<?php
/* add_ons_php */

//$azp_attrs,$azp_content,$azp_element
$azp_mID = $el_id = $el_class = $num_feature = ''; 

// var_dump($azp_attrs);
extract($azp_attrs);

$classes = array(
	'azp_element',
    'rcard_room',
    'azp-element-' . $azp_mID,
    $el_class,
);
// $animation_data = self::buildAnimation($azp_attrs);
// $classes[] = $animation_data['trigger'];
// $classes[] = self::buildTypography($azp_attrs);//will return custom class for the element without dot
// $azplgallerystyle = self::buildStyle($azp_attrs);

$classes = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $classes ) ) );

if($el_id != ''){
    $el_id = 'id="'.$el_id.'"';
}
$price = get_post_meta( get_the_ID(), '_price', true );
$adults = get_post_meta( get_the_ID(), ESB_META_PREFIX.'adults', true );
$children = get_post_meta( get_the_ID(), ESB_META_PREFIX.'children', true );
$max_guests = intval($adults) + intval($children);
?>
<div class="<?php echo $classes; ?>" <?php echo $el_id;?>>
    <div class="lrooms-item fl-wrap dis-flex">
        <?php if(has_post_thumbnail()): ?>
        <div class="lrooms-media">
            <?php the_post_thumbnail(); ?>
            <?php 
            $photos = get_post_meta( get_the_ID(), ESB_META_PREFIX.'images', true );
            if( !is_array($photos) ){
                $photos = explode(",", $photos);
            }
            if (!empty($photos) ):   
                $photos_gal = array();
                foreach ($photos as $iid) {
                    $photos_gal[] = array('src'=> wp_get_attachment_url( $iid ));
                }
            ?>
            <div class="dynamic-gal more-photos-button color-bg" data-dynamicPath='<?php echo json_encode($photos_gal);?>'><i class="fas fa-camera"></i> <span><?php echo sprintf(_x( '%d photos', 'Room card', 'homeradar-add-ons' ), count($photos) ); ?></span>  </div>
            <?php endif; ?>
        </div>
        <?php endif; ?>
        <div class="lrooms-details">
            <div class="lrooms-details-header fl-wrap">
                <?php if( !empty($price) ): ?><span class="lrooms-area"><?php echo sprintf(__( '%s <strong>/ night</strong>', 'homeradar-add-ons' ), homeradar_addons_get_price_formated($price) ) ?></span><?php endif; ?>
                <h3><?php the_title(); ?></h3>
                <?php if( !empty($max_guests) ): ?><h5><?php echo sprintf(__( 'Max Guests: <span>%d persons</span>', 'homeradar-add-ons' ), $max_guests); ?></h5><?php endif; ?>
            </div>
            <?php 
            // the_excerpt();
            homeradar_addons_the_excerpt_max_charlength(homeradar_addons_get_option('excerpt_length','55'));
            ?>
            <?php 
                $features = get_the_terms(get_the_ID(), 'listing_feature');
                if ( $features && ! is_wp_error( $features ) ){ 
                    $feature_group = array();
                    foreach( $features as $key => $term){
                        if(homeradar_addons_get_option('feature_parent_group') == 'yes'){ 
                            if($term->parent){
                                if( !isset($feature_group[$term->parent]) || !is_array($feature_group[$term->parent]) ) $feature_group[$term->parent] = array();
                                $feature_group[$term->parent][$term->term_id] = $term->name;
                            }else{
                                if(!isset($feature_group[$term->term_id])) $feature_group[$term->term_id] = $term->name;
                            }
                        }else{
                            if(!isset($feature_group[$term->term_id])) $feature_group[$term->term_id] = $term->name;
                        }
                            
                    }
                ?>
                <div class="facilities-list fl-wrap">
                    <ul class="facilities-list-ul">
                        <?php
                        $count = 1;
                        foreach( $feature_group as $tid => $tvalue){
                            // var_dump($tvalue);
                            if($count <= (int)$num_feature){
                                if( is_array( $tvalue ) && count( $tvalue ) ){
                                    $term = get_term_by( 'id', $tid , 'listing_feature' );
                                    if($term){
                                        $term_meta = get_term_meta( $term->term_id, ESB_META_PREFIX.'term_meta', true );

                                        echo sprintf( '<li class="fea-has-children">%1$s<ul class="fea-children">',
                                            isset($term_meta['icon_class'])? '<i class="'.$term_meta['icon_class'].'"></i>' . esc_html( $term->name ) : esc_html( $term->name )
                                        );

                                        foreach ($tvalue as $id => $name) {
                                            $term_meta = get_term_meta( $id, ESB_META_PREFIX.'term_meta', true );

                                            echo sprintf( '<li class="tolt" data-microtip-position="top"  data-tooltip="%2$s">%1$s</li>',
                                                isset($term_meta['icon_class']) ? '<i class="'.$term_meta['icon_class'].'"></i>' : '<span class="fea-nicon">' . esc_html( $name ).'</span>', 
                                                esc_html( $name )
                                            );
                                        }

                                        echo '</ul></li>';
                                    }
                                    
                                }else{
                                    $term_meta = get_term_meta( $tid, ESB_META_PREFIX.'term_meta', true );
                                    echo sprintf( '<li class="tolt" data-microtip-position="top"  data-tooltip="%2$s">%1$s</li>',
                                        isset($term_meta['icon_class']) ? '<i class="'.$term_meta['icon_class'].'"></i>' : '<span class="fea-nicon">' . esc_html( $tvalue ).'</span>', 
                                        esc_html( $tvalue )
                                    );
                                }
                            }  
                            $count++;                 
                        }
                    ?>
                    </ul>
                    
                </div>
                <?php } ?>
                
        </div>
    </div>
</div>