<?php
/* add_ons_php */

//$azp_attrs,$azp_content,$azp_element
$azp_mID = $el_id = $el_class = $hide_status = $hide_bookmark = $hide_overlay = $hide_author = $hide_rating = $hide_saleoff = $hide_featured = $show_logo = '';
$hide_address = $disable_address_url = $hide_cats = '';
// var_dump($azp_attrs);
extract($azp_attrs);

$classes = array(
    'azp_element',
    'preview_listing',
    'azp-element-' . $azp_mID,
    'geodir-category-img',
    $el_class,
);
// $animation_data = self::buildAnimation($azp_attrs);
// $classes[] = $animation_data['trigger'];
// $classes[] = self::buildTypography($azp_attrs);//will return custom class for the element without dot
// $azplgallerystyle = self::buildStyle($azp_attrs);

$classes = preg_replace('/\s+/', ' ', implode(' ', array_filter($classes)));

if ($el_id != '') {
    $el_id = 'id="' . $el_id . '"';
}
if( $hide_overlay == 'yes' ) $classes .= ' card-hide-overlay';
// if (has_post_thumbnail()) {

$latitude = get_post_meta( get_the_ID(), ESB_META_PREFIX.'latitude', true );
$longitude = get_post_meta( get_the_ID(), ESB_META_PREFIX.'longitude', true );
$address_url = '#';
if( $disable_address_url != 'yes' && !empty($latitude) && !empty($longitude) ) $address_url = 'https://www.google.com/maps/search/?api=1&query='.esc_attr($latitude).','.esc_attr($longitude);

?>
<div class="<?php echo $classes; ?>" <?php echo $el_id; ?>>
    <a href="<?php the_permalink();?>" class="listing-thumb-link geodir-category-img_item">
        
        <?php 
        echo wp_get_attachment_image( homeradar_addons_get_listing_thumbnail( get_the_ID() ) , 'homeradar-listing-grid', false, array('class'=>'respimg') );
        ?>

        <?php if( $hide_overlay != 'yes' ): ?><div class="overlay"></div><?php endif; ?>
    </a>

    <div class="geodir-category-location">
        <a href="<?php echo $address_url; ?>" class="single-map-item tolt" data-microtip-position="top-left" data-tooltip="<?php esc_attr_e( 'On the map', 'homeradar-add-ons' ); ?>">
            <i class="fas fa-map-marker-alt"></i>
            <span><?php 
                echo homeradar_addons_listing_get_address();
            ?></span></a>                                              
    </div>

    <?php if( $hide_featured != 'yes' && get_post_meta( get_the_ID(), ESB_META_PREFIX.'featured', true ) == '1' ) : ?>
        <div class="listing-featured"><?php _e( 'Featured', 'homeradar-add-ons' ); ?></div>
    <?php endif;?>

    <?php 
    if( $hide_cats != 'yes'){
    ?>
        <div class="list-single-opt_header_cat dis-flex-wrap">
            <?php
            $statuses = get_the_terms(get_the_ID(), 'listing_status'); 
            if ( $statuses && ! is_wp_error( $statuses ) ){
                foreach( $statuses as $key => $tax){
                    $term_metas = homeradar_addons_custom_tax_metas($tax->term_id); 
                    echo sprintf( '<a href="%1$s" class="cat-opt status-opt flex-items-center">%2$s</a> ',
                        homeradar_addons_get_term_link( $tax->term_id, 'listing_status' ),
                        esc_html( $tax->name )
                    );
                }
            }
            ?>
            <?php
            $cats = get_the_terms(get_the_ID(), 'listing_cat'); 
            if ( $cats && ! is_wp_error( $cats ) ){
                foreach( $cats as $key => $cat){
                    $term_metas = homeradar_addons_custom_tax_metas($cat->term_id); 
                    // echo sprintf( '<a href="%1$s" class="cat-opt flex-items-center %2$s">%4$s<span>%3$s</span></a> ',
                    echo sprintf( '<a href="%1$s" class="cat-opt flex-items-center">%3$s</a> ',
                        homeradar_addons_get_term_link( $cat->term_id, 'listing_cat' ),
                        $term_metas['color'],
                        esc_html( $cat->name ),
                        ($term_metas['icon'] != '' ? '<i class="'.$term_metas['icon'].'"></i>' : ''),
                        $term_metas['color']
                    );
                }
            }
            ?>
        </div>
    <?php } ?>


    <?php if( $hide_bookmark != 'yes' ): ?>
    
        <?php if(!is_user_logged_in()): 
            $logBtnAttrs = homeradar_addons_get_login_button_attrs( 'savelist', 'current' );
        ?>
            <a href="<?php echo esc_url( $logBtnAttrs['url'] );?>" class="geodir_save-btn tolt <?php echo esc_attr( $logBtnAttrs['class'] );?>" data-message="<?php esc_attr_e( 'Logging in first to save this listing.', 'homeradar-add-ons' ); ?>" data-microtip-position="left" data-tooltip="<?php echo esc_attr_x( 'Login', 'Listing card', 'homeradar-add-ons' ); ?>"><span><i class="fal fa-heart"></i></span></a>
        <?php elseif( homeradar_addons_already_bookmarked(get_the_ID()) ): ?>
            <a href="javascript:void(0);" class="geodir_save-btn tolt" data-id="<?php the_ID(); ?>" data-microtip-position="left" data-tooltip="<?php echo esc_attr_x( 'Saved', 'Listing card', 'homeradar-add-ons' ); ?>"><span><i class="fas fa-heart"></i></span></a>
        <?php else: ?>
            <a href="#" class="geodir_save-btn tolt bookmark-listing-btn" data-id="<?php the_ID(); ?>" data-map="1" data-microtip-position="left" data-tooltip="<?php echo esc_attr_x( 'Save', 'Listing card', 'homeradar-add-ons' ); ?>"><span><i class="fal fa-heart"></i></span></a>
        <?php endif; ?>

    <?php endif; ?>
    <?php 
    $compareTxt = esc_attr_x( 'Compare', 'Listing card', 'homeradar-add-ons' );
    $comparedTxt = esc_attr_x( 'Added to Compare', 'Listing card', 'homeradar-add-ons' );
    $cpadded = Esb_Class_Compare::is_added( get_the_ID() );
    ?>
    <a href="#" class="compare-btn tolt compare-btn-<?php echo get_the_ID(); ?><?php if($cpadded) echo ' added-to-compare';?>" 
    data-microtip-position="left" data-tooltip="<?php echo $cpadded ? $comparedTxt : $compareTxt; ?>" 
    data-text1="<?php echo $compareTxt; ?>" data-text2="<?php echo $comparedTxt; ?>"
    data-lid="<?php echo get_the_ID(); ?>" data-ltitle="<?php echo esc_attr(get_the_title( get_the_ID() )); ?>" 
    data-lthumb="<?php echo wp_get_attachment_image_url( homeradar_addons_get_listing_thumbnail( get_the_ID() ), 'thumbnail' ); ?>"
    data-lprice="<?php echo homeradar_addons_get_price_string(get_post_meta( get_the_ID(), '_price', true )); ?>"
    data-laddress="<?php echo homeradar_addons_listing_get_address(); ?>"
    ><span><i class="fal fa-random"></i></span></a>
    <?php 
    $images = get_post_meta( get_the_ID(), ESB_META_PREFIX.'images', true );
    if( !empty($images) && !is_array($images) ) $images = explode(",", $images);
    if( !empty($images) ): ?>
    <div class="geodir-category-listing_media-list">
        <span><i class="fas fa-camera"></i> <?php echo count($images); ?></span>
    </div>
    <?php endif; ?>


    
        

    
    

    <?php 
    if( $hide_saleoff != 'yes' ):
    $saleoff = get_post_meta( get_the_ID(), ESB_META_PREFIX.'sale_off', true );
    if( !empty($saleoff) ): ?>
        <div class="lcard-saleoff">
            <div class="saleoff-inner"><?php echo sprintf( esc_html__( "Sale %s%%", 'homeradar-add-ons' ) , $saleoff ); ?></div>
        </div>
    <?php endif;
    endif; ?> 

    
    
    <?php // homeradar_addons_get_template_part( 'templates-inner/status', '', array( 'hide_status'=> $hide_status ) ); ?>
    
    <?php do_action( 'cth_listing_card_thumbnail' ); ?>
    <div class="lcfields-wrap lcfields-abs dis-flex-wrap"><?php echo wp_kses_post( $azp_content ); ?></div>
    
</div>
<?php // }
