<?php
/* add_ons_php */
azp_add_element(
    'price_range',
    array(
        'name'                    => __('Price Range', 'homeradar-add-ons'),
        // 'desc'                  => __('Custom element for adding third party shortcode','homeradar-add-ons'),
        'category'                => __("Widget", 'homeradar-add-ons'),
        'icon'                    => ESB_DIR_URL . 'assets/azp-eles-icon/cththemes-logo.png',
        'open_settings_on_create' => true,
        'showStyleTab'            => true,
        'showTypographyTab'       => true,
        'showAnimationTab'        => true,
        'template_folder'         => 'widget/',
        'attrs'                   => array(
            array(
                'type'          => 'text',
                'param_name'    => 'title',
                'show_in_admin' => true,
                'label'         => __('Title', 'homeradar-add-ons'),
                'default'       => 'Price Range',
            ),
            array(
                'type'        => 'checkbox',
                'param_name'  => 'hide_widget_on',
                // 'show_in_admin'         => true,
                'label'       => __('Hide this widget on', 'homeradar-add-ons'),
                'desc'        => __('Hide on logout user or based author plan?', 'homeradar-add-ons'),
                'default'     => '',
                'value'       => homeradar_addons_loggedin_plans_options(),
                'multiple'    => true,
                'show_toggle' => true,
            ),
            array(
                'type'          => 'switch',
                'param_name'    => 'hide_claim',
                'show_in_admin' => true,
                'label'         => __('Hide claim listing', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'yes',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),
            // array(
            //     'type'          => 'switch',
            //     'param_name'    => 'hide_claimed',
            //     'show_in_admin' => true,
            //     'label'         => __('Hide Claim on Claimed Listing?', 'homeradar-add-ons'),
            //     'desc'          => __( 'Hide Claim Listing on price range widget for already claimed listing', 'homeradar-add-ons' ),
            //     'default'       => 'yes',
            //     'value'         => array(
            //         'yes' => __('Yes', 'homeradar-add-ons'),
            //         'no'  => __('No', 'homeradar-add-ons'),
            //     ),
            // ),
            array(
                'type'       => 'text',
                'param_name' => 'el_id',
                'label'      => __('Element ID', 'homeradar-add-ons'),
                // 'desc'                  => '',
                'default'    => '',
            ),

            array(
                'type'       => 'text',
                'param_name' => 'el_class',
                'label'      => __('Extra Class', 'homeradar-add-ons'),
                'desc'       => __("Use this field to add a class name and then refer to it in your CSS.", 'homeradar-add-ons'),
                'default'    => '',
            ),

        ),
    )
);
