<?php
/* add_ons_php */
azp_add_element(
    'lsimilar',
    array(
        'name'                    => __('Similar Listings', 'homeradar-add-ons'),
        // 'desc'                  => __('Custom element for adding third party shortcode','homeradar-add-ons'),
        'category'                => __("Widget", 'homeradar-add-ons'),
        'icon'                    => ESB_DIR_URL . 'assets/azp-eles-icon/cththemes-logo.png',
        'open_settings_on_create' => true,
        'showStyleTab'            => true,
        'showTypographyTab'       => true,
        'showAnimationTab'        => true,
        'template_folder'         => 'widget/',
        'attrs'                   => array(
            array(
                'type'          => 'text',
                'param_name'    => 'title',
                'show_in_admin' => true,
                'label'         => __('Title', 'homeradar-add-ons'),
                'default'       => 'Similar Listings',
            ),

            array(
                'type'          => 'select',
                'param_name'    => 'taxonomy',
                'show_in_admin' => true,
                'label'         => __('Listings related', 'homeradar-add-ons'),
                // 'desc'                  => 'Select Ascending or Descending order.',
                'default'       => 'listing_tag',
                'value'         => array(
                    'listing_cat'      => __('Same Categories', 'homeradar-add-ons'),
                    'listing_location' => __('Same Locations', 'homeradar-add-ons'),
                    'listing_feature'  => __('Same Features', 'homeradar-add-ons'),
                    'listing_tag'      => __('Same Tags', 'homeradar-add-ons'),
                    'featured'          => _x('Featured only', 'Listing type', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'          => 'text',
                'param_name'    => 'posts_per_page',
                'show_in_admin' => true,
                'label'         => __('Listings to show', 'homeradar-add-ons'),
                'desc'          => __("Number of listings to show (-1 for all).", 'homeradar-add-ons'),
                'default'       => '4',
            ),
            array(
                'type'          => 'select',
                'param_name'    => 'order_by',
                'show_in_admin' => true,
                'label'         => __('Order by', 'homeradar-add-ons'),
                // 'desc'                  => 'Select how to sort retrieved posts.',
                'default'       => 'date',
                'value'         => array(
                    'date'          => __('Date', 'homeradar-add-ons'),
                    'ID'            => __('ID', 'homeradar-add-ons'),
                    'author'        => __('Author', 'homeradar-add-ons'),
                    'title'         => __('Title', 'homeradar-add-ons'),
                    'modified'      => __('Modified', 'homeradar-add-ons'),
                    'rand'          => __('Random', 'homeradar-add-ons'),
                    'comment_count' => __('Comment Count', 'homeradar-add-ons'),
                    'menu_order'    => __('Menu Order', 'homeradar-add-ons'),
                    // 'post__in'      => __('ID order given (post__in)', 'homeradar-add-ons')
                ),
            ),
            array(
                'type'          => 'select',
                'param_name'    => 'order',
                'show_in_admin' => true,
                'label'         => __('Sort Order', 'homeradar-add-ons'),
                // 'desc'                  => 'Select Ascending or Descending order.',
                'default'       => 'DESC',
                'value'         => array(
                    'ASC'  => __('Ascending', 'homeradar-add-ons'),
                    'DESC' => __('Descending', 'homeradar-add-ons'),
                ),
            ),

            // array(
            //     "type"       => "text",
            //     "label"      => esc_html__("Responsive", 'homeradar-add-ons'),
            //     "param_name" => "responsive",
            //     "desc"       => esc_html__("The format is: screen-size:number-items-display,larger-screen-size:number-items-display. Ex: 528:1,800:2,1224:3,1500:4", 'homeradar-add-ons'),
            //     "default"    => "528:1,800:2,1224:2,1500:2",
            // ),
            array(
                'type'        => 'checkbox',
                'param_name'  => 'hide_widget_on',
                'label'       => _x('Hide this widget on', 'Listing type', 'homeradar-add-ons'),
                'desc'        => _x('Hide on logout user or based author plan?', 'Listing type', 'homeradar-add-ons'),
                'default'     => '',
                'value'       => homeradar_addons_loggedin_plans_options(),
                'multiple'    => true,
                'show_toggle' => true,
            ),
            array(
                'type'          => 'switch',
                'param_name'    => 'show_cats',
                'show_in_admin' => true,
                'label'         => __('Show Categories', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'no',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),
            array(
                'type'          => 'switch',
                'param_name'    => 'show_price',
                'show_in_admin' => true,
                'label'         => __('Show Price', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'yes',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),
            array(
                'type'          => 'switch',
                'param_name'    => 'show_vall',
                'show_in_admin' => true,
                'label'         => __('Show View all', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'yes',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),
            array(
                'type'       => 'text',
                'param_name' => 'vall_text',
                'label'      => __('View all text', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => 'View All Properties',
            ),
            
            array(
                'type'       => 'text',
                'param_name' => 'el_id',
                'label'      => __('Element ID', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => '',
            ),

            array(
                'type'       => 'text',
                'param_name' => 'el_class',
                'label'      => __('Extra Class', 'homeradar-add-ons'),
                'desc'       => __("Use this field to add a class name and then refer to it in your CSS.", 'homeradar-add-ons'),
                'default'    => '',
            ),

        ),
    )
);
