<?php
/* add_ons_php */
azp_add_element(
    'getintouch',
    array(
        'name'                    => __('Contact Form', 'homeradar-add-ons'),
        // 'desc'                  => __('Custom element for adding third party shortcode','homeradar-add-ons'),
        'category'                => "Widget",
        'icon'                    => ESB_DIR_URL . 'assets/azp-eles-icon/cththemes-logo.png',
        'open_settings_on_create' => true,
        'showStyleTab'            => true,
        'showTypographyTab'       => true,
        'showAnimationTab'        => true,
        'template_folder'         => 'widget/',
        'attrs'                   => array(
            array(
                'type'          => 'text',
                'param_name'    => 'title',
                'show_in_admin' => true,
                'label'         => __('Title', 'homeradar-add-ons'),
                'default'       => 'Contact Property',
            ),
            array(
                'type'        => 'checkbox',
                'param_name'  => 'hide_widget_on',
                'label'       => __('Hide this widget on', 'homeradar-add-ons'),
                'desc'        => __('Hide on logout user or based author plan?', 'homeradar-add-ons'),
                'default'     => '',
                'value'       => homeradar_addons_loggedin_plans_options(),
                'multiple'    => true,
                'show_toggle' => true,
            ),

            array(
                'type'          => 'select',
                'param_name'    => 'dformat',
                'show_in_admin' => true,
                'label'         => __('Date Format', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'MM/DD/YYYY',
                'value'         => array(
                    'DD-MM-YYYY' => __('28-02-2019', 'homeradar-add-ons'),
                    'DD/MM/YYYY' => __('28/02/2019', 'homeradar-add-ons'),

                    'MM-DD-YYYY' => __('02-28-2019', 'homeradar-add-ons'),
                    'MM/DD/YYYY' => __('02/28/2019', 'homeradar-add-ons'),

                    'YYYY-MM-DD' => __('2019-02-28', 'homeradar-add-ons'),
                    'YYYY/MM/DD' => __('2019/02/28', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'          => 'switch',
                'param_name'    => 'hide_phone',
                'show_in_admin' => true,
                'label'         => _x('Hide phone field?', 'Listing type', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'yes',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),
            array(
                'type'          => 'switch',
                'param_name'    => 'hide_message',
                'show_in_admin' => true,
                'label'         => _x('Hide message field?', 'Listing type', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'yes',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),
            
            array(
                'type'       => 'text',
                'param_name' => 'el_id',
                'label'      => __('Element ID', 'homeradar-add-ons'),
                'default'    => '',
            ),

            array(
                'type'       => 'text',
                'param_name' => 'el_class',
                'label'      => __('Extra Class', 'homeradar-add-ons'),
                'desc'       => __("Use this field to add a class name and then refer to it in your CSS.", 'homeradar-add-ons'),
                'default'    => '',
            ),

        ),
    )
);
