<?php
/* add_ons_php */
azp_add_element(
    'event_dates',
    array(
        'name'                    => __('Event Dates (NEW)', 'homeradar-add-ons'),
        'category'                => 'Widget',
        'icon'                    => ESB_DIR_URL . 'assets/azp-eles-icon/cththemes-logo.png',
        'open_settings_on_create' => true,
        'showStyleTab'            => true,
        'showTypographyTab'       => true,
        'showAnimationTab'        => true,
        'template_folder'         => 'widget/',
        'attrs'                   => array(
            array(
                'type'                  => 'text',
                'param_name'            => 'title',
                'label'                 => __('Widget Title','homeradar-add-ons'),
                // 'desc'                  => '',
                'default'               => 'Event Dates'
            ),
            array(
                'type'                  => 'text',
                'param_name'            => 'dates_to_show',
                'label'                 => __('Number of first dates to show?','homeradar-add-ons'),
                // 'desc'                  => '',
                'default'               => '3'
            ),
            array(
                'type'                  => 'switch',
                'param_name'            => 'show_end',
                'show_in_admin'         => true,
                'label'                 => __('Show end date','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => 'yes',
                'value'                 => array(   
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                 ),
            ),
            array(
                'type'                  => 'checkbox',
                'param_name'            => 'hide_widget_on',
                'label'                 => _x('Hide this widget on', 'Listing type', 'homeradar-add-ons'),
                'desc'                  => _x('Hide on logout user or based author plan?', 'Listing type', 'homeradar-add-ons'),
                'default'               => '',
                'value'                 => homeradar_addons_loggedin_plans_options(),
                'multiple'              => true,
                'show_toggle'           => true,
            ),
            array(
                'type'                  => 'text',
                'param_name'            => 'el_id',
                'label'                 => __('Element ID','homeradar-add-ons'),
                // 'desc'                  => '',
                'default'               => ''
            ),
            
            array(
                'type'                  => 'text',
                'param_name'            => 'el_class',
                'label'                 => __('Extra Class','homeradar-add-ons'),
                'desc'                  => __("Use this field to add a class name and then refer to it in your CSS." ,'homeradar-add-ons'),
                'default'               => ''
            ),

        ),
    )
);
