<?php
/* add_ons_php */
azp_add_element(
    'cal_mortgage',
    array(
        'name'                    => __('Mortgage Calculator', 'homeradar-add-ons'),
        'category'                => 'Widget',
        'icon'                    => ESB_DIR_URL . 'assets/azp-eles-icon/cththemes-logo.png',
        'open_settings_on_create' => true,
        'showStyleTab'            => true,
        'showTypographyTab'       => true,
        'showAnimationTab'        => true,
        'template_folder'         => 'widget/',
        'attrs'                   => array(
            array(
                'type'          => 'text',
                'param_name'    => 'title',
                'show_in_admin' => true,
                'label'         => __('Title', 'homeradar-add-ons'),
                'default'       => 'Calculate Your Mortgage',
            ),
            array(
                'type'          => 'textarea',
                'param_name'    => 'desc',
                'show_in_admin' => true,
                'label'         => __('Description', 'homeradar-add-ons'),
                'default'       => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc posuere convallis purus non cursus. ',
            ),
            
            array(
                'type'                  => 'checkbox',
                'param_name'            => 'hide_widget_on',
                'label'                 => _x('Hide this widget on', 'Listing type', 'homeradar-add-ons'),
                'desc'                  => _x('Hide on logout user or based author plan?', 'Listing type', 'homeradar-add-ons'),
                'default'               => '',
                'value'                 => homeradar_addons_loggedin_plans_options(),
                'multiple'              => true,
                'show_toggle'           => true,
            ),
            array(
                'type'       => 'text',
                'param_name' => 'el_id',
                'label'      => __('Element ID', 'homeradar-add-ons'),
                'default'    => '',
            ),

            array(
                'type'       => 'text',
                'param_name' => 'el_class',
                'label'      => __('Extra Class', 'homeradar-add-ons'),
                'desc'       => __("Use this field to add a class name and then refer to it in your CSS.", 'homeradar-add-ons'),
                'default'    => '',
            ),

        ),
    )
);
