<?php
/* add_ons_php */
azp_add_element(
    'lslider',
    array(
        'name'                    => __('Photos Slider', 'homeradar-add-ons'),
        // 'desc'                  => __('Custom element for adding third party shortcode','homeradar-add-ons'),
        'category'                => __("Listing", 'homeradar-add-ons'),
        'icon'                    => ESB_DIR_URL . 'assets/azp-eles-icon/cththemes-logo.png',
        'open_settings_on_create' => true,
        'showStyleTab'            => true,
        'showTypographyTab'       => true,
        'showAnimationTab'        => true,
        'template_folder'         => 'single/',
        'attrs'                   => array(
            array(
                'type'          => 'text',
                'param_name'    => 'title',
                'show_in_admin' => true,
                'label'         => __('Title', 'homeradar-add-ons'),
                'default'       => '',
            ),
            array(
                'type'          => 'select',
                'param_name'    => 'images_size',
                'show_in_admin' => true,
                'label'         => _x('Images Size', 'Listing Type', 'homeradar-add-ons'),
                'default'       => 'full',
                'value'         => array(
                    'full'                  => _x('Full Size', 'Listing Type', 'homeradar-add-ons'),
                    'large'                 => _x('Large size, maximum 1024px', 'Listing Type', 'homeradar-add-ons'),
                    'medium'                => _x('Medium size, maximum 300px', 'Listing Type', 'homeradar-add-ons'),
                    'homeradar-lgal'          => _x('Listing gallery size', 'Listing Type', 'homeradar-add-ons'),
                    
                ),
            ),
            array(
                'type'                  => 'checkbox',
                'param_name'            => 'hide_widget_on',
                'label'                 => _x('Hide this widget on', 'Listing type', 'homeradar-add-ons'),
                'desc'                  => _x('Hide on logout user or based author plan?', 'Listing type', 'homeradar-add-ons'),
                'default'               => '',
                'value'                 => homeradar_addons_loggedin_plans_options(),
                'multiple'              => true,
                'show_toggle'           => true,
            ),
            array(
                'type'       => 'text',
                'param_name' => 'el_id',
                'label'      => __('Element ID', 'homeradar-add-ons'),
                // 'desc'                  => '',
                'default'    => '',
            ),

            array(
                'type'       => 'text',
                'param_name' => 'el_class',
                'label'      => __('Extra Class', 'homeradar-add-ons'),
                'desc'       => __("Use this field to add a class name and then refer to it in your CSS.", 'homeradar-add-ons'),
                'default'    => '',
            ),

        ),
    )
);
