<?php
/* add_ons_php */
azp_add_element(
    'lproducts',
    array(
        'name'                    => __('WooCommerce Products', 'homeradar-add-ons'),
        // 'desc'                  => __('Custom element for adding third party shortcode','homeradar-add-ons'),
        'category'                => __("Listing", 'homeradar-add-ons'),
        'icon'                    => ESB_DIR_URL . 'assets/azp-eles-icon/cththemes-logo.png',
        'open_settings_on_create' => true,
        'showStyleTab'            => true,
        'showTypographyTab'       => true,
        'showAnimationTab'        => true,
        'template_folder'         => 'single/',
        'attrs'                   => array(
            array(
                'type'          => 'text',
                'param_name'    => 'title',
                'show_in_admin' => true,
                'label'         => __('Title', 'homeradar-add-ons'),
                'default'       => 'Products',
            ),
            array(
                'type'          => 'select',
                'param_name'    => 'order_by',
                'show_in_admin' => true,
                'label'         => __('Order by', 'homeradar-add-ons'),
                'desc'          => 'Select how to sort retrieved posts.',
                'default'       => 'date',
                'value'         => array(
                    'date'     => __('Date', 'homeradar-add-ons'),
                    'ID'       => __('ID', 'homeradar-add-ons'),
                    'author'   => __('Author', 'homeradar-add-ons'),
                    'title'    => __('Title', 'homeradar-add-ons'),
                    'modified' => __('Modified', 'homeradar-add-ons'),
                    'rand'     => __('Random', 'homeradar-add-ons'),
                    // 'comment_count' => __('Comment Count', 'homeradar-add-ons'),
                    // 'menu_order'    => __('Menu Order', 'homeradar-add-ons'),
                    // 'post__in'      => __('ID order given (post__in)', 'homeradar-add-ons')
                ),
            ),
            array(
                'type'          => 'select',
                'param_name'    => 'order',
                'show_in_admin' => true,
                'label'         => __('Sort Order', 'homeradar-add-ons'),
                'desc'          => 'Select Ascending or Descending order.',
                'default'       => 'DESC',
                'value'         => array(
                    'ASC'  => __('Ascending', 'homeradar-add-ons'),
                    'DESC' => __('Descending', 'homeradar-add-ons'),
                ),
            ),
            array(
                'type'                  => 'checkbox',
                'param_name'            => 'hide_widget_on',
                'label'                 => _x('Hide this widget on', 'Listing type', 'homeradar-add-ons'),
                'desc'                  => _x('Hide on logout user or based author plan?', 'Listing type', 'homeradar-add-ons'),
                'default'               => '',
                'value'                 => homeradar_addons_loggedin_plans_options(),
                'multiple'              => true,
                'show_toggle'           => true,
            ),
            array(
                'type'       => 'text',
                'param_name' => 'el_id',
                'label'      => __('Element ID', 'homeradar-add-ons'),
                // 'desc'                  => '',
                'default'    => '',
            ),
            array(
                'type'       => 'text',
                'param_name' => 'el_class',
                'label'      => __('Extra Class', 'homeradar-add-ons'),
                'desc'       => __("Use this field to add a class name and then refer to it in your CSS.", 'homeradar-add-ons'),
                'default'    => '',
            ),

        ),
    )
);
