<?php
/* add_ons_php */
azp_add_element(
    'lmembers',
    array(
        'name'                    => __('Trainers/Speakers', 'homeradar-add-ons'),
        // 'desc'                  => __('Custom element for adding third party shortcode','homeradar-add-ons'),
        'category'                => __("Listing", 'homeradar-add-ons'),
        'icon'                    => ESB_DIR_URL . 'assets/azp-eles-icon/cththemes-logo.png',
        'open_settings_on_create' => true,
        'showStyleTab'            => true,
        'showTypographyTab'       => true,
        'showAnimationTab'        => true,
        'template_folder'         => 'single/',
        'attrs'                   => array(
            array(
                'type'          => 'text',
                'param_name'    => 'title',
                'show_in_admin' => true,
                'label'         => __('Title', 'homeradar-add-ons'),
                'default'       => 'Event Speakers',
            ),

            

            array(
                'type'          => 'select',
                'param_name'    => 'cols',
                'show_in_admin' => true,
                'label'         => __('Columns Grid', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'three',
                'value'         => array(
                    'one'   => esc_html__('One Column', 'homeradar-add-ons'),
                    'two'   => esc_html__('Two Columns', 'homeradar-add-ons'),
                    'three' => esc_html__('Three Columns', 'homeradar-add-ons'),
                    'four'  => esc_html__('Four Columns', 'homeradar-add-ons'),
                    'five'  => esc_html__('Five Columns', 'homeradar-add-ons'),
                    'six'   => esc_html__('Six Columns', 'homeradar-add-ons'),
                    'seven' => esc_html__('Seven Columns', 'homeradar-add-ons'),
                    'eight' => esc_html__('Eight Columns', 'homeradar-add-ons'),
                    'nine'  => esc_html__('Nine Columns', 'homeradar-add-ons'),
                    'ten'   => esc_html__('Ten Columns', 'homeradar-add-ons'),
                ),
            ),
            array(
                'type'          => 'select',
                'param_name'    => 'space',
                'show_in_admin' => true,
                'label'         => __('Space', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'small',
                'value'         => array(
                    'xxbig'      => esc_html__('Extra Big', 'homeradar-add-ons'),
                    'xbig'       => esc_html__('Bigger', 'homeradar-add-ons'),
                    'big'        => esc_html__('Big', 'homeradar-add-ons'),
                    'medium'     => esc_html__('Medium', 'homeradar-add-ons'),
                    'small'      => esc_html__('Small', 'homeradar-add-ons'),
                    'extrasmall' => esc_html__('Extra Small', 'homeradar-add-ons'),
                    'no'         => esc_html__('None', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'        => 'checkbox',
                'param_name'  => 'hide_widget_on',
                'label'       => _x('Hide this widget on', 'Listing type', 'homeradar-add-ons'),
                'desc'        => _x('Hide on logout user or based author plan?', 'Listing type', 'homeradar-add-ons'),
                'default'     => '',
                'value'       => homeradar_addons_loggedin_plans_options(),
                'multiple'    => true,
                'show_toggle' => true,
            ),
            array(
                'type'       => 'text',
                'param_name' => 'el_id',
                'label'      => __('Element ID', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => '',
            ),

            array(
                'type'       => 'text',
                'param_name' => 'el_class',
                'label'      => __('Extra Class', 'homeradar-add-ons'),
                'desc'       => __("Use this field to add a class name and then refer to it in your CSS.", 'homeradar-add-ons'),
                'default'    => '',
            ),

        ),
    )
);
