<?php
/* add_ons_php */
azp_add_element(
    'lcus_field',
    array(
        'name'                    => __('Custom Field', 'homeradar-add-ons'),
        // 'desc'                  => __('Custom element for adding third party shortcode','homeradar-add-ons'),
        'category'                => __("Custom", 'homeradar-add-ons'),
        'icon'                    => ESB_DIR_URL . 'assets/azp-eles-icon/cththemes-logo.png',
        'open_settings_on_create' => true,
        'showStyleTab'            => true,
        'showTypographyTab'       => true,
        'showAnimationTab'        => true,
        'template_folder'         => 'single/',
        'attrs'                   => array(
            array(
                'type'          => 'text',
                'param_name'    => 'title',
                'show_in_admin' => true,
                'label'         => __('Title', 'homeradar-add-ons'),
                'default'       => 'Title',
            ),
            array(
                'type'          => 'selectcfield',
                'param_name'    => 'name',
                'show_in_admin' => true,
                'label'         => __('Field name', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => '',
                'value'         => array(),
            ),
            array(
                'type'          => 'switch',
                'param_name'    => 'show_opt_lbl',
                'show_in_admin' => true,
                'label'         => __('Display option label for Select/Radio/Checkbox field', 'homeradar-add-ons'),
                // 'desc'                  => '',
                'default'       => 'yes',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'          => 'select',
                'param_name'    => 'ftype',
                'show_in_admin' => true,
                'label'         => _x('Field Type', 'Listing Type', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'dflt',
                'value'         => array(
                    'dflt'          => _x('Default field', 'Listing Type', 'homeradar-add-ons'),
                    'image'         => _x('Image field', 'Listing Type', 'homeradar-add-ons'),
                    'oembed'        => _x('Auto embed video', 'Listing Type', 'homeradar-add-ons'),
                    'link'          => _x('Link field', 'Listing Type', 'homeradar-add-ons'),
                    'file'          => _x('File url', 'Listing Type', 'homeradar-add-ons'),
                    'raw_text'      => _x('HTML Code', 'Listing Type', 'homeradar-add-ons'),
                    'dlfile'        => _x('View file button', 'Listing Type', 'homeradar-add-ons'),
                    'date'          => _x('Date', 'Listing Type', 'homeradar-add-ons'),
                    'datetime'      => _x('Date time', 'Listing Type', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'          => 'switch',
                'param_name'    => 'title_block',
                'show_in_admin' => true,
                'label'         => __('Separate title and value into two lines', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'no',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'          => 'select',
                'param_name'    => 'width',
                'show_in_admin' => true,
                'label'         => __('Width', 'homeradar-add-ons'),
                // 'desc'                  => 'Select how to sort retrieved posts.',
                'default'       => '12',
                'value'         => array(
                    '12' => __('1/1', 'homeradar-add-ons'),
                    '10' => __('5/6', 'homeradar-add-ons'),
                    '9'  => __('3/4', 'homeradar-add-ons'),
                    '8'  => __('2/3', 'homeradar-add-ons'),
                    '7'  => __('7/12', 'homeradar-add-ons'),
                    '6'  => __('1/2', 'homeradar-add-ons'),
                    '5'  => __('5/12', 'homeradar-add-ons'),
                    '4'  => __('1/3', 'homeradar-add-ons'),
                    '3'  => __('1/4', 'homeradar-add-ons'),
                    '2'  => __('1/6', 'homeradar-add-ons'),
                    '1'  => __('1/12', 'homeradar-add-ons'),

                ),
            ),

            array(
                'type'          => 'switch',
                'param_name'    => 'use_sec_style',
                // 'show_in_admin' => true,
                'label'         => _x('Use section style', 'Listing type', 'homeradar-add-ons'),
                // 'desc'                  => '',
                'default'       => 'no',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'        => 'checkbox',
                'param_name'  => 'hide_widget_on',
                'label'       => _x('Hide this widget on', 'Listing type', 'homeradar-add-ons'),
                'desc'        => _x('Hide on logout user or based author plan?', 'Listing type', 'homeradar-add-ons'),
                'default'     => '',
                'value'       => homeradar_addons_loggedin_plans_options(),
                'multiple'    => true,
                'show_toggle' => true,
            ),
            
            array(
                'type'       => 'text',
                'param_name' => 'el_id',
                'label'      => __('Element ID', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => '',
            ),

            array(
                'type'       => 'text',
                'param_name' => 'el_class',
                'label'      => __('Extra Class', 'homeradar-add-ons'),
                'desc'       => __("Use this field to add a class name and then refer to it in your CSS.", 'homeradar-add-ons'),
                'default'    => '',
            ),

        ),
    )
);
