<?php
/* add_ons_php */
azp_add_element(
    'lcalendar',
    array(
        'name'                    => __('Availability Calendar', 'homeradar-add-ons'),
        // 'desc'                  => __('Custom element for adding third party shortcode','homeradar-add-ons'),
        'category'                => __("Listing", 'homeradar-add-ons'),
        'icon'                    => ESB_DIR_URL . 'assets/azp-eles-icon/cththemes-logo.png',
        'open_settings_on_create' => true,
        'showStyleTab'            => true,
        'showTypographyTab'       => true,
        'showAnimationTab'        => true,
        'template_folder'         => 'single/',
        'attrs'                   => array(
            array(
                'type'          => 'text',
                'param_name'    => 'title',
                'show_in_admin' => true,
                'label'         => __('Title', 'homeradar-add-ons'),
                'default'       => 'Available Dates',
            ),
            
            array(
                'type'          => 'select',
                'param_name'    => 'dates_source',
                'show_in_admin' => true,
                'label'         => __('Dates from', 'homeradar-add-ons'),
                // 'desc'                  => 'Select Ascending or Descending order.',
                'default'       => 'listing_dates',
                'value'         => array(
                    'listing_dates'    => __('Available Dates (NEW)', 'homeradar-add-ons'),
                    // 'tour_calendar_metas'   => __('Tour Dates', 'homeradar-add-ons'),
                    'hotel_room_dates' => __('Hotel Room Dates', 'homeradar-add-ons'),
                    // 'house_dates'           => __('House Dates', 'homeradar-add-ons'),

                    // 'event_dates'           => __('Event Dates', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'          => 'switch',
                'param_name'    => 'single_select',
                'show_in_admin' => true,
                'label'         => __('Single date selection?', 'homeradar-add-ons'),
                // 'desc'                  => '',
                'default'       => 'yes',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'          => 'switch',
                'param_name'    => 'hide_if_empty',
                'show_in_admin' => true,
                'label'         => __('Hide widget if empty dates?', 'homeradar-add-ons'),
                // 'desc'                  => '',
                'default'       => 'no',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),

            

            

            array(
                'type'       => 'text',
                'param_name' => 'showing',
                'label'      => __('Months to show', 'homeradar-add-ons'),
                // 'desc'                  => '',
                'default'    => '2',
            ),

            array(
                'type'       => 'text',
                'param_name' => 'max',
                'label'      => __('Max Months', 'homeradar-add-ons'),
                // 'desc'                  => '',
                'default'    => '12',
            ),

            array(
                'type'          => 'switch',
                'param_name'    => 'show_min_nights',
                // 'show_in_admin' => true,
                'label'         => _x('Show Minimum Nights', 'Listing Type', 'homeradar-add-ons'),
                // 'desc'                  => '',
                'default'       => 'yes',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'                  => 'checkbox',
                'param_name'            => 'hide_widget_on',
                'label'                 => _x('Hide this widget on', 'Listing type', 'homeradar-add-ons'),
                'desc'                  => _x('Hide on logout user or based author plan?', 'Listing type', 'homeradar-add-ons'),
                'default'               => '',
                'value'                 => homeradar_addons_loggedin_plans_options(),
                'multiple'              => true,
                'show_toggle'           => true,
            ),

            array(
                'type'       => 'text',
                'param_name' => 'scroll_ele_id',
                'label'      => _x('Element ID will scroll to when dates selected', 'Listing type', 'homeradar-add-ons'),
                'desc'       => '<a href="'.ESB_DIR_URL . 'assets/images/ele-id.jpg'.'" target="_blank">What is the Element ID?<a>',
                'default'    => 'widget-general-booking',
            ),
            

            array(
                'type'       => 'text',
                'param_name' => 'el_id',
                'label'      => __('Element ID', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => '',
            ),

            array(
                'type'       => 'text',
                'param_name' => 'el_class',
                'label'      => __('Extra Class', 'homeradar-add-ons'),
                'desc'       => __("Use this field to add a class name and then refer to it in your CSS.", 'homeradar-add-ons'),
                'default'    => '',
            ),

        ),
    )
);
