<?php
/* add_ons_php */
azp_add_element(
    'linquiry_general',
    array(
        'name'                    => __('General Inquiry', 'homeradar-add-ons'),
        // 'desc'                  => __('Custom element for adding third party shortcode','homeradar-add-ons'),
        'category'                => __("Booking Inquiry", 'homeradar-add-ons'),
        'icon'                    => ESB_DIR_URL . 'assets/azp-eles-icon/cththemes-logo.png',
        'open_settings_on_create' => true,
        'showStyleTab'            => true,
        'showTypographyTab'       => true,
        'showAnimationTab'        => true,
        'template_folder'         => 'inquiry/',
        'attrs'                   => array(
            array(
                'type'          => 'text',
                'param_name'    => 'title',
                'show_in_admin' => true,
                'label'         => __('Title', 'homeradar-add-ons'),
                'default'       => 'Booking Inquiry',
            ),
            array(
                'type'          => 'switch',
                'param_name'    => 'hide_not_claimed',
                'show_in_admin' => true,
                'label'         => _x('Hide on not claimed listing?', 'Listing type', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'no',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),
            array(
                'type'        => 'checkbox',
                'param_name'  => 'hide_widget_on',
                // 'show_in_admin'         => true,
                'label'       => __('Hide this widget on', 'homeradar-add-ons'),
                'desc'        => __('Hide on logout user or based author plan?', 'homeradar-add-ons'),
                'default'     => '',
                'value'       => homeradar_addons_loggedin_plans_options(),
                'multiple'    => true,
                'show_toggle' => true,
            ),

            array(
                'type'          => 'switch',
                'param_name'    => 'hide_if_no_price',
                // 'show_in_admin' => true,
                'label'         => _x('Hide when there is no price set?', 'Listing Type', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'no',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),



            // array(
            //     'type'       => 'select',
            //     'param_name' => 'bprice',
            //     // 'show_in_admin'         => true,
            //     'label'      => __('Price Based', 'homeradar-add-ons'),
            //     'desc'       => '',
            //     'default'    => 'per_night',
            //     'value'      => array(
            //         'per_person'   => __('Per person', 'homeradar-add-ons'),
            //         'per_night'    => __('Per night', 'homeradar-add-ons'),
            //         'night_person' => __('Per person/night', 'homeradar-add-ons'),
            //         'per_day'      => __('Per day', 'homeradar-add-ons'),
            //         'day_person'   => __('Per person/day', 'homeradar-add-ons'),
            //         'listing'   => __('Per listing', 'homeradar-add-ons'),
            //         'none'         => __('No listing price', 'homeradar-add-ons'),

            //     ),
            // ),

            array(
                'type'          => 'switch',
                'param_name'    => 'show_name',
                'show_in_admin' => true,
                'label'         => __('Show name on logged in user?', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'no',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'          => 'switch',
                'param_name'    => 'show_email',
                'show_in_admin' => true,
                'label'         => __('Show email on logged in user?', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'no',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'          => 'switch',
                'param_name'    => 'show_phone',
                'show_in_admin' => true,
                'label'         => __('Show phone on logged in user?', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'yes',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'       => 'switch',
                'param_name' => 'checkin_show',
                // 'show_in_admin'         => true,
                'label'      => __('Show Checkin?', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => '1',
                'value'      => array(
                    '1' => __('Yes', 'homeradar-add-ons'),
                    '0' => __('No', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'          => 'switch',
                'param_name'    => 'hide_dfdate',
                // 'show_in_admin' => true,
                'label'         => _x('Hide current checkin date value?', 'Listing Type', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'no',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'          => 'switch',
                'param_name'    => 'ckin_required',
                // 'show_in_admin' => true,
                'label'         => _x('Require checkin for booking?', 'Listing Type', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'no',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'          => 'switch',
                'param_name'    => 'hide_dmetas',
                // 'show_in_admin' => true,
                'label'         => _x('Hide date metas?', 'Listing Type', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'no',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'       => 'switch',
                'param_name' => 'checkout_show',
                // 'show_in_admin'         => true,
                'label'      => __('Show Checkout?', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => '1',
                'value'      => array(
                    '1' => __('Yes', 'homeradar-add-ons'),
                    '0' => __('No', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'          => 'select',
                'param_name'    => 'dates_source',
                // 'show_in_admin' => true,
                'label'         => _x('Checkin/out dates from','Listing type', 'homeradar-add-ons'),
                // 'desc'                  => 'Select Ascending or Descending order.',
                'default'       => 'listing_dates',
                'value'         => array(
                    ''                  => _x('None','Listing type', 'homeradar-add-ons'),
                    'listing_dates'     => _x('Available Dates (NEW)','Listing type', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'       => 'text',
                'param_name' => 'dlabel',
                'label'      => __('Date picker label', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => 'Date',
            ),

            array(
                'type'       => 'icon',
                'param_name' => 'dicon',
                'label'      => __('Date picker icon', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => 'fal fa-calendar-check',
            ),

            array(
                'type'       => 'text',
                'param_name' => 'cin_plhd',
                'label'      => __('Checkin placeholder', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => '',
            ),

            array(
                'type'          => 'select',
                'param_name'    => 'dformat',
                'show_in_admin' => true,
                'label'         => __('Date Format', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'DD/MM/YYYY',
                'value'         => array(
                    'DD-MM-YYYY' => __('28-02-2019', 'homeradar-add-ons'),
                    'DD/MM/YYYY' => __('28/02/2019', 'homeradar-add-ons'),

                    'MM-DD-YYYY' => __('02-28-2019', 'homeradar-add-ons'),
                    'MM/DD/YYYY' => __('02/28/2019', 'homeradar-add-ons'),

                    'YYYY-MM-DD' => __('2019-02-28', 'homeradar-add-ons'),
                    'YYYY/MM/DD' => __('2019/02/28', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'       => 'switch',
                'param_name' => 'slots_show',
                // 'show_in_admin'         => true,
                'label'      => __('Show Time Slots?', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => '0',
                'value'      => array(
                    '1' => __('Yes', 'homeradar-add-ons'),
                    '0' => __('No', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'       => 'text',
                'param_name' => 'sllable',
                'label'      => __('Time slots label', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => 'Time Slots',
            ),

            array(
                'type'       => 'switch',
                'param_name' => 'slots_single',
                // 'show_in_admin'         => true,
                'label'      => __('Single Slot?', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => 'no',
                'value'      => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'       => 'switch',
                'param_name' => 'tpicker_show',
                // 'show_in_admin'         => true,
                'label'      => __('Show Time Picker?', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => '1',
                'value'      => array(
                    '1' => __('Yes', 'homeradar-add-ons'),
                    '0' => __('No', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'       => 'text',
                'param_name' => 'tlabel',
                'label'      => __('Time picker label', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => 'Time',
            ),

            array(
                'type'          => 'select',
                'param_name'    => 'tformat',
                'show_in_admin' => true,
                'label'         => __('Time Format', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'H:i:s',
                'value'         => array(
                    'g:i a' => __('8:30 am', 'homeradar-add-ons'),
                    'g:i A' => __('8:30 AM', 'homeradar-add-ons'),
                    'h:i a' => __('08:30 am', 'homeradar-add-ons'),
                    'h:i A' => __('08:30 AM', 'homeradar-add-ons'),
                    'G:i:s' => __('8:30:00 (24-hour)', 'homeradar-add-ons'),
                    'H:i:s' => __('08:30:00 (24-hour)', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'       => 'icon',
                'param_name' => 'ticon',
                'label'      => __('Time picker icon', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => 'fal fa-clock',
            ),

            array(
                'type'       => 'switch',
                'param_name' => 'adult_show',
                // 'show_in_admin'         => true,
                'label'      => __('Show Adults?', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => '1',
                'value'      => array(
                    '1' => __('Yes', 'homeradar-add-ons'),
                    '0' => __('No', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'       => 'text',
                'param_name' => 'adult_lbl',
                'label'      => __('Adults field label', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => 'Adults',
            ),

            array(
                'type'       => 'text',
                'param_name' => 'adult_desc',
                'label'      => __('Adults field description', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => 'Age 18+',
            ),

            array(
                'type'       => 'switch',
                'param_name' => 'child_show',
                // 'show_in_admin'         => true,
                'label'      => __('Show Children?', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => '1',
                'value'      => array(
                    '1' => __('Yes', 'homeradar-add-ons'),
                    '0' => __('No', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'       => 'text',
                'param_name' => 'child_lbl',
                'label'      => __('Children field label', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => 'Children',
            ),

            array(
                'type'       => 'text',
                'param_name' => 'child_desc',
                'label'      => __('Children field description', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => 'Age 6-17',
            ),

            array(
                'type'       => 'switch',
                'param_name' => 'infant_show',
                // 'show_in_admin'         => true,
                'label'      => __('Show Infant?', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => '1',
                'value'      => array(
                    '1' => __('Yes', 'homeradar-add-ons'),
                    '0' => __('No', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'       => 'text',
                'param_name' => 'infant_lbl',
                'label'      => __('Infant field label', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => 'Infant',
            ),

            array(
                'type'       => 'text',
                'param_name' => 'infant_desc',
                'label'      => __('Infant field description', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => 'Age 0-5',
            ),

            array(
                'type'          => 'switch',
                'param_name'    => 'show_notes',
                'show_in_admin' => true,
                'label'         => __('Show Additional Infos', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'no',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),
            

            

            array(
                'type'          => 'switch',
                'param_name'    => 'show_quantity',
                'label'         => __('Show Quantity', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'no',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'       => 'text',
                'param_name' => 'qtt_lbl',
                'label'      => __('Quantity field label', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => 'Quantity',
            ),

            array(
                'type'       => 'text',
                'param_name' => 'qtt_desc',
                'label'      => __('Quantity field description', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => '',
            ),

            array(
                'type'       => 'text',
                'param_name' => 'qtt_default',
                'label'      => __('Default quantity value', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => '0',
            ),

            array(
                'type'          => 'switch',
                'param_name'    => 'show_menu',
                'show_in_admin' => true,
                'label'         => __('Show Menu', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'no',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),
            array(
                'type'       => 'text',
                'param_name' => 'menu_lbl',
                'label'      => __('Menu label', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => 'Menu',
            ),

            array(
                'type'       => 'text',
                'param_name' => 'menu_desc',
                'label'      => __('Menu description', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => '',
            ),

            array(
                'type'          => 'select',
                'param_name'    => 'show_tickets',
                // 'show_in_admin' => true,
                'label'         => _x('Show Event Tickets','Listing type', 'homeradar-add-ons'),
                // 'desc'                  => 'Select Ascending or Descending order.',
                'default'       => 'single_day',
                'value'         => array(
                    'none'           => _x('None','Listing type', 'homeradar-add-ons'),
                    'single_day'     => _x('For single day event','Listing type', 'homeradar-add-ons'),
                    'multi_day'      => _x('For multiple days event','Listing type', 'homeradar-add-ons'),
                ),
            ),
            array(
                'type'       => 'text',
                'param_name' => 'ticket_lbl',
                'label'      => _x('Tickets label','Listing type', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => 'Select tickets',
            ),

            array(
                'type'          => 'switch',
                'param_name'    => 'show_lservices',
                'label'         => __('Show Extra Services?', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'yes',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'          => 'switch',
                'param_name'    => 'quanity_lservices',
                'label'         => __('Allow quantity for Extra Services?', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'yes',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'          => 'switch',
                'param_name'    => 'show_total_cost',
                // 'show_in_admin' => true,
                'label'         => __('Show Total Cost', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'yes',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),
            array(
                'type'          => 'switch',
                'param_name'    => 'show_upload_cv',
                // 'show_in_admin' => true,
                'label'         => __('Show upload CV field', 'homeradar-add-ons'),
                'desc'          => '',
                'default'       => 'no',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),

            array(
                'type'       => 'textarea',
                'param_name' => 'ad_note',
                'label'      => _x('Additional note','Listing type', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => 'The total cost above doesn\'t include 10% service fee.',
            ),

            array(
                'type'       => 'text',
                'param_name' => 'el_id',
                'label'      => __('Element ID', 'homeradar-add-ons'),
                'desc'       => '',
                'default'    => '',
            ),

            array(
                'type'       => 'text',
                'param_name' => 'el_class',
                'label'      => __('Extra Class', 'homeradar-add-ons'),
                'desc'       => __("Use this field to add a class name and then refer to it in your CSS.", 'homeradar-add-ons'),
                'default'    => '',
            ),

        ),
    )
);
