/* Mapbox GL JS is Copyright © 2020 Mapbox and subject to the Mapbox Terms of Service ((https://www.mapbox.com/legal/tos/). */
(function (global, factory) {
typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
typeof define === 'function' && define.amd ? define(factory) :
(global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.mapboxgl = factory());
}(this, (function () { 'use strict';

/* eslint-disable */

var shared, worker, mapboxgl;
// define gets called three times: one for each chunk. we rely on the order
// they're imported to know which is which
function define(_, chunk) {
if (!shared) {
    shared = chunk;
} else if (!worker) {
    worker = chunk;
} else {
    var workerBundleString = "self.onerror = function() { console.error('An error occurred while parsing the WebWorker bundle. This is most likely due to improper transpilation by Babel; please see https://docs.mapbox.com/mapbox-gl-js/api/#transpiling-v2'); }; var sharedChunk = {}; (" + shared + ")(sharedChunk); (" + worker + ")(sharedChunk); self.onerror = null;"

    var sharedChunk = {};
    shared(sharedChunk);
    mapboxgl = chunk(sharedChunk);
    if (typeof window !== 'undefined') {
        mapboxgl.workerUrl = window.URL.createObjectURL(new Blob([workerBundleString], { type: 'text/javascript' }));
    }
}
}


define(["exports"],(function(t){"use strict";var e="2.2.0",r=n;function n(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=n,this.p2x=r,this.p2y=n;}n.prototype.sampleCurveX=function(t){return ((this.ax*t+this.bx)*t+this.cx)*t},n.prototype.sampleCurveY=function(t){return ((this.ay*t+this.by)*t+this.cy)*t},n.prototype.sampleCurveDerivativeX=function(t){return (3*this.ax*t+2*this.bx)*t+this.cx},n.prototype.solveCurveX=function(t,e){var r,n,i,s,a;for(void 0===e&&(e=1e-6),i=t,a=0;a<8;a++){if(s=this.sampleCurveX(i)-t,Math.abs(s)<e)return i;var o=this.sampleCurveDerivativeX(i);if(Math.abs(o)<1e-6)break;i-=s/o;}if((i=t)<(r=0))return r;if(i>(n=1))return n;for(;r<n;){if(s=this.sampleCurveX(i),Math.abs(s-t)<e)return i;t>s?r=i:n=i,i=.5*(n-r)+r;}return i},n.prototype.solve=function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))};var i=s;function s(t,e){this.x=t,this.y=e;}s.prototype={clone:function(){return new s(this.x,this.y)},add:function(t){return this.clone()._add(t)},sub:function(t){return this.clone()._sub(t)},multByPoint:function(t){return this.clone()._multByPoint(t)},divByPoint:function(t){return this.clone()._divByPoint(t)},mult:function(t){return this.clone()._mult(t)},div:function(t){return this.clone()._div(t)},rotate:function(t){return this.clone()._rotate(t)},rotateAround:function(t,e){return this.clone()._rotateAround(t,e)},matMult:function(t){return this.clone()._matMult(t)},unit:function(){return this.clone()._unit()},perp:function(){return this.clone()._perp()},round:function(){return this.clone()._round()},mag:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals:function(t){return this.x===t.x&&this.y===t.y},dist:function(t){return Math.sqrt(this.distSqr(t))},distSqr:function(t){var e=t.x-this.x,r=t.y-this.y;return e*e+r*r},angle:function(){return Math.atan2(this.y,this.x)},angleTo:function(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith:function(t){return this.angleWithSep(t.x,t.y)},angleWithSep:function(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult:function(t){var e=t[2]*this.x+t[3]*this.y;return this.x=t[0]*this.x+t[1]*this.y,this.y=e,this},_add:function(t){return this.x+=t.x,this.y+=t.y,this},_sub:function(t){return this.x-=t.x,this.y-=t.y,this},_mult:function(t){return this.x*=t,this.y*=t,this},_div:function(t){return this.x/=t,this.y/=t,this},_multByPoint:function(t){return this.x*=t.x,this.y*=t.y,this},_divByPoint:function(t){return this.x/=t.x,this.y/=t.y,this},_unit:function(){return this._div(this.mag()),this},_perp:function(){var t=this.y;return this.y=this.x,this.x=-t,this},_rotate:function(t){var e=Math.cos(t),r=Math.sin(t),n=r*this.x+e*this.y;return this.x=e*this.x-r*this.y,this.y=n,this},_rotateAround:function(t,e){var r=Math.cos(t),n=Math.sin(t),i=e.y+n*(this.x-e.x)+r*(this.y-e.y);return this.x=e.x+r*(this.x-e.x)-n*(this.y-e.y),this.y=i,this},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}},s.convert=function(t){return t instanceof s?t:Array.isArray(t)?new s(t[0],t[1]):t};var a="undefined"!=typeof self?self:{};const o=Math.pow(2,53)-1,l=Math.PI/180,u=180/Math.PI;function c(t){return t*l}function h(t){if(t<=0)return 0;if(t>=1)return 1;const e=t*t,r=e*t;return 4*(t<.5?r:3*(t-e)+r-.75)}function p(t,e,n,i){const s=new r(t,e,n,i);return function(t){return s.solve(t)}}const d=p(.25,.1,.25,1);function f(t,e,r){return Math.min(r,Math.max(e,t))}function y(t,e,r){const n=r-e,i=((t-e)%n+n)%n+e;return i===e?r:i}function m(t,e,r){if(!t.length)return r(null,[]);let n=t.length;const i=new Array(t.length);let s=null;t.forEach(((t,a)=>{e(t,((t,e)=>{t&&(s=t),i[a]=e,0==--n&&r(s,i);}));}));}function g(t){const e=[];for(const r in t)e.push(t[r]);return e}function x(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}let v=1;function b(){return v++}function w(){return function t(e){return e?(e^16*Math.random()>>e/4).toString(16):([1e7]+-[1e3]+-4e3+-8e3+-1e11).replace(/[018]/g,t)}()}function _(t){return !!t&&/^[0-9a-f]{8}-[0-9a-f]{4}-[4][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i.test(t)}function k(t,e){t.forEach((t=>{e[t]&&(e[t]=e[t].bind(e));}));}function A(t,e){return -1!==t.indexOf(e,t.length-e.length)}function S(t,e,r){const n={};for(const i in t)n[i]=e.call(r||this,t[i],i,t);return n}function I(t,e,r){const n={};for(const i in t)e.call(r||this,t[i],i,t)&&(n[i]=t[i]);return n}function z(t){return Array.isArray(t)?t.map(z):"object"==typeof t&&t?S(t,z):t}const T={};function M(t){T[t]||("undefined"!=typeof console&&console.warn(t),T[t]=!0);}function E(t,e,r){return (r.y-t.y)*(e.x-t.x)>(e.y-t.y)*(r.x-t.x)}function B(t){let e=0;for(let r,n,i=0,s=t.length,a=s-1;i<s;a=i++)r=t[i],n=t[a],e+=(n.x-r.x)*(r.y+n.y);return e}function C(){return "undefined"!=typeof WorkerGlobalScope&&"undefined"!=typeof self&&self instanceof WorkerGlobalScope}function P(t){const e={};if(t.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,((t,r,n,i)=>{const s=n||i;return e[r]=!s||s.toLowerCase(),""})),e["max-age"]){const t=parseInt(e["max-age"],10);isNaN(t)?delete e["max-age"]:e["max-age"]=t;}return e}let V,D,F,L=null;function R(t){if(null==L){const e=t.navigator?t.navigator.userAgent:null;L=!!t.safari||!(!e||!(/\b(iPad|iPhone|iPod)\b/.test(e)||e.match("Safari")&&!e.match("Chrome")));}return L}function U(t){try{const e=a[t];return e.setItem("_mapbox_test_",1),e.removeItem("_mapbox_test_"),!0}catch(t){return !1}}const $={now:()=>void 0!==F?F:a.performance.now(),setNow(t){F=t;},restoreNow(){F=void 0;},frame(t){const e=a.requestAnimationFrame(t);return {cancel:()=>a.cancelAnimationFrame(e)}},getImageData(t,e=0){const r=a.document.createElement("canvas"),n=r.getContext("2d");if(!n)throw new Error("failed to create canvas 2d context");return r.width=t.width,r.height=t.height,n.drawImage(t,0,0,t.width,t.height),n.getImageData(-e,-e,t.width+2*e,t.height+2*e)},resolveURL:t=>(V||(V=a.document.createElement("a")),V.href=t,V.href),get devicePixelRatio(){return a.devicePixelRatio},get prefersReducedMotion(){return !!a.matchMedia&&(null==D&&(D=a.matchMedia("(prefers-reduced-motion: reduce)")),D.matches)}};let O;const q={API_URL:"https://api.mapbox.com",get API_URL_REGEX(){if(null==O){const t=/^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/|\?|$)/i;try{O=null!=process.env.API_URL_REGEX?new RegExp(process.env.API_URL_REGEX):t;}catch(e){O=t;}}return O},get EVENTS_URL(){return this.API_URL?0===this.API_URL.indexOf("https://api.mapbox.cn")?"https://events.mapbox.cn/events/v2":0===this.API_URL.indexOf("https://api.mapbox.com")?"https://events.mapbox.com/events/v2":null:null},SESSION_PATH:"/map-sessions/v1",FEEDBACK_URL:"https://apps.mapbox.com/feedback",TILE_URL_VERSION:"v4",RASTER_URL_PREFIX:"raster/v1",REQUIRE_ACCESS_TOKEN:!0,ACCESS_TOKEN:null,MAX_PARALLEL_IMAGE_REQUESTS:16},N={supported:!1,testSupport:function(t){!Z&&G&&(X?K(t):j=t);}};let j,G,Z=!1,X=!1;function K(t){const e=t.createTexture();t.bindTexture(t.TEXTURE_2D,e);try{if(t.texImage2D(t.TEXTURE_2D,0,t.RGBA,t.RGBA,t.UNSIGNED_BYTE,G),t.isContextLost())return;N.supported=!0;}catch(t){}t.deleteTexture(e),Z=!0;}a.document&&(G=a.document.createElement("img"),G.onload=function(){j&&K(j),j=null,X=!0;},G.onerror=function(){Z=!0,j=null;},G.src="data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA=");const H="01",Y="NO_ACCESS_TOKEN";function J(t){return 0===t.indexOf("mapbox:")}function W(t){return q.API_URL_REGEX.test(t)}const Q=/^(\w+):\/\/([^/?]*)(\/[^?]+)?\??(.+)?/;function tt(t){const e=t.match(Q);if(!e)throw new Error("Unable to parse URL object");return {protocol:e[1],authority:e[2],path:e[3]||"/",params:e[4]?e[4].split("&"):[]}}function et(t){const e=t.params.length?`?${t.params.join("&")}`:"";return `${t.protocol}://${t.authority}${t.path}${e}`}function rt(t){if(!t)return null;const e=t.split(".");if(!e||3!==e.length)return null;try{return JSON.parse(decodeURIComponent(a.atob(e[1]).split("").map((t=>"%"+("00"+t.charCodeAt(0).toString(16)).slice(-2))).join("")))}catch(t){return null}}class nt{constructor(t){this.type=t,this.anonId=null,this.eventData={},this.queue=[],this.pendingRequest=null;}getStorageKey(t){const e=rt(q.ACCESS_TOKEN);let r="";return r=e&&e.u?a.btoa(encodeURIComponent(e.u).replace(/%([0-9A-F]{2})/g,((t,e)=>String.fromCharCode(Number("0x"+e))))):q.ACCESS_TOKEN||"",t?`mapbox.eventData.${t}:${r}`:`mapbox.eventData:${r}`}fetchEventData(){const t=U("localStorage"),e=this.getStorageKey(),r=this.getStorageKey("uuid");if(t)try{const t=a.localStorage.getItem(e);t&&(this.eventData=JSON.parse(t));const n=a.localStorage.getItem(r);n&&(this.anonId=n);}catch(t){M("Unable to read from LocalStorage");}}saveEventData(){const t=U("localStorage"),e=this.getStorageKey(),r=this.getStorageKey("uuid");if(t)try{a.localStorage.setItem(r,this.anonId),Object.keys(this.eventData).length>=1&&a.localStorage.setItem(e,JSON.stringify(this.eventData));}catch(t){M("Unable to write to LocalStorage");}}processRequests(t){}postEvent(t,r,n,i){if(!q.EVENTS_URL)return;const s=tt(q.EVENTS_URL);s.params.push(`access_token=${i||q.ACCESS_TOKEN||""}`);const a={event:this.type,created:new Date(t).toISOString(),sdkIdentifier:"mapbox-gl-js",sdkVersion:e,skuId:H,userId:this.anonId},o=r?x(a,r):a,l={url:et(s),headers:{"Content-Type":"text/plain"},body:JSON.stringify([o])};this.pendingRequest=It(l,(t=>{this.pendingRequest=null,n(t),this.saveEventData(),this.processRequests(i);}));}queueRequest(t,e){this.queue.push(t),this.processRequests(e);}}const it=new class extends nt{constructor(t){super("appUserTurnstile"),this._customAccessToken=t;}postTurnstileEvent(t,e){q.EVENTS_URL&&q.ACCESS_TOKEN&&Array.isArray(t)&&t.some((t=>J(t)||W(t)))&&this.queueRequest(Date.now(),e);}processRequests(t){if(this.pendingRequest||0===this.queue.length)return;this.anonId&&this.eventData.lastSuccess&&this.eventData.tokenU||this.fetchEventData();const e=rt(q.ACCESS_TOKEN),r=e?e.u:q.ACCESS_TOKEN;let n=r!==this.eventData.tokenU;_(this.anonId)||(this.anonId=w(),n=!0);const i=this.queue.shift();if(this.eventData.lastSuccess){const t=new Date(this.eventData.lastSuccess),e=new Date(i),r=(i-this.eventData.lastSuccess)/864e5;n=n||r>=1||r<-1||t.getDate()!==e.getDate();}else n=!0;if(!n)return this.processRequests();this.postEvent(i,{"enabled.telemetry":!1},(t=>{t||(this.eventData.lastSuccess=i,this.eventData.tokenU=r);}),t);}},st=it.postTurnstileEvent.bind(it),at=new class extends nt{constructor(){super("map.load"),this.success={},this.skuToken="";}postMapLoadEvent(t,e,r,n){this.skuToken=e,this.errorCb=n,q.EVENTS_URL&&(r||q.ACCESS_TOKEN?this.queueRequest({id:t,timestamp:Date.now()},r):this.errorCb(new Error(Y)));}processRequests(t){if(this.pendingRequest||0===this.queue.length)return;const{id:e,timestamp:r}=this.queue.shift();e&&this.success[e]||(this.anonId||this.fetchEventData(),_(this.anonId)||(this.anonId=w()),this.postEvent(r,{skuToken:this.skuToken},(t=>{t?this.errorCb(t):e&&(this.success[e]=!0);}),t));}},ot=at.postMapLoadEvent.bind(at),lt=new class extends nt{constructor(){super("map.auth"),this.success={},this.skuToken="";}getSession(t,e,r,n){if(!q.API_URL||!q.SESSION_PATH)return;const i=tt(q.API_URL+q.SESSION_PATH);i.params.push(`sku=${e||""}`),i.params.push(`access_token=${n||q.ACCESS_TOKEN||""}`);const s={url:et(i),headers:{"Content-Type":"text/plain"}};this.pendingRequest=zt(s,(t=>{this.pendingRequest=null,r(t),this.saveEventData(),this.processRequests(n);}));}getSessionAPI(t,e,r,n){this.skuToken=e,this.errorCb=n,q.SESSION_PATH&&q.API_URL&&(r||q.ACCESS_TOKEN?this.queueRequest({id:t,timestamp:Date.now()},r):this.errorCb(new Error(Y)));}processRequests(t){if(this.pendingRequest||0===this.queue.length)return;const{id:e,timestamp:r}=this.queue.shift();e&&this.success[e]||this.getSession(r,this.skuToken,(t=>{t?this.errorCb(t):e&&(this.success[e]=!0);}),t);}},ut=lt.getSessionAPI.bind(lt),ct=new Set,ht="mapbox-tiles";let pt,dt,ft=500,yt=50;function mt(){a.caches&&!pt&&(pt=a.caches.open(ht));}function gt(t){const e=t.indexOf("?");return e<0?t:t.slice(0,e)}let xt,vt=1/0;function bt(){return null==xt&&(xt=a.OffscreenCanvas&&new a.OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof a.createImageBitmap),xt}const wt={Unknown:"Unknown",Style:"Style",Source:"Source",Tile:"Tile",Glyphs:"Glyphs",SpriteImage:"SpriteImage",SpriteJSON:"SpriteJSON",Image:"Image"};"function"==typeof Object.freeze&&Object.freeze(wt);class _t extends Error{constructor(t,e,r){401===e&&W(r)&&(t+=": you may have provided an invalid Mapbox access token. See https://www.mapbox.com/api-documentation/#access-tokens-and-token-scopes"),super(t),this.status=e,this.url=r;}toString(){return `${this.name}: ${this.message} (${this.status}): ${this.url}`}}const kt=C()?()=>self.worker&&self.worker.referrer:()=>("blob:"===a.location.protocol?a.parent:a).location.href;const At=function(t,e){if(!(/^file:/.test(r=t.url)||/^file:/.test(kt())&&!/^\w+:/.test(r))){if(a.fetch&&a.Request&&a.AbortController&&a.Request.prototype.hasOwnProperty("signal"))return function(t,e){const r=new a.AbortController,n=new a.Request(t.url,{method:t.method||"GET",body:t.body,credentials:t.credentials,headers:t.headers,referrer:kt(),signal:r.signal});let i=!1,s=!1;const o=(l=n.url).indexOf("sku=")>0&&W(l);var l;"json"===t.type&&n.headers.set("Accept","application/json");const u=(r,i,l)=>{if(s)return;if(r&&"SecurityError"!==r.message&&M(r),i&&l)return c(i);const u=Date.now();a.fetch(n).then((r=>{if(r.ok){const t=o?r.clone():null;return c(r,t,u)}return e(new _t(r.statusText,r.status,t.url))})).catch((t=>{20!==t.code&&e(new Error(t.message));}));},c=(r,o,l)=>{("arrayBuffer"===t.type?r.arrayBuffer():"json"===t.type?r.json():r.text()).then((t=>{s||(o&&l&&function(t,e,r){if(mt(),!pt)return;const n={status:e.status,statusText:e.statusText,headers:new a.Headers};e.headers.forEach(((t,e)=>n.headers.set(e,t)));const i=P(e.headers.get("Cache-Control")||"");i["no-store"]||(i["max-age"]&&n.headers.set("Expires",new Date(r+1e3*i["max-age"]).toUTCString()),new Date(n.headers.get("Expires")).getTime()-r<42e4||function(t,e){if(void 0===dt)try{new Response(new ReadableStream),dt=!0;}catch(t){dt=!1;}dt?e(t.body):t.blob().then(e);}(e,(e=>{const r=new a.Response(e,n);mt(),pt&&pt.then((e=>e.put(gt(t.url),r))).catch((t=>M(t.message)));})));}(n,o,l),i=!0,e(null,t,r.headers.get("Cache-Control"),r.headers.get("Expires")));})).catch((t=>{s||e(new Error(t.message));}));};return o?function(t,e){if(mt(),!pt)return e(null);const r=gt(t.url);pt.then((t=>{t.match(r).then((n=>{const i=function(t){if(!t)return !1;const e=new Date(t.headers.get("Expires")||0),r=P(t.headers.get("Cache-Control")||"");return e>Date.now()&&!r["no-cache"]}(n);t.delete(r),i&&t.put(r,n.clone()),e(null,n,i);})).catch(e);})).catch(e);}(n,u):u(null,null),{cancel:()=>{s=!0,i||r.abort();}}}(t,e);if(C()&&self.worker&&self.worker.actor)return self.worker.actor.send("getResource",t,e,void 0,!0)}var r;return function(t,e){const r=new a.XMLHttpRequest;r.open(t.method||"GET",t.url,!0),"arrayBuffer"===t.type&&(r.responseType="arraybuffer");for(const e in t.headers)r.setRequestHeader(e,t.headers[e]);return "json"===t.type&&(r.responseType="text",r.setRequestHeader("Accept","application/json")),r.withCredentials="include"===t.credentials,r.onerror=()=>{e(new Error(r.statusText));},r.onload=()=>{if((r.status>=200&&r.status<300||0===r.status)&&null!==r.response){let n=r.response;if("json"===t.type)try{n=JSON.parse(r.response);}catch(t){return e(t)}e(null,n,r.getResponseHeader("Cache-Control"),r.getResponseHeader("Expires"));}else e(new _t(r.statusText,r.status,t.url));},r.send(t.body),{cancel:()=>r.abort()}}(t,e)},St=function(t,e){return At(x(t,{type:"arrayBuffer"}),e)},It=function(t,e){return At(x(t,{method:"POST"}),e)},zt=function(t,e){return At(x(t,{method:"GET"}),e)};function Tt(t){const e=a.document.createElement("a");return e.href=t,e.protocol===a.document.location.protocol&&e.host===a.document.location.host}const Mt="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";let Et,Bt;Et=[],Bt=0;const Ct=function(t,e){if(N.supported&&(t.headers||(t.headers={}),t.headers.accept="image/webp,*/*"),Bt>=q.MAX_PARALLEL_IMAGE_REQUESTS){const r={requestParameters:t,callback:e,cancelled:!1,cancel(){this.cancelled=!0;}};return Et.push(r),r}Bt++;let r=!1;const n=()=>{if(!r)for(r=!0,Bt--;Et.length&&Bt<q.MAX_PARALLEL_IMAGE_REQUESTS;){const t=Et.shift(),{requestParameters:e,callback:r,cancelled:n}=t;n||(t.cancel=Ct(e,r).cancel);}},i=St(t,((t,r,i,s)=>{n(),t?e(t):r&&(bt()?function(t,e){const r=new a.Blob([new Uint8Array(t)],{type:"image/png"});a.createImageBitmap(r).then((t=>{e(null,t);})).catch((t=>{e(new Error(`Could not load image because of ${t.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`));}));}(r,e):function(t,e,r,n){const i=new a.Image,s=a.URL;i.onload=()=>{e(null,i),s.revokeObjectURL(i.src),i.onload=null,a.requestAnimationFrame((()=>{i.src=Mt;}));},i.onerror=()=>e(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const o=new a.Blob([new Uint8Array(t)],{type:"image/png"});i.cacheControl=r,i.expires=n,i.src=t.byteLength?s.createObjectURL(o):Mt;}(r,e,i,s));}));return {cancel:()=>{i.cancel(),n();}}};function Pt(t,e,r){r[t]&&-1!==r[t].indexOf(e)||(r[t]=r[t]||[],r[t].push(e));}function Vt(t,e,r){if(r&&r[t]){const n=r[t].indexOf(e);-1!==n&&r[t].splice(n,1);}}class Dt{constructor(t,e={}){x(this,e),this.type=t;}}class Ft extends Dt{constructor(t,e={}){super("error",x({error:t},e));}}class Lt{on(t,e){return this._listeners=this._listeners||{},Pt(t,e,this._listeners),this}off(t,e){return Vt(t,e,this._listeners),Vt(t,e,this._oneTimeListeners),this}once(t,e){return e?(this._oneTimeListeners=this._oneTimeListeners||{},Pt(t,e,this._oneTimeListeners),this):new Promise((e=>this.once(t,e)))}fire(t,e){"string"==typeof t&&(t=new Dt(t,e||{}));const r=t.type;if(this.listens(r)){t.target=this;const e=this._listeners&&this._listeners[r]?this._listeners[r].slice():[];for(const r of e)r.call(this,t);const n=this._oneTimeListeners&&this._oneTimeListeners[r]?this._oneTimeListeners[r].slice():[];for(const e of n)Vt(r,e,this._oneTimeListeners),e.call(this,t);const i=this._eventedParent;i&&(x(t,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),i.fire(t));}else t instanceof Ft&&console.error(t.error);return this}listens(t){return !!(this._listeners&&this._listeners[t]&&this._listeners[t].length>0||this._oneTimeListeners&&this._oneTimeListeners[t]&&this._oneTimeListeners[t].length>0||this._eventedParent&&this._eventedParent.listens(t))}setEventedParent(t,e){return this._eventedParent=t,this._eventedParentData=e,this}}var Rt={$version:8,$root:{version:{required:!0,type:"enum",values:[8]},name:{type:"string"},metadata:{type:"*"},center:{type:"array",value:"number"},zoom:{type:"number"},bearing:{type:"number",default:0,period:360,units:"degrees"},pitch:{type:"number",default:0,units:"degrees"},light:{type:"light"},terrain:{type:"terrain"},sources:{required:!0,type:"sources"},sprite:{type:"string"},glyphs:{type:"string"},transition:{type:"transition"},layers:{required:!0,type:"array",value:"layer"}},sources:{"*":{type:"source"}},source:["source_vector","source_raster","source_raster_dem","source_geojson","source_video","source_image"],source_vector:{type:{required:!0,type:"enum",values:{vector:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},attribution:{type:"string"},promoteId:{type:"promoteId"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster:{type:{required:!0,type:"enum",values:{raster:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},attribution:{type:"string"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster_dem:{type:{required:!0,type:"enum",values:{"raster-dem":{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},attribution:{type:"string"},encoding:{type:"enum",values:{terrarium:{},mapbox:{}},default:"mapbox"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_geojson:{type:{required:!0,type:"enum",values:{geojson:{}}},data:{type:"*"},maxzoom:{type:"number",default:18},attribution:{type:"string"},buffer:{type:"number",default:128,maximum:512,minimum:0},filter:{type:"*"},tolerance:{type:"number",default:.375},cluster:{type:"boolean",default:!1},clusterRadius:{type:"number",default:50,minimum:0},clusterMaxZoom:{type:"number"},clusterMinPoints:{type:"number"},clusterProperties:{type:"*"},lineMetrics:{type:"boolean",default:!1},generateId:{type:"boolean",default:!1},promoteId:{type:"promoteId"}},source_video:{type:{required:!0,type:"enum",values:{video:{}}},urls:{required:!0,type:"array",value:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},source_image:{type:{required:!0,type:"enum",values:{image:{}}},url:{required:!0,type:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},layer:{id:{type:"string",required:!0},type:{type:"enum",values:{fill:{},line:{},symbol:{},circle:{},heatmap:{},"fill-extrusion":{},raster:{},hillshade:{},background:{},sky:{}},required:!0},metadata:{type:"*"},source:{type:"string"},"source-layer":{type:"string"},minzoom:{type:"number",minimum:0,maximum:24},maxzoom:{type:"number",minimum:0,maximum:24},filter:{type:"filter"},layout:{type:"layout"},paint:{type:"paint"}},layout:["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_hillshade","layout_background","layout_sky"],layout_background:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_sky:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_fill:{"fill-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_circle:{"circle-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_heatmap:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},"layout_fill-extrusion":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_line:{"line-cap":{type:"enum",values:{butt:{},round:{},square:{}},default:"butt",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-join":{type:"enum",values:{bevel:{},round:{},miter:{}},default:"miter",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{type:"number",default:2,requires:[{"line-join":"miter"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-round-limit":{type:"number",default:1.05,requires:[{"line-join":"round"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_symbol:{"symbol-placement":{type:"enum",values:{point:{},line:{},"line-center":{}},default:"point",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-spacing":{type:"number",default:250,minimum:1,units:"pixels",requires:[{"symbol-placement":"line"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{type:"boolean",default:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{type:"enum",values:{auto:{},"viewport-y":{},source:{}},default:"auto",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{type:"boolean",default:!1,requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{type:"boolean",default:!1,requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-optional":{type:"boolean",default:!1,requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-size":{type:"number",default:1,minimum:0,units:"factor of the original icon size",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{type:"enum",values:{none:{},width:{},height:{},both:{}},default:"none",requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-text-fit-padding":{type:"array",value:"number",length:4,default:[0,0,0,0],units:"pixels",requires:["icon-image","text-field",{"icon-text-fit":["both","width","height"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-image":{type:"resolvedImage",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{type:"number",default:2,minimum:0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-keep-upright":{type:"boolean",default:!1,requires:["icon-image",{"icon-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-offset":{type:"array",value:"number",length:2,default:[0,0],requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-field":{type:"formatted",default:"",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-font":{type:"array",value:"string",default:["Open Sans Regular","Arial Unicode MS Regular"],requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-size":{type:"number",default:16,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{type:"number",default:10,minimum:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{type:"number",default:1.2,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-letter-spacing":{type:"number",default:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-justify":{type:"enum",values:{auto:{},left:{},center:{},right:{}},default:"center",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{type:"number",units:"ems",default:0,requires:["text-field"],"property-type":"data-driven",expression:{interpolated:!0,parameters:["zoom","feature"]}},"text-variable-anchor":{type:"array",value:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["text-field",{"!":"text-variable-anchor"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{type:"number",default:45,units:"degrees",requires:["text-field",{"symbol-placement":["line","line-center"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-writing-mode":{type:"array",value:"enum",values:{horizontal:{},vertical:{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-padding":{type:"number",default:2,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-keep-upright":{type:"boolean",default:!0,requires:["text-field",{"text-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-transform":{type:"enum",values:{none:{},uppercase:{},lowercase:{}},default:"none",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-offset":{type:"array",value:"number",units:"ems",length:2,default:[0,0],requires:["text-field",{"!":"text-radial-offset"}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{type:"boolean",default:!1,requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{type:"boolean",default:!1,requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-optional":{type:"boolean",default:!1,requires:["text-field","icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_raster:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_hillshade:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},filter:{type:"array",value:"*"},filter_operator:{type:"enum",values:{"==":{},"!=":{},">":{},">=":{},"<":{},"<=":{},in:{},"!in":{},all:{},any:{},none:{},has:{},"!has":{},within:{}}},geometry_type:{type:"enum",values:{Point:{},LineString:{},Polygon:{}}},function:{expression:{type:"expression"},stops:{type:"array",value:"function_stop"},base:{type:"number",default:1,minimum:0},property:{type:"string",default:"$zoom"},type:{type:"enum",values:{identity:{},exponential:{},interval:{},categorical:{}},default:"exponential"},colorSpace:{type:"enum",values:{rgb:{},lab:{},hcl:{}},default:"rgb"},default:{type:"*",required:!1}},function_stop:{type:"array",minimum:0,maximum:24,value:["number","color"],length:2},expression:{type:"array",value:"*",minimum:1},light:{anchor:{type:"enum",default:"viewport",values:{map:{},viewport:{}},"property-type":"data-constant",transition:!1,expression:{interpolated:!1,parameters:["zoom"]}},position:{type:"array",default:[1.15,210,30],length:3,value:"number","property-type":"data-constant",transition:!0,expression:{interpolated:!0,parameters:["zoom"]}},color:{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},intensity:{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},terrain:{source:{type:"string",required:!0},exaggeration:{type:"number","property-type":"data-constant",default:1,minimum:0,maximum:1e3,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},paint:["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_background","paint_sky"],paint_fill:{"fill-antialias":{type:"boolean",default:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-outline-color":{type:"color",transition:!0,requires:[{"!":"fill-pattern"},{"fill-antialias":!0}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-extrusion-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-extrusion-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"fill-extrusion-height":{type:"number",default:0,minimum:0,units:"meters",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{type:"number",default:0,minimum:0,units:"meters",transition:!0,requires:["fill-extrusion-height"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{type:"boolean",default:!0,transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_line:{"line-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"line-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["line-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-width":{type:"number",default:1,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-gap-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-offset":{type:"number",default:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-dasharray":{type:"array",value:"number",minimum:0,transition:!0,units:"line widths",requires:[{"!":"line-pattern"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"line-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-gradient":{type:"color",transition:!1,requires:[{"!":"line-dasharray"},{"!":"line-pattern"},{source:"geojson",has:{lineMetrics:!0}}],expression:{interpolated:!0,parameters:["line-progress"]},"property-type":"color-ramp"}},paint_circle:{"circle-radius":{type:"number",default:5,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-blur":{type:"number",default:0,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["circle-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{type:"enum",values:{map:{},viewport:{}},default:"map",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"}},paint_heatmap:{"heatmap-radius":{type:"number",default:30,minimum:1,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-weight":{type:"number",default:1,minimum:0,transition:!1,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-intensity":{type:"number",default:1,minimum:0,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"heatmap-color":{type:"color",default:["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",.1,"royalblue",.3,"cyan",.5,"lime",.7,"yellow",1,"red"],transition:!1,expression:{interpolated:!0,parameters:["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_symbol:{"icon-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-color":{type:"color",default:"#000000",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["icon-image","icon-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-color":{type:"color",default:"#000000",transition:!0,overridable:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["text-field","text-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_raster:{"raster-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-hue-rotate":{type:"number",default:0,period:360,transition:!0,units:"degrees",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{type:"number",default:0,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-saturation":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-contrast":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-resampling":{type:"enum",values:{linear:{},nearest:{}},default:"linear",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{type:"number",default:300,minimum:0,transition:!1,units:"milliseconds",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_hillshade:{"hillshade-illumination-direction":{type:"number",default:335,minimum:0,maximum:359,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{type:"number",default:.5,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-highlight-color":{type:"color",default:"#FFFFFF",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-accent-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_background:{"background-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"background-pattern"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"background-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"background-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_sky:{"sky-type":{type:"enum",values:{gradient:{},atmosphere:{}},default:"atmosphere",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"sky-atmosphere-sun":{type:"array",value:"number",length:2,units:"degrees",minimum:[0,0],maximum:[360,180],transition:!1,requires:[{"sky-type":"atmosphere"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"sky-atmosphere-sun-intensity":{type:"number",requires:[{"sky-type":"atmosphere"}],default:10,minimum:0,maximum:100,transition:!1,"property-type":"data-constant"},"sky-gradient-center":{type:"array",requires:[{"sky-type":"gradient"}],value:"number",default:[0,0],length:2,units:"degrees",minimum:[0,0],maximum:[360,180],transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"sky-gradient-radius":{type:"number",requires:[{"sky-type":"gradient"}],default:90,minimum:0,maximum:180,transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"sky-gradient":{type:"color",default:["interpolate",["linear"],["sky-radial-progress"],.8,"#87ceeb",1,"white"],transition:!1,requires:[{"sky-type":"gradient"}],expression:{interpolated:!0,parameters:["sky-radial-progress"]},"property-type":"color-ramp"},"sky-atmosphere-halo-color":{type:"color",default:"white",transition:!1,requires:[{"sky-type":"atmosphere"}],"property-type":"data-constant"},"sky-atmosphere-color":{type:"color",default:"white",transition:!1,requires:[{"sky-type":"atmosphere"}],"property-type":"data-constant"},"sky-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},transition:{duration:{type:"number",default:300,minimum:0,units:"milliseconds"},delay:{type:"number",default:0,minimum:0,units:"milliseconds"}},"property-type":{"data-driven":{type:"property-type"},"cross-faded":{type:"property-type"},"cross-faded-data-driven":{type:"property-type"},"color-ramp":{type:"property-type"},"data-constant":{type:"property-type"},constant:{type:"property-type"}},promoteId:{"*":{type:"string"}}};class Ut{constructor(t,e,r,n){this.message=(t?`${t}: `:"")+r,n&&(this.identifier=n),null!=e&&e.__line__&&(this.line=e.__line__);}}function $t(t){const e=t.value;return e?[new Ut(t.key,e,"constants have been deprecated as of v8")]:[]}function Ot(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}function qt(t){return t instanceof Number||t instanceof String||t instanceof Boolean?t.valueOf():t}function Nt(t){if(Array.isArray(t))return t.map(Nt);if(t instanceof Object&&!(t instanceof Number||t instanceof String||t instanceof Boolean)){const e={};for(const r in t)e[r]=Nt(t[r]);return e}return qt(t)}class jt extends Error{constructor(t,e){super(e),this.message=e,this.key=t;}}class Gt{constructor(t,e=[]){this.parent=t,this.bindings={};for(const[t,r]of e)this.bindings[t]=r;}concat(t){return new Gt(this,t)}get(t){if(this.bindings[t])return this.bindings[t];if(this.parent)return this.parent.get(t);throw new Error(`${t} not found in scope.`)}has(t){return !!this.bindings[t]||!!this.parent&&this.parent.has(t)}}const Zt={kind:"null"},Xt={kind:"number"},Kt={kind:"string"},Ht={kind:"boolean"},Yt={kind:"color"},Jt={kind:"object"},Wt={kind:"value"},Qt={kind:"collator"},te={kind:"formatted"},ee={kind:"resolvedImage"};function re(t,e){return {kind:"array",itemType:t,N:e}}function ne(t){if("array"===t.kind){const e=ne(t.itemType);return "number"==typeof t.N?`array<${e}, ${t.N}>`:"value"===t.itemType.kind?"array":`array<${e}>`}return t.kind}const ie=[Zt,Xt,Kt,Ht,Yt,te,Jt,re(Wt),ee];function se(t,e){if("error"===e.kind)return null;if("array"===t.kind){if("array"===e.kind&&(0===e.N&&"value"===e.itemType.kind||!se(t.itemType,e.itemType))&&("number"!=typeof t.N||t.N===e.N))return null}else {if(t.kind===e.kind)return null;if("value"===t.kind)for(const t of ie)if(!se(t,e))return null}return `Expected ${ne(t)} but found ${ne(e)} instead.`}function ae(t,e){return e.some((e=>e.kind===t.kind))}function oe(t,e){return e.some((e=>"null"===e?null===t:"array"===e?Array.isArray(t):"object"===e?t&&!Array.isArray(t)&&"object"==typeof t:e===typeof t))}function le(t){var e={exports:{}};return t(e,e.exports),e.exports}var ue=le((function(t,e){var r={transparent:[0,0,0,0],aliceblue:[240,248,255,1],antiquewhite:[250,235,215,1],aqua:[0,255,255,1],aquamarine:[127,255,212,1],azure:[240,255,255,1],beige:[245,245,220,1],bisque:[255,228,196,1],black:[0,0,0,1],blanchedalmond:[255,235,205,1],blue:[0,0,255,1],blueviolet:[138,43,226,1],brown:[165,42,42,1],burlywood:[222,184,135,1],cadetblue:[95,158,160,1],chartreuse:[127,255,0,1],chocolate:[210,105,30,1],coral:[255,127,80,1],cornflowerblue:[100,149,237,1],cornsilk:[255,248,220,1],crimson:[220,20,60,1],cyan:[0,255,255,1],darkblue:[0,0,139,1],darkcyan:[0,139,139,1],darkgoldenrod:[184,134,11,1],darkgray:[169,169,169,1],darkgreen:[0,100,0,1],darkgrey:[169,169,169,1],darkkhaki:[189,183,107,1],darkmagenta:[139,0,139,1],darkolivegreen:[85,107,47,1],darkorange:[255,140,0,1],darkorchid:[153,50,204,1],darkred:[139,0,0,1],darksalmon:[233,150,122,1],darkseagreen:[143,188,143,1],darkslateblue:[72,61,139,1],darkslategray:[47,79,79,1],darkslategrey:[47,79,79,1],darkturquoise:[0,206,209,1],darkviolet:[148,0,211,1],deeppink:[255,20,147,1],deepskyblue:[0,191,255,1],dimgray:[105,105,105,1],dimgrey:[105,105,105,1],dodgerblue:[30,144,255,1],firebrick:[178,34,34,1],floralwhite:[255,250,240,1],forestgreen:[34,139,34,1],fuchsia:[255,0,255,1],gainsboro:[220,220,220,1],ghostwhite:[248,248,255,1],gold:[255,215,0,1],goldenrod:[218,165,32,1],gray:[128,128,128,1],green:[0,128,0,1],greenyellow:[173,255,47,1],grey:[128,128,128,1],honeydew:[240,255,240,1],hotpink:[255,105,180,1],indianred:[205,92,92,1],indigo:[75,0,130,1],ivory:[255,255,240,1],khaki:[240,230,140,1],lavender:[230,230,250,1],lavenderblush:[255,240,245,1],lawngreen:[124,252,0,1],lemonchiffon:[255,250,205,1],lightblue:[173,216,230,1],lightcoral:[240,128,128,1],lightcyan:[224,255,255,1],lightgoldenrodyellow:[250,250,210,1],lightgray:[211,211,211,1],lightgreen:[144,238,144,1],lightgrey:[211,211,211,1],lightpink:[255,182,193,1],lightsalmon:[255,160,122,1],lightseagreen:[32,178,170,1],lightskyblue:[135,206,250,1],lightslategray:[119,136,153,1],lightslategrey:[119,136,153,1],lightsteelblue:[176,196,222,1],lightyellow:[255,255,224,1],lime:[0,255,0,1],limegreen:[50,205,50,1],linen:[250,240,230,1],magenta:[255,0,255,1],maroon:[128,0,0,1],mediumaquamarine:[102,205,170,1],mediumblue:[0,0,205,1],mediumorchid:[186,85,211,1],mediumpurple:[147,112,219,1],mediumseagreen:[60,179,113,1],mediumslateblue:[123,104,238,1],mediumspringgreen:[0,250,154,1],mediumturquoise:[72,209,204,1],mediumvioletred:[199,21,133,1],midnightblue:[25,25,112,1],mintcream:[245,255,250,1],mistyrose:[255,228,225,1],moccasin:[255,228,181,1],navajowhite:[255,222,173,1],navy:[0,0,128,1],oldlace:[253,245,230,1],olive:[128,128,0,1],olivedrab:[107,142,35,1],orange:[255,165,0,1],orangered:[255,69,0,1],orchid:[218,112,214,1],palegoldenrod:[238,232,170,1],palegreen:[152,251,152,1],paleturquoise:[175,238,238,1],palevioletred:[219,112,147,1],papayawhip:[255,239,213,1],peachpuff:[255,218,185,1],peru:[205,133,63,1],pink:[255,192,203,1],plum:[221,160,221,1],powderblue:[176,224,230,1],purple:[128,0,128,1],rebeccapurple:[102,51,153,1],red:[255,0,0,1],rosybrown:[188,143,143,1],royalblue:[65,105,225,1],saddlebrown:[139,69,19,1],salmon:[250,128,114,1],sandybrown:[244,164,96,1],seagreen:[46,139,87,1],seashell:[255,245,238,1],sienna:[160,82,45,1],silver:[192,192,192,1],skyblue:[135,206,235,1],slateblue:[106,90,205,1],slategray:[112,128,144,1],slategrey:[112,128,144,1],snow:[255,250,250,1],springgreen:[0,255,127,1],steelblue:[70,130,180,1],tan:[210,180,140,1],teal:[0,128,128,1],thistle:[216,191,216,1],tomato:[255,99,71,1],turquoise:[64,224,208,1],violet:[238,130,238,1],wheat:[245,222,179,1],white:[255,255,255,1],whitesmoke:[245,245,245,1],yellow:[255,255,0,1],yellowgreen:[154,205,50,1]};function n(t){return (t=Math.round(t))<0?0:t>255?255:t}function i(t){return n("%"===t[t.length-1]?parseFloat(t)/100*255:parseInt(t))}function s(t){return (e="%"===t[t.length-1]?parseFloat(t)/100:parseFloat(t))<0?0:e>1?1:e;var e;}function a(t,e,r){return r<0?r+=1:r>1&&(r-=1),6*r<1?t+(e-t)*r*6:2*r<1?e:3*r<2?t+(e-t)*(2/3-r)*6:t}try{e.parseCSSColor=function(t){var e,o=t.replace(/ /g,"").toLowerCase();if(o in r)return r[o].slice();if("#"===o[0])return 4===o.length?(e=parseInt(o.substr(1),16))>=0&&e<=4095?[(3840&e)>>4|(3840&e)>>8,240&e|(240&e)>>4,15&e|(15&e)<<4,1]:null:7===o.length&&(e=parseInt(o.substr(1),16))>=0&&e<=16777215?[(16711680&e)>>16,(65280&e)>>8,255&e,1]:null;var l=o.indexOf("("),u=o.indexOf(")");if(-1!==l&&u+1===o.length){var c=o.substr(0,l),h=o.substr(l+1,u-(l+1)).split(","),p=1;switch(c){case"rgba":if(4!==h.length)return null;p=s(h.pop());case"rgb":return 3!==h.length?null:[i(h[0]),i(h[1]),i(h[2]),p];case"hsla":if(4!==h.length)return null;p=s(h.pop());case"hsl":if(3!==h.length)return null;var d=(parseFloat(h[0])%360+360)%360/360,f=s(h[1]),y=s(h[2]),m=y<=.5?y*(f+1):y+f-y*f,g=2*y-m;return [n(255*a(g,m,d+1/3)),n(255*a(g,m,d)),n(255*a(g,m,d-1/3)),p];default:return null}}return null};}catch(t){}}));class ce{constructor(t,e,r,n=1){this.r=t,this.g=e,this.b=r,this.a=n;}static parse(t){if(!t)return;if(t instanceof ce)return t;if("string"!=typeof t)return;const e=ue.parseCSSColor(t);return e?new ce(e[0]/255*e[3],e[1]/255*e[3],e[2]/255*e[3],e[3]):void 0}toString(){const[t,e,r,n]=this.toArray();return `rgba(${Math.round(t)},${Math.round(e)},${Math.round(r)},${n})`}toArray(){const{r:t,g:e,b:r,a:n}=this;return 0===n?[0,0,0,0]:[255*t/n,255*e/n,255*r/n,n]}}ce.black=new ce(0,0,0,1),ce.white=new ce(1,1,1,1),ce.transparent=new ce(0,0,0,0),ce.red=new ce(1,0,0,1),ce.blue=new ce(0,0,1,1);class he{constructor(t,e,r){this.sensitivity=t?e?"variant":"case":e?"accent":"base",this.locale=r,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"});}compare(t,e){return this.collator.compare(t,e)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}class pe{constructor(t,e,r,n,i){this.text=t,this.image=e,this.scale=r,this.fontStack=n,this.textColor=i;}}class de{constructor(t){this.sections=t;}static fromString(t){return new de([new pe(t,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((t=>0!==t.text.length||t.image&&0!==t.image.name.length))}static factory(t){return t instanceof de?t:de.fromString(t)}toString(){return 0===this.sections.length?"":this.sections.map((t=>t.text)).join("")}serialize(){const t=["format"];for(const e of this.sections){if(e.image){t.push(["image",e.image.name]);continue}t.push(e.text);const r={};e.fontStack&&(r["text-font"]=["literal",e.fontStack.split(",")]),e.scale&&(r["font-scale"]=e.scale),e.textColor&&(r["text-color"]=["rgba"].concat(e.textColor.toArray())),t.push(r);}return t}}class fe{constructor(t){this.name=t.name,this.available=t.available;}toString(){return this.name}static fromString(t){return t?new fe({name:t,available:!1}):null}serialize(){return ["image",this.name]}}function ye(t,e,r,n){return "number"==typeof t&&t>=0&&t<=255&&"number"==typeof e&&e>=0&&e<=255&&"number"==typeof r&&r>=0&&r<=255?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid rgba value [${[t,e,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function me(t){if(null===t)return !0;if("string"==typeof t)return !0;if("boolean"==typeof t)return !0;if("number"==typeof t)return !0;if(t instanceof ce)return !0;if(t instanceof he)return !0;if(t instanceof de)return !0;if(t instanceof fe)return !0;if(Array.isArray(t)){for(const e of t)if(!me(e))return !1;return !0}if("object"==typeof t){for(const e in t)if(!me(t[e]))return !1;return !0}return !1}function ge(t){if(null===t)return Zt;if("string"==typeof t)return Kt;if("boolean"==typeof t)return Ht;if("number"==typeof t)return Xt;if(t instanceof ce)return Yt;if(t instanceof he)return Qt;if(t instanceof de)return te;if(t instanceof fe)return ee;if(Array.isArray(t)){const e=t.length;let r;for(const e of t){const t=ge(e);if(r){if(r===t)continue;r=Wt;break}r=t;}return re(r||Wt,e)}return Jt}function xe(t){const e=typeof t;return null===t?"":"string"===e||"number"===e||"boolean"===e?String(t):t instanceof ce||t instanceof de||t instanceof fe?t.toString():JSON.stringify(t)}class ve{constructor(t,e){this.type=t,this.value=e;}static parse(t,e){if(2!==t.length)return e.error(`'literal' expression requires exactly one argument, but found ${t.length-1} instead.`);if(!me(t[1]))return e.error("invalid value");const r=t[1];let n=ge(r);const i=e.expectedType;return "array"!==n.kind||0!==n.N||!i||"array"!==i.kind||"number"==typeof i.N&&0!==i.N||(n=i),new ve(n,r)}evaluate(){return this.value}eachChild(){}outputDefined(){return !0}serialize(){return "array"===this.type.kind||"object"===this.type.kind?["literal",this.value]:this.value instanceof ce?["rgba"].concat(this.value.toArray()):this.value instanceof de?this.value.serialize():this.value}}class be{constructor(t){this.name="ExpressionEvaluationError",this.message=t;}toJSON(){return this.message}}const we={string:Kt,number:Xt,boolean:Ht,object:Jt};class _e{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r,n=1;const i=t[0];if("array"===i){let i,s;if(t.length>2){const r=t[1];if("string"!=typeof r||!(r in we)||"object"===r)return e.error('The item type argument of "array" must be one of string, number, boolean',1);i=we[r],n++;}else i=Wt;if(t.length>3){if(null!==t[2]&&("number"!=typeof t[2]||t[2]<0||t[2]!==Math.floor(t[2])))return e.error('The length argument to "array" must be a positive integer literal',2);s=t[2],n++;}r=re(i,s);}else r=we[i];const s=[];for(;n<t.length;n++){const r=e.parse(t[n],n,Wt);if(!r)return null;s.push(r);}return new _e(r,s)}evaluate(t){for(let e=0;e<this.args.length;e++){const r=this.args[e].evaluate(t);if(!se(this.type,ge(r)))return r;if(e===this.args.length-1)throw new be(`Expected value to be of type ${ne(this.type)}, but found ${ne(ge(r))} instead.`)}return null}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){const t=this.type,e=[t.kind];if("array"===t.kind){const r=t.itemType;if("string"===r.kind||"number"===r.kind||"boolean"===r.kind){e.push(r.kind);const n=t.N;("number"==typeof n||this.args.length>1)&&e.push(n);}}return e.concat(this.args.map((t=>t.serialize())))}}class ke{constructor(t){this.type=te,this.sections=t;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[1];if(!Array.isArray(r)&&"object"==typeof r)return e.error("First argument must be an image or text section.");const n=[];let i=!1;for(let r=1;r<=t.length-1;++r){const s=t[r];if(i&&"object"==typeof s&&!Array.isArray(s)){i=!1;let t=null;if(s["font-scale"]&&(t=e.parse(s["font-scale"],1,Xt),!t))return null;let r=null;if(s["text-font"]&&(r=e.parse(s["text-font"],1,re(Kt)),!r))return null;let a=null;if(s["text-color"]&&(a=e.parse(s["text-color"],1,Yt),!a))return null;const o=n[n.length-1];o.scale=t,o.font=r,o.textColor=a;}else {const s=e.parse(t[r],1,Wt);if(!s)return null;const a=s.type.kind;if("string"!==a&&"value"!==a&&"null"!==a&&"resolvedImage"!==a)return e.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");i=!0,n.push({content:s,scale:null,font:null,textColor:null});}}return new ke(n)}evaluate(t){return new de(this.sections.map((e=>{const r=e.content.evaluate(t);return ge(r)===ee?new pe("",r,null,null,null):new pe(xe(r),null,e.scale?e.scale.evaluate(t):null,e.font?e.font.evaluate(t).join(","):null,e.textColor?e.textColor.evaluate(t):null)})))}eachChild(t){for(const e of this.sections)t(e.content),e.scale&&t(e.scale),e.font&&t(e.font),e.textColor&&t(e.textColor);}outputDefined(){return !1}serialize(){const t=["format"];for(const e of this.sections){t.push(e.content.serialize());const r={};e.scale&&(r["font-scale"]=e.scale.serialize()),e.font&&(r["text-font"]=e.font.serialize()),e.textColor&&(r["text-color"]=e.textColor.serialize()),t.push(r);}return t}}class Ae{constructor(t){this.type=ee,this.input=t;}static parse(t,e){if(2!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,Kt);return r?new Ae(r):e.error("No image name provided.")}evaluate(t){const e=this.input.evaluate(t),r=fe.fromString(e);return r&&t.availableImages&&(r.available=t.availableImages.indexOf(e)>-1),r}eachChild(t){t(this.input);}outputDefined(){return !1}serialize(){return ["image",this.input.serialize()]}}const Se={"to-boolean":Ht,"to-color":Yt,"to-number":Xt,"to-string":Kt};class Ie{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[0];if(("to-boolean"===r||"to-string"===r)&&2!==t.length)return e.error("Expected one argument.");const n=Se[r],i=[];for(let r=1;r<t.length;r++){const n=e.parse(t[r],r,Wt);if(!n)return null;i.push(n);}return new Ie(n,i)}evaluate(t){if("boolean"===this.type.kind)return Boolean(this.args[0].evaluate(t));if("color"===this.type.kind){let e,r;for(const n of this.args){if(e=n.evaluate(t),r=null,e instanceof ce)return e;if("string"==typeof e){const r=t.parseColor(e);if(r)return r}else if(Array.isArray(e)&&(r=e.length<3||e.length>4?`Invalid rbga value ${JSON.stringify(e)}: expected an array containing either three or four numeric values.`:ye(e[0],e[1],e[2],e[3]),!r))return new ce(e[0]/255,e[1]/255,e[2]/255,e[3])}throw new be(r||`Could not parse color from value '${"string"==typeof e?e:String(JSON.stringify(e))}'`)}if("number"===this.type.kind){let e=null;for(const r of this.args){if(e=r.evaluate(t),null===e)return 0;const n=Number(e);if(!isNaN(n))return n}throw new be(`Could not convert ${JSON.stringify(e)} to number.`)}return "formatted"===this.type.kind?de.fromString(xe(this.args[0].evaluate(t))):"resolvedImage"===this.type.kind?fe.fromString(xe(this.args[0].evaluate(t))):xe(this.args[0].evaluate(t))}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){if("formatted"===this.type.kind)return new ke([{content:this.args[0],scale:null,font:null,textColor:null}]).serialize();if("resolvedImage"===this.type.kind)return new Ae(this.args[0]).serialize();const t=[`to-${this.type.kind}`];return this.eachChild((e=>{t.push(e.serialize());})),t}}const ze=["Unknown","Point","LineString","Polygon"];class Te{constructor(){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache={},this.availableImages=null,this.canonical=null;}id(){return this.feature&&"id"in this.feature?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?ze[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}parseColor(t){let e=this._parseColorCache[t];return e||(e=this._parseColorCache[t]=ce.parse(t)),e}}class Me{constructor(t,e,r,n){this.name=t,this.type=e,this._evaluate=r,this.args=n;}evaluate(t){return this._evaluate(t,this.args)}eachChild(t){this.args.forEach(t);}outputDefined(){return !1}serialize(){return [this.name].concat(this.args.map((t=>t.serialize())))}static parse(t,e){const r=t[0],n=Me.definitions[r];if(!n)return e.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0);const i=Array.isArray(n)?n[0]:n.type,s=Array.isArray(n)?[[n[1],n[2]]]:n.overloads,a=s.filter((([e])=>!Array.isArray(e)||e.length===t.length-1));let o=null;for(const[n,s]of a){o=new We(e.registry,e.path,null,e.scope);const a=[];let l=!1;for(let e=1;e<t.length;e++){const r=t[e],i=Array.isArray(n)?n[e-1]:n.type,s=o.parse(r,1+a.length,i);if(!s){l=!0;break}a.push(s);}if(!l)if(Array.isArray(n)&&n.length!==a.length)o.error(`Expected ${n.length} arguments, but found ${a.length} instead.`);else {for(let t=0;t<a.length;t++){const e=Array.isArray(n)?n[t]:n.type,r=a[t];o.concat(t+1).checkSubtype(e,r.type);}if(0===o.errors.length)return new Me(r,i,s,a)}}if(1===a.length)e.errors.push(...o.errors);else {const r=(a.length?a:s).map((([t])=>{return e=t,Array.isArray(e)?`(${e.map(ne).join(", ")})`:`(${ne(e.type)}...)`;var e;})).join(" | "),n=[];for(let r=1;r<t.length;r++){const i=e.parse(t[r],1+n.length);if(!i)return null;n.push(ne(i.type));}e.error(`Expected arguments of type ${r}, but found (${n.join(", ")}) instead.`);}return null}static register(t,e){Me.definitions=e;for(const r in e)t[r]=Me;}}class Ee{constructor(t,e,r){this.type=Qt,this.locale=r,this.caseSensitive=t,this.diacriticSensitive=e;}static parse(t,e){if(2!==t.length)return e.error("Expected one argument.");const r=t[1];if("object"!=typeof r||Array.isArray(r))return e.error("Collator options argument must be an object.");const n=e.parse(void 0!==r["case-sensitive"]&&r["case-sensitive"],1,Ht);if(!n)return null;const i=e.parse(void 0!==r["diacritic-sensitive"]&&r["diacritic-sensitive"],1,Ht);if(!i)return null;let s=null;return r.locale&&(s=e.parse(r.locale,1,Kt),!s)?null:new Ee(n,i,s)}evaluate(t){return new he(this.caseSensitive.evaluate(t),this.diacriticSensitive.evaluate(t),this.locale?this.locale.evaluate(t):null)}eachChild(t){t(this.caseSensitive),t(this.diacriticSensitive),this.locale&&t(this.locale);}outputDefined(){return !1}serialize(){const t={};return t["case-sensitive"]=this.caseSensitive.serialize(),t["diacritic-sensitive"]=this.diacriticSensitive.serialize(),this.locale&&(t.locale=this.locale.serialize()),["collator",t]}}const Be=8192;function Ce(t,e){t[0]=Math.min(t[0],e[0]),t[1]=Math.min(t[1],e[1]),t[2]=Math.max(t[2],e[0]),t[3]=Math.max(t[3],e[1]);}function Pe(t,e){return !(t[0]<=e[0]||t[2]>=e[2]||t[1]<=e[1]||t[3]>=e[3])}function Ve(t,e){const r=(180+t[0])/360,n=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t[1]*Math.PI/360)))/360,i=Math.pow(2,e.z);return [Math.round(r*i*Be),Math.round(n*i*Be)]}function De(t,e,r){const n=t[0]-e[0],i=t[1]-e[1],s=t[0]-r[0],a=t[1]-r[1];return n*a-s*i==0&&n*s<=0&&i*a<=0}function Fe(t,e){let r=!1;for(let a=0,o=e.length;a<o;a++){const o=e[a];for(let e=0,a=o.length;e<a-1;e++){if(De(t,o[e],o[e+1]))return !1;(i=o[e])[1]>(n=t)[1]!=(s=o[e+1])[1]>n[1]&&n[0]<(s[0]-i[0])*(n[1]-i[1])/(s[1]-i[1])+i[0]&&(r=!r);}}var n,i,s;return r}function Le(t,e){for(let r=0;r<e.length;r++)if(Fe(t,e[r]))return !0;return !1}function Re(t,e,r,n){const i=n[0]-r[0],s=n[1]-r[1],a=(t[0]-r[0])*s-i*(t[1]-r[1]),o=(e[0]-r[0])*s-i*(e[1]-r[1]);return a>0&&o<0||a<0&&o>0}function Ue(t,e,r){for(const u of r)for(let r=0;r<u.length-1;++r)if(0!=(o=[(a=u[r+1])[0]-(s=u[r])[0],a[1]-s[1]])[0]*(l=[(i=e)[0]-(n=t)[0],i[1]-n[1]])[1]-o[1]*l[0]&&Re(n,i,s,a)&&Re(s,a,n,i))return !0;var n,i,s,a,o,l;return !1}function $e(t,e){for(let r=0;r<t.length;++r)if(!Fe(t[r],e))return !1;for(let r=0;r<t.length-1;++r)if(Ue(t[r],t[r+1],e))return !1;return !0}function Oe(t,e){for(let r=0;r<e.length;r++)if($e(t,e[r]))return !0;return !1}function qe(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=[];for(let n=0;n<t[i].length;n++){const a=Ve(t[i][n],r);Ce(e,a),s.push(a);}n.push(s);}return n}function Ne(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=qe(t[i],e,r);n.push(s);}return n}function je(t,e,r,n){if(t[0]<r[0]||t[0]>r[2]){const e=.5*n;let i=t[0]-r[0]>e?-n:r[0]-t[0]>e?n:0;0===i&&(i=t[0]-r[2]>e?-n:r[2]-t[0]>e?n:0),t[0]+=i;}Ce(e,t);}function Ge(t,e,r,n){const i=Math.pow(2,n.z)*Be,s=[n.x*Be,n.y*Be],a=[];for(const n of t)for(const t of n){const n=[t.x+s[0],t.y+s[1]];je(n,e,r,i),a.push(n);}return a}function Ze(t,e,r,n){const i=Math.pow(2,n.z)*Be,s=[n.x*Be,n.y*Be],a=[];for(const r of t){const t=[];for(const n of r){const r=[n.x+s[0],n.y+s[1]];Ce(e,r),t.push(r);}a.push(t);}if(e[2]-e[0]<=i/2){(o=e)[0]=o[1]=1/0,o[2]=o[3]=-1/0;for(const t of a)for(const n of t)je(n,e,r,i);}var o;return a}class Xe{constructor(t,e){this.type=Ht,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'within' expression requires exactly one argument, but found ${t.length-1} instead.`);if(me(t[1])){const e=t[1];if("FeatureCollection"===e.type)for(let t=0;t<e.features.length;++t){const r=e.features[t].geometry.type;if("Polygon"===r||"MultiPolygon"===r)return new Xe(e,e.features[t].geometry)}else if("Feature"===e.type){const t=e.geometry.type;if("Polygon"===t||"MultiPolygon"===t)return new Xe(e,e.geometry)}else if("Polygon"===e.type||"MultiPolygon"===e.type)return new Xe(e,e)}return e.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if("Polygon"===e.type){const s=qe(e.coordinates,n,i),a=Ge(t.geometry(),r,n,i);if(!Pe(r,n))return !1;for(const t of a)if(!Fe(t,s))return !1}if("MultiPolygon"===e.type){const s=Ne(e.coordinates,n,i),a=Ge(t.geometry(),r,n,i);if(!Pe(r,n))return !1;for(const t of a)if(!Le(t,s))return !1}return !0}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if("Polygon"===e.type){const s=qe(e.coordinates,n,i),a=Ze(t.geometry(),r,n,i);if(!Pe(r,n))return !1;for(const t of a)if(!$e(t,s))return !1}if("MultiPolygon"===e.type){const s=Ne(e.coordinates,n,i),a=Ze(t.geometry(),r,n,i);if(!Pe(r,n))return !1;for(const t of a)if(!Oe(t,s))return !1}return !0}(t,this.geometries)}return !1}eachChild(){}outputDefined(){return !0}serialize(){return ["within",this.geojson]}}function Ke(t){if(t instanceof Me){if("get"===t.name&&1===t.args.length)return !1;if("feature-state"===t.name)return !1;if("has"===t.name&&1===t.args.length)return !1;if("properties"===t.name||"geometry-type"===t.name||"id"===t.name)return !1;if(/^filter-/.test(t.name))return !1}if(t instanceof Xe)return !1;let e=!0;return t.eachChild((t=>{e&&!Ke(t)&&(e=!1);})),e}function He(t){if(t instanceof Me&&"feature-state"===t.name)return !1;let e=!0;return t.eachChild((t=>{e&&!He(t)&&(e=!1);})),e}function Ye(t,e){if(t instanceof Me&&e.indexOf(t.name)>=0)return !1;let r=!0;return t.eachChild((t=>{r&&!Ye(t,e)&&(r=!1);})),r}class Je{constructor(t,e){this.type=e.type,this.name=t,this.boundExpression=e;}static parse(t,e){if(2!==t.length||"string"!=typeof t[1])return e.error("'var' expression requires exactly one string literal argument.");const r=t[1];return e.scope.has(r)?new Je(r,e.scope.get(r)):e.error(`Unknown variable "${r}". Make sure "${r}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(t){return this.boundExpression.evaluate(t)}eachChild(){}outputDefined(){return !1}serialize(){return ["var",this.name]}}class We{constructor(t,e=[],r,n=new Gt,i=[]){this.registry=t,this.path=e,this.key=e.map((t=>`[${t}]`)).join(""),this.scope=n,this.errors=i,this.expectedType=r;}parse(t,e,r,n,i={}){return e?this.concat(e,r,n)._parse(t,i):this._parse(t,i)}_parse(t,e){function r(t,e,r){return "assert"===r?new _e(e,[t]):"coerce"===r?new Ie(e,[t]):t}if(null!==t&&"string"!=typeof t&&"boolean"!=typeof t&&"number"!=typeof t||(t=["literal",t]),Array.isArray(t)){if(0===t.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const n=t[0];if("string"!=typeof n)return this.error(`Expression name must be a string, but found ${typeof n} instead. If you wanted a literal array, use ["literal", [...]].`,0),null;const i=this.registry[n];if(i){let n=i.parse(t,this);if(!n)return null;if(this.expectedType){const t=this.expectedType,i=n.type;if("string"!==t.kind&&"number"!==t.kind&&"boolean"!==t.kind&&"object"!==t.kind&&"array"!==t.kind||"value"!==i.kind)if("color"!==t.kind&&"formatted"!==t.kind&&"resolvedImage"!==t.kind||"value"!==i.kind&&"string"!==i.kind){if(this.checkSubtype(t,i))return null}else n=r(n,t,e.typeAnnotation||"coerce");else n=r(n,t,e.typeAnnotation||"assert");}if(!(n instanceof ve)&&"resolvedImage"!==n.type.kind&&Qe(n)){const t=new Te;try{n=new ve(n.type,n.evaluate(t));}catch(t){return this.error(t.message),null}}return n}return this.error(`Unknown expression "${n}". If you wanted a literal array, use ["literal", [...]].`,0)}return this.error(void 0===t?"'undefined' value invalid. Use null instead.":"object"==typeof t?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof t} instead.`)}concat(t,e,r){const n="number"==typeof t?this.path.concat(t):this.path,i=r?this.scope.concat(r):this.scope;return new We(this.registry,n,e||null,i,this.errors)}error(t,...e){const r=`${this.key}${e.map((t=>`[${t}]`)).join("")}`;this.errors.push(new jt(r,t));}checkSubtype(t,e){const r=se(t,e);return r&&this.error(r),r}}function Qe(t){if(t instanceof Je)return Qe(t.boundExpression);if(t instanceof Me&&"error"===t.name)return !1;if(t instanceof Ee)return !1;if(t instanceof Xe)return !1;const e=t instanceof Ie||t instanceof _e;let r=!0;return t.eachChild((t=>{r=e?r&&Qe(t):r&&t instanceof ve;})),!!r&&Ke(t)&&Ye(t,["zoom","heatmap-density","line-progress","sky-radial-progress","accumulated","is-supported-script"])}function tr(t,e){const r=t.length-1;let n,i,s=0,a=r,o=0;for(;s<=a;)if(o=Math.floor((s+a)/2),n=t[o],i=t[o+1],n<=e){if(o===r||e<i)return o;s=o+1;}else {if(!(n>e))throw new be("Input is not a number.");a=o-1;}return 0}class er{constructor(t,e,r){this.type=t,this.input=e,this.labels=[],this.outputs=[];for(const[t,e]of r)this.labels.push(t),this.outputs.push(e);}static parse(t,e){if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");const r=e.parse(t[1],1,Xt);if(!r)return null;const n=[];let i=null;e.expectedType&&"value"!==e.expectedType.kind&&(i=e.expectedType);for(let r=1;r<t.length;r+=2){const s=1===r?-1/0:t[r],a=t[r+1],o=r,l=r+1;if("number"!=typeof s)return e.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',o);if(n.length&&n[n.length-1][0]>=s)return e.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',o);const u=e.parse(a,l,i);if(!u)return null;i=i||u.type,n.push([s,u]);}return new er(i,r,n)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;return n>=e[i-1]?r[i-1].evaluate(t):r[tr(e,n)].evaluate(t)}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}serialize(){const t=["step",this.input.serialize()];for(let e=0;e<this.labels.length;e++)e>0&&t.push(this.labels[e]),t.push(this.outputs[e].serialize());return t}}function rr(t,e,r){return t*(1-r)+e*r}var nr=Object.freeze({__proto__:null,number:rr,color:function(t,e,r){return new ce(rr(t.r,e.r,r),rr(t.g,e.g,r),rr(t.b,e.b,r),rr(t.a,e.a,r))},array:function(t,e,r){return t.map(((t,n)=>rr(t,e[n],r)))}});const ir=.95047,sr=1.08883,ar=4/29,or=6/29,lr=3*or*or,ur=Math.PI/180,cr=180/Math.PI;function hr(t){return t>.008856451679035631?Math.pow(t,1/3):t/lr+ar}function pr(t){return t>or?t*t*t:lr*(t-ar)}function dr(t){return 255*(t<=.0031308?12.92*t:1.055*Math.pow(t,1/2.4)-.055)}function fr(t){return (t/=255)<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function yr(t){const e=fr(t.r),r=fr(t.g),n=fr(t.b),i=hr((.4124564*e+.3575761*r+.1804375*n)/ir),s=hr((.2126729*e+.7151522*r+.072175*n)/1);return {l:116*s-16,a:500*(i-s),b:200*(s-hr((.0193339*e+.119192*r+.9503041*n)/sr)),alpha:t.a}}function mr(t){let e=(t.l+16)/116,r=isNaN(t.a)?e:e+t.a/500,n=isNaN(t.b)?e:e-t.b/200;return e=1*pr(e),r=ir*pr(r),n=sr*pr(n),new ce(dr(3.2404542*r-1.5371385*e-.4985314*n),dr(-.969266*r+1.8760108*e+.041556*n),dr(.0556434*r-.2040259*e+1.0572252*n),t.alpha)}function gr(t,e,r){const n=e-t;return t+r*(n>180||n<-180?n-360*Math.round(n/360):n)}const xr={forward:yr,reverse:mr,interpolate:function(t,e,r){return {l:rr(t.l,e.l,r),a:rr(t.a,e.a,r),b:rr(t.b,e.b,r),alpha:rr(t.alpha,e.alpha,r)}}},vr={forward:function(t){const{l:e,a:r,b:n}=yr(t),i=Math.atan2(n,r)*cr;return {h:i<0?i+360:i,c:Math.sqrt(r*r+n*n),l:e,alpha:t.a}},reverse:function(t){const e=t.h*ur,r=t.c;return mr({l:t.l,a:Math.cos(e)*r,b:Math.sin(e)*r,alpha:t.alpha})},interpolate:function(t,e,r){return {h:gr(t.h,e.h,r),c:rr(t.c,e.c,r),l:rr(t.l,e.l,r),alpha:rr(t.alpha,e.alpha,r)}}};var br=Object.freeze({__proto__:null,lab:xr,hcl:vr});class wr{constructor(t,e,r,n,i){this.type=t,this.operator=e,this.interpolation=r,this.input=n,this.labels=[],this.outputs=[];for(const[t,e]of i)this.labels.push(t),this.outputs.push(e);}static interpolationFactor(t,e,n,i){let s=0;if("exponential"===t.name)s=_r(e,t.base,n,i);else if("linear"===t.name)s=_r(e,1,n,i);else if("cubic-bezier"===t.name){const a=t.controlPoints;s=new r(a[0],a[1],a[2],a[3]).solve(_r(e,1,n,i));}return s}static parse(t,e){let[r,n,i,...s]=t;if(!Array.isArray(n)||0===n.length)return e.error("Expected an interpolation type expression.",1);if("linear"===n[0])n={name:"linear"};else if("exponential"===n[0]){const t=n[1];if("number"!=typeof t)return e.error("Exponential interpolation requires a numeric base.",1,1);n={name:"exponential",base:t};}else {if("cubic-bezier"!==n[0])return e.error(`Unknown interpolation type ${String(n[0])}`,1,0);{const t=n.slice(1);if(4!==t.length||t.some((t=>"number"!=typeof t||t<0||t>1)))return e.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);n={name:"cubic-bezier",controlPoints:t};}}if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");if(i=e.parse(i,2,Xt),!i)return null;const a=[];let o=null;"interpolate-hcl"===r||"interpolate-lab"===r?o=Yt:e.expectedType&&"value"!==e.expectedType.kind&&(o=e.expectedType);for(let t=0;t<s.length;t+=2){const r=s[t],n=s[t+1],i=t+3,l=t+4;if("number"!=typeof r)return e.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',i);if(a.length&&a[a.length-1][0]>=r)return e.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',i);const u=e.parse(n,l,o);if(!u)return null;o=o||u.type,a.push([r,u]);}return "number"===o.kind||"color"===o.kind||"array"===o.kind&&"number"===o.itemType.kind&&"number"==typeof o.N?new wr(o,r,n,i,a):e.error(`Type ${ne(o)} is not interpolatable.`)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;if(n>=e[i-1])return r[i-1].evaluate(t);const s=tr(e,n),a=wr.interpolationFactor(this.interpolation,n,e[s],e[s+1]),o=r[s].evaluate(t),l=r[s+1].evaluate(t);return "interpolate"===this.operator?nr[this.type.kind.toLowerCase()](o,l,a):"interpolate-hcl"===this.operator?vr.reverse(vr.interpolate(vr.forward(o),vr.forward(l),a)):xr.reverse(xr.interpolate(xr.forward(o),xr.forward(l),a))}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}serialize(){let t;t="linear"===this.interpolation.name?["linear"]:"exponential"===this.interpolation.name?1===this.interpolation.base?["linear"]:["exponential",this.interpolation.base]:["cubic-bezier"].concat(this.interpolation.controlPoints);const e=[this.operator,t,this.input.serialize()];for(let t=0;t<this.labels.length;t++)e.push(this.labels[t],this.outputs[t].serialize());return e}}function _r(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}class kr{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expectected at least one argument.");let r=null;const n=e.expectedType;n&&"value"!==n.kind&&(r=n);const i=[];for(const n of t.slice(1)){const t=e.parse(n,1+i.length,r,void 0,{typeAnnotation:"omit"});if(!t)return null;r=r||t.type,i.push(t);}const s=n&&i.some((t=>se(n,t.type)));return new kr(s?Wt:r,i)}evaluate(t){let e,r=null,n=0;for(const i of this.args)if(n++,r=i.evaluate(t),r&&r instanceof fe&&!r.available&&(e||(e=r.name),r=null,n===this.args.length&&(r=e)),null!==r)break;return r}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){const t=["coalesce"];return this.eachChild((e=>{t.push(e.serialize());})),t}}class Ar{constructor(t,e){this.type=e.type,this.bindings=[].concat(t),this.result=e;}evaluate(t){return this.result.evaluate(t)}eachChild(t){for(const e of this.bindings)t(e[1]);t(this.result);}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found ${t.length-1} instead.`);const r=[];for(let n=1;n<t.length-1;n+=2){const i=t[n];if("string"!=typeof i)return e.error(`Expected string, but found ${typeof i} instead.`,n);if(/[^a-zA-Z0-9_]/.test(i))return e.error("Variable names must contain only alphanumeric characters or '_'.",n);const s=e.parse(t[n+1],n+1);if(!s)return null;r.push([i,s]);}const n=e.parse(t[t.length-1],t.length-1,e.expectedType,r);return n?new Ar(r,n):null}outputDefined(){return this.result.outputDefined()}serialize(){const t=["let"];for(const[e,r]of this.bindings)t.push(e,r.serialize());return t.push(this.result.serialize()),t}}class Sr{constructor(t,e,r){this.type=t,this.index=e,this.input=r;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Xt),n=e.parse(t[2],2,re(e.expectedType||Wt));return r&&n?new Sr(n.type.itemType,r,n):null}evaluate(t){const e=this.index.evaluate(t),r=this.input.evaluate(t);if(e<0)throw new be(`Array index out of bounds: ${e} < 0.`);if(e>=r.length)throw new be(`Array index out of bounds: ${e} > ${r.length-1}.`);if(e!==Math.floor(e))throw new be(`Array index must be an integer, but found ${e} instead.`);return r[e]}eachChild(t){t(this.index),t(this.input);}outputDefined(){return !1}serialize(){return ["at",this.index.serialize(),this.input.serialize()]}}class Ir{constructor(t,e){this.type=Ht,this.needle=t,this.haystack=e;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Wt),n=e.parse(t[2],2,Wt);return r&&n?ae(r.type,[Ht,Kt,Xt,Zt,Wt])?new Ir(r,n):e.error(`Expected first argument to be of type boolean, string, number or null, but found ${ne(r.type)} instead`):null}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!r)return !1;if(!oe(e,["boolean","string","number","null"]))throw new be(`Expected first argument to be of type boolean, string, number or null, but found ${ne(ge(e))} instead.`);if(!oe(r,["string","array"]))throw new be(`Expected second argument to be of type array or string, but found ${ne(ge(r))} instead.`);return r.indexOf(e)>=0}eachChild(t){t(this.needle),t(this.haystack);}outputDefined(){return !0}serialize(){return ["in",this.needle.serialize(),this.haystack.serialize()]}}class zr{constructor(t,e,r){this.type=Xt,this.needle=t,this.haystack=e,this.fromIndex=r;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Wt),n=e.parse(t[2],2,Wt);if(!r||!n)return null;if(!ae(r.type,[Ht,Kt,Xt,Zt,Wt]))return e.error(`Expected first argument to be of type boolean, string, number or null, but found ${ne(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,Xt);return i?new zr(r,n,i):null}return new zr(r,n)}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!oe(e,["boolean","string","number","null"]))throw new be(`Expected first argument to be of type boolean, string, number or null, but found ${ne(ge(e))} instead.`);if(!oe(r,["string","array"]))throw new be(`Expected second argument to be of type array or string, but found ${ne(ge(r))} instead.`);if(this.fromIndex){const n=this.fromIndex.evaluate(t);return r.indexOf(e,n)}return r.indexOf(e)}eachChild(t){t(this.needle),t(this.haystack),this.fromIndex&&t(this.fromIndex);}outputDefined(){return !1}serialize(){if(null!=this.fromIndex&&void 0!==this.fromIndex){const t=this.fromIndex.serialize();return ["index-of",this.needle.serialize(),this.haystack.serialize(),t]}return ["index-of",this.needle.serialize(),this.haystack.serialize()]}}class Tr{constructor(t,e,r,n,i,s){this.inputType=t,this.type=e,this.input=r,this.cases=n,this.outputs=i,this.otherwise=s;}static parse(t,e){if(t.length<5)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length%2!=1)return e.error("Expected an even number of arguments.");let r,n;e.expectedType&&"value"!==e.expectedType.kind&&(n=e.expectedType);const i={},s=[];for(let a=2;a<t.length-1;a+=2){let o=t[a];const l=t[a+1];Array.isArray(o)||(o=[o]);const u=e.concat(a);if(0===o.length)return u.error("Expected at least one branch label.");for(const t of o){if("number"!=typeof t&&"string"!=typeof t)return u.error("Branch labels must be numbers or strings.");if("number"==typeof t&&Math.abs(t)>Number.MAX_SAFE_INTEGER)return u.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof t&&Math.floor(t)!==t)return u.error("Numeric branch labels must be integer values.");if(r){if(u.checkSubtype(r,ge(t)))return null}else r=ge(t);if(void 0!==i[String(t)])return u.error("Branch labels must be unique.");i[String(t)]=s.length;}const c=e.parse(l,a,n);if(!c)return null;n=n||c.type,s.push(c);}const a=e.parse(t[1],1,Wt);if(!a)return null;const o=e.parse(t[t.length-1],t.length-1,n);return o?"value"!==a.type.kind&&e.concat(1).checkSubtype(r,a.type)?null:new Tr(r,n,a,i,s,o):null}evaluate(t){const e=this.input.evaluate(t);return (ge(e)===this.inputType&&this.outputs[this.cases[e]]||this.otherwise).evaluate(t)}eachChild(t){t(this.input),this.outputs.forEach(t),t(this.otherwise);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))&&this.otherwise.outputDefined()}serialize(){const t=["match",this.input.serialize()],e=Object.keys(this.cases).sort(),r=[],n={};for(const t of e){const e=n[this.cases[t]];void 0===e?(n[this.cases[t]]=r.length,r.push([this.cases[t],[t]])):r[e][1].push(t);}const i=t=>"number"===this.inputType.kind?Number(t):t;for(const[e,n]of r)t.push(1===n.length?i(n[0]):n.map(i)),t.push(this.outputs[e].serialize());return t.push(this.otherwise.serialize()),t}}class Mr{constructor(t,e,r){this.type=t,this.branches=e,this.otherwise=r;}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length%2!=0)return e.error("Expected an odd number of arguments.");let r;e.expectedType&&"value"!==e.expectedType.kind&&(r=e.expectedType);const n=[];for(let i=1;i<t.length-1;i+=2){const s=e.parse(t[i],i,Ht);if(!s)return null;const a=e.parse(t[i+1],i+1,r);if(!a)return null;n.push([s,a]),r=r||a.type;}const i=e.parse(t[t.length-1],t.length-1,r);return i?new Mr(r,n,i):null}evaluate(t){for(const[e,r]of this.branches)if(e.evaluate(t))return r.evaluate(t);return this.otherwise.evaluate(t)}eachChild(t){for(const[e,r]of this.branches)t(e),t(r);t(this.otherwise);}outputDefined(){return this.branches.every((([t,e])=>e.outputDefined()))&&this.otherwise.outputDefined()}serialize(){const t=["case"];return this.eachChild((e=>{t.push(e.serialize());})),t}}class Er{constructor(t,e,r,n){this.type=t,this.input=e,this.beginIndex=r,this.endIndex=n;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Wt),n=e.parse(t[2],2,Xt);if(!r||!n)return null;if(!ae(r.type,[re(Wt),Kt,Wt]))return e.error(`Expected first argument to be of type array or string, but found ${ne(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,Xt);return i?new Er(r.type,r,n,i):null}return new Er(r.type,r,n)}evaluate(t){const e=this.input.evaluate(t),r=this.beginIndex.evaluate(t);if(!oe(e,["string","array"]))throw new be(`Expected first argument to be of type array or string, but found ${ne(ge(e))} instead.`);if(this.endIndex){const n=this.endIndex.evaluate(t);return e.slice(r,n)}return e.slice(r)}eachChild(t){t(this.input),t(this.beginIndex),this.endIndex&&t(this.endIndex);}outputDefined(){return !1}serialize(){if(null!=this.endIndex&&void 0!==this.endIndex){const t=this.endIndex.serialize();return ["slice",this.input.serialize(),this.beginIndex.serialize(),t]}return ["slice",this.input.serialize(),this.beginIndex.serialize()]}}function Br(t,e){return "=="===t||"!="===t?"boolean"===e.kind||"string"===e.kind||"number"===e.kind||"null"===e.kind||"value"===e.kind:"string"===e.kind||"number"===e.kind||"value"===e.kind}function Cr(t,e,r,n){return 0===n.compare(e,r)}function Pr(t,e,r){const n="=="!==t&&"!="!==t;return class i{constructor(t,e,r){this.type=Ht,this.lhs=t,this.rhs=e,this.collator=r,this.hasUntypedArgument="value"===t.type.kind||"value"===e.type.kind;}static parse(t,e){if(3!==t.length&&4!==t.length)return e.error("Expected two or three arguments.");const r=t[0];let s=e.parse(t[1],1,Wt);if(!s)return null;if(!Br(r,s.type))return e.concat(1).error(`"${r}" comparisons are not supported for type '${ne(s.type)}'.`);let a=e.parse(t[2],2,Wt);if(!a)return null;if(!Br(r,a.type))return e.concat(2).error(`"${r}" comparisons are not supported for type '${ne(a.type)}'.`);if(s.type.kind!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return e.error(`Cannot compare types '${ne(s.type)}' and '${ne(a.type)}'.`);n&&("value"===s.type.kind&&"value"!==a.type.kind?s=new _e(a.type,[s]):"value"!==s.type.kind&&"value"===a.type.kind&&(a=new _e(s.type,[a])));let o=null;if(4===t.length){if("string"!==s.type.kind&&"string"!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return e.error("Cannot use collator to compare non-string types.");if(o=e.parse(t[3],3,Qt),!o)return null}return new i(s,a,o)}evaluate(i){const s=this.lhs.evaluate(i),a=this.rhs.evaluate(i);if(n&&this.hasUntypedArgument){const e=ge(s),r=ge(a);if(e.kind!==r.kind||"string"!==e.kind&&"number"!==e.kind)throw new be(`Expected arguments for "${t}" to be (string, string) or (number, number), but found (${e.kind}, ${r.kind}) instead.`)}if(this.collator&&!n&&this.hasUntypedArgument){const t=ge(s),r=ge(a);if("string"!==t.kind||"string"!==r.kind)return e(i,s,a)}return this.collator?r(i,s,a,this.collator.evaluate(i)):e(i,s,a)}eachChild(t){t(this.lhs),t(this.rhs),this.collator&&t(this.collator);}outputDefined(){return !0}serialize(){const e=[t];return this.eachChild((t=>{e.push(t.serialize());})),e}}}const Vr=Pr("==",(function(t,e,r){return e===r}),Cr),Dr=Pr("!=",(function(t,e,r){return e!==r}),(function(t,e,r,n){return !Cr(0,e,r,n)})),Fr=Pr("<",(function(t,e,r){return e<r}),(function(t,e,r,n){return n.compare(e,r)<0})),Lr=Pr(">",(function(t,e,r){return e>r}),(function(t,e,r,n){return n.compare(e,r)>0})),Rr=Pr("<=",(function(t,e,r){return e<=r}),(function(t,e,r,n){return n.compare(e,r)<=0})),Ur=Pr(">=",(function(t,e,r){return e>=r}),(function(t,e,r,n){return n.compare(e,r)>=0}));class $r{constructor(t,e,r,n,i){this.type=Kt,this.number=t,this.locale=e,this.currency=r,this.minFractionDigits=n,this.maxFractionDigits=i;}static parse(t,e){if(3!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,Xt);if(!r)return null;const n=t[2];if("object"!=typeof n||Array.isArray(n))return e.error("NumberFormat options argument must be an object.");let i=null;if(n.locale&&(i=e.parse(n.locale,1,Kt),!i))return null;let s=null;if(n.currency&&(s=e.parse(n.currency,1,Kt),!s))return null;let a=null;if(n["min-fraction-digits"]&&(a=e.parse(n["min-fraction-digits"],1,Xt),!a))return null;let o=null;return n["max-fraction-digits"]&&(o=e.parse(n["max-fraction-digits"],1,Xt),!o)?null:new $r(r,i,s,a,o)}evaluate(t){return new Intl.NumberFormat(this.locale?this.locale.evaluate(t):[],{style:this.currency?"currency":"decimal",currency:this.currency?this.currency.evaluate(t):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(t):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(t):void 0}).format(this.number.evaluate(t))}eachChild(t){t(this.number),this.locale&&t(this.locale),this.currency&&t(this.currency),this.minFractionDigits&&t(this.minFractionDigits),this.maxFractionDigits&&t(this.maxFractionDigits);}outputDefined(){return !1}serialize(){const t={};return this.locale&&(t.locale=this.locale.serialize()),this.currency&&(t.currency=this.currency.serialize()),this.minFractionDigits&&(t["min-fraction-digits"]=this.minFractionDigits.serialize()),this.maxFractionDigits&&(t["max-fraction-digits"]=this.maxFractionDigits.serialize()),["number-format",this.number.serialize(),t]}}class Or{constructor(t){this.type=Xt,this.input=t;}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const r=e.parse(t[1],1);return r?"array"!==r.type.kind&&"string"!==r.type.kind&&"value"!==r.type.kind?e.error(`Expected argument of type string or array, but found ${ne(r.type)} instead.`):new Or(r):null}evaluate(t){const e=this.input.evaluate(t);if("string"==typeof e)return e.length;if(Array.isArray(e))return e.length;throw new be(`Expected value to be of type string or array, but found ${ne(ge(e))} instead.`)}eachChild(t){t(this.input);}outputDefined(){return !1}serialize(){const t=["length"];return this.eachChild((e=>{t.push(e.serialize());})),t}}const qr={"==":Vr,"!=":Dr,">":Lr,"<":Fr,">=":Ur,"<=":Rr,array:_e,at:Sr,boolean:_e,case:Mr,coalesce:kr,collator:Ee,format:ke,image:Ae,in:Ir,"index-of":zr,interpolate:wr,"interpolate-hcl":wr,"interpolate-lab":wr,length:Or,let:Ar,literal:ve,match:Tr,number:_e,"number-format":$r,object:_e,slice:Er,step:er,string:_e,"to-boolean":Ie,"to-color":Ie,"to-number":Ie,"to-string":Ie,var:Je,within:Xe};function Nr(t,[e,r,n,i]){e=e.evaluate(t),r=r.evaluate(t),n=n.evaluate(t);const s=i?i.evaluate(t):1,a=ye(e,r,n,s);if(a)throw new be(a);return new ce(e/255*s,r/255*s,n/255*s,s)}function jr(t,e){return t in e}function Gr(t,e){const r=e[t];return void 0===r?null:r}function Zr(t){return {type:t}}function Xr(t){return {result:"success",value:t}}function Kr(t){return {result:"error",value:t}}function Hr(t){return "data-driven"===t["property-type"]||"cross-faded-data-driven"===t["property-type"]}function Yr(t){return !!t.expression&&t.expression.parameters.indexOf("zoom")>-1}function Jr(t){return !!t.expression&&t.expression.interpolated}function Wr(t){return t instanceof Number?"number":t instanceof String?"string":t instanceof Boolean?"boolean":Array.isArray(t)?"array":null===t?"null":typeof t}function Qr(t){return "object"==typeof t&&null!==t&&!Array.isArray(t)}function tn(t){return t}function en(t,e){const r="color"===e.type,n=t.stops&&"object"==typeof t.stops[0][0],i=n||!(n||void 0!==t.property),s=t.type||(Jr(e)?"exponential":"interval");if(r&&((t=Ot({},t)).stops&&(t.stops=t.stops.map((t=>[t[0],ce.parse(t[1])]))),t.default=ce.parse(t.default?t.default:e.default)),t.colorSpace&&"rgb"!==t.colorSpace&&!br[t.colorSpace])throw new Error(`Unknown color space: ${t.colorSpace}`);let a,o,l;if("exponential"===s)a=an;else if("interval"===s)a=sn;else if("categorical"===s){a=nn,o=Object.create(null);for(const e of t.stops)o[e[0]]=e[1];l=typeof t.stops[0][0];}else {if("identity"!==s)throw new Error(`Unknown function type "${s}"`);a=on;}if(n){const r={},n=[];for(let e=0;e<t.stops.length;e++){const i=t.stops[e],s=i[0].zoom;void 0===r[s]&&(r[s]={zoom:s,type:t.type,property:t.property,default:t.default,stops:[]},n.push(s)),r[s].stops.push([i[0].value,i[1]]);}const i=[];for(const t of n)i.push([r[t].zoom,en(r[t],e)]);const s={name:"linear"};return {kind:"composite",interpolationType:s,interpolationFactor:wr.interpolationFactor.bind(void 0,s),zoomStops:i.map((t=>t[0])),evaluate:({zoom:r},n)=>an({stops:i,base:t.base},e,r).evaluate(r,n)}}if(i){const r="exponential"===s?{name:"exponential",base:void 0!==t.base?t.base:1}:null;return {kind:"camera",interpolationType:r,interpolationFactor:wr.interpolationFactor.bind(void 0,r),zoomStops:t.stops.map((t=>t[0])),evaluate:({zoom:r})=>a(t,e,r,o,l)}}return {kind:"source",evaluate(r,n){const i=n&&n.properties?n.properties[t.property]:void 0;return void 0===i?rn(t.default,e.default):a(t,e,i,o,l)}}}function rn(t,e,r){return void 0!==t?t:void 0!==e?e:void 0!==r?r:void 0}function nn(t,e,r,n,i){return rn(typeof r===i?n[r]:void 0,t.default,e.default)}function sn(t,e,r){if("number"!==Wr(r))return rn(t.default,e.default);const n=t.stops.length;if(1===n)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[n-1][0])return t.stops[n-1][1];const i=tr(t.stops.map((t=>t[0])),r);return t.stops[i][1]}function an(t,e,r){const n=void 0!==t.base?t.base:1;if("number"!==Wr(r))return rn(t.default,e.default);const i=t.stops.length;if(1===i)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[i-1][0])return t.stops[i-1][1];const s=tr(t.stops.map((t=>t[0])),r),a=function(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}(r,n,t.stops[s][0],t.stops[s+1][0]),o=t.stops[s][1],l=t.stops[s+1][1];let u=nr[e.type]||tn;if(t.colorSpace&&"rgb"!==t.colorSpace){const e=br[t.colorSpace];u=(t,r)=>e.reverse(e.interpolate(e.forward(t),e.forward(r),a));}return "function"==typeof o.evaluate?{evaluate(...t){const e=o.evaluate.apply(void 0,t),r=l.evaluate.apply(void 0,t);if(void 0!==e&&void 0!==r)return u(e,r,a)}}:u(o,l,a)}function on(t,e,r){return "color"===e.type?r=ce.parse(r):"formatted"===e.type?r=de.fromString(r.toString()):"resolvedImage"===e.type?r=fe.fromString(r.toString()):Wr(r)===e.type||"enum"===e.type&&e.values[r]||(r=void 0),rn(r,t.default,e.default)}Me.register(qr,{error:[{kind:"error"},[Kt],(t,[e])=>{throw new be(e.evaluate(t))}],typeof:[Kt,[Wt],(t,[e])=>ne(ge(e.evaluate(t)))],"to-rgba":[re(Xt,4),[Yt],(t,[e])=>e.evaluate(t).toArray()],rgb:[Yt,[Xt,Xt,Xt],Nr],rgba:[Yt,[Xt,Xt,Xt,Xt],Nr],has:{type:Ht,overloads:[[[Kt],(t,[e])=>jr(e.evaluate(t),t.properties())],[[Kt,Jt],(t,[e,r])=>jr(e.evaluate(t),r.evaluate(t))]]},get:{type:Wt,overloads:[[[Kt],(t,[e])=>Gr(e.evaluate(t),t.properties())],[[Kt,Jt],(t,[e,r])=>Gr(e.evaluate(t),r.evaluate(t))]]},"feature-state":[Wt,[Kt],(t,[e])=>Gr(e.evaluate(t),t.featureState||{})],properties:[Jt,[],t=>t.properties()],"geometry-type":[Kt,[],t=>t.geometryType()],id:[Wt,[],t=>t.id()],zoom:[Xt,[],t=>t.globals.zoom],"heatmap-density":[Xt,[],t=>t.globals.heatmapDensity||0],"line-progress":[Xt,[],t=>t.globals.lineProgress||0],"sky-radial-progress":[Xt,[],t=>t.globals.skyRadialProgress||0],accumulated:[Wt,[],t=>void 0===t.globals.accumulated?null:t.globals.accumulated],"+":[Xt,Zr(Xt),(t,e)=>{let r=0;for(const n of e)r+=n.evaluate(t);return r}],"*":[Xt,Zr(Xt),(t,e)=>{let r=1;for(const n of e)r*=n.evaluate(t);return r}],"-":{type:Xt,overloads:[[[Xt,Xt],(t,[e,r])=>e.evaluate(t)-r.evaluate(t)],[[Xt],(t,[e])=>-e.evaluate(t)]]},"/":[Xt,[Xt,Xt],(t,[e,r])=>e.evaluate(t)/r.evaluate(t)],"%":[Xt,[Xt,Xt],(t,[e,r])=>e.evaluate(t)%r.evaluate(t)],ln2:[Xt,[],()=>Math.LN2],pi:[Xt,[],()=>Math.PI],e:[Xt,[],()=>Math.E],"^":[Xt,[Xt,Xt],(t,[e,r])=>Math.pow(e.evaluate(t),r.evaluate(t))],sqrt:[Xt,[Xt],(t,[e])=>Math.sqrt(e.evaluate(t))],log10:[Xt,[Xt],(t,[e])=>Math.log(e.evaluate(t))/Math.LN10],ln:[Xt,[Xt],(t,[e])=>Math.log(e.evaluate(t))],log2:[Xt,[Xt],(t,[e])=>Math.log(e.evaluate(t))/Math.LN2],sin:[Xt,[Xt],(t,[e])=>Math.sin(e.evaluate(t))],cos:[Xt,[Xt],(t,[e])=>Math.cos(e.evaluate(t))],tan:[Xt,[Xt],(t,[e])=>Math.tan(e.evaluate(t))],asin:[Xt,[Xt],(t,[e])=>Math.asin(e.evaluate(t))],acos:[Xt,[Xt],(t,[e])=>Math.acos(e.evaluate(t))],atan:[Xt,[Xt],(t,[e])=>Math.atan(e.evaluate(t))],min:[Xt,Zr(Xt),(t,e)=>Math.min(...e.map((e=>e.evaluate(t))))],max:[Xt,Zr(Xt),(t,e)=>Math.max(...e.map((e=>e.evaluate(t))))],abs:[Xt,[Xt],(t,[e])=>Math.abs(e.evaluate(t))],round:[Xt,[Xt],(t,[e])=>{const r=e.evaluate(t);return r<0?-Math.round(-r):Math.round(r)}],floor:[Xt,[Xt],(t,[e])=>Math.floor(e.evaluate(t))],ceil:[Xt,[Xt],(t,[e])=>Math.ceil(e.evaluate(t))],"filter-==":[Ht,[Kt,Wt],(t,[e,r])=>t.properties()[e.value]===r.value],"filter-id-==":[Ht,[Wt],(t,[e])=>t.id()===e.value],"filter-type-==":[Ht,[Kt],(t,[e])=>t.geometryType()===e.value],"filter-<":[Ht,[Kt,Wt],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<i}],"filter-id-<":[Ht,[Wt],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<n}],"filter->":[Ht,[Kt,Wt],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>i}],"filter-id->":[Ht,[Wt],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>n}],"filter-<=":[Ht,[Kt,Wt],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<=i}],"filter-id-<=":[Ht,[Wt],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<=n}],"filter->=":[Ht,[Kt,Wt],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>=i}],"filter-id->=":[Ht,[Wt],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>=n}],"filter-has":[Ht,[Wt],(t,[e])=>e.value in t.properties()],"filter-has-id":[Ht,[],t=>null!==t.id()&&void 0!==t.id()],"filter-type-in":[Ht,[re(Kt)],(t,[e])=>e.value.indexOf(t.geometryType())>=0],"filter-id-in":[Ht,[re(Wt)],(t,[e])=>e.value.indexOf(t.id())>=0],"filter-in-small":[Ht,[Kt,re(Wt)],(t,[e,r])=>r.value.indexOf(t.properties()[e.value])>=0],"filter-in-large":[Ht,[Kt,re(Wt)],(t,[e,r])=>function(t,e,r,n){for(;r<=n;){const i=r+n>>1;if(e[i]===t)return !0;e[i]>t?n=i-1:r=i+1;}return !1}(t.properties()[e.value],r.value,0,r.value.length-1)],all:{type:Ht,overloads:[[[Ht,Ht],(t,[e,r])=>e.evaluate(t)&&r.evaluate(t)],[Zr(Ht),(t,e)=>{for(const r of e)if(!r.evaluate(t))return !1;return !0}]]},any:{type:Ht,overloads:[[[Ht,Ht],(t,[e,r])=>e.evaluate(t)||r.evaluate(t)],[Zr(Ht),(t,e)=>{for(const r of e)if(r.evaluate(t))return !0;return !1}]]},"!":[Ht,[Ht],(t,[e])=>!e.evaluate(t)],"is-supported-script":[Ht,[Kt],(t,[e])=>{const r=t.globals&&t.globals.isSupportedScript;return !r||r(e.evaluate(t))}],upcase:[Kt,[Kt],(t,[e])=>e.evaluate(t).toUpperCase()],downcase:[Kt,[Kt],(t,[e])=>e.evaluate(t).toLowerCase()],concat:[Kt,Zr(Wt),(t,e)=>e.map((e=>xe(e.evaluate(t)))).join("")],"resolved-locale":[Kt,[Qt],(t,[e])=>e.evaluate(t).resolvedLocale()]});class ln{constructor(t,e){this.expression=t,this._warningHistory={},this._evaluator=new Te,this._defaultValue=e?function(t){return "color"===t.type&&Qr(t.default)?new ce(0,0,0,0):"color"===t.type?ce.parse(t.default)||null:void 0===t.default?null:t.default}(e):null,this._enumValues=e&&"enum"===e.type?e.values:null;}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._evaluator.globals=t,this._evaluator.feature=e,this._evaluator.featureState=r,this._evaluator.canonical=n,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s,this.expression.evaluate(this._evaluator)}evaluate(t,e,r,n,i,s){this._evaluator.globals=t,this._evaluator.feature=e||null,this._evaluator.featureState=r||null,this._evaluator.canonical=n,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s||null;try{const t=this.expression.evaluate(this._evaluator);if(null==t||"number"==typeof t&&t!=t)return this._defaultValue;if(this._enumValues&&!(t in this._enumValues))throw new be(`Expected value to be one of ${Object.keys(this._enumValues).map((t=>JSON.stringify(t))).join(", ")}, but found ${JSON.stringify(t)} instead.`);return t}catch(t){return this._warningHistory[t.message]||(this._warningHistory[t.message]=!0,"undefined"!=typeof console&&console.warn(t.message)),this._defaultValue}}}function un(t){return Array.isArray(t)&&t.length>0&&"string"==typeof t[0]&&t[0]in qr}function cn(t,e){const r=new We(qr,[],e?function(t){const e={color:Yt,string:Kt,number:Xt,enum:Kt,boolean:Ht,formatted:te,resolvedImage:ee};return "array"===t.type?re(e[t.value]||Wt,t.length):e[t.type]}(e):void 0),n=r.parse(t,void 0,void 0,void 0,e&&"string"===e.type?{typeAnnotation:"coerce"}:void 0);return n?Xr(new ln(n,e)):Kr(r.errors)}class hn{constructor(t,e){this.kind=t,this._styleExpression=e,this.isStateDependent="constant"!==t&&!He(e.expression);}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._styleExpression.evaluate(t,e,r,n,i,s)}}class pn{constructor(t,e,r,n){this.kind=t,this.zoomStops=r,this._styleExpression=e,this.isStateDependent="camera"!==t&&!He(e.expression),this.interpolationType=n;}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._styleExpression.evaluate(t,e,r,n,i,s)}interpolationFactor(t,e,r){return this.interpolationType?wr.interpolationFactor(this.interpolationType,t,e,r):0}}function dn(t,e){if("error"===(t=cn(t,e)).result)return t;const r=t.value.expression,n=Ke(r);if(!n&&!Hr(e))return Kr([new jt("","data expressions not supported")]);const i=Ye(r,["zoom"]);if(!i&&!Yr(e))return Kr([new jt("","zoom expressions not supported")]);const s=yn(r);return s||i?s instanceof jt?Kr([s]):s instanceof wr&&!Jr(e)?Kr([new jt("",'"interpolate" expressions cannot be used with this property')]):Xr(s?new pn(n?"camera":"composite",t.value,s.labels,s instanceof wr?s.interpolation:void 0):new hn(n?"constant":"source",t.value)):Kr([new jt("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.')])}class fn{constructor(t,e){this._parameters=t,this._specification=e,Ot(this,en(this._parameters,this._specification));}static deserialize(t){return new fn(t._parameters,t._specification)}static serialize(t){return {_parameters:t._parameters,_specification:t._specification}}}function yn(t){let e=null;if(t instanceof Ar)e=yn(t.result);else if(t instanceof kr){for(const r of t.args)if(e=yn(r),e)break}else (t instanceof er||t instanceof wr)&&t.input instanceof Me&&"zoom"===t.input.name&&(e=t);return e instanceof jt||t.eachChild((t=>{const r=yn(t);r instanceof jt?e=r:!e&&r?e=new jt("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.'):e&&r&&e!==r&&(e=new jt("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'));})),e}function mn(t){const e=t.key,r=t.value,n=t.valueSpec||{},i=t.objectElementValidators||{},s=t.style,a=t.styleSpec;let o=[];const l=Wr(r);if("object"!==l)return [new Ut(e,r,`object expected, ${l} found`)];for(const t in r){const l=t.split(".")[0],u=n[l]||n["*"];let c;if(i[l])c=i[l];else if(n[l])c=jn;else if(i["*"])c=i["*"];else {if(!n["*"]){o.push(new Ut(e,r[t],`unknown property "${t}"`));continue}c=jn;}o=o.concat(c({key:(e?`${e}.`:e)+t,value:r[t],valueSpec:u,style:s,styleSpec:a,object:r,objectKey:t},r));}for(const t in n)i[t]||n[t].required&&void 0===n[t].default&&void 0===r[t]&&o.push(new Ut(e,r,`missing required property "${t}"`));return o}function gn(t){const e=t.value,r=t.valueSpec,n=t.style,i=t.styleSpec,s=t.key,a=t.arrayElementValidator||jn;if("array"!==Wr(e))return [new Ut(s,e,`array expected, ${Wr(e)} found`)];if(r.length&&e.length!==r.length)return [new Ut(s,e,`array length ${r.length} expected, length ${e.length} found`)];if(r["min-length"]&&e.length<r["min-length"])return [new Ut(s,e,`array length at least ${r["min-length"]} expected, length ${e.length} found`)];let o={type:r.value,values:r.values,minimum:r.minimum,maximum:r.maximum};i.$version<7&&(o.function=r.function),"object"===Wr(r.value)&&(o=r.value);let l=[];for(let t=0;t<e.length;t++)l=l.concat(a({array:e,arrayIndex:t,value:e[t],valueSpec:o,style:n,styleSpec:i,key:`${s}[${t}]`}));return l}function xn(t){const e=t.key,r=t.value,n=t.valueSpec;let i=Wr(r);if("number"===i&&r!=r&&(i="NaN"),"number"!==i)return [new Ut(e,r,`number expected, ${i} found`)];if("minimum"in n){let i=n.minimum;if("array"===Wr(n.minimum)&&(i=n.minimum[t.arrayIndex]),r<i)return [new Ut(e,r,`${r} is less than the minimum value ${i}`)]}if("maximum"in n){let i=n.maximum;if("array"===Wr(n.maximum)&&(i=n.maximum[t.arrayIndex]),r>i)return [new Ut(e,r,`${r} is greater than the maximum value ${i}`)]}return []}function vn(t){const e=t.valueSpec,r=qt(t.value.type);let n,i,s,a={};const o="categorical"!==r&&void 0===t.value.property,l=!o,u="array"===Wr(t.value.stops)&&"array"===Wr(t.value.stops[0])&&"object"===Wr(t.value.stops[0][0]),c=mn({key:t.key,value:t.value,valueSpec:t.styleSpec.function,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{stops:function(t){if("identity"===r)return [new Ut(t.key,t.value,'identity function may not have a "stops" property')];let e=[];const n=t.value;return e=e.concat(gn({key:t.key,value:n,valueSpec:t.valueSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:h})),"array"===Wr(n)&&0===n.length&&e.push(new Ut(t.key,n,"array must have at least one stop")),e},default:function(t){return jn({key:t.key,value:t.value,valueSpec:e,style:t.style,styleSpec:t.styleSpec})}}});return "identity"===r&&o&&c.push(new Ut(t.key,t.value,'missing required property "property"')),"identity"===r||t.value.stops||c.push(new Ut(t.key,t.value,'missing required property "stops"')),"exponential"===r&&t.valueSpec.expression&&!Jr(t.valueSpec)&&c.push(new Ut(t.key,t.value,"exponential functions not supported")),t.styleSpec.$version>=8&&(l&&!Hr(t.valueSpec)?c.push(new Ut(t.key,t.value,"property functions not supported")):o&&!Yr(t.valueSpec)&&c.push(new Ut(t.key,t.value,"zoom functions not supported"))),"categorical"!==r&&!u||void 0!==t.value.property||c.push(new Ut(t.key,t.value,'"property" property is required')),c;function h(t){let r=[];const n=t.value,o=t.key;if("array"!==Wr(n))return [new Ut(o,n,`array expected, ${Wr(n)} found`)];if(2!==n.length)return [new Ut(o,n,`array length 2 expected, length ${n.length} found`)];if(u){if("object"!==Wr(n[0]))return [new Ut(o,n,`object expected, ${Wr(n[0])} found`)];if(void 0===n[0].zoom)return [new Ut(o,n,"object stop key must have zoom")];if(void 0===n[0].value)return [new Ut(o,n,"object stop key must have value")];if(s&&s>qt(n[0].zoom))return [new Ut(o,n[0].zoom,"stop zoom values must appear in ascending order")];qt(n[0].zoom)!==s&&(s=qt(n[0].zoom),i=void 0,a={}),r=r.concat(mn({key:`${o}[0]`,value:n[0],valueSpec:{zoom:{}},style:t.style,styleSpec:t.styleSpec,objectElementValidators:{zoom:xn,value:p}}));}else r=r.concat(p({key:`${o}[0]`,value:n[0],valueSpec:{},style:t.style,styleSpec:t.styleSpec},n));return un(Nt(n[1]))?r.concat([new Ut(`${o}[1]`,n[1],"expressions are not allowed in function stops.")]):r.concat(jn({key:`${o}[1]`,value:n[1],valueSpec:e,style:t.style,styleSpec:t.styleSpec}))}function p(t,s){const o=Wr(t.value),l=qt(t.value),u=null!==t.value?t.value:s;if(n){if(o!==n)return [new Ut(t.key,u,`${o} stop domain type must match previous stop domain type ${n}`)]}else n=o;if("number"!==o&&"string"!==o&&"boolean"!==o)return [new Ut(t.key,u,"stop domain value must be a number, string, or boolean")];if("number"!==o&&"categorical"!==r){let n=`number expected, ${o} found`;return Hr(e)&&void 0===r&&(n+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new Ut(t.key,u,n)]}return "categorical"!==r||"number"!==o||isFinite(l)&&Math.floor(l)===l?"categorical"!==r&&"number"===o&&void 0!==i&&l<i?[new Ut(t.key,u,"stop domain values must appear in ascending order")]:(i=l,"categorical"===r&&l in a?[new Ut(t.key,u,"stop domain values must be unique")]:(a[l]=!0,[])):[new Ut(t.key,u,`integer expected, found ${l}`)]}}function bn(t){const e=("property"===t.expressionContext?dn:cn)(Nt(t.value),t.valueSpec);if("error"===e.result)return e.value.map((e=>new Ut(`${t.key}${e.key}`,t.value,e.message)));const r=e.value.expression||e.value._styleExpression.expression;if("property"===t.expressionContext&&"text-font"===t.propertyKey&&!r.outputDefined())return [new Ut(t.key,t.value,`Invalid data expression for "${t.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===t.expressionContext&&"layout"===t.propertyType&&!He(r))return [new Ut(t.key,t.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===t.expressionContext&&!He(r))return [new Ut(t.key,t.value,'"feature-state" data expressions are not supported with filters.')];if(t.expressionContext&&0===t.expressionContext.indexOf("cluster")){if(!Ye(r,["zoom","feature-state"]))return [new Ut(t.key,t.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===t.expressionContext&&!Ke(r))return [new Ut(t.key,t.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return []}function wn(t){const e=t.key,r=t.value,n=t.valueSpec,i=[];return Array.isArray(n.values)?-1===n.values.indexOf(qt(r))&&i.push(new Ut(e,r,`expected one of [${n.values.join(", ")}], ${JSON.stringify(r)} found`)):-1===Object.keys(n.values).indexOf(qt(r))&&i.push(new Ut(e,r,`expected one of [${Object.keys(n.values).join(", ")}], ${JSON.stringify(r)} found`)),i}function _n(t){if(!0===t||!1===t)return !0;if(!Array.isArray(t)||0===t.length)return !1;switch(t[0]){case"has":return t.length>=2&&"$id"!==t[1]&&"$type"!==t[1];case"in":return t.length>=3&&("string"!=typeof t[1]||Array.isArray(t[2]));case"!in":case"!has":case"none":return !1;case"==":case"!=":case">":case">=":case"<":case"<=":return 3!==t.length||Array.isArray(t[1])||Array.isArray(t[2]);case"any":case"all":for(const e of t.slice(1))if(!_n(e)&&"boolean"!=typeof e)return !1;return !0;default:return !0}}const kn={type:"boolean",default:!1,transition:!1,"property-type":"data-driven",expression:{interpolated:!1,parameters:["zoom","feature"]}};function An(t){if(null==t)return {filter:()=>!0,needGeometry:!1};_n(t)||(t=zn(t));const e=cn(t,kn);if("error"===e.result)throw new Error(e.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return {filter:(t,r,n)=>e.value.evaluate(t,r,{},n),needGeometry:In(t)}}function Sn(t,e){return t<e?-1:t>e?1:0}function In(t){if(!Array.isArray(t))return !1;if("within"===t[0])return !0;for(let e=1;e<t.length;e++)if(In(t[e]))return !0;return !1}function zn(t){if(!t)return !0;const e=t[0];return t.length<=1?"any"!==e:"=="===e?Tn(t[1],t[2],"=="):"!="===e?Bn(Tn(t[1],t[2],"==")):"<"===e||">"===e||"<="===e||">="===e?Tn(t[1],t[2],e):"any"===e?(r=t.slice(1),["any"].concat(r.map(zn))):"all"===e?["all"].concat(t.slice(1).map(zn)):"none"===e?["all"].concat(t.slice(1).map(zn).map(Bn)):"in"===e?Mn(t[1],t.slice(2)):"!in"===e?Bn(Mn(t[1],t.slice(2))):"has"===e?En(t[1]):"!has"===e?Bn(En(t[1])):"within"!==e||t;var r;}function Tn(t,e,r){switch(t){case"$type":return [`filter-type-${r}`,e];case"$id":return [`filter-id-${r}`,e];default:return [`filter-${r}`,t,e]}}function Mn(t,e){if(0===e.length)return !1;switch(t){case"$type":return ["filter-type-in",["literal",e]];case"$id":return ["filter-id-in",["literal",e]];default:return e.length>200&&!e.some((t=>typeof t!=typeof e[0]))?["filter-in-large",t,["literal",e.sort(Sn)]]:["filter-in-small",t,["literal",e]]}}function En(t){switch(t){case"$type":return !0;case"$id":return ["filter-has-id"];default:return ["filter-has",t]}}function Bn(t){return ["!",t]}function Cn(t){return _n(Nt(t.value))?bn(Ot({},t,{expressionContext:"filter",valueSpec:{value:"boolean"}})):Pn(t)}function Pn(t){const e=t.value,r=t.key;if("array"!==Wr(e))return [new Ut(r,e,`array expected, ${Wr(e)} found`)];const n=t.styleSpec;let i,s=[];if(e.length<1)return [new Ut(r,e,"filter array must have at least 1 element")];switch(s=s.concat(wn({key:`${r}[0]`,value:e[0],valueSpec:n.filter_operator,style:t.style,styleSpec:t.styleSpec})),qt(e[0])){case"<":case"<=":case">":case">=":e.length>=2&&"$type"===qt(e[1])&&s.push(new Ut(r,e,`"$type" cannot be use with operator "${e[0]}"`));case"==":case"!=":3!==e.length&&s.push(new Ut(r,e,`filter array for operator "${e[0]}" must have 3 elements`));case"in":case"!in":e.length>=2&&(i=Wr(e[1]),"string"!==i&&s.push(new Ut(`${r}[1]`,e[1],`string expected, ${i} found`)));for(let a=2;a<e.length;a++)i=Wr(e[a]),"$type"===qt(e[1])?s=s.concat(wn({key:`${r}[${a}]`,value:e[a],valueSpec:n.geometry_type,style:t.style,styleSpec:t.styleSpec})):"string"!==i&&"number"!==i&&"boolean"!==i&&s.push(new Ut(`${r}[${a}]`,e[a],`string, number, or boolean expected, ${i} found`));break;case"any":case"all":case"none":for(let n=1;n<e.length;n++)s=s.concat(Pn({key:`${r}[${n}]`,value:e[n],style:t.style,styleSpec:t.styleSpec}));break;case"has":case"!has":i=Wr(e[1]),2!==e.length?s.push(new Ut(r,e,`filter array for "${e[0]}" operator must have 2 elements`)):"string"!==i&&s.push(new Ut(`${r}[1]`,e[1],`string expected, ${i} found`));break;case"within":i=Wr(e[1]),2!==e.length?s.push(new Ut(r,e,`filter array for "${e[0]}" operator must have 2 elements`)):"object"!==i&&s.push(new Ut(`${r}[1]`,e[1],`object expected, ${i} found`));}return s}function Vn(t,e){const r=t.key,n=t.style,i=t.styleSpec,s=t.value,a=t.objectKey,o=i[`${e}_${t.layerType}`];if(!o)return [];const l=a.match(/^(.*)-transition$/);if("paint"===e&&l&&o[l[1]]&&o[l[1]].transition)return jn({key:r,value:s,valueSpec:i.transition,style:n,styleSpec:i});const u=t.valueSpec||o[a];if(!u)return [new Ut(r,s,`unknown property "${a}"`)];let c;if("string"===Wr(s)&&Hr(u)&&!u.tokens&&(c=/^{([^}]+)}$/.exec(s)))return [new Ut(r,s,`"${a}" does not support interpolation syntax\nUse an identity property function instead: \`{ "type": "identity", "property": ${JSON.stringify(c[1])} }\`.`)];const h=[];return "symbol"===t.layerType&&("text-field"===a&&n&&!n.glyphs&&h.push(new Ut(r,s,'use of "text-field" requires a style "glyphs" property')),"text-font"===a&&Qr(Nt(s))&&"identity"===qt(s.type)&&h.push(new Ut(r,s,'"text-font" does not support identity functions'))),h.concat(jn({key:t.key,value:s,valueSpec:u,style:n,styleSpec:i,expressionContext:"property",propertyType:e,propertyKey:a}))}function Dn(t){return Vn(t,"paint")}function Fn(t){return Vn(t,"layout")}function Ln(t){let e=[];const r=t.value,n=t.key,i=t.style,s=t.styleSpec;r.type||r.ref||e.push(new Ut(n,r,'either "type" or "ref" is required'));let a=qt(r.type);const o=qt(r.ref);if(r.id){const s=qt(r.id);for(let a=0;a<t.arrayIndex;a++){const t=i.layers[a];qt(t.id)===s&&e.push(new Ut(n,r.id,`duplicate layer id "${r.id}", previously used at line ${t.id.__line__}`));}}if("ref"in r){let t;["type","source","source-layer","filter","layout"].forEach((t=>{t in r&&e.push(new Ut(n,r[t],`"${t}" is prohibited for ref layers`));})),i.layers.forEach((e=>{qt(e.id)===o&&(t=e);})),t?t.ref?e.push(new Ut(n,r.ref,"ref cannot reference another ref layer")):a=qt(t.type):e.push(new Ut(n,r.ref,`ref layer "${o}" not found`));}else if("background"!==a&&"sky"!==a)if(r.source){const t=i.sources&&i.sources[r.source],s=t&&qt(t.type);t?"vector"===s&&"raster"===a?e.push(new Ut(n,r.source,`layer "${r.id}" requires a raster source`)):"raster"===s&&"raster"!==a?e.push(new Ut(n,r.source,`layer "${r.id}" requires a vector source`)):"vector"!==s||r["source-layer"]?"raster-dem"===s&&"hillshade"!==a?e.push(new Ut(n,r.source,"raster-dem source can only be used with layer type 'hillshade'.")):"line"!==a||!r.paint||!r.paint["line-gradient"]||"geojson"===s&&t.lineMetrics||e.push(new Ut(n,r,`layer "${r.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):e.push(new Ut(n,r,`layer "${r.id}" must specify a "source-layer"`)):e.push(new Ut(n,r.source,`source "${r.source}" not found`));}else e.push(new Ut(n,r,'missing required property "source"'));return e=e.concat(mn({key:n,value:r,valueSpec:s.layer,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":()=>[],type:()=>jn({key:`${n}.type`,value:r.type,valueSpec:s.layer.type,style:t.style,styleSpec:t.styleSpec,object:r,objectKey:"type"}),filter:Cn,layout:t=>mn({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":t=>Fn(Ot({layerType:a},t))}}),paint:t=>mn({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":t=>Dn(Ot({layerType:a},t))}})}})),e}function Rn(t){const e=t.value,r=t.key,n=Wr(e);return "string"!==n?[new Ut(r,e,`string expected, ${n} found`)]:[]}const Un={promoteId:function({key:t,value:e}){if("string"===Wr(e))return Rn({key:t,value:e});{const r=[];for(const n in e)r.push(...Rn({key:`${t}.${n}`,value:e[n]}));return r}}};function $n(t){const e=t.value,r=t.key,n=t.styleSpec,i=t.style;if(!e.type)return [new Ut(r,e,'"type" is required')];const s=qt(e.type);let a;switch(s){case"vector":case"raster":case"raster-dem":return a=mn({key:r,value:e,valueSpec:n[`source_${s.replace("-","_")}`],style:t.style,styleSpec:n,objectElementValidators:Un}),a;case"geojson":if(a=mn({key:r,value:e,valueSpec:n.source_geojson,style:i,styleSpec:n,objectElementValidators:Un}),e.cluster)for(const t in e.clusterProperties){const[n,i]=e.clusterProperties[t],s="string"==typeof n?[n,["accumulated"],["get",t]]:n;a.push(...bn({key:`${r}.${t}.map`,value:i,expressionContext:"cluster-map"})),a.push(...bn({key:`${r}.${t}.reduce`,value:s,expressionContext:"cluster-reduce"}));}return a;case"video":return mn({key:r,value:e,valueSpec:n.source_video,style:i,styleSpec:n});case"image":return mn({key:r,value:e,valueSpec:n.source_image,style:i,styleSpec:n});case"canvas":return [new Ut(r,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return wn({key:`${r}.type`,value:e.type,valueSpec:{values:["vector","raster","raster-dem","geojson","video","image"]},style:i,styleSpec:n})}}function On(t){const e=t.value,r=t.styleSpec,n=r.light,i=t.style;let s=[];const a=Wr(e);if(void 0===e)return s;if("object"!==a)return s=s.concat([new Ut("light",e,`object expected, ${a} found`)]),s;for(const t in e){const a=t.match(/^(.*)-transition$/);s=s.concat(a&&n[a[1]]&&n[a[1]].transition?jn({key:t,value:e[t],valueSpec:r.transition,style:i,styleSpec:r}):n[t]?jn({key:t,value:e[t],valueSpec:n[t],style:i,styleSpec:r}):[new Ut(t,e[t],`unknown property "${t}"`)]);}return s}function qn(t){const e=t.value,r=t.key,n=t.style,i=t.styleSpec,s=i.terrain;let a=[];const o=Wr(e);if(void 0===e)return a;if("object"!==o)return a=a.concat([new Ut("terrain",e,`object expected, ${o} found`)]),a;for(const t in e){const r=t.match(/^(.*)-transition$/);a=a.concat(r&&s[r[1]]&&s[r[1]].transition?jn({key:t,value:e[t],valueSpec:i.transition,style:n,styleSpec:i}):s[t]?jn({key:t,value:e[t],valueSpec:s[t],style:n,styleSpec:i}):[new Ut(t,e[t],`unknown property "${t}"`)]);}if(e.source){const t=n.sources&&n.sources[e.source],i=t&&qt(t.type);t?"raster-dem"!==i&&a.push(new Ut(r,e.source,`terrain cannot be used with a source of type ${i}, it only be used with a "raster-dem" source type`)):a.push(new Ut(r,e.source,`source "${e.source}" not found`));}else a.push(new Ut(r,e,'terrain is missing required property "source"'));return a}const Nn={"*":()=>[],array:gn,boolean:function(t){const e=t.value,r=t.key,n=Wr(e);return "boolean"!==n?[new Ut(r,e,`boolean expected, ${n} found`)]:[]},number:xn,color:function(t){const e=t.key,r=t.value,n=Wr(r);return "string"!==n?[new Ut(e,r,`color expected, ${n} found`)]:null===ue.parseCSSColor(r)?[new Ut(e,r,`color expected, "${r}" found`)]:[]},constants:$t,enum:wn,filter:Cn,function:vn,layer:Ln,object:mn,source:$n,light:On,terrain:qn,string:Rn,formatted:function(t){return 0===Rn(t).length?[]:bn(t)},resolvedImage:function(t){return 0===Rn(t).length?[]:bn(t)}};function jn(t){const e=t.value,r=t.valueSpec,n=t.styleSpec;return r.expression&&Qr(qt(e))?vn(t):r.expression&&un(Nt(e))?bn(t):r.type&&Nn[r.type]?Nn[r.type](t):mn(Ot({},t,{valueSpec:r.type?n[r.type]:r}))}function Gn(t){const e=t.value,r=t.key,n=Rn(t);return n.length||(-1===e.indexOf("{fontstack}")&&n.push(new Ut(r,e,'"glyphs" url must include a "{fontstack}" token')),-1===e.indexOf("{range}")&&n.push(new Ut(r,e,'"glyphs" url must include a "{range}" token'))),n}function Zn(t,e=Rt){let r=[];return r=r.concat(jn({key:"",value:t,valueSpec:e.$root,styleSpec:e,style:t,objectElementValidators:{glyphs:Gn,"*":()=>[]}})),t.constants&&(r=r.concat($t({key:"constants",value:t.constants,style:t,styleSpec:e}))),Xn(r)}function Xn(t){return [].concat(t).sort(((t,e)=>t.line-e.line))}function Kn(t){return function(...e){return Xn(t.apply(this,e))}}Zn.source=Kn($n),Zn.light=Kn(On),Zn.terrain=Kn(qn),Zn.layer=Kn(Ln),Zn.filter=Kn(Cn),Zn.paintProperty=Kn(Dn),Zn.layoutProperty=Kn(Fn);const Hn=Zn,Yn=Hn.light,Jn=Hn.paintProperty,Wn=Hn.layoutProperty;function Qn(t,e){let r=!1;if(e&&e.length)for(const n of e)t.fire(new Ft(new Error(n.message))),r=!0;return r}var ti=ei;function ei(t,e,r){var n=this.cells=[];if(t instanceof ArrayBuffer){this.arrayBuffer=t;var i=new Int32Array(this.arrayBuffer);t=i[0],this.d=(e=i[1])+2*(r=i[2]);for(var s=0;s<this.d*this.d;s++){var a=i[3+s],o=i[3+s+1];n.push(a===o?null:i.subarray(a,o));}var l=i[3+n.length+1];this.keys=i.subarray(i[3+n.length],l),this.bboxes=i.subarray(l),this.insert=this._insertReadonly;}else {this.d=e+2*r;for(var u=0;u<this.d*this.d;u++)n.push([]);this.keys=[],this.bboxes=[];}this.n=e,this.extent=t,this.padding=r,this.scale=e/t,this.uid=0;var c=r/e*t;this.min=-c,this.max=t+c;}ei.prototype.insert=function(t,e,r,n,i){this._forEachCell(e,r,n,i,this._insertCell,this.uid++),this.keys.push(t),this.bboxes.push(e),this.bboxes.push(r),this.bboxes.push(n),this.bboxes.push(i);},ei.prototype._insertReadonly=function(){throw "Cannot insert into a GridIndex created from an ArrayBuffer."},ei.prototype._insertCell=function(t,e,r,n,i,s){this.cells[i].push(s);},ei.prototype.query=function(t,e,r,n,i){var s=this.min,a=this.max;if(t<=s&&e<=s&&a<=r&&a<=n&&!i)return Array.prototype.slice.call(this.keys);var o=[];return this._forEachCell(t,e,r,n,this._queryCell,o,{},i),o},ei.prototype._queryCell=function(t,e,r,n,i,s,a,o){var l=this.cells[i];if(null!==l)for(var u=this.keys,c=this.bboxes,h=0;h<l.length;h++){var p=l[h];if(void 0===a[p]){var d=4*p;(o?o(c[d+0],c[d+1],c[d+2],c[d+3]):t<=c[d+2]&&e<=c[d+3]&&r>=c[d+0]&&n>=c[d+1])?(a[p]=!0,s.push(u[p])):a[p]=!1;}}},ei.prototype._forEachCell=function(t,e,r,n,i,s,a,o){for(var l=this._convertToCellCoord(t),u=this._convertToCellCoord(e),c=this._convertToCellCoord(r),h=this._convertToCellCoord(n),p=l;p<=c;p++)for(var d=u;d<=h;d++){var f=this.d*d+p;if((!o||o(this._convertFromCellCoord(p),this._convertFromCellCoord(d),this._convertFromCellCoord(p+1),this._convertFromCellCoord(d+1)))&&i.call(this,t,e,r,n,f,s,a,o))return}},ei.prototype._convertFromCellCoord=function(t){return (t-this.padding)/this.scale},ei.prototype._convertToCellCoord=function(t){return Math.max(0,Math.min(this.d-1,Math.floor(t*this.scale)+this.padding))},ei.prototype.toArrayBuffer=function(){if(this.arrayBuffer)return this.arrayBuffer;for(var t=this.cells,e=3+this.cells.length+1+1,r=0,n=0;n<this.cells.length;n++)r+=this.cells[n].length;var i=new Int32Array(e+r+this.keys.length+this.bboxes.length);i[0]=this.extent,i[1]=this.n,i[2]=this.padding;for(var s=e,a=0;a<t.length;a++){var o=t[a];i[3+a]=s,i.set(o,s),s+=o.length;}return i[3+t.length]=s,i.set(this.keys,s),i[3+t.length+1]=s+=this.keys.length,i.set(this.bboxes,s),s+=this.bboxes.length,i.buffer};const{ImageData:ri,ImageBitmap:ni}=a,ii={};function si(t,e,r={}){Object.defineProperty(e,"_classRegistryKey",{value:t,writeable:!1}),ii[t]={klass:e,omit:r.omit||[],shallow:r.shallow||[]};}si("Object",Object),ti.serialize=function(t,e){const r=t.toArrayBuffer();return e&&e.push(r),{buffer:r}},ti.deserialize=function(t){return new ti(t.buffer)},si("Grid",ti),si("Color",ce),si("Error",Error),si("ResolvedImage",fe),si("StylePropertyFunction",fn),si("StyleExpression",ln,{omit:["_evaluator"]}),si("ZoomDependentExpression",pn),si("ZoomConstantExpression",hn),si("CompoundExpression",Me,{omit:["_evaluate"]});for(const t in qr)qr[t]._classRegistryKey||si(`Expression_${t}`,qr[t]);function ai(t){return t&&"undefined"!=typeof ArrayBuffer&&(t instanceof ArrayBuffer||t.constructor&&"ArrayBuffer"===t.constructor.name)}function oi(t){return ni&&t instanceof ni}function li(t,e){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp)return t;if(ai(t)||oi(t))return e&&e.push(t),t;if(ArrayBuffer.isView(t)){const r=t;return e&&e.push(r.buffer),r}if(t instanceof ri)return e&&e.push(t.data.buffer),t;if(Array.isArray(t)){const r=[];for(const n of t)r.push(li(n,e));return r}if("object"==typeof t){const r=t.constructor,n=r._classRegistryKey;if(!n)throw new Error("can't serialize object of unregistered class");const i=r.serialize?r.serialize(t,e):{};if(!r.serialize){for(const r in t){if(!t.hasOwnProperty(r))continue;if(ii[n].omit.indexOf(r)>=0)continue;const s=t[r];i[r]=ii[n].shallow.indexOf(r)>=0?s:li(s,e);}t instanceof Error&&(i.message=t.message);}if(i.$name)throw new Error("$name property is reserved for worker serialization logic.");return "Object"!==n&&(i.$name=n),i}throw new Error("can't serialize object of type "+typeof t)}function ui(t){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||ai(t)||oi(t)||ArrayBuffer.isView(t)||t instanceof ri)return t;if(Array.isArray(t))return t.map(ui);if("object"==typeof t){const e=t.$name||"Object",{klass:r}=ii[e];if(!r)throw new Error(`can't deserialize unregistered class ${e}`);if(r.deserialize)return r.deserialize(t);const n=Object.create(r.prototype);for(const r of Object.keys(t)){if("$name"===r)continue;const i=t[r];n[r]=ii[e].shallow.indexOf(r)>=0?i:ui(i);}return n}throw new Error("can't deserialize object of type "+typeof t)}class ci{constructor(){this.first=!0;}update(t,e){const r=Math.floor(t);return this.first?(this.first=!1,this.lastIntegerZoom=r,this.lastIntegerZoomTime=0,this.lastZoom=t,this.lastFloorZoom=r,!0):(this.lastFloorZoom>r?(this.lastIntegerZoom=r+1,this.lastIntegerZoomTime=e):this.lastFloorZoom<r&&(this.lastIntegerZoom=r,this.lastIntegerZoomTime=e),t!==this.lastZoom&&(this.lastZoom=t,this.lastFloorZoom=r,!0))}}const hi=t=>t>=1536&&t<=1791,pi=t=>t>=1872&&t<=1919,di=t=>t>=2208&&t<=2303,fi=t=>t>=11904&&t<=12031,yi=t=>t>=12032&&t<=12255,mi=t=>t>=12272&&t<=12287,gi=t=>t>=12288&&t<=12351,xi=t=>t>=12352&&t<=12447,vi=t=>t>=12448&&t<=12543,bi=t=>t>=12544&&t<=12591,wi=t=>t>=12704&&t<=12735,_i=t=>t>=12736&&t<=12783,ki=t=>t>=12784&&t<=12799,Ai=t=>t>=12800&&t<=13055,Si=t=>t>=13056&&t<=13311,Ii=t=>t>=13312&&t<=19903,zi=t=>t>=19968&&t<=40959,Ti=t=>t>=40960&&t<=42127,Mi=t=>t>=42128&&t<=42191,Ei=t=>t>=44032&&t<=55215,Bi=t=>t>=63744&&t<=64255,Ci=t=>t>=64336&&t<=65023,Pi=t=>t>=65040&&t<=65055,Vi=t=>t>=65072&&t<=65103,Di=t=>t>=65104&&t<=65135,Fi=t=>t>=65136&&t<=65279,Li=t=>t>=65280&&t<=65519;function Ri(t){for(const e of t)if(Oi(e.charCodeAt(0)))return !0;return !1}function Ui(t){for(const e of t)if(!$i(e.charCodeAt(0)))return !1;return !0}function $i(t){return !(hi(t)||pi(t)||di(t)||Ci(t)||Fi(t))}function Oi(t){return !(746!==t&&747!==t&&(t<4352||!(wi(t)||bi(t)||Vi(t)&&!(t>=65097&&t<=65103)||Bi(t)||Si(t)||fi(t)||_i(t)||!(!gi(t)||t>=12296&&t<=12305||t>=12308&&t<=12319||12336===t)||Ii(t)||zi(t)||Ai(t)||(t=>t>=12592&&t<=12687)(t)||(t=>t>=43360&&t<=43391)(t)||(t=>t>=55216&&t<=55295)(t)||(t=>t>=4352&&t<=4607)(t)||Ei(t)||xi(t)||mi(t)||(t=>t>=12688&&t<=12703)(t)||yi(t)||ki(t)||vi(t)&&12540!==t||!(!Li(t)||65288===t||65289===t||65293===t||t>=65306&&t<=65310||65339===t||65341===t||65343===t||t>=65371&&t<=65503||65507===t||t>=65512&&t<=65519)||!(!Di(t)||t>=65112&&t<=65118||t>=65123&&t<=65126)||(t=>t>=5120&&t<=5759)(t)||(t=>t>=6320&&t<=6399)(t)||Pi(t)||(t=>t>=19904&&t<=19967)(t)||Ti(t)||Mi(t))))}function qi(t){return !(Oi(t)||function(t){return !!((t=>t>=128&&t<=255)(t)&&(167===t||169===t||174===t||177===t||188===t||189===t||190===t||215===t||247===t)||(t=>t>=8192&&t<=8303)(t)&&(8214===t||8224===t||8225===t||8240===t||8241===t||8251===t||8252===t||8258===t||8263===t||8264===t||8265===t||8273===t)||(t=>t>=8448&&t<=8527)(t)||(t=>t>=8528&&t<=8591)(t)||(t=>t>=8960&&t<=9215)(t)&&(t>=8960&&t<=8967||t>=8972&&t<=8991||t>=8996&&t<=9e3||9003===t||t>=9085&&t<=9114||t>=9150&&t<=9165||9167===t||t>=9169&&t<=9179||t>=9186&&t<=9215)||(t=>t>=9216&&t<=9279)(t)&&9251!==t||(t=>t>=9280&&t<=9311)(t)||(t=>t>=9312&&t<=9471)(t)||(t=>t>=9632&&t<=9727)(t)||(t=>t>=9728&&t<=9983)(t)&&!(t>=9754&&t<=9759)||(t=>t>=11008&&t<=11263)(t)&&(t>=11026&&t<=11055||t>=11088&&t<=11097||t>=11192&&t<=11243)||gi(t)||vi(t)||(t=>t>=57344&&t<=63743)(t)||Vi(t)||Di(t)||Li(t)||8734===t||8756===t||8757===t||t>=9984&&t<=10087||t>=10102&&t<=10131||65532===t||65533===t)}(t))}function Ni(t){return t>=1424&&t<=2303||Ci(t)||Fi(t)}function ji(t,e){return !(!e&&Ni(t)||t>=2304&&t<=3583||t>=3840&&t<=4255||(t=>t>=6016&&t<=6143)(t))}function Gi(t){for(const e of t)if(Ni(e.charCodeAt(0)))return !0;return !1}const Zi="deferred",Xi="loading",Ki="loaded";let Hi=null,Yi="unavailable",Ji=null;const Wi=function(t){t&&"string"==typeof t&&t.indexOf("NetworkError")>-1&&(Yi="error"),Hi&&Hi(t);};function Qi(){ts.fire(new Dt("pluginStateChange",{pluginStatus:Yi,pluginURL:Ji}));}const ts=new Lt,es=function(){return Yi},rs=function(){if(Yi!==Zi||!Ji)throw new Error("rtl-text-plugin cannot be downloaded unless a pluginURL is specified");Yi=Xi,Qi(),Ji&&St({url:Ji},(t=>{t?Wi(t):(Yi=Ki,Qi());}));},ns={applyArabicShaping:null,processBidirectionalText:null,processStyledBidirectionalText:null,isLoaded:()=>Yi===Ki||null!=ns.applyArabicShaping,isLoading:()=>Yi===Xi,setState(t){Yi=t.pluginStatus,Ji=t.pluginURL;},isParsed:()=>null!=ns.applyArabicShaping&&null!=ns.processBidirectionalText&&null!=ns.processStyledBidirectionalText,getPluginURL:()=>Ji};class is{constructor(t,e){this.zoom=t,e?(this.now=e.now,this.fadeDuration=e.fadeDuration,this.zoomHistory=e.zoomHistory,this.transition=e.transition):(this.now=0,this.fadeDuration=0,this.zoomHistory=new ci,this.transition={});}isSupportedScript(t){return function(t,e){for(const r of t)if(!ji(r.charCodeAt(0),e))return !1;return !0}(t,ns.isLoaded())}crossFadingFactor(){return 0===this.fadeDuration?1:Math.min((this.now-this.zoomHistory.lastIntegerZoomTime)/this.fadeDuration,1)}getCrossfadeParameters(){const t=this.zoom,e=t-Math.floor(t),r=this.crossFadingFactor();return t>this.zoomHistory.lastIntegerZoom?{fromScale:2,toScale:1,t:e+(1-e)*r}:{fromScale:.5,toScale:1,t:1-(1-r)*e}}}class ss{constructor(t,e){this.property=t,this.value=e,this.expression=function(t,e){if(Qr(t))return new fn(t,e);if(un(t)){const r=dn(t,e);if("error"===r.result)throw new Error(r.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return r.value}{let r=t;return "string"==typeof t&&"color"===e.type&&(r=ce.parse(t)),{kind:"constant",evaluate:()=>r}}}(void 0===e?t.specification.default:e,t.specification);}isDataDriven(){return "source"===this.expression.kind||"composite"===this.expression.kind}possiblyEvaluate(t,e,r){return this.property.possiblyEvaluate(this,t,e,r)}}class as{constructor(t){this.property=t,this.value=new ss(t,void 0);}transitioned(t,e){return new ls(this.property,this.value,e,x({},t.transition,this.transition),t.now)}untransitioned(){return new ls(this.property,this.value,null,{},0)}}class os{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitionablePropertyValues);}getValue(t){return z(this._values[t].value.value)}setValue(t,e){this._values.hasOwnProperty(t)||(this._values[t]=new as(this._values[t].property)),this._values[t].value=new ss(this._values[t].property,null===e?void 0:z(e));}getTransition(t){return z(this._values[t].transition)}setTransition(t,e){this._values.hasOwnProperty(t)||(this._values[t]=new as(this._values[t].property)),this._values[t].transition=z(e)||void 0;}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);const n=this.getTransition(e);void 0!==n&&(t[`${e}-transition`]=n);}return t}transitioned(t,e){const r=new us(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].transitioned(t,e._values[n]);return r}untransitioned(){const t=new us(this._properties);for(const e of Object.keys(this._values))t._values[e]=this._values[e].untransitioned();return t}}class ls{constructor(t,e,r,n,i){this.property=t,this.value=e,this.begin=i+n.delay||0,this.end=this.begin+n.duration||0,t.specification.transition&&(n.delay||n.duration)&&(this.prior=r);}possiblyEvaluate(t,e,r){const n=t.now||0,i=this.value.possiblyEvaluate(t,e,r),s=this.prior;if(s){if(n>this.end)return this.prior=null,i;if(this.value.isDataDriven())return this.prior=null,i;if(n<this.begin)return s.possiblyEvaluate(t,e,r);{const a=(n-this.begin)/(this.end-this.begin);return this.property.interpolate(s.possiblyEvaluate(t,e,r),i,h(a))}}return i}}class us{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitioningPropertyValues);}possiblyEvaluate(t,e,r){const n=new ps(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}hasTransition(){for(const t of Object.keys(this._values))if(this._values[t].prior)return !0;return !1}}class cs{constructor(t){this._properties=t,this._values=Object.create(t.defaultPropertyValues);}getValue(t){return z(this._values[t].value)}setValue(t,e){this._values[t]=new ss(this._values[t].property,null===e?void 0:z(e));}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);}return t}possiblyEvaluate(t,e,r){const n=new ps(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}}class hs{constructor(t,e,r){this.property=t,this.value=e,this.parameters=r;}isConstant(){return "constant"===this.value.kind}constantOr(t){return "constant"===this.value.kind?this.value.value:t}evaluate(t,e,r,n){return this.property.evaluate(this.value,this.parameters,t,e,r,n)}}class ps{constructor(t){this._properties=t,this._values=Object.create(t.defaultPossiblyEvaluatedValues);}get(t){return this._values[t]}}class ds{constructor(t){this.specification=t;}possiblyEvaluate(t,e){return t.expression.evaluate(e)}interpolate(t,e,r){const n=nr[this.specification.type];return n?n(t,e,r):t}}class fs{constructor(t,e){this.specification=t,this.overrides=e;}possiblyEvaluate(t,e,r,n){return new hs(this,"constant"===t.expression.kind||"camera"===t.expression.kind?{kind:"constant",value:t.expression.evaluate(e,null,{},r,n)}:t.expression,e)}interpolate(t,e,r){if("constant"!==t.value.kind||"constant"!==e.value.kind)return t;if(void 0===t.value.value||void 0===e.value.value)return new hs(this,{kind:"constant",value:void 0},t.parameters);const n=nr[this.specification.type];return n?new hs(this,{kind:"constant",value:n(t.value.value,e.value.value,r)},t.parameters):t}evaluate(t,e,r,n,i,s){return "constant"===t.kind?t.value:t.evaluate(e,r,n,i,s)}}class ys extends fs{possiblyEvaluate(t,e,r,n){if(void 0===t.value)return new hs(this,{kind:"constant",value:void 0},e);if("constant"===t.expression.kind){const i=t.expression.evaluate(e,null,{},r,n),s="resolvedImage"===t.property.specification.type&&"string"!=typeof i?i.name:i,a=this._calculate(s,s,s,e);return new hs(this,{kind:"constant",value:a},e)}if("camera"===t.expression.kind){const r=this._calculate(t.expression.evaluate({zoom:e.zoom-1}),t.expression.evaluate({zoom:e.zoom}),t.expression.evaluate({zoom:e.zoom+1}),e);return new hs(this,{kind:"constant",value:r},e)}return new hs(this,t.expression,e)}evaluate(t,e,r,n,i,s){if("source"===t.kind){const a=t.evaluate(e,r,n,i,s);return this._calculate(a,a,a,e)}return "composite"===t.kind?this._calculate(t.evaluate({zoom:Math.floor(e.zoom)-1},r,n),t.evaluate({zoom:Math.floor(e.zoom)},r,n),t.evaluate({zoom:Math.floor(e.zoom)+1},r,n),e):t.value}_calculate(t,e,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e}}interpolate(t){return t}}class ms{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,n){if(void 0!==t.value){if("constant"===t.expression.kind){const i=t.expression.evaluate(e,null,{},r,n);return this._calculate(i,i,i,e)}return this._calculate(t.expression.evaluate(new is(Math.floor(e.zoom-1),e)),t.expression.evaluate(new is(Math.floor(e.zoom),e)),t.expression.evaluate(new is(Math.floor(e.zoom+1),e)),e)}}_calculate(t,e,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e}}interpolate(t){return t}}class gs{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,n){return !!t.expression.evaluate(e,null,{},r,n)}interpolate(){return !1}}class xs{constructor(t){this.properties=t,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];for(const e in t){const r=t[e];r.specification.overridable&&this.overridableProperties.push(e);const n=this.defaultPropertyValues[e]=new ss(r,void 0),i=this.defaultTransitionablePropertyValues[e]=new as(r);this.defaultTransitioningPropertyValues[e]=i.untransitioned(),this.defaultPossiblyEvaluatedValues[e]=n.possiblyEvaluate({});}}}function vs(t,e){return 256*(t=f(Math.floor(t),0,255))+f(Math.floor(e),0,255)}si("DataDrivenProperty",fs),si("DataConstantProperty",ds),si("CrossFadedDataDrivenProperty",ys),si("CrossFadedProperty",ms),si("ColorRampProperty",gs);const bs={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class ws{constructor(t,e){this._structArray=t,this._pos1=e*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8;}}class _s{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0);}static serialize(t,e){return t._trim(),e&&(t.isTransferred=!0,e.push(t.arrayBuffer)),{length:t.length,arrayBuffer:t.arrayBuffer}}static deserialize(t){const e=Object.create(this.prototype);return e.arrayBuffer=t.arrayBuffer,e.length=t.length,e.capacity=t.arrayBuffer.byteLength/e.bytesPerElement,e._refreshViews(),e}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews());}clear(){this.length=0;}resize(t){this.reserve(t),this.length=t;}reserve(t){if(t>this.capacity){this.capacity=Math.max(t,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const e=this.uint8;this._refreshViews(),e&&this.uint8.set(e);}}_refreshViews(){throw new Error("_refreshViews() must be implemented by each concrete StructArray layout")}}function ks(t,e=1){let r=0,n=0;return {members:t.map((t=>{const i=bs[t.type].BYTES_PER_ELEMENT,s=r=As(r,Math.max(e,i)),a=t.components||1;return n=Math.max(n,i),r+=i*a,{name:t.name,type:t.type,components:a,offset:s}})),size:As(r,Math.max(n,e)),alignment:e}}function As(t,e){return Math.ceil(t/e)*e}class Ss extends _s{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.int16[n+0]=e,this.int16[n+1]=r,t}}Ss.prototype.bytesPerElement=4,si("StructArrayLayout2i4",Ss);class Is extends _s{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.int16[s+0]=e,this.int16[s+1]=r,this.int16[s+2]=n,this.int16[s+3]=i,t}}Is.prototype.bytesPerElement=8,si("StructArrayLayout4i8",Is);class zs extends _s{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s,a)}emplace(t,e,r,n,i,s,a,o){const l=6*t,u=12*t,c=3*t;return this.int16[l+0]=e,this.int16[l+1]=r,this.uint8[u+4]=n,this.uint8[u+5]=i,this.uint8[u+6]=s,this.uint8[u+7]=a,this.float32[c+2]=o,t}}zs.prototype.bytesPerElement=12,si("StructArrayLayout2i4ub1f12",zs);class Ts extends _s{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.float32[n+0]=e,this.float32[n+1]=r,t}}Ts.prototype.bytesPerElement=8,si("StructArrayLayout2f8",Ts);class Ms extends _s{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u){const c=this.length;return this.resize(c+1),this.emplace(c,t,e,r,n,i,s,a,o,l,u)}emplace(t,e,r,n,i,s,a,o,l,u,c){const h=10*t;return this.uint16[h+0]=e,this.uint16[h+1]=r,this.uint16[h+2]=n,this.uint16[h+3]=i,this.uint16[h+4]=s,this.uint16[h+5]=a,this.uint16[h+6]=o,this.uint16[h+7]=l,this.uint16[h+8]=u,this.uint16[h+9]=c,t}}Ms.prototype.bytesPerElement=20,si("StructArrayLayout10ui20",Ms);class Es extends _s{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h){const p=this.length;return this.resize(p+1),this.emplace(p,t,e,r,n,i,s,a,o,l,u,c,h)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p){const d=12*t;return this.int16[d+0]=e,this.int16[d+1]=r,this.int16[d+2]=n,this.int16[d+3]=i,this.uint16[d+4]=s,this.uint16[d+5]=a,this.uint16[d+6]=o,this.uint16[d+7]=l,this.int16[d+8]=u,this.int16[d+9]=c,this.int16[d+10]=h,this.int16[d+11]=p,t}}Es.prototype.bytesPerElement=24,si("StructArrayLayout4i4ui4i24",Es);class Bs extends _s{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.float32[i+0]=e,this.float32[i+1]=r,this.float32[i+2]=n,t}}Bs.prototype.bytesPerElement=12,si("StructArrayLayout3f12",Bs);class Cs extends _s{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint32[1*t+0]=e,t}}Cs.prototype.bytesPerElement=4,si("StructArrayLayout1ul4",Cs);class Ps extends _s{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u){const c=this.length;return this.resize(c+1),this.emplace(c,t,e,r,n,i,s,a,o,l,u)}emplace(t,e,r,n,i,s,a,o,l,u,c){const h=16*t,p=8*t;return this.int16[h+0]=e,this.int16[h+1]=r,this.float32[p+1]=n,this.float32[p+2]=i,this.float32[p+3]=s,this.float32[p+4]=a,this.int16[h+10]=o,this.uint32[p+6]=l,this.uint16[h+14]=u,this.uint16[h+15]=c,t}}Ps.prototype.bytesPerElement=32,si("StructArrayLayout2i4f1i1ul2ui32",Ps);class Vs extends _s{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=6*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=n,this.int16[o+3]=i,this.int16[o+4]=s,this.int16[o+5]=a,t}}Vs.prototype.bytesPerElement=12,si("StructArrayLayout2i2i2i12",Vs);class Ds extends _s{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const a=4*t,o=8*t;return this.float32[a+0]=e,this.float32[a+1]=r,this.float32[a+2]=n,this.int16[o+6]=i,this.int16[o+7]=s,t}}Ds.prototype.bytesPerElement=16,si("StructArrayLayout2f1f2i16",Ds);class Fs extends _s{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=12*t,a=3*t;return this.uint8[s+0]=e,this.uint8[s+1]=r,this.float32[a+1]=n,this.float32[a+2]=i,t}}Fs.prototype.bytesPerElement=12,si("StructArrayLayout2ub2f12",Fs);class Ls extends _s{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.uint16[i+0]=e,this.uint16[i+1]=r,this.uint16[i+2]=n,t}}Ls.prototype.bytesPerElement=6,si("StructArrayLayout3ui6",Ls);class Rs extends _s{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p,d,f,y,m){const g=this.length;return this.resize(g+1),this.emplace(g,t,e,r,n,i,s,a,o,l,u,c,h,p,d,f,y,m)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,d,f,y,m,g){const x=24*t,v=12*t,b=48*t;return this.int16[x+0]=e,this.int16[x+1]=r,this.uint16[x+2]=n,this.uint16[x+3]=i,this.uint32[v+2]=s,this.uint32[v+3]=a,this.uint32[v+4]=o,this.uint16[x+10]=l,this.uint16[x+11]=u,this.uint16[x+12]=c,this.float32[v+7]=h,this.float32[v+8]=p,this.uint8[b+36]=d,this.uint8[b+37]=f,this.uint8[b+38]=y,this.uint32[v+10]=m,this.int16[x+22]=g,t}}Rs.prototype.bytesPerElement=48,si("StructArrayLayout2i2ui3ul3ui2f3ub1ul1i48",Rs);class Us extends _s{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p,d,f,y,m,g,x,v,b,w,_,k,A,S,I,z){const T=this.length;return this.resize(T+1),this.emplace(T,t,e,r,n,i,s,a,o,l,u,c,h,p,d,f,y,m,g,x,v,b,w,_,k,A,S,I,z)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,d,f,y,m,g,x,v,b,w,_,k,A,S,I,z,T){const M=34*t,E=17*t;return this.int16[M+0]=e,this.int16[M+1]=r,this.int16[M+2]=n,this.int16[M+3]=i,this.int16[M+4]=s,this.int16[M+5]=a,this.int16[M+6]=o,this.int16[M+7]=l,this.uint16[M+8]=u,this.uint16[M+9]=c,this.uint16[M+10]=h,this.uint16[M+11]=p,this.uint16[M+12]=d,this.uint16[M+13]=f,this.uint16[M+14]=y,this.uint16[M+15]=m,this.uint16[M+16]=g,this.uint16[M+17]=x,this.uint16[M+18]=v,this.uint16[M+19]=b,this.uint16[M+20]=w,this.uint16[M+21]=_,this.uint16[M+22]=k,this.uint32[E+12]=A,this.float32[E+13]=S,this.float32[E+14]=I,this.float32[E+15]=z,this.float32[E+16]=T,t}}Us.prototype.bytesPerElement=68,si("StructArrayLayout8i15ui1ul4f68",Us);class $s extends _s{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.float32[1*t+0]=e,t}}$s.prototype.bytesPerElement=4,si("StructArrayLayout1f4",$s);class Os extends _s{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.int16[i+0]=e,this.int16[i+1]=r,this.int16[i+2]=n,t}}Os.prototype.bytesPerElement=6,si("StructArrayLayout3i6",Os);class qs extends _s{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=6*t;return this.uint32[3*t+0]=e,this.uint16[s+2]=r,this.uint16[s+3]=n,this.uint16[s+4]=i,t}}qs.prototype.bytesPerElement=12,si("StructArrayLayout1ul3ui12",qs);class Ns extends _s{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.uint16[n+0]=e,this.uint16[n+1]=r,t}}Ns.prototype.bytesPerElement=4,si("StructArrayLayout2ui4",Ns);class js extends _s{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint16[1*t+0]=e,t}}js.prototype.bytesPerElement=2,si("StructArrayLayout1ui2",js);class Gs extends _s{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.float32[s+0]=e,this.float32[s+1]=r,this.float32[s+2]=n,this.float32[s+3]=i,t}}Gs.prototype.bytesPerElement=16,si("StructArrayLayout4f16",Gs);class Zs extends ws{get anchorPointX(){return this._structArray.int16[this._pos2+0]}get anchorPointY(){return this._structArray.int16[this._pos2+1]}get x1(){return this._structArray.float32[this._pos4+1]}get y1(){return this._structArray.float32[this._pos4+2]}get x2(){return this._structArray.float32[this._pos4+3]}get y2(){return this._structArray.float32[this._pos4+4]}get padding(){return this._structArray.int16[this._pos2+10]}get featureIndex(){return this._structArray.uint32[this._pos4+6]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+14]}get bucketIndex(){return this._structArray.uint16[this._pos2+15]}get anchorPoint(){return new i(this.anchorPointX,this.anchorPointY)}}Zs.prototype.size=32;class Xs extends Ps{get(t){return new Zs(this,t)}}si("CollisionBoxArray",Xs);class Ks extends ws{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+2]}get numGlyphs(){return this._structArray.uint16[this._pos2+3]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+2]}get lineStartIndex(){return this._structArray.uint32[this._pos4+3]}get lineLength(){return this._structArray.uint32[this._pos4+4]}get segment(){return this._structArray.uint16[this._pos2+10]}get lowerSize(){return this._structArray.uint16[this._pos2+11]}get upperSize(){return this._structArray.uint16[this._pos2+12]}get lineOffsetX(){return this._structArray.float32[this._pos4+7]}get lineOffsetY(){return this._structArray.float32[this._pos4+8]}get writingMode(){return this._structArray.uint8[this._pos1+36]}get placedOrientation(){return this._structArray.uint8[this._pos1+37]}set placedOrientation(t){this._structArray.uint8[this._pos1+37]=t;}get hidden(){return this._structArray.uint8[this._pos1+38]}set hidden(t){this._structArray.uint8[this._pos1+38]=t;}get crossTileID(){return this._structArray.uint32[this._pos4+10]}set crossTileID(t){this._structArray.uint32[this._pos4+10]=t;}get associatedIconIndex(){return this._structArray.int16[this._pos2+22]}}Ks.prototype.size=48;class Hs extends Rs{get(t){return new Ks(this,t)}}si("PlacedSymbolArray",Hs);class Ys extends ws{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+2]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+3]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+4]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+5]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+6]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+7]}get key(){return this._structArray.uint16[this._pos2+8]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+9]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+10]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+11]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+12]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+13]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+14]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+15]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+16]}get featureIndex(){return this._structArray.uint16[this._pos2+17]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+18]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+19]}get numIconVertices(){return this._structArray.uint16[this._pos2+20]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+21]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+22]}get crossTileID(){return this._structArray.uint32[this._pos4+12]}set crossTileID(t){this._structArray.uint32[this._pos4+12]=t;}get textBoxScale(){return this._structArray.float32[this._pos4+13]}get textOffset0(){return this._structArray.float32[this._pos4+14]}get textOffset1(){return this._structArray.float32[this._pos4+15]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+16]}}Ys.prototype.size=68;class Js extends Us{get(t){return new Ys(this,t)}}si("SymbolInstanceArray",Js);class Ws extends $s{getoffsetX(t){return this.float32[1*t+0]}}si("GlyphOffsetArray",Ws);class Qs extends Os{getx(t){return this.int16[3*t+0]}gety(t){return this.int16[3*t+1]}gettileUnitDistanceFromAnchor(t){return this.int16[3*t+2]}}si("SymbolLineVertexArray",Qs);class ta extends ws{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}get layoutVertexArrayOffset(){return this._structArray.uint16[this._pos2+4]}}ta.prototype.size=12;class ea extends qs{get(t){return new ta(this,t)}}si("FeatureIndexArray",ea);class ra extends ws{get a_centroid_pos0(){return this._structArray.uint16[this._pos2+0]}get a_centroid_pos1(){return this._structArray.uint16[this._pos2+1]}}ra.prototype.size=4;class na extends Ns{get(t){return new ra(this,t)}}si("FillExtrusionCentroidArray",na);const ia=ks([{name:"a_pattern_to",components:4,type:"Uint16"},{name:"a_pattern_from",components:4,type:"Uint16"},{name:"a_pixel_ratio_to",components:1,type:"Uint16"},{name:"a_pixel_ratio_from",components:1,type:"Uint16"}]);var sa=le((function(t){t.exports=function(t,e){var r,n,i,s,a,o,l,u;for(n=t.length-(r=3&t.length),i=e,a=3432918353,o=461845907,u=0;u<n;)l=255&t.charCodeAt(u)|(255&t.charCodeAt(++u))<<8|(255&t.charCodeAt(++u))<<16|(255&t.charCodeAt(++u))<<24,++u,i=27492+(65535&(s=5*(65535&(i=(i^=l=(65535&(l=(l=(65535&l)*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<13|i>>>19))+((5*(i>>>16)&65535)<<16)&4294967295))+((58964+(s>>>16)&65535)<<16);switch(l=0,r){case 3:l^=(255&t.charCodeAt(u+2))<<16;case 2:l^=(255&t.charCodeAt(u+1))<<8;case 1:i^=l=(65535&(l=(l=(65535&(l^=255&t.charCodeAt(u)))*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295;}return i^=t.length,i=2246822507*(65535&(i^=i>>>16))+((2246822507*(i>>>16)&65535)<<16)&4294967295,i=3266489909*(65535&(i^=i>>>13))+((3266489909*(i>>>16)&65535)<<16)&4294967295,(i^=i>>>16)>>>0};})),aa=le((function(t){t.exports=function(t,e){for(var r,n=t.length,i=e^n,s=0;n>=4;)r=1540483477*(65535&(r=255&t.charCodeAt(s)|(255&t.charCodeAt(++s))<<8|(255&t.charCodeAt(++s))<<16|(255&t.charCodeAt(++s))<<24))+((1540483477*(r>>>16)&65535)<<16),i=1540483477*(65535&i)+((1540483477*(i>>>16)&65535)<<16)^(r=1540483477*(65535&(r^=r>>>24))+((1540483477*(r>>>16)&65535)<<16)),n-=4,++s;switch(n){case 3:i^=(255&t.charCodeAt(s+2))<<16;case 2:i^=(255&t.charCodeAt(s+1))<<8;case 1:i=1540483477*(65535&(i^=255&t.charCodeAt(s)))+((1540483477*(i>>>16)&65535)<<16);}return i=1540483477*(65535&(i^=i>>>13))+((1540483477*(i>>>16)&65535)<<16),(i^=i>>>15)>>>0};})),oa=sa,la=aa;oa.murmur3=sa,oa.murmur2=la;class ua{constructor(){this.ids=[],this.positions=[],this.indexed=!1;}add(t,e,r,n){this.ids.push(ca(t)),this.positions.push(e,r,n);}getPositions(t){const e=ca(t);let r=0,n=this.ids.length-1;for(;r<n;){const t=r+n>>1;this.ids[t]>=e?n=t:r=t+1;}const i=[];for(;this.ids[r]===e;)i.push({index:this.positions[3*r],start:this.positions[3*r+1],end:this.positions[3*r+2]}),r++;return i}static serialize(t,e){const r=new Float64Array(t.ids),n=new Uint32Array(t.positions);return ha(r,n,0,r.length-1),e&&e.push(r.buffer,n.buffer),{ids:r,positions:n}}static deserialize(t){const e=new ua;return e.ids=t.ids,e.positions=t.positions,e.indexed=!0,e}}function ca(t){const e=+t;return !isNaN(e)&&e<=o?e:oa(String(t))}function ha(t,e,r,n){for(;r<n;){const i=t[r+n>>1];let s=r-1,a=n+1;for(;;){do{s++;}while(t[s]<i);do{a--;}while(t[a]>i);if(s>=a)break;pa(t,s,a),pa(e,3*s,3*a),pa(e,3*s+1,3*a+1),pa(e,3*s+2,3*a+2);}a-r<n-a?(ha(t,e,r,a),r=a+1):(ha(t,e,a+1,n),n=a);}}function pa(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}si("FeaturePositionMap",ua);class da{constructor(t,e){this.gl=t.gl,this.location=e;}}class fa extends da{constructor(t,e){super(t,e),this.current=0;}set(t){this.current!==t&&(this.current=t,this.gl.uniform1f(this.location,t));}}class ya extends da{constructor(t,e){super(t,e),this.current=[0,0,0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]&&t[3]===this.current[3]||(this.current=t,this.gl.uniform4f(this.location,t[0],t[1],t[2],t[3]));}}class ma extends da{constructor(t,e){super(t,e),this.current=ce.transparent;}set(t){t.r===this.current.r&&t.g===this.current.g&&t.b===this.current.b&&t.a===this.current.a||(this.current=t,this.gl.uniform4f(this.location,t.r,t.g,t.b,t.a));}}const ga=new Float32Array(16),xa=new Float32Array(9);function va(t){return [vs(255*t.r,255*t.g),vs(255*t.b,255*t.a)]}class ba{constructor(t,e,r){this.value=t,this.uniformNames=e.map((t=>`u_${t}`)),this.type=r;}setUniform(t,e,r){t.set(r.constantOr(this.value));}getBinding(t,e,r){return "color"===this.type?new ma(t,e):new fa(t,e)}}class wa{constructor(t,e){this.uniformNames=e.map((t=>`u_${t}`)),this.patternFrom=null,this.patternTo=null,this.pixelRatioFrom=1,this.pixelRatioTo=1;}setConstantPatternPositions(t,e){this.pixelRatioFrom=e.pixelRatio,this.pixelRatioTo=t.pixelRatio,this.patternFrom=e.tlbr,this.patternTo=t.tlbr;}setUniform(t,e,r,n){const i="u_pattern_to"===n?this.patternTo:"u_pattern_from"===n?this.patternFrom:"u_pixel_ratio_to"===n?this.pixelRatioTo:"u_pixel_ratio_from"===n?this.pixelRatioFrom:null;i&&t.set(i);}getBinding(t,e,r){return "u_pattern"===r.substr(0,9)?new ya(t,e):new fa(t,e)}}class _a{constructor(t,e,r,n){this.expression=t,this.type=r,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?2:1,offset:0}))),this.paintVertexArray=new n;}populatePaintArray(t,e,r,n,i){const s=this.paintVertexArray.length,a=this.expression.evaluate(new is(0),e,{},n,[],i);this.paintVertexArray.resize(t),this._setPaintValue(s,t,a);}updatePaintArray(t,e,r,n){const i=this.expression.evaluate({zoom:0},r,n);this._setPaintValue(t,e,i);}_setPaintValue(t,e,r){if("color"===this.type){const n=va(r);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,n[0],n[1]);}else {for(let n=t;n<e;n++)this.paintVertexArray.emplace(n,r);this.maxValue=Math.max(this.maxValue,Math.abs(r));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}}class ka{constructor(t,e,r,n,i,s){this.expression=t,this.uniformNames=e.map((t=>`u_${t}_t`)),this.type=r,this.useIntegerZoom=n,this.zoom=i,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?4:2,offset:0}))),this.paintVertexArray=new s;}populatePaintArray(t,e,r,n,i){const s=this.expression.evaluate(new is(this.zoom),e,{},n,[],i),a=this.expression.evaluate(new is(this.zoom+1),e,{},n,[],i),o=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValue(o,t,s,a);}updatePaintArray(t,e,r,n){const i=this.expression.evaluate({zoom:this.zoom},r,n),s=this.expression.evaluate({zoom:this.zoom+1},r,n);this._setPaintValue(t,e,i,s);}_setPaintValue(t,e,r,n){if("color"===this.type){const i=va(r),s=va(n);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,i[0],i[1],s[0],s[1]);}else {for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r,n);this.maxValue=Math.max(this.maxValue,Math.abs(r),Math.abs(n));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}setUniform(t,e){const r=this.useIntegerZoom?Math.floor(e.zoom):e.zoom,n=f(this.expression.interpolationFactor(r,this.zoom,this.zoom+1),0,1);t.set(n);}getBinding(t,e,r){return new fa(t,e)}}class Aa{constructor(t,e,r,n,i,s,a){this.expression=t,this.type=r,this.useIntegerZoom=n,this.zoom=i,this.layerId=a;for(let t=0;t<e.length;++t);this.zoomInPaintVertexArray=new s,this.zoomOutPaintVertexArray=new s;}populatePaintArray(t,e,r){const n=this.zoomInPaintVertexArray.length;this.zoomInPaintVertexArray.resize(t),this.zoomOutPaintVertexArray.resize(t),this._setPaintValues(n,t,e.patterns&&e.patterns[this.layerId],r);}updatePaintArray(t,e,r,n,i){this._setPaintValues(t,e,r.patterns&&r.patterns[this.layerId],i);}_setPaintValues(t,e,r,n){if(!n||!r)return;const{min:i,mid:s,max:a}=r,o=n[i],l=n[s],u=n[a];if(o&&l&&u)for(let r=t;r<e;r++)this.zoomInPaintVertexArray.emplace(r,l.tl[0],l.tl[1],l.br[0],l.br[1],o.tl[0],o.tl[1],o.br[0],o.br[1],l.pixelRatio,o.pixelRatio),this.zoomOutPaintVertexArray.emplace(r,l.tl[0],l.tl[1],l.br[0],l.br[1],u.tl[0],u.tl[1],u.br[0],u.br[1],l.pixelRatio,u.pixelRatio);}upload(t){this.zoomInPaintVertexArray&&this.zoomInPaintVertexArray.arrayBuffer&&this.zoomOutPaintVertexArray&&this.zoomOutPaintVertexArray.arrayBuffer&&(this.zoomInPaintVertexBuffer=t.createVertexBuffer(this.zoomInPaintVertexArray,ia.members,this.expression.isStateDependent),this.zoomOutPaintVertexBuffer=t.createVertexBuffer(this.zoomOutPaintVertexArray,ia.members,this.expression.isStateDependent));}destroy(){this.zoomOutPaintVertexBuffer&&this.zoomOutPaintVertexBuffer.destroy(),this.zoomInPaintVertexBuffer&&this.zoomInPaintVertexBuffer.destroy();}}class Sa{constructor(t,e,r=(()=>!0)){this.binders={},this._buffers=[];const n=[];for(const i in t.paint._values){if(!r(i))continue;const s=t.paint.get(i);if(!(s instanceof hs&&Hr(s.property.specification)))continue;const a=za(i,t.type),o=s.value,l=s.property.specification.type,u=s.property.useIntegerZoom,c=s.property.specification["property-type"],h="cross-faded"===c||"cross-faded-data-driven"===c;if("constant"===o.kind)this.binders[i]=h?new wa(o.value,a):new ba(o.value,a,l),n.push(`/u_${i}`);else if("source"===o.kind||h){const r=Ta(i,l,"source");this.binders[i]=h?new Aa(o,a,l,u,e,r,t.id):new _a(o,a,l,r),n.push(`/a_${i}`);}else {const t=Ta(i,l,"composite");this.binders[i]=new ka(o,a,l,u,e,t),n.push(`/z_${i}`);}}this.cacheKey=n.sort().join("");}getMaxValue(t){const e=this.binders[t];return e instanceof _a||e instanceof ka?e.maxValue:0}populatePaintArrays(t,e,r,n,i){for(const s in this.binders){const a=this.binders[s];(a instanceof _a||a instanceof ka||a instanceof Aa)&&a.populatePaintArray(t,e,r,n,i);}}setConstantPatternPositions(t,e){for(const r in this.binders){const n=this.binders[r];n instanceof wa&&n.setConstantPatternPositions(t,e);}}updatePaintArrays(t,e,r,n,i){let s=!1;for(const a in t){const o=e.getPositions(a);for(const e of o){const o=r.feature(e.index);for(const r in this.binders){const l=this.binders[r];if((l instanceof _a||l instanceof ka||l instanceof Aa)&&!0===l.expression.isStateDependent){const u=n.paint.get(r);l.expression=u.value,l.updatePaintArray(e.start,e.end,o,t[a],i),s=!0;}}}}return s}defines(){const t=[];for(const e in this.binders){const r=this.binders[e];(r instanceof ba||r instanceof wa)&&t.push(...r.uniformNames.map((t=>`#define HAS_UNIFORM_${t}`)));}return t}getBinderAttributes(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof _a||r instanceof ka)for(let e=0;e<r.paintVertexAttributes.length;e++)t.push(r.paintVertexAttributes[e].name);else if(r instanceof Aa)for(let e=0;e<ia.members.length;e++)t.push(ia.members[e].name);}return t}getBinderUniforms(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof ba||r instanceof wa||r instanceof ka)for(const e of r.uniformNames)t.push(e);}return t}getPaintVertexBuffers(){return this._buffers}getUniforms(t,e){const r=[];for(const n in this.binders){const i=this.binders[n];if(i instanceof ba||i instanceof wa||i instanceof ka)for(const s of i.uniformNames)if(e[s]){const a=i.getBinding(t,e[s],s);r.push({name:s,property:n,binding:a});}}return r}setUniforms(t,e,r,n){for(const{name:t,property:i,binding:s}of e)this.binders[i].setUniform(s,n,r.get(i),t);}updatePaintBuffers(t){this._buffers=[];for(const e in this.binders){const r=this.binders[e];if(t&&r instanceof Aa){const e=2===t.fromScale?r.zoomInPaintVertexBuffer:r.zoomOutPaintVertexBuffer;e&&this._buffers.push(e);}else (r instanceof _a||r instanceof ka)&&r.paintVertexBuffer&&this._buffers.push(r.paintVertexBuffer);}}upload(t){for(const e in this.binders){const r=this.binders[e];(r instanceof _a||r instanceof ka||r instanceof Aa)&&r.upload(t);}this.updatePaintBuffers();}destroy(){for(const t in this.binders){const e=this.binders[t];(e instanceof _a||e instanceof ka||e instanceof Aa)&&e.destroy();}}}class Ia{constructor(t,e,r=(()=>!0)){this.programConfigurations={};for(const n of t)this.programConfigurations[n.id]=new Sa(n,e,r);this.needsUpload=!1,this._featureMap=new ua,this._bufferOffset=0;}populatePaintArrays(t,e,r,n,i,s){for(const r in this.programConfigurations)this.programConfigurations[r].populatePaintArrays(t,e,n,i,s);void 0!==e.id&&this._featureMap.add(e.id,r,this._bufferOffset,t),this._bufferOffset=t,this.needsUpload=!0;}updatePaintArrays(t,e,r,n){for(const i of r)this.needsUpload=this.programConfigurations[i.id].updatePaintArrays(t,this._featureMap,e,i,n)||this.needsUpload;}get(t){return this.programConfigurations[t]}upload(t){if(this.needsUpload){for(const e in this.programConfigurations)this.programConfigurations[e].upload(t);this.needsUpload=!1;}}destroy(){for(const t in this.programConfigurations)this.programConfigurations[t].destroy();}}function za(t,e){return {"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-extrusion-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"]}[t]||[t.replace(`${e}-`,"").replace(/-/g,"_")]}function Ta(t,e,r){const n={color:{source:Ts,composite:Gs},number:{source:$s,composite:Ts}},i=function(t){return {"line-pattern":{source:Ms,composite:Ms},"fill-pattern":{source:Ms,composite:Ms},"fill-extrusion-pattern":{source:Ms,composite:Ms}}[t]}(t);return i&&i[r]||n[e][r]}si("ConstantBinder",ba),si("CrossFadedConstantBinder",wa),si("SourceExpressionBinder",_a),si("CrossFadedCompositeBinder",Aa),si("CompositeExpressionBinder",ka),si("ProgramConfiguration",Sa,{omit:["_buffers"]}),si("ProgramConfigurationSet",Ia);const Ma="-transition";class Ea extends Lt{constructor(t,e){if(super(),this.id=t.id,this.type=t.type,this._featureFilter={filter:()=>!0,needGeometry:!1},"custom"!==t.type&&(this.metadata=(t=t).metadata,this.minzoom=t.minzoom,this.maxzoom=t.maxzoom,"background"!==t.type&&"sky"!==t.type&&(this.source=t.source,this.sourceLayer=t["source-layer"],this.filter=t.filter),e.layout&&(this._unevaluatedLayout=new cs(e.layout)),e.paint)){this._transitionablePaint=new os(e.paint);for(const e in t.paint)this.setPaintProperty(e,t.paint[e],{validate:!1});for(const e in t.layout)this.setLayoutProperty(e,t.layout[e],{validate:!1});this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new ps(e.paint);}}getCrossfadeParameters(){return this._crossfadeParameters}getLayoutProperty(t){return "visibility"===t?this.visibility:this._unevaluatedLayout.getValue(t)}setLayoutProperty(t,e,r={}){null!=e&&this._validate(Wn,`layers.${this.id}.layout.${t}`,t,e,r)||("visibility"!==t?this._unevaluatedLayout.setValue(t,e):this.visibility=e);}getPaintProperty(t){return A(t,Ma)?this._transitionablePaint.getTransition(t.slice(0,-Ma.length)):this._transitionablePaint.getValue(t)}setPaintProperty(t,e,r={}){if(null!=e&&this._validate(Jn,`layers.${this.id}.paint.${t}`,t,e,r))return !1;if(A(t,Ma))return this._transitionablePaint.setTransition(t.slice(0,-Ma.length),e||void 0),!1;{const r=this._transitionablePaint._values[t],n="cross-faded-data-driven"===r.property.specification["property-type"],i=r.value.isDataDriven(),s=r.value;this._transitionablePaint.setValue(t,e),this._handleSpecialPaintPropertyUpdate(t);const a=this._transitionablePaint._values[t].value;return a.isDataDriven()||i||n||this._handleOverridablePaintPropertyUpdate(t,s,a)}}_handleSpecialPaintPropertyUpdate(t){}getProgramIds(){return null}getProgramConfiguration(t){return null}_handleOverridablePaintPropertyUpdate(t,e,r){return !1}isHidden(t){return !!(this.minzoom&&t<this.minzoom)||!!(this.maxzoom&&t>=this.maxzoom)||"none"===this.visibility}updateTransitions(t){this._transitioningPaint=this._transitionablePaint.transitioned(t,this._transitioningPaint);}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(t,e){t.getCrossfadeParameters&&(this._crossfadeParameters=t.getCrossfadeParameters()),this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(t,void 0,e)),this.paint=this._transitioningPaint.possiblyEvaluate(t,void 0,e);}serialize(){const t={id:this.id,type:this.type,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()};return this.visibility&&(t.layout=t.layout||{},t.layout.visibility=this.visibility),I(t,((t,e)=>!(void 0===t||"layout"===e&&!Object.keys(t).length||"paint"===e&&!Object.keys(t).length)))}_validate(t,e,r,n,i={}){return (!i||!1!==i.validate)&&Qn(this,t.call(Hn,{key:e,layerType:this.type,objectKey:r,value:n,styleSpec:Rt,style:{glyphs:!0,sprite:!0}}))}is3D(){return !1}isSky(){return !1}isTileClipped(){return !1}hasOffscreenPass(){return !1}resize(){}isStateDependent(){for(const t in this.paint._values){const e=this.paint.get(t);if(e instanceof hs&&Hr(e.property.specification)&&("source"===e.value.kind||"composite"===e.value.kind)&&e.value.isStateDependent)return !0}return !1}}const Ba=ks([{name:"a_pos",components:2,type:"Int16"}],4),{members:Ca}=Ba;class Pa{constructor(t=[]){this.segments=t;}prepareSegment(t,e,r,n){let i=this.segments[this.segments.length-1];return t>Pa.MAX_VERTEX_ARRAY_LENGTH&&M(`Max vertices per segment is ${Pa.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${t}`),(!i||i.vertexLength+t>Pa.MAX_VERTEX_ARRAY_LENGTH||i.sortKey!==n)&&(i={vertexOffset:e.length,primitiveOffset:r.length,vertexLength:0,primitiveLength:0},void 0!==n&&(i.sortKey=n),this.segments.push(i)),i}get(){return this.segments}destroy(){for(const t of this.segments)for(const e in t.vaos)t.vaos[e].destroy();}static simpleSegment(t,e,r,n){return new Pa([{vertexOffset:t,primitiveOffset:e,vertexLength:r,primitiveLength:n,vaos:{},sortKey:0}])}}Pa.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,si("SegmentVector",Pa);var Va=8192;const Da=Math.pow(2,14)-1,Fa=-Da-1;function La(t){const e=Va/t.extent,r=t.loadGeometry();for(let t=0;t<r.length;t++){const n=r[t];for(let t=0;t<n.length;t++){const r=n[t],i=Math.round(r.x*e),s=Math.round(r.y*e);r.x=f(i,Fa,Da),r.y=f(s,Fa,Da),(i<r.x||i>r.x+1||s<r.y||s>r.y+1)&&M("Geometry exceeds allowed extent, reduce your vector tile buffer size");}}return r}function Ra(t,e){return {type:t.type,id:t.id,properties:t.properties,geometry:e?La(t):[]}}function Ua(t,e,r,n,i){t.emplaceBack(2*e+(n+1)/2,2*r+(i+1)/2);}class $a{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new Ss,this.indexArray=new Ls,this.segments=new Pa,this.programConfigurations=new Ia(t.layers,t.zoom),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){const n=this.layers[0],i=[];let s=null;"circle"===n.type&&(s=n.layout.get("circle-sort-key"));for(const{feature:e,id:n,index:a,sourceLayerIndex:o}of t){const t=this.layers[0]._featureFilter.needGeometry,l=Ra(e,t);if(!this.layers[0]._featureFilter.filter(new is(this.zoom),l,r))continue;const u=s?s.evaluate(l,{},r):void 0,c={id:n,properties:e.properties,type:e.type,sourceLayerIndex:o,index:a,geometry:t?l.geometry:La(e),patterns:{},sortKey:u};i.push(c);}s&&i.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of i){const{geometry:i,index:s,sourceLayerIndex:a}=n,o=t[s].feature;this.addFeature(n,i,s,r),e.featureIndex.insert(o,i,s,a,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Ca),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}addFeature(t,e,r,n){for(const r of e)for(const e of r){const r=e.x,n=e.y;if(r<0||r>=Va||n<0||n>=Va)continue;const i=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray,t.sortKey),s=i.vertexLength;Ua(this.layoutVertexArray,r,n,-1,-1),Ua(this.layoutVertexArray,r,n,1,-1),Ua(this.layoutVertexArray,r,n,1,1),Ua(this.layoutVertexArray,r,n,-1,1),this.indexArray.emplaceBack(s,s+1,s+2),this.indexArray.emplaceBack(s,s+3,s+2),i.vertexLength+=4,i.primitiveLength+=2;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{},n);}}function Oa(t,e){for(let r=0;r<t.length;r++)if(Ya(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(Ya(t,e[r]))return !0;return !!Ga(t,e)}function qa(t,e,r){return !!Ya(t,e)||!!Xa(e,t,r)}function Na(t,e){if(1===t.length)return Ha(e,t[0]);for(let r=0;r<e.length;r++){const n=e[r];for(let e=0;e<n.length;e++)if(Ya(t,n[e]))return !0}for(let r=0;r<t.length;r++)if(Ha(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(Ga(t,e[r]))return !0;return !1}function ja(t,e,r){if(t.length>1){if(Ga(t,e))return !0;for(let n=0;n<e.length;n++)if(Xa(e[n],t,r))return !0}for(let n=0;n<t.length;n++)if(Xa(t[n],e,r))return !0;return !1}function Ga(t,e){if(0===t.length||0===e.length)return !1;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)if(Za(n,i,e[t],e[t+1]))return !0}return !1}function Za(t,e,r,n){return E(t,r,n)!==E(e,r,n)&&E(t,e,r)!==E(t,e,n)}function Xa(t,e,r){const n=r*r;if(1===e.length)return t.distSqr(e[0])<n;for(let r=1;r<e.length;r++)if(Ka(t,e[r-1],e[r])<n)return !0;return !1}function Ka(t,e,r){const n=e.distSqr(r);if(0===n)return t.distSqr(e);const i=((t.x-e.x)*(r.x-e.x)+(t.y-e.y)*(r.y-e.y))/n;return t.distSqr(i<0?e:i>1?r:r.sub(e)._mult(i)._add(e))}function Ha(t,e){let r,n,i,s=!1;for(let a=0;a<t.length;a++){r=t[a];for(let t=0,a=r.length-1;t<r.length;a=t++)n=r[t],i=r[a],n.y>e.y!=i.y>e.y&&e.x<(i.x-n.x)*(e.y-n.y)/(i.y-n.y)+n.x&&(s=!s);}return s}function Ya(t,e){let r=!1;for(let n=0,i=t.length-1;n<t.length;i=n++){const s=t[n],a=t[i];s.y>e.y!=a.y>e.y&&e.x<(a.x-s.x)*(e.y-s.y)/(a.y-s.y)+s.x&&(r=!r);}return r}function Ja(t,e,r,n,s){for(const i of t)if(e<=i.x&&r<=i.y&&n>=i.x&&s>=i.y)return !0;const a=[new i(e,r),new i(e,s),new i(n,s),new i(n,r)];if(t.length>2)for(const e of a)if(Ya(t,e))return !0;for(let e=0;e<t.length-1;e++)if(Wa(t[e],t[e+1],a))return !0;return !1}function Wa(t,e,r){const n=r[0],i=r[2];if(t.x<n.x&&e.x<n.x||t.x>i.x&&e.x>i.x||t.y<n.y&&e.y<n.y||t.y>i.y&&e.y>i.y)return !1;const s=E(t,e,r[0]);return s!==E(t,e,r[1])||s!==E(t,e,r[2])||s!==E(t,e,r[3])}function Qa(t,e,r){const n=e.paint.get(t).value;return "constant"===n.kind?n.value:r.programConfigurations.get(e.id).getMaxValue(t)}function to(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1])}function eo(t,e,r,n,s){if(!e[0]&&!e[1])return t;const a=i.convert(e)._mult(s);"viewport"===r&&a._rotate(-n);const o=[];for(let e=0;e<t.length;e++)o.push(t[e].sub(a));return o}function ro(t,e,r,n){const s=i.convert(t)._mult(n);return "viewport"===e&&s._rotate(-r),s}si("CircleBucket",$a,{omit:["layers"]});const no=new xs({"circle-sort-key":new fs(Rt.layout_circle["circle-sort-key"])});var io={paint:new xs({"circle-radius":new fs(Rt.paint_circle["circle-radius"]),"circle-color":new fs(Rt.paint_circle["circle-color"]),"circle-blur":new fs(Rt.paint_circle["circle-blur"]),"circle-opacity":new fs(Rt.paint_circle["circle-opacity"]),"circle-translate":new ds(Rt.paint_circle["circle-translate"]),"circle-translate-anchor":new ds(Rt.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new ds(Rt.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new ds(Rt.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new fs(Rt.paint_circle["circle-stroke-width"]),"circle-stroke-color":new fs(Rt.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new fs(Rt.paint_circle["circle-stroke-opacity"])}),layout:no},so="undefined"!=typeof Float32Array?Float32Array:Array;function ao(){var t=new so(9);return so!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[5]=0,t[6]=0,t[7]=0),t[0]=1,t[4]=1,t[8]=1,t}function oo(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function lo(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],d=e[10],f=e[11],y=e[12],m=e[13],g=e[14],x=e[15],v=r[0],b=r[1],w=r[2],_=r[3];return t[0]=v*n+b*o+w*h+_*y,t[1]=v*i+b*l+w*p+_*m,t[2]=v*s+b*u+w*d+_*g,t[3]=v*a+b*c+w*f+_*x,t[4]=(v=r[4])*n+(b=r[5])*o+(w=r[6])*h+(_=r[7])*y,t[5]=v*i+b*l+w*p+_*m,t[6]=v*s+b*u+w*d+_*g,t[7]=v*a+b*c+w*f+_*x,t[8]=(v=r[8])*n+(b=r[9])*o+(w=r[10])*h+(_=r[11])*y,t[9]=v*i+b*l+w*p+_*m,t[10]=v*s+b*u+w*d+_*g,t[11]=v*a+b*c+w*f+_*x,t[12]=(v=r[12])*n+(b=r[13])*o+(w=r[14])*h+(_=r[15])*y,t[13]=v*i+b*l+w*p+_*m,t[14]=v*s+b*u+w*d+_*g,t[15]=v*a+b*c+w*f+_*x,t}Math.hypot||(Math.hypot=function(){for(var t=0,e=arguments.length;e--;)t+=arguments[e]*arguments[e];return Math.sqrt(t)});var uo=lo;function co(){var t=new so(3);return so!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t}function ho(t){return Math.hypot(t[0],t[1],t[2])}function po(t,e,r){var n=new so(3);return n[0]=t,n[1]=e,n[2]=r,n}function fo(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t}function yo(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t}function mo(t,e){var r=e[0],n=e[1],i=e[2],s=r*r+n*n+i*i;return s>0&&(s=1/Math.sqrt(s)),t[0]=e[0]*s,t[1]=e[1]*s,t[2]=e[2]*s,t}function go(t,e,r){var n=r[0],i=r[1],s=r[2],a=e[0],o=e[1],l=e[2],u=i*l-s*o,c=s*a-n*l,h=n*o-i*a,p=i*h-s*c,d=s*u-n*h,f=n*c-i*u,y=2*r[3];return c*=y,h*=y,d*=2,f*=2,t[0]=a+(u*=y)+(p*=2),t[1]=o+c+d,t[2]=l+h+f,t}var xo,vo=fo,bo=ho;function wo(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3];return t[0]=r[0]*n+r[4]*i+r[8]*s+r[12]*a,t[1]=r[1]*n+r[5]*i+r[9]*s+r[13]*a,t[2]=r[2]*n+r[6]*i+r[10]*s+r[14]*a,t[3]=r[3]*n+r[7]*i+r[11]*s+r[15]*a,t}function _o(){var t=new so(4);return so!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t[3]=1,t}function ko(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t}function Ao(t,e,r){r*=.5;var n=e[0],i=e[1],s=e[2],a=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=n*l+a*o,t[1]=i*l+s*o,t[2]=s*l-i*o,t[3]=a*l-n*o,t}function So(t,e,r){const n=wo([],[t.x,t.y,e,1],r);return new i(n[0]/n[3],n[1]/n[3])}co(),xo=new so(4),so!=Float32Array&&(xo[0]=0,xo[1]=0,xo[2]=0,xo[3]=0),co(),po(1,0,0),po(0,1,0),_o(),_o(),ao();const Io=po(0,0,0),zo=po(0,0,1);function To(t,e){const r=co();return Io[2]=e,t.intersectsPlane(Io,zo,r),new i(r[0],r[1])}class Mo extends $a{}function Eo(t,{width:e,height:r},n,i){if(i){if(i instanceof Uint8ClampedArray)i=new Uint8Array(i.buffer);else if(i.length!==e*r*n)throw new RangeError("mismatched image size")}else i=new Uint8Array(e*r*n);return t.width=e,t.height=r,t.data=i,t}function Bo(t,{width:e,height:r},n){if(e===t.width&&r===t.height)return;const i=Eo({},{width:e,height:r},n);Co(t,i,{x:0,y:0},{x:0,y:0},{width:Math.min(t.width,e),height:Math.min(t.height,r)},n),t.width=e,t.height=r,t.data=i.data;}function Co(t,e,r,n,i,s){if(0===i.width||0===i.height)return e;if(i.width>t.width||i.height>t.height||r.x>t.width-i.width||r.y>t.height-i.height)throw new RangeError("out of range source coordinates for image copy");if(i.width>e.width||i.height>e.height||n.x>e.width-i.width||n.y>e.height-i.height)throw new RangeError("out of range destination coordinates for image copy");const a=t.data,o=e.data;for(let l=0;l<i.height;l++){const u=((r.y+l)*t.width+r.x)*s,c=((n.y+l)*e.width+n.x)*s;for(let t=0;t<i.width*s;t++)o[c+t]=a[u+t];}return e}si("HeatmapBucket",Mo,{omit:["layers"]});class Po{constructor(t,e){Eo(this,t,1,e);}resize(t){Bo(this,t,1);}clone(){return new Po({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){Co(t,e,r,n,i,1);}}class Vo{constructor(t,e){Eo(this,t,4,e);}resize(t){Bo(this,t,4);}replace(t,e){e?this.data.set(t):this.data=t instanceof Uint8ClampedArray?new Uint8Array(t.buffer):t;}clone(){return new Vo({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){Co(t,e,r,n,i,4);}}si("AlphaImage",Po),si("RGBAImage",Vo);var Do={paint:new xs({"heatmap-radius":new fs(Rt.paint_heatmap["heatmap-radius"]),"heatmap-weight":new fs(Rt.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new ds(Rt.paint_heatmap["heatmap-intensity"]),"heatmap-color":new gs(Rt.paint_heatmap["heatmap-color"]),"heatmap-opacity":new ds(Rt.paint_heatmap["heatmap-opacity"])})};function Fo(t){const e={},r=t.resolution||256,n=t.clips?t.clips.length:1,i=t.image||new Vo({width:r,height:n}),s=(r,n,s)=>{e[t.evaluationKey]=s;const a=t.expression.evaluate(e);i.data[r+n+0]=Math.floor(255*a.r/a.a),i.data[r+n+1]=Math.floor(255*a.g/a.a),i.data[r+n+2]=Math.floor(255*a.b/a.a),i.data[r+n+3]=Math.floor(255*a.a);};if(t.clips)for(let e=0,i=0;e<n;++e,i+=4*r)for(let n=0,a=0;n<r;n++,a+=4){const o=n/(r-1),{start:l,end:u}=t.clips[e];s(i,a,l*(1-o)+u*o);}else for(let t=0,e=0;t<r;t++,e+=4)s(0,e,t/(r-1));return i}var Lo={paint:new xs({"hillshade-illumination-direction":new ds(Rt.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-anchor":new ds(Rt.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new ds(Rt.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new ds(Rt.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new ds(Rt.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new ds(Rt.paint_hillshade["hillshade-accent-color"])})};const Ro=ks([{name:"a_pos",components:2,type:"Int16"}],4),{members:Uo}=Ro;var $o=qo,Oo=qo;function qo(t,e,r){r=r||2;var n,i,s,a,o,l,u,c=e&&e.length,h=c?e[0]*r:t.length,p=No(t,0,h,r,!0),d=[];if(!p||p.next===p.prev)return d;if(c&&(p=function(t,e,r,n){var i,s,a,o=[];for(i=0,s=e.length;i<s;i++)(a=No(t,e[i]*n,i<s-1?e[i+1]*n:t.length,n,!1))===a.next&&(a.steiner=!0),o.push(tl(a));for(o.sort(Yo),i=0;i<o.length;i++)Jo(o[i],r),r=jo(r,r.next);return r}(t,e,p,r)),t.length>80*r){n=s=t[0],i=a=t[1];for(var f=r;f<h;f+=r)(o=t[f])<n&&(n=o),(l=t[f+1])<i&&(i=l),o>s&&(s=o),l>a&&(a=l);u=0!==(u=Math.max(s-n,a-i))?1/u:0;}return Go(p,d,r,n,i,u),d}function No(t,e,r,n,i){var s,a;if(i===dl(t,e,r,n)>0)for(s=e;s<r;s+=n)a=cl(s,t[s],t[s+1],a);else for(s=r-n;s>=e;s-=n)a=cl(s,t[s],t[s+1],a);return a&&il(a,a.next)&&(hl(a),a=a.next),a}function jo(t,e){if(!t)return t;e||(e=t);var r,n=t;do{if(r=!1,n.steiner||!il(n,n.next)&&0!==nl(n.prev,n,n.next))n=n.next;else {if(hl(n),(n=e=n.prev)===n.next)break;r=!0;}}while(r||n!==e);return e}function Go(t,e,r,n,i,s,a){if(t){!a&&s&&function(t,e,r,n){var i=t;do{null===i.z&&(i.z=Qo(i.x,i.y,e,r,n)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next;}while(i!==t);i.prevZ.nextZ=null,i.prevZ=null,function(t){var e,r,n,i,s,a,o,l,u=1;do{for(r=t,t=null,s=null,a=0;r;){for(a++,n=r,o=0,e=0;e<u&&(o++,n=n.nextZ);e++);for(l=u;o>0||l>0&&n;)0!==o&&(0===l||!n||r.z<=n.z)?(i=r,r=r.nextZ,o--):(i=n,n=n.nextZ,l--),s?s.nextZ=i:t=i,i.prevZ=s,s=i;r=n;}s.nextZ=null,u*=2;}while(a>1)}(i);}(t,n,i,s);for(var o,l,u=t;t.prev!==t.next;)if(o=t.prev,l=t.next,s?Xo(t,n,i,s):Zo(t))e.push(o.i/r),e.push(t.i/r),e.push(l.i/r),hl(t),t=l.next,u=l.next;else if((t=l)===u){a?1===a?Go(t=Ko(jo(t),e,r),e,r,n,i,s,2):2===a&&Ho(t,e,r,n,i,s):Go(jo(t),e,r,n,i,s,1);break}}}function Zo(t){var e=t.prev,r=t,n=t.next;if(nl(e,r,n)>=0)return !1;for(var i=t.next.next;i!==t.prev;){if(el(e.x,e.y,r.x,r.y,n.x,n.y,i.x,i.y)&&nl(i.prev,i,i.next)>=0)return !1;i=i.next;}return !0}function Xo(t,e,r,n){var i=t.prev,s=t,a=t.next;if(nl(i,s,a)>=0)return !1;for(var o=i.x>s.x?i.x>a.x?i.x:a.x:s.x>a.x?s.x:a.x,l=i.y>s.y?i.y>a.y?i.y:a.y:s.y>a.y?s.y:a.y,u=Qo(i.x<s.x?i.x<a.x?i.x:a.x:s.x<a.x?s.x:a.x,i.y<s.y?i.y<a.y?i.y:a.y:s.y<a.y?s.y:a.y,e,r,n),c=Qo(o,l,e,r,n),h=t.prevZ,p=t.nextZ;h&&h.z>=u&&p&&p.z<=c;){if(h!==t.prev&&h!==t.next&&el(i.x,i.y,s.x,s.y,a.x,a.y,h.x,h.y)&&nl(h.prev,h,h.next)>=0)return !1;if(h=h.prevZ,p!==t.prev&&p!==t.next&&el(i.x,i.y,s.x,s.y,a.x,a.y,p.x,p.y)&&nl(p.prev,p,p.next)>=0)return !1;p=p.nextZ;}for(;h&&h.z>=u;){if(h!==t.prev&&h!==t.next&&el(i.x,i.y,s.x,s.y,a.x,a.y,h.x,h.y)&&nl(h.prev,h,h.next)>=0)return !1;h=h.prevZ;}for(;p&&p.z<=c;){if(p!==t.prev&&p!==t.next&&el(i.x,i.y,s.x,s.y,a.x,a.y,p.x,p.y)&&nl(p.prev,p,p.next)>=0)return !1;p=p.nextZ;}return !0}function Ko(t,e,r){var n=t;do{var i=n.prev,s=n.next.next;!il(i,s)&&sl(i,n,n.next,s)&&ll(i,s)&&ll(s,i)&&(e.push(i.i/r),e.push(n.i/r),e.push(s.i/r),hl(n),hl(n.next),n=t=s),n=n.next;}while(n!==t);return jo(n)}function Ho(t,e,r,n,i,s){var a=t;do{for(var o=a.next.next;o!==a.prev;){if(a.i!==o.i&&rl(a,o)){var l=ul(a,o);return a=jo(a,a.next),l=jo(l,l.next),Go(a,e,r,n,i,s),void Go(l,e,r,n,i,s)}o=o.next;}a=a.next;}while(a!==t)}function Yo(t,e){return t.x-e.x}function Jo(t,e){if(e=function(t,e){var r,n=e,i=t.x,s=t.y,a=-1/0;do{if(s<=n.y&&s>=n.next.y&&n.next.y!==n.y){var o=n.x+(s-n.y)*(n.next.x-n.x)/(n.next.y-n.y);if(o<=i&&o>a){if(a=o,o===i){if(s===n.y)return n;if(s===n.next.y)return n.next}r=n.x<n.next.x?n:n.next;}}n=n.next;}while(n!==e);if(!r)return null;if(i===a)return r;var l,u=r,c=r.x,h=r.y,p=1/0;n=r;do{i>=n.x&&n.x>=c&&i!==n.x&&el(s<h?i:a,s,c,h,s<h?a:i,s,n.x,n.y)&&(l=Math.abs(s-n.y)/(i-n.x),ll(n,t)&&(l<p||l===p&&(n.x>r.x||n.x===r.x&&Wo(r,n)))&&(r=n,p=l)),n=n.next;}while(n!==u);return r}(t,e)){var r=ul(e,t);jo(e,e.next),jo(r,r.next);}}function Wo(t,e){return nl(t.prev,t,e.prev)<0&&nl(e.next,t,t.next)<0}function Qo(t,e,r,n,i){return (t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=32767*(t-r)*i)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=32767*(e-n)*i)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function tl(t){var e=t,r=t;do{(e.x<r.x||e.x===r.x&&e.y<r.y)&&(r=e),e=e.next;}while(e!==t);return r}function el(t,e,r,n,i,s,a,o){return (i-a)*(e-o)-(t-a)*(s-o)>=0&&(t-a)*(n-o)-(r-a)*(e-o)>=0&&(r-a)*(s-o)-(i-a)*(n-o)>=0}function rl(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){var r=t;do{if(r.i!==t.i&&r.next.i!==t.i&&r.i!==e.i&&r.next.i!==e.i&&sl(r,r.next,t,e))return !0;r=r.next;}while(r!==t);return !1}(t,e)&&(ll(t,e)&&ll(e,t)&&function(t,e){var r=t,n=!1,i=(t.x+e.x)/2,s=(t.y+e.y)/2;do{r.y>s!=r.next.y>s&&r.next.y!==r.y&&i<(r.next.x-r.x)*(s-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next;}while(r!==t);return n}(t,e)&&(nl(t.prev,t,e.prev)||nl(t,e.prev,e))||il(t,e)&&nl(t.prev,t,t.next)>0&&nl(e.prev,e,e.next)>0)}function nl(t,e,r){return (e.y-t.y)*(r.x-e.x)-(e.x-t.x)*(r.y-e.y)}function il(t,e){return t.x===e.x&&t.y===e.y}function sl(t,e,r,n){var i=ol(nl(t,e,r)),s=ol(nl(t,e,n)),a=ol(nl(r,n,t)),o=ol(nl(r,n,e));return i!==s&&a!==o||!(0!==i||!al(t,r,e))||!(0!==s||!al(t,n,e))||!(0!==a||!al(r,t,n))||!(0!==o||!al(r,e,n))}function al(t,e,r){return e.x<=Math.max(t.x,r.x)&&e.x>=Math.min(t.x,r.x)&&e.y<=Math.max(t.y,r.y)&&e.y>=Math.min(t.y,r.y)}function ol(t){return t>0?1:t<0?-1:0}function ll(t,e){return nl(t.prev,t,t.next)<0?nl(t,e,t.next)>=0&&nl(t,t.prev,e)>=0:nl(t,e,t.prev)<0||nl(t,t.next,e)<0}function ul(t,e){var r=new pl(t.i,t.x,t.y),n=new pl(e.i,e.x,e.y),i=t.next,s=e.prev;return t.next=e,e.prev=t,r.next=i,i.prev=r,n.next=r,r.prev=n,s.next=n,n.prev=s,n}function cl(t,e,r,n){var i=new pl(t,e,r);return n?(i.next=n.next,i.prev=n,n.next.prev=i,n.next=i):(i.prev=i,i.next=i),i}function hl(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ);}function pl(t,e,r){this.i=t,this.x=e,this.y=r,this.prev=null,this.next=null,this.z=null,this.prevZ=null,this.nextZ=null,this.steiner=!1;}function dl(t,e,r,n){for(var i=0,s=e,a=r-n;s<r;s+=n)i+=(t[a]-t[s])*(t[s+1]+t[a+1]),a=s;return i}function fl(t,e,r,n,i){yl(t,e,r||0,n||t.length-1,i||gl);}function yl(t,e,r,n,i){for(;n>r;){if(n-r>600){var s=n-r+1,a=e-r+1,o=Math.log(s),l=.5*Math.exp(2*o/3),u=.5*Math.sqrt(o*l*(s-l)/s)*(a-s/2<0?-1:1);yl(t,e,Math.max(r,Math.floor(e-a*l/s+u)),Math.min(n,Math.floor(e+(s-a)*l/s+u)),i);}var c=t[e],h=r,p=n;for(ml(t,r,e),i(t[n],c)>0&&ml(t,r,n);h<p;){for(ml(t,h,p),h++,p--;i(t[h],c)<0;)h++;for(;i(t[p],c)>0;)p--;}0===i(t[r],c)?ml(t,r,p):ml(t,++p,n),p<=e&&(r=p+1),e<=p&&(n=p-1);}}function ml(t,e,r){var n=t[e];t[e]=t[r],t[r]=n;}function gl(t,e){return t<e?-1:t>e?1:0}function xl(t,e){const r=t.length;if(r<=1)return [t];const n=[];let i,s;for(let e=0;e<r;e++){const r=B(t[e]);0!==r&&(t[e].area=Math.abs(r),void 0===s&&(s=r<0),s===r<0?(i&&n.push(i),i=[t[e]]):i.push(t[e]));}if(i&&n.push(i),e>1)for(let t=0;t<n.length;t++)n[t].length<=e||(fl(n[t],e,1,n[t].length-1,vl),n[t]=n[t].slice(0,e));return n}function vl(t,e){return e.area-t.area}function bl(t,e,r){const n=r.patternDependencies;let i=!1;for(const r of e){const e=r.paint.get(`${t}-pattern`);e.isConstant()||(i=!0);const s=e.constantOr(null);s&&(i=!0,n[s.to]=!0,n[s.from]=!0);}return i}function wl(t,e,r,n,i){const s=i.patternDependencies;for(const a of e){const e=a.paint.get(`${t}-pattern`).value;if("constant"!==e.kind){let t=e.evaluate({zoom:n-1},r,{},i.availableImages),o=e.evaluate({zoom:n},r,{},i.availableImages),l=e.evaluate({zoom:n+1},r,{},i.availableImages);t=t&&t.name?t.name:t,o=o&&o.name?o.name:o,l=l&&l.name?l.name:l,s[t]=!0,s[o]=!0,s[l]=!0,r.patterns[a.id]={min:t,mid:o,max:l};}}return r}qo.deviation=function(t,e,r,n){var i=e&&e.length,s=Math.abs(dl(t,0,i?e[0]*r:t.length,r));if(i)for(var a=0,o=e.length;a<o;a++)s-=Math.abs(dl(t,e[a]*r,a<o-1?e[a+1]*r:t.length,r));var l=0;for(a=0;a<n.length;a+=3){var u=n[a]*r,c=n[a+1]*r,h=n[a+2]*r;l+=Math.abs((t[u]-t[h])*(t[c+1]-t[u+1])-(t[u]-t[c])*(t[h+1]-t[u+1]));}return 0===s&&0===l?0:Math.abs((l-s)/s)},qo.flatten=function(t){for(var e=t[0][0].length,r={vertices:[],holes:[],dimensions:e},n=0,i=0;i<t.length;i++){for(var s=0;s<t[i].length;s++)for(var a=0;a<e;a++)r.vertices.push(t[i][s][a]);i>0&&r.holes.push(n+=t[i-1].length);}return r},$o.default=Oo;class _l{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.layoutVertexArray=new Ss,this.indexArray=new Ls,this.indexArray2=new Ns,this.programConfigurations=new Ia(t.layers,t.zoom),this.segments=new Pa,this.segments2=new Pa,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){this.hasPattern=bl("fill",this.layers,e);const n=this.layers[0].layout.get("fill-sort-key"),i=[];for(const{feature:s,id:a,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=Ra(s,t);if(!this.layers[0]._featureFilter.filter(new is(this.zoom),u,r))continue;const c=n?n.evaluate(u,{},r,e.availableImages):void 0,h={id:a,properties:s.properties,type:s.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:La(s),patterns:{},sortKey:c};i.push(h);}n&&i.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of i){const{geometry:i,index:s,sourceLayerIndex:a}=n;if(this.hasPattern){const t=wl("fill",this.layers,n,this.zoom,e);this.patternFeatures.push(t);}else this.addFeature(n,i,s,r,{});e.featureIndex.insert(t[s].feature,i,s,a,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}addFeatures(t,e,r){for(const t of this.patternFeatures)this.addFeature(t,t.geometry,t.index,e,r);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Uo),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.indexBuffer2=t.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy());}addFeature(t,e,r,n,i){for(const t of xl(e,500)){let e=0;for(const r of t)e+=r.length;const r=this.segments.prepareSegment(e,this.layoutVertexArray,this.indexArray),n=r.vertexLength,i=[],s=[];for(const e of t){if(0===e.length)continue;e!==t[0]&&s.push(i.length/2);const r=this.segments2.prepareSegment(e.length,this.layoutVertexArray,this.indexArray2),n=r.vertexLength;this.layoutVertexArray.emplaceBack(e[0].x,e[0].y),this.indexArray2.emplaceBack(n+e.length-1,n),i.push(e[0].x),i.push(e[0].y);for(let t=1;t<e.length;t++)this.layoutVertexArray.emplaceBack(e[t].x,e[t].y),this.indexArray2.emplaceBack(n+t-1,n+t),i.push(e[t].x),i.push(e[t].y);r.vertexLength+=e.length,r.primitiveLength+=e.length;}const a=$o(i,s);for(let t=0;t<a.length;t+=3)this.indexArray.emplaceBack(n+a[t],n+a[t+1],n+a[t+2]);r.vertexLength+=e,r.primitiveLength+=a.length/3;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,n);}}si("FillBucket",_l,{omit:["layers","patternFeatures"]});const kl=new xs({"fill-sort-key":new fs(Rt.layout_fill["fill-sort-key"])});var Al={paint:new xs({"fill-antialias":new ds(Rt.paint_fill["fill-antialias"]),"fill-opacity":new fs(Rt.paint_fill["fill-opacity"]),"fill-color":new fs(Rt.paint_fill["fill-color"]),"fill-outline-color":new fs(Rt.paint_fill["fill-outline-color"]),"fill-translate":new ds(Rt.paint_fill["fill-translate"]),"fill-translate-anchor":new ds(Rt.paint_fill["fill-translate-anchor"]),"fill-pattern":new ys(Rt.paint_fill["fill-pattern"])}),layout:kl};const Sl=ks([{name:"a_pos_normal_ed",components:4,type:"Int16"}]),Il=ks([{name:"a_centroid_pos",components:2,type:"Uint16"}]),{members:zl}=Sl;var Tl=Ml;function Ml(t,e,r,n,i){this.properties={},this.extent=r,this.type=0,this._pbf=t,this._geometry=-1,this._keys=n,this._values=i,t.readFields(El,this,e);}function El(t,e,r){1==t?e.id=r.readVarint():2==t?function(t,e){for(var r=t.readVarint()+t.pos;t.pos<r;){var n=e._keys[t.readVarint()],i=e._values[t.readVarint()];e.properties[n]=i;}}(r,e):3==t?e.type=r.readVarint():4==t&&(e._geometry=r.pos);}function Bl(t){for(var e,r,n=0,i=0,s=t.length,a=s-1;i<s;a=i++)n+=((r=t[a]).x-(e=t[i]).x)*(e.y+r.y);return n}Ml.types=["Unknown","Point","LineString","Polygon"],Ml.prototype.loadGeometry=function(){var t=this._pbf;t.pos=this._geometry;for(var e,r=t.readVarint()+t.pos,n=1,s=0,a=0,o=0,l=[];t.pos<r;){if(s<=0){var u=t.readVarint();n=7&u,s=u>>3;}if(s--,1===n||2===n)a+=t.readSVarint(),o+=t.readSVarint(),1===n&&(e&&l.push(e),e=[]),e.push(new i(a,o));else {if(7!==n)throw new Error("unknown command "+n);e&&e.push(e[0].clone());}}return e&&l.push(e),l},Ml.prototype.bbox=function(){var t=this._pbf;t.pos=this._geometry;for(var e=t.readVarint()+t.pos,r=1,n=0,i=0,s=0,a=1/0,o=-1/0,l=1/0,u=-1/0;t.pos<e;){if(n<=0){var c=t.readVarint();r=7&c,n=c>>3;}if(n--,1===r||2===r)(i+=t.readSVarint())<a&&(a=i),i>o&&(o=i),(s+=t.readSVarint())<l&&(l=s),s>u&&(u=s);else if(7!==r)throw new Error("unknown command "+r)}return [a,l,o,u]},Ml.prototype.toGeoJSON=function(t,e,r){var n,i,s=this.extent*Math.pow(2,r),a=this.extent*t,o=this.extent*e,l=this.loadGeometry(),u=Ml.types[this.type];function c(t){for(var e=0;e<t.length;e++){var r=t[e];t[e]=[360*(r.x+a)/s-180,360/Math.PI*Math.atan(Math.exp((180-360*(r.y+o)/s)*Math.PI/180))-90];}}switch(this.type){case 1:var h=[];for(n=0;n<l.length;n++)h[n]=l[n][0];c(l=h);break;case 2:for(n=0;n<l.length;n++)c(l[n]);break;case 3:for(l=function(t){var e=t.length;if(e<=1)return [t];for(var r,n,i=[],s=0;s<e;s++){var a=Bl(t[s]);0!==a&&(void 0===n&&(n=a<0),n===a<0?(r&&i.push(r),r=[t[s]]):r.push(t[s]));}return r&&i.push(r),i}(l),n=0;n<l.length;n++)for(i=0;i<l[n].length;i++)c(l[n][i]);}1===l.length?l=l[0]:u="Multi"+u;var p={type:"Feature",geometry:{type:u,coordinates:l},properties:this.properties};return "id"in this&&(p.id=this.id),p};var Cl=Pl;function Pl(t,e){this.version=1,this.name=null,this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(Vl,this,e),this.length=this._features.length;}function Vl(t,e,r){15===t?e.version=r.readVarint():1===t?e.name=r.readString():5===t?e.extent=r.readVarint():2===t?e._features.push(r.pos):3===t?e._keys.push(r.readString()):4===t&&e._values.push(function(t){for(var e=null,r=t.readVarint()+t.pos;t.pos<r;){var n=t.readVarint()>>3;e=1===n?t.readString():2===n?t.readFloat():3===n?t.readDouble():4===n?t.readVarint64():5===n?t.readVarint():6===n?t.readSVarint():7===n?t.readBoolean():null;}return e}(r));}function Dl(t,e,r){if(3===t){var n=new Cl(r,r.readVarint()+r.pos);n.length&&(e[n.name]=n);}}Pl.prototype.feature=function(t){if(t<0||t>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[t];var e=this._pbf.readVarint()+this._pbf.pos;return new Tl(this._pbf,e,this.extent,this._keys,this._values)};var Fl={VectorTile:function(t,e){this.layers=t.readFields(Dl,{},e);},VectorTileFeature:Tl,VectorTileLayer:Cl};const Ll=Fl.VectorTileFeature.types,Rl=Math.pow(2,13);function Ul(t,e,r,n,i,s,a,o){t.emplaceBack((e<<1)+a,(r<<1)+s,(Math.floor(n*Rl)<<1)+i,Math.round(o));}class $l{constructor(){this.acc=new i(0,0),this.polyCount=[];}startRing(t){this.currentPolyCount={edges:0,top:0},this.polyCount.push(this.currentPolyCount),this.min||(this.min=new i(t.x,t.y),this.max=new i(t.x,t.y));}append(t,e){this.currentPolyCount.edges++,this.acc._add(t);let r=!!this.borders;const n=this.min,i=this.max;t.x<n.x?(n.x=t.x,r=!0):t.x>i.x&&(i.x=t.x,r=!0),t.y<n.y?(n.y=t.y,r=!0):t.y>i.y&&(i.y=t.y,r=!0),((0===t.x||t.x===Va)&&t.x===e.x)!=((0===t.y||t.y===Va)&&t.y===e.y)&&this.processBorderOverlap(t,e),r&&this.checkBorderIntersection(t,e);}checkBorderIntersection(t,e){e.x<0!=t.x<0&&this.addBorderIntersection(0,rr(e.y,t.y,(0-e.x)/(t.x-e.x))),e.x>Va!=t.x>Va&&this.addBorderIntersection(1,rr(e.y,t.y,(Va-e.x)/(t.x-e.x))),e.y<0!=t.y<0&&this.addBorderIntersection(2,rr(e.x,t.x,(0-e.y)/(t.y-e.y))),e.y>Va!=t.y>Va&&this.addBorderIntersection(3,rr(e.x,t.x,(Va-e.y)/(t.y-e.y)));}addBorderIntersection(t,e){this.borders||(this.borders=[[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE]]);const r=this.borders[t];e<r[0]&&(r[0]=e),e>r[1]&&(r[1]=e);}processBorderOverlap(t,e){if(t.x===e.x){if(t.y===e.y)return;const r=0===t.x?0:1;this.addBorderIntersection(r,e.y),this.addBorderIntersection(r,t.y);}else {const r=0===t.y?2:3;this.addBorderIntersection(r,e.x),this.addBorderIntersection(r,t.x);}}centroid(){const t=this.polyCount.reduce(((t,e)=>t+e.edges),0);return 0!==t?this.acc.div(t)._round():new i(0,0)}span(){return new i(this.max.x-this.min.x,this.max.y-this.min.y)}intersectsCount(){return this.borders.reduce(((t,e)=>t+ +(e[0]!==Number.MAX_VALUE)),0)}}class Ol{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new Is,this.centroidVertexArray=new na,this.indexArray=new Ls,this.programConfigurations=new Ia(t.layers,t.zoom),this.segments=new Pa,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.enableTerrain=t.enableTerrain;}populate(t,e,r){this.features=[],this.hasPattern=bl("fill-extrusion",this.layers,e),this.featuresOnBorder=[],this.borders=[[],[],[],[]],this.borderDone=[!1,!1,!1,!1],this.tileToMeter=function(t){const e=Math.exp(Math.PI*(1-t.y/(1<<t.z)*2));return 80150034*e/(e*e+1)/Va/(1<<t.z)}(r);for(const{feature:n,id:i,index:s,sourceLayerIndex:a}of t){const t=this.layers[0]._featureFilter.needGeometry,o=Ra(n,t);if(!this.layers[0]._featureFilter.filter(new is(this.zoom),o,r))continue;const l={id:i,sourceLayerIndex:a,index:s,geometry:t?o.geometry:La(n),properties:n.properties,type:n.type,patterns:{}},u=this.layoutVertexArray.length;this.hasPattern?this.features.push(wl("fill-extrusion",this.layers,l,this.zoom,e)):this.addFeature(l,l.geometry,s,r,{}),e.featureIndex.insert(n,l.geometry,s,a,this.index,u);}this.sortBorders();}addFeatures(t,e,r){for(const t of this.features){const{geometry:n}=t;this.addFeature(t,n,t.index,e,r);}this.sortBorders();}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,zl),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}uploadCentroid(t){0!==this.centroidVertexArray.length&&(this.centroidVertexBuffer?this.needsCentroidUpdate&&this.centroidVertexBuffer.updateData(this.centroidVertexArray):this.centroidVertexBuffer=t.createVertexBuffer(this.centroidVertexArray,Il.members,!0),this.needsCentroidUpdate=!1);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.centroidVertexBuffer&&this.centroidVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}addFeature(t,e,r,n,i){const s=this.enableTerrain&&t.properties&&"Polygon"===Ll[t.type]?new $l:null;for(const r of xl(e,500)){let e=0,n=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray);if(0===r.length||(a=r[0]).every((t=>t.x<=0))||a.every((t=>t.x>=Va))||a.every((t=>t.y<=0))||a.every((t=>t.y>=Va)))continue;for(let t=0;t<r.length;t++){const i=r[t];if(0===i.length)continue;e+=i.length;let a=0;s&&s.startRing(i[0]);for(let t=0;t<i.length;t++){const e=i[t];if(t>=1){const r=i[t-1];if(!ql(e,r)){s&&s.append(e,r),n.vertexLength+4>Pa.MAX_VERTEX_ARRAY_LENGTH&&(n=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray));const t=e.sub(r)._perp(),i=t.x/(Math.abs(t.x)+Math.abs(t.y)),o=t.y>0?1:0,l=r.dist(e);a+l>32768&&(a=0),Ul(this.layoutVertexArray,e.x,e.y,i,o,0,0,a),Ul(this.layoutVertexArray,e.x,e.y,i,o,0,1,a),a+=l,Ul(this.layoutVertexArray,r.x,r.y,i,o,0,0,a),Ul(this.layoutVertexArray,r.x,r.y,i,o,0,1,a);const u=n.vertexLength;this.indexArray.emplaceBack(u,u+2,u+1),this.indexArray.emplaceBack(u+1,u+2,u+3),n.vertexLength+=4,n.primitiveLength+=2;}}}}if(n.vertexLength+e>Pa.MAX_VERTEX_ARRAY_LENGTH&&(n=this.segments.prepareSegment(e,this.layoutVertexArray,this.indexArray)),"Polygon"!==Ll[t.type])continue;const i=[],o=[],l=n.vertexLength;for(let t=0;t<r.length;t++){const e=r[t];if(0!==e.length){e!==r[0]&&o.push(i.length/2);for(let t=0;t<e.length;t++){const r=e[t];Ul(this.layoutVertexArray,r.x,r.y,0,0,1,1,0),i.push(r.x),i.push(r.y),s&&s.currentPolyCount.top++;}}}const u=$o(i,o);for(let t=0;t<u.length;t+=3)this.indexArray.emplaceBack(l+u[t],l+u[t+2],l+u[t+1]);n.primitiveLength+=u.length/3,n.vertexLength+=e;}var a;if(s&&s.polyCount.length>0){if(s.borders){s.vertexArrayOffset=this.centroidVertexArray.length;const t=s.borders,e=this.featuresOnBorder.push(s)-1;for(let r=0;r<4;r++)t[r][0]!==Number.MAX_VALUE&&this.borders[r].push(e);}this.encodeCentroid(s.borders?void 0:s.centroid(),s);}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,n);}sortBorders(){for(let t=0;t<4;t++)this.borders[t].sort(((e,r)=>this.featuresOnBorder[e].borders[t][0]-this.featuresOnBorder[r].borders[t][0]));}encodeCentroid(t,e,r=!0){let n,i;if(t)if(0!==t.y){const r=e.span()._mult(this.tileToMeter);n=(Math.max(t.x,1)<<3)+Math.min(7,Math.round(r.x/10)),i=(Math.max(t.y,1)<<3)+Math.min(7,Math.round(r.y/10));}else n=Math.ceil(7.3*t.x),i=0;else n=0,i=+r;let s=r?this.centroidVertexArray.length:e.vertexArrayOffset;for(const t of e.polyCount){r&&this.centroidVertexArray.resize(this.centroidVertexArray.length+4*t.edges+t.top);for(let e=0;e<2*t.edges;e++)this.centroidVertexArray.emplace(s++,0,i),this.centroidVertexArray.emplace(s++,n,i);for(let e=0;e<t.top;e++)this.centroidVertexArray.emplace(s++,n,i);}}}function ql(t,e){return t.x===e.x&&(t.x<0||t.x>Va)||t.y===e.y&&(t.y<0||t.y>Va)}si("FillExtrusionBucket",Ol,{omit:["layers","features"]}),si("PartMetadata",$l);var Nl={paint:new xs({"fill-extrusion-opacity":new ds(Rt["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new fs(Rt["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new ds(Rt["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new ds(Rt["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new ys(Rt["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new fs(Rt["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new fs(Rt["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new ds(Rt["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"])})};function jl(t,e){return t.x*e.x+t.y*e.y}function Gl(t,e){if(1===t.length){let r=0;const n=e[r++];let i;for(;!i||n.equals(i);)if(i=e[r++],!i)return 1/0;for(;r<e.length;r++){const s=e[r],a=t[0],o=i.sub(n),l=s.sub(n),u=a.sub(n),c=jl(o,o),h=jl(o,l),p=jl(l,l),d=jl(u,o),f=jl(u,l),y=c*p-h*h,m=(p*d-h*f)/y,g=(c*f-h*d)/y,x=n.z*(1-m-g)+i.z*m+s.z*g;if(isFinite(x))return x}return 1/0}{let t=1/0;for(const r of e)t=Math.min(t,r.z);return t}}function Zl(t){const e=new i(t[0],t[1]);return e.z=t[2],e}function Xl(t,e,r,n,i,s,a,o){const l=a*i.getElevationAt(t,e,!0,!0),u=0!==s[0],c=u?0===s[1]?a*(s[0]/7.3):a*function(t,e,r){const n=Math.floor(e[0]/8),i=Math.floor(e[1]/8),s=10*(e[0]-8*n),a=10*(e[1]-8*i),o=t.getElevationAt(n,i,!0,!0),l=t.getMeterToDEM(r),u=Math.floor(.5*(s*l-1)),c=Math.floor(.5*(a*l-1)),h=t.tileCoordToPixel(n,i),p=2*u+1,d=2*c+1,f=function(t,e,r,n,i){return [t.getElevationAtPixel(e,r,!0),t.getElevationAtPixel(e+i,r,!0),t.getElevationAtPixel(e,r+i,!0),t.getElevationAtPixel(e+n,r+i,!0)]}(t,h.x-u,h.y-c,p,d),y=Math.abs(f[0]-f[1]),m=Math.abs(f[2]-f[3]),g=Math.abs(f[0]-f[2])+Math.abs(f[1]-f[3]),x=Math.min(.25,.5*l*(y+m)/p),v=Math.min(.25,.5*l*g/d);return o+Math.max(x*s,v*a)}(i,s,o):l;return {base:l+(0===r)?-1:r,top:u?Math.max(c+n,l+r+2):l+n}}const Kl=ks([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"},{name:"a_linesofar",components:1,type:"Float32"}],4),{members:Hl}=Kl,Yl=ks([{name:"a_uv_x",components:1,type:"Float32"},{name:"a_split_index",components:1,type:"Float32"}]),{members:Jl}=Yl,Wl=Fl.VectorTileFeature.types,Ql=Math.cos(Math.PI/180*37.5);class tu{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((t=>{this.gradients[t.id]={};})),this.layoutVertexArray=new zs,this.layoutVertexArray2=new Ts,this.indexArray=new Ls,this.programConfigurations=new Ia(t.layers,t.zoom),this.segments=new Pa,this.maxLineLength=0,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){this.hasPattern=bl("line",this.layers,e);const n=this.layers[0].layout.get("line-sort-key"),i=[];for(const{feature:e,id:s,index:a,sourceLayerIndex:o}of t){const t=this.layers[0]._featureFilter.needGeometry,l=Ra(e,t);if(!this.layers[0]._featureFilter.filter(new is(this.zoom),l,r))continue;const u=n?n.evaluate(l,{},r):void 0,c={id:s,properties:e.properties,type:e.type,sourceLayerIndex:o,index:a,geometry:t?l.geometry:La(e),patterns:{},sortKey:u};i.push(c);}n&&i.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of i){const{geometry:i,index:s,sourceLayerIndex:a}=n;if(this.hasPattern){const t=wl("line",this.layers,n,this.zoom,e);this.patternFeatures.push(t);}else this.addFeature(n,i,s,r,{});e.featureIndex.insert(t[s].feature,i,s,a,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}addFeatures(t,e,r){for(const t of this.patternFeatures)this.addFeature(t,t.geometry,t.index,e,r);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=t.createVertexBuffer(this.layoutVertexArray2,Jl)),this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Hl),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}lineFeatureClips(t){if(t.properties&&t.properties.hasOwnProperty("mapbox_clip_start")&&t.properties.hasOwnProperty("mapbox_clip_end"))return {start:+t.properties.mapbox_clip_start,end:+t.properties.mapbox_clip_end}}addFeature(t,e,r,n,i){const s=this.layers[0].layout,a=s.get("line-join").evaluate(t,{}),o=s.get("line-cap"),l=s.get("line-miter-limit"),u=s.get("line-round-limit");this.lineClips=this.lineFeatureClips(t);for(const r of e)this.addLine(r,t,a,o,l,u);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,n);}addLine(t,e,r,n,i,s){if(this.distance=0,this.scaledDistance=0,this.totalDistance=0,this.lineSoFar=0,this.lineClips){this.lineClipsArray.push(this.lineClips);for(let e=0;e<t.length-1;e++)this.totalDistance+=t[e].dist(t[e+1]);this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance);}const a="Polygon"===Wl[e.type];let o=t.length;for(;o>=2&&t[o-1].equals(t[o-2]);)o--;let l=0;for(;l<o-1&&t[l].equals(t[l+1]);)l++;if(o<(a?3:2))return;"bevel"===r&&(i=1.05);const u=this.overscaling<=16?122880/(512*this.overscaling):0,c=this.segments.prepareSegment(10*o,this.layoutVertexArray,this.indexArray);let h,p,d,f,y;this.e1=this.e2=-1,a&&(h=t[o-2],y=t[l].sub(h)._unit()._perp());for(let e=l;e<o;e++){if(d=e===o-1?a?t[l+1]:void 0:t[e+1],d&&t[e].equals(d))continue;y&&(f=y),h&&(p=h),h=t[e],y=d?d.sub(h)._unit()._perp():f,f=f||y;let m=f.add(y);0===m.x&&0===m.y||m._unit();const g=f.x*y.x+f.y*y.y,x=m.x*y.x+m.y*y.y,v=0!==x?1/x:1/0,b=2*Math.sqrt(2-2*x),w=x<Ql&&p&&d,_=f.x*y.y-f.y*y.x>0;if(w&&e>l){const t=h.dist(p);if(t>2*u){const e=h.sub(h.sub(p)._mult(u/t)._round());this.updateDistance(p,e),this.addCurrentVertex(e,f,0,0,c),p=e;}}const k=p&&d;let A=k?r:a?"butt":n;if(k&&"round"===A&&(v<s?A="miter":v<=2&&(A="fakeround")),"miter"===A&&v>i&&(A="bevel"),"bevel"===A&&(v>2&&(A="flipbevel"),v<i&&(A="miter")),p&&this.updateDistance(p,h),"miter"===A)m._mult(v),this.addCurrentVertex(h,m,0,0,c);else if("flipbevel"===A){if(v>100)m=y.mult(-1);else {const t=v*f.add(y).mag()/f.sub(y).mag();m._perp()._mult(t*(_?-1:1));}this.addCurrentVertex(h,m,0,0,c),this.addCurrentVertex(h,m.mult(-1),0,0,c);}else if("bevel"===A||"fakeround"===A){const t=-Math.sqrt(v*v-1),e=_?t:0,r=_?0:t;if(p&&this.addCurrentVertex(h,f,e,r,c),"fakeround"===A){const t=Math.round(180*b/Math.PI/20);for(let e=1;e<t;e++){let r=e/t;if(.5!==r){const t=r-.5;r+=r*t*(r-1)*((1.0904+g*(g*(3.55645-1.43519*g)-3.2452))*t*t+(.848013+g*(.215638*g-1.06021)));}const n=y.sub(f)._mult(r)._add(f)._unit()._mult(_?-1:1);this.addHalfVertex(h,n.x,n.y,!1,_,0,c);}}d&&this.addCurrentVertex(h,y,-e,-r,c);}else if("butt"===A)this.addCurrentVertex(h,m,0,0,c);else if("square"===A){const t=p?1:-1;this.addCurrentVertex(h,m,t,t,c);}else "round"===A&&(p&&(this.addCurrentVertex(h,f,0,0,c),this.addCurrentVertex(h,f,1,1,c,!0)),d&&(this.addCurrentVertex(h,y,-1,-1,c,!0),this.addCurrentVertex(h,y,0,0,c)));if(w&&e<o-1){const t=h.dist(d);if(t>2*u){const e=h.add(d.sub(h)._mult(u/t)._round());this.updateDistance(h,e),this.addCurrentVertex(e,y,0,0,c),h=e;}}}}addCurrentVertex(t,e,r,n,i,s=!1){const a=e.y*n-e.x,o=-e.y-e.x*n;this.addHalfVertex(t,e.x+e.y*r,e.y-e.x*r,s,!1,r,i),this.addHalfVertex(t,a,o,s,!0,-n,i);}addHalfVertex({x:t,y:e},r,n,i,s,a,o){this.layoutVertexArray.emplaceBack((t<<1)+(i?1:0),(e<<1)+(s?1:0),Math.round(63*r)+128,Math.round(63*n)+128,1+(0===a?0:a<0?-1:1),0,this.lineSoFar),this.lineClips&&this.layoutVertexArray2.emplaceBack(this.scaledDistance,this.lineClipsArray.length);const l=o.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,this.e2,l),o.primitiveLength++),s?this.e2=l:this.e1=l;}updateScaledDistance(){if(this.lineClips){const t=this.totalDistance/(this.lineClips.end-this.lineClips.start);this.scaledDistance=this.distance/this.totalDistance,this.lineSoFar=t*this.lineClips.start+this.distance;}else this.lineSoFar=this.distance;}updateDistance(t,e){this.distance+=t.dist(e),this.updateScaledDistance();}}si("LineBucket",tu,{omit:["layers","patternFeatures"]});const eu=new xs({"line-cap":new ds(Rt.layout_line["line-cap"]),"line-join":new fs(Rt.layout_line["line-join"]),"line-miter-limit":new ds(Rt.layout_line["line-miter-limit"]),"line-round-limit":new ds(Rt.layout_line["line-round-limit"]),"line-sort-key":new fs(Rt.layout_line["line-sort-key"])});var ru={paint:new xs({"line-opacity":new fs(Rt.paint_line["line-opacity"]),"line-color":new fs(Rt.paint_line["line-color"]),"line-translate":new ds(Rt.paint_line["line-translate"]),"line-translate-anchor":new ds(Rt.paint_line["line-translate-anchor"]),"line-width":new fs(Rt.paint_line["line-width"]),"line-gap-width":new fs(Rt.paint_line["line-gap-width"]),"line-offset":new fs(Rt.paint_line["line-offset"]),"line-blur":new fs(Rt.paint_line["line-blur"]),"line-dasharray":new ms(Rt.paint_line["line-dasharray"]),"line-pattern":new ys(Rt.paint_line["line-pattern"]),"line-gradient":new gs(Rt.paint_line["line-gradient"])}),layout:eu};const nu=new class extends fs{possiblyEvaluate(t,e){return e=new is(Math.floor(e.zoom),{now:e.now,fadeDuration:e.fadeDuration,zoomHistory:e.zoomHistory,transition:e.transition}),super.possiblyEvaluate(t,e)}evaluate(t,e,r,n){return e=x({},e,{zoom:Math.floor(e.zoom)}),super.evaluate(t,e,r,n)}}(ru.paint.properties["line-width"].specification);function iu(t,e){return e>0?e+2*t:t}nu.useIntegerZoom=!0;const su=ks([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_data",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),au=ks([{name:"a_projected_pos",components:3,type:"Float32"}],4);ks([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const ou=ks([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"}]),lu=ks([{name:"a_size_scale",components:1,type:"Float32"},{name:"a_padding",components:2,type:"Float32"}]);ks([{type:"Int16",name:"anchorPointX"},{type:"Int16",name:"anchorPointY"},{type:"Float32",name:"x1"},{type:"Float32",name:"y1"},{type:"Float32",name:"x2"},{type:"Float32",name:"y2"},{type:"Int16",name:"padding"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const uu=ks([{name:"a_pos",components:2,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4),cu=ks([{name:"a_pos_2f",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);ks([{name:"triangle",components:3,type:"Uint16"}]),ks([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"}]),ks([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",name:"textBoxScale"},{type:"Float32",components:2,name:"textOffset"},{type:"Float32",name:"collisionCircleDiameter"}]),ks([{type:"Float32",name:"offsetX"}]),ks([{type:"Int16",name:"x"},{type:"Int16",name:"y"},{type:"Int16",name:"tileUnitDistanceFromAnchor"}]);var hu=24;const pu=128;function du(t,e){const{expression:r}=e;if("constant"===r.kind)return {kind:"constant",layoutSize:r.evaluate(new is(t+1))};if("source"===r.kind)return {kind:"source"};{const{zoomStops:e,interpolationType:n}=r;let i=0;for(;i<e.length&&e[i]<=t;)i++;i=Math.max(0,i-1);let s=i;for(;s<e.length&&e[s]<t+1;)s++;s=Math.min(e.length-1,s);const a=e[i],o=e[s];return "composite"===r.kind?{kind:"composite",minZoom:a,maxZoom:o,interpolationType:n}:{kind:"camera",minZoom:a,maxZoom:o,minSize:r.evaluate(new is(a)),maxSize:r.evaluate(new is(o)),interpolationType:n}}}function fu(t,{uSize:e,uSizeT:r},{lowerSize:n,upperSize:i}){return "source"===t.kind?n/pu:"composite"===t.kind?rr(n/pu,i/pu,r):e}function yu(t,e){let r=0,n=0;if("constant"===t.kind)n=t.layoutSize;else if("source"!==t.kind){const{interpolationType:i,minZoom:s,maxZoom:a}=t,o=i?f(wr.interpolationFactor(i,e,s,a),0,1):0;"camera"===t.kind?n=rr(t.minSize,t.maxSize,o):r=o;}return {uSizeT:r,uSize:n}}var mu=Object.freeze({__proto__:null,getSizeData:du,evaluateSizeForFeature:fu,evaluateSizeForZoom:yu,SIZE_PACK_FACTOR:pu});function gu(t,e,r){return t.sections.forEach((t=>{t.text=function(t,e,r){const n=e.layout.get("text-transform").evaluate(r,{});return "uppercase"===n?t=t.toLocaleUpperCase():"lowercase"===n&&(t=t.toLocaleLowerCase()),ns.applyArabicShaping&&(t=ns.applyArabicShaping(t)),t}(t.text,e,r);})),t}const xu={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂"};var vu=function(t,e,r,n,i){var s,a,o=8*i-n-1,l=(1<<o)-1,u=l>>1,c=-7,h=r?i-1:0,p=r?-1:1,d=t[e+h];for(h+=p,s=d&(1<<-c)-1,d>>=-c,c+=o;c>0;s=256*s+t[e+h],h+=p,c-=8);for(a=s&(1<<-c)-1,s>>=-c,c+=n;c>0;a=256*a+t[e+h],h+=p,c-=8);if(0===s)s=1-u;else {if(s===l)return a?NaN:1/0*(d?-1:1);a+=Math.pow(2,n),s-=u;}return (d?-1:1)*a*Math.pow(2,s-n)},bu=function(t,e,r,n,i,s){var a,o,l,u=8*s-i-1,c=(1<<u)-1,h=c>>1,p=23===i?Math.pow(2,-24)-Math.pow(2,-77):0,d=n?0:s-1,f=n?1:-1,y=e<0||0===e&&1/e<0?1:0;for(e=Math.abs(e),isNaN(e)||e===1/0?(o=isNaN(e)?1:0,a=c):(a=Math.floor(Math.log(e)/Math.LN2),e*(l=Math.pow(2,-a))<1&&(a--,l*=2),(e+=a+h>=1?p/l:p*Math.pow(2,1-h))*l>=2&&(a++,l/=2),a+h>=c?(o=0,a=c):a+h>=1?(o=(e*l-1)*Math.pow(2,i),a+=h):(o=e*Math.pow(2,h-1)*Math.pow(2,i),a=0));i>=8;t[r+d]=255&o,d+=f,o/=256,i-=8);for(a=a<<i|o,u+=i;u>0;t[r+d]=255&a,d+=f,a/=256,u-=8);t[r+d-f]|=128*y;},wu=_u;function _u(t){this.buf=ArrayBuffer.isView&&ArrayBuffer.isView(t)?t:new Uint8Array(t||0),this.pos=0,this.type=0,this.length=this.buf.length;}_u.Varint=0,_u.Fixed64=1,_u.Bytes=2,_u.Fixed32=5;var ku=4294967296,Au=1/ku,Su="undefined"==typeof TextDecoder?null:new TextDecoder("utf8");function Iu(t){return t.type===_u.Bytes?t.readVarint()+t.pos:t.pos+1}function zu(t,e,r){return r?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function Tu(t,e,r){var n=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));r.realloc(n);for(var i=r.pos-1;i>=t;i--)r.buf[i+n]=r.buf[i];}function Mu(t,e){for(var r=0;r<t.length;r++)e.writeVarint(t[r]);}function Eu(t,e){for(var r=0;r<t.length;r++)e.writeSVarint(t[r]);}function Bu(t,e){for(var r=0;r<t.length;r++)e.writeFloat(t[r]);}function Cu(t,e){for(var r=0;r<t.length;r++)e.writeDouble(t[r]);}function Pu(t,e){for(var r=0;r<t.length;r++)e.writeBoolean(t[r]);}function Vu(t,e){for(var r=0;r<t.length;r++)e.writeFixed32(t[r]);}function Du(t,e){for(var r=0;r<t.length;r++)e.writeSFixed32(t[r]);}function Fu(t,e){for(var r=0;r<t.length;r++)e.writeFixed64(t[r]);}function Lu(t,e){for(var r=0;r<t.length;r++)e.writeSFixed64(t[r]);}function Ru(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+16777216*t[e+3]}function Uu(t,e,r){t[r]=e,t[r+1]=e>>>8,t[r+2]=e>>>16,t[r+3]=e>>>24;}function $u(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+(t[e+3]<<24)}function Ou(t,e,r){1===t&&r.readMessage(qu,e);}function qu(t,e,r){if(3===t){const{id:t,bitmap:n,width:i,height:s,left:a,top:o,advance:l}=r.readMessage(Nu,{});e.push({id:t,bitmap:new Po({width:i+6,height:s+6},n),metrics:{width:i,height:s,left:a,top:o,advance:l}});}}function Nu(t,e,r){1===t?e.id=r.readVarint():2===t?e.bitmap=r.readBytes():3===t?e.width=r.readVarint():4===t?e.height=r.readVarint():5===t?e.left=r.readSVarint():6===t?e.top=r.readSVarint():7===t&&(e.advance=r.readVarint());}function ju(t){let e=0,r=0;for(const n of t)e+=n.w*n.h,r=Math.max(r,n.w);t.sort(((t,e)=>e.h-t.h));const n=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(e/.95)),r),h:1/0}];let i=0,s=0;for(const e of t)for(let t=n.length-1;t>=0;t--){const r=n[t];if(!(e.w>r.w||e.h>r.h)){if(e.x=r.x,e.y=r.y,s=Math.max(s,e.y+e.h),i=Math.max(i,e.x+e.w),e.w===r.w&&e.h===r.h){const e=n.pop();t<n.length&&(n[t]=e);}else e.h===r.h?(r.x+=e.w,r.w-=e.w):e.w===r.w?(r.y+=e.h,r.h-=e.h):(n.push({x:r.x+e.w,y:r.y,w:r.w-e.w,h:e.h}),r.y+=e.h,r.h-=e.h);break}}return {w:i,h:s,fill:e/(i*s)||0}}_u.prototype={destroy:function(){this.buf=null;},readFields:function(t,e,r){for(r=r||this.length;this.pos<r;){var n=this.readVarint(),i=n>>3,s=this.pos;this.type=7&n,t(i,e,this),this.pos===s&&this.skip(n);}return e},readMessage:function(t,e){return this.readFields(t,e,this.readVarint()+this.pos)},readFixed32:function(){var t=Ru(this.buf,this.pos);return this.pos+=4,t},readSFixed32:function(){var t=$u(this.buf,this.pos);return this.pos+=4,t},readFixed64:function(){var t=Ru(this.buf,this.pos)+Ru(this.buf,this.pos+4)*ku;return this.pos+=8,t},readSFixed64:function(){var t=Ru(this.buf,this.pos)+$u(this.buf,this.pos+4)*ku;return this.pos+=8,t},readFloat:function(){var t=vu(this.buf,this.pos,!0,23,4);return this.pos+=4,t},readDouble:function(){var t=vu(this.buf,this.pos,!0,52,8);return this.pos+=8,t},readVarint:function(t){var e,r,n=this.buf;return e=127&(r=n[this.pos++]),r<128?e:(e|=(127&(r=n[this.pos++]))<<7,r<128?e:(e|=(127&(r=n[this.pos++]))<<14,r<128?e:(e|=(127&(r=n[this.pos++]))<<21,r<128?e:function(t,e,r){var n,i,s=r.buf;if(n=(112&(i=s[r.pos++]))>>4,i<128)return zu(t,n,e);if(n|=(127&(i=s[r.pos++]))<<3,i<128)return zu(t,n,e);if(n|=(127&(i=s[r.pos++]))<<10,i<128)return zu(t,n,e);if(n|=(127&(i=s[r.pos++]))<<17,i<128)return zu(t,n,e);if(n|=(127&(i=s[r.pos++]))<<24,i<128)return zu(t,n,e);if(n|=(1&(i=s[r.pos++]))<<31,i<128)return zu(t,n,e);throw new Error("Expected varint not more than 10 bytes")}(e|=(15&(r=n[this.pos]))<<28,t,this))))},readVarint64:function(){return this.readVarint(!0)},readSVarint:function(){var t=this.readVarint();return t%2==1?(t+1)/-2:t/2},readBoolean:function(){return Boolean(this.readVarint())},readString:function(){var t=this.readVarint()+this.pos,e=this.pos;return this.pos=t,t-e>=12&&Su?function(t,e,r){return Su.decode(t.subarray(e,r))}(this.buf,e,t):function(t,e,r){for(var n="",i=e;i<r;){var s,a,o,l=t[i],u=null,c=l>239?4:l>223?3:l>191?2:1;if(i+c>r)break;1===c?l<128&&(u=l):2===c?128==(192&(s=t[i+1]))&&(u=(31&l)<<6|63&s)<=127&&(u=null):3===c?(a=t[i+2],128==(192&(s=t[i+1]))&&128==(192&a)&&((u=(15&l)<<12|(63&s)<<6|63&a)<=2047||u>=55296&&u<=57343)&&(u=null)):4===c&&(a=t[i+2],o=t[i+3],128==(192&(s=t[i+1]))&&128==(192&a)&&128==(192&o)&&((u=(15&l)<<18|(63&s)<<12|(63&a)<<6|63&o)<=65535||u>=1114112)&&(u=null)),null===u?(u=65533,c=1):u>65535&&(u-=65536,n+=String.fromCharCode(u>>>10&1023|55296),u=56320|1023&u),n+=String.fromCharCode(u),i+=c;}return n}(this.buf,e,t)},readBytes:function(){var t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e},readPackedVarint:function(t,e){if(this.type!==_u.Bytes)return t.push(this.readVarint(e));var r=Iu(this);for(t=t||[];this.pos<r;)t.push(this.readVarint(e));return t},readPackedSVarint:function(t){if(this.type!==_u.Bytes)return t.push(this.readSVarint());var e=Iu(this);for(t=t||[];this.pos<e;)t.push(this.readSVarint());return t},readPackedBoolean:function(t){if(this.type!==_u.Bytes)return t.push(this.readBoolean());var e=Iu(this);for(t=t||[];this.pos<e;)t.push(this.readBoolean());return t},readPackedFloat:function(t){if(this.type!==_u.Bytes)return t.push(this.readFloat());var e=Iu(this);for(t=t||[];this.pos<e;)t.push(this.readFloat());return t},readPackedDouble:function(t){if(this.type!==_u.Bytes)return t.push(this.readDouble());var e=Iu(this);for(t=t||[];this.pos<e;)t.push(this.readDouble());return t},readPackedFixed32:function(t){if(this.type!==_u.Bytes)return t.push(this.readFixed32());var e=Iu(this);for(t=t||[];this.pos<e;)t.push(this.readFixed32());return t},readPackedSFixed32:function(t){if(this.type!==_u.Bytes)return t.push(this.readSFixed32());var e=Iu(this);for(t=t||[];this.pos<e;)t.push(this.readSFixed32());return t},readPackedFixed64:function(t){if(this.type!==_u.Bytes)return t.push(this.readFixed64());var e=Iu(this);for(t=t||[];this.pos<e;)t.push(this.readFixed64());return t},readPackedSFixed64:function(t){if(this.type!==_u.Bytes)return t.push(this.readSFixed64());var e=Iu(this);for(t=t||[];this.pos<e;)t.push(this.readSFixed64());return t},skip:function(t){var e=7&t;if(e===_u.Varint)for(;this.buf[this.pos++]>127;);else if(e===_u.Bytes)this.pos=this.readVarint()+this.pos;else if(e===_u.Fixed32)this.pos+=4;else {if(e!==_u.Fixed64)throw new Error("Unimplemented type: "+e);this.pos+=8;}},writeTag:function(t,e){this.writeVarint(t<<3|e);},realloc:function(t){for(var e=this.length||16;e<this.pos+t;)e*=2;if(e!==this.length){var r=new Uint8Array(e);r.set(this.buf),this.buf=r,this.length=e;}},finish:function(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)},writeFixed32:function(t){this.realloc(4),Uu(this.buf,t,this.pos),this.pos+=4;},writeSFixed32:function(t){this.realloc(4),Uu(this.buf,t,this.pos),this.pos+=4;},writeFixed64:function(t){this.realloc(8),Uu(this.buf,-1&t,this.pos),Uu(this.buf,Math.floor(t*Au),this.pos+4),this.pos+=8;},writeSFixed64:function(t){this.realloc(8),Uu(this.buf,-1&t,this.pos),Uu(this.buf,Math.floor(t*Au),this.pos+4),this.pos+=8;},writeVarint:function(t){(t=+t||0)>268435455||t<0?function(t,e){var r,n;if(t>=0?(r=t%4294967296|0,n=t/4294967296|0):(n=~(-t/4294967296),4294967295^(r=~(-t%4294967296))?r=r+1|0:(r=0,n=n+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,r){r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,r.buf[r.pos]=127&(t>>>=7);}(r,0,e),function(t,e){var r=(7&t)<<4;e.buf[e.pos++]|=r|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))));}(n,e);}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))));},writeSVarint:function(t){this.writeVarint(t<0?2*-t-1:2*t);},writeBoolean:function(t){this.writeVarint(Boolean(t));},writeString:function(t){t=String(t),this.realloc(4*t.length),this.pos++;var e=this.pos;this.pos=function(t,e,r){for(var n,i,s=0;s<e.length;s++){if((n=e.charCodeAt(s))>55295&&n<57344){if(!i){n>56319||s+1===e.length?(t[r++]=239,t[r++]=191,t[r++]=189):i=n;continue}if(n<56320){t[r++]=239,t[r++]=191,t[r++]=189,i=n;continue}n=i-55296<<10|n-56320|65536,i=null;}else i&&(t[r++]=239,t[r++]=191,t[r++]=189,i=null);n<128?t[r++]=n:(n<2048?t[r++]=n>>6|192:(n<65536?t[r++]=n>>12|224:(t[r++]=n>>18|240,t[r++]=n>>12&63|128),t[r++]=n>>6&63|128),t[r++]=63&n|128);}return r}(this.buf,t,this.pos);var r=this.pos-e;r>=128&&Tu(e,r,this),this.pos=e-1,this.writeVarint(r),this.pos+=r;},writeFloat:function(t){this.realloc(4),bu(this.buf,t,this.pos,!0,23,4),this.pos+=4;},writeDouble:function(t){this.realloc(8),bu(this.buf,t,this.pos,!0,52,8),this.pos+=8;},writeBytes:function(t){var e=t.length;this.writeVarint(e),this.realloc(e);for(var r=0;r<e;r++)this.buf[this.pos++]=t[r];},writeRawMessage:function(t,e){this.pos++;var r=this.pos;t(e,this);var n=this.pos-r;n>=128&&Tu(r,n,this),this.pos=r-1,this.writeVarint(n),this.pos+=n;},writeMessage:function(t,e,r){this.writeTag(t,_u.Bytes),this.writeRawMessage(e,r);},writePackedVarint:function(t,e){e.length&&this.writeMessage(t,Mu,e);},writePackedSVarint:function(t,e){e.length&&this.writeMessage(t,Eu,e);},writePackedBoolean:function(t,e){e.length&&this.writeMessage(t,Pu,e);},writePackedFloat:function(t,e){e.length&&this.writeMessage(t,Bu,e);},writePackedDouble:function(t,e){e.length&&this.writeMessage(t,Cu,e);},writePackedFixed32:function(t,e){e.length&&this.writeMessage(t,Vu,e);},writePackedSFixed32:function(t,e){e.length&&this.writeMessage(t,Du,e);},writePackedFixed64:function(t,e){e.length&&this.writeMessage(t,Fu,e);},writePackedSFixed64:function(t,e){e.length&&this.writeMessage(t,Lu,e);},writeBytesField:function(t,e){this.writeTag(t,_u.Bytes),this.writeBytes(e);},writeFixed32Field:function(t,e){this.writeTag(t,_u.Fixed32),this.writeFixed32(e);},writeSFixed32Field:function(t,e){this.writeTag(t,_u.Fixed32),this.writeSFixed32(e);},writeFixed64Field:function(t,e){this.writeTag(t,_u.Fixed64),this.writeFixed64(e);},writeSFixed64Field:function(t,e){this.writeTag(t,_u.Fixed64),this.writeSFixed64(e);},writeVarintField:function(t,e){this.writeTag(t,_u.Varint),this.writeVarint(e);},writeSVarintField:function(t,e){this.writeTag(t,_u.Varint),this.writeSVarint(e);},writeStringField:function(t,e){this.writeTag(t,_u.Bytes),this.writeString(e);},writeFloatField:function(t,e){this.writeTag(t,_u.Fixed32),this.writeFloat(e);},writeDoubleField:function(t,e){this.writeTag(t,_u.Fixed64),this.writeDouble(e);},writeBooleanField:function(t,e){this.writeVarintField(t,Boolean(e));}};class Gu{constructor(t,{pixelRatio:e,version:r,stretchX:n,stretchY:i,content:s}){this.paddedRect=t,this.pixelRatio=e,this.stretchX=n,this.stretchY=i,this.content=s,this.version=r;}get tl(){return [this.paddedRect.x+1,this.paddedRect.y+1]}get br(){return [this.paddedRect.x+this.paddedRect.w-1,this.paddedRect.y+this.paddedRect.h-1]}get tlbr(){return this.tl.concat(this.br)}get displaySize(){return [(this.paddedRect.w-2)/this.pixelRatio,(this.paddedRect.h-2)/this.pixelRatio]}}class Zu{constructor(t,e){const r={},n={};this.haveRenderCallbacks=[];const i=[];this.addImages(t,r,i),this.addImages(e,n,i);const{w:s,h:a}=ju(i),o=new Vo({width:s||1,height:a||1});for(const e in t){const n=t[e],i=r[e].paddedRect;Vo.copy(n.data,o,{x:0,y:0},{x:i.x+1,y:i.y+1},n.data);}for(const t in e){const r=e[t],i=n[t].paddedRect,s=i.x+1,a=i.y+1,l=r.data.width,u=r.data.height;Vo.copy(r.data,o,{x:0,y:0},{x:s,y:a},r.data),Vo.copy(r.data,o,{x:0,y:u-1},{x:s,y:a-1},{width:l,height:1}),Vo.copy(r.data,o,{x:0,y:0},{x:s,y:a+u},{width:l,height:1}),Vo.copy(r.data,o,{x:l-1,y:0},{x:s-1,y:a},{width:1,height:u}),Vo.copy(r.data,o,{x:0,y:0},{x:s+l,y:a},{width:1,height:u});}this.image=o,this.iconPositions=r,this.patternPositions=n;}addImages(t,e,r){for(const n in t){const i=t[n],s={x:0,y:0,w:i.data.width+2,h:i.data.height+2};r.push(s),e[n]=new Gu(s,i),i.hasRenderCallback&&this.haveRenderCallbacks.push(n);}}patchUpdatedImages(t,e){t.dispatchRenderCallbacks(this.haveRenderCallbacks);for(const r in t.updatedImages)this.patchUpdatedImage(this.iconPositions[r],t.getImage(r),e),this.patchUpdatedImage(this.patternPositions[r],t.getImage(r),e);}patchUpdatedImage(t,e,r){if(!t||!e)return;if(t.version===e.version)return;t.version=e.version;const[n,i]=t.tl;r.update(e.data,void 0,{x:n,y:i});}}si("ImagePosition",Gu),si("ImageAtlas",Zu);const Xu={horizontal:1,vertical:2,horizontalOnly:3},Ku=-17;class Hu{constructor(){this.scale=1,this.fontStack="",this.imageName=null;}static forText(t,e){const r=new Hu;return r.scale=t||1,r.fontStack=e,r}static forImage(t){const e=new Hu;return e.imageName=t,e}}class Yu{constructor(){this.text="",this.sectionIndex=[],this.sections=[],this.imageSectionID=null;}static fromFeature(t,e){const r=new Yu;for(let n=0;n<t.sections.length;n++){const i=t.sections[n];i.image?r.addImageSection(i):r.addTextSection(i,e);}return r}length(){return this.text.length}getSection(t){return this.sections[this.sectionIndex[t]]}getSectionIndex(t){return this.sectionIndex[t]}getCharCode(t){return this.text.charCodeAt(t)}verticalizePunctuation(){this.text=function(t){let e="";for(let r=0;r<t.length;r++){const n=t.charCodeAt(r+1)||null,i=t.charCodeAt(r-1)||null;e+=n&&qi(n)&&!xu[t[r+1]]||i&&qi(i)&&!xu[t[r-1]]||!xu[t[r]]?t[r]:xu[t[r]];}return e}(this.text);}trim(){let t=0;for(let e=0;e<this.text.length&&Wu[this.text.charCodeAt(e)];e++)t++;let e=this.text.length;for(let r=this.text.length-1;r>=0&&r>=t&&Wu[this.text.charCodeAt(r)];r--)e--;this.text=this.text.substring(t,e),this.sectionIndex=this.sectionIndex.slice(t,e);}substring(t,e){const r=new Yu;return r.text=this.text.substring(t,e),r.sectionIndex=this.sectionIndex.slice(t,e),r.sections=this.sections,r}toString(){return this.text}getMaxScale(){return this.sectionIndex.reduce(((t,e)=>Math.max(t,this.sections[e].scale)),0)}addTextSection(t,e){this.text+=t.text,this.sections.push(Hu.forText(t.scale,t.fontStack||e));const r=this.sections.length-1;for(let e=0;e<t.text.length;++e)this.sectionIndex.push(r);}addImageSection(t){const e=t.image?t.image.name:"";if(0===e.length)return void M("Can't add FormattedSection with an empty image.");const r=this.getNextImageSectionCharCode();r?(this.text+=String.fromCharCode(r),this.sections.push(Hu.forImage(e)),this.sectionIndex.push(this.sections.length-1)):M("Reached maximum number of images 6401");}getNextImageSectionCharCode(){return this.imageSectionID?this.imageSectionID>=63743?null:++this.imageSectionID:(this.imageSectionID=57344,this.imageSectionID)}}function Ju(t,e,r,n,i,s,a,o,l,u,c,h,p,d,f,y){const m=Yu.fromFeature(t,i);let g;h===Xu.vertical&&m.verticalizePunctuation();const{processBidirectionalText:x,processStyledBidirectionalText:v}=ns;if(x&&1===m.sections.length){g=[];const t=x(m.toString(),sc(m,u,s,e,n,d,f));for(const e of t){const t=new Yu;t.text=e,t.sections=m.sections;for(let r=0;r<e.length;r++)t.sectionIndex.push(0);g.push(t);}}else if(v){g=[];const t=v(m.text,m.sectionIndex,sc(m,u,s,e,n,d,f));for(const e of t){const t=new Yu;t.text=e[0],t.sectionIndex=e[1],t.sections=m.sections,g.push(t);}}else g=function(t,e){const r=[],n=t.text;let i=0;for(const n of e)r.push(t.substring(i,n)),i=n;return i<n.length&&r.push(t.substring(i,n.length)),r}(m,sc(m,u,s,e,n,d,f));const b=[],w={positionedLines:b,text:m.toString(),top:c[1],bottom:c[1],left:c[0],right:c[0],writingMode:h,iconsInText:!1,verticalizable:!1};return function(t,e,r,n,i,s,a,o,l,u,c,h){let p=0,d=Ku,f=0,y=0;const m="right"===o?1:"left"===o?0:.5;let g=0;for(const a of i){a.trim();const i=a.getMaxScale(),o=(i-1)*hu,v={positionedGlyphs:[],lineOffset:0};t.positionedLines[g]=v;const b=v.positionedGlyphs;let w=0;if(!a.length()){d+=s,++g;continue}for(let s=0;s<a.length();s++){const f=a.getSection(s),y=a.getSectionIndex(s),m=a.getCharCode(s);let g=0,v=null,_=null,k=null,A=hu;const S=!(l===Xu.horizontal||!c&&!Oi(m)||c&&(Wu[m]||(x=m,hi(x)||pi(x)||di(x)||Ci(x)||Fi(x))));if(f.imageName){const e=n[f.imageName];if(!e)continue;k=f.imageName,t.iconsInText=t.iconsInText||!0,_=e.paddedRect;const r=e.displaySize;f.scale=f.scale*hu/h,v={width:r[0],height:r[1],left:1,top:-3,advance:S?r[1]:r[0],localGlyph:!1},g=o+(hu-r[1]*f.scale),A=v.advance;const s=S?r[0]*f.scale-hu*i:r[1]*f.scale-hu*i;s>0&&s>w&&(w=s);}else {const t=r[f.fontStack],n=t&&t[m];if(n&&n.rect)_=n.rect,v=n.metrics;else {const t=e[f.fontStack],r=t&&t[m];if(!r)continue;v=r.metrics;}g=(i-f.scale)*hu;}S?(t.verticalizable=!0,b.push({glyph:m,imageName:k,x:p,y:d+g,vertical:S,scale:f.scale,localGlyph:v.localGlyph,fontStack:f.fontStack,sectionIndex:y,metrics:v,rect:_}),p+=A*f.scale+u):(b.push({glyph:m,imageName:k,x:p,y:d+g,vertical:S,scale:f.scale,localGlyph:v.localGlyph,fontStack:f.fontStack,sectionIndex:y,metrics:v,rect:_}),p+=v.advance*f.scale+u);}0!==b.length&&(f=Math.max(p-u,f),oc(b,0,b.length-1,m,w)),p=0;const _=s*i+w;v.lineOffset=Math.max(w,o),d+=_,y=Math.max(_,y),++g;}var x;const v=d-Ku,{horizontalAlign:b,verticalAlign:w}=ac(a);(function(t,e,r,n,i,s,a,o,l){const u=(e-r)*i;let c=0;c=s!==a?-o*n-Ku:(-n*l+.5)*a;for(const e of t)for(const t of e.positionedGlyphs)t.x+=u,t.y+=c;})(t.positionedLines,m,b,w,f,y,s,v,i.length),t.top+=-w*v,t.bottom=t.top+v,t.left+=-b*f,t.right=t.left+f;}(w,e,r,n,g,a,o,l,h,u,p,y),!function(t){for(const e of t)if(0!==e.positionedGlyphs.length)return !1;return !0}(b)&&w}const Wu={9:!0,10:!0,11:!0,12:!0,13:!0,32:!0},Qu={10:!0,32:!0,38:!0,40:!0,41:!0,43:!0,45:!0,47:!0,173:!0,183:!0,8203:!0,8208:!0,8211:!0,8231:!0};function tc(t,e,r,n,i,s){if(e.imageName){const t=n[e.imageName];return t?t.displaySize[0]*e.scale*hu/s+i:0}{const n=r[e.fontStack],s=n&&n[t];return s?s.metrics.advance*e.scale+i:0}}function ec(t,e,r,n){const i=Math.pow(t-e,2);return n?t<e?i/2:2*i:i+Math.abs(r)*r}function rc(t,e,r){let n=0;return 10===t&&(n-=1e4),r&&(n+=150),40!==t&&65288!==t||(n+=50),41!==e&&65289!==e||(n+=50),n}function nc(t,e,r,n,i,s){let a=null,o=ec(e,r,i,s);for(const t of n){const n=ec(e-t.x,r,i,s)+t.badness;n<=o&&(a=t,o=n);}return {index:t,x:e,priorBreak:a,badness:o}}function ic(t){return t?ic(t.priorBreak).concat(t.index):[]}function sc(t,e,r,n,i,s,a){if("point"!==s)return [];if(!t)return [];const o=[],l=function(t,e,r,n,i,s){let a=0;for(let r=0;r<t.length();r++){const o=t.getSection(r);a+=tc(t.getCharCode(r),o,n,i,e,s);}return a/Math.max(1,Math.ceil(a/r))}(t,e,r,n,i,a),u=t.text.indexOf("​")>=0;let c=0;for(let r=0;r<t.length();r++){const s=t.getSection(r),p=t.getCharCode(r);if(Wu[p]||(c+=tc(p,s,n,i,e,a)),r<t.length()-1){const e=!((h=p)<11904||!(wi(h)||bi(h)||Vi(h)||Bi(h)||Si(h)||fi(h)||_i(h)||gi(h)||Ii(h)||zi(h)||Ai(h)||Li(h)||xi(h)||mi(h)||yi(h)||ki(h)||vi(h)||Pi(h)||Mi(h)||Ti(h)));(Qu[p]||e||s.imageName)&&o.push(nc(r+1,c,l,o,rc(p,t.getCharCode(r+1),e&&u),!1));}}var h;return ic(nc(t.length(),c,l,o,0,!0))}function ac(t){let e=.5,r=.5;switch(t){case"right":case"top-right":case"bottom-right":e=1;break;case"left":case"top-left":case"bottom-left":e=0;}switch(t){case"bottom":case"bottom-right":case"bottom-left":r=1;break;case"top":case"top-right":case"top-left":r=0;}return {horizontalAlign:e,verticalAlign:r}}function oc(t,e,r,n,i){if(!n&&!i)return;const s=t[r],a=(t[r].x+s.metrics.advance*s.scale)*n;for(let n=e;n<=r;n++)t[n].x-=a,t[n].y+=i;}function lc(t,e,r){const{horizontalAlign:n,verticalAlign:i}=ac(r),s=e[0]-t.displaySize[0]*n,a=e[1]-t.displaySize[1]*i;return {image:t,top:a,bottom:a+t.displaySize[1],left:s,right:s+t.displaySize[0]}}function uc(t,e,r,n,i,s){const a=t.image;let o;if(a.content){const t=a.content,e=a.pixelRatio||1;o=[t[0]/e,t[1]/e,a.displaySize[0]-t[2]/e,a.displaySize[1]-t[3]/e];}const l=e.left*s,u=e.right*s;let c,h,p,d;"width"===r||"both"===r?(d=i[0]+l-n[3],h=i[0]+u+n[1]):(d=i[0]+(l+u-a.displaySize[0])/2,h=d+a.displaySize[0]);const f=e.top*s,y=e.bottom*s;return "height"===r||"both"===r?(c=i[1]+f-n[0],p=i[1]+y+n[2]):(c=i[1]+(f+y-a.displaySize[1])/2,p=c+a.displaySize[1]),{image:a,top:c,right:h,bottom:p,left:d,collisionPadding:o}}class cc extends i{constructor(t,e,r,n){super(t,e),this.angle=r,void 0!==n&&(this.segment=n);}clone(){return new cc(this.x,this.y,this.angle,this.segment)}}function hc(t,e,r,n,i){if(void 0===e.segment)return !0;let s=e,a=e.segment+1,o=0;for(;o>-r/2;){if(a--,a<0)return !1;o-=t[a].dist(s),s=t[a];}o+=t[a].dist(t[a+1]),a++;const l=[];let u=0;for(;o<r/2;){const e=t[a],r=t[a+1];if(!r)return !1;let s=t[a-1].angleTo(e)-e.angleTo(r);for(s=Math.abs((s+3*Math.PI)%(2*Math.PI)-Math.PI),l.push({distance:o,angleDelta:s}),u+=s;o-l[0].distance>n;)u-=l.shift().angleDelta;if(u>i)return !1;a++,o+=e.dist(r);}return !0}function pc(t){let e=0;for(let r=0;r<t.length-1;r++)e+=t[r].dist(t[r+1]);return e}function dc(t,e,r){return t?.6*e*r:0}function fc(t,e){return Math.max(t?t.right-t.left:0,e?e.right-e.left:0)}function yc(t,e,r,n,i,s){const a=dc(r,i,s),o=fc(r,n)*s;let l=0;const u=pc(t)/2;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1],s=n.dist(i);if(l+s>u){const c=(u-l)/s,h=rr(n.x,i.x,c),p=rr(n.y,i.y,c),d=new cc(h,p,i.angleTo(n),r);return d._round(),!a||hc(t,d,o,a,e)?d:void 0}l+=s;}}function mc(t,e,r,n,i,s,a,o,l){const u=dc(n,s,a),c=fc(n,i),h=c*a,p=0===t[0].x||t[0].x===l||0===t[0].y||t[0].y===l;return e-h<e/4&&(e=h+e/4),gc(t,p?e/2*o%e:(c/2+2*s)*a*o%e,e,u,r,h,p,!1,l)}function gc(t,e,r,n,i,s,a,o,l){const u=s/2,c=pc(t);let h=0,p=e-r,d=[];for(let e=0;e<t.length-1;e++){const a=t[e],o=t[e+1],f=a.dist(o),y=o.angleTo(a);for(;p+r<h+f;){p+=r;const m=(p-h)/f,g=rr(a.x,o.x,m),x=rr(a.y,o.y,m);if(g>=0&&g<l&&x>=0&&x<l&&p-u>=0&&p+u<=c){const r=new cc(g,x,y,e);r._round(),n&&!hc(t,r,s,n,i)||d.push(r);}}h+=f;}return o||d.length||a||(d=gc(t,h/2,r,n,i,s,a,!0,l)),d}function xc(t,e,r,n,s){const a=[];for(let o=0;o<t.length;o++){const l=t[o];let u;for(let t=0;t<l.length-1;t++){let o=l[t],c=l[t+1];o.x<e&&c.x<e||(o.x<e?o=new i(e,o.y+(e-o.x)/(c.x-o.x)*(c.y-o.y))._round():c.x<e&&(c=new i(e,o.y+(e-o.x)/(c.x-o.x)*(c.y-o.y))._round()),o.y<r&&c.y<r||(o.y<r?o=new i(o.x+(r-o.y)/(c.y-o.y)*(c.x-o.x),r)._round():c.y<r&&(c=new i(o.x+(r-o.y)/(c.y-o.y)*(c.x-o.x),r)._round()),o.x>=n&&c.x>=n||(o.x>=n?o=new i(n,o.y+(n-o.x)/(c.x-o.x)*(c.y-o.y))._round():c.x>=n&&(c=new i(n,o.y+(n-o.x)/(c.x-o.x)*(c.y-o.y))._round()),o.y>=s&&c.y>=s||(o.y>=s?o=new i(o.x+(s-o.y)/(c.y-o.y)*(c.x-o.x),s)._round():c.y>=s&&(c=new i(o.x+(s-o.y)/(c.y-o.y)*(c.x-o.x),s)._round()),u&&o.equals(u[u.length-1])||(u=[o],a.push(u)),u.push(c)))));}}return a}si("Anchor",cc);var vc=_c,bc=_c,wc=1e20;function _c(t,e,r,n,i,s){this.fontSize=t||24,this.buffer=void 0===e?3:e,this.cutoff=n||.25,this.fontFamily=i||"sans-serif",this.fontWeight=s||"normal",this.radius=r||8;var a=this.size=this.fontSize+2*this.buffer,o=a+2*this.buffer;this.canvas=document.createElement("canvas"),this.canvas.width=this.canvas.height=a,this.ctx=this.canvas.getContext("2d"),this.ctx.font=this.fontWeight+" "+this.fontSize+"px "+this.fontFamily,this.ctx.textAlign="left",this.ctx.fillStyle="black",this.gridOuter=new Float64Array(o*o),this.gridInner=new Float64Array(o*o),this.f=new Float64Array(o),this.z=new Float64Array(o+1),this.v=new Uint16Array(o),this.useMetrics=void 0!==this.ctx.measureText("A").actualBoundingBoxLeft,this.middle=Math.round(a/2*(navigator.userAgent.indexOf("Gecko/")>=0?1.2:1));}function kc(t,e,r,n,i,s){for(var a=0;a<e;a++)Ac(t,a,e,r,n,i,s);for(var o=0;o<r;o++)Ac(t,o*e,1,e,n,i,s);}function Ac(t,e,r,n,i,s,a){var o,l,u,c;for(s[0]=0,a[0]=-wc,a[1]=wc,o=0;o<n;o++)i[o]=t[e+o*r];for(o=1,l=0,u=0;o<n;o++){do{u=(i[o]-i[c=s[l]]+o*o-c*c)/(o-c)/2;}while(u<=a[l]&&--l>-1);s[++l]=o,a[l]=u,a[l+1]=wc;}for(o=0,l=0;o<n;o++){for(;a[l+1]<o;)l++;t[e+o*r]=i[c=s[l]]+(o-c)*(o-c);}}_c.prototype._draw=function(t,e){var r,n,i,s,a,o,l,u,c,h=this.ctx.measureText(t),p=h.width,d=2*this.buffer;e&&this.useMetrics?(a=Math.floor(h.actualBoundingBoxAscent),u=this.buffer+Math.ceil(h.actualBoundingBoxAscent),o=this.buffer,l=this.buffer,r=(n=Math.min(this.size,Math.ceil(h.actualBoundingBoxRight-h.actualBoundingBoxLeft)))+d,i=(s=Math.min(this.size-o,Math.ceil(h.actualBoundingBoxAscent+h.actualBoundingBoxDescent)))+d,this.ctx.textBaseline="alphabetic"):(r=n=this.size,i=s=this.size,a=19*this.fontSize/24,o=l=0,u=this.middle,this.ctx.textBaseline="middle"),n&&s&&(this.ctx.clearRect(l,o,n,s),this.ctx.fillText(t,this.buffer,u),c=this.ctx.getImageData(l,o,n,s));var f=new Uint8ClampedArray(r*i);return function(t,e,r,n,i,s,a){s.fill(wc,0,e*r),a.fill(0,0,e*r);for(var o=(e-n)/2,l=0;l<i;l++)for(var u=0;u<n;u++){var c=(l+o)*e+u+o,h=t.data[4*(l*n+u)+3]/255;if(1===h)s[c]=0,a[c]=wc;else if(0===h)s[c]=wc,a[c]=0;else {var p=Math.max(0,.5-h),d=Math.max(0,h-.5);s[c]=p*p,a[c]=d*d;}}}(c,r,i,n,s,this.gridOuter,this.gridInner),kc(this.gridOuter,r,i,this.f,this.v,this.z),kc(this.gridInner,r,i,this.f,this.v,this.z),function(t,e,r,n,i,s,a){for(var o=0;o<e*r;o++){var l=Math.sqrt(n[o])-Math.sqrt(i[o]);t[o]=Math.round(255-255*(l/s+a));}}(f,r,i,this.gridOuter,this.gridInner,this.radius,this.cutoff),{data:f,metrics:{width:n,height:s,sdfWidth:r,sdfHeight:i,top:a,left:0,advance:p}}},_c.prototype.draw=function(t){return this._draw(t,!1).data},_c.prototype.drawWithMetrics=function(t){return this._draw(t,!0)},vc.default=bc;const Sc={none:0,ideographs:1,all:2};class Ic{constructor(t,e,r){this.requestManager=t,this.localGlyphMode=e,this.localFontFamily=r,this.entries={},this.localGlyphs={200:{},400:{},500:{},900:{}};}setURL(t){this.url=t;}getGlyphs(t,e){const r=[];for(const e in t)for(const n of t[e])r.push({stack:e,id:n});m(r,(({stack:t,id:e},r)=>{let n=this.entries[t];n||(n=this.entries[t]={glyphs:{},requests:{},ranges:{}});let i=n.glyphs[e];if(void 0!==i)return void r(null,{stack:t,id:e,glyph:i});if(i=this._tinySDF(n,t,e),i)return n.glyphs[e]=i,void r(null,{stack:t,id:e,glyph:i});const s=Math.floor(e/256);if(256*s>65535)return void r(new Error("glyphs > 65535 not supported"));if(n.ranges[s])return void r(null,{stack:t,id:e,glyph:i});let a=n.requests[s];a||(a=n.requests[s]=[],Ic.loadGlyphRange(t,s,this.url,this.requestManager,((t,e)=>{if(e){for(const t in e)this._doesCharSupportLocalGlyph(+t)||(n.glyphs[+t]=e[+t]);n.ranges[s]=!0;}for(const r of a)r(t,e);delete n.requests[s];}))),a.push(((n,i)=>{n?r(n):i&&r(null,{stack:t,id:e,glyph:i[e]||null});}));}),((t,r)=>{if(t)e(t);else if(r){const t={};for(const{stack:e,id:n,glyph:i}of r)(t[e]||(t[e]={}))[n]=i&&{id:i.id,bitmap:i.bitmap.clone(),metrics:i.metrics};e(null,t);}}));}_doesCharSupportLocalGlyph(t){return this.localGlyphMode!==Sc.none&&(this.localGlyphMode===Sc.all?!!this.localFontFamily:!!this.localFontFamily&&(zi(t)||Ei(t)||xi(t)||vi(t)))}_tinySDF(t,e,r){const n=this.localFontFamily;if(!n)return;if(!this._doesCharSupportLocalGlyph(r))return;let i=t.tinySDF;if(!i){let r="400";/bold/i.test(e)?r="900":/medium/i.test(e)?r="500":/light/i.test(e)&&(r="200"),i=t.tinySDF=new Ic.TinySDF(48,6,16,.25,n,r);}if(this.localGlyphs[i.fontWeight][r])return this.localGlyphs[i.fontWeight][r];const{data:s,metrics:a}=i.drawWithMetrics(String.fromCharCode(r)),{sdfWidth:o,sdfHeight:l,width:u,height:c,left:h,top:p,advance:d}=a;return this.localGlyphs[i.fontWeight][r]={id:r,bitmap:new Po({width:o,height:l},s),metrics:{width:u/2,height:c/2,left:h/2,top:p/2-27,advance:d/2,localGlyph:!0}}}}function zc(t,e,r,n){const s=[],a=t.image,o=a.pixelRatio,l=a.paddedRect.w-2,u=a.paddedRect.h-2,c=t.right-t.left,h=t.bottom-t.top,p=a.stretchX||[[0,l]],d=a.stretchY||[[0,u]],f=(t,e)=>t+e[1]-e[0],y=p.reduce(f,0),m=d.reduce(f,0),g=l-y,x=u-m;let v=0,b=y,w=0,_=m,k=0,A=g,S=0,I=x;if(a.content&&n){const t=a.content;v=Tc(p,0,t[0]),w=Tc(d,0,t[1]),b=Tc(p,t[0],t[2]),_=Tc(d,t[1],t[3]),k=t[0]-v,S=t[1]-w,A=t[2]-t[0]-b,I=t[3]-t[1]-_;}const z=(n,s,l,u)=>{const p=Ec(n.stretch-v,b,c,t.left),d=Bc(n.fixed-k,A,n.stretch,y),f=Ec(s.stretch-w,_,h,t.top),g=Bc(s.fixed-S,I,s.stretch,m),x=Ec(l.stretch-v,b,c,t.left),z=Bc(l.fixed-k,A,l.stretch,y),T=Ec(u.stretch-w,_,h,t.top),M=Bc(u.fixed-S,I,u.stretch,m),E=new i(p,f),B=new i(x,f),C=new i(x,T),P=new i(p,T),V=new i(d/o,g/o),D=new i(z/o,M/o),F=e*Math.PI/180;if(F){const t=Math.sin(F),e=Math.cos(F),r=[e,-t,t,e];E._matMult(r),B._matMult(r),P._matMult(r),C._matMult(r);}const L=n.stretch+n.fixed,R=s.stretch+s.fixed;return {tl:E,tr:B,bl:P,br:C,tex:{x:a.paddedRect.x+1+L,y:a.paddedRect.y+1+R,w:l.stretch+l.fixed-L,h:u.stretch+u.fixed-R},writingMode:void 0,glyphOffset:[0,0],sectionIndex:0,pixelOffsetTL:V,pixelOffsetBR:D,minFontScaleX:A/o/c,minFontScaleY:I/o/h,isSDF:r}};if(n&&(a.stretchX||a.stretchY)){const t=Mc(p,g,y),e=Mc(d,x,m);for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)s.push(z(n,e[t],i,e[t+1]));}}else s.push(z({fixed:0,stretch:-1},{fixed:0,stretch:-1},{fixed:0,stretch:l+1},{fixed:0,stretch:u+1}));return s}function Tc(t,e,r){let n=0;for(const i of t)n+=Math.max(e,Math.min(r,i[1]))-Math.max(e,Math.min(r,i[0]));return n}function Mc(t,e,r){const n=[{fixed:-1,stretch:0}];for(const[e,r]of t){const t=n[n.length-1];n.push({fixed:e-t.stretch,stretch:t.stretch}),n.push({fixed:e-t.stretch,stretch:t.stretch+(r-e)});}return n.push({fixed:e+1,stretch:r}),n}function Ec(t,e,r,n){return t/e*r+n}function Bc(t,e,r,n){return t-e*r/n}Ic.loadGlyphRange=function(t,e,r,n,i){const s=256*e,a=s+255,o=n.transformRequest(n.normalizeGlyphsURL(r).replace("{fontstack}",t).replace("{range}",`${s}-${a}`),wt.Glyphs);St(o,((t,e)=>{if(t)i(t);else if(e){const t={};for(const r of function(t){return new wu(t).readFields(Ou,[])}(e))t[r.id]=r;i(null,t);}}));},Ic.TinySDF=vc;class Cc{constructor(t=[],e=Pc){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t);}push(t){this.data.push(t),this.length++,this._up(this.length-1);}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return this.length--,this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:r}=this,n=e[t];for(;t>0;){const i=t-1>>1,s=e[i];if(r(n,s)>=0)break;e[t]=s,t=i;}e[t]=n;}_down(t){const{data:e,compare:r}=this,n=this.length>>1,i=e[t];for(;t<n;){let n=1+(t<<1),s=e[n];const a=n+1;if(a<this.length&&r(e[a],s)<0&&(n=a,s=e[a]),r(s,i)>=0)break;e[t]=s,t=n;}e[t]=i;}}function Pc(t,e){return t<e?-1:t>e?1:0}function Vc(t,e=1,r=!1){let n=1/0,s=1/0,a=-1/0,o=-1/0;const l=t[0];for(let t=0;t<l.length;t++){const e=l[t];(!t||e.x<n)&&(n=e.x),(!t||e.y<s)&&(s=e.y),(!t||e.x>a)&&(a=e.x),(!t||e.y>o)&&(o=e.y);}const u=Math.min(a-n,o-s);let c=u/2;const h=new Cc([],Dc);if(0===u)return new i(n,s);for(let e=n;e<a;e+=u)for(let r=s;r<o;r+=u)h.push(new Fc(e+c,r+c,c,t));let p=function(t){let e=0,r=0,n=0;const i=t[0];for(let t=0,s=i.length,a=s-1;t<s;a=t++){const s=i[t],o=i[a],l=s.x*o.y-o.x*s.y;r+=(s.x+o.x)*l,n+=(s.y+o.y)*l,e+=3*l;}return new Fc(r/e,n/e,0,t)}(t),d=h.length;for(;h.length;){const n=h.pop();(n.d>p.d||!p.d)&&(p=n,r&&console.log("found best %d after %d probes",Math.round(1e4*n.d)/1e4,d)),n.max-p.d<=e||(c=n.h/2,h.push(new Fc(n.p.x-c,n.p.y-c,c,t)),h.push(new Fc(n.p.x+c,n.p.y-c,c,t)),h.push(new Fc(n.p.x-c,n.p.y+c,c,t)),h.push(new Fc(n.p.x+c,n.p.y+c,c,t)),d+=4);}return r&&(console.log(`num probes: ${d}`),console.log(`best distance: ${p.d}`)),p.p}function Dc(t,e){return e.max-t.max}function Fc(t,e,r,n){this.p=new i(t,e),this.h=r,this.d=function(t,e){let r=!1,n=1/0;for(let i=0;i<e.length;i++){const s=e[i];for(let e=0,i=s.length,a=i-1;e<i;a=e++){const i=s[e],o=s[a];i.y>t.y!=o.y>t.y&&t.x<(o.x-i.x)*(t.y-i.y)/(o.y-i.y)+i.x&&(r=!r),n=Math.min(n,Ka(t,i,o));}}return (r?1:-1)*Math.sqrt(n)}(this.p,n),this.max=this.d+this.h*Math.SQRT2;}const Lc=Number.POSITIVE_INFINITY;function Rc(t,e){return e[1]!==Lc?function(t,e,r){let n=0,i=0;switch(e=Math.abs(e),r=Math.abs(r),t){case"top-right":case"top-left":case"top":i=r-7;break;case"bottom-right":case"bottom-left":case"bottom":i=7-r;}switch(t){case"top-right":case"bottom-right":case"right":n=-e;break;case"top-left":case"bottom-left":case"left":n=e;}return [n,i]}(t,e[0],e[1]):function(t,e){let r=0,n=0;e<0&&(e=0);const i=e/Math.sqrt(2);switch(t){case"top-right":case"top-left":n=i-7;break;case"bottom-right":case"bottom-left":n=7-i;break;case"bottom":n=7-e;break;case"top":n=e-7;}switch(t){case"top-right":case"bottom-right":r=-i;break;case"top-left":case"bottom-left":r=i;break;case"left":r=e;break;case"right":r=-e;}return [r,n]}(t,e[0])}function Uc(t,e,r,n,i,s,a,o){t.createArrays(),t.tilePixelRatio=Va/(512*t.overscaling),t.compareText={},t.iconsNeedLinear=!1;const l=t.layers[0].layout,u=t.layers[0]._unevaluatedLayout._values,c={};if("composite"===t.textSizeData.kind){const{minZoom:e,maxZoom:r}=t.textSizeData;c.compositeTextSizes=[u["text-size"].possiblyEvaluate(new is(e),a),u["text-size"].possiblyEvaluate(new is(r),a)];}if("composite"===t.iconSizeData.kind){const{minZoom:e,maxZoom:r}=t.iconSizeData;c.compositeIconSizes=[u["icon-size"].possiblyEvaluate(new is(e),a),u["icon-size"].possiblyEvaluate(new is(r),a)];}c.layoutTextSize=u["text-size"].possiblyEvaluate(new is(o+1),a),c.layoutIconSize=u["icon-size"].possiblyEvaluate(new is(o+1),a),c.textMaxSize=u["text-size"].possiblyEvaluate(new is(18),a);const h=l.get("text-line-height")*hu,p="map"===l.get("text-rotation-alignment")&&"point"!==l.get("symbol-placement"),d=l.get("text-keep-upright"),f=l.get("text-size");for(const s of t.features){const o=l.get("text-font").evaluate(s,{},a).join(","),u=f.evaluate(s,{},a),y=c.layoutTextSize.evaluate(s,{},a),m=(c.layoutIconSize.evaluate(s,{},a),{horizontal:{},vertical:void 0}),g=s.text;let x,v=[0,0];if(g){const n=g.toString(),c=l.get("text-letter-spacing").evaluate(s,{},a)*hu,f=Ui(n)?c:0,x=l.get("text-anchor").evaluate(s,{},a),b=l.get("text-variable-anchor");if(!b){const t=l.get("text-radial-offset").evaluate(s,{},a);v=t?Rc(x,[t*hu,Lc]):l.get("text-offset").evaluate(s,{},a).map((t=>t*hu));}let w=p?"center":l.get("text-justify").evaluate(s,{},a);const _=l.get("symbol-placement"),k="point"===_?l.get("text-max-width").evaluate(s,{},a)*hu:0,A=()=>{t.allowVerticalPlacement&&Ri(n)&&(m.vertical=Ju(g,e,r,i,o,k,h,x,"left",f,v,Xu.vertical,!0,_,y,u));};if(!p&&b){const t="auto"===w?b.map((t=>$c(t))):[w];let n=!1;for(let s=0;s<t.length;s++){const a=t[s];if(!m.horizontal[a])if(n)m.horizontal[a]=m.horizontal[0];else {const t=Ju(g,e,r,i,o,k,h,"center",a,f,v,Xu.horizontal,!1,_,y,u);t&&(m.horizontal[a]=t,n=1===t.positionedLines.length);}}A();}else {"auto"===w&&(w=$c(x));const t=Ju(g,e,r,i,o,k,h,x,w,f,v,Xu.horizontal,!1,_,y,u);t&&(m.horizontal[w]=t),A(),Ri(n)&&p&&d&&(m.vertical=Ju(g,e,r,i,o,k,h,x,w,f,v,Xu.vertical,!1,_,y,u));}}let b=!1;if(s.icon&&s.icon.name){const e=n[s.icon.name];e&&(x=lc(i[s.icon.name],l.get("icon-offset").evaluate(s,{},a),l.get("icon-anchor").evaluate(s,{},a)),b=e.sdf,void 0===t.sdfIcons?t.sdfIcons=e.sdf:t.sdfIcons!==e.sdf&&M("Style sheet warning: Cannot mix SDF and non-SDF icons in one buffer"),(e.pixelRatio!==t.pixelRatio||0!==l.get("icon-rotate").constantOr(1))&&(t.iconsNeedLinear=!0));}const w=jc(m.horizontal)||m.vertical;t.iconsInText=!!w&&w.iconsInText,(w||x)&&Oc(t,s,m,x,n,c,y,0,v,b,a);}s&&t.generateCollisionDebugBuffers(o,t.collisionBoxArray);}function $c(t){switch(t){case"right":case"top-right":case"bottom-right":return "right";case"left":case"top-left":case"bottom-left":return "left"}return "center"}function Oc(t,e,r,n,i,s,a,o,l,u,h){let p=s.textMaxSize.evaluate(e,{},h);void 0===p&&(p=a);const d=t.layers[0].layout,f=d.get("icon-offset").evaluate(e,{},h),y=jc(r.horizontal),m=a/24,g=t.tilePixelRatio*m,x=t.tilePixelRatio*p/24,v=t.tilePixelRatio*d.get("symbol-spacing"),b=d.get("text-padding")*t.tilePixelRatio,w=d.get("icon-padding")*t.tilePixelRatio,_=c(d.get("text-max-angle")),k="map"===d.get("text-rotation-alignment")&&"point"!==d.get("symbol-placement"),A="map"===d.get("icon-rotation-alignment")&&"point"!==d.get("symbol-placement"),S=d.get("symbol-placement"),I=v/2,z=d.get("icon-text-fit");let T;n&&"none"!==z&&(t.allowVerticalPlacement&&r.vertical&&(T=uc(n,r.vertical,z,d.get("icon-text-fit-padding"),f,m)),y&&(n=uc(n,y,z,d.get("icon-text-fit-padding"),f,m)));const E=(o,c)=>{c.x<0||c.x>=Va||c.y<0||c.y>=Va||function(t,e,r,n,i,s,a,o,l,u,c,h,p,d,f,y,m,g,x,v,b,w,_,k,A){const S=t.addToLineVertexArray(e,r);let I,z,T,E,B,C,P,V=0,D=0,F=0,L=0,R=-1,U=-1;const $={};let O=oa(""),q=0,N=0;if(void 0===o._unevaluatedLayout.getValue("text-radial-offset")?[q,N]=o.layout.get("text-offset").evaluate(b,{},k).map((t=>t*hu)):(q=o.layout.get("text-radial-offset").evaluate(b,{},k)*hu,N=Lc),t.allowVerticalPlacement&&n.vertical){const t=n.vertical;if(f)C=Zc(t),a&&(P=Zc(a));else {const r=o.layout.get("text-rotate").evaluate(b,{},k)+90;T=Gc(l,e,u,c,h,t,0,d,r),a&&(E=Gc(l,e,u,c,h,a,0,g,r));}}if(i){const r=o.layout.get("icon-rotate").evaluate(b,{},k),n="none"!==o.layout.get("icon-text-fit"),s=zc(i,r,_,n),p=a?zc(a,r,_,n):void 0;z=Gc(l,e,u,c,h,i,0,g,r),V=4*s.length;const d=t.iconSizeData;let f=null;"source"===d.kind?(f=[pu*o.layout.get("icon-size").evaluate(b,{},k)],f[0]>qc&&M(`${t.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)):"composite"===d.kind&&(f=[pu*w.compositeIconSizes[0].evaluate(b,{},k),pu*w.compositeIconSizes[1].evaluate(b,{},k)],(f[0]>qc||f[1]>qc)&&M(`${t.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)),t.addSymbols(t.icon,s,f,v,x,b,!1,e,S.lineStartIndex,S.lineLength,-1,k),R=t.icon.placedSymbolArray.length-1,p&&(D=4*p.length,t.addSymbols(t.icon,p,f,v,x,b,Xu.vertical,e,S.lineStartIndex,S.lineLength,-1,k),U=t.icon.placedSymbolArray.length-1);}for(const r in n.horizontal){const i=n.horizontal[r];I||(O=oa(i.text),f?B=Zc(i):I=Gc(l,e,u,c,h,i,0,d,o.layout.get("text-rotate").evaluate(b,{},k)));const a=1===i.positionedLines.length;if(F+=Nc(t,e,i,s,o,f,b,y,S,n.vertical?Xu.horizontal:Xu.horizontalOnly,a?Object.keys(n.horizontal):[r],$,R,w,k),a)break}n.vertical&&(L+=Nc(t,e,n.vertical,s,o,f,b,y,S,Xu.vertical,["vertical"],$,U,w,k));let j=-1;const G=(t,e)=>t?Math.max(t,e):e;j=G(B,j),j=G(C,j),j=G(P,j);const Z=j>-1?1:0;Z&&(j*=A/hu),t.glyphOffsetArray.length>=eh.MAX_GLYPHS&&M("Too many glyphs being rendered in a tile. See https://github.com/mapbox/mapbox-gl-js/issues/2907"),void 0!==b.sortKey&&t.addToSortKeyRanges(t.symbolInstances.length,b.sortKey),t.symbolInstances.emplaceBack(e.x,e.y,$.right>=0?$.right:-1,$.center>=0?$.center:-1,$.left>=0?$.left:-1,$.vertical||-1,R,U,O,void 0!==I?I:t.collisionBoxArray.length,void 0!==I?I+1:t.collisionBoxArray.length,void 0!==T?T:t.collisionBoxArray.length,void 0!==T?T+1:t.collisionBoxArray.length,void 0!==z?z:t.collisionBoxArray.length,void 0!==z?z+1:t.collisionBoxArray.length,E||t.collisionBoxArray.length,E?E+1:t.collisionBoxArray.length,u,F,L,V,D,Z,0,p,q,N,j);}(t,c,o,r,n,i,T,t.layers[0],t.collisionBoxArray,e.index,e.sourceLayerIndex,t.index,g,b,k,l,0,w,A,f,e,s,u,h,a);};if("line"===S)for(const i of xc(e.geometry,0,0,Va,Va)){const e=mc(i,v,_,r.vertical||y,n,24,x,t.overscaling,Va);for(const r of e){const e=y;e&&Xc(t,e.text,I,r)||E(i,r);}}else if("line-center"===S){for(const t of e.geometry)if(t.length>1){const e=yc(t,_,r.vertical||y,n,24,x);e&&E(t,e);}}else if("Polygon"===e.type)for(const t of xl(e.geometry,0)){const e=Vc(t,16);E(t[0],new cc(e.x,e.y,0));}else if("LineString"===e.type)for(const t of e.geometry)E(t,new cc(t[0].x,t[0].y,0));else if("Point"===e.type)for(const t of e.geometry)for(const e of t)E([e],new cc(e.x,e.y,0));}const qc=32640;function Nc(t,e,r,n,s,a,o,l,u,c,h,p,d,f,y){const m=function(t,e,r,n,s,a,o,l){const u=n.layout.get("text-rotate").evaluate(a,{})*Math.PI/180,c=[];for(const t of e.positionedLines)for(const n of t.positionedGlyphs){if(!n.rect)continue;const a=n.rect||{};let h=4,p=!0,d=1,f=0;const y=(s||l)&&n.vertical,m=n.metrics.advance*n.scale/2;if(l&&e.verticalizable){const e=(n.scale-1)*hu,r=(hu-n.metrics.width*n.scale)/2;f=t.lineOffset/2-(n.imageName?-r:e);}if(n.imageName){const t=o[n.imageName];p=t.sdf,d=t.pixelRatio,h=1/d;}const g=s?[n.x+m,n.y]:[0,0];let x=s?[0,0]:[n.x+m+r[0],n.y+r[1]-f],v=[0,0];y&&(v=x,x=[0,0]);const b=(n.metrics.left-h)*n.scale-m+x[0],w=(-n.metrics.top-h)*n.scale+x[1],_=b+a.w*n.scale/(d*(n.localGlyph?2:1)),k=w+a.h*n.scale/(d*(n.localGlyph?2:1)),A=new i(b,w),S=new i(_,w),I=new i(b,k),z=new i(_,k);if(y){const t=new i(-m,m-Ku),e=-Math.PI/2,r=12-m,s=new i(22-r,-(n.imageName?r:0)),a=new i(...v);A._rotateAround(e,t)._add(s)._add(a),S._rotateAround(e,t)._add(s)._add(a),I._rotateAround(e,t)._add(s)._add(a),z._rotateAround(e,t)._add(s)._add(a);}if(u){const t=Math.sin(u),e=Math.cos(u),r=[e,-t,t,e];A._matMult(r),S._matMult(r),I._matMult(r),z._matMult(r);}const T=new i(0,0),M=new i(0,0);c.push({tl:A,tr:S,bl:I,br:z,tex:a,writingMode:e.writingMode,glyphOffset:g,sectionIndex:n.sectionIndex,isSDF:p,pixelOffsetTL:T,pixelOffsetBR:M,minFontScaleX:0,minFontScaleY:0});}return c}(0,r,l,s,a,o,n,t.allowVerticalPlacement),g=t.textSizeData;let x=null;"source"===g.kind?(x=[pu*s.layout.get("text-size").evaluate(o,{},y)],x[0]>qc&&M(`${t.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)):"composite"===g.kind&&(x=[pu*f.compositeTextSizes[0].evaluate(o,{},y),pu*f.compositeTextSizes[1].evaluate(o,{},y)],(x[0]>qc||x[1]>qc)&&M(`${t.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)),t.addSymbols(t.text,m,x,l,a,o,c,e,u.lineStartIndex,u.lineLength,d,y);for(const e of h)p[e]=t.text.placedSymbolArray.length-1;return 4*m.length}function jc(t){for(const e in t)return t[e];return null}function Gc(t,e,r,n,s,a,o,l,u){let h=a.top,p=a.bottom,d=a.left,f=a.right;const y=a.collisionPadding;if(y&&(d-=y[0],h-=y[1],f+=y[2],p+=y[3]),u){const t=new i(d,h),e=new i(f,h),r=new i(d,p),n=new i(f,p),s=c(u);t._rotate(s),e._rotate(s),r._rotate(s),n._rotate(s),d=Math.min(t.x,e.x,r.x,n.x),f=Math.max(t.x,e.x,r.x,n.x),h=Math.min(t.y,e.y,r.y,n.y),p=Math.max(t.y,e.y,r.y,n.y);}return t.emplaceBack(e.x,e.y,d,h,f,p,l,r,n,s),t.length-1}function Zc(t){t.collisionPadding&&(t.top-=t.collisionPadding[1],t.bottom+=t.collisionPadding[3]);const e=t.bottom-t.top;return e>0?Math.max(10,e):null}function Xc(t,e,r,n){const i=t.compareText;if(e in i){const t=i[e];for(let e=t.length-1;e>=0;e--)if(n.dist(t[e])<r)return !0}else i[e]=[];return i[e].push(n),!1}const Kc=Fl.VectorTileFeature.types,Hc=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function Yc(t,e,r,n,i,s,a,o,l,u,c,h,p){const d=o?Math.min(qc,Math.round(o[0])):0,f=o?Math.min(qc,Math.round(o[1])):0;t.emplaceBack(e,r,Math.round(32*n),Math.round(32*i),s,a,(d<<1)+(l?1:0),f,16*u,16*c,256*h,256*p);}function Jc(t,e,r){t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r);}function Wc(t){for(const e of t.sections)if(Gi(e.text))return !0;return !1}class Qc{constructor(t){this.layoutVertexArray=new Es,this.indexArray=new Ls,this.programConfigurations=t,this.segments=new Pa,this.dynamicLayoutVertexArray=new Bs,this.opacityVertexArray=new Cs,this.placedSymbolArray=new Hs;}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length}upload(t,e,r,n){this.isEmpty()||(r&&(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,su.members),this.indexBuffer=t.createIndexBuffer(this.indexArray,e),this.dynamicLayoutVertexBuffer=t.createVertexBuffer(this.dynamicLayoutVertexArray,au.members,!0),this.opacityVertexBuffer=t.createVertexBuffer(this.opacityVertexArray,Hc,!0),this.opacityVertexBuffer.itemSize=1),(r||n)&&this.programConfigurations.upload(t));}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy());}}si("SymbolBuffers",Qc);class th{constructor(t,e,r){this.layoutVertexArray=new t,this.layoutAttributes=e,this.indexArray=new r,this.segments=new Pa,this.collisionVertexArray=new Fs,this.collisionVertexArrayExt=new Bs;}upload(t){this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=t.createVertexBuffer(this.collisionVertexArray,ou.members,!0),this.collisionVertexBufferExt=t.createVertexBuffer(this.collisionVertexArrayExt,lu.members,!0);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy(),this.collisionVertexBufferExt.destroy());}}si("CollisionBuffers",th);class eh{constructor(t){this.collisionBoxArray=t.collisionBoxArray,this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.pixelRatio=t.pixelRatio,this.sourceLayerIndex=t.sourceLayerIndex,this.hasPattern=!1,this.hasRTLText=!1,this.sortKeyRanges=[],this.collisionCircleArray=[],this.placementInvProjMatrix=oo([]),this.placementViewportMatrix=oo([]);const e=this.layers[0]._unevaluatedLayout._values;this.textSizeData=du(this.zoom,e["text-size"]),this.iconSizeData=du(this.zoom,e["icon-size"]);const r=this.layers[0].layout,n=r.get("symbol-sort-key"),i=r.get("symbol-z-order");this.canOverlap=r.get("text-allow-overlap")||r.get("icon-allow-overlap")||r.get("text-ignore-placement")||r.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==i&&void 0!==n.constantOr(1),this.sortFeaturesByY=("viewport-y"===i||"auto"===i&&!this.sortFeaturesByKey)&&this.canOverlap,"point"===r.get("symbol-placement")&&(this.writingModes=r.get("text-writing-mode").map((t=>Xu[t]))),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.sourceID=t.sourceID;}createArrays(){this.text=new Qc(new Ia(this.layers,this.zoom,(t=>/^text/.test(t)))),this.icon=new Qc(new Ia(this.layers,this.zoom,(t=>/^icon/.test(t)))),this.glyphOffsetArray=new Ws,this.lineVertexArray=new Qs,this.symbolInstances=new Js;}calculateGlyphDependencies(t,e,r,n,i){for(let s=0;s<t.length;s++)if(e[t.charCodeAt(s)]=!0,(r||n)&&i){const r=xu[t.charAt(s)];r&&(e[r.charCodeAt(0)]=!0);}}populate(t,e,r){const n=this.layers[0],i=n.layout,s=i.get("text-font"),a=i.get("text-field"),o=i.get("icon-image"),l=("constant"!==a.value.kind||a.value.value instanceof de&&!a.value.value.isEmpty()||a.value.value.toString().length>0)&&("constant"!==s.value.kind||s.value.value.length>0),u="constant"!==o.value.kind||!!o.value.value||Object.keys(o.parameters).length>0,c=i.get("symbol-sort-key");if(this.features=[],!l&&!u)return;const h=e.iconDependencies,p=e.glyphDependencies,d=e.availableImages,f=new is(this.zoom);for(const{feature:e,id:a,index:o,sourceLayerIndex:y}of t){const t=n._featureFilter.needGeometry,m=Ra(e,t);if(!n._featureFilter.filter(f,m,r))continue;let g,x;if(t||(m.geometry=La(e)),l){const t=n.getValueAndResolveTokens("text-field",m,r,d),e=de.factory(t);Wc(e)&&(this.hasRTLText=!0),(!this.hasRTLText||"unavailable"===es()||this.hasRTLText&&ns.isParsed())&&(g=gu(e,n,m));}if(u){const t=n.getValueAndResolveTokens("icon-image",m,r,d);x=t instanceof fe?t:fe.fromString(t);}if(!g&&!x)continue;const v=this.sortFeaturesByKey?c.evaluate(m,{},r):void 0;if(this.features.push({id:a,text:g,icon:x,index:o,sourceLayerIndex:y,geometry:m.geometry,properties:e.properties,type:Kc[e.type],sortKey:v}),x&&(h[x.name]=!0),g){const t=s.evaluate(m,{},r).join(","),e="map"===i.get("text-rotation-alignment")&&"point"!==i.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(Xu.vertical)>=0;for(const r of g.sections)if(r.image)h[r.image.name]=!0;else {const n=Ri(g.toString()),i=r.fontStack||t,s=p[i]=p[i]||{};this.calculateGlyphDependencies(r.text,s,e,this.allowVerticalPlacement,n);}}}"line"===i.get("symbol-placement")&&(this.features=function(t){const e={},r={},n=[];let i=0;function s(e){n.push(t[e]),i++;}function a(t,e,i){const s=r[t];return delete r[t],r[e]=s,n[s].geometry[0].pop(),n[s].geometry[0]=n[s].geometry[0].concat(i[0]),s}function o(t,r,i){const s=e[r];return delete e[r],e[t]=s,n[s].geometry[0].shift(),n[s].geometry[0]=i[0].concat(n[s].geometry[0]),s}function l(t,e,r){const n=r?e[0][e[0].length-1]:e[0][0];return `${t}:${n.x}:${n.y}`}for(let u=0;u<t.length;u++){const c=t[u],h=c.geometry,p=c.text?c.text.toString():null;if(!p){s(u);continue}const d=l(p,h),f=l(p,h,!0);if(d in r&&f in e&&r[d]!==e[f]){const t=o(d,f,h),i=a(d,f,n[t].geometry);delete e[d],delete r[f],r[l(p,n[i].geometry,!0)]=i,n[t].geometry=null;}else d in r?a(d,f,h):f in e?o(d,f,h):(s(u),e[d]=i-1,r[f]=i-1);}return n.filter((t=>t.geometry))}(this.features)),this.sortFeaturesByKey&&this.features.sort(((t,e)=>t.sortKey-e.sortKey));}update(t,e,r){this.stateDependentLayers.length&&(this.text.programConfigurations.updatePaintArrays(t,e,this.layers,r),this.icon.programConfigurations.updatePaintArrays(t,e,this.layers,r));}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return !this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(t){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(t),this.iconCollisionBox.upload(t)),this.text.upload(t,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload),this.icon.upload(t,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload),this.uploaded=!0;}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy();}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData();}addToLineVertexArray(t,e){const r=this.lineVertexArray.length;if(void 0!==t.segment){let r=t.dist(e[t.segment+1]),n=t.dist(e[t.segment]);const i={};for(let n=t.segment+1;n<e.length;n++)i[n]={x:e[n].x,y:e[n].y,tileUnitDistanceFromAnchor:r},n<e.length-1&&(r+=e[n+1].dist(e[n]));for(let r=t.segment||0;r>=0;r--)i[r]={x:e[r].x,y:e[r].y,tileUnitDistanceFromAnchor:n},r>0&&(n+=e[r-1].dist(e[r]));for(let t=0;t<e.length;t++){const e=i[t];this.lineVertexArray.emplaceBack(e.x,e.y,e.tileUnitDistanceFromAnchor);}}return {lineStartIndex:r,lineLength:this.lineVertexArray.length-r}}addSymbols(t,e,r,n,i,s,a,o,l,u,c,h){const p=t.indexArray,d=t.layoutVertexArray,f=t.segments.prepareSegment(4*e.length,d,p,this.canOverlap?s.sortKey:void 0),y=this.glyphOffsetArray.length,m=f.vertexLength,g=this.allowVerticalPlacement&&a===Xu.vertical?Math.PI/2:0,x=s.text&&s.text.sections;for(let n=0;n<e.length;n++){const{tl:i,tr:a,bl:l,br:u,tex:c,pixelOffsetTL:y,pixelOffsetBR:m,minFontScaleX:v,minFontScaleY:b,glyphOffset:w,isSDF:_,sectionIndex:k}=e[n],A=f.vertexLength,S=w[1];Yc(d,o.x,o.y,i.x,S+i.y,c.x,c.y,r,_,y.x,y.y,v,b),Yc(d,o.x,o.y,a.x,S+a.y,c.x+c.w,c.y,r,_,m.x,y.y,v,b),Yc(d,o.x,o.y,l.x,S+l.y,c.x,c.y+c.h,r,_,y.x,m.y,v,b),Yc(d,o.x,o.y,u.x,S+u.y,c.x+c.w,c.y+c.h,r,_,m.x,m.y,v,b),Jc(t.dynamicLayoutVertexArray,o,g),p.emplaceBack(A,A+1,A+2),p.emplaceBack(A+1,A+2,A+3),f.vertexLength+=4,f.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(w[0]),n!==e.length-1&&k===e[n+1].sectionIndex||t.programConfigurations.populatePaintArrays(d.length,s,s.index,{},h,x&&x[k]);}t.placedSymbolArray.emplaceBack(o.x,o.y,y,this.glyphOffsetArray.length-y,m,l,u,o.segment,r?r[0]:0,r?r[1]:0,n[0],n[1],a,0,!1,0,c);}_commitLayoutVertex(t,e,r,n,i){t.emplaceBack(e.x,e.y,r,n,Math.round(i.x),Math.round(i.y));}_addCollisionDebugVertices(t,e,r,n,s){const a=r.segments.prepareSegment(4,r.layoutVertexArray,r.indexArray),o=a.vertexLength,l=s.anchorX,u=s.anchorY;for(let t=0;t<4;t++)r.collisionVertexArray.emplaceBack(0,0,0,0);r.collisionVertexArrayExt.emplaceBack(e,-t.padding,-t.padding),r.collisionVertexArrayExt.emplaceBack(e,t.padding,-t.padding),r.collisionVertexArrayExt.emplaceBack(e,t.padding,t.padding),r.collisionVertexArrayExt.emplaceBack(e,-t.padding,t.padding),this._commitLayoutVertex(r.layoutVertexArray,n,l,u,new i(t.x1,t.y1)),this._commitLayoutVertex(r.layoutVertexArray,n,l,u,new i(t.x2,t.y1)),this._commitLayoutVertex(r.layoutVertexArray,n,l,u,new i(t.x2,t.y2)),this._commitLayoutVertex(r.layoutVertexArray,n,l,u,new i(t.x1,t.y2)),a.vertexLength+=4;const c=r.indexArray;c.emplaceBack(o,o+1),c.emplaceBack(o+1,o+2),c.emplaceBack(o+2,o+3),c.emplaceBack(o+3,o),a.primitiveLength+=4;}_addTextDebugCollisionBoxes(t,e,r,n,i,s){for(let a=n;a<i;a++){const n=r.get(a),i=this.getSymbolInstanceTextSize(t,s,e,a);this._addCollisionDebugVertices(n,i,this.textCollisionBox,n.anchorPoint,s);}}_addIconDebugCollisionBoxes(t,e,r,n,i,s){for(let a=n;a<i;a++){const n=r.get(a),i=this.getSymbolInstanceIconSize(t,e,a);this._addCollisionDebugVertices(n,i,this.iconCollisionBox,n.anchorPoint,s);}}generateCollisionDebugBuffers(t,e){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new th(Vs,uu.members,Ns),this.iconCollisionBox=new th(Vs,uu.members,Ns);const r=yu(this.iconSizeData,t),n=yu(this.textSizeData,t);for(let i=0;i<this.symbolInstances.length;i++){const s=this.symbolInstances.get(i);this._addTextDebugCollisionBoxes(n,t,e,s.textBoxStartIndex,s.textBoxEndIndex,s),this._addTextDebugCollisionBoxes(n,t,e,s.verticalTextBoxStartIndex,s.verticalTextBoxEndIndex,s),this._addIconDebugCollisionBoxes(r,t,e,s.iconBoxStartIndex,s.iconBoxEndIndex,s),this._addIconDebugCollisionBoxes(r,t,e,s.verticalIconBoxStartIndex,s.verticalIconBoxEndIndex,s);}}getSymbolInstanceTextSize(t,e,r,n){const i=this.text.placedSymbolArray.get(e.rightJustifiedTextSymbolIndex>=0?e.rightJustifiedTextSymbolIndex:e.centerJustifiedTextSymbolIndex>=0?e.centerJustifiedTextSymbolIndex:e.leftJustifiedTextSymbolIndex>=0?e.leftJustifiedTextSymbolIndex:e.verticalPlacedTextSymbolIndex>=0?e.verticalPlacedTextSymbolIndex:n),s=fu(this.textSizeData,t,i)/hu;return this.tilePixelRatio*s}getSymbolInstanceIconSize(t,e,r){const n=this.icon.placedSymbolArray.get(r),i=fu(this.iconSizeData,t,n);return this.tilePixelRatio*i}_commitDebugCollisionVertexUpdate(t,e,r){t.emplaceBack(e,-r,-r),t.emplaceBack(e,r,-r),t.emplaceBack(e,r,r),t.emplaceBack(e,-r,r);}_updateTextDebugCollisionBoxes(t,e,r,n,i,s){for(let a=n;a<i;a++){const n=r.get(a),i=this.getSymbolInstanceTextSize(t,s,e,a);this._commitDebugCollisionVertexUpdate(this.textCollisionBox.collisionVertexArrayExt,i,n.padding);}}_updateIconDebugCollisionBoxes(t,e,r,n,i){for(let s=n;s<i;s++){const n=r.get(s),i=this.getSymbolInstanceIconSize(t,e,s);this._commitDebugCollisionVertexUpdate(this.iconCollisionBox.collisionVertexArrayExt,i,n.padding);}}updateCollisionDebugBuffers(t,e){if(!this.hasDebugData())return;this.hasTextCollisionBoxData()&&this.textCollisionBox.collisionVertexArrayExt.clear(),this.hasIconCollisionBoxData()&&this.iconCollisionBox.collisionVertexArrayExt.clear();const r=yu(this.iconSizeData,t),n=yu(this.textSizeData,t);for(let i=0;i<this.symbolInstances.length;i++){const s=this.symbolInstances.get(i);this._updateTextDebugCollisionBoxes(n,t,e,s.textBoxStartIndex,s.textBoxEndIndex,s),this._updateTextDebugCollisionBoxes(n,t,e,s.verticalTextBoxStartIndex,s.verticalTextBoxEndIndex,s),this._updateIconDebugCollisionBoxes(r,t,e,s.iconBoxStartIndex,s.iconBoxEndIndex),this._updateIconDebugCollisionBoxes(r,t,e,s.verticalIconBoxStartIndex,s.verticalIconBoxEndIndex);}this.hasTextCollisionBoxData()&&this.textCollisionBox.collisionVertexBufferExt&&this.textCollisionBox.collisionVertexBufferExt.updateData(this.textCollisionBox.collisionVertexArrayExt),this.hasIconCollisionBoxData()&&this.iconCollisionBox.collisionVertexBufferExt&&this.iconCollisionBox.collisionVertexBufferExt.updateData(this.iconCollisionBox.collisionVertexArrayExt);}_deserializeCollisionBoxesForSymbol(t,e,r,n,i,s,a,o,l){const u={};for(let n=e;n<r;n++){const e=t.get(n);u.textBox={x1:e.x1,y1:e.y1,x2:e.x2,y2:e.y2,padding:e.padding,anchorPointX:e.anchorPointX,anchorPointY:e.anchorPointY},u.textFeatureIndex=e.featureIndex;break}for(let e=n;e<i;e++){const r=t.get(e);u.verticalTextBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,padding:r.padding,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.verticalTextFeatureIndex=r.featureIndex;break}for(let e=s;e<a;e++){const r=t.get(e);u.iconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,padding:r.padding,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.iconFeatureIndex=r.featureIndex;break}for(let e=o;e<l;e++){const r=t.get(e);u.verticalIconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,padding:r.padding,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.verticalIconFeatureIndex=r.featureIndex;break}return u}deserializeCollisionBoxes(t){this.collisionArrays=[];for(let e=0;e<this.symbolInstances.length;e++){const r=this.symbolInstances.get(e);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(t,r.textBoxStartIndex,r.textBoxEndIndex,r.verticalTextBoxStartIndex,r.verticalTextBoxEndIndex,r.iconBoxStartIndex,r.iconBoxEndIndex,r.verticalIconBoxStartIndex,r.verticalIconBoxEndIndex));}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}addIndicesForPlacedSymbol(t,e){const r=t.placedSymbolArray.get(e),n=r.vertexStartIndex+4*r.numGlyphs;for(let e=r.vertexStartIndex;e<n;e+=4)t.indexArray.emplaceBack(e,e+1,e+2),t.indexArray.emplaceBack(e+1,e+2,e+3);}getSortedSymbolIndexes(t){if(this.sortedAngle===t&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const e=Math.sin(t),r=Math.cos(t),n=[],i=[],s=[];for(let t=0;t<this.symbolInstances.length;++t){s.push(t);const a=this.symbolInstances.get(t);n.push(0|Math.round(e*a.anchorX+r*a.anchorY)),i.push(a.featureIndex);}return s.sort(((t,e)=>n[t]-n[e]||i[e]-i[t])),s}addToSortKeyRanges(t,e){const r=this.sortKeyRanges[this.sortKeyRanges.length-1];r&&r.sortKey===e?r.symbolInstanceEnd=t+1:this.sortKeyRanges.push({sortKey:e,symbolInstanceStart:t,symbolInstanceEnd:t+1});}sortFeatures(t){if(this.sortFeaturesByY&&this.sortedAngle!==t&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(t),this.sortedAngle=t,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const t of this.symbolInstanceIndexes){const e=this.symbolInstances.get(t);this.featureSortOrder.push(e.featureIndex),[e.rightJustifiedTextSymbolIndex,e.centerJustifiedTextSymbolIndex,e.leftJustifiedTextSymbolIndex].forEach(((t,e,r)=>{t>=0&&r.indexOf(t)===e&&this.addIndicesForPlacedSymbol(this.text,t);})),e.verticalPlacedTextSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.text,e.verticalPlacedTextSymbolIndex),e.placedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.placedIconSymbolIndex),e.verticalPlacedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.verticalPlacedIconSymbolIndex);}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray);}}}si("SymbolBucket",eh,{omit:["layers","collisionBoxArray","features","compareText"]}),eh.MAX_GLYPHS=65535,eh.addDynamicAttributes=Jc;const rh=new xs({"symbol-placement":new ds(Rt.layout_symbol["symbol-placement"]),"symbol-spacing":new ds(Rt.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new ds(Rt.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new fs(Rt.layout_symbol["symbol-sort-key"]),"symbol-z-order":new ds(Rt.layout_symbol["symbol-z-order"]),"icon-allow-overlap":new ds(Rt.layout_symbol["icon-allow-overlap"]),"icon-ignore-placement":new ds(Rt.layout_symbol["icon-ignore-placement"]),"icon-optional":new ds(Rt.layout_symbol["icon-optional"]),"icon-rotation-alignment":new ds(Rt.layout_symbol["icon-rotation-alignment"]),"icon-size":new fs(Rt.layout_symbol["icon-size"]),"icon-text-fit":new ds(Rt.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new ds(Rt.layout_symbol["icon-text-fit-padding"]),"icon-image":new fs(Rt.layout_symbol["icon-image"]),"icon-rotate":new fs(Rt.layout_symbol["icon-rotate"]),"icon-padding":new ds(Rt.layout_symbol["icon-padding"]),"icon-keep-upright":new ds(Rt.layout_symbol["icon-keep-upright"]),"icon-offset":new fs(Rt.layout_symbol["icon-offset"]),"icon-anchor":new fs(Rt.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new ds(Rt.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new ds(Rt.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new ds(Rt.layout_symbol["text-rotation-alignment"]),"text-field":new fs(Rt.layout_symbol["text-field"]),"text-font":new fs(Rt.layout_symbol["text-font"]),"text-size":new fs(Rt.layout_symbol["text-size"]),"text-max-width":new fs(Rt.layout_symbol["text-max-width"]),"text-line-height":new ds(Rt.layout_symbol["text-line-height"]),"text-letter-spacing":new fs(Rt.layout_symbol["text-letter-spacing"]),"text-justify":new fs(Rt.layout_symbol["text-justify"]),"text-radial-offset":new fs(Rt.layout_symbol["text-radial-offset"]),"text-variable-anchor":new ds(Rt.layout_symbol["text-variable-anchor"]),"text-anchor":new fs(Rt.layout_symbol["text-anchor"]),"text-max-angle":new ds(Rt.layout_symbol["text-max-angle"]),"text-writing-mode":new ds(Rt.layout_symbol["text-writing-mode"]),"text-rotate":new fs(Rt.layout_symbol["text-rotate"]),"text-padding":new ds(Rt.layout_symbol["text-padding"]),"text-keep-upright":new ds(Rt.layout_symbol["text-keep-upright"]),"text-transform":new fs(Rt.layout_symbol["text-transform"]),"text-offset":new fs(Rt.layout_symbol["text-offset"]),"text-allow-overlap":new ds(Rt.layout_symbol["text-allow-overlap"]),"text-ignore-placement":new ds(Rt.layout_symbol["text-ignore-placement"]),"text-optional":new ds(Rt.layout_symbol["text-optional"])});var nh={paint:new xs({"icon-opacity":new fs(Rt.paint_symbol["icon-opacity"]),"icon-color":new fs(Rt.paint_symbol["icon-color"]),"icon-halo-color":new fs(Rt.paint_symbol["icon-halo-color"]),"icon-halo-width":new fs(Rt.paint_symbol["icon-halo-width"]),"icon-halo-blur":new fs(Rt.paint_symbol["icon-halo-blur"]),"icon-translate":new ds(Rt.paint_symbol["icon-translate"]),"icon-translate-anchor":new ds(Rt.paint_symbol["icon-translate-anchor"]),"text-opacity":new fs(Rt.paint_symbol["text-opacity"]),"text-color":new fs(Rt.paint_symbol["text-color"],{runtimeType:Yt,getOverride:t=>t.textColor,hasOverride:t=>!!t.textColor}),"text-halo-color":new fs(Rt.paint_symbol["text-halo-color"]),"text-halo-width":new fs(Rt.paint_symbol["text-halo-width"]),"text-halo-blur":new fs(Rt.paint_symbol["text-halo-blur"]),"text-translate":new ds(Rt.paint_symbol["text-translate"]),"text-translate-anchor":new ds(Rt.paint_symbol["text-translate-anchor"])}),layout:rh};class ih{constructor(t){this.type=t.property.overrides?t.property.overrides.runtimeType:Zt,this.defaultValue=t;}evaluate(t){if(t.formattedSection){const e=this.defaultValue.property.overrides;if(e&&e.hasOverride(t.formattedSection))return e.getOverride(t.formattedSection)}return t.feature&&t.featureState?this.defaultValue.evaluate(t.feature,t.featureState):this.defaultValue.property.specification.default}eachChild(t){this.defaultValue.isConstant()||t(this.defaultValue.value._styleExpression.expression);}outputDefined(){return !1}serialize(){return null}}si("FormatSectionOverride",ih,{omit:["defaultValue"]});class sh extends Ea{constructor(t){super(t,nh);}recalculate(t,e){if(super.recalculate(t,e),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]=this.layout.get("text-rotation-alignment")),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment")),"point"===this.layout.get("symbol-placement")){const t=this.layout.get("text-writing-mode");if(t){const e=[];for(const r of t)e.indexOf(r)<0&&e.push(r);this.layout._values["text-writing-mode"]=e;}else this.layout._values["text-writing-mode"]=["horizontal"];}this._setPaintOverrides();}getValueAndResolveTokens(t,e,r,n){const i=this.layout.get(t).evaluate(e,{},r,n),s=this._unevaluatedLayout._values[t];return s.isDataDriven()||un(s.value)||!i?i:function(t,e){return e.replace(/{([^{}]+)}/g,((e,r)=>r in t?String(t[r]):""))}(e.properties,i)}createBucket(t){return new eh(t)}queryRadius(){return 0}queryIntersectsFeature(){return !1}_setPaintOverrides(){for(const t of nh.paint.overridableProperties){if(!sh.hasPaintOverride(this.layout,t))continue;const e=this.paint.get(t),r=new ih(e),n=new ln(r,e.property.specification);let i=null;i="constant"===e.value.kind||"source"===e.value.kind?new hn("source",n):new pn("composite",n,e.value.zoomStops,e.value._interpolationType),this.paint._values[t]=new hs(e.property,i,e.parameters);}}_handleOverridablePaintPropertyUpdate(t,e,r){return !(!this.layout||e.isDataDriven()||r.isDataDriven())&&sh.hasPaintOverride(this.layout,t)}static hasPaintOverride(t,e){const r=t.get("text-field"),n=nh.paint.properties[e];let i=!1;const s=t=>{for(const e of t)if(n.overrides&&n.overrides.hasOverride(e))return void(i=!0)};if("constant"===r.value.kind&&r.value.value instanceof de)s(r.value.value.sections);else if("source"===r.value.kind){const t=e=>{i||(e instanceof ve&&ge(e.value)===te?s(e.value.sections):e instanceof ke?s(e.sections):e.eachChild(t));},e=r.value;e._styleExpression&&t(e._styleExpression.expression);}return i}getProgramConfiguration(t){return new Sa(this,t)}}var ah={paint:new xs({"background-color":new ds(Rt.paint_background["background-color"]),"background-pattern":new ms(Rt.paint_background["background-pattern"]),"background-opacity":new ds(Rt.paint_background["background-opacity"])})},oh={paint:new xs({"raster-opacity":new ds(Rt.paint_raster["raster-opacity"]),"raster-hue-rotate":new ds(Rt.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new ds(Rt.paint_raster["raster-brightness-min"]),"raster-brightness-max":new ds(Rt.paint_raster["raster-brightness-max"]),"raster-saturation":new ds(Rt.paint_raster["raster-saturation"]),"raster-contrast":new ds(Rt.paint_raster["raster-contrast"]),"raster-resampling":new ds(Rt.paint_raster["raster-resampling"]),"raster-fade-duration":new ds(Rt.paint_raster["raster-fade-duration"])})};class lh extends Ea{constructor(t){super(t,{}),this.implementation=t;}is3D(){return "3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}recalculate(){}updateTransitions(){}hasTransition(){}serialize(){}onAdd(t){this.implementation.onAdd&&this.implementation.onAdd(t,t.painter.context.gl);}onRemove(t){this.implementation.onRemove&&this.implementation.onRemove(t,t.painter.context.gl);}}var uh={paint:new xs({"sky-type":new ds(Rt.paint_sky["sky-type"]),"sky-atmosphere-sun":new ds(Rt.paint_sky["sky-atmosphere-sun"]),"sky-atmosphere-sun-intensity":new ds(Rt.paint_sky["sky-atmosphere-sun-intensity"]),"sky-gradient-center":new ds(Rt.paint_sky["sky-gradient-center"]),"sky-gradient-radius":new ds(Rt.paint_sky["sky-gradient-radius"]),"sky-gradient":new gs(Rt.paint_sky["sky-gradient"]),"sky-atmosphere-halo-color":new ds(Rt.paint_sky["sky-atmosphere-halo-color"]),"sky-atmosphere-color":new ds(Rt.paint_sky["sky-atmosphere-color"]),"sky-opacity":new ds(Rt.paint_sky["sky-opacity"])})};function ch(t,e,r){const n=po(0,0,1),i=ko(_o());return function(t,e,r){r*=.5;var n=e[0],i=e[1],s=e[2],a=e[3],o=Math.sin(r),l=Math.cos(r);t[0]=n*l-s*o,t[1]=i*l+a*o,t[2]=s*l+n*o,t[3]=a*l-i*o;}(i,i,r?-c(t)+Math.PI:c(t)),Ao(i,i,-c(e)),go(n,n,i),mo(n,n)}const hh={circle:class extends Ea{constructor(t){super(t,io);}createBucket(t){return new $a(t)}queryRadius(t){const e=t;return Qa("circle-radius",this,e)+Qa("circle-stroke-width",this,e)+to(this.paint.get("circle-translate"))}queryIntersectsFeature(t,e,r,n,i,s,a,o){const l="map"===this.paint.get("circle-pitch-alignment");if(l&&t.queryGeometry.isAboveHorizon)return !1;const u=ro(this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),c=this.paint.get("circle-radius").evaluate(e,r)+this.paint.get("circle-stroke-width").evaluate(e,r),h=l?c*t.pixelToTileUnitsFactor:c;for(const e of n)for(const r of e){const e=r.add(u),n=o&&s.elevation?s.elevation.exaggeration()*o.getElevationAt(e.x,e.y,!0):0,i=l?e:So(e,n,a),c=l?t.tilespaceRays.map((t=>To(t,n))):t.queryGeometry.screenGeometry;let p=h;const d=wo([],[r.x,r.y,n,1],a);if("viewport"===this.paint.get("circle-pitch-scale")&&"map"===this.paint.get("circle-pitch-alignment")?p*=d[3]/s.cameraToCenterDistance:"map"===this.paint.get("circle-pitch-scale")&&"viewport"===this.paint.get("circle-pitch-alignment")&&(p*=s.cameraToCenterDistance/d[3]),qa(c,i,p))return !0}return !1}getProgramIds(){return ["circle"]}getProgramConfiguration(t){return new Sa(this,t)}},heatmap:class extends Ea{createBucket(t){return new Mo(t)}constructor(t){super(t,Do),this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"heatmap-color"===t&&this._updateColorRamp();}_updateColorRamp(){this.colorRamp=Fo({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null;}resize(){this.heatmapFbo&&(this.heatmapFbo.destroy(),this.heatmapFbo=null);}queryRadius(){return 0}queryIntersectsFeature(){return !1}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}getProgramIds(){return ["heatmap","heatmapTexture"]}getProgramConfiguration(t){return new Sa(this,t)}},hillshade:class extends Ea{constructor(t){super(t,Lo);}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}getProgramIds(){return ["hillshade","hillshadePrepare"]}getProgramConfiguration(t){return new Sa(this,t)}},fill:class extends Ea{constructor(t){super(t,Al);}getProgramIds(){const t=this.paint.get("fill-pattern"),e=t&&t.constantOr(1),r=[e?"fillPattern":"fill"];return this.paint.get("fill-antialias")&&r.push(e&&!this.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline"),r}getProgramConfiguration(t){return new Sa(this,t)}recalculate(t,e){super.recalculate(t,e);const r=this.paint._values["fill-outline-color"];"constant"===r.value.kind&&void 0===r.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"]);}createBucket(t){return new _l(t)}queryRadius(){return to(this.paint.get("fill-translate"))}queryIntersectsFeature(t,e,r,n,i,s){return !t.queryGeometry.isAboveHorizon&&Na(eo(t.tilespaceGeometry,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),n)}isTileClipped(){return !0}},"fill-extrusion":class extends Ea{constructor(t){super(t,Nl);}createBucket(t){return new Ol(t)}queryRadius(){return to(this.paint.get("fill-extrusion-translate"))}is3D(){return !0}getProgramIds(){return [this.paint.get("fill-extrusion-pattern").constantOr(1)?"fillExtrusionPattern":"fillExtrusion"]}getProgramConfiguration(t){return new Sa(this,t)}queryIntersectsFeature(t,e,r,n,s,a,o,l,u){const c=ro(this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),a.angle,t.pixelToTileUnitsFactor),h=this.paint.get("fill-extrusion-height").evaluate(e,r),p=this.paint.get("fill-extrusion-base").evaluate(e,r),d=[0,0],f=l&&a.elevation,y=a.elevation?a.elevation.exaggeration():1;if(f){const e=t.tile.getBucket(this).centroidVertexArray,r=u+1;if(r<e.length){const t=e.get(r);d[0]=t.a_centroid_pos0,d[1]=t.a_centroid_pos1;}}if(0===d[0]&&1===d[1])return !1;const m=function(t,e,r,n,s,a,o,l,u){return a?function(t,e,r,n,i,s,a,o,l){const u=[],c=[],h=[0,0,0,1];for(const p of t){const t=[],d=[];for(const u of p){const c=u.x+n.x,p=u.y+n.y,f=Xl(c,p,e,r,s,a,o,l);h[0]=c,h[1]=p,h[2]=f.base,h[3]=1,wo(h,h,i),h[3]=Math.max(h[3],1e-5);const y=Zl([h[0]/h[3],h[1]/h[3],h[2]/h[3]]);h[0]=c,h[1]=p,h[2]=f.top,h[3]=1,wo(h,h,i),h[3]=Math.max(h[3],1e-5);const m=Zl([h[0]/h[3],h[1]/h[3],h[2]/h[3]]);t.push(y),d.push(m);}u.push(t),c.push(d);}return [u,c]}(t,e,r,n,s,a,o,l,u):function(t,e,r,n,s){const a=[],o=[],l=s[8]*e,u=s[9]*e,c=s[10]*e,h=s[11]*e,p=s[8]*r,d=s[9]*r,f=s[10]*r,y=s[11]*r;for(const e of t){const t=[],r=[];for(const a of e){const e=a.x+n.x,o=a.y+n.y,m=s[0]*e+s[4]*o+s[12],g=s[1]*e+s[5]*o+s[13],x=s[2]*e+s[6]*o+s[14],v=s[3]*e+s[7]*o+s[15],b=m+l,w=g+u,_=x+c,k=Math.max(v+h,1e-5),A=m+p,S=g+d,I=x+f,z=Math.max(v+y,1e-5),T=new i(b/k,w/k);T.z=_/k,t.push(T);const M=new i(A/z,S/z);M.z=I/z,r.push(M);}a.push(t),o.push(r);}return [a,o]}(t,e,r,n,s)}(n,p,h,c,o,f?l:null,d,y,a.center.lat),g=t.queryGeometry;return function(t,e,r){let n=1/0;Na(r,e)&&(n=Gl(r,e[0]));for(let i=0;i<e.length;i++){const s=e[i],a=t[i];for(let t=0;t<s.length-1;t++){const e=s[t],i=[e,s[t+1],a[t+1],a[t],e];Oa(r,i)&&(n=Math.min(n,Gl(r,i)));}}return n!==1/0&&n}(m[0],m[1],g.isPointQuery()?g.screenBounds:g.screenGeometry)}},line:class extends Ea{constructor(t){super(t,ru),this.gradientVersion=0;}_handleSpecialPaintPropertyUpdate(t){"line-gradient"===t&&(this.stepInterpolant=this._transitionablePaint._values["line-gradient"].value.expression._styleExpression.expression instanceof er,this.gradientVersion=(this.gradientVersion+1)%o);}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}recalculate(t,e){super.recalculate(t,e),this.paint._values["line-floorwidth"]=nu.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,t);}createBucket(t){return new tu(t)}getProgramIds(){const t=this.paint.get("line-dasharray"),e=this.paint.get("line-pattern").constantOr(1),r=this.paint.get("line-gradient");return [e?"linePattern":t?"lineSDF":r?"lineGradient":"line"]}getProgramConfiguration(t){return new Sa(this,t)}queryRadius(t){const e=t,r=iu(Qa("line-width",this,e),Qa("line-gap-width",this,e)),n=Qa("line-offset",this,e);return r/2+Math.abs(n)+to(this.paint.get("line-translate"))}queryIntersectsFeature(t,e,r,n,s,a){if(t.queryGeometry.isAboveHorizon)return !1;const o=eo(t.tilespaceGeometry,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),a.angle,t.pixelToTileUnitsFactor),l=t.pixelToTileUnitsFactor/2*iu(this.paint.get("line-width").evaluate(e,r),this.paint.get("line-gap-width").evaluate(e,r)),u=this.paint.get("line-offset").evaluate(e,r);return u&&(n=function(t,e){const r=[],n=new i(0,0);for(let i=0;i<t.length;i++){const s=t[i],a=[];for(let t=0;t<s.length;t++){const r=s[t-1],i=s[t],o=s[t+1],l=0===t?n:i.sub(r)._unit()._perp(),u=t===s.length-1?n:o.sub(i)._unit()._perp(),c=l._add(u)._unit();c._mult(1/(c.x*u.x+c.y*u.y)),a.push(c._mult(e)._add(i));}r.push(a);}return r}(n,u*t.pixelToTileUnitsFactor)),function(t,e,r){for(let n=0;n<e.length;n++){const i=e[n];if(t.length>=3)for(let e=0;e<i.length;e++)if(Ya(t,i[e]))return !0;if(ja(t,i,r))return !0}return !1}(o,n,l)}isTileClipped(){return !0}},symbol:sh,background:class extends Ea{constructor(t){super(t,ah);}getProgramIds(){return [this.paint.get("background-pattern")?"backgroundPattern":"background"]}},raster:class extends Ea{constructor(t){super(t,oh);}getProgramIds(){return ["raster"]}},sky:class extends Ea{constructor(t){super(t,uh),this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"sky-gradient"===t?this._updateColorRamp():"sky-atmosphere-sun"!==t&&"sky-atmosphere-halo-color"!==t&&"sky-atmosphere-color"!==t&&"sky-atmosphere-sun-intensity"!==t||(this._skyboxInvalidated=!0);}_updateColorRamp(){this.colorRamp=Fo({expression:this._transitionablePaint._values["sky-gradient"].value.expression,evaluationKey:"skyRadialProgress"}),this.colorRampTexture&&(this.colorRampTexture.destroy(),this.colorRampTexture=null);}needsSkyboxCapture(t){if(this._skyboxInvalidated||!this.skyboxTexture||!this.skyboxGeometry)return !0;if(!this.paint.get("sky-atmosphere-sun")){const e=t.style.light.properties.get("position");return this._lightPosition.azimuthal!==e.azimuthal||this._lightPosition.polar!==e.polar}}getCenter(t,e){const r=this.paint.get("sky-type");if("atmosphere"===r){const r=this.paint.get("sky-atmosphere-sun"),n=!r,i=t.style.light,s=i.properties.get("position");return n&&"viewport"===i.properties.get("anchor")&&M("The sun direction is attached to a light with viewport anchor, lighting may behave unexpectedly."),n?ch(s.azimuthal,90-s.polar,e):ch(r[0],90-r[1],e)}if("gradient"===r){const t=this.paint.get("sky-gradient-center");return ch(t[0],90-t[1],e)}}is3D(){return !1}isSky(){return !0}markSkyboxValid(t){this._skyboxInvalidated=!1,this._lightPosition=t.style.light.properties.get("position");}hasOffscreenPass(){return !0}getProgramIds(){const t=this.paint.get("sky-type");return "atmosphere"===t?["skyboxCapture","skybox"]:"gradient"===t?["skyboxGradient"]:null}}},{HTMLImageElement:ph,HTMLCanvasElement:dh,HTMLVideoElement:fh,ImageData:yh,ImageBitmap:mh}=a;class gh{constructor(t,e,r,n){this.context=t,this.format=r,this.texture=t.gl.createTexture(),this.update(e,n);}update(t,e,r){const{width:n,height:i}=t,s=!(this.size&&this.size[0]===n&&this.size[1]===i||r),{context:a}=this,{gl:o}=a;if(this.useMipmap=Boolean(e&&e.useMipmap),o.bindTexture(o.TEXTURE_2D,this.texture),a.pixelStoreUnpackFlipY.set(!1),a.pixelStoreUnpack.set(1),a.pixelStoreUnpackPremultiplyAlpha.set(this.format===o.RGBA&&(!e||!1!==e.premultiply)),s)this.size=[n,i],t instanceof ph||t instanceof dh||t instanceof fh||t instanceof yh||mh&&t instanceof mh?o.texImage2D(o.TEXTURE_2D,0,this.format,this.format,o.UNSIGNED_BYTE,t):o.texImage2D(o.TEXTURE_2D,0,this.format,n,i,0,this.format,o.UNSIGNED_BYTE,t.data);else {const{x:e,y:s}=r||{x:0,y:0};t instanceof ph||t instanceof dh||t instanceof fh||t instanceof yh||mh&&t instanceof mh?o.texSubImage2D(o.TEXTURE_2D,0,e,s,o.RGBA,o.UNSIGNED_BYTE,t):o.texSubImage2D(o.TEXTURE_2D,0,e,s,n,i,o.RGBA,o.UNSIGNED_BYTE,t.data);}this.useMipmap&&this.isSizePowerOfTwo()&&o.generateMipmap(o.TEXTURE_2D);}bind(t,e,r){const{context:n}=this,{gl:i}=n;i.bindTexture(i.TEXTURE_2D,this.texture),r!==i.LINEAR_MIPMAP_NEAREST||this.isSizePowerOfTwo()||(r=i.LINEAR),t!==this.filter&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MAG_FILTER,t),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MIN_FILTER,r||t),this.filter=t),e!==this.wrap&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_S,e),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_T,e),this.wrap=e);}isSizePowerOfTwo(){return this.size[0]===this.size[1]&&Math.log(this.size[0])/Math.LN2%1==0}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null;}}class xh{constructor(t){this._callback=t,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._callback();});}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._callback();}),0));}remove(){delete this._channel,this._callback=()=>{};}}const vh=a.performance;function bh(t){const e=t?t.url.toString():void 0;return vh.getEntriesByName(e)}class wh{constructor(){this.tasks={},this.taskQueue=[],k(["process"],this),this.invoker=new xh(this.process),this.nextId=0;}add(t,e){const r=this.nextId++,n=function({type:t,isSymbolTile:e,zoom:r}){return r=r||0,"message"===t?0:"maybePrepare"!==t||e?"parseTile"!==t||e?"parseTile"===t&&e?300-r:"maybePrepare"===t&&e?400-r:500:200-r:100-r}(e);if(0===n){C();try{t();}finally{}return {cancel:()=>{}}}return this.tasks[r]={fn:t,metadata:e,priority:n,id:r},this.taskQueue.push(r),this.invoker.trigger(),{cancel:()=>{delete this.tasks[r];}}}process(){C();try{if(this.taskQueue=this.taskQueue.filter((t=>!!this.tasks[t])),!this.taskQueue.length)return;const t=this.pick();if(null===t)return;const e=this.tasks[t];if(delete this.tasks[t],this.taskQueue.length&&this.invoker.trigger(),!e)return;e.fn();}finally{}}pick(){let t=null,e=1/0;for(let r=0;r<this.taskQueue.length;r++){const n=this.tasks[this.taskQueue[r]];n.priority<e&&(e=n.priority,t=r);}if(null===t)return null;const r=this.taskQueue[t];return this.taskQueue.splice(t,1),r}remove(){this.invoker.remove();}}class _h{constructor(t,e){t&&(e?this.setSouthWest(t).setNorthEast(e):4===t.length?this.setSouthWest([t[0],t[1]]).setNorthEast([t[2],t[3]]):this.setSouthWest(t[0]).setNorthEast(t[1]));}setNorthEast(t){return this._ne=t instanceof Ah?new Ah(t.lng,t.lat):Ah.convert(t),this}setSouthWest(t){return this._sw=t instanceof Ah?new Ah(t.lng,t.lat):Ah.convert(t),this}extend(t){const e=this._sw,r=this._ne;let n,i;if(t instanceof Ah)n=t,i=t;else {if(!(t instanceof _h))return Array.isArray(t)?4===t.length||t.every(Array.isArray)?this.extend(_h.convert(t)):this.extend(Ah.convert(t)):this;if(n=t._sw,i=t._ne,!n||!i)return this}return e||r?(e.lng=Math.min(n.lng,e.lng),e.lat=Math.min(n.lat,e.lat),r.lng=Math.max(i.lng,r.lng),r.lat=Math.max(i.lat,r.lat)):(this._sw=new Ah(n.lng,n.lat),this._ne=new Ah(i.lng,i.lat)),this}getCenter(){return new Ah((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2)}getSouthWest(){return this._sw}getNorthEast(){return this._ne}getNorthWest(){return new Ah(this.getWest(),this.getNorth())}getSouthEast(){return new Ah(this.getEast(),this.getSouth())}getWest(){return this._sw.lng}getSouth(){return this._sw.lat}getEast(){return this._ne.lng}getNorth(){return this._ne.lat}toArray(){return [this._sw.toArray(),this._ne.toArray()]}toString(){return `LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`}isEmpty(){return !(this._sw&&this._ne)}contains(t){const{lng:e,lat:r}=Ah.convert(t);let n=this._sw.lng<=e&&e<=this._ne.lng;return this._sw.lng>this._ne.lng&&(n=this._sw.lng>=e&&e>=this._ne.lng),this._sw.lat<=r&&r<=this._ne.lat&&n}static convert(t){return !t||t instanceof _h?t:new _h(t)}}const kh=6371008.8;class Ah{constructor(t,e){if(isNaN(t)||isNaN(e))throw new Error(`Invalid LngLat object: (${t}, ${e})`);if(this.lng=+t,this.lat=+e,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new Ah(y(this.lng,-180,180),this.lat)}toArray(){return [this.lng,this.lat]}toString(){return `LngLat(${this.lng}, ${this.lat})`}distanceTo(t){const e=Math.PI/180,r=this.lat*e,n=t.lat*e,i=Math.sin(r)*Math.sin(n)+Math.cos(r)*Math.cos(n)*Math.cos((t.lng-this.lng)*e);return kh*Math.acos(Math.min(i,1))}toBounds(t=0){const e=360*t/40075017,r=e/Math.cos(Math.PI/180*this.lat);return new _h(new Ah(this.lng-r,this.lat-e),new Ah(this.lng+r,this.lat+e))}static convert(t){if(t instanceof Ah)return t;if(Array.isArray(t)&&(2===t.length||3===t.length))return new Ah(Number(t[0]),Number(t[1]));if(!Array.isArray(t)&&"object"==typeof t&&null!==t)return new Ah(Number("lng"in t?t.lng:t.lon),Number(t.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}const Sh=2*Math.PI*kh;function Ih(t){return Sh*Math.cos(t*Math.PI/180)}function zh(t){return (180+t)/360}function Th(t){return (180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t*Math.PI/360)))/360}function Mh(t,e){return t/Ih(e)}function Eh(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}function Bh(t,e){return t*Ih(Eh(e))}class Ch{constructor(t,e,r=0){this.x=+t,this.y=+e,this.z=+r;}static fromLngLat(t,e=0){const r=Ah.convert(t);return new Ch(zh(r.lng),Th(r.lat),Mh(e,r.lat))}toLngLat(){return new Ah(360*this.x-180,Eh(this.y))}toAltitude(){return Bh(this.z,this.y)}meterInMercatorCoordinateUnits(){return 1/Sh*(t=Eh(this.y),1/Math.cos(t*Math.PI/180));var t;}}function Ph(t,e,r){var n=2*Math.PI*6378137/256/Math.pow(2,r);return [t*n-2*Math.PI*6378137/2,e*n-2*Math.PI*6378137/2]}class Vh{constructor(t,e,r){this.z=t,this.x=e,this.y=r,this.key=Lh(0,t,t,e,r);}equals(t){return this.z===t.z&&this.x===t.x&&this.y===t.y}url(t,e){const r=(i=this.y,s=this.z,a=Ph(256*(n=this.x),256*(i=Math.pow(2,s)-i-1),s),o=Ph(256*(n+1),256*(i+1),s),a[0]+","+a[1]+","+o[0]+","+o[1]);var n,i,s,a,o;const l=function(t,e,r){let n,i="";for(let s=t;s>0;s--)n=1<<s-1,i+=(e&n?1:0)+(r&n?2:0);return i}(this.z,this.x,this.y);return t[(this.x+this.y)%t.length].replace("{prefix}",(this.x%16).toString(16)+(this.y%16).toString(16)).replace("{z}",String(this.z)).replace("{x}",String(this.x)).replace("{y}",String("tms"===e?Math.pow(2,this.z)-this.y-1:this.y)).replace("{quadkey}",l).replace("{bbox-epsg-3857}",r)}getTilePoint(t){const e=Math.pow(2,this.z);return new i((t.x*e-this.x)*Va,(t.y*e-this.y)*Va)}getTileVec3(t){const e=Math.pow(2,this.z);return po((t.x*e-this.x)*Va,(t.y*e-this.y)*Va,Bh(t.z,t.y))}toString(){return `${this.z}/${this.x}/${this.y}`}}class Dh{constructor(t,e){this.wrap=t,this.canonical=e,this.key=Lh(t,e.z,e.z,e.x,e.y);}}class Fh{constructor(t,e,r,n,i){this.overscaledZ=t,this.wrap=e,this.canonical=new Vh(r,+n,+i),this.key=0===e&&t===r?this.canonical.key:Lh(e,t,r,n,i);}equals(t){return this.overscaledZ===t.overscaledZ&&this.wrap===t.wrap&&this.canonical.equals(t.canonical)}scaledTo(t){const e=this.canonical.z-t;return t>this.canonical.z?new Fh(t,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new Fh(t,this.wrap,t,this.canonical.x>>e,this.canonical.y>>e)}calculateScaledKey(t,e=!0){if(this.overscaledZ===t&&e)return this.key;if(t>this.canonical.z)return Lh(this.wrap*+e,t,this.canonical.z,this.canonical.x,this.canonical.y);{const r=this.canonical.z-t;return Lh(this.wrap*+e,t,t,this.canonical.x>>r,this.canonical.y>>r)}}isChildOf(t){if(t.wrap!==this.wrap)return !1;const e=this.canonical.z-t.canonical.z;return 0===t.overscaledZ||t.overscaledZ<this.overscaledZ&&t.canonical.x===this.canonical.x>>e&&t.canonical.y===this.canonical.y>>e}children(t){if(this.overscaledZ>=t)return [new Fh(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const e=this.canonical.z+1,r=2*this.canonical.x,n=2*this.canonical.y;return [new Fh(e,this.wrap,e,r,n),new Fh(e,this.wrap,e,r+1,n),new Fh(e,this.wrap,e,r,n+1),new Fh(e,this.wrap,e,r+1,n+1)]}isLessThan(t){return this.wrap<t.wrap||!(this.wrap>t.wrap)&&(this.overscaledZ<t.overscaledZ||!(this.overscaledZ>t.overscaledZ)&&(this.canonical.x<t.canonical.x||!(this.canonical.x>t.canonical.x)&&this.canonical.y<t.canonical.y))}wrapped(){return new Fh(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(t){return new Fh(this.overscaledZ,t,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new Dh(this.wrap,this.canonical)}toString(){return `${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}getTilePoint(t){return this.canonical.getTilePoint(new Ch(t.x-this.wrap,t.y))}getTileVec3(t){return this.canonical.getTileVec3(new Ch(t.x-this.wrap,t.y,t.z))}}function Lh(t,e,r,n,i){const s=1<<Math.min(r,22);let a=s*(i%s)+n%s;return t&&r<22&&(a+=s*s*((t<0?-2*t-1:2*t)%(1<<2*(22-r)))),16*(32*a+r)+(e-r)}si("CanonicalTileID",Vh),si("OverscaledTileID",Fh,{omit:["posMatrix"]});class Rh{constructor(t){this._stringToNumber={},this._numberToString=[];for(let e=0;e<t.length;e++){const r=t[e];this._stringToNumber[r]=e,this._numberToString[e]=r;}}encode(t){return this._stringToNumber[t]}decode(t){return this._numberToString[t]}}class Uh{constructor(t,e,r,n,i){this.type="Feature",this._vectorTileFeature=t,t._z=e,t._x=r,t._y=n,this.properties=t.properties,this.id=i;}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._vectorTileFeature._x,this._vectorTileFeature._y,this._vectorTileFeature._z).geometry),this._geometry}set geometry(t){this._geometry=t;}toJSON(){const t={geometry:this.geometry};for(const e in this)"_geometry"!==e&&"_vectorTileFeature"!==e&&(t[e]=this[e]);return t}}var $h=ks([{name:"a_pos",type:"Int16",components:2}]);class Oh{constructor(t,e,r){this.tileID=t,this.uid=b(),this.uses=0,this.tileSize=e,this.tileZoom=r,this.buckets={},this.expirationTime=null,this.queryPadding=0,this.hasSymbolBuckets=!1,this.hasRTLText=!1,this.dependencies={},this.expiredRequestCount=0,this.state="loading";}registerFadeDuration(t){const e=t+this.timeAdded;e<$.now()||this.fadeEndTime&&e<this.fadeEndTime||(this.fadeEndTime=e);}wasRequested(){return "errored"===this.state||"loaded"===this.state||"reloading"===this.state}loadVectorData(t,e,r){if(this.hasData()&&this.unloadVectorData(),this.state="loaded",t){t.featureIndex&&(this.latestFeatureIndex=t.featureIndex,t.rawTileData?(this.latestRawTileData=t.rawTileData,this.latestFeatureIndex.rawTileData=t.rawTileData):this.latestRawTileData&&(this.latestFeatureIndex.rawTileData=this.latestRawTileData)),this.collisionBoxArray=t.collisionBoxArray,this.buckets=function(t,e){const r={};if(!e)return r;for(const n of t){const t=n.layerIds.map((t=>e.getLayer(t))).filter(Boolean);if(0!==t.length){n.layers=t,n.stateDependentLayerIds&&(n.stateDependentLayers=n.stateDependentLayerIds.map((e=>t.filter((t=>t.id===e))[0])));for(const e of t)r[e.id]=n;}}return r}(t.buckets,e.style),this.hasSymbolBuckets=!1;for(const t in this.buckets){const e=this.buckets[t];if(e instanceof eh){if(this.hasSymbolBuckets=!0,!r)break;e.justReloaded=!0;}}if(this.hasRTLText=!1,this.hasSymbolBuckets)for(const t in this.buckets){const e=this.buckets[t];if(e instanceof eh&&e.hasRTLText){this.hasRTLText=!0,ns.isLoading()||ns.isLoaded()||"deferred"!==es()||rs();break}}this.queryPadding=0;for(const t in this.buckets){const r=this.buckets[t];this.queryPadding=Math.max(this.queryPadding,e.style.getLayer(t).queryRadius(r));}t.imageAtlas&&(this.imageAtlas=t.imageAtlas),t.glyphAtlasImage&&(this.glyphAtlasImage=t.glyphAtlasImage);}else this.collisionBoxArray=new Xs;}unloadVectorData(){for(const t in this.buckets)this.buckets[t].destroy();this.buckets={},this.imageAtlasTexture&&this.imageAtlasTexture.destroy(),this.imageAtlas&&(this.imageAtlas=null),this.glyphAtlasTexture&&this.glyphAtlasTexture.destroy(),this.latestFeatureIndex=null,this.state="unloaded";}getBucket(t){return this.buckets[t.id]}upload(t){for(const e in this.buckets){const r=this.buckets[e];r.uploadPending()&&r.upload(t);}const e=t.gl;this.imageAtlas&&!this.imageAtlas.uploaded&&(this.imageAtlasTexture=new gh(t,this.imageAtlas.image,e.RGBA),this.imageAtlas.uploaded=!0),this.glyphAtlasImage&&(this.glyphAtlasTexture=new gh(t,this.glyphAtlasImage,e.ALPHA),this.glyphAtlasImage=null);}prepare(t){this.imageAtlas&&this.imageAtlas.patchUpdatedImages(t,this.imageAtlasTexture);}queryRenderedFeatures(t,e,r,n,i,s,a,o){return this.latestFeatureIndex&&this.latestFeatureIndex.rawTileData?this.latestFeatureIndex.query({tileResult:n,pixelPosMatrix:a,transform:s,params:i},t,e,r):{}}querySourceFeatures(t,e){const r=this.latestFeatureIndex;if(!r||!r.rawTileData)return;const n=r.loadVTLayers(),i=e?e.sourceLayer:"",s=n._geojsonTileLayer||n[i];if(!s)return;const a=An(e&&e.filter),{z:o,x:l,y:u}=this.tileID.canonical,c={z:o,x:l,y:u};for(let e=0;e<s.length;e++){const n=s.feature(e);if(a.needGeometry){const t=Ra(n,!0);if(!a.filter(new is(this.tileID.overscaledZ),t,this.tileID.canonical))continue}else if(!a.filter(new is(this.tileID.overscaledZ),n))continue;const h=r.getId(n,i),p=new Uh(n,o,l,u,h);p.tile=c,t.push(p);}}hasData(){return "loaded"===this.state||"reloading"===this.state||"expired"===this.state}patternsLoaded(){return this.imageAtlas&&!!Object.keys(this.imageAtlas.patternPositions).length}setExpiryData(t){const e=this.expirationTime;if(t.cacheControl){const e=P(t.cacheControl);e["max-age"]&&(this.expirationTime=Date.now()+1e3*e["max-age"]);}else t.expires&&(this.expirationTime=new Date(t.expires).getTime());if(this.expirationTime){const t=Date.now();let r=!1;if(this.expirationTime>t)r=!1;else if(e)if(this.expirationTime<e)r=!0;else {const n=this.expirationTime-e;n?this.expirationTime=t+Math.max(n,3e4):r=!0;}else r=!0;r?(this.expiredRequestCount++,this.state="expired"):this.expiredRequestCount=0;}}getExpiryTimeout(){if(this.expirationTime)return this.expiredRequestCount?1e3*(1<<Math.min(this.expiredRequestCount-1,31)):Math.min(this.expirationTime-(new Date).getTime(),Math.pow(2,31)-1)}setFeatureState(t,e){if(!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData||0===Object.keys(t).length)return;const r=this.latestFeatureIndex.loadVTLayers();for(const n in this.buckets){if(!e.style.hasLayer(n))continue;const i=this.buckets[n],s=i.layers[0].sourceLayer||"_geojsonTileLayer",a=r[s],o=t[s];if(!a||!o||0===Object.keys(o).length)continue;i.update(o,a,this.imageAtlas&&this.imageAtlas.patternPositions||{});const l=e&&e.style&&e.style.getLayer(n);l&&(this.queryPadding=Math.max(this.queryPadding,l.queryRadius(i)));}}holdingForFade(){return void 0!==this.symbolFadeHoldUntil}symbolFadeFinished(){return !this.symbolFadeHoldUntil||this.symbolFadeHoldUntil<$.now()}clearFadeHold(){this.symbolFadeHoldUntil=void 0;}setHoldDuration(t){this.symbolFadeHoldUntil=$.now()+t;}setDependencies(t,e){const r={};for(const t of e)r[t]=!0;this.dependencies[t]=r;}hasDependency(t,e){for(const r of t){const t=this.dependencies[r];if(t)for(const r of e)if(t[r])return !0}return !1}clearQueryDebugViz(){}}class qh{constructor(){this.state={},this.stateChanges={},this.deletedStates={};}updateState(t,e,r){const n=String(e);if(this.stateChanges[t]=this.stateChanges[t]||{},this.stateChanges[t][n]=this.stateChanges[t][n]||{},x(this.stateChanges[t][n],r),null===this.deletedStates[t]){this.deletedStates[t]={};for(const e in this.state[t])e!==n&&(this.deletedStates[t][e]=null);}else if(this.deletedStates[t]&&null===this.deletedStates[t][n]){this.deletedStates[t][n]={};for(const e in this.state[t][n])r[e]||(this.deletedStates[t][n][e]=null);}else for(const e in r)this.deletedStates[t]&&this.deletedStates[t][n]&&null===this.deletedStates[t][n][e]&&delete this.deletedStates[t][n][e];}removeFeatureState(t,e,r){if(null===this.deletedStates[t])return;const n=String(e);if(this.deletedStates[t]=this.deletedStates[t]||{},r&&void 0!==e)null!==this.deletedStates[t][n]&&(this.deletedStates[t][n]=this.deletedStates[t][n]||{},this.deletedStates[t][n][r]=null);else if(void 0!==e)if(this.stateChanges[t]&&this.stateChanges[t][n])for(r in this.deletedStates[t][n]={},this.stateChanges[t][n])this.deletedStates[t][n][r]=null;else this.deletedStates[t][n]=null;else this.deletedStates[t]=null;}getState(t,e){const r=String(e),n=x({},(this.state[t]||{})[r],(this.stateChanges[t]||{})[r]);if(null===this.deletedStates[t])return {};if(this.deletedStates[t]){const r=this.deletedStates[t][e];if(null===r)return {};for(const t in r)delete n[t];}return n}initializeTileState(t,e){t.setFeatureState(this.state,e);}coalesceChanges(t,e){const r={};for(const t in this.stateChanges){this.state[t]=this.state[t]||{};const e={};for(const r in this.stateChanges[t])this.state[t][r]||(this.state[t][r]={}),x(this.state[t][r],this.stateChanges[t][r]),e[r]=this.state[t][r];r[t]=e;}for(const t in this.deletedStates){this.state[t]=this.state[t]||{};const e={};if(null===this.deletedStates[t])for(const r in this.state[t])e[r]={},this.state[t][r]={};else for(const r in this.deletedStates[t]){if(null===this.deletedStates[t][r])this.state[t][r]={};else for(const e of Object.keys(this.deletedStates[t][r]))delete this.state[t][r][e];e[r]=this.state[t][r];}r[t]=r[t]||{},x(r[t],e);}if(this.stateChanges={},this.deletedStates={},0!==Object.keys(r).length)for(const n in t)t[n].setFeatureState(r,e);}}class Nh{constructor(t){this.size=t,this.minimums=[],this.maximums=[],this.leaves=[];}getElevation(t,e){const r=this.toIdx(t,e);return {min:this.minimums[r],max:this.maximums[r]}}isLeaf(t,e){return this.leaves[this.toIdx(t,e)]}toIdx(t,e){return e*this.size+t}}function jh(t,e,r,n){let i=0,s=Number.MAX_VALUE;for(let a=0;a<3;a++)if(Math.abs(n[a])<1e-15){if(r[a]<t[a]||r[a]>e[a])return null}else {const o=1/n[a];let l=(t[a]-r[a])*o,u=(e[a]-r[a])*o;if(l>u){const t=l;l=u,u=t;}if(l>i&&(i=l),u<s&&(s=u),i>s)return null}return i}function Gh(t,e,r,n,i,s,a,o,l,u,c){const h=n-t,p=i-e,d=s-r,f=a-t,y=o-e,m=l-r,g=c[1]*m-c[2]*y,x=c[2]*f-c[0]*m,v=c[0]*y-c[1]*f,b=h*g+p*x+d*v;if(Math.abs(b)<1e-15)return null;const w=1/b,_=u[0]-t,k=u[1]-e,A=u[2]-r,S=(_*g+k*x+A*v)*w;if(S<0||S>1)return null;const I=k*d-A*p,z=A*h-_*d,T=_*p-k*h,M=(c[0]*I+c[1]*z+c[2]*T)*w;return M<0||S+M>1?null:(f*I+y*z+m*T)*w}function Zh(t,e,r){return (t-e)/(r-e)}function Xh(t,e,r,n,i,s,a,o,l){const u=1<<r,c=s-n,h=a-i,p=(t+1)/u*c+n,d=(e+0)/u*h+i,f=(e+1)/u*h+i;o[0]=(t+0)/u*c+n,o[1]=d,l[0]=p,l[1]=f;}class Kh{constructor(t){if(this.maximums=[],this.minimums=[],this.leaves=[],this.childOffsets=[],this.nodeCount=0,this.dem=t,this._siblingOffset=[[0,0],[1,0],[0,1],[1,1]],!this.dem)return;const e=function(t){const e=Math.ceil(Math.log2(t.dim/8)),r=[];let n=Math.ceil(Math.pow(2,e));const i=1/n,s=(t,e,r,n,i)=>{const s=n?1:0,a=(t+1)*r-s,o=e*r,l=(e+1)*r-s;i[0]=t*r,i[1]=o,i[2]=a,i[3]=l;};let a=new Nh(n);const o=[];for(let e=0;e<n*n;e++){s(e%n,Math.floor(e/n),i,!1,o);const r=Yh(o[0],o[1],t),l=Yh(o[2],o[1],t),u=Yh(o[2],o[3],t),c=Yh(o[0],o[3],t);a.minimums.push(Math.min(r,l,u,c)),a.maximums.push(Math.max(r,l,u,c)),a.leaves.push(1);}for(r.push(a),n/=2;n>=1;n/=2){const t=r[r.length-1];a=new Nh(n);for(let e=0;e<n*n;e++){s(e%n,Math.floor(e/n),2,!0,o);const r=t.getElevation(o[0],o[1]),i=t.getElevation(o[2],o[1]),l=t.getElevation(o[2],o[3]),u=t.getElevation(o[0],o[3]),c=t.isLeaf(o[0],o[1]),h=t.isLeaf(o[2],o[1]),p=t.isLeaf(o[2],o[3]),d=t.isLeaf(o[0],o[3]),f=Math.min(r.min,i.min,l.min,u.min),y=Math.max(r.max,i.max,l.max,u.max),m=c&&h&&p&&d;a.maximums.push(y),a.minimums.push(f),a.leaves.push(y-f<=5&&m?1:0);}r.push(a);}return r}(this.dem),r=e.length-1,n=e[r];this._addNode(n.minimums[0],n.maximums[0],n.leaves[0]),this._construct(e,0,0,r,0);}raycastRoot(t,e,r,n,i,s,a=1){return jh([t,e,-100],[r,n,this.maximums[0]*a],i,s)}raycast(t,e,r,n,i,s,a=1){if(!this.nodeCount)return null;const o=this.raycastRoot(t,e,r,n,i,s,a);if(null==o)return null;const l=[],u=[],c=[],h=[],p=[{idx:0,t:o,nodex:0,nodey:0,depth:0}];for(;p.length>0;){const{idx:o,t:d,nodex:f,nodey:y,depth:m}=p.pop();if(this.leaves[o]){Xh(f,y,m,t,e,r,n,c,h);const o=1<<m,l=(f+0)/o,u=(f+1)/o,p=(y+0)/o,g=(y+1)/o,x=Yh(l,p,this.dem)*a,v=Yh(u,p,this.dem)*a,b=Yh(u,g,this.dem)*a,w=Yh(l,g,this.dem)*a,_=Gh(c[0],c[1],x,h[0],c[1],v,h[0],h[1],b,i,s),k=Gh(h[0],h[1],b,c[0],h[1],w,c[0],c[1],x,i,s),A=Math.min(null!==_?_:Number.MAX_VALUE,null!==k?k:Number.MAX_VALUE);if(A!==Number.MAX_VALUE)return A;{const t=yo([],i,s,d);if(Hh(x,v,w,b,Zh(t[0],c[0],h[0]),Zh(t[1],c[1],h[1]))>=t[2])return d}continue}let g=0;for(let p=0;p<this._siblingOffset.length;p++){Xh((f<<1)+this._siblingOffset[p][0],(y<<1)+this._siblingOffset[p][1],m+1,t,e,r,n,c,h),c[2]=-100,h[2]=this.maximums[this.childOffsets[o]+p]*a;const d=jh(c,h,i,s);if(null!=d){const t=d;l[p]=t;let e=!1;for(let r=0;r<g&&!e;r++)t>=l[u[r]]&&(u.splice(r,0,p),e=!0);e||(u[g]=p),g++;}}for(let t=0;t<g;t++){const e=u[t];p.push({idx:this.childOffsets[o]+e,t:l[e],nodex:(f<<1)+this._siblingOffset[e][0],nodey:(y<<1)+this._siblingOffset[e][1],depth:m+1});}}return null}_addNode(t,e,r){return this.minimums.push(t),this.maximums.push(e),this.leaves.push(r),this.childOffsets.push(0),this.nodeCount++}_construct(t,e,r,n,i){if(1===t[n].isLeaf(e,r))return;this.childOffsets[i]||(this.childOffsets[i]=this.nodeCount);const s=n-1,a=t[s];let o,l=0;for(let t=0;t<this._siblingOffset.length;t++){const n=2*e+this._siblingOffset[t][0],i=2*r+this._siblingOffset[t][1],s=a.getElevation(n,i),u=a.isLeaf(n,i),c=this._addNode(s.min,s.max,u);u&&(l|=1<<t),o||(o=c);}for(let n=0;n<this._siblingOffset.length;n++)l&1<<n||this._construct(t,2*e+this._siblingOffset[n][0],2*r+this._siblingOffset[n][1],s,o+n);}}function Hh(t,e,r,n,i,s){return rr(rr(t,r,s),rr(e,n,s),i)}function Yh(t,e,r){const n=r.dim,i=f(t*n-.5,0,n-1),s=f(e*n-.5,0,n-1),a=Math.floor(i),o=Math.floor(s),l=Math.min(a+1,n-1),u=Math.min(o+1,n-1);return Hh(r.get(a,o),r.get(l,o),r.get(a,u),r.get(l,u),i-a,s-o)}const Jh={mapbox:[6553.6,25.6,.1,1e4],terrarium:[256,1,1/256,32768]};class Wh{get tree(){return this._tree||this._buildQuadTree(),this._tree}constructor(t,e,r,n=!1,i=!1){if(this.uid=t,e.height!==e.width)throw new RangeError("DEM tiles must be square");if(r&&"mapbox"!==r&&"terrarium"!==r)return M(`"${r}" is not a valid encoding type. Valid types include "mapbox" and "terrarium".`);this.stride=e.height;const s=this.dim=e.height-2;if(this.data=new Uint32Array(e.data.buffer),this.encoding=r||"mapbox",this.borderReady=n,!n){for(let t=0;t<s;t++)this.data[this._idx(-1,t)]=this.data[this._idx(0,t)],this.data[this._idx(s,t)]=this.data[this._idx(s-1,t)],this.data[this._idx(t,-1)]=this.data[this._idx(t,0)],this.data[this._idx(t,s)]=this.data[this._idx(t,s-1)];this.data[this._idx(-1,-1)]=this.data[this._idx(0,0)],this.data[this._idx(s,-1)]=this.data[this._idx(s-1,0)],this.data[this._idx(-1,s)]=this.data[this._idx(0,s-1)],this.data[this._idx(s,s)]=this.data[this._idx(s-1,s-1)],i&&this._buildQuadTree();}}_buildQuadTree(){this._tree=new Kh(this);}get(t,e,r=!1){const n=new Uint8Array(this.data.buffer);r&&(t=f(t,-1,this.dim),e=f(e,-1,this.dim));const i=4*this._idx(t,e);return ("terrarium"===this.encoding?this._unpackTerrarium:this._unpackMapbox)(n[i],n[i+1],n[i+2])}static getUnpackVector(t){return Jh[t]}get unpackVector(){return Jh[this.encoding]}_idx(t,e){if(t<-1||t>=this.dim+1||e<-1||e>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return (e+1)*this.stride+(t+1)}_unpackMapbox(t,e,r){return (256*t*256+256*e+r)/10-1e4}_unpackTerrarium(t,e,r){return 256*t+e+r/256-32768}static pack(t,e){const r=[0,0,0,0],n=Wh.getUnpackVector(e);let i=Math.floor((t+n[3])/n[2]);return r[2]=i%256,i=Math.floor(i/256),r[1]=i%256,i=Math.floor(i/256),r[0]=i,r}getPixels(){return new Vo({width:this.stride,height:this.stride},new Uint8Array(this.data.buffer))}backfillBorder(t,e,r){if(this.dim!==t.dim)throw new Error("dem dimension mismatch");let n=e*this.dim,i=e*this.dim+this.dim,s=r*this.dim,a=r*this.dim+this.dim;switch(e){case-1:n=i-1;break;case 1:i=n+1;}switch(r){case-1:s=a-1;break;case 1:a=s+1;}const o=-e*this.dim,l=-r*this.dim;for(let e=s;e<a;e++)for(let r=n;r<i;r++)this.data[this._idx(r,e)]=t.data[this._idx(r+o,e+l)];}onDeserialize(){this._tree&&(this._tree.dem=this);}}si("DEMData",Wh),si("DemMinMaxQuadTree",Kh,{omit:["dem"]});class Qh{constructor(t,e){this.max=t,this.onRemove=e,this.reset();}reset(){for(const t in this.data)for(const e of this.data[t])e.timeout&&clearTimeout(e.timeout),this.onRemove(e.value);return this.data={},this.order=[],this}add(t,e,r){const n=t.wrapped().key;void 0===this.data[n]&&(this.data[n]=[]);const i={value:e,timeout:void 0};if(void 0!==r&&(i.timeout=setTimeout((()=>{this.remove(t,i);}),r)),this.data[n].push(i),this.order.push(n),this.order.length>this.max){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t);}return this}has(t){return t.wrapped().key in this.data}getAndRemove(t){return this.has(t)?this._getAndRemoveByKey(t.wrapped().key):null}_getAndRemoveByKey(t){const e=this.data[t].shift();return e.timeout&&clearTimeout(e.timeout),0===this.data[t].length&&delete this.data[t],this.order.splice(this.order.indexOf(t),1),e.value}getByKey(t){const e=this.data[t];return e?e[0].value:null}get(t){return this.has(t)?this.data[t.wrapped().key][0].value:null}remove(t,e){if(!this.has(t))return this;const r=t.wrapped().key,n=void 0===e?0:this.data[r].indexOf(e),i=this.data[r][n];return this.data[r].splice(n,1),i.timeout&&clearTimeout(i.timeout),0===this.data[r].length&&delete this.data[r],this.onRemove(i.value),this.order.splice(this.order.indexOf(r),1),this}setMaxSize(t){for(this.max=t;this.order.length>this.max;){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t);}return this}filter(t){const e=[];for(const r in this.data)for(const n of this.data[r])t(n.value)||e.push(n);for(const t of e)this.remove(t.value.tileID,t);}}class tp{constructor(t,e,r){this.func=t,this.mask=e,this.range=r;}}tp.ReadOnly=!1,tp.ReadWrite=!0,tp.disabled=new tp(519,tp.ReadOnly,[0,1]);const ep=7680;class rp{constructor(t,e,r,n,i,s){this.test=t,this.ref=e,this.mask=r,this.fail=n,this.depthFail=i,this.pass=s;}}rp.disabled=new rp({func:519,mask:0},0,0,ep,ep,ep);class np{constructor(t,e,r){this.blendFunction=t,this.blendColor=e,this.mask=r;}}np.Replace=[1,0],np.disabled=new np(np.Replace,ce.transparent,[!1,!1,!1,!1]),np.unblended=new np(np.Replace,ce.transparent,[!0,!0,!0,!0]),np.alphaBlended=new np([1,771],ce.transparent,[!0,!0,!0,!0]);const ip=1029,sp=2305;class ap{constructor(t,e,r){this.enable=t,this.mode=e,this.frontFace=r;}}ap.disabled=new ap(!1,ip,sp),ap.backCCW=new ap(!0,ip,sp),ap.backCW=new ap(!0,ip,2304),ap.frontCW=new ap(!0,1028,2304),ap.frontCCW=new ap(!0,1028,sp);class op extends Lt{constructor(t,e,r){super(),this.id=t,this._onlySymbols=r,e.on("data",(t=>{"source"===t.dataType&&"metadata"===t.sourceDataType&&(this._sourceLoaded=!0),this._sourceLoaded&&!this._paused&&"source"===t.dataType&&"content"===t.sourceDataType&&(this.reload(),this.transform&&this.update(this.transform));})),e.on("error",(()=>{this._sourceErrored=!0;})),this._source=e,this._tiles={},this._cache=new Qh(0,this._unloadTile.bind(this)),this._timers={},this._cacheTimers={},this._maxTileCacheSize=null,this._loadedParentTiles={},this._coveredTiles={},this._state=new qh;}onAdd(t){this.map=t,this._maxTileCacheSize=t?t._maxTileCacheSize:null;}loaded(){if(this._sourceErrored)return !0;if(!this._sourceLoaded)return !1;if(!this._source.loaded())return !1;for(const t in this._tiles){const e=this._tiles[t];if("loaded"!==e.state&&"errored"!==e.state)return !1}return !0}getSource(){return this._source}pause(){this._paused=!0;}resume(){if(!this._paused)return;const t=this._shouldReloadOnResume;this._paused=!1,this._shouldReloadOnResume=!1,t&&this.reload(),this.transform&&this.update(this.transform);}_loadTile(t,e){return t.isSymbolTile=this._onlySymbols,this._source.loadTile(t,e)}_unloadTile(t){if(this._source.unloadTile)return this._source.unloadTile(t,(()=>{}))}_abortTile(t){if(this._source.abortTile)return this._source.abortTile(t,(()=>{}))}serialize(){return this._source.serialize()}prepare(t){this._source.prepare&&this._source.prepare(),this._state.coalesceChanges(this._tiles,this.map?this.map.painter:null);for(const e in this._tiles){const r=this._tiles[e];r.upload(t),r.prepare(this.map.style.imageManager);}}getIds(){return g(this._tiles).map((t=>t.tileID)).sort(lp).map((t=>t.key))}getRenderableIds(t){const e=[];for(const r in this._tiles)this._isIdRenderable(+r,t)&&e.push(this._tiles[r]);return t?e.sort(((t,e)=>{const r=t.tileID,n=e.tileID,s=new i(r.canonical.x,r.canonical.y)._rotate(this.transform.angle),a=new i(n.canonical.x,n.canonical.y)._rotate(this.transform.angle);return r.overscaledZ-n.overscaledZ||a.y-s.y||a.x-s.x})).map((t=>t.tileID.key)):e.map((t=>t.tileID)).sort(lp).map((t=>t.key))}hasRenderableParent(t){const e=this.findLoadedParent(t,0);return !!e&&this._isIdRenderable(e.tileID.key)}_isIdRenderable(t,e){return this._tiles[t]&&this._tiles[t].hasData()&&!this._coveredTiles[t]&&(e||!this._tiles[t].holdingForFade())}reload(){if(this._paused)this._shouldReloadOnResume=!0;else {this._cache.reset();for(const t in this._tiles)"errored"!==this._tiles[t].state&&this._reloadTile(+t,"reloading");}}_reloadTile(t,e){const r=this._tiles[t];r&&("loading"!==r.state&&(r.state=e),this._loadTile(r,this._tileLoaded.bind(this,r,t,e)));}_tileLoaded(t,e,r,n){if(n)return t.state="errored",void(404!==n.status?this._source.fire(new Ft(n,{tile:t})):this.update(this.transform));t.timeAdded=$.now(),"expired"===r&&(t.refreshedUponExpiration=!0),this._setTileReloadTimer(e,t),"raster-dem"===this.getSource().type&&t.dem&&this._backfillDEM(t),this._state.initializeTileState(t,this.map?this.map.painter:null),this._source.fire(new Dt("data",{dataType:"source",tile:t,coord:t.tileID,sourceCacheId:this.id}));}_backfillDEM(t){const e=this.getRenderableIds();for(let n=0;n<e.length;n++){const i=e[n];if(t.neighboringTiles&&t.neighboringTiles[i]){const e=this.getTileByID(i);r(t,e),r(e,t);}}function r(t,e){if(!t.dem||t.dem.borderReady)return;t.needsHillshadePrepare=!0,t.needsDEMTextureUpload=!0;let r=e.tileID.canonical.x-t.tileID.canonical.x;const n=e.tileID.canonical.y-t.tileID.canonical.y,i=Math.pow(2,t.tileID.canonical.z),s=e.tileID.key;0===r&&0===n||Math.abs(n)>1||(Math.abs(r)>1&&(1===Math.abs(r+i)?r+=i:1===Math.abs(r-i)&&(r-=i)),e.dem&&t.dem&&(t.dem.backfillBorder(e.dem,r,n),t.neighboringTiles&&t.neighboringTiles[s]&&(t.neighboringTiles[s].backfilled=!0)));}}getTile(t){return this.getTileByID(t.key)}getTileByID(t){return this._tiles[t]}_retainLoadedChildren(t,e,r,n){for(const i in this._tiles){let s=this._tiles[i];if(n[i]||!s.hasData()||s.tileID.overscaledZ<=e||s.tileID.overscaledZ>r)continue;let a=s.tileID;for(;s&&s.tileID.overscaledZ>e+1;){const t=s.tileID.scaledTo(s.tileID.overscaledZ-1);s=this._tiles[t.key],s&&s.hasData()&&(a=t);}let o=a;for(;o.overscaledZ>e;)if(o=o.scaledTo(o.overscaledZ-1),t[o.key]){n[a.key]=a;break}}}findLoadedParent(t,e){if(t.key in this._loadedParentTiles){const r=this._loadedParentTiles[t.key];return r&&r.tileID.overscaledZ>=e?r:null}for(let r=t.overscaledZ-1;r>=e;r--){const e=t.scaledTo(r),n=this._getLoadedTile(e);if(n)return n}}_getLoadedTile(t){const e=this._tiles[t.key];return e&&e.hasData()?e:this._cache.getByKey(this._source.reparseOverscaled?t.wrapped().key:t.canonical.key)}updateCacheSize(t,e){e=e||this._source.tileSize;const r=Math.ceil(t.width/e)+1,n=Math.ceil(t.height/e)+1,i=Math.floor(r*n*5),s="number"==typeof this._maxTileCacheSize?Math.min(this._maxTileCacheSize,i):i;this._cache.setMaxSize(s);}handleWrapJump(t){const e=Math.round((t-(void 0===this._prevLng?t:this._prevLng))/360);if(this._prevLng=t,e){const t={};for(const r in this._tiles){const n=this._tiles[r];n.tileID=n.tileID.unwrapTo(n.tileID.wrap+e),t[n.tileID.key]=n;}this._tiles=t;for(const t in this._timers)clearTimeout(this._timers[t]),delete this._timers[t];for(const t in this._tiles)this._setTileReloadTimer(+t,this._tiles[t]);}}update(t,e,r){if(this.transform=t,!this._sourceLoaded||this._paused||this.transform.freezeTileCoverage)return;if(this.usedForTerrain&&!r)return;let n;this.updateCacheSize(t,e),this.handleWrapJump(this.transform.center.lng),this._coveredTiles={},this.used||this.usedForTerrain?this._source.tileID?n=t.getVisibleUnwrappedCoordinates(this._source.tileID).map((t=>new Fh(t.canonical.z,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y))):(n=t.coveringTiles({tileSize:e||this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom&&!r,reparseOverscaled:this._source.reparseOverscaled,useElevationData:!!this.transform.elevation&&!this.usedForTerrain}),this._source.hasTile&&(n=n.filter((t=>this._source.hasTile(t))))):n=[];const i=this._updateRetainedTiles(n);if(up(this._source.type)&&0!==n.length){const t={},e={},r=Object.keys(i);for(const n of r){const r=i[n],s=this._tiles[n];if(!s||s.fadeEndTime&&s.fadeEndTime<=$.now())continue;const a=this.findLoadedParent(r,Math.max(r.overscaledZ-op.maxOverzooming,this._source.minzoom));a&&(this._addTile(a.tileID),t[a.tileID.key]=a.tileID),e[n]=r;}const s=n[n.length-1].overscaledZ;for(const t in this._tiles){const r=this._tiles[t];if(i[t]||!r.hasData())continue;let n=r.tileID;for(;n.overscaledZ>s;){n=n.scaledTo(n.overscaledZ-1);const s=this._tiles[n.key];if(s&&s.hasData()&&e[n.key]){i[t]=r.tileID;break}}}for(const e in t)i[e]||(this._coveredTiles[e]=!0,i[e]=t[e]);}for(const t in i)this._tiles[t].clearFadeHold();const s=function(t,e){const r=[];for(const n in t)n in e||r.push(n);return r}(this._tiles,i);for(const t of s){const e=this._tiles[t];e.hasSymbolBuckets&&!e.holdingForFade()?e.setHoldDuration(this.map._fadeDuration):e.hasSymbolBuckets&&!e.symbolFadeFinished()||this._removeTile(+t);}this._updateLoadedParentTileCache(),this._onlySymbols&&this._source.afterUpdate&&this._source.afterUpdate();}releaseSymbolFadeTiles(){for(const t in this._tiles)this._tiles[t].holdingForFade()&&this._removeTile(+t);}_updateRetainedTiles(t){const e={};if(0===t.length)return e;const r={},n=t[t.length-1].overscaledZ,i=t[0].overscaledZ,s=Math.max(i-op.maxOverzooming,this._source.minzoom),a=Math.max(i+op.maxUnderzooming,this._source.minzoom),o={};for(const r of t){const t=this._addTile(r);e[r.key]=r,t.hasData()||n<this._source.maxzoom&&(o[r.key]=r);}this._retainLoadedChildren(o,n,a,e);for(const n of t){let t=this._tiles[n.key];if(t.hasData())continue;if(n.canonical.z>=this._source.maxzoom){const t=n.children(this._source.maxzoom)[0],r=this.getTile(t);if(r&&r.hasData()){e[t.key]=t;continue}}else {const t=n.children(this._source.maxzoom);if(e[t[0].key]&&e[t[1].key]&&e[t[2].key]&&e[t[3].key])continue}let i=t.wasRequested();for(let a=n.overscaledZ-1;a>=s;--a){const s=n.scaledTo(a);if(r[s.key])break;if(r[s.key]=!0,t=this.getTile(s),!t&&i&&(t=this._addTile(s)),t&&(e[s.key]=s,i=t.wasRequested(),t.hasData()))break}}return e}_updateLoadedParentTileCache(){this._loadedParentTiles={};for(const t in this._tiles){const e=[];let r,n=this._tiles[t].tileID;for(;n.overscaledZ>0;){if(n.key in this._loadedParentTiles){r=this._loadedParentTiles[n.key];break}e.push(n.key);const t=n.scaledTo(n.overscaledZ-1);if(r=this._getLoadedTile(t),r)break;n=t;}for(const t of e)this._loadedParentTiles[t]=r;}}_addTile(t){let e=this._tiles[t.key];if(e)return e;e=this._cache.getAndRemove(t),e&&(this._setTileReloadTimer(t.key,e),e.tileID=t,this._state.initializeTileState(e,this.map?this.map.painter:null),this._cacheTimers[t.key]&&(clearTimeout(this._cacheTimers[t.key]),delete this._cacheTimers[t.key],this._setTileReloadTimer(t.key,e)));const r=Boolean(e);return r||(e=new Oh(t,this._source.tileSize*t.overscaleFactor(),this.transform.tileZoom),this._loadTile(e,this._tileLoaded.bind(this,e,t.key,e.state))),e?(e.uses++,this._tiles[t.key]=e,r||this._source.fire(new Dt("dataloading",{tile:e,coord:e.tileID,dataType:"source"})),e):null}_setTileReloadTimer(t,e){t in this._timers&&(clearTimeout(this._timers[t]),delete this._timers[t]);const r=e.getExpiryTimeout();r&&(this._timers[t]=setTimeout((()=>{this._reloadTile(t,"expired"),delete this._timers[t];}),r));}_removeTile(t){const e=this._tiles[t];e&&(e.uses--,delete this._tiles[t],this._timers[t]&&(clearTimeout(this._timers[t]),delete this._timers[t]),e.uses>0||(e.hasData()&&"reloading"!==e.state?this._cache.add(e.tileID,e,e.getExpiryTimeout()):(e.aborted=!0,this._abortTile(e),this._unloadTile(e))));}clearTiles(){this._shouldReloadOnResume=!1,this._paused=!1;for(const t in this._tiles)this._removeTile(+t);this._cache.reset();}tilesIn(t,e,r){const n=[],i=this.transform;if(!i)return n;for(const s in this._tiles){const a=this._tiles[s];if(r&&a.clearQueryDebugViz(),a.holdingForFade())continue;const o=t.containsTile(a,i,e);o&&n.push(o);}return n}getVisibleCoordinates(t){const e=this.getRenderableIds(t).map((t=>this._tiles[t].tileID));for(const t of e)t.posMatrix=this.transform.calculatePosMatrix(t.toUnwrapped());return e}hasTransition(){if(this._source.hasTransition())return !0;if(up(this._source.type))for(const t in this._tiles){const e=this._tiles[t];if(void 0!==e.fadeEndTime&&e.fadeEndTime>=$.now())return !0}return !1}setFeatureState(t,e,r){this._state.updateState(t=t||"_geojsonTileLayer",e,r);}removeFeatureState(t,e,r){this._state.removeFeatureState(t=t||"_geojsonTileLayer",e,r);}getFeatureState(t,e){return this._state.getState(t=t||"_geojsonTileLayer",e)}setDependencies(t,e,r){const n=this._tiles[t];n&&n.setDependencies(e,r);}reloadTilesForDependencies(t,e){for(const r in this._tiles)this._tiles[r].hasDependency(t,e)&&this._reloadTile(+r,"reloading");this._cache.filter((r=>!r.hasDependency(t,e)));}}function lp(t,e){const r=Math.abs(2*t.wrap)-+(t.wrap<0),n=Math.abs(2*e.wrap)-+(e.wrap<0);return t.overscaledZ-e.overscaledZ||n-r||e.canonical.y-t.canonical.y||e.canonical.x-t.canonical.x}function up(t){return "raster"===t||"image"===t||"video"===t}op.maxOverzooming=10,op.maxUnderzooming=3;class cp{constructor(t,e,r){this._demTile=t,this._dem=this._demTile.dem,this._scale=e,this._offset=r;}static create(t,e,r){const n=r||t.findDEMTileFor(e);if(!n||!n.dem)return;const i=n.dem,s=n.tileID,a=1<<e.canonical.z-s.canonical.z;return new cp(n,n.tileSize/Va/a,[(e.canonical.x/a-s.canonical.x)*i.dim,(e.canonical.y/a-s.canonical.y)*i.dim])}tileCoordToPixel(t,e){const r=e*this._scale+this._offset[1],n=Math.floor(t*this._scale+this._offset[0]),s=Math.floor(r);return new i(n,s)}getElevationAt(t,e,r,n){const i=t*this._scale+this._offset[0],s=e*this._scale+this._offset[1],a=Math.floor(i),o=Math.floor(s),l=this._dem;return n=!!n,r?rr(rr(l.get(a,o,n),l.get(a,o+1,n),s-o),rr(l.get(a+1,o,n),l.get(a+1,o+1,n),s-o),i-a):l.get(a,o,n)}getElevationAtPixel(t,e,r){return this._dem.get(t,e,!!r)}getMeterToDEM(t){return (1<<this._demTile.tileID.canonical.z)*Mh(1,t)*this._dem.stride}}class hp{constructor(t,e){this.tileID=t,this.x=t.canonical.x,this.y=t.canonical.y,this.z=t.canonical.z,this.grid=new ti(Va,16,0),this.featureIndexArray=new ea,this.promoteId=e;}insert(t,e,r,n,i,s=0){const a=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(r,n,i,s);const o=this.grid;for(let t=0;t<e.length;t++){const r=e[t],n=[1/0,1/0,-1/0,-1/0];for(let t=0;t<r.length;t++){const e=r[t];n[0]=Math.min(n[0],e.x),n[1]=Math.min(n[1],e.y),n[2]=Math.max(n[2],e.x),n[3]=Math.max(n[3],e.y);}n[0]<Va&&n[1]<Va&&n[2]>=0&&n[3]>=0&&o.insert(a,n[0],n[1],n[2],n[3]);}}loadVTLayers(){return this.vtLayers||(this.vtLayers=new Fl.VectorTile(new wu(this.rawTileData)).layers,this.sourceLayerCoder=new Rh(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"])),this.vtLayers}query(t,e,r,n){this.loadVTLayers();const i=t.params||{},s=An(i.filter),a=t.tileResult,o=t.transform,l=a.bufferedTilespaceBounds,u=this.grid.query(l.min.x,l.min.y,l.max.x,l.max.y,((t,e,r,n)=>Ja(a.bufferedTilespaceGeometry,t,e,r,n)));u.sort(dp);let c=null;o.elevation&&u.length>0&&(c=cp.create(o.elevation,this.tileID));const h={};let p;for(let o=0;o<u.length;o++){const l=u[o];if(l===p)continue;p=l;const d=this.featureIndexArray.get(l);let f=null;this.loadMatchingFeature(h,d,s,i.layers,i.availableImages,e,r,n,((e,r,n,i=0)=>(f||(f=La(e)),r.queryIntersectsFeature(a,e,n,f,this.z,t.transform,t.pixelPosMatrix,c,i))));}return h}loadMatchingFeature(t,e,r,n,i,s,a,o,l){const{featureIndex:u,bucketIndex:c,sourceLayerIndex:h,layoutVertexArrayOffset:p}=e,d=this.bucketLayerIDs[c];if(n&&!function(t,e){for(let r=0;r<t.length;r++)if(e.indexOf(t[r])>=0)return !0;return !1}(n,d))return;const f=this.sourceLayerCoder.decode(h),y=this.vtLayers[f].feature(u);if(r.needGeometry){const t=Ra(y,!0);if(!r.filter(new is(this.tileID.overscaledZ),t,this.tileID.canonical))return}else if(!r.filter(new is(this.tileID.overscaledZ),y))return;const m=this.getId(y,f);for(let e=0;e<d.length;e++){const r=d[e];if(n&&n.indexOf(r)<0)continue;const c=s[r];if(!c)continue;let h={};void 0!==m&&o&&(h=o.getState(c.sourceLayer||"_geojsonTileLayer",m));const f=x({},a[r]);f.paint=pp(f.paint,c.paint,y,h,i),f.layout=pp(f.layout,c.layout,y,h,i);const g=!l||l(y,c,h,p);if(!g)continue;const v=new Uh(y,this.z,this.x,this.y,m);v.layer=f;let b=t[r];void 0===b&&(b=t[r]=[]),b.push({featureIndex:u,feature:v,intersectionZ:g});}}lookupSymbolFeatures(t,e,r,n,i,s,a,o){const l={};this.loadVTLayers();const u=An(i);for(const i of t)this.loadMatchingFeature(l,{bucketIndex:r,sourceLayerIndex:n,featureIndex:i,layoutVertexArrayOffset:0},u,s,a,o,e);return l}hasLayer(t){for(const e of this.bucketLayerIDs)for(const r of e)if(t===r)return !0;return !1}getId(t,e){let r=t.id;return this.promoteId&&(r=t.properties["string"==typeof this.promoteId?this.promoteId:this.promoteId[e]],"boolean"==typeof r&&(r=Number(r))),r}}function pp(t,e,r,n,i){return S(t,((t,s)=>{const a=e instanceof ps?e.get(s):null;return a&&a.evaluate?a.evaluate(r,n,i):a}))}function dp(t,e){return e-t}si("FeatureIndex",hp,{omit:["rawTileData","sourceLayerCoder"]});class fp{constructor(t){const e={},r=[];for(const n in t){const i=t[n],s=e[n]={};for(const t in i){const e=i[+t];if(!e||0===e.bitmap.width||0===e.bitmap.height)continue;const n=e.metrics.localGlyph?2:1,a={x:0,y:0,w:e.bitmap.width+2*n,h:e.bitmap.height+2*n};r.push(a),s[t]={rect:a,metrics:e.metrics};}}const{w:n,h:i}=ju(r),s=new Po({width:n||1,height:i||1});for(const r in t){const n=t[r];for(const t in n){const i=n[+t];if(!i||0===i.bitmap.width||0===i.bitmap.height)continue;const a=e[r][t].rect,o=i.metrics.localGlyph?2:1;Po.copy(i.bitmap,s,{x:0,y:0},{x:a.x+o,y:a.y+o},i.bitmap);}}this.image=s,this.positions=e;}}si("GlyphAtlas",fp);class yp{constructor(t){this.tileID=new Fh(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.tileZoom=t.tileZoom,this.uid=t.uid,this.zoom=t.zoom,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.overscaling=this.tileID.overscaleFactor(),this.showCollisionBoxes=t.showCollisionBoxes,this.collectResourceTiming=!!t.collectResourceTiming,this.returnDependencies=!!t.returnDependencies,this.promoteId=t.promoteId,this.enableTerrain=!!t.enableTerrain,this.isSymbolTile=t.isSymbolTile;}parse(t,e,r,n,i){this.status="parsing",this.data=t,this.collisionBoxArray=new Xs;const s=new Rh(Object.keys(t.layers).sort()),a=new hp(this.tileID,this.promoteId);a.bucketLayerIDs=[];const o={},l={featureIndex:a,iconDependencies:{},patternDependencies:{},glyphDependencies:{},availableImages:r},u=e.familiesBySource[this.source];for(const e in u){const n=t.layers[e];if(!n)continue;let i=!1,c=!1;for(const t of u[e])"symbol"===t[0].type?i=!0:c=!0;if(!0===this.isSymbolTile&&!i)continue;if(!1===this.isSymbolTile&&!c)continue;1===n.version&&M(`Vector tile source "${this.source}" layer "${e}" does not use vector tile spec v2 and therefore may have some rendering errors.`);const h=s.encode(e),p=[];for(let t=0;t<n.length;t++){const r=n.feature(t),i=a.getId(r,e);p.push({feature:r,id:i,index:t,sourceLayerIndex:h});}for(const t of u[e]){const e=t[0];void 0!==this.isSymbolTile&&"symbol"===e.type!==this.isSymbolTile||e.minzoom&&this.zoom<Math.floor(e.minzoom)||e.maxzoom&&this.zoom>=e.maxzoom||"none"!==e.visibility&&(mp(t,this.zoom,r),(o[e.id]=e.createBucket({index:a.bucketLayerIDs.length,layers:t,zoom:this.zoom,pixelRatio:this.pixelRatio,overscaling:this.overscaling,collisionBoxArray:this.collisionBoxArray,sourceLayerIndex:h,sourceID:this.source,enableTerrain:this.enableTerrain})).populate(p,l,this.tileID.canonical),a.bucketLayerIDs.push(t.map((t=>t.id))));}}let c,h,p,d;const f={type:"maybePrepare",isSymbolTile:this.isSymbolTile,zoom:this.zoom},y=S(l.glyphDependencies,(t=>Object.keys(t).map(Number)));Object.keys(y).length?n.send("getGlyphs",{uid:this.uid,stacks:y},((t,e)=>{c||(c=t,h=e,v.call(this));}),void 0,!1,f):h={};const m=Object.keys(l.iconDependencies);m.length?n.send("getImages",{icons:m,source:this.source,tileID:this.tileID,type:"icons"},((t,e)=>{c||(c=t,p=e,v.call(this));}),void 0,!1,f):p={};const x=Object.keys(l.patternDependencies);function v(){if(c)return i(c);if(h&&p&&d){const t=new fp(h),e=new Zu(p,d);for(const n in o){const i=o[n];i instanceof eh?(mp(i.layers,this.zoom,r),Uc(i,h,t.positions,p,e.iconPositions,this.showCollisionBoxes,this.tileID.canonical,this.tileZoom)):i.hasPattern&&(i instanceof tu||i instanceof _l||i instanceof Ol)&&(mp(i.layers,this.zoom,r),i.addFeatures(l,this.tileID.canonical,e.patternPositions));}this.status="done",i(null,{buckets:g(o).filter((t=>!t.isEmpty())),featureIndex:a,collisionBoxArray:this.collisionBoxArray,glyphAtlasImage:t.image,imageAtlas:e,glyphMap:this.returnDependencies?h:null,iconMap:this.returnDependencies?p:null,glyphPositions:this.returnDependencies?t.positions:null});}}x.length?n.send("getImages",{icons:x,source:this.source,tileID:this.tileID,type:"patterns"},((t,e)=>{c||(c=t,d=e,v.call(this));}),void 0,!1,f):d={},v.call(this);}}function mp(t,e,r){const n=new is(e);for(const e of t)e.recalculate(n,r);}class gp{constructor(t){this.entries={},this.scheduler=t;}request(t,e,r,n){const i=this.entries[t]=this.entries[t]||{callbacks:[]};if(i.result){const[t,r]=i.result;return this.scheduler?this.scheduler.add((()=>{n(t,r);}),e):n(t,r),()=>{}}return i.callbacks.push(n),i.cancel||(i.cancel=r(((r,n)=>{i.result=[r,n];for(const t of i.callbacks)this.scheduler?this.scheduler.add((()=>{t(r,n);}),e):t(r,n);setTimeout((()=>delete this.entries[t]),3e3);}))),()=>{i.result||(i.callbacks=i.callbacks.filter((t=>t!==n)),i.callbacks.length||(i.cancel(),delete this.entries[t]));}}}function xp(t,e,r){const n=JSON.stringify(t.request);return t.data&&(this.deduped.entries[n]={result:[null,t.data]}),this.deduped.request(n,{type:"parseTile",isSymbolTile:t.isSymbolTile,zoom:t.tileZoom},(e=>{const n=St(t.request,((t,n,i,s)=>{t?e(t):n&&e(null,{vectorTile:r?void 0:new Fl.VectorTile(new wu(n)),rawData:n,cacheControl:i,expires:s});}));return ()=>{n.cancel(),e();}}),e)}t.ARRAY_TYPE=so,t.AUTH_ERR_MSG=Y,t.Actor=class{constructor(t,e,r){this.target=t,this.parent=e,this.mapId=r,this.callbacks={},this.cancelCallbacks={},k(["receive"],this),this.target.addEventListener("message",this.receive,!1),this.globalScope=C()?t:a,this.scheduler=new wh;}send(t,e,r,n,i=!1,s){const a=Math.round(1e18*Math.random()).toString(36).substring(0,10);r&&(r.metadata=s,this.callbacks[a]=r);const o=R(this.globalScope)?void 0:[];return this.target.postMessage({id:a,type:t,hasCallback:!!r,targetMapId:n,mustQueue:i,sourceMapId:this.mapId,data:li(e,o)},o),{cancel:()=>{r&&delete this.callbacks[a],this.target.postMessage({id:a,type:"<cancel>",targetMapId:n,sourceMapId:this.mapId});}}}receive(t){const e=t.data,r=e.id;if(r&&(!e.targetMapId||this.mapId===e.targetMapId))if("<cancel>"===e.type){const t=this.cancelCallbacks[r];delete this.cancelCallbacks[r],t&&t.cancel();}else if(e.mustQueue||C()){const t=this.callbacks[r];this.cancelCallbacks[r]=this.scheduler.add((()=>this.processTask(r,e)),t&&t.metadata||{type:"message"});}else this.processTask(r,e);}processTask(t,e){if("<response>"===e.type){const r=this.callbacks[t];delete this.callbacks[t],r&&(e.error?r(ui(e.error)):r(null,ui(e.data)));}else {const r=R(this.globalScope)?void 0:[],n=e.hasCallback?(e,n)=>{delete this.cancelCallbacks[t],this.target.postMessage({id:t,type:"<response>",sourceMapId:this.mapId,error:e?li(e):null,data:li(n,r)},r);}:t=>{},i=ui(e.data);if(this.parent[e.type])this.parent[e.type](e.sourceMapId,i,n);else if(this.parent.getWorkerSource){const t=e.type.split(".");this.parent.getWorkerSource(e.sourceMapId,t[0],i.source)[t[1]](i,n);}else n(new Error(`Could not find function ${e.type}`));}}remove(){this.scheduler.remove(),this.target.removeEventListener("message",this.receive,!1);}},t.CanonicalTileID=Vh,t.Color=ce,t.ColorMode=np,t.CullFaceMode=ap,t.DEMData=Wh,t.DataConstantProperty=ds,t.DedupedRequest=gp,t.DepthMode=tp,t.EXTENT=Va,t.Elevation=class{getAtPoint(t,e=0){const r=this._source();if(!r)return e;if(t.y<0||t.y>1)return e;const n=r.getSource().maxzoom,i=1<<n,s=Math.floor(t.x),a=t.x-s,o=new Fh(n,s,n,Math.floor(a*i),Math.floor(t.y*i)),l=this.findDEMTileFor(o);if(!l||!l.dem)return e;const u=l.dem,c=1<<l.tileID.canonical.z,h=(a*c-l.tileID.canonical.x)*u.dim,p=(t.y*c-l.tileID.canonical.y)*u.dim,d=Math.floor(h),f=Math.floor(p);return this.exaggeration()*rr(rr(u.get(d,f),u.get(d,f+1),p-f),rr(u.get(d+1,f),u.get(d+1,f+1),p-f),h-d)}getAtTileOffset(t,e,r){const n=1<<t.canonical.z;return this.getAtPoint(new Ch(t.wrap+(t.canonical.x+e/Va)/n,(t.canonical.y+r/Va)/n))}getForTilePoints(t,e,r,n){const i=cp.create(this,t,n);return !!i&&(e.forEach((t=>{t[2]=this.exaggeration()*i.getElevationAt(t[0],t[1],r);})),!0)}getMinMaxForTile(t){const e=this.findDEMTileFor(t);if(!e||!e.dem)return null;const r=e.dem.tree,n=e.tileID,i=1<<t.canonical.z-n.canonical.z;let s=t.canonical.x/i-n.canonical.x,a=t.canonical.y/i-n.canonical.y,o=0;for(let e=0;e<t.canonical.z-n.canonical.z&&!r.leaves[o];e++){s*=2,a*=2;const t=2*Math.floor(a)+Math.floor(s);o=r.childOffsets[o]+t,s%=1,a%=1;}return {min:this.exaggeration()*r.minimums[o],max:this.exaggeration()*r.maximums[o]}}getMinElevationBelowMSL(){throw new Error("Pure virtual method called.")}raycast(t,e,r){throw new Error("Pure virtual method called.")}pointCoordinate(t){throw new Error("Pure virtual method called.")}_source(){throw new Error("Pure virtual method called.")}exaggeration(){throw new Error("Pure virtual method called.")}findDEMTileFor(t){throw new Error("Pure virtual method called.")}get visibleDemTiles(){throw new Error("Getter must be implemented in subclass.")}},t.ErrorEvent=Ft,t.EvaluationParameters=is,t.Event=Dt,t.Evented=Lt,t.GlyphManager=Ic,t.ImagePosition=Gu,t.LngLat=Ah,t.LngLatBounds=_h,t.LocalGlyphMode=Sc,t.MAX_SAFE_INTEGER=o,t.MercatorCoordinate=Ch,t.ONE_EM=hu,t.OverscaledTileID=Fh,t.Properties=xs,t.RGBAImage=Vo,t.RequestManager=class{constructor(t,e,r){this._transformRequestFn=t,this._customAccessToken=e,this._silenceAuthErrors=!!r,this._createSkuToken();}_createSkuToken(){const t=function(){let t="";for(let e=0;e<10;e++)t+="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"[Math.floor(62*Math.random())];return {token:["1",H,t].join(""),tokenExpiresAt:Date.now()+432e5}}();this._skuToken=t.token,this._skuTokenExpiresAt=t.tokenExpiresAt;}_isSkuTokenExpired(){return Date.now()>this._skuTokenExpiresAt}transformRequest(t,e){return this._transformRequestFn&&this._transformRequestFn(t,e)||{url:t}}normalizeStyleURL(t,e){if(!J(t))return t;const r=tt(t);return r.path=`/styles/v1${r.path}`,this._makeAPIURL(r,this._customAccessToken||e)}normalizeGlyphsURL(t,e){if(!J(t))return t;const r=tt(t);return r.path=`/fonts/v1${r.path}`,this._makeAPIURL(r,this._customAccessToken||e)}normalizeSourceURL(t,e){if(!J(t))return t;const r=tt(t);return r.path=`/v4/${r.authority}.json`,r.params.push("secure"),this._makeAPIURL(r,this._customAccessToken||e)}normalizeSpriteURL(t,e,r,n){const i=tt(t);return J(t)?(i.path=`/styles/v1${i.path}/sprite${e}${r}`,this._makeAPIURL(i,this._customAccessToken||n)):(i.path+=`${e}${r}`,et(i))}normalizeTileURL(t,e,r){if(this._isSkuTokenExpired()&&this._createSkuToken(),t&&!J(t))return t;const n=tt(t);n.path=n.path.replace(/(\.(png|jpg)\d*)(?=$)/,`${e||r&&"raster"!==n.authority&&512===r?"@2x":""}${N.supported?".webp":"$1"}`),"raster"===n.authority?n.path=`/${q.RASTER_URL_PREFIX}${n.path}`:(n.path=n.path.replace(/^.+\/v4\//,"/"),n.path=`/${q.TILE_URL_VERSION}${n.path}`);const i=this._customAccessToken||function(t){for(const e of t){const t=e.match(/^access_token=(.*)$/);if(t)return t[1]}return null}(n.params)||q.ACCESS_TOKEN;return q.REQUIRE_ACCESS_TOKEN&&i&&this._skuToken&&n.params.push(`sku=${this._skuToken}`),this._makeAPIURL(n,i)}canonicalizeTileURL(t,e){const r=tt(t);if(!r.path.match(/^(\/v4\/|\/raster\/v1\/)/)||!r.path.match(/\.[\w]+$/))return t;let n="mapbox://";r.path.match(/^\/raster\/v1\//)?n+=`raster/${r.path.replace(`/${q.RASTER_URL_PREFIX}/`,"")}`:n+=`tiles/${r.path.replace(`/${q.TILE_URL_VERSION}/`,"")}`;let i=r.params;return e&&(i=i.filter((t=>!t.match(/^access_token=/)))),i.length&&(n+=`?${i.join("&")}`),n}canonicalizeTileset(t,e){const r=!!e&&J(e),n=[];for(const e of t.tiles||[])W(e)?n.push(this.canonicalizeTileURL(e,r)):n.push(e);return n}_makeAPIURL(t,e){const r="See https://www.mapbox.com/api-documentation/#access-tokens-and-token-scopes",n=tt(q.API_URL);if(t.protocol=n.protocol,t.authority=n.authority,"http"===t.protocol){const e=t.params.indexOf("secure");e>=0&&t.params.splice(e,1);}if("/"!==n.path&&(t.path=`${n.path}${t.path}`),!q.REQUIRE_ACCESS_TOKEN)return et(t);if(e=e||q.ACCESS_TOKEN,!this._silenceAuthErrors){if(!e)throw new Error(`An API access token is required to use Mapbox GL. ${r}`);if("s"===e[0])throw new Error(`Use a public access token (pk.*) with Mapbox GL, not a secret access token (sk.*). ${r}`)}return t.params=t.params.filter((t=>-1===t.indexOf("access_token"))),t.params.push(`access_token=${e||""}`),et(t)}},t.ResourceType=wt,t.SegmentVector=Pa,t.SourceCache=op,t.StencilMode=rp,t.StructArrayLayout1ui2=js,t.StructArrayLayout2f1f2i16=Ds,t.StructArrayLayout2i4=Ss,t.StructArrayLayout2ui4=Ns,t.StructArrayLayout3f12=Bs,t.StructArrayLayout3ui6=Ls,t.StructArrayLayout4i8=Is,t.Texture=gh,t.Tile=Oh,t.Transitionable=os,t.Uniform1f=fa,t.Uniform1i=class extends da{constructor(t,e){super(t,e),this.current=0;}set(t){this.current!==t&&(this.current=t,this.gl.uniform1i(this.location,t));}},t.Uniform2f=class extends da{constructor(t,e){super(t,e),this.current=[0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]||(this.current=t,this.gl.uniform2f(this.location,t[0],t[1]));}},t.Uniform3f=class extends da{constructor(t,e){super(t,e),this.current=[0,0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]||(this.current=t,this.gl.uniform3f(this.location,t[0],t[1],t[2]));}},t.Uniform4f=ya,t.UniformColor=ma,t.UniformMatrix3f=class extends da{constructor(t,e){super(t,e),this.current=xa;}set(t){for(let e=0;e<9;e++)if(t[e]!==this.current[e]){this.current=t,this.gl.uniformMatrix3fv(this.location,!1,t);break}}},t.UniformMatrix4f=class extends da{constructor(t,e){super(t,e),this.current=ga;}set(t){if(t[12]!==this.current[12]||t[0]!==this.current[0])return this.current=t,void this.gl.uniformMatrix4fv(this.location,!1,t);for(let e=1;e<16;e++)if(t[e]!==this.current[e]){this.current=t,this.gl.uniformMatrix4fv(this.location,!1,t);break}}},t.UnwrappedTileID=Dh,t.ValidationError=Ut,t.VectorTileWorkerSource=class extends Lt{constructor(t,e,r,n,i){super(),this.actor=t,this.layerIndex=e,this.availableImages=r,this.loadVectorData=i||xp,this.loading={},this.loaded={},this.deduped=new gp(t.scheduler),this.isSpriteLoaded=n,this.scheduler=t.scheduler;}loadTile(t,e){const r=t.uid,n=t&&t.request,i=n&&n.collectResourceTiming,s=this.loading[r]=new yp(t);s.abort=this.loadVectorData(t,((a,o)=>{const l=!this.loading[r];if(delete this.loading[r],l||a||!o)return s.status="done",l||(this.loaded[r]=s),e(a);const u=o.rawData,c={};o.expires&&(c.expires=o.expires),o.cacheControl&&(c.cacheControl=o.cacheControl),s.vectorTile=o.vectorTile||new Fl.VectorTile(new wu(u));const h=()=>{s.parse(s.vectorTile,this.layerIndex,this.availableImages,this.actor,((t,r)=>{if(t||!r)return e(t);const s={};if(i){const t=bh(n);t.length>0&&(s.resourceTiming=JSON.parse(JSON.stringify(t)));}e(null,x({rawTileData:u.slice(0)},r,c,s));}));};this.isSpriteLoaded?h():this.once("isSpriteLoaded",(()=>{this.scheduler?this.scheduler.add(h,{type:"parseTile",isSymbolTile:t.isSymbolTile,zoom:t.tileZoom}):h();})),this.loaded=this.loaded||{},this.loaded[r]=s;}));}reloadTile(t,e){const r=this.loaded,n=t.uid,i=this;if(r&&r[n]){const s=r[n];s.showCollisionBoxes=t.showCollisionBoxes,s.enableTerrain=!!t.enableTerrain;const a=(t,r)=>{const n=s.reloadCallback;n&&(delete s.reloadCallback,s.parse(s.vectorTile,i.layerIndex,this.availableImages,i.actor,n)),e(t,r);};"parsing"===s.status?s.reloadCallback=a:"done"===s.status&&(s.vectorTile?s.parse(s.vectorTile,this.layerIndex,this.availableImages,this.actor,a):a());}}abortTile(t,e){const r=t.uid,n=this.loading[r];n&&(n.abort&&n.abort(),delete this.loading[r]),e();}removeTile(t,e){const r=this.loaded,n=t.uid;r&&r[n]&&delete r[n],e();}},t.WritingMode=Xu,t.ZoomHistory=ci,t.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t},t.addDynamicAttributes=Jc,t.altitudeFromMercatorZ=Bh,t.asyncAll=m,t.bezier=p,t.bindAll=k,t.bufferConvexPolygon=function(t,e){const r=[];for(let n=0;n<t.length;n++){const i=y(n-1,-1,t.length-1),s=y(n+1,-1,t.length-1),a=t[n],o=t[s],l=t[i].sub(a).unit(),u=o.sub(a).unit(),c=u.angleWithSep(l.x,l.y),h=l.add(u).unit().mult(-1*e/Math.sin(c/2));r.push(a.add(h));}return r},t.cacheEntryPossiblyAdded=function(t){vt++,vt>yt&&(t.getActor().send("enforceCacheSizeLimit",ft),vt=0);},t.clamp=f,t.clearTileCache=function(t){const e=a.caches.delete(ht);t&&e.catch(t).then((()=>t()));},t.clipLine=xc,t.clone=function(t){var e=new so(3);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e},t.clone$1=function(t){var e=new so(16);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e},t.clone$2=z,t.collisionCircleLayout=cu,t.config=q,t.conjugate=function(t,e){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=e[3],t},t.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t},t.create=co,t.create$1=function(){var t=new so(16);return so!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0),t[0]=1,t[5]=1,t[10]=1,t[15]=1,t},t.create$2=ao,t.createExpression=cn,t.createFilter=An,t.createLayout=ks,t.createStyleLayer=function(t){return "custom"===t.type?new lh(t):new hh[t.type](t)},t.cross=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=r[0],o=r[1],l=r[2];return t[0]=i*l-s*o,t[1]=s*a-n*l,t[2]=n*o-i*a,t},t.degToRad=c,t.div=function(t,e,r){return t[0]=e[0]/r[0],t[1]=e[1]/r[1],t[2]=e[2]/r[2],t},t.dot=function(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]},t.dot$1=function(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]+t[3]*e[3]},t.ease=d,t.easeCubicInOut=h,t.emitValidationErrors=Qn,t.endsWith=A,t.enforceCacheSizeLimit=function(t){mt(),pt&&pt.then((e=>{e.keys().then((r=>{for(let n=0;n<r.length-t;n++)e.delete(r[n]);}));}));},t.evaluateSizeForFeature=fu,t.evaluateSizeForZoom=yu,t.evaluateVariableOffset=Rc,t.evented=ts,t.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]},t.exactEquals$1=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]},t.exported=$,t.exported$1=N,t.extend=x,t.filterObject=I,t.fromMat4=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t},t.fromQuat=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=r+r,o=n+n,l=i+i,u=r*a,c=n*a,h=n*o,p=i*a,d=i*o,f=i*l,y=s*a,m=s*o,g=s*l;return t[0]=1-h-f,t[1]=c+g,t[2]=p-m,t[3]=0,t[4]=c-g,t[5]=1-u-f,t[6]=d+y,t[7]=0,t[8]=p+m,t[9]=d-y,t[10]=1-u-h,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},t.fromRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=r,t[2]=0,t[3]=-r,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},t.getAnchorAlignment=ac,t.getAnchorJustification=$c,t.getBounds=function(t){let e=1/0,r=1/0,n=-1/0,s=-1/0;for(const i of t)e=Math.min(e,i.x),r=Math.min(r,i.y),n=Math.max(n,i.x),s=Math.max(s,i.y);return {min:new i(e,r),max:new i(n,s)}},t.getImage=Ct,t.getJSON=function(t,e){return At(x(t,{type:"json"}),e)},t.getMapSessionAPI=ut,t.getPerformanceMeasurement=bh,t.getRTLTextPluginStatus=es,t.getReferrer=kt,t.getVideo=function(t,e){const r=a.document.createElement("video");r.muted=!0,r.onloadstart=function(){e(null,r);};for(let e=0;e<t.length;e++){const n=a.document.createElement("source");Tt(t[e])||(r.crossOrigin="Anonymous"),n.src=t[e],r.appendChild(n);}return {cancel:()=>{}}},t.identity=oo,t.identity$1=ko,t.invert=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=e[9],p=e[10],d=e[11],f=e[12],y=e[13],m=e[14],g=e[15],x=r*o-n*a,v=r*l-i*a,b=r*u-s*a,w=n*l-i*o,_=n*u-s*o,k=i*u-s*l,A=c*y-h*f,S=c*m-p*f,I=c*g-d*f,z=h*m-p*y,T=h*g-d*y,M=p*g-d*m,E=x*M-v*T+b*z+w*I-_*S+k*A;return E?(t[0]=(o*M-l*T+u*z)*(E=1/E),t[1]=(i*T-n*M-s*z)*E,t[2]=(y*k-m*_+g*w)*E,t[3]=(p*_-h*k-d*w)*E,t[4]=(l*I-a*M-u*S)*E,t[5]=(r*M-i*I+s*S)*E,t[6]=(m*b-f*k-g*v)*E,t[7]=(c*k-p*b+d*v)*E,t[8]=(a*T-o*I+u*A)*E,t[9]=(n*I-r*T-s*A)*E,t[10]=(f*_-y*b+g*x)*E,t[11]=(h*b-c*_-d*x)*E,t[12]=(o*S-a*z-l*A)*E,t[13]=(r*z-n*S+i*A)*E,t[14]=(y*v-f*w-m*x)*E,t[15]=(c*w-h*v+p*x)*E,t):null},t.isMapAuthenticated=function(t){return ct.has(t)},t.isMapboxURL=J,t.latFromMercatorY=Eh,t.len=bo,t.length=ho,t.length$1=function(t){return Math.hypot(t[0],t[1],t[2],t[3])},t.loadVectorTile=xp,t.makeRequest=At,t.mercatorXfromLng=zh,t.mercatorYfromLat=Th,t.mercatorZfromAltitude=Mh,t.mul=function(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t[2]=e[2]*r[2],t[3]=e[3]*r[3],t},t.mul$1=uo,t.mul$2=function(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t[2]=e[2]*r[2],t},t.multiply=lo,t.nextPowerOfTwo=function(t){return t<=1?1:Math.pow(2,Math.ceil(Math.log(t)/Math.LN2))},t.normalize=mo,t.normalize$1=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=r*r+n*n+i*i+s*s;return a>0&&(a=1/Math.sqrt(a)),t[0]=r*a,t[1]=n*a,t[2]=i*a,t[3]=s*a,t},t.number=rr,t.offscreenCanvasSupported=bt,t.ortho=function(t,e,r,n,i,s,a){var o=1/(e-r),l=1/(n-i),u=1/(s-a);return t[0]=-2*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*l,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*u,t[11]=0,t[12]=(e+r)*o,t[13]=(i+n)*l,t[14]=(a+s)*u,t[15]=1,t},t.pbf=wu,t.perspective=function(t,e,r,n,i){var s,a=1/Math.tan(e/2);return t[0]=a/r,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=a,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=i&&i!==1/0?(t[10]=(i+n)*(s=1/(n-i)),t[14]=2*i*n*s):(t[10]=-1,t[14]=-2*n),t},t.pick=function(t,e){const r={};for(let n=0;n<e.length;n++){const i=e[n];i in t&&(r[i]=t[i]);}return r},t.plugin=ns,t.pointGeometry=i,t.polygonIntersectsBox=Ja,t.polygonIntersectsPolygon=Oa,t.polygonizeBounds=function(t,e,r=0,n=!0){const s=new i(r,r),a=t.sub(s),o=e.add(s),l=[a,new i(o.x,a.y),o,new i(a.x,o.y)];return n&&l.push(a),l},t.posAttributes=$h,t.postMapLoadEvent=ot,t.postTurnstileEvent=st,t.potpack=ju,t.prevPowerOfTwo=function(t){return t<=1?1:Math.pow(2,Math.floor(Math.log(t)/Math.LN2))},t.radToDeg=function(t){return t*u},t.refProperties=["type","source","source-layer","minzoom","maxzoom","filter","layout"],t.registerForPluginStateChange=function(t){return t({pluginStatus:Yi,pluginURL:Ji}),ts.on("pluginStateChange",t),t},t.removeAuthState=function(t){ct.delete(t);},t.renderColorRamp=Fo,t.rotateX=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[4],a=e[5],o=e[6],l=e[7],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[4]=s*i+u*n,t[5]=a*i+c*n,t[6]=o*i+h*n,t[7]=l*i+p*n,t[8]=u*i-s*n,t[9]=c*i-a*n,t[10]=h*i-o*n,t[11]=p*i-l*n,t},t.rotateX$1=Ao,t.rotateY=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[0],a=e[1],o=e[2],l=e[3],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*i-u*n,t[1]=a*i-c*n,t[2]=o*i-h*n,t[3]=l*i-p*n,t[8]=s*n+u*i,t[9]=a*n+c*i,t[10]=o*n+h*i,t[11]=l*n+p*i,t},t.rotateZ=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[0],a=e[1],o=e[2],l=e[3],u=e[4],c=e[5],h=e[6],p=e[7];return e!==t&&(t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*i+u*n,t[1]=a*i+c*n,t[2]=o*i+h*n,t[3]=l*i+p*n,t[4]=u*i-s*n,t[5]=c*i-a*n,t[6]=h*i-o*n,t[7]=p*i-l*n,t},t.rotateZ$1=function(t,e,r){r*=.5;var n=e[0],i=e[1],s=e[2],a=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=n*l+i*o,t[1]=i*l-n*o,t[2]=s*l+a*o,t[3]=a*l-s*o,t},t.scale=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t},t.scale$1=function(t,e,r){var n=r[0],i=r[1],s=r[2];return t[0]=e[0]*n,t[1]=e[1]*n,t[2]=e[2]*n,t[3]=e[3]*n,t[4]=e[4]*i,t[5]=e[5]*i,t[6]=e[6]*i,t[7]=e[7]*i,t[8]=e[8]*s,t[9]=e[9]*s,t[10]=e[10]*s,t[11]=e[11]*s,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},t.scale$2=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t},t.scaleAndAdd=yo,t.setCacheLimits=function(t,e){ft=t,yt=e;},t.setRTLTextPlugin=function(t,e,r=!1){if(Yi===Zi||Yi===Xi||Yi===Ki)throw new Error("setRTLTextPlugin cannot be called multiple times.");Ji=$.resolveURL(t),Yi=Zi,Hi=e,Qi(),r||rs();},t.spec=Rt,t.storeAuthState=function(t,e){e?ct.add(t):ct.delete(t);},t.sub=vo,t.subtract=fo,t.symbolSize=mu,t.transformMat3=function(t,e,r){var n=e[0],i=e[1],s=e[2];return t[0]=n*r[0]+i*r[3]+s*r[6],t[1]=n*r[1]+i*r[4]+s*r[7],t[2]=n*r[2]+i*r[5]+s*r[8],t},t.transformMat4=wo,t.transformQuat=go,t.translate=function(t,e,r){var n,i,s,a,o,l,u,c,h,p,d,f,y=r[0],m=r[1],g=r[2];return e===t?(t[12]=e[0]*y+e[4]*m+e[8]*g+e[12],t[13]=e[1]*y+e[5]*m+e[9]*g+e[13],t[14]=e[2]*y+e[6]*m+e[10]*g+e[14],t[15]=e[3]*y+e[7]*m+e[11]*g+e[15]):(i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],d=e[10],f=e[11],t[0]=n=e[0],t[1]=i,t[2]=s,t[3]=a,t[4]=o,t[5]=l,t[6]=u,t[7]=c,t[8]=h,t[9]=p,t[10]=d,t[11]=f,t[12]=n*y+o*m+h*g+e[12],t[13]=i*y+l*m+p*g+e[13],t[14]=s*y+u*m+d*g+e[14],t[15]=a*y+c*m+f*g+e[15]),t},t.triggerPluginCompletionEvent=Wi,t.uniqueId=b,t.validateCustomStyleLayer=function(t){const e=[],r=t.id;return void 0===r&&e.push({message:`layers.${r}: missing required property "id"`}),void 0===t.render&&e.push({message:`layers.${r}: missing required method "render"`}),t.renderingMode&&"2d"!==t.renderingMode&&"3d"!==t.renderingMode&&e.push({message:`layers.${r}: property "renderingMode" must be either "2d" or "3d"`}),e},t.validateLight=Yn,t.validateStyle=Hn,t.values=g,t.vectorTile=Fl,t.version=e,t.warnOnce=M,t.window=a,t.wrap=y;}));

define(["./shared"],(function(e){"use strict";function t(e){const r=typeof e;if("number"===r||"boolean"===r||"string"===r||null==e)return JSON.stringify(e);if(Array.isArray(e)){let r="[";for(const o of e)r+=`${t(o)},`;return `${r}]`}const o=Object.keys(e).sort();let n="{";for(let r=0;r<o.length;r++)n+=`${JSON.stringify(o[r])}:${t(e[o[r]])},`;return `${n}}`}function r(r){let o="";for(const n of e.refProperties)o+=`/${t(r[n])}`;return o}class o{constructor(e){this.keyCache={},e&&this.replace(e);}replace(e){this._layerConfigs={},this._layers={},this.update(e,[]);}update(t,o){for(const r of t){this._layerConfigs[r.id]=r;const t=this._layers[r.id]=e.createStyleLayer(r);t._featureFilter=e.createFilter(t.filter),this.keyCache[r.id]&&delete this.keyCache[r.id];}for(const e of o)delete this.keyCache[e],delete this._layerConfigs[e],delete this._layers[e];this.familiesBySource={};const n=function(e,t){const o={};for(let n=0;n<e.length;n++){const i=t&&t[e[n].id]||r(e[n]);t&&(t[e[n].id]=i);let s=o[i];s||(s=o[i]=[]),s.push(e[n]);}const n=[];for(const e in o)n.push(o[e]);return n}(e.values(this._layerConfigs),this.keyCache);for(const e of n){const t=e.map((e=>this._layers[e.id])),r=t[0];if("none"===r.visibility)continue;const o=r.source||"";let n=this.familiesBySource[o];n||(n=this.familiesBySource[o]={});const i=r.sourceLayer||"_geojsonTileLayer";let s=n[i];s||(s=n[i]=[]),s.push(t);}}}const{ImageBitmap:n}=e.window;class i{loadTile(t,r){const{uid:o,encoding:i,rawImageData:s,padding:a,buildQuadTree:l}=t,u=n&&s instanceof n?this.getImageData(s,a):s;r(null,new e.DEMData(o,u,i,a<1,l));}getImageData(t,r){this.offscreenCanvas&&this.offscreenCanvasContext||(this.offscreenCanvas=new OffscreenCanvas(t.width,t.height),this.offscreenCanvasContext=this.offscreenCanvas.getContext("2d")),this.offscreenCanvas.width=t.width,this.offscreenCanvas.height=t.height,this.offscreenCanvasContext.drawImage(t,0,0,t.width,t.height);const o=this.offscreenCanvasContext.getImageData(-r,-r,t.width+2*r,t.height+2*r);return this.offscreenCanvasContext.clearRect(0,0,this.offscreenCanvas.width,this.offscreenCanvas.height),new e.RGBAImage({width:o.width,height:o.height},o.data)}}var s=function e(t,r){var o,n=t&&t.type;if("FeatureCollection"===n)for(o=0;o<t.features.length;o++)e(t.features[o],r);else if("GeometryCollection"===n)for(o=0;o<t.geometries.length;o++)e(t.geometries[o],r);else if("Feature"===n)e(t.geometry,r);else if("Polygon"===n)a(t.coordinates,r);else if("MultiPolygon"===n)for(o=0;o<t.coordinates.length;o++)a(t.coordinates[o],r);return t};function a(e,t){if(0!==e.length){l(e[0],t);for(var r=1;r<e.length;r++)l(e[r],!t);}}function l(e,t){for(var r=0,o=0,n=e.length,i=n-1;o<n;i=o++)r+=(e[o][0]-e[i][0])*(e[i][1]+e[o][1]);r>=0!=!!t&&e.reverse();}const u=e.vectorTile.VectorTileFeature.prototype.toGeoJSON;class h{constructor(t){this._feature=t,this.extent=e.EXTENT,this.type=t.type,this.properties=t.tags,"id"in t&&!isNaN(t.id)&&(this.id=parseInt(t.id,10));}loadGeometry(){if(1===this._feature.type){const t=[];for(const r of this._feature.geometry)t.push([new e.pointGeometry(r[0],r[1])]);return t}{const t=[];for(const r of this._feature.geometry){const o=[];for(const t of r)o.push(new e.pointGeometry(t[0],t[1]));t.push(o);}return t}}toGeoJSON(e,t,r){return u.call(this,e,t,r)}}class c{constructor(t){this.layers={_geojsonTileLayer:this},this.name="_geojsonTileLayer",this.extent=e.EXTENT,this.length=t.length,this._features=t;}feature(e){return new h(this._features[e])}}var f=e.vectorTile.VectorTileFeature,p=g;function g(e,t){this.options=t||{},this.features=e,this.length=e.length;}function d(e,t){this.id="number"==typeof e.id?e.id:void 0,this.type=e.type,this.rawGeometry=1===e.type?[e.geometry]:e.geometry,this.properties=e.tags,this.extent=t||4096;}g.prototype.feature=function(e){return new d(this.features[e],this.options.extent)},d.prototype.loadGeometry=function(){var t=this.rawGeometry;this.geometry=[];for(var r=0;r<t.length;r++){for(var o=t[r],n=[],i=0;i<o.length;i++)n.push(new e.pointGeometry(o[i][0],o[i][1]));this.geometry.push(n);}return this.geometry},d.prototype.bbox=function(){this.geometry||this.loadGeometry();for(var e=this.geometry,t=1/0,r=-1/0,o=1/0,n=-1/0,i=0;i<e.length;i++)for(var s=e[i],a=0;a<s.length;a++){var l=s[a];t=Math.min(t,l.x),r=Math.max(r,l.x),o=Math.min(o,l.y),n=Math.max(n,l.y);}return [t,o,r,n]},d.prototype.toGeoJSON=f.prototype.toGeoJSON;var m=v,y=p;function v(t){var r=new e.pbf;return function(e,t){for(var r in e.layers)t.writeMessage(3,x,e.layers[r]);}(t,r),r.finish()}function x(e,t){var r;t.writeVarintField(15,e.version||1),t.writeStringField(1,e.name||""),t.writeVarintField(5,e.extent||4096);var o={keys:[],values:[],keycache:{},valuecache:{}};for(r=0;r<e.length;r++)o.feature=e.feature(r),t.writeMessage(2,w,o);var n=o.keys;for(r=0;r<n.length;r++)t.writeStringField(3,n[r]);var i=o.values;for(r=0;r<i.length;r++)t.writeMessage(4,T,i[r]);}function w(e,t){var r=e.feature;void 0!==r.id&&t.writeVarintField(1,r.id),t.writeMessage(2,S,e),t.writeVarintField(3,r.type),t.writeMessage(4,b,r);}function S(e,t){var r=e.feature,o=e.keys,n=e.values,i=e.keycache,s=e.valuecache;for(var a in r.properties){var l=i[a];void 0===l&&(o.push(a),i[a]=l=o.length-1),t.writeVarint(l);var u=r.properties[a],h=typeof u;"string"!==h&&"boolean"!==h&&"number"!==h&&(u=JSON.stringify(u));var c=h+":"+u,f=s[c];void 0===f&&(n.push(u),s[c]=f=n.length-1),t.writeVarint(f);}}function M(e,t){return (t<<3)+(7&e)}function P(e){return e<<1^e>>31}function b(e,t){for(var r=e.loadGeometry(),o=e.type,n=0,i=0,s=r.length,a=0;a<s;a++){var l=r[a],u=1;1===o&&(u=l.length),t.writeVarint(M(1,u));for(var h=3===o?l.length-1:l.length,c=0;c<h;c++){1===c&&1!==o&&t.writeVarint(M(2,h-1));var f=l[c].x-n,p=l[c].y-i;t.writeVarint(P(f)),t.writeVarint(P(p)),n+=f,i+=p;}3===o&&t.writeVarint(M(7,1));}}function T(e,t){var r=typeof e;"string"===r?t.writeStringField(1,e):"boolean"===r?t.writeBooleanField(7,e):"number"===r&&(e%1!=0?t.writeDoubleField(3,e):e<0?t.writeSVarintField(6,e):t.writeVarintField(5,e));}function k(e,t,r,o,n,i){if(n-o<=r)return;const s=o+n>>1;I(e,t,s,o,n,i%2),k(e,t,r,o,s-1,i+1),k(e,t,r,s+1,n,i+1);}function I(e,t,r,o,n,i){for(;n>o;){if(n-o>600){const s=n-o+1,a=r-o+1,l=Math.log(s),u=.5*Math.exp(2*l/3),h=.5*Math.sqrt(l*u*(s-u)/s)*(a-s/2<0?-1:1);I(e,t,r,Math.max(o,Math.floor(r-a*u/s+h)),Math.min(n,Math.floor(r+(s-a)*u/s+h)),i);}const s=t[2*r+i];let a=o,l=n;for(_(e,t,o,r),t[2*n+i]>s&&_(e,t,o,n);a<l;){for(_(e,t,a,l),a++,l--;t[2*a+i]<s;)a++;for(;t[2*l+i]>s;)l--;}t[2*o+i]===s?_(e,t,o,l):(l++,_(e,t,l,n)),l<=r&&(o=l+1),r<=l&&(n=l-1);}}function _(e,t,r,o){L(e,r,o),L(t,2*r,2*o),L(t,2*r+1,2*o+1);}function L(e,t,r){const o=e[t];e[t]=e[r],e[r]=o;}function C(e,t,r,o){const n=e-r,i=t-o;return n*n+i*i}m.fromVectorTileJs=v,m.fromGeojsonVt=function(e,t){t=t||{};var r={};for(var o in e)r[o]=new p(e[o].features,t),r[o].name=o,r[o].version=t.version,r[o].extent=t.extent;return v({layers:r})},m.GeoJSONWrapper=y;const O=e=>e[0],z=e=>e[1];class E{constructor(e,t=O,r=z,o=64,n=Float64Array){this.nodeSize=o,this.points=e;const i=e.length<65536?Uint16Array:Uint32Array,s=this.ids=new i(e.length),a=this.coords=new n(2*e.length);for(let o=0;o<e.length;o++)s[o]=o,a[2*o]=t(e[o]),a[2*o+1]=r(e[o]);k(s,a,o,0,s.length-1,0);}range(e,t,r,o){return function(e,t,r,o,n,i,s){const a=[0,e.length-1,0],l=[];let u,h;for(;a.length;){const c=a.pop(),f=a.pop(),p=a.pop();if(f-p<=s){for(let s=p;s<=f;s++)u=t[2*s],h=t[2*s+1],u>=r&&u<=n&&h>=o&&h<=i&&l.push(e[s]);continue}const g=Math.floor((p+f)/2);u=t[2*g],h=t[2*g+1],u>=r&&u<=n&&h>=o&&h<=i&&l.push(e[g]);const d=(c+1)%2;(0===c?r<=u:o<=h)&&(a.push(p),a.push(g-1),a.push(d)),(0===c?n>=u:i>=h)&&(a.push(g+1),a.push(f),a.push(d));}return l}(this.ids,this.coords,e,t,r,o,this.nodeSize)}within(e,t,r){return function(e,t,r,o,n,i){const s=[0,e.length-1,0],a=[],l=n*n;for(;s.length;){const u=s.pop(),h=s.pop(),c=s.pop();if(h-c<=i){for(let n=c;n<=h;n++)C(t[2*n],t[2*n+1],r,o)<=l&&a.push(e[n]);continue}const f=Math.floor((c+h)/2),p=t[2*f],g=t[2*f+1];C(p,g,r,o)<=l&&a.push(e[f]);const d=(u+1)%2;(0===u?r-n<=p:o-n<=g)&&(s.push(c),s.push(f-1),s.push(d)),(0===u?r+n>=p:o+n>=g)&&(s.push(f+1),s.push(h),s.push(d));}return a}(this.ids,this.coords,e,t,r,this.nodeSize)}}const F={minZoom:0,maxZoom:16,minPoints:2,radius:40,extent:512,nodeSize:64,log:!1,generateId:!1,reduce:null,map:e=>e},N=Math.fround||(Z=new Float32Array(1),e=>(Z[0]=+e,Z[0]));var Z;class G{constructor(e){this.options=D(Object.create(F),e),this.trees=new Array(this.options.maxZoom+1);}load(e){const{log:t,minZoom:r,maxZoom:o,nodeSize:n}=this.options;t&&console.time("total time");const i=`prepare ${e.length} points`;t&&console.time(i),this.points=e;let s=[];for(let t=0;t<e.length;t++)e[t].geometry&&s.push(Y(e[t],t));this.trees[o+1]=new E(s,$,B,n,Float32Array),t&&console.timeEnd(i);for(let e=o;e>=r;e--){const r=+Date.now();s=this._cluster(s,e),this.trees[e]=new E(s,$,B,n,Float32Array),t&&console.log("z%d: %d clusters in %dms",e,s.length,+Date.now()-r);}return t&&console.timeEnd("total time"),this}getClusters(e,t){let r=((e[0]+180)%360+360)%360-180;const o=Math.max(-90,Math.min(90,e[1]));let n=180===e[2]?180:((e[2]+180)%360+360)%360-180;const i=Math.max(-90,Math.min(90,e[3]));if(e[2]-e[0]>=360)r=-180,n=180;else if(r>n){const e=this.getClusters([r,o,180,i],t),s=this.getClusters([-180,o,n,i],t);return e.concat(s)}const s=this.trees[this._limitZoom(t)],a=s.range(V(r),j(i),V(n),j(o)),l=[];for(const e of a){const t=s.points[e];l.push(t.numPoints?W(t):this.points[t.index]);}return l}getChildren(e){const t=this._getOriginId(e),r=this._getOriginZoom(e),o="No cluster with the specified id.",n=this.trees[r];if(!n)throw new Error(o);const i=n.points[t];if(!i)throw new Error(o);const s=this.options.radius/(this.options.extent*Math.pow(2,r-1)),a=n.within(i.x,i.y,s),l=[];for(const t of a){const r=n.points[t];r.parentId===e&&l.push(r.numPoints?W(r):this.points[r.index]);}if(0===l.length)throw new Error(o);return l}getLeaves(e,t,r){const o=[];return this._appendLeaves(o,e,t=t||10,r=r||0,0),o}getTile(e,t,r){const o=this.trees[this._limitZoom(e)],n=Math.pow(2,e),{extent:i,radius:s}=this.options,a=s/i,l=(r-a)/n,u=(r+1+a)/n,h={features:[]};return this._addTileFeatures(o.range((t-a)/n,l,(t+1+a)/n,u),o.points,t,r,n,h),0===t&&this._addTileFeatures(o.range(1-a/n,l,1,u),o.points,n,r,n,h),t===n-1&&this._addTileFeatures(o.range(0,l,a/n,u),o.points,-1,r,n,h),h.features.length?h:null}getClusterExpansionZoom(e){let t=this._getOriginZoom(e)-1;for(;t<=this.options.maxZoom;){const r=this.getChildren(e);if(t++,1!==r.length)break;e=r[0].properties.cluster_id;}return t}_appendLeaves(e,t,r,o,n){const i=this.getChildren(t);for(const t of i){const i=t.properties;if(i&&i.cluster?n+i.point_count<=o?n+=i.point_count:n=this._appendLeaves(e,i.cluster_id,r,o,n):n<o?n++:e.push(t),e.length===r)break}return n}_addTileFeatures(e,t,r,o,n,i){for(const s of e){const e=t[s],a=e.numPoints,l={type:1,geometry:[[Math.round(this.options.extent*(e.x*n-r)),Math.round(this.options.extent*(e.y*n-o))]],tags:a?X(e):this.points[e.index].properties};let u;a?u=e.id:this.options.generateId?u=e.index:this.points[e.index].id&&(u=this.points[e.index].id),void 0!==u&&(l.id=u),i.features.push(l);}}_limitZoom(e){return Math.max(this.options.minZoom,Math.min(+e,this.options.maxZoom+1))}_cluster(e,t){const r=[],{radius:o,extent:n,reduce:i,minPoints:s}=this.options,a=o/(n*Math.pow(2,t));for(let o=0;o<e.length;o++){const n=e[o];if(n.zoom<=t)continue;n.zoom=t;const l=this.trees[t+1],u=l.within(n.x,n.y,a),h=n.numPoints||1;let c=h;for(const e of u){const r=l.points[e];r.zoom>t&&(c+=r.numPoints||1);}if(c>=s){let e=n.x*h,s=n.y*h,a=i&&h>1?this._map(n,!0):null;const f=(o<<5)+(t+1)+this.points.length;for(const r of u){const o=l.points[r];if(o.zoom<=t)continue;o.zoom=t;const u=o.numPoints||1;e+=o.x*u,s+=o.y*u,o.parentId=f,i&&(a||(a=this._map(n,!0)),i(a,this._map(o)));}n.parentId=f,r.push(J(e/c,s/c,f,c,a));}else if(r.push(n),c>1)for(const e of u){const o=l.points[e];o.zoom<=t||(o.zoom=t,r.push(o));}}return r}_getOriginId(e){return e-this.points.length>>5}_getOriginZoom(e){return (e-this.points.length)%32}_map(e,t){if(e.numPoints)return t?D({},e.properties):e.properties;const r=this.points[e.index].properties,o=this.options.map(r);return t&&o===r?D({},o):o}}function J(e,t,r,o,n){return {x:N(e),y:N(t),zoom:1/0,id:r,parentId:-1,numPoints:o,properties:n}}function Y(e,t){const[r,o]=e.geometry.coordinates;return {x:N(V(r)),y:N(j(o)),zoom:1/0,index:t,parentId:-1}}function W(e){return {type:"Feature",id:e.id,properties:X(e),geometry:{type:"Point",coordinates:[(t=e.x,360*(t-.5)),A(e.y)]}};var t;}function X(e){const t=e.numPoints,r=t>=1e4?`${Math.round(t/1e3)}k`:t>=1e3?Math.round(t/100)/10+"k":t;return D(D({},e.properties),{cluster:!0,cluster_id:e.id,point_count:t,point_count_abbreviated:r})}function V(e){return e/360+.5}function j(e){const t=Math.sin(e*Math.PI/180),r=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return r<0?0:r>1?1:r}function A(e){const t=(180-360*e)*Math.PI/180;return 360*Math.atan(Math.exp(t))/Math.PI-90}function D(e,t){for(const r in t)e[r]=t[r];return e}function $(e){return e.x}function B(e){return e.y}function R(e,t,r,o){for(var n,i=o,s=r-t>>1,a=r-t,l=e[t],u=e[t+1],h=e[r],c=e[r+1],f=t+3;f<r;f+=3){var p=q(e[f],e[f+1],l,u,h,c);if(p>i)n=f,i=p;else if(p===i){var g=Math.abs(f-s);g<a&&(n=f,a=g);}}i>o&&(n-t>3&&R(e,t,n,o),e[n+2]=i,r-n>3&&R(e,n,r,o));}function q(e,t,r,o,n,i){var s=n-r,a=i-o;if(0!==s||0!==a){var l=((e-r)*s+(t-o)*a)/(s*s+a*a);l>1?(r=n,o=i):l>0&&(r+=s*l,o+=a*l);}return (s=e-r)*s+(a=t-o)*a}function U(e,t,r,o){var n={id:void 0===e?null:e,type:t,geometry:r,tags:o,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0};return function(e){var t=e.geometry,r=e.type;if("Point"===r||"MultiPoint"===r||"LineString"===r)Q(e,t);else if("Polygon"===r||"MultiLineString"===r)for(var o=0;o<t.length;o++)Q(e,t[o]);else if("MultiPolygon"===r)for(o=0;o<t.length;o++)for(var n=0;n<t[o].length;n++)Q(e,t[o][n]);}(n),n}function Q(e,t){for(var r=0;r<t.length;r+=3)e.minX=Math.min(e.minX,t[r]),e.minY=Math.min(e.minY,t[r+1]),e.maxX=Math.max(e.maxX,t[r]),e.maxY=Math.max(e.maxY,t[r+1]);}function H(e,t,r,o){if(t.geometry){var n=t.geometry.coordinates,i=t.geometry.type,s=Math.pow(r.tolerance/((1<<r.maxZoom)*r.extent),2),a=[],l=t.id;if(r.promoteId?l=t.properties[r.promoteId]:r.generateId&&(l=o||0),"Point"===i)K(n,a);else if("MultiPoint"===i)for(var u=0;u<n.length;u++)K(n[u],a);else if("LineString"===i)ee(n,a,s,!1);else if("MultiLineString"===i){if(r.lineMetrics){for(u=0;u<n.length;u++)ee(n[u],a=[],s,!1),e.push(U(l,"LineString",a,t.properties));return}te(n,a,s,!1);}else if("Polygon"===i)te(n,a,s,!0);else {if("MultiPolygon"!==i){if("GeometryCollection"===i){for(u=0;u<t.geometry.geometries.length;u++)H(e,{id:l,geometry:t.geometry.geometries[u],properties:t.properties},r,o);return}throw new Error("Input data is not a valid GeoJSON object.")}for(u=0;u<n.length;u++){var h=[];te(n[u],h,s,!0),a.push(h);}}e.push(U(l,i,a,t.properties));}}function K(e,t){t.push(re(e[0])),t.push(oe(e[1])),t.push(0);}function ee(e,t,r,o){for(var n,i,s=0,a=0;a<e.length;a++){var l=re(e[a][0]),u=oe(e[a][1]);t.push(l),t.push(u),t.push(0),a>0&&(s+=o?(n*u-l*i)/2:Math.sqrt(Math.pow(l-n,2)+Math.pow(u-i,2))),n=l,i=u;}var h=t.length-3;t[2]=1,R(t,0,h,r),t[h+2]=1,t.size=Math.abs(s),t.start=0,t.end=t.size;}function te(e,t,r,o){for(var n=0;n<e.length;n++){var i=[];ee(e[n],i,r,o),t.push(i);}}function re(e){return e/360+.5}function oe(e){var t=Math.sin(e*Math.PI/180),r=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return r<0?0:r>1?1:r}function ne(e,t,r,o,n,i,s,a){if(o/=t,i>=(r/=t)&&s<o)return e;if(s<r||i>=o)return null;for(var l=[],u=0;u<e.length;u++){var h=e[u],c=h.geometry,f=h.type,p=0===n?h.minX:h.minY,g=0===n?h.maxX:h.maxY;if(p>=r&&g<o)l.push(h);else if(!(g<r||p>=o)){var d=[];if("Point"===f||"MultiPoint"===f)ie(c,d,r,o,n);else if("LineString"===f)se(c,d,r,o,n,!1,a.lineMetrics);else if("MultiLineString"===f)le(c,d,r,o,n,!1);else if("Polygon"===f)le(c,d,r,o,n,!0);else if("MultiPolygon"===f)for(var m=0;m<c.length;m++){var y=[];le(c[m],y,r,o,n,!0),y.length&&d.push(y);}if(d.length){if(a.lineMetrics&&"LineString"===f){for(m=0;m<d.length;m++)l.push(U(h.id,f,d[m],h.tags));continue}"LineString"!==f&&"MultiLineString"!==f||(1===d.length?(f="LineString",d=d[0]):f="MultiLineString"),"Point"!==f&&"MultiPoint"!==f||(f=3===d.length?"Point":"MultiPoint"),l.push(U(h.id,f,d,h.tags));}}}return l.length?l:null}function ie(e,t,r,o,n){for(var i=0;i<e.length;i+=3){var s=e[i+n];s>=r&&s<=o&&(t.push(e[i]),t.push(e[i+1]),t.push(e[i+2]));}}function se(e,t,r,o,n,i,s){for(var a,l,u=ae(e),h=0===n?he:ce,c=e.start,f=0;f<e.length-3;f+=3){var p=e[f],g=e[f+1],d=e[f+2],m=e[f+3],y=e[f+4],v=0===n?p:g,x=0===n?m:y,w=!1;s&&(a=Math.sqrt(Math.pow(p-m,2)+Math.pow(g-y,2))),v<r?x>r&&(l=h(u,p,g,m,y,r),s&&(u.start=c+a*l)):v>o?x<o&&(l=h(u,p,g,m,y,o),s&&(u.start=c+a*l)):ue(u,p,g,d),x<r&&v>=r&&(l=h(u,p,g,m,y,r),w=!0),x>o&&v<=o&&(l=h(u,p,g,m,y,o),w=!0),!i&&w&&(s&&(u.end=c+a*l),t.push(u),u=ae(e)),s&&(c+=a);}var S=e.length-3;p=e[S],g=e[S+1],d=e[S+2],(v=0===n?p:g)>=r&&v<=o&&ue(u,p,g,d),S=u.length-3,i&&S>=3&&(u[S]!==u[0]||u[S+1]!==u[1])&&ue(u,u[0],u[1],u[2]),u.length&&t.push(u);}function ae(e){var t=[];return t.size=e.size,t.start=e.start,t.end=e.end,t}function le(e,t,r,o,n,i){for(var s=0;s<e.length;s++)se(e[s],t,r,o,n,i,!1);}function ue(e,t,r,o){e.push(t),e.push(r),e.push(o);}function he(e,t,r,o,n,i){var s=(i-t)/(o-t);return e.push(i),e.push(r+(n-r)*s),e.push(1),s}function ce(e,t,r,o,n,i){var s=(i-r)/(n-r);return e.push(t+(o-t)*s),e.push(i),e.push(1),s}function fe(e,t){for(var r=[],o=0;o<e.length;o++){var n,i=e[o],s=i.type;if("Point"===s||"MultiPoint"===s||"LineString"===s)n=pe(i.geometry,t);else if("MultiLineString"===s||"Polygon"===s){n=[];for(var a=0;a<i.geometry.length;a++)n.push(pe(i.geometry[a],t));}else if("MultiPolygon"===s)for(n=[],a=0;a<i.geometry.length;a++){for(var l=[],u=0;u<i.geometry[a].length;u++)l.push(pe(i.geometry[a][u],t));n.push(l);}r.push(U(i.id,s,n,i.tags));}return r}function pe(e,t){var r=[];r.size=e.size,void 0!==e.start&&(r.start=e.start,r.end=e.end);for(var o=0;o<e.length;o+=3)r.push(e[o]+t,e[o+1],e[o+2]);return r}function ge(e,t){if(e.transformed)return e;var r,o,n,i=1<<e.z,s=e.x,a=e.y;for(r=0;r<e.features.length;r++){var l=e.features[r],u=l.geometry,h=l.type;if(l.geometry=[],1===h)for(o=0;o<u.length;o+=2)l.geometry.push(de(u[o],u[o+1],t,i,s,a));else for(o=0;o<u.length;o++){var c=[];for(n=0;n<u[o].length;n+=2)c.push(de(u[o][n],u[o][n+1],t,i,s,a));l.geometry.push(c);}}return e.transformed=!0,e}function de(e,t,r,o,n,i){return [Math.round(r*(e*o-n)),Math.round(r*(t*o-i))]}function me(e,t,r,o,n){for(var i=t===n.maxZoom?0:n.tolerance/((1<<t)*n.extent),s={features:[],numPoints:0,numSimplified:0,numFeatures:0,source:null,x:r,y:o,z:t,transformed:!1,minX:2,minY:1,maxX:-1,maxY:0},a=0;a<e.length;a++){s.numFeatures++,ye(s,e[a],i,n);var l=e[a].minX,u=e[a].minY,h=e[a].maxX,c=e[a].maxY;l<s.minX&&(s.minX=l),u<s.minY&&(s.minY=u),h>s.maxX&&(s.maxX=h),c>s.maxY&&(s.maxY=c);}return s}function ye(e,t,r,o){var n=t.geometry,i=t.type,s=[];if("Point"===i||"MultiPoint"===i)for(var a=0;a<n.length;a+=3)s.push(n[a]),s.push(n[a+1]),e.numPoints++,e.numSimplified++;else if("LineString"===i)ve(s,n,e,r,!1,!1);else if("MultiLineString"===i||"Polygon"===i)for(a=0;a<n.length;a++)ve(s,n[a],e,r,"Polygon"===i,0===a);else if("MultiPolygon"===i)for(var l=0;l<n.length;l++){var u=n[l];for(a=0;a<u.length;a++)ve(s,u[a],e,r,!0,0===a);}if(s.length){var h=t.tags||null;if("LineString"===i&&o.lineMetrics){for(var c in h={},t.tags)h[c]=t.tags[c];h.mapbox_clip_start=n.start/n.size,h.mapbox_clip_end=n.end/n.size;}var f={geometry:s,type:"Polygon"===i||"MultiPolygon"===i?3:"LineString"===i||"MultiLineString"===i?2:1,tags:h};null!==t.id&&(f.id=t.id),e.features.push(f);}}function ve(e,t,r,o,n,i){var s=o*o;if(o>0&&t.size<(n?s:o))r.numPoints+=t.length/3;else {for(var a=[],l=0;l<t.length;l+=3)(0===o||t[l+2]>s)&&(r.numSimplified++,a.push(t[l]),a.push(t[l+1])),r.numPoints++;n&&function(e,t){for(var r=0,o=0,n=e.length,i=n-2;o<n;i=o,o+=2)r+=(e[o]-e[i])*(e[o+1]+e[i+1]);if(r>0===t)for(o=0,n=e.length;o<n/2;o+=2){var s=e[o],a=e[o+1];e[o]=e[n-2-o],e[o+1]=e[n-1-o],e[n-2-o]=s,e[n-1-o]=a;}}(a,i),e.push(a);}}function xe(e,t){var r=(t=this.options=function(e,t){for(var r in t)e[r]=t[r];return e}(Object.create(this.options),t)).debug;if(r&&console.time("preprocess data"),t.maxZoom<0||t.maxZoom>24)throw new Error("maxZoom should be in the 0-24 range");if(t.promoteId&&t.generateId)throw new Error("promoteId and generateId cannot be used together.");var o=function(e,t){var r=[];if("FeatureCollection"===e.type)for(var o=0;o<e.features.length;o++)H(r,e.features[o],t,o);else H(r,"Feature"===e.type?e:{geometry:e},t);return r}(e,t);this.tiles={},this.tileCoords=[],r&&(console.timeEnd("preprocess data"),console.log("index: maxZoom: %d, maxPoints: %d",t.indexMaxZoom,t.indexMaxPoints),console.time("generate tiles"),this.stats={},this.total=0),(o=function(e,t){var r=t.buffer/t.extent,o=e,n=ne(e,1,-1-r,r,0,-1,2,t),i=ne(e,1,1-r,2+r,0,-1,2,t);return (n||i)&&(o=ne(e,1,-r,1+r,0,-1,2,t)||[],n&&(o=fe(n,1).concat(o)),i&&(o=o.concat(fe(i,-1)))),o}(o,t)).length&&this.splitTile(o,0,0,0),r&&(o.length&&console.log("features: %d, points: %d",this.tiles[0].numFeatures,this.tiles[0].numPoints),console.timeEnd("generate tiles"),console.log("tiles generated:",this.total,JSON.stringify(this.stats)));}function we(e,t,r){return 32*((1<<e)*r+t)+e}function Se(e,t){const r=e.tileID.canonical;if(!this._geoJSONIndex)return t(null,null);const o=this._geoJSONIndex.getTile(r.z,r.x,r.y);if(!o)return t(null,null);const n=new c(o.features);let i=m(n);0===i.byteOffset&&i.byteLength===i.buffer.byteLength||(i=new Uint8Array(i)),t(null,{vectorTile:n,rawData:i.buffer});}xe.prototype.options={maxZoom:14,indexMaxZoom:5,indexMaxPoints:1e5,tolerance:3,extent:4096,buffer:64,lineMetrics:!1,promoteId:null,generateId:!1,debug:0},xe.prototype.splitTile=function(e,t,r,o,n,i,s){for(var a=[e,t,r,o],l=this.options,u=l.debug;a.length;){o=a.pop(),r=a.pop(),t=a.pop(),e=a.pop();var h=1<<t,c=we(t,r,o),f=this.tiles[c];if(!f&&(u>1&&console.time("creation"),f=this.tiles[c]=me(e,t,r,o,l),this.tileCoords.push({z:t,x:r,y:o}),u)){u>1&&(console.log("tile z%d-%d-%d (features: %d, points: %d, simplified: %d)",t,r,o,f.numFeatures,f.numPoints,f.numSimplified),console.timeEnd("creation"));var p="z"+t;this.stats[p]=(this.stats[p]||0)+1,this.total++;}if(f.source=e,n){if(t===l.maxZoom||t===n)continue;var g=1<<n-t;if(r!==Math.floor(i/g)||o!==Math.floor(s/g))continue}else if(t===l.indexMaxZoom||f.numPoints<=l.indexMaxPoints)continue;if(f.source=null,0!==e.length){u>1&&console.time("clipping");var d,m,y,v,x,w,S=.5*l.buffer/l.extent,M=.5-S,P=.5+S,b=1+S;d=m=y=v=null,x=ne(e,h,r-S,r+P,0,f.minX,f.maxX,l),w=ne(e,h,r+M,r+b,0,f.minX,f.maxX,l),e=null,x&&(d=ne(x,h,o-S,o+P,1,f.minY,f.maxY,l),m=ne(x,h,o+M,o+b,1,f.minY,f.maxY,l),x=null),w&&(y=ne(w,h,o-S,o+P,1,f.minY,f.maxY,l),v=ne(w,h,o+M,o+b,1,f.minY,f.maxY,l),w=null),u>1&&console.timeEnd("clipping"),a.push(d||[],t+1,2*r,2*o),a.push(m||[],t+1,2*r,2*o+1),a.push(y||[],t+1,2*r+1,2*o),a.push(v||[],t+1,2*r+1,2*o+1);}}},xe.prototype.getTile=function(e,t,r){var o=this.options,n=o.extent,i=o.debug;if(e<0||e>24)return null;var s=1<<e,a=we(e,t=(t%s+s)%s,r);if(this.tiles[a])return ge(this.tiles[a],n);i>1&&console.log("drilling down to z%d-%d-%d",e,t,r);for(var l,u=e,h=t,c=r;!l&&u>0;)u--,h=Math.floor(h/2),c=Math.floor(c/2),l=this.tiles[we(u,h,c)];return l&&l.source?(i>1&&console.log("found parent tile z%d-%d-%d",u,h,c),i>1&&console.time("drilling down"),this.splitTile(l.source,u,h,c,e,t,r),i>1&&console.timeEnd("drilling down"),this.tiles[a]?ge(this.tiles[a],n):null):null};class Me extends e.VectorTileWorkerSource{constructor(e,t,r,o,n){super(e,t,r,o,Se),n&&(this.loadGeoJSON=n);}loadData(t,r){const o=t&&t.request,n=o&&o.collectResourceTiming;this.loadGeoJSON(t,((i,a)=>{if(i||!a)return r(i);if("object"!=typeof a)return r(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`));{s(a,!0);try{if(t.filter){const r=e.createExpression(t.filter,{type:"boolean","property-type":"data-driven",overridable:!1,transition:!1});if("error"===r.result)throw new Error(r.value.map((e=>`${e.key}: ${e.message}`)).join(", "));const o=a.features.filter((e=>r.value.evaluate({zoom:0},e)));a={type:"FeatureCollection",features:o};}this._geoJSONIndex=t.cluster?new G(function({superclusterOptions:t,clusterProperties:r}){if(!r||!t)return t;const o={},n={},i={accumulated:null,zoom:0},s={properties:null},a=Object.keys(r);for(const t of a){const[i,s]=r[t],a=e.createExpression(s),l=e.createExpression("string"==typeof i?[i,["accumulated"],["get",t]]:i);o[t]=a.value,n[t]=l.value;}return t.map=e=>{s.properties=e;const t={};for(const e of a)t[e]=o[e].evaluate(i,s);return t},t.reduce=(e,t)=>{s.properties=t;for(const t of a)i.accumulated=e[t],e[t]=n[t].evaluate(i,s);},t}(t)).load(a.features):function(e,t){return new xe(e,t)}(a,t.geojsonVtOptions);}catch(i){return r(i)}this.loaded={};const l={};if(n){const r=e.getPerformanceMeasurement(o);r&&(l.resourceTiming={},l.resourceTiming[t.source]=JSON.parse(JSON.stringify(r)));}r(null,l);}}));}reloadTile(e,t){const r=this.loaded;return r&&r[e.uid]?super.reloadTile(e,t):this.loadTile(e,t)}loadGeoJSON(t,r){if(t.request)e.getJSON(t.request,r);else {if("string"!=typeof t.data)return r(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`));try{return r(null,JSON.parse(t.data))}catch(e){return r(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`))}}}getClusterExpansionZoom(e,t){try{t(null,this._geoJSONIndex.getClusterExpansionZoom(e.clusterId));}catch(e){t(e);}}getClusterChildren(e,t){try{t(null,this._geoJSONIndex.getChildren(e.clusterId));}catch(e){t(e);}}getClusterLeaves(e,t){try{t(null,this._geoJSONIndex.getLeaves(e.clusterId,e.limit,e.offset));}catch(e){t(e);}}}class Pe{constructor(t){this.self=t,this.actor=new e.Actor(t,this),this.layerIndexes={},this.availableImages={},this.isSpriteLoaded=!1,this.workerSourceTypes={vector:e.VectorTileWorkerSource,geojson:Me},this.workerSources={},this.demWorkerSources={},this.self.registerWorkerSource=(e,t)=>{if(this.workerSourceTypes[e])throw new Error(`Worker source with name "${e}" already registered.`);this.workerSourceTypes[e]=t;},this.self.registerRTLTextPlugin=t=>{if(e.plugin.isParsed())throw new Error("RTL text plugin already registered.");e.plugin.applyArabicShaping=t.applyArabicShaping,e.plugin.processBidirectionalText=t.processBidirectionalText,e.plugin.processStyledBidirectionalText=t.processStyledBidirectionalText;};}checkIfReady(e,t,r){r();}setReferrer(e,t){this.referrer=t;}spriteLoaded(t,r){this.isSpriteLoaded=r;for(const o in this.workerSources[t]){const n=this.workerSources[t][o];for(const t in n)n[t]instanceof e.VectorTileWorkerSource&&(n[t].isSpriteLoaded=r,n[t].fire(new e.Event("isSpriteLoaded")));}}setImages(e,t,r){this.availableImages[e]=t;for(const r in this.workerSources[e]){const o=this.workerSources[e][r];for(const e in o)o[e].availableImages=t;}r();}enableTerrain(e,t,r){this.terrain=t,r();}setLayers(e,t,r){this.getLayerIndex(e).replace(t),r();}updateLayers(e,t,r){this.getLayerIndex(e).update(t.layers,t.removedIds),r();}loadTile(t,r,o){const n=this.enableTerrain?e.extend({enableTerrain:this.terrain},r):r;this.getWorkerSource(t,r.type,r.source).loadTile(n,o);}loadDEMTile(t,r,o){const n=this.enableTerrain?e.extend({buildQuadTree:this.terrain},r):r;this.getDEMWorkerSource(t,r.source).loadTile(n,o);}reloadTile(t,r,o){const n=this.enableTerrain?e.extend({enableTerrain:this.terrain},r):r;this.getWorkerSource(t,r.type,r.source).reloadTile(n,o);}abortTile(e,t,r){this.getWorkerSource(e,t.type,t.source).abortTile(t,r);}removeTile(e,t,r){this.getWorkerSource(e,t.type,t.source).removeTile(t,r);}removeSource(e,t,r){if(!this.workerSources[e]||!this.workerSources[e][t.type]||!this.workerSources[e][t.type][t.source])return;const o=this.workerSources[e][t.type][t.source];delete this.workerSources[e][t.type][t.source],void 0!==o.removeSource?o.removeSource(t,r):r();}loadWorkerSource(e,t,r){try{this.self.importScripts(t.url),r();}catch(e){r(e.toString());}}syncRTLPluginState(t,r,o){try{e.plugin.setState(r);const t=e.plugin.getPluginURL();if(e.plugin.isLoaded()&&!e.plugin.isParsed()&&null!=t){this.self.importScripts(t);const r=e.plugin.isParsed();o(r?void 0:new Error(`RTL Text Plugin failed to import scripts from ${t}`),r);}}catch(e){o(e.toString());}}getAvailableImages(e){let t=this.availableImages[e];return t||(t=[]),t}getLayerIndex(e){let t=this.layerIndexes[e];return t||(t=this.layerIndexes[e]=new o),t}getWorkerSource(e,t,r){return this.workerSources[e]||(this.workerSources[e]={}),this.workerSources[e][t]||(this.workerSources[e][t]={}),this.workerSources[e][t][r]||(this.workerSources[e][t][r]=new this.workerSourceTypes[t]({send:(t,r,o,n,i,s)=>{this.actor.send(t,r,o,e,i,s);},scheduler:this.actor.scheduler},this.getLayerIndex(e),this.getAvailableImages(e),this.isSpriteLoaded)),this.workerSources[e][t][r]}getDEMWorkerSource(e,t){return this.demWorkerSources[e]||(this.demWorkerSources[e]={}),this.demWorkerSources[e][t]||(this.demWorkerSources[e][t]=new i),this.demWorkerSources[e][t]}enforceCacheSizeLimit(t,r){e.enforceCacheSizeLimit(r);}getWorkerPerformanceMetrics(e,t,r){r(void 0,void 0);}}return "undefined"!=typeof WorkerGlobalScope&&"undefined"!=typeof self&&self instanceof WorkerGlobalScope&&(self.worker=new Pe(self)),Pe}));

define(["./shared"],(function(t){"use strict";var e=i;function i(t){return !function(t){return "undefined"==typeof window||"undefined"==typeof document?"not a browser":Array.prototype&&Array.prototype.every&&Array.prototype.filter&&Array.prototype.forEach&&Array.prototype.indexOf&&Array.prototype.lastIndexOf&&Array.prototype.map&&Array.prototype.some&&Array.prototype.reduce&&Array.prototype.reduceRight&&Array.isArray?Function.prototype&&Function.prototype.bind?Object.keys&&Object.create&&Object.getPrototypeOf&&Object.getOwnPropertyNames&&Object.isSealed&&Object.isFrozen&&Object.isExtensible&&Object.getOwnPropertyDescriptor&&Object.defineProperty&&Object.defineProperties&&Object.seal&&Object.freeze&&Object.preventExtensions?"JSON"in window&&"parse"in JSON&&"stringify"in JSON?function(){if(!("Worker"in window&&"Blob"in window&&"URL"in window))return !1;var t,e,i=new Blob([""],{type:"text/javascript"}),o=URL.createObjectURL(i);try{e=new Worker(o),t=!0;}catch(e){t=!1;}return e&&e.terminate(),URL.revokeObjectURL(o),t}()?"Uint8ClampedArray"in window?ArrayBuffer.isView?function(){var t=document.createElement("canvas");t.width=t.height=1;var e=t.getContext("2d");if(!e)return !1;var i=e.getImageData(0,0,1,1);return i&&i.width===t.width}()?(void 0===o[e=t&&t.failIfMajorPerformanceCaveat]&&(o[e]=function(t){var e,o=function(t){var e=document.createElement("canvas"),o=Object.create(i.webGLContextAttributes);return o.failIfMajorPerformanceCaveat=t,e.getContext("webgl",o)||e.getContext("experimental-webgl",o)}(t);if(!o)return !1;try{e=o.createShader(o.VERTEX_SHADER);}catch(t){return !1}return !(!e||o.isContextLost())&&(o.shaderSource(e,"void main() {}"),o.compileShader(e),!0===o.getShaderParameter(e,o.COMPILE_STATUS))}(e)),o[e]?document.documentMode?"insufficient ECMAScript 6 support":void 0:"insufficient WebGL support"):"insufficient Canvas/getImageData support":"insufficient ArrayBuffer support":"insufficient Uint8ClampedArray support":"insufficient worker support":"insufficient JSON support":"insufficient Object support":"insufficient Function support":"insufficent Array support";var e;}(t)}var o={};function r(t,e){if(Array.isArray(t)){if(!Array.isArray(e)||t.length!==e.length)return !1;for(let i=0;i<t.length;i++)if(!r(t[i],e[i]))return !1;return !0}if("object"==typeof t&&null!==t&&null!==e){if("object"!=typeof e)return !1;if(Object.keys(t).length!==Object.keys(e).length)return !1;for(const i in t)if(!r(t[i],e[i]))return !1;return !0}return t===e}i.webGLContextAttributes={antialias:!1,alpha:!0,stencil:!0,depth:!0};const a={create:function(e,i,o){const r=t.window.document.createElement(e);return void 0!==i&&(r.className=i),o&&o.appendChild(r),r},createNS:function(e,i){return t.window.document.createElementNS(e,i)}},n=t.window.document&&t.window.document.documentElement.style,s=n&&void 0!==n.userSelect?"userSelect":"WebkitUserSelect";let l;a.disableDrag=function(){n&&s&&(l=n[s],n[s]="none");},a.enableDrag=function(){n&&s&&(n[s]=l);},a.setTransform=function(t,e){t.style.transform=e;};let c=!1;try{const e=Object.defineProperty({},"passive",{get(){c=!0;}});t.window.addEventListener("test",e,e),t.window.removeEventListener("test",e,e);}catch(t){c=!1;}a.addEventListener=function(t,e,i,o={}){t.addEventListener(e,i,"passive"in o&&c?o:o.capture);},a.removeEventListener=function(t,e,i,o={}){t.removeEventListener(e,i,"passive"in o&&c?o:o.capture);};const h=function(e){e.preventDefault(),e.stopPropagation(),t.window.removeEventListener("click",h,!0);};function u(e,i,o){const r=e.offsetWidth===i.width?1:e.offsetWidth/i.width;return new t.pointGeometry((o.clientX-i.left)*r,(o.clientY-i.top)*r)}a.suppressClick=function(){t.window.addEventListener("click",h,!0),t.window.setTimeout((()=>{t.window.removeEventListener("click",h,!0);}),0);},a.mousePos=function(t,e){const i=t.getBoundingClientRect();return u(t,i,e)},a.touchPos=function(t,e){const i=t.getBoundingClientRect(),o=[];for(let r=0;r<e.length;r++)o.push(u(t,i,e[r]));return o},a.mouseButton=function(e){return void 0!==t.window.InstallTrigger&&2===e.button&&e.ctrlKey&&t.window.navigator.platform.toUpperCase().indexOf("MAC")>=0?0:e.button},a.remove=function(t){t.parentNode&&t.parentNode.removeChild(t);};class d{constructor(t,e){this.pos=t,this.dir=e;}intersectsPlane(e,i,o){const r=t.dot(i,this.dir);if(Math.abs(r)<1e-6)return !1;const a=t.dot(t.sub(t.create(),e,this.pos),i)/r,n=t.scaleAndAdd(t.create(),this.pos,this.dir,a);return t.copy(o,n),!0}}class _{constructor(t,e){this.points=t,this.planes=e;}static fromInvProjectionMatrix(e,i,o){const r=Math.pow(2,o),a=[[-1,1,-1,1],[1,1,-1,1],[1,-1,-1,1],[-1,-1,-1,1],[-1,1,1,1],[1,1,1,1],[1,-1,1,1],[-1,-1,1,1]].map((o=>{const a=t.transformMat4([],o,e),n=1/a[3]/i*r;return t.mul(a,a,[n,n,1/a[3],n])})),n=[[0,1,2],[6,5,4],[0,3,7],[2,1,5],[3,2,6],[0,4,5]].map((e=>{const i=t.sub([],a[e[0]],a[e[1]]),o=t.sub([],a[e[2]],a[e[1]]),r=t.normalize([],t.cross([],i,o)),n=-t.dot(r,a[e[1]]);return r.concat(n)}));return new _(a,n)}}class m{constructor(e,i){this.min=e,this.max=i,this.center=t.scale([],t.add([],this.min,this.max),.5);}quadrant(e){const i=[e%2==0,e<2],o=t.clone(this.min),r=t.clone(this.max);for(let t=0;t<i.length;t++)o[t]=i[t]?this.min[t]:this.center[t],r[t]=i[t]?this.center[t]:this.max[t];return r[2]=this.max[2],new m(o,r)}distanceX(t){return Math.max(Math.min(this.max[0],t[0]),this.min[0])-t[0]}distanceY(t){return Math.max(Math.min(this.max[1],t[1]),this.min[1])-t[1]}distanceZ(t){return Math.max(Math.min(this.max[2],t[2]),this.min[2])-t[2]}intersects(e){const i=[[this.min[0],this.min[1],this.min[2],1],[this.max[0],this.min[1],this.min[2],1],[this.max[0],this.max[1],this.min[2],1],[this.min[0],this.max[1],this.min[2],1],[this.min[0],this.min[1],this.max[2],1],[this.max[0],this.min[1],this.max[2],1],[this.max[0],this.max[1],this.max[2],1],[this.min[0],this.max[1],this.max[2],1]];let o=!0;for(let r=0;r<e.planes.length;r++){const a=e.planes[r];let n=0;for(let e=0;e<i.length;e++)n+=t.dot$1(a,i[e])>=0;if(0===n)return 0;n!==i.length&&(o=!1);}if(o)return 2;for(let t=0;t<3;t++){let i=Number.MAX_VALUE,o=-Number.MAX_VALUE;for(let r=0;r<e.points.length;r++){const a=e.points[r][t]-this.min[t];i=Math.min(i,a),o=Math.max(o,a);}if(o<0||i>this.max[t]-this.min[t])return 0}return 1}}function p(t){const{userImage:e}=t;return !!(e&&e.render&&e.render())&&(t.data.replace(new Uint8Array(e.data.buffer)),!0)}class f extends t.Evented{constructor(){super(),this.images={},this.updatedImages={},this.callbackDispatchedThisFrame={},this.loaded=!1,this.requestors=[],this.patterns={},this.atlasImage=new t.RGBAImage({width:1,height:1}),this.dirty=!0;}isLoaded(){return this.loaded}setLoaded(t){if(this.loaded!==t&&(this.loaded=t,t)){for(const{ids:t,callback:e}of this.requestors)this._notify(t,e);this.requestors=[];}}getImage(t){return this.images[t]}addImage(t,e){this._validate(t,e)&&(this.images[t]=e);}_validate(e,i){let o=!0;return this._validateStretch(i.stretchX,i.data&&i.data.width)||(this.fire(new t.ErrorEvent(new Error(`Image "${e}" has invalid "stretchX" value`))),o=!1),this._validateStretch(i.stretchY,i.data&&i.data.height)||(this.fire(new t.ErrorEvent(new Error(`Image "${e}" has invalid "stretchY" value`))),o=!1),this._validateContent(i.content,i)||(this.fire(new t.ErrorEvent(new Error(`Image "${e}" has invalid "content" value`))),o=!1),o}_validateStretch(t,e){if(!t)return !0;let i=0;for(const o of t){if(o[0]<i||o[1]<o[0]||e<o[1])return !1;i=o[1];}return !0}_validateContent(t,e){return !(t&&(4!==t.length||t[0]<0||e.data.width<t[0]||t[1]<0||e.data.height<t[1]||t[2]<0||e.data.width<t[2]||t[3]<0||e.data.height<t[3]||t[2]<t[0]||t[3]<t[1]))}updateImage(t,e){e.version=this.images[t].version+1,this.images[t]=e,this.updatedImages[t]=!0;}removeImage(t){const e=this.images[t];delete this.images[t],delete this.patterns[t],e.userImage&&e.userImage.onRemove&&e.userImage.onRemove();}listImages(){return Object.keys(this.images)}getImages(t,e){let i=!0;if(!this.isLoaded())for(const e of t)this.images[e]||(i=!1);this.isLoaded()||i?this._notify(t,e):this.requestors.push({ids:t,callback:e});}_notify(e,i){const o={};for(const i of e){this.images[i]||this.fire(new t.Event("styleimagemissing",{id:i}));const e=this.images[i];e?o[i]={data:e.data.clone(),pixelRatio:e.pixelRatio,sdf:e.sdf,version:e.version,stretchX:e.stretchX,stretchY:e.stretchY,content:e.content,hasRenderCallback:Boolean(e.userImage&&e.userImage.render)}:t.warnOnce(`Image "${i}" could not be loaded. Please make sure you have added the image with map.addImage() or a "sprite" property in your style. You can provide missing images by listening for the "styleimagemissing" map event.`);}i(null,o);}getPixelSize(){const{width:t,height:e}=this.atlasImage;return {width:t,height:e}}getPattern(e){const i=this.patterns[e],o=this.getImage(e);if(!o)return null;if(i&&i.position.version===o.version)return i.position;if(i)i.position.version=o.version;else {const i={w:o.data.width+2,h:o.data.height+2,x:0,y:0},r=new t.ImagePosition(i,o);this.patterns[e]={bin:i,position:r};}return this._updatePatternAtlas(),this.patterns[e].position}bind(e){const i=e.gl;this.atlasTexture?this.dirty&&(this.atlasTexture.update(this.atlasImage),this.dirty=!1):this.atlasTexture=new t.Texture(e,this.atlasImage,i.RGBA),this.atlasTexture.bind(i.LINEAR,i.CLAMP_TO_EDGE);}_updatePatternAtlas(){const e=[];for(const t in this.patterns)e.push(this.patterns[t].bin);const{w:i,h:o}=t.potpack(e),r=this.atlasImage;r.resize({width:i||1,height:o||1});for(const e in this.patterns){const{bin:i}=this.patterns[e],o=i.x+1,a=i.y+1,n=this.images[e].data,s=n.width,l=n.height;t.RGBAImage.copy(n,r,{x:0,y:0},{x:o,y:a},{width:s,height:l}),t.RGBAImage.copy(n,r,{x:0,y:l-1},{x:o,y:a-1},{width:s,height:1}),t.RGBAImage.copy(n,r,{x:0,y:0},{x:o,y:a+l},{width:s,height:1}),t.RGBAImage.copy(n,r,{x:s-1,y:0},{x:o-1,y:a},{width:1,height:l}),t.RGBAImage.copy(n,r,{x:0,y:0},{x:o+s,y:a},{width:1,height:l});}this.dirty=!0;}beginFrame(){this.callbackDispatchedThisFrame={};}dispatchRenderCallbacks(t){for(const e of t){if(this.callbackDispatchedThisFrame[e])continue;this.callbackDispatchedThisFrame[e]=!0;const t=this.images[e];p(t)&&this.updateImage(e,t);}}}const g=new t.Properties({anchor:new t.DataConstantProperty(t.spec.light.anchor),position:new class{constructor(){this.specification=t.spec.light.position;}possiblyEvaluate(e,i){return function([e,i,o]){const r=t.degToRad(i+90),a=t.degToRad(o);return {x:e*Math.cos(r)*Math.sin(a),y:e*Math.sin(r)*Math.sin(a),z:e*Math.cos(a),azimuthal:i,polar:o}}(e.expression.evaluate(i))}interpolate(e,i,o){return {x:t.number(e.x,i.x,o),y:t.number(e.y,i.y,o),z:t.number(e.z,i.z,o),azimuthal:t.number(e.azimuthal,i.azimuthal,o),polar:t.number(e.polar,i.polar,o)}}},color:new t.DataConstantProperty(t.spec.light.color),intensity:new t.DataConstantProperty(t.spec.light.intensity)}),x="-transition";class v extends t.Evented{constructor(e){super(),this._transitionable=new t.Transitionable(g),this.setLight(e),this._transitioning=this._transitionable.untransitioned();}getLight(){return this._transitionable.serialize()}setLight(e,i={}){if(!this._validate(t.validateLight,e,i))for(const i in e){const o=e[i];t.endsWith(i,x)?this._transitionable.setTransition(i.slice(0,-x.length),o):this._transitionable.setValue(i,o);}}updateTransitions(t){this._transitioning=this._transitionable.transitioned(t,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(t){this.properties=this._transitioning.possiblyEvaluate(t);}_validate(e,i,o){return (!o||!1!==o.validate)&&t.emitValidationErrors(this,e.call(t.validateStyle,t.extend({value:i,style:{glyphs:!0,sprite:!0},styleSpec:t.spec})))}}const y=new t.Properties({source:new t.DataConstantProperty(t.spec.terrain.source),exaggeration:new t.DataConstantProperty(t.spec.terrain.exaggeration)}),b="-transition";class w extends t.Evented{constructor(e){super(),this._transitionable=new t.Transitionable(y),this.set(e),this._transitioning=this._transitionable.untransitioned();}get(){return this._transitionable.serialize()}set(e){for(const i in e){const o=e[i];t.endsWith(i,b)?this._transitionable.setTransition(i.slice(0,-b.length),o):this._transitionable.setValue(i,o);}}updateTransitions(t){this._transitioning=this._transitionable.transitioned(t,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(t){this.properties=this._transitioning.possiblyEvaluate(t);}}class T{constructor(t,e){this.width=t,this.height=e,this.nextRow=0,this.data=new Uint8Array(this.width*this.height),this.dashEntry={};}getDash(t,e){const i=t.join(",")+String(e);return this.dashEntry[i]||(this.dashEntry[i]=this.addDash(t,e)),this.dashEntry[i]}getDashRanges(t,e,i){const o=[];let r=t.length%2==1?-t[t.length-1]*i:0,a=t[0]*i,n=!0;o.push({left:r,right:a,isDash:n,zeroLength:0===t[0]});let s=t[0];for(let e=1;e<t.length;e++){n=!n;const l=t[e];r=s*i,s+=l,a=s*i,o.push({left:r,right:a,isDash:n,zeroLength:0===l});}return o}addRoundDash(t,e,i){const o=e/2;for(let e=-i;e<=i;e++){const r=this.width*(this.nextRow+i+e);let a=0,n=t[a];for(let s=0;s<this.width;s++){s/n.right>1&&(n=t[++a]);const l=Math.abs(s-n.left),c=Math.abs(s-n.right),h=Math.min(l,c);let u;const d=e/i*(o+1);if(n.isDash){const t=o-Math.abs(d);u=Math.sqrt(h*h+t*t);}else u=o-Math.sqrt(h*h+d*d);this.data[r+s]=Math.max(0,Math.min(255,u+128));}}}addRegularDash(t){for(let e=t.length-1;e>=0;--e){const i=t[e],o=t[e+1];i.zeroLength?t.splice(e,1):o&&o.isDash===i.isDash&&(o.left=i.left,t.splice(e,1));}const e=t[0],i=t[t.length-1];e.isDash===i.isDash&&(e.left=i.left-this.width,i.right=e.right+this.width);const o=this.width*this.nextRow;let r=0,a=t[r];for(let e=0;e<this.width;e++){e/a.right>1&&(a=t[++r]);const i=Math.abs(e-a.left),n=Math.abs(e-a.right),s=Math.min(i,n);this.data[o+e]=Math.max(0,Math.min(255,(a.isDash?s:-s)+128));}}addDash(e,i){const o=i?7:0,r=2*o+1;if(this.nextRow+r>this.height)return t.warnOnce("LineAtlas out of space"),null;0===e.length&&e.push(1);let a=0;for(let i=0;i<e.length;i++)e[i]<0&&(t.warnOnce("Negative value is found in line dasharray, replacing values with 0"),e[i]=0),a+=e[i];if(0!==a){const t=this.width/a,r=this.getDashRanges(e,this.width,t);i?this.addRoundDash(r,t,o):this.addRegularDash(r);}const n={y:(this.nextRow+o+.5)/this.height,height:2*o/this.height,width:a};return this.nextRow+=r,this.dirty=!0,n}bind(t){const e=t.gl;this.texture?(e.bindTexture(e.TEXTURE_2D,this.texture),this.dirty&&(this.dirty=!1,e.texSubImage2D(e.TEXTURE_2D,0,0,0,this.width,this.height,e.ALPHA,e.UNSIGNED_BYTE,this.data))):(this.texture=e.createTexture(),e.bindTexture(e.TEXTURE_2D,this.texture),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.REPEAT),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.REPEAT),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,e.LINEAR),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,e.LINEAR),e.texImage2D(e.TEXTURE_2D,0,e.ALPHA,this.width,this.height,0,e.ALPHA,e.UNSIGNED_BYTE,this.data));}}class E{constructor(e,i){this.workerPool=e,this.actors=[],this.currentActor=0,this.id=t.uniqueId();const o=this.workerPool.acquire(this.id);for(let t=0;t<o.length;t++){const e=new E.Actor(o[t],i,this.id);e.name=`Worker ${t}`,this.actors.push(e);}this.ready=!1,this.broadcast("checkIfReady",null,(()=>{this.ready=!0;}));}broadcast(e,i,o){t.asyncAll(this.actors,((t,o)=>{t.send(e,i,o);}),o=o||function(){});}getActor(){return this.currentActor=(this.currentActor+1)%this.actors.length,this.actors[this.currentActor]}remove(){this.actors.forEach((t=>{t.remove();})),this.actors=[],this.workerPool.release(this.id);}}function C(e,i,o){return i*(t.EXTENT/(e.tileSize*Math.pow(2,o-e.tileID.overscaledZ)))}E.Actor=t.Actor;class S{constructor(t,e,i,o){this.screenBounds=t,this.cameraPoint=e,this._screenRaycastCache={},this._cameraRaycastCache={},this.isAboveHorizon=i,this.screenGeometry=this.bufferedScreenGeometry(0),this.screenGeometryMercator=this.screenGeometry.map((t=>o.pointCoordinate3D(t))),this.cameraGeometry=this.bufferedCameraGeometry(0);}static createFromScreenPoints(e,i){let o,r;if(e instanceof t.pointGeometry||"number"==typeof e[0]){const a=t.pointGeometry.convert(e);o=[t.pointGeometry.convert(e)],r=i.isPointAboveHorizon(a);}else {const a=t.pointGeometry.convert(e[0]),n=t.pointGeometry.convert(e[1]);o=[a,n],r=t.polygonizeBounds(a,n).every((t=>i.isPointAboveHorizon(t)));}return new S(o,i.getCameraPoint(),r,i)}isPointQuery(){return 1===this.screenBounds.length}bufferedScreenGeometry(e){return t.polygonizeBounds(this.screenBounds[0],1===this.screenBounds.length?this.screenBounds[0]:this.screenBounds[1],e)}bufferedCameraGeometry(e){const i=this.screenBounds[0],o=1===this.screenBounds.length?this.screenBounds[0].add(new t.pointGeometry(1,1)):this.screenBounds[1],r=t.polygonizeBounds(i,o,0,!1);return this.cameraPoint.y>o.y&&(this.cameraPoint.x>i.x&&this.cameraPoint.x<o.x?r.splice(3,0,this.cameraPoint):this.cameraPoint.x>=o.x?r[2]=this.cameraPoint:this.cameraPoint.x<=i.x&&(r[3]=this.cameraPoint)),t.bufferConvexPolygon(r,e)}containsTile(e,i,o){const r=e.queryPadding+1,a=o?this._bufferedCameraMercator(r,i).map((t=>e.tileID.getTilePoint(t))):this._bufferedScreenMercator(r,i).map((t=>e.tileID.getTilePoint(t))),n=this.screenGeometryMercator.map((t=>e.tileID.getTileVec3(t))),s=n.map((e=>new t.pointGeometry(e[0],e[1]))),l=i.getFreeCameraOptions().position||new t.MercatorCoordinate(0,0,0),c=e.tileID.getTileVec3(l),h=n.map((e=>{const i=t.sub(e,e,c);return t.normalize(i,i),new d(c,i)})),u=C(e,1,i.zoom);if(t.polygonIntersectsBox(a,0,0,t.EXTENT,t.EXTENT))return {queryGeometry:this,tilespaceGeometry:s,tilespaceRays:h,bufferedTilespaceGeometry:a,bufferedTilespaceBounds:(_=t.getBounds(a),_.min.x=t.clamp(_.min.x,0,t.EXTENT),_.min.y=t.clamp(_.min.y,0,t.EXTENT),_.max.x=t.clamp(_.max.x,0,t.EXTENT),_.max.y=t.clamp(_.max.y,0,t.EXTENT),_),tile:e,tileID:e.tileID,pixelToTileUnitsFactor:u};var _;}_bufferedScreenMercator(t,e){const i=I(t);if(this._screenRaycastCache[i])return this._screenRaycastCache[i];{const o=this.bufferedScreenGeometry(t).map((t=>e.pointCoordinate3D(t)));return this._screenRaycastCache[i]=o,o}}_bufferedCameraMercator(t,e){const i=I(t);if(this._cameraRaycastCache[i])return this._cameraRaycastCache[i];{const o=this.bufferedCameraGeometry(t).map((t=>e.pointCoordinate3D(t)));return this._cameraRaycastCache[i]=o,o}}}function I(t){return 100*t|0}function M(e,i,o){const r=function(r,a){if(r)return o(r);if(a){const r=t.pick(t.extend(a,e),["tiles","minzoom","maxzoom","attribution","mapbox_logo","bounds","scheme","tileSize","encoding"]);a.vector_layers&&(r.vectorLayers=a.vector_layers,r.vectorLayerIds=r.vectorLayers.map((t=>t.id))),r.tiles=i.canonicalizeTileset(r,e.url),o(null,r);}};return e.url?t.getJSON(i.transformRequest(i.normalizeSourceURL(e.url),t.ResourceType.Source),r):t.exported.frame((()=>r(null,e)))}class z{constructor(e,i,o){this.bounds=t.LngLatBounds.convert(this.validateBounds(e)),this.minzoom=i||0,this.maxzoom=o||24;}validateBounds(t){return Array.isArray(t)&&4===t.length?[Math.max(-180,t[0]),Math.max(-90,t[1]),Math.min(180,t[2]),Math.min(90,t[3])]:[-180,-90,180,90]}contains(e){const i=Math.pow(2,e.z),o=Math.floor(t.mercatorXfromLng(this.bounds.getWest())*i),r=Math.floor(t.mercatorYfromLat(this.bounds.getNorth())*i),a=Math.ceil(t.mercatorXfromLng(this.bounds.getEast())*i),n=Math.ceil(t.mercatorYfromLat(this.bounds.getSouth())*i);return e.x>=o&&e.x<a&&e.y>=r&&e.y<n}}class P{constructor(t,e,i){this.context=t;const o=t.gl;this.buffer=o.createBuffer(),this.dynamicDraw=Boolean(i),this.context.unbindVAO(),t.bindElementBuffer.set(this.buffer),o.bufferData(o.ELEMENT_ARRAY_BUFFER,e.arrayBuffer,this.dynamicDraw?o.DYNAMIC_DRAW:o.STATIC_DRAW),this.dynamicDraw||delete e.arrayBuffer;}bind(){this.context.bindElementBuffer.set(this.buffer);}updateData(t){const e=this.context.gl;this.context.unbindVAO(),this.bind(),e.bufferSubData(e.ELEMENT_ARRAY_BUFFER,0,t.arrayBuffer);}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer);}}const A={Int8:"BYTE",Uint8:"UNSIGNED_BYTE",Int16:"SHORT",Uint16:"UNSIGNED_SHORT",Int32:"INT",Uint32:"UNSIGNED_INT",Float32:"FLOAT"};class D{constructor(t,e,i,o){this.length=e.length,this.attributes=i,this.itemSize=e.bytesPerElement,this.dynamicDraw=o,this.context=t;const r=t.gl;this.buffer=r.createBuffer(),t.bindVertexBuffer.set(this.buffer),r.bufferData(r.ARRAY_BUFFER,e.arrayBuffer,this.dynamicDraw?r.DYNAMIC_DRAW:r.STATIC_DRAW),this.dynamicDraw||delete e.arrayBuffer;}bind(){this.context.bindVertexBuffer.set(this.buffer);}updateData(t){const e=this.context.gl;this.bind(),e.bufferSubData(e.ARRAY_BUFFER,0,t.arrayBuffer);}enableAttributes(t,e){for(let i=0;i<this.attributes.length;i++){const o=e.attributes[this.attributes[i].name];void 0!==o&&t.enableVertexAttribArray(o);}}setVertexAttribPointers(t,e,i){for(let o=0;o<this.attributes.length;o++){const r=this.attributes[o],a=e.attributes[r.name];void 0!==a&&t.vertexAttribPointer(a,r.components,t[A[r.type]],!1,this.itemSize,r.offset+this.itemSize*(i||0));}}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer);}}class L{constructor(t){this.gl=t.gl,this.default=this.getDefault(),this.current=this.default,this.dirty=!1;}get(){return this.current}set(t){}getDefault(){return this.default}setDefault(){this.set(this.default);}}class R extends L{getDefault(){return t.Color.transparent}set(t){const e=this.current;(t.r!==e.r||t.g!==e.g||t.b!==e.b||t.a!==e.a||this.dirty)&&(this.gl.clearColor(t.r,t.g,t.b,t.a),this.current=t,this.dirty=!1);}}class k extends L{getDefault(){return 1}set(t){(t!==this.current||this.dirty)&&(this.gl.clearDepth(t),this.current=t,this.dirty=!1);}}class B extends L{getDefault(){return 0}set(t){(t!==this.current||this.dirty)&&(this.gl.clearStencil(t),this.current=t,this.dirty=!1);}}class F extends L{getDefault(){return [!0,!0,!0,!0]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||t[3]!==e[3]||this.dirty)&&(this.gl.colorMask(t[0],t[1],t[2],t[3]),this.current=t,this.dirty=!1);}}class O extends L{getDefault(){return !0}set(t){(t!==this.current||this.dirty)&&(this.gl.depthMask(t),this.current=t,this.dirty=!1);}}class U extends L{getDefault(){return 255}set(t){(t!==this.current||this.dirty)&&(this.gl.stencilMask(t),this.current=t,this.dirty=!1);}}class N extends L{getDefault(){return {func:this.gl.ALWAYS,ref:0,mask:255}}set(t){const e=this.current;(t.func!==e.func||t.ref!==e.ref||t.mask!==e.mask||this.dirty)&&(this.gl.stencilFunc(t.func,t.ref,t.mask),this.current=t,this.dirty=!1);}}class G extends L{getDefault(){const t=this.gl;return [t.KEEP,t.KEEP,t.KEEP]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||this.dirty)&&(this.gl.stencilOp(t[0],t[1],t[2]),this.current=t,this.dirty=!1);}}class Z extends L{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.STENCIL_TEST):e.disable(e.STENCIL_TEST),this.current=t,this.dirty=!1;}}class V extends L{getDefault(){return [0,1]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||this.dirty)&&(this.gl.depthRange(t[0],t[1]),this.current=t,this.dirty=!1);}}class q extends L{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.DEPTH_TEST):e.disable(e.DEPTH_TEST),this.current=t,this.dirty=!1;}}class W extends L{getDefault(){return this.gl.LESS}set(t){(t!==this.current||this.dirty)&&(this.gl.depthFunc(t),this.current=t,this.dirty=!1);}}class j extends L{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.BLEND):e.disable(e.BLEND),this.current=t,this.dirty=!1;}}class X extends L{getDefault(){const t=this.gl;return [t.ONE,t.ZERO]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||this.dirty)&&(this.gl.blendFunc(t[0],t[1]),this.current=t,this.dirty=!1);}}class $ extends L{getDefault(){return t.Color.transparent}set(t){const e=this.current;(t.r!==e.r||t.g!==e.g||t.b!==e.b||t.a!==e.a||this.dirty)&&(this.gl.blendColor(t.r,t.g,t.b,t.a),this.current=t,this.dirty=!1);}}class H extends L{getDefault(){return this.gl.FUNC_ADD}set(t){(t!==this.current||this.dirty)&&(this.gl.blendEquation(t),this.current=t,this.dirty=!1);}}class K extends L{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.CULL_FACE):e.disable(e.CULL_FACE),this.current=t,this.dirty=!1;}}class Y extends L{getDefault(){return this.gl.BACK}set(t){(t!==this.current||this.dirty)&&(this.gl.cullFace(t),this.current=t,this.dirty=!1);}}class J extends L{getDefault(){return this.gl.CCW}set(t){(t!==this.current||this.dirty)&&(this.gl.frontFace(t),this.current=t,this.dirty=!1);}}class Q extends L{getDefault(){return null}set(t){(t!==this.current||this.dirty)&&(this.gl.useProgram(t),this.current=t,this.dirty=!1);}}class tt extends L{getDefault(){return this.gl.TEXTURE0}set(t){(t!==this.current||this.dirty)&&(this.gl.activeTexture(t),this.current=t,this.dirty=!1);}}class et extends L{getDefault(){const t=this.gl;return [0,0,t.drawingBufferWidth,t.drawingBufferHeight]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||t[3]!==e[3]||this.dirty)&&(this.gl.viewport(t[0],t[1],t[2],t[3]),this.current=t,this.dirty=!1);}}class it extends L{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindFramebuffer(e.FRAMEBUFFER,t),this.current=t,this.dirty=!1;}}class ot extends L{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindRenderbuffer(e.RENDERBUFFER,t),this.current=t,this.dirty=!1;}}class rt extends L{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindTexture(e.TEXTURE_2D,t),this.current=t,this.dirty=!1;}}class at extends L{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindBuffer(e.ARRAY_BUFFER,t),this.current=t,this.dirty=!1;}}class nt extends L{getDefault(){return null}set(t){const e=this.gl;e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,t),this.current=t,this.dirty=!1;}}class st extends L{constructor(t){super(t),this.vao=t.extVertexArrayObject;}getDefault(){return null}set(t){this.vao&&(t!==this.current||this.dirty)&&(this.vao.bindVertexArrayOES(t),this.current=t,this.dirty=!1);}}class lt extends L{getDefault(){return 4}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_ALIGNMENT,t),this.current=t,this.dirty=!1;}}class ct extends L{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_PREMULTIPLY_ALPHA_WEBGL,t),this.current=t,this.dirty=!1;}}class ht extends L{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_FLIP_Y_WEBGL,t),this.current=t,this.dirty=!1;}}class ut extends L{constructor(t,e){super(t),this.context=t,this.parent=e;}getDefault(){return null}}class dt extends ut{setDirty(){this.dirty=!0;}set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,t,0),this.current=t,this.dirty=!1;}}class _t extends ut{attachment(){return this.gl.DEPTH_ATTACHMENT}set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferRenderbuffer(e.FRAMEBUFFER,this.attachment(),e.RENDERBUFFER,t),this.current=t,this.dirty=!1;}}class mt extends _t{attachment(){return this.gl.DEPTH_STENCIL_ATTACHMENT}}class pt{constructor(t,e,i,o){this.context=t,this.width=e,this.height=i;const r=this.framebuffer=t.gl.createFramebuffer();this.colorAttachment=new dt(t,r),o&&(this.depthAttachment=new _t(t,r));}destroy(){const t=this.context.gl,e=this.colorAttachment.get();if(e&&t.deleteTexture(e),this.depthAttachment){const e=this.depthAttachment.get();e&&t.deleteRenderbuffer(e);}t.deleteFramebuffer(this.framebuffer);}}class ft{constructor(t){this.gl=t,this.extVertexArrayObject=this.gl.getExtension("OES_vertex_array_object"),this.clearColor=new R(this),this.clearDepth=new k(this),this.clearStencil=new B(this),this.colorMask=new F(this),this.depthMask=new O(this),this.stencilMask=new U(this),this.stencilFunc=new N(this),this.stencilOp=new G(this),this.stencilTest=new Z(this),this.depthRange=new V(this),this.depthTest=new q(this),this.depthFunc=new W(this),this.blend=new j(this),this.blendFunc=new X(this),this.blendColor=new $(this),this.blendEquation=new H(this),this.cullFace=new K(this),this.cullFaceSide=new Y(this),this.frontFace=new J(this),this.program=new Q(this),this.activeTexture=new tt(this),this.viewport=new et(this),this.bindFramebuffer=new it(this),this.bindRenderbuffer=new ot(this),this.bindTexture=new rt(this),this.bindVertexBuffer=new at(this),this.bindElementBuffer=new nt(this),this.bindVertexArrayOES=this.extVertexArrayObject&&new st(this),this.pixelStoreUnpack=new lt(this),this.pixelStoreUnpackPremultiplyAlpha=new ct(this),this.pixelStoreUnpackFlipY=new ht(this),this.extTextureFilterAnisotropic=t.getExtension("EXT_texture_filter_anisotropic")||t.getExtension("MOZ_EXT_texture_filter_anisotropic")||t.getExtension("WEBKIT_EXT_texture_filter_anisotropic"),this.extTextureFilterAnisotropic&&(this.extTextureFilterAnisotropicMax=t.getParameter(this.extTextureFilterAnisotropic.MAX_TEXTURE_MAX_ANISOTROPY_EXT)),this.extTextureFilterAnisotropicForceOff=!1,this.extTextureHalfFloat=t.getExtension("OES_texture_half_float"),this.extTextureHalfFloat&&(t.getExtension("OES_texture_half_float_linear"),this.extRenderToTextureHalfFloat=t.getExtension("EXT_color_buffer_half_float")),this.extTimerQuery=t.getExtension("EXT_disjoint_timer_query"),this.maxTextureSize=t.getParameter(t.MAX_TEXTURE_SIZE);}setDefault(){this.unbindVAO(),this.clearColor.setDefault(),this.clearDepth.setDefault(),this.clearStencil.setDefault(),this.colorMask.setDefault(),this.depthMask.setDefault(),this.stencilMask.setDefault(),this.stencilFunc.setDefault(),this.stencilOp.setDefault(),this.stencilTest.setDefault(),this.depthRange.setDefault(),this.depthTest.setDefault(),this.depthFunc.setDefault(),this.blend.setDefault(),this.blendFunc.setDefault(),this.blendColor.setDefault(),this.blendEquation.setDefault(),this.cullFace.setDefault(),this.cullFaceSide.setDefault(),this.frontFace.setDefault(),this.program.setDefault(),this.activeTexture.setDefault(),this.bindFramebuffer.setDefault(),this.pixelStoreUnpack.setDefault(),this.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.pixelStoreUnpackFlipY.setDefault();}setDirty(){this.clearColor.dirty=!0,this.clearDepth.dirty=!0,this.clearStencil.dirty=!0,this.colorMask.dirty=!0,this.depthMask.dirty=!0,this.stencilMask.dirty=!0,this.stencilFunc.dirty=!0,this.stencilOp.dirty=!0,this.stencilTest.dirty=!0,this.depthRange.dirty=!0,this.depthTest.dirty=!0,this.depthFunc.dirty=!0,this.blend.dirty=!0,this.blendFunc.dirty=!0,this.blendColor.dirty=!0,this.blendEquation.dirty=!0,this.cullFace.dirty=!0,this.cullFaceSide.dirty=!0,this.frontFace.dirty=!0,this.program.dirty=!0,this.activeTexture.dirty=!0,this.viewport.dirty=!0,this.bindFramebuffer.dirty=!0,this.bindRenderbuffer.dirty=!0,this.bindTexture.dirty=!0,this.bindVertexBuffer.dirty=!0,this.bindElementBuffer.dirty=!0,this.extVertexArrayObject&&(this.bindVertexArrayOES.dirty=!0),this.pixelStoreUnpack.dirty=!0,this.pixelStoreUnpackPremultiplyAlpha.dirty=!0,this.pixelStoreUnpackFlipY.dirty=!0;}createIndexBuffer(t,e){return new P(this,t,e)}createVertexBuffer(t,e,i){return new D(this,t,e,i)}createRenderbuffer(t,e,i){const o=this.gl,r=o.createRenderbuffer();return this.bindRenderbuffer.set(r),o.renderbufferStorage(o.RENDERBUFFER,t,e,i),this.bindRenderbuffer.set(null),r}createFramebuffer(t,e,i){return new pt(this,t,e,i)}clear({color:t,depth:e,stencil:i}){const o=this.gl;let r=0;t&&(r|=o.COLOR_BUFFER_BIT,this.clearColor.set(t),this.colorMask.set([!0,!0,!0,!0])),void 0!==e&&(r|=o.DEPTH_BUFFER_BIT,this.depthRange.set([0,1]),this.clearDepth.set(e),this.depthMask.set(!0)),void 0!==i&&(r|=o.STENCIL_BUFFER_BIT,this.clearStencil.set(i),this.stencilMask.set(255)),o.clear(r);}setCullFace(t){!1===t.enable?this.cullFace.set(!1):(this.cullFace.set(!0),this.cullFaceSide.set(t.mode),this.frontFace.set(t.frontFace));}setDepthMode(t){t.func!==this.gl.ALWAYS||t.mask?(this.depthTest.set(!0),this.depthFunc.set(t.func),this.depthMask.set(t.mask),this.depthRange.set(t.range)):this.depthTest.set(!1);}setStencilMode(t){t.test.func!==this.gl.ALWAYS||t.mask?(this.stencilTest.set(!0),this.stencilMask.set(t.mask),this.stencilOp.set([t.fail,t.depthFail,t.pass]),this.stencilFunc.set({func:t.test.func,ref:t.ref,mask:t.test.mask})):this.stencilTest.set(!1);}setColorMode(e){r(e.blendFunction,t.ColorMode.Replace)?this.blend.set(!1):(this.blend.set(!0),this.blendFunc.set(e.blendFunction),this.blendColor.set(e.blendColor)),this.colorMask.set(e.mask);}unbindVAO(){this.extVertexArrayObject&&this.bindVertexArrayOES.set(null);}}class gt extends t.Evented{constructor(e,i,o,r){super(),this.id=e,this.dispatcher=o,this.setEventedParent(r),this.type="raster",this.minzoom=0,this.maxzoom=22,this.roundZoom=!0,this.scheme="xyz",this.tileSize=512,this._loaded=!1,this._options=t.extend({type:"raster"},i),t.extend(this,t.pick(i,["url","scheme","tileSize"]));}load(){this._loaded=!1,this.fire(new t.Event("dataloading",{dataType:"source"})),this._tileJSONRequest=M(this._options,this.map._requestManager,((e,i)=>{this._tileJSONRequest=null,this._loaded=!0,e?this.fire(new t.ErrorEvent(e)):i&&(t.extend(this,i),i.bounds&&(this.tileBounds=new z(i.bounds,this.minzoom,this.maxzoom)),t.postTurnstileEvent(i.tiles),this.fire(new t.Event("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new t.Event("data",{dataType:"source",sourceDataType:"content"})));}));}loaded(){return this._loaded}onAdd(t){this.map=t,this.load();}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null);}serialize(){return t.extend({},this._options)}hasTile(t){return !this.tileBounds||this.tileBounds.contains(t.canonical)}loadTile(e,i){const o=t.exported.devicePixelRatio>=2,r=this.map._requestManager.normalizeTileURL(e.tileID.canonical.url(this.tiles,this.scheme),o,this.tileSize);e.request=t.getImage(this.map._requestManager.transformRequest(r,t.ResourceType.Tile),((o,r)=>{if(delete e.request,e.aborted)e.state="unloaded",i(null);else if(o)e.state="errored",i(o);else if(r){this.map._refreshExpiredTiles&&e.setExpiryData(r),delete r.cacheControl,delete r.expires;const o=this.map.painter.context,a=o.gl;e.texture=this.map.painter.getTileTexture(r.width),e.texture?e.texture.update(r,{useMipmap:!0}):(e.texture=new t.Texture(o,r,a.RGBA,{useMipmap:!0}),e.texture.bind(a.LINEAR,a.CLAMP_TO_EDGE,a.LINEAR_MIPMAP_NEAREST),o.extTextureFilterAnisotropic&&a.texParameterf(a.TEXTURE_2D,o.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,o.extTextureFilterAnisotropicMax)),e.state="loaded",t.cacheEntryPossiblyAdded(this.dispatcher),i(null);}}));}abortTile(t,e){t.request&&(t.request.cancel(),delete t.request),e();}unloadTile(t,e){t.texture&&this.map.painter.saveTileTexture(t.texture),e();}hasTransition(){return !1}}var xt=t.createLayout([{name:"a_pos",type:"Int16",components:2},{name:"a_texture_pos",type:"Int16",components:2}]);class vt extends t.Evented{constructor(t,e,i,o){super(),this.id=t,this.dispatcher=i,this.coordinates=e.coordinates,this.type="image",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.tiles={},this._loaded=!1,this.setEventedParent(o),this.options=e;}load(e,i){this._loaded=!1,this.fire(new t.Event("dataloading",{dataType:"source"})),this.url=this.options.url,t.getImage(this.map._requestManager.transformRequest(this.url,t.ResourceType.Image),((o,r)=>{this._loaded=!0,o?this.fire(new t.ErrorEvent(o)):r&&(this.image=r,e&&(this.coordinates=e),i&&i(),this._finishLoading());}));}loaded(){return this._loaded}updateImage(t){return this.image&&t.url?(this.options.url=t.url,this.load(t.coordinates,(()=>{this.texture=null;})),this):this}_finishLoading(){this.map&&(this.setCoordinates(this.coordinates),this.fire(new t.Event("data",{dataType:"source",sourceDataType:"metadata"})));}onAdd(t){this.map=t,this.load();}setCoordinates(e){this.coordinates=e;const i=e.map(t.MercatorCoordinate.fromLngLat);this.tileID=function(e){let i=1/0,o=1/0,r=-1/0,a=-1/0;for(const t of e)i=Math.min(i,t.x),o=Math.min(o,t.y),r=Math.max(r,t.x),a=Math.max(a,t.y);const n=Math.max(r-i,a-o),s=Math.max(0,Math.floor(-Math.log(n)/Math.LN2)),l=Math.pow(2,s);return new t.CanonicalTileID(s,Math.floor((i+r)/2*l),Math.floor((o+a)/2*l))}(i),this.minzoom=this.maxzoom=this.tileID.z;const o=i.map((t=>this.tileID.getTilePoint(t)._round()));return this._boundsArray=new t.StructArrayLayout4i8,this._boundsArray.emplaceBack(o[0].x,o[0].y,0,0),this._boundsArray.emplaceBack(o[1].x,o[1].y,t.EXTENT,0),this._boundsArray.emplaceBack(o[3].x,o[3].y,0,t.EXTENT),this._boundsArray.emplaceBack(o[2].x,o[2].y,t.EXTENT,t.EXTENT),this.boundsBuffer&&(this.boundsBuffer.destroy(),delete this.boundsBuffer),this.fire(new t.Event("data",{dataType:"source",sourceDataType:"content"})),this}prepare(){if(0===Object.keys(this.tiles).length||!this.image)return;const e=this.map.painter.context,i=e.gl;this.boundsBuffer||(this.boundsBuffer=e.createVertexBuffer(this._boundsArray,xt.members)),this.boundsSegments||(this.boundsSegments=t.SegmentVector.simpleSegment(0,0,4,2)),this.texture||(this.texture=new t.Texture(e,this.image,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE));for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture);}}loadTile(t,e){this.tileID&&this.tileID.equals(t.tileID.canonical)?(this.tiles[String(t.tileID.wrap)]=t,t.buckets={},e(null)):(t.state="errored",e(null));}serialize(){return {type:"image",url:this.options.url,coordinates:this.coordinates}}hasTransition(){return !1}}const yt={vector:class extends t.Evented{constructor(e,i,o,r){if(super(),this.id=e,this.dispatcher=o,this.type="vector",this.minzoom=0,this.maxzoom=22,this.scheme="xyz",this.tileSize=512,this.reparseOverscaled=!0,this.isTileClipped=!0,this._loaded=!1,t.extend(this,t.pick(i,["url","scheme","tileSize","promoteId"])),this._options=t.extend({type:"vector"},i),this._collectResourceTiming=i.collectResourceTiming,512!==this.tileSize)throw new Error("vector tile sources must have a tileSize of 512");this.setEventedParent(r),this._tileWorkers={},this._deduped=new t.DedupedRequest;}load(){this._loaded=!1,this.fire(new t.Event("dataloading",{dataType:"source"})),this._tileJSONRequest=M(this._options,this.map._requestManager,((e,i)=>{this._tileJSONRequest=null,this._loaded=!0,e?this.fire(new t.ErrorEvent(e)):i&&(t.extend(this,i),i.bounds&&(this.tileBounds=new z(i.bounds,this.minzoom,this.maxzoom)),t.postTurnstileEvent(i.tiles,this.map._requestManager._customAccessToken),this.fire(new t.Event("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new t.Event("data",{dataType:"source",sourceDataType:"content"})));}));}loaded(){return this._loaded}hasTile(t){return !this.tileBounds||this.tileBounds.contains(t.canonical)}onAdd(t){this.map=t,this.load();}setSourceProperty(t){this._tileJSONRequest&&this._tileJSONRequest.cancel(),t();const e=this.map.style._getSourceCaches(this.id);for(const t of e)t.clearTiles();this.load();}setTiles(t){return this.setSourceProperty((()=>{this._options.tiles=t;})),this}setUrl(t){return this.setSourceProperty((()=>{this.url=t,this._options.url=t;})),this}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null);}serialize(){return t.extend({},this._options)}loadTile(e,i){const o=this.map._requestManager.normalizeTileURL(e.tileID.canonical.url(this.tiles,this.scheme)),r={request:this.map._requestManager.transformRequest(o,t.ResourceType.Tile),data:void 0,uid:e.uid,tileID:e.tileID,tileZoom:e.tileZoom,zoom:e.tileID.overscaledZ,tileSize:this.tileSize*e.tileID.overscaleFactor(),type:this.type,source:this.id,pixelRatio:t.exported.devicePixelRatio,showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,isSymbolTile:e.isSymbolTile};if(r.request.collectResourceTiming=this._collectResourceTiming,e.actor&&"expired"!==e.state)"loading"===e.state?e.reloadCallback=i:e.request=e.actor.send("reloadTile",r,a.bind(this));else if(e.actor=this._tileWorkers[o]=this._tileWorkers[o]||this.dispatcher.getActor(),this.dispatcher.ready)e.request=e.actor.send("loadTile",r,a.bind(this),void 0,!0);else {const i=t.loadVectorTile.call({deduped:this._deduped},r,((t,i)=>{t||!i?a.call(this,t):(r.data={cacheControl:i.cacheControl,expires:i.expires,rawData:i.rawData.slice(0)},e.actor&&e.actor.send("loadTile",r,a.bind(this),void 0,!0));}),!0);e.request={cancel:i};}function a(o,r){return delete e.request,e.aborted?i(null):o&&404!==o.status?i(o):(r&&r.resourceTiming&&(e.resourceTiming=r.resourceTiming),this.map._refreshExpiredTiles&&r&&e.setExpiryData(r),e.loadVectorData(r,this.map.painter),t.cacheEntryPossiblyAdded(this.dispatcher),i(null),void(e.reloadCallback&&(this.loadTile(e,e.reloadCallback),e.reloadCallback=null)))}}abortTile(t){t.request&&(t.request.cancel(),delete t.request),t.actor&&t.actor.send("abortTile",{uid:t.uid,type:this.type,source:this.id});}unloadTile(t){t.unloadVectorData(),t.actor&&t.actor.send("removeTile",{uid:t.uid,type:this.type,source:this.id});}hasTransition(){return !1}afterUpdate(){this._tileWorkers={};}},raster:gt,"raster-dem":class extends gt{constructor(e,i,o,r){super(e,i,o,r),this.type="raster-dem",this.maxzoom=22,this._options=t.extend({type:"raster-dem"},i),this.encoding=i.encoding||"mapbox";}loadTile(e,i){const o=this.map._requestManager.normalizeTileURL(e.tileID.canonical.url(this.tiles,this.scheme),!1,this.tileSize);function r(t,o){t&&(e.state="errored",i(t)),o&&(e.dem=o,e.dem.onDeserialize(),e.needsHillshadePrepare=!0,e.needsDEMTextureUpload=!0,e.state="loaded",i(null));}e.request=t.getImage(this.map._requestManager.transformRequest(o,t.ResourceType.Tile),function(o,a){if(delete e.request,e.aborted)e.state="unloaded",i(null);else if(o)e.state="errored",i(o);else if(a){this.map._refreshExpiredTiles&&e.setExpiryData(a),delete a.cacheControl,delete a.expires;const i=t.window.ImageBitmap&&a instanceof t.window.ImageBitmap&&t.offscreenCanvasSupported(),o=1-(a.width-t.prevPowerOfTwo(a.width))/2;o<1||e.neighboringTiles||(e.neighboringTiles=this._getNeighboringTiles(e.tileID));const n=i?a:t.exported.getImageData(a,o),s={uid:e.uid,coord:e.tileID,source:this.id,rawImageData:n,encoding:this.encoding,padding:o};e.actor&&"expired"!==e.state||(e.actor=this.dispatcher.getActor(),e.actor.send("loadDEMTile",s,r.bind(this),void 0,!0));}}.bind(this));}_getNeighboringTiles(e){const i=e.canonical,o=Math.pow(2,i.z),r=(i.x-1+o)%o,a=0===i.x?e.wrap-1:e.wrap,n=(i.x+1+o)%o,s=i.x+1===o?e.wrap+1:e.wrap,l={};return l[new t.OverscaledTileID(e.overscaledZ,a,i.z,r,i.y).key]={backfilled:!1},l[new t.OverscaledTileID(e.overscaledZ,s,i.z,n,i.y).key]={backfilled:!1},i.y>0&&(l[new t.OverscaledTileID(e.overscaledZ,a,i.z,r,i.y-1).key]={backfilled:!1},l[new t.OverscaledTileID(e.overscaledZ,e.wrap,i.z,i.x,i.y-1).key]={backfilled:!1},l[new t.OverscaledTileID(e.overscaledZ,s,i.z,n,i.y-1).key]={backfilled:!1}),i.y+1<o&&(l[new t.OverscaledTileID(e.overscaledZ,a,i.z,r,i.y+1).key]={backfilled:!1},l[new t.OverscaledTileID(e.overscaledZ,e.wrap,i.z,i.x,i.y+1).key]={backfilled:!1},l[new t.OverscaledTileID(e.overscaledZ,s,i.z,n,i.y+1).key]={backfilled:!1}),l}unloadTile(t){t.demTexture&&this.map.painter.saveTileTexture(t.demTexture),t.fbo&&(t.fbo.destroy(),delete t.fbo),t.dem&&delete t.dem,delete t.neighboringTiles,t.state="unloaded";}},geojson:class extends t.Evented{constructor(e,i,o,r){super(),this.id=e,this.type="geojson",this.minzoom=0,this.maxzoom=18,this.tileSize=512,this.isTileClipped=!0,this.reparseOverscaled=!0,this._loaded=!1,this.actor=o.getActor(),this.setEventedParent(r),this._data=i.data,this._options=t.extend({},i),this._collectResourceTiming=i.collectResourceTiming,void 0!==i.maxzoom&&(this.maxzoom=i.maxzoom),i.type&&(this.type=i.type),i.attribution&&(this.attribution=i.attribution),this.promoteId=i.promoteId;const a=t.EXTENT/this.tileSize;this.workerOptions=t.extend({source:this.id,cluster:i.cluster||!1,geojsonVtOptions:{buffer:(void 0!==i.buffer?i.buffer:128)*a,tolerance:(void 0!==i.tolerance?i.tolerance:.375)*a,extent:t.EXTENT,maxZoom:this.maxzoom,lineMetrics:i.lineMetrics||!1,generateId:i.generateId||!1},superclusterOptions:{maxZoom:void 0!==i.clusterMaxZoom?i.clusterMaxZoom:this.maxzoom-1,minPoints:Math.max(2,i.clusterMinPoints||2),extent:t.EXTENT,radius:(void 0!==i.clusterRadius?i.clusterRadius:50)*a,log:!1,generateId:i.generateId||!1},clusterProperties:i.clusterProperties,filter:i.filter},i.workerOptions);}onAdd(t){this.map=t,this.setData(this._data);}setData(t){return this._data=t,this._updateWorkerData(),this}getClusterExpansionZoom(t,e){return this.actor.send("geojson.getClusterExpansionZoom",{clusterId:t,source:this.id},e),this}getClusterChildren(t,e){return this.actor.send("geojson.getClusterChildren",{clusterId:t,source:this.id},e),this}getClusterLeaves(t,e,i,o){return this.actor.send("geojson.getClusterLeaves",{source:this.id,clusterId:t,limit:e,offset:i},o),this}_updateWorkerData(){if(this._pendingLoad)return void(this._coalesce=!0);this.fire(new t.Event("dataloading",{dataType:"source"})),this._loaded=!1;const e=t.extend({},this.workerOptions),i=this._data;"string"==typeof i?(e.request=this.map._requestManager.transformRequest(t.exported.resolveURL(i),t.ResourceType.Source),e.request.collectResourceTiming=this._collectResourceTiming):e.data=JSON.stringify(i),this._pendingLoad=this.actor.send(`${this.type}.loadData`,e,((e,i)=>{if(this._loaded=!0,this._pendingLoad=null,e)this.fire(new t.ErrorEvent(e));else {const e={dataType:"source",sourceDataType:this._metadataFired?"content":"metadata"};this._collectResourceTiming&&i&&i.resourceTiming&&i.resourceTiming[this.id]&&(e.resourceTiming=i.resourceTiming[this.id]),this.fire(new t.Event("data",e)),this._metadataFired=!0;}this._coalesce&&(this._updateWorkerData(),this._coalesce=!1);}));}loaded(){return this._loaded}loadTile(e,i){const o=e.actor?"reloadTile":"loadTile";e.actor=this.actor,e.request=this.actor.send(o,{type:this.type,uid:e.uid,tileID:e.tileID,tileZoom:e.tileZoom,zoom:e.tileID.overscaledZ,maxZoom:this.maxzoom,tileSize:this.tileSize,source:this.id,pixelRatio:t.exported.devicePixelRatio,showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId},((t,r)=>(delete e.request,e.unloadVectorData(),e.aborted?i(null):t?i(t):(e.loadVectorData(r,this.map.painter,"reloadTile"===o),i(null)))),void 0,"loadTile"===o);}abortTile(t){t.request&&(t.request.cancel(),delete t.request),t.aborted=!0;}unloadTile(t){t.unloadVectorData(),this.actor.send("removeTile",{uid:t.uid,type:this.type,source:this.id});}onRemove(){this._pendingLoad&&this._pendingLoad.cancel();}serialize(){return t.extend({},this._options,{type:this.type,data:this._data})}hasTransition(){return !1}},video:class extends vt{constructor(t,e,i,o){super(t,e,i,o),this.roundZoom=!0,this.type="video",this.options=e;}load(){this._loaded=!1;const e=this.options;this.urls=[];for(const i of e.urls)this.urls.push(this.map._requestManager.transformRequest(i,t.ResourceType.Source).url);t.getVideo(this.urls,((e,i)=>{this._loaded=!0,e?this.fire(new t.ErrorEvent(e)):i&&(this.video=i,this.video.loop=!0,this.video.addEventListener("playing",(()=>{this.map.triggerRepaint();})),this.map&&this.video.play(),this._finishLoading());}));}pause(){this.video&&this.video.pause();}play(){this.video&&this.video.play();}seek(e){if(this.video){const i=this.video.seekable;e<i.start(0)||e>i.end(0)?this.fire(new t.ErrorEvent(new t.ValidationError(`sources.${this.id}`,null,`Playback for this video can be set only between the ${i.start(0)} and ${i.end(0)}-second mark.`))):this.video.currentTime=e;}}getVideo(){return this.video}onAdd(t){this.map||(this.map=t,this.load(),this.video&&(this.video.play(),this.setCoordinates(this.coordinates)));}prepare(){if(0===Object.keys(this.tiles).length||this.video.readyState<2)return;const e=this.map.painter.context,i=e.gl;this.boundsBuffer||(this.boundsBuffer=e.createVertexBuffer(this._boundsArray,xt.members)),this.boundsSegments||(this.boundsSegments=t.SegmentVector.simpleSegment(0,0,4,2)),this.texture?this.video.paused||(this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE),i.texSubImage2D(i.TEXTURE_2D,0,0,0,i.RGBA,i.UNSIGNED_BYTE,this.video)):(this.texture=new t.Texture(e,this.video,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE));for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture);}}serialize(){return {type:"video",urls:this.urls,coordinates:this.coordinates}}hasTransition(){return this.video&&!this.video.paused}},image:vt,canvas:class extends vt{constructor(e,i,o,r){super(e,i,o,r),i.coordinates?Array.isArray(i.coordinates)&&4===i.coordinates.length&&!i.coordinates.some((t=>!Array.isArray(t)||2!==t.length||t.some((t=>"number"!=typeof t))))||this.fire(new t.ErrorEvent(new t.ValidationError(`sources.${e}`,null,'"coordinates" property must be an array of 4 longitude/latitude array pairs'))):this.fire(new t.ErrorEvent(new t.ValidationError(`sources.${e}`,null,'missing required property "coordinates"'))),i.animate&&"boolean"!=typeof i.animate&&this.fire(new t.ErrorEvent(new t.ValidationError(`sources.${e}`,null,'optional "animate" property must be a boolean value'))),i.canvas?"string"==typeof i.canvas||i.canvas instanceof t.window.HTMLCanvasElement||this.fire(new t.ErrorEvent(new t.ValidationError(`sources.${e}`,null,'"canvas" must be either a string representing the ID of the canvas element from which to read, or an HTMLCanvasElement instance'))):this.fire(new t.ErrorEvent(new t.ValidationError(`sources.${e}`,null,'missing required property "canvas"'))),this.options=i,this.animate=void 0===i.animate||i.animate;}load(){this._loaded=!0,this.canvas||(this.canvas=this.options.canvas instanceof t.window.HTMLCanvasElement?this.options.canvas:t.window.document.getElementById(this.options.canvas)),this.width=this.canvas.width,this.height=this.canvas.height,this._hasInvalidDimensions()?this.fire(new t.ErrorEvent(new Error("Canvas dimensions cannot be less than or equal to zero."))):(this.play=function(){this._playing=!0,this.map.triggerRepaint();},this.pause=function(){this._playing&&(this.prepare(),this._playing=!1);},this._finishLoading());}getCanvas(){return this.canvas}onAdd(t){this.map=t,this.load(),this.canvas&&this.animate&&this.play();}onRemove(){this.pause();}prepare(){let e=!1;if(this.canvas.width!==this.width&&(this.width=this.canvas.width,e=!0),this.canvas.height!==this.height&&(this.height=this.canvas.height,e=!0),this._hasInvalidDimensions())return;if(0===Object.keys(this.tiles).length)return;const i=this.map.painter.context,o=i.gl;this.boundsBuffer||(this.boundsBuffer=i.createVertexBuffer(this._boundsArray,xt.members)),this.boundsSegments||(this.boundsSegments=t.SegmentVector.simpleSegment(0,0,4,2)),this.texture?(e||this._playing)&&this.texture.update(this.canvas,{premultiply:!0}):this.texture=new t.Texture(i,this.canvas,o.RGBA,{premultiply:!0});for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture);}}serialize(){return {type:"canvas",coordinates:this.coordinates}}hasTransition(){return this._playing}_hasInvalidDimensions(){for(const t of [this.canvas.width,this.canvas.height])if(isNaN(t)||t<=0)return !0;return !1}}},bt=function(e,i,o,r){const a=new yt[i.type](e,i,o,r);if(a.id!==e)throw new Error(`Expected Source id to be ${e} instead of ${a.id}`);return t.bindAll(["load","abort","unload","serialize","prepare"],a),a};function wt(e,i){const o=t.identity([]);return t.scale$1(o,o,[.5*e.width,.5*-e.height,1]),t.translate(o,o,[1,-1,0]),t.multiply(o,o,e.calculatePosMatrix(i.toUnwrapped()))}function Tt(t,e,i,o,r,a,n,s=!1){const l=t.tilesIn(o,n,s);l.sort(Ct);const c=[];for(const o of l)c.push({wrappedTileID:o.tile.tileID.wrapped().key,queryResults:o.tile.queryRenderedFeatures(e,i,t._state,o,r,a,wt(t.transform,o.tile.tileID),s)});const h=function(t){const e={},i={};for(const o of t){const t=o.queryResults,r=o.wrappedTileID,a=i[r]=i[r]||{};for(const i in t){const o=t[i],r=a[i]=a[i]||{},n=e[i]=e[i]||[];for(const t of o)r[t.featureIndex]||(r[t.featureIndex]=!0,n.push(t));}}return e}(c);for(const e in h)h[e].forEach((e=>{const i=e.feature,o=t.getFeatureState(i.layer["source-layer"],i.id);i.source=i.layer.source,i.layer["source-layer"]&&(i.sourceLayer=i.layer["source-layer"]),i.state=o;}));return h}function Et(t,e){const i=t.getRenderableIds().map((e=>t.getTileByID(e))),o=[],r={};for(let t=0;t<i.length;t++){const a=i[t],n=a.tileID.canonical.key;r[n]||(r[n]=!0,a.querySourceFeatures(o,e));}return o}function Ct(t,e){const i=t.tileID,o=e.tileID;return i.overscaledZ-o.overscaledZ||i.canonical.y-o.canonical.y||i.wrap-o.wrap||i.canonical.x-o.canonical.x}function St(){return null!=Fr.workerClass?new Fr.workerClass:new t.window.Worker(Fr.workerUrl)}const It="mapboxgl_preloaded_worker_pool";class Mt{constructor(){this.active={};}acquire(t){if(!this.workers)for(this.workers=[];this.workers.length<Mt.workerCount;)this.workers.push(new St);return this.active[t]=!0,this.workers.slice()}release(t){delete this.active[t],0===this.numActive()&&(this.workers.forEach((t=>{t.terminate();})),this.workers=null);}isPreloaded(){return !!this.active[It]}numActive(){return Object.keys(this.active).length}}let zt;function Pt(){return zt||(zt=new Mt),zt}function At(e,i){const o={};for(const t in e)"ref"!==t&&(o[t]=e[t]);return t.refProperties.forEach((t=>{t in i&&(o[t]=i[t]);})),o}function Dt(t){t=t.slice();const e=Object.create(null);for(let i=0;i<t.length;i++)e[t[i].id]=t[i];for(let i=0;i<t.length;i++)"ref"in t[i]&&(t[i]=At(t[i],e[t[i].ref]));return t}Mt.workerCount=2;const Lt={setStyle:"setStyle",addLayer:"addLayer",removeLayer:"removeLayer",setPaintProperty:"setPaintProperty",setLayoutProperty:"setLayoutProperty",setFilter:"setFilter",addSource:"addSource",removeSource:"removeSource",setGeoJSONSourceData:"setGeoJSONSourceData",setLayerZoomRange:"setLayerZoomRange",setLayerProperty:"setLayerProperty",setCenter:"setCenter",setZoom:"setZoom",setBearing:"setBearing",setPitch:"setPitch",setSprite:"setSprite",setGlyphs:"setGlyphs",setTransition:"setTransition",setLight:"setLight",setTerrain:"setTerrain"};function Rt(t,e,i){i.push({command:Lt.addSource,args:[t,e[t]]});}function kt(t,e,i){e.push({command:Lt.removeSource,args:[t]}),i[t]=!0;}function Bt(t,e,i,o){kt(t,i,o),Rt(t,e,i);}function Ft(t,e,i){let o;for(o in t[i])if(t[i].hasOwnProperty(o)&&"data"!==o&&!r(t[i][o],e[i][o]))return !1;for(o in e[i])if(e[i].hasOwnProperty(o)&&"data"!==o&&!r(t[i][o],e[i][o]))return !1;return !0}function Ot(t,e,i,o,a,n){let s;for(s in e=e||{},t=t||{})t.hasOwnProperty(s)&&(r(t[s],e[s])||i.push({command:n,args:[o,s,e[s],a]}));for(s in e)e.hasOwnProperty(s)&&!t.hasOwnProperty(s)&&(r(t[s],e[s])||i.push({command:n,args:[o,s,e[s],a]}));}function Ut(t){return t.id}function Nt(t,e){return t[e.id]=e,t}class Gt{constructor(t,e){this.reset(t,e);}reset(t,e){this.points=t||[],this._distances=[0];for(let t=1;t<this.points.length;t++)this._distances[t]=this._distances[t-1]+this.points[t].dist(this.points[t-1]);this.length=this._distances[this._distances.length-1],this.padding=Math.min(e||0,.5*this.length),this.paddedLength=this.length-2*this.padding;}lerp(e){if(1===this.points.length)return this.points[0];e=t.clamp(e,0,1);let i=1,o=this._distances[i];const r=e*this.paddedLength+this.padding;for(;o<r&&i<this._distances.length;)o=this._distances[++i];const a=i-1,n=this._distances[a],s=o-n,l=s>0?(r-n)/s:0;return this.points[a].mult(1-l).add(this.points[i].mult(l))}}class Zt{constructor(t,e,i){const o=this.boxCells=[],r=this.circleCells=[];this.xCellCount=Math.ceil(t/i),this.yCellCount=Math.ceil(e/i);for(let t=0;t<this.xCellCount*this.yCellCount;t++)o.push([]),r.push([]);this.circleKeys=[],this.boxKeys=[],this.bboxes=[],this.circles=[],this.width=t,this.height=e,this.xScale=this.xCellCount/t,this.yScale=this.yCellCount/e,this.boxUid=0,this.circleUid=0;}keysLength(){return this.boxKeys.length+this.circleKeys.length}insert(t,e,i,o,r){this._forEachCell(e,i,o,r,this._insertBoxCell,this.boxUid++),this.boxKeys.push(t),this.bboxes.push(e),this.bboxes.push(i),this.bboxes.push(o),this.bboxes.push(r);}insertCircle(t,e,i,o){this._forEachCell(e-o,i-o,e+o,i+o,this._insertCircleCell,this.circleUid++),this.circleKeys.push(t),this.circles.push(e),this.circles.push(i),this.circles.push(o);}_insertBoxCell(t,e,i,o,r,a){this.boxCells[r].push(a);}_insertCircleCell(t,e,i,o,r,a){this.circleCells[r].push(a);}_query(t,e,i,o,r,a){if(i<0||t>this.width||o<0||e>this.height)return !r&&[];const n=[];if(t<=0&&e<=0&&this.width<=i&&this.height<=o){if(r)return !0;for(let t=0;t<this.boxKeys.length;t++)n.push({key:this.boxKeys[t],x1:this.bboxes[4*t],y1:this.bboxes[4*t+1],x2:this.bboxes[4*t+2],y2:this.bboxes[4*t+3]});for(let t=0;t<this.circleKeys.length;t++){const e=this.circles[3*t],i=this.circles[3*t+1],o=this.circles[3*t+2];n.push({key:this.circleKeys[t],x1:e-o,y1:i-o,x2:e+o,y2:i+o});}return a?n.filter(a):n}return this._forEachCell(t,e,i,o,this._queryCell,n,{hitTest:r,seenUids:{box:{},circle:{}}},a),r?n.length>0:n}_queryCircle(t,e,i,o,r){const a=t-i,n=t+i,s=e-i,l=e+i;if(n<0||a>this.width||l<0||s>this.height)return !o&&[];const c=[];return this._forEachCell(a,s,n,l,this._queryCellCircle,c,{hitTest:o,circle:{x:t,y:e,radius:i},seenUids:{box:{},circle:{}}},r),o?c.length>0:c}query(t,e,i,o,r){return this._query(t,e,i,o,!1,r)}hitTest(t,e,i,o,r){return this._query(t,e,i,o,!0,r)}hitTestCircle(t,e,i,o){return this._queryCircle(t,e,i,!0,o)}_queryCell(t,e,i,o,r,a,n,s){const l=n.seenUids,c=this.boxCells[r];if(null!==c){const r=this.bboxes;for(const h of c)if(!l.box[h]){l.box[h]=!0;const c=4*h;if(t<=r[c+2]&&e<=r[c+3]&&i>=r[c+0]&&o>=r[c+1]&&(!s||s(this.boxKeys[h]))){if(n.hitTest)return a.push(!0),!0;a.push({key:this.boxKeys[h],x1:r[c],y1:r[c+1],x2:r[c+2],y2:r[c+3]});}}}const h=this.circleCells[r];if(null!==h){const r=this.circles;for(const c of h)if(!l.circle[c]){l.circle[c]=!0;const h=3*c;if(this._circleAndRectCollide(r[h],r[h+1],r[h+2],t,e,i,o)&&(!s||s(this.circleKeys[c]))){if(n.hitTest)return a.push(!0),!0;{const t=r[h],e=r[h+1],i=r[h+2];a.push({key:this.circleKeys[c],x1:t-i,y1:e-i,x2:t+i,y2:e+i});}}}}}_queryCellCircle(t,e,i,o,r,a,n,s){const l=n.circle,c=n.seenUids,h=this.boxCells[r];if(null!==h){const t=this.bboxes;for(const e of h)if(!c.box[e]){c.box[e]=!0;const i=4*e;if(this._circleAndRectCollide(l.x,l.y,l.radius,t[i+0],t[i+1],t[i+2],t[i+3])&&(!s||s(this.boxKeys[e])))return a.push(!0),!0}}const u=this.circleCells[r];if(null!==u){const t=this.circles;for(const e of u)if(!c.circle[e]){c.circle[e]=!0;const i=3*e;if(this._circlesCollide(t[i],t[i+1],t[i+2],l.x,l.y,l.radius)&&(!s||s(this.circleKeys[e])))return a.push(!0),!0}}}_forEachCell(t,e,i,o,r,a,n,s){const l=this._convertToXCellCoord(t),c=this._convertToYCellCoord(e),h=this._convertToXCellCoord(i),u=this._convertToYCellCoord(o);for(let d=l;d<=h;d++)for(let l=c;l<=u;l++)if(r.call(this,t,e,i,o,this.xCellCount*l+d,a,n,s))return}_convertToXCellCoord(t){return Math.max(0,Math.min(this.xCellCount-1,Math.floor(t*this.xScale)))}_convertToYCellCoord(t){return Math.max(0,Math.min(this.yCellCount-1,Math.floor(t*this.yScale)))}_circlesCollide(t,e,i,o,r,a){const n=o-t,s=r-e,l=i+a;return l*l>n*n+s*s}_circleAndRectCollide(t,e,i,o,r,a,n){const s=(a-o)/2,l=Math.abs(t-(o+s));if(l>s+i)return !1;const c=(n-r)/2,h=Math.abs(e-(r+c));if(h>c+i)return !1;if(l<=s||h<=c)return !0;const u=l-s,d=h-c;return u*u+d*d<=i*i}}function Vt(e,i,o,r,a){const n=t.create$1();return i?(t.scale$1(n,n,[1/a,1/a,1]),o||t.rotateZ(n,n,r.angle)):t.multiply(n,r.labelPlaneMatrix,e),n}function qt(e,i,o,r,a){if(i){const i=t.clone$1(e);return t.scale$1(i,i,[a,a,1]),o||t.rotateZ(i,i,-r.angle),i}return r.glCoordMatrix}function Wt(e,i,o=0){const r=[e.x,e.y,o,1];o?t.transformMat4(r,r,i):ie(r,r,i);const a=r[3];return {point:new t.pointGeometry(r[0]/a,r[1]/a),signedDistanceFromCamera:a}}function jt(t,e){return Math.min(.5+t/e*.5,1.5)}function Xt(t,e){const i=t[0]/t[3],o=t[1]/t[3];return i>=-e[0]&&i<=e[0]&&o>=-e[1]&&o<=e[1]}function $t(e,i,o,r,a,n,s,l,c){const h=r?e.textSizeData:e.iconSizeData,u=t.evaluateSizeForZoom(h,o.transform.zoom),d=[256/o.width*2+1,256/o.height*2+1],_=r?e.text.dynamicLayoutVertexArray:e.icon.dynamicLayoutVertexArray;_.clear();const m=e.lineVertexArray,p=r?e.text.placedSymbolArray:e.icon.placedSymbolArray,f=o.transform.width/o.transform.height;let g=!1;for(let r=0;r<p.length;r++){const x=p.get(r);if(x.hidden||x.writingMode===t.WritingMode.vertical&&!g){ee(x.numGlyphs,_);continue}g=!1;const v=c?c({x:x.anchorX,y:x.anchorY}):0,y=[x.anchorX,x.anchorY,v,1];if(t.transformMat4(y,y,i),!Xt(y,d)){ee(x.numGlyphs,_);continue}const b=jt(o.transform.cameraToCenterDistance,y[3]),w=t.evaluateSizeForFeature(h,u,x),T=s?w/b:w*b,E=new t.pointGeometry(x.anchorX,x.anchorY),C=Wt(E,a,v);if(C.signedDistanceFromCamera<=0){ee(x.numGlyphs,_);continue}const S=C.point;let I={};const M=s?null:c,z=Yt(x,T,!1,l,i,a,n,e.glyphOffsetArray,m,_,S,E,I,f,M);g=z.useVertical,M&&z.needsFlipping&&(I={}),(z.notEnoughRoom||g||z.needsFlipping&&Yt(x,T,!0,l,i,a,n,e.glyphOffsetArray,m,_,S,E,I,f,M).notEnoughRoom)&&ee(x.numGlyphs,_);}r?e.text.dynamicLayoutVertexBuffer.updateData(_):e.icon.dynamicLayoutVertexBuffer.updateData(_);}function Ht(t,e,i,o,r,a,n,s,l,c,h,u,d){const _=s.glyphStartIndex+s.numGlyphs,m=s.lineStartIndex,p=s.lineStartIndex+s.lineLength,f=e.getoffsetX(s.glyphStartIndex),g=e.getoffsetX(_-1),x=Qt(t*f,i,o,r,a,n,s.segment,m,p,l,c,h,u,d,!0);if(!x)return null;const v=Qt(t*g,i,o,r,a,n,s.segment,m,p,l,c,h,u,d,!0);return v?{first:x,last:v}:null}function Kt(e,i,o,r){return e===t.WritingMode.horizontal&&Math.abs(o.y-i.y)>Math.abs(o.x-i.x)*r?{useVertical:!0}:(e===t.WritingMode.vertical?i.y<o.y:i.x>o.x)?{needsFlipping:!0}:null}function Yt(e,i,o,r,a,n,s,l,c,h,u,d,_,m,p){const f=i/24,g=e.lineOffsetX*f,x=e.lineOffsetY*f;let v;if(e.numGlyphs>1){const t=e.glyphStartIndex+e.numGlyphs,i=e.lineStartIndex,a=e.lineStartIndex+e.lineLength,h=Ht(f,l,g,x,o,u,d,e,c,n,_,p);if(!h)return {notEnoughRoom:!0};const y=Wt(h.first.point,s).point,b=Wt(h.last.point,s).point;if(r&&!o){const t=Kt(e.writingMode,y,b,m);if(t)return t}v=[h.first];for(let r=e.glyphStartIndex+1;r<t-1;r++)v.push(Qt(f*l.getoffsetX(r),g,x,o,u,d,e.segment,i,a,c,n,_,p));v.push(h.last);}else {if(r&&!o){const i=Wt(d,a).point,o=e.lineStartIndex+e.segment+1,r=new t.pointGeometry(c.getx(o),c.gety(o)),n=Wt(r,a),s=n.signedDistanceFromCamera>0?n.point:Jt(d,r,i,1,a),l=Kt(e.writingMode,i,s,m);if(l)return l}const i=Qt(f*l.getoffsetX(e.glyphStartIndex),g,x,o,u,d,e.segment,e.lineStartIndex,e.lineStartIndex+e.lineLength,c,n,_,p);if(!i)return {notEnoughRoom:!0};v=[i];}for(const e of v)t.addDynamicAttributes(h,e.point,e.angle);return {}}function Jt(t,e,i,o,r,a){const n=t.add(t.sub(e)._unit()),s=Wt(n,r,a?a(n):0).point,l=i.sub(s);return i.add(l._mult(o/l.mag()))}function Qt(e,i,o,r,a,n,s,l,c,h,u,d,_,m,p){const f=r?e-i:e+i;let g=f>0?1:-1,x=0;r&&(g*=-1,x=Math.PI),g<0&&(x+=Math.PI);let v=g>0?l+s:l+s+1,y=a,b=a,w=0,T=0;const E=Math.abs(f),C=[],S=[];let I=n;const M=()=>{const e=v-g;return 0===w?n:new t.pointGeometry(h.getx(e),h.gety(e))},z=()=>Jt(M(),I,b,E-w+1,u,_);for(;w+T<=E;){if(v+=g,v<l||v>=c)return null;if(b=y,C.push(y),m&&S.push(I||M()),y=d[v],void 0===y){I=new t.pointGeometry(h.getx(v),h.gety(v));const e=Wt(I,u,_?_(I):0);y=e.signedDistanceFromCamera>0?d[v]=e.point:z();}else I=null;w+=T,T=b.dist(y);}p&&_&&(I=I||new t.pointGeometry(h.getx(v),h.gety(v)),d[v]=y=void 0===d[v]?y:z(),T=b.dist(y));const P=(E-w)/T,A=y.sub(b),D=A.mult(P)._add(b);o&&D._add(A._unit()._perp()._mult(o*g));const L=x+Math.atan2(y.y-b.y,y.x-b.x);return C.push(D),m&&(I=I||new t.pointGeometry(h.getx(v),h.gety(v)),S.push(function(e,i,o){const r=1-o;return new t.pointGeometry(e.x*r+i.x*o,e.y*r+i.y*o)}(S.length>0?S[S.length-1]:I,I,P))),{point:D,angle:L,path:C,tilePath:S}}const te=new Float32Array([-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0]);function ee(t,e){for(let i=0;i<t;i++){const t=e.length;e.resize(t+4),e.float32.set(te,3*t);}}function ie(t,e,i){const o=e[0],r=e[1];return t[0]=i[0]*o+i[4]*r+i[12],t[1]=i[1]*o+i[5]*r+i[13],t[3]=i[3]*o+i[7]*r+i[15],t}const oe=100;class re{constructor(t,e=new Zt(t.width+200,t.height+200,25),i=new Zt(t.width+200,t.height+200,25)){this.transform=t,this.grid=e,this.ignoredGrid=i,this.pitchfactor=Math.cos(t._pitch)*t.cameraToCenterDistance,this.screenRightBoundary=t.width+oe,this.screenBottomBoundary=t.height+oe,this.gridRightBoundary=t.width+200,this.gridBottomBoundary=t.height+200;}placeCollisionBox(t,e,i,o,r,a,n){const s=this.projectAndGetPerspectiveRatio(a,e.anchorPointX,e.anchorPointY,e.elevation),l=r*s.perspectiveRatio,c=(e.x1*t+i.x-e.padding)*l+s.point.x,h=(e.y1*t+i.y-e.padding)*l+s.point.y,u=(e.x2*t+i.x+e.padding)*l+s.point.x,d=(e.y2*t+i.y+e.padding)*l+s.point.y,_=s.perspectiveRatio<=.55||s.aboveHorizon;return !this.isInsideGrid(c,h,u,d)||!o&&this.grid.hitTest(c,h,u,d,n)||_?{box:[],offscreen:!1}:{box:[c,h,u,d],offscreen:this.isOffscreen(c,h,u,d)}}placeCollisionCircles(e,i,o,r,a,n,s,l,c,h,u,d,_,m){const p=[],f=this.transform.elevation,g=f?t=>f.getAtTileOffset(m,t.x,t.y):t=>0,x=new t.pointGeometry(i.anchorX,i.anchorY),v=g(x),y=this.projectAndGetPerspectiveRatio(n,x.x,x.y,v),{perspectiveRatio:b}=y,w=(h?a/b:a*b)/t.ONE_EM,T=Wt(x,s,v).point,E=y.signedDistanceFromCamera>0?Ht(w,r,i.lineOffsetX*w,i.lineOffsetY*w,!1,T,x,i,o,s,{},f&&!h?g:null,h&&!!f):null;let C=!1,S=!1,I=!0;if(E&&!y.aboveHorizon){const i=.5*d*b+_,o=new t.pointGeometry(-100,-100),r=new t.pointGeometry(this.screenRightBoundary,this.screenBottomBoundary),a=new Gt,n=E.first,s=E.last;let h=[];for(let t=n.path.length-1;t>=1;t--)h.push(n.path[t]);for(let t=1;t<s.path.length;t++)h.push(s.path[t]);const m=2.5*i;if(l){const t=h.map(f?(t,e)=>{const i=g(e<n.path.length-1?n.tilePath[n.path.length-1-e]:s.tilePath[e-n.path.length+2]);return Wt(t,l,i)}:t=>Wt(t,l));h=t.some((t=>t.signedDistanceFromCamera<=0))?[]:t.map((t=>t.point));}let x=[];if(h.length>0){const e=h[0].clone(),i=h[0].clone();for(let t=1;t<h.length;t++)e.x=Math.min(e.x,h[t].x),e.y=Math.min(e.y,h[t].y),i.x=Math.max(i.x,h[t].x),i.y=Math.max(i.y,h[t].y);x=e.x>=o.x&&i.x<=r.x&&e.y>=o.y&&i.y<=r.y?[h]:i.x<o.x||e.x>r.x||i.y<o.y||e.y>r.y?[]:t.clipLine([h],o.x,o.y,r.x,r.y);}for(const t of x){a.reset(t,.25*i);let o=0;o=a.length<=.5*i?1:Math.ceil(a.paddedLength/m)+1;for(let t=0;t<o;t++){const r=t/Math.max(o-1,1),n=a.lerp(r),s=n.x+oe,l=n.y+oe;p.push(s,l,i,0);const h=s-i,d=l-i,_=s+i,m=l+i;if(I=I&&this.isOffscreen(h,d,_,m),S=S||this.isInsideGrid(h,d,_,m),!e&&this.grid.hitTestCircle(s,l,i,u)&&(C=!0,!c))return {circles:[],offscreen:!1,collisionDetected:C}}}}return {circles:!c&&C||!S?[]:p,offscreen:I,collisionDetected:C}}queryRenderedSymbols(e){if(0===e.length||0===this.grid.keysLength()&&0===this.ignoredGrid.keysLength())return {};const i=[];let o=1/0,r=1/0,a=-1/0,n=-1/0;for(const s of e){const e=new t.pointGeometry(s.x+oe,s.y+oe);o=Math.min(o,e.x),r=Math.min(r,e.y),a=Math.max(a,e.x),n=Math.max(n,e.y),i.push(e);}const s=this.grid.query(o,r,a,n).concat(this.ignoredGrid.query(o,r,a,n)),l={},c={};for(const e of s){const o=e.key;if(void 0===l[o.bucketInstanceId]&&(l[o.bucketInstanceId]={}),l[o.bucketInstanceId][o.featureIndex])continue;const r=[new t.pointGeometry(e.x1,e.y1),new t.pointGeometry(e.x2,e.y1),new t.pointGeometry(e.x2,e.y2),new t.pointGeometry(e.x1,e.y2)];t.polygonIntersectsPolygon(i,r)&&(l[o.bucketInstanceId][o.featureIndex]=!0,void 0===c[o.bucketInstanceId]&&(c[o.bucketInstanceId]=[]),c[o.bucketInstanceId].push(o.featureIndex));}return c}insertCollisionBox(t,e,i,o,r){(e?this.ignoredGrid:this.grid).insert({bucketInstanceId:i,featureIndex:o,collisionGroupID:r},t[0],t[1],t[2],t[3]);}insertCollisionCircles(t,e,i,o,r){const a=e?this.ignoredGrid:this.grid,n={bucketInstanceId:i,featureIndex:o,collisionGroupID:r};for(let e=0;e<t.length;e+=4)a.insertCircle(n,t[e],t[e+1],t[e+2]);}projectAndGetPerspectiveRatio(e,i,o,r){const a=[i,o,r||0,1];let n=!1;return r||this.transform.pitch>0?(t.transformMat4(a,a,e),n=a[2]>a[3]):ie(a,a,e),{point:new t.pointGeometry((a[0]/a[3]+1)/2*this.transform.width+oe,(-a[1]/a[3]+1)/2*this.transform.height+oe),perspectiveRatio:Math.min(.5+this.transform.cameraToCenterDistance/a[3]*.5,1.5),signedDistanceFromCamera:a[3],aboveHorizon:n}}isOffscreen(t,e,i,o){return i<oe||t>=this.screenRightBoundary||o<oe||e>this.screenBottomBoundary}isInsideGrid(t,e,i,o){return i>=0&&t<this.gridRightBoundary&&o>=0&&e<this.gridBottomBoundary}getViewportMatrix(){const e=t.identity([]);return t.translate(e,e,[-100,-100,0]),e}}class ae{constructor(t,e,i,o){this.opacity=t?Math.max(0,Math.min(1,t.opacity+(t.placed?e:-e))):o&&i?1:0,this.placed=i;}isHidden(){return 0===this.opacity&&!this.placed}}class ne{constructor(t,e,i,o,r){this.text=new ae(t?t.text:null,e,i,r),this.icon=new ae(t?t.icon:null,e,o,r);}isHidden(){return this.text.isHidden()&&this.icon.isHidden()}}class se{constructor(t,e,i){this.text=t,this.icon=e,this.skipFade=i;}}class le{constructor(){this.invProjMatrix=t.create$1(),this.viewportMatrix=t.create$1(),this.circles=[];}}class ce{constructor(t,e,i,o,r){this.bucketInstanceId=t,this.featureIndex=e,this.sourceLayerIndex=i,this.bucketIndex=o,this.tileID=r;}}class he{constructor(t){this.crossSourceCollisions=t,this.maxGroupID=0,this.collisionGroups={};}get(t){if(this.crossSourceCollisions)return {ID:0,predicate:null};if(!this.collisionGroups[t]){const e=++this.maxGroupID;this.collisionGroups[t]={ID:e,predicate:t=>t.collisionGroupID===e};}return this.collisionGroups[t]}}function ue(e,i,o,r,a){const{horizontalAlign:n,verticalAlign:s}=t.getAnchorAlignment(e),l=-(n-.5)*i,c=-(s-.5)*o,h=t.evaluateVariableOffset(e,r);return new t.pointGeometry(l+h[0]*a,c+h[1]*a)}function de(e,i,o,r,a){const n=new t.pointGeometry(e,i);return o&&n._rotate(r?a:-a),n}class _e{constructor(t,e,i,o){this.transform=t.clone(),this.collisionIndex=new re(this.transform),this.placements={},this.opacities={},this.variableOffsets={},this.stale=!1,this.commitTime=0,this.fadeDuration=e,this.retainedQueryData={},this.collisionGroups=new he(i),this.collisionCircleArrays={},this.prevPlacement=o,o&&(o.prevPlacement=void 0),this.placedOrientations={};}getBucketParts(e,i,o,r){const a=o.getBucket(i),n=o.latestFeatureIndex;if(!a||!n||i.id!==a.layerIds[0])return;const s=o.collisionBoxArray,l=a.layers[0].layout,c=Math.pow(2,this.transform.zoom-o.tileID.overscaledZ),h=o.tileSize/t.EXTENT,u=this.transform.calculatePosMatrix(o.tileID.toUnwrapped()),d="map"===l.get("text-pitch-alignment"),_="map"===l.get("text-rotation-alignment"),m=C(o,1,this.transform.zoom),p=Vt(u,d,_,this.transform,m);let f=null;if(d){const e=qt(u,d,_,this.transform,m);f=t.multiply([],this.transform.labelPlaneMatrix,e);}this.retainedQueryData[a.bucketInstanceId]=new ce(a.bucketInstanceId,n,a.sourceLayerIndex,a.index,o.tileID);const g={bucket:a,layout:l,posMatrix:u,textLabelPlaneMatrix:p,labelToScreenMatrix:f,scale:c,textPixelRatio:h,holdingForFade:o.holdingForFade(),collisionBoxArray:s,partiallyEvaluatedTextSize:t.evaluateSizeForZoom(a.textSizeData,this.transform.zoom),partiallyEvaluatedIconSize:t.evaluateSizeForZoom(a.iconSizeData,this.transform.zoom),collisionGroup:this.collisionGroups.get(a.sourceID)};if(r)for(const t of a.sortKeyRanges){const{sortKey:i,symbolInstanceStart:o,symbolInstanceEnd:r}=t;e.push({sortKey:i,symbolInstanceStart:o,symbolInstanceEnd:r,parameters:g});}else e.push({symbolInstanceStart:0,symbolInstanceEnd:a.symbolInstances.length,parameters:g});}attemptAnchorPlacement(t,e,i,o,r,a,n,s,l,c,h,u,d,_,m,p,f,g){const x=[u.textOffset0,u.textOffset1],v=_.getSymbolInstanceTextSize(f,u,this.transform.zoom,d),y=ue(t,i,o,x,r),b=this.collisionIndex.placeCollisionBox(v,e,de(y.x,y.y,a,n,this.transform.angle),h,s,l,c.predicate);if((!p||0!==this.collisionIndex.placeCollisionBox(_.getSymbolInstanceIconSize(g,this.transform.zoom,d),p,de(y.x,y.y,a,n,this.transform.angle),h,s,l,c.predicate).box.length)&&b.box.length>0){let e;return this.prevPlacement&&this.prevPlacement.variableOffsets[u.crossTileID]&&this.prevPlacement.placements[u.crossTileID]&&this.prevPlacement.placements[u.crossTileID].text&&(e=this.prevPlacement.variableOffsets[u.crossTileID].anchor),this.variableOffsets[u.crossTileID]={textOffset:x,width:i,height:o,anchor:t,textBoxScale:r,prevAnchor:e},this.markUsedJustification(_,t,u,m),_.allowVerticalPlacement&&(this.markUsedOrientation(_,m,u),this.placedOrientations[u.crossTileID]=m),{shift:y,placedGlyphBoxes:b}}}placeLayerBucketPart(e,i,o){const{bucket:r,layout:a,posMatrix:n,textLabelPlaneMatrix:s,labelToScreenMatrix:l,textPixelRatio:c,holdingForFade:h,collisionBoxArray:u,partiallyEvaluatedTextSize:d,partiallyEvaluatedIconSize:_,collisionGroup:m}=e.parameters,p=a.get("text-optional"),f=a.get("icon-optional"),g=a.get("text-allow-overlap"),x=a.get("icon-allow-overlap"),v="map"===a.get("text-rotation-alignment"),y="map"===a.get("text-pitch-alignment"),b="none"!==a.get("icon-text-fit"),w="viewport-y"===a.get("symbol-z-order"),T=g&&(x||!r.hasIconData()||f),E=x&&(g||!r.hasTextData()||p);!r.collisionArrays&&u&&r.deserializeCollisionBoxes(u),o&&r.updateCollisionDebugBuffers(this.transform.zoom,u);const C=(e,u,w)=>{if(i[e.crossTileID])return;if(h)return void(this.placements[e.crossTileID]=new se(!1,!1,!1));let C=!1,S=!1,I=!0,M=null,z={box:null,offscreen:null},P={box:null,offscreen:null},A=null,D=null,L=null,R=0,k=0,B=0;w.textFeatureIndex?R=w.textFeatureIndex:e.useRuntimeCollisionCircles&&(R=e.featureIndex),w.verticalTextFeatureIndex&&(k=w.verticalTextFeatureIndex);const F=t=>{(this.transform.elevation||t.elevation)&&(t.elevation=this.transform.elevation?this.transform.elevation.getAtTileOffset(this.retainedQueryData[r.bucketInstanceId].tileID,t.anchorPointX,t.anchorPointY):0);},O=w.textBox;if(O){F(O);const i=i=>{let o=t.WritingMode.horizontal;if(r.allowVerticalPlacement&&!i&&this.prevPlacement){const t=this.prevPlacement.placedOrientations[e.crossTileID];t&&(this.placedOrientations[e.crossTileID]=t,o=t,this.markUsedOrientation(r,o,e));}return o},o=(i,o)=>{if(r.allowVerticalPlacement&&e.numVerticalGlyphVertices>0&&w.verticalTextBox){for(const e of r.writingModes)if(e===t.WritingMode.vertical?(z=o(),P=z):z=i(),z&&z.box&&z.box.length)break}else z=i();};if(a.get("text-variable-anchor")){let s=a.get("text-variable-anchor");if(this.prevPlacement&&this.prevPlacement.variableOffsets[e.crossTileID]){const t=this.prevPlacement.variableOffsets[e.crossTileID];s.indexOf(t.anchor)>0&&(s=s.filter((e=>e!==t.anchor)),s.unshift(t.anchor));}const l=(t,i,o)=>{const a=e.textBoxScale,l=(t.x2-t.x1)*a+2*t.padding,h=(t.y2-t.y1)*a+2*t.padding,p=b&&!x?i:null;p&&F(p);let f={box:[],offscreen:!1};const w=g?2*s.length:s.length;for(let i=0;i<w;++i){const g=this.attemptAnchorPlacement(s[i%s.length],t,l,h,a,v,y,c,n,m,i>=s.length,e,u,r,o,p,d,_);if(g&&(f=g.placedGlyphBoxes,f&&f.box&&f.box.length)){C=!0,M=g.shift;break}}return f};o((()=>l(O,w.iconBox,t.WritingMode.horizontal)),(()=>{const i=w.verticalTextBox;return i&&F(i),r.allowVerticalPlacement&&!(z&&z.box&&z.box.length)&&e.numVerticalGlyphVertices>0&&i?l(i,w.verticalIconBox,t.WritingMode.vertical):{box:null,offscreen:null}})),z&&(C=z.box,I=z.offscreen);const h=i(z&&z.box);if(!C&&this.prevPlacement){const t=this.prevPlacement.variableOffsets[e.crossTileID];t&&(this.variableOffsets[e.crossTileID]=t,this.markUsedJustification(r,t.anchor,e,h));}}else {const a=(i,o)=>{const a=r.getSymbolInstanceTextSize(d,e,this.transform.zoom,u),s=this.collisionIndex.placeCollisionBox(a,i,new t.pointGeometry(0,0),g,c,n,m.predicate);return s&&s.box&&s.box.length&&(this.markUsedOrientation(r,o,e),this.placedOrientations[e.crossTileID]=o),s};o((()=>a(O,t.WritingMode.horizontal)),(()=>{const i=w.verticalTextBox;return r.allowVerticalPlacement&&e.numVerticalGlyphVertices>0&&i?(F(i),a(i,t.WritingMode.vertical)):{box:null,offscreen:null}})),i(z&&z.box&&z.box.length);}}if(A=z,C=A&&A.box&&A.box.length>0,I=A&&A.offscreen,e.useRuntimeCollisionCircles){const i=r.text.placedSymbolArray.get(e.centerJustifiedTextSymbolIndex),c=t.evaluateSizeForFeature(r.textSizeData,d,i),h=a.get("text-padding");D=this.collisionIndex.placeCollisionCircles(g,i,r.lineVertexArray,r.glyphOffsetArray,c,n,s,l,o,y,m.predicate,e.collisionCircleDiameter,h,this.retainedQueryData[r.bucketInstanceId].tileID),C=g||D.circles.length>0&&!D.collisionDetected,I=I&&D.offscreen;}if(w.iconFeatureIndex&&(B=w.iconFeatureIndex),w.iconBox){const e=e=>{F(e);const i=b&&M?de(M.x,M.y,v,y,this.transform.angle):new t.pointGeometry(0,0),o=r.getSymbolInstanceIconSize(_,this.transform.zoom,u);return this.collisionIndex.placeCollisionBox(o,e,i,x,c,n,m.predicate)};P&&P.box&&P.box.length&&w.verticalIconBox?(L=e(w.verticalIconBox),S=L.box.length>0):(L=e(w.iconBox),S=L.box.length>0),I=I&&L.offscreen;}const U=p||0===e.numHorizontalGlyphVertices&&0===e.numVerticalGlyphVertices,N=f||0===e.numIconVertices;if(U||N?N?U||(S=S&&C):C=S&&C:S=C=S&&C,C&&A&&A.box&&this.collisionIndex.insertCollisionBox(A.box,a.get("text-ignore-placement"),r.bucketInstanceId,P&&P.box&&k?k:R,m.ID),S&&L&&this.collisionIndex.insertCollisionBox(L.box,a.get("icon-ignore-placement"),r.bucketInstanceId,B,m.ID),D&&(C&&this.collisionIndex.insertCollisionCircles(D.circles,a.get("text-ignore-placement"),r.bucketInstanceId,R,m.ID),o)){const t=r.bucketInstanceId;let e=this.collisionCircleArrays[t];void 0===e&&(e=this.collisionCircleArrays[t]=new le);for(let t=0;t<D.circles.length;t+=4)e.circles.push(D.circles[t+0]),e.circles.push(D.circles[t+1]),e.circles.push(D.circles[t+2]),e.circles.push(D.collisionDetected?1:0);}this.placements[e.crossTileID]=new se(C||T,S||E,I||r.justReloaded),i[e.crossTileID]=!0;};if(w){const t=r.getSortedSymbolIndexes(this.transform.angle);for(let e=t.length-1;e>=0;--e){const i=t[e];C(r.symbolInstances.get(i),i,r.collisionArrays[i]);}}else for(let t=e.symbolInstanceStart;t<e.symbolInstanceEnd;t++)C(r.symbolInstances.get(t),t,r.collisionArrays[t]);if(o&&r.bucketInstanceId in this.collisionCircleArrays){const e=this.collisionCircleArrays[r.bucketInstanceId];t.invert(e.invProjMatrix,n),e.viewportMatrix=this.collisionIndex.getViewportMatrix();}r.justReloaded=!1;}markUsedJustification(e,i,o,r){let a;a=r===t.WritingMode.vertical?o.verticalPlacedTextSymbolIndex:{left:o.leftJustifiedTextSymbolIndex,center:o.centerJustifiedTextSymbolIndex,right:o.rightJustifiedTextSymbolIndex}[t.getAnchorJustification(i)];const n=[o.leftJustifiedTextSymbolIndex,o.centerJustifiedTextSymbolIndex,o.rightJustifiedTextSymbolIndex,o.verticalPlacedTextSymbolIndex];for(const t of n)t>=0&&(e.text.placedSymbolArray.get(t).crossTileID=a>=0&&t!==a?0:o.crossTileID);}markUsedOrientation(e,i,o){const r=i===t.WritingMode.horizontal||i===t.WritingMode.horizontalOnly?i:0,a=i===t.WritingMode.vertical?i:0,n=[o.leftJustifiedTextSymbolIndex,o.centerJustifiedTextSymbolIndex,o.rightJustifiedTextSymbolIndex];for(const t of n)e.text.placedSymbolArray.get(t).placedOrientation=r;o.verticalPlacedTextSymbolIndex&&(e.text.placedSymbolArray.get(o.verticalPlacedTextSymbolIndex).placedOrientation=a);}commit(t){this.commitTime=t,this.zoomAtLastRecencyCheck=this.transform.zoom;const e=this.prevPlacement;let i=!1;this.prevZoomAdjustment=e?e.zoomAdjustment(this.transform.zoom):0;const o=e?e.symbolFadeChange(t):1,r=e?e.opacities:{},a=e?e.variableOffsets:{},n=e?e.placedOrientations:{};for(const t in this.placements){const e=this.placements[t],a=r[t];a?(this.opacities[t]=new ne(a,o,e.text,e.icon),i=i||e.text!==a.text.placed||e.icon!==a.icon.placed):(this.opacities[t]=new ne(null,o,e.text,e.icon,e.skipFade),i=i||e.text||e.icon);}for(const t in r){const e=r[t];if(!this.opacities[t]){const r=new ne(e,o,!1,!1);r.isHidden()||(this.opacities[t]=r,i=i||e.text.placed||e.icon.placed);}}for(const t in a)this.variableOffsets[t]||!this.opacities[t]||this.opacities[t].isHidden()||(this.variableOffsets[t]=a[t]);for(const t in n)this.placedOrientations[t]||!this.opacities[t]||this.opacities[t].isHidden()||(this.placedOrientations[t]=n[t]);i?this.lastPlacementChangeTime=t:"number"!=typeof this.lastPlacementChangeTime&&(this.lastPlacementChangeTime=e?e.lastPlacementChangeTime:t);}updateLayerOpacities(t,e){const i={};for(const o of e){const e=o.getBucket(t);e&&o.latestFeatureIndex&&t.id===e.layerIds[0]&&this.updateBucketOpacities(e,i,o.collisionBoxArray);}}updateBucketOpacities(e,i,o){e.hasTextData()&&e.text.opacityVertexArray.clear(),e.hasIconData()&&e.icon.opacityVertexArray.clear(),e.hasIconCollisionBoxData()&&e.iconCollisionBox.collisionVertexArray.clear(),e.hasTextCollisionBoxData()&&e.textCollisionBox.collisionVertexArray.clear();const r=e.layers[0].layout,a=new ne(null,0,!1,!1,!0),n=r.get("text-allow-overlap"),s=r.get("icon-allow-overlap"),l=r.get("text-variable-anchor"),c="map"===r.get("text-rotation-alignment"),h="map"===r.get("text-pitch-alignment"),u="none"!==r.get("icon-text-fit"),d=new ne(null,0,n&&(s||!e.hasIconData()||r.get("icon-optional")),s&&(n||!e.hasTextData()||r.get("text-optional")),!0);!e.collisionArrays&&o&&(e.hasIconCollisionBoxData()||e.hasTextCollisionBoxData())&&e.deserializeCollisionBoxes(o);const _=(t,e,i)=>{for(let o=0;o<e/4;o++)t.opacityVertexArray.emplaceBack(i);};for(let o=0;o<e.symbolInstances.length;o++){const r=e.symbolInstances.get(o),{numHorizontalGlyphVertices:n,numVerticalGlyphVertices:s,crossTileID:m}=r;let p=this.opacities[m];i[m]?p=a:p||(p=d,this.opacities[m]=p),i[m]=!0;const f=r.numIconVertices>0,g=this.placedOrientations[r.crossTileID],x=g===t.WritingMode.vertical,v=g===t.WritingMode.horizontal||g===t.WritingMode.horizontalOnly;if(n>0||s>0){const t=we(p.text);_(e.text,n,x?Te:t),_(e.text,s,v?Te:t);const i=p.text.isHidden();[r.rightJustifiedTextSymbolIndex,r.centerJustifiedTextSymbolIndex,r.leftJustifiedTextSymbolIndex].forEach((t=>{t>=0&&(e.text.placedSymbolArray.get(t).hidden=i||x?1:0);})),r.verticalPlacedTextSymbolIndex>=0&&(e.text.placedSymbolArray.get(r.verticalPlacedTextSymbolIndex).hidden=i||v?1:0);const o=this.variableOffsets[r.crossTileID];o&&this.markUsedJustification(e,o.anchor,r,g);const a=this.placedOrientations[r.crossTileID];a&&(this.markUsedJustification(e,"left",r,a),this.markUsedOrientation(e,a,r));}if(f){const t=we(p.icon),i=!(u&&r.verticalPlacedIconSymbolIndex&&x);r.placedIconSymbolIndex>=0&&(_(e.icon,r.numIconVertices,i?t:Te),e.icon.placedSymbolArray.get(r.placedIconSymbolIndex).hidden=p.icon.isHidden()),r.verticalPlacedIconSymbolIndex>=0&&(_(e.icon,r.numVerticalIconVertices,i?Te:t),e.icon.placedSymbolArray.get(r.verticalPlacedIconSymbolIndex).hidden=p.icon.isHidden());}if(e.hasIconCollisionBoxData()||e.hasTextCollisionBoxData()){const i=e.collisionArrays[o];if(i){let o=new t.pointGeometry(0,0);if(i.textBox||i.verticalTextBox){let t=!0;if(l){const e=this.variableOffsets[m];e?(o=ue(e.anchor,e.width,e.height,e.textOffset,e.textBoxScale),c&&o._rotate(h?this.transform.angle:-this.transform.angle)):t=!1;}i.textBox&&me(e.textCollisionBox.collisionVertexArray,p.text.placed,!t||x,o.x,o.y),i.verticalTextBox&&me(e.textCollisionBox.collisionVertexArray,p.text.placed,!t||v,o.x,o.y);}const r=Boolean(!v&&i.verticalIconBox);i.iconBox&&me(e.iconCollisionBox.collisionVertexArray,p.icon.placed,r,u?o.x:0,u?o.y:0),i.verticalIconBox&&me(e.iconCollisionBox.collisionVertexArray,p.icon.placed,!r,u?o.x:0,u?o.y:0);}}}if(e.sortFeatures(this.transform.angle),this.retainedQueryData[e.bucketInstanceId]&&(this.retainedQueryData[e.bucketInstanceId].featureSortOrder=e.featureSortOrder),e.hasTextData()&&e.text.opacityVertexBuffer&&e.text.opacityVertexBuffer.updateData(e.text.opacityVertexArray),e.hasIconData()&&e.icon.opacityVertexBuffer&&e.icon.opacityVertexBuffer.updateData(e.icon.opacityVertexArray),e.hasIconCollisionBoxData()&&e.iconCollisionBox.collisionVertexBuffer&&e.iconCollisionBox.collisionVertexBuffer.updateData(e.iconCollisionBox.collisionVertexArray),e.hasTextCollisionBoxData()&&e.textCollisionBox.collisionVertexBuffer&&e.textCollisionBox.collisionVertexBuffer.updateData(e.textCollisionBox.collisionVertexArray),e.bucketInstanceId in this.collisionCircleArrays){const t=this.collisionCircleArrays[e.bucketInstanceId];e.placementInvProjMatrix=t.invProjMatrix,e.placementViewportMatrix=t.viewportMatrix,e.collisionCircleArray=t.circles,delete this.collisionCircleArrays[e.bucketInstanceId];}}symbolFadeChange(t){return 0===this.fadeDuration?1:(t-this.commitTime)/this.fadeDuration+this.prevZoomAdjustment}zoomAdjustment(t){return Math.max(0,(this.transform.zoom-t)/1.5)}hasTransitions(t){return this.stale||t-this.lastPlacementChangeTime<this.fadeDuration}stillRecent(t,e){const i=this.zoomAtLastRecencyCheck===e?1-this.zoomAdjustment(e):1;return this.zoomAtLastRecencyCheck=e,this.commitTime+this.fadeDuration*i>t}setStale(){this.stale=!0;}}function me(t,e,i,o,r){t.emplaceBack(e?1:0,i?1:0,o||0,r||0),t.emplaceBack(e?1:0,i?1:0,o||0,r||0),t.emplaceBack(e?1:0,i?1:0,o||0,r||0),t.emplaceBack(e?1:0,i?1:0,o||0,r||0);}const pe=Math.pow(2,25),fe=Math.pow(2,24),ge=Math.pow(2,17),xe=Math.pow(2,16),ve=Math.pow(2,9),ye=Math.pow(2,8),be=Math.pow(2,1);function we(t){if(0===t.opacity&&!t.placed)return 0;if(1===t.opacity&&t.placed)return 4294967295;const e=t.placed?1:0,i=Math.floor(127*t.opacity);return i*pe+e*fe+i*ge+e*xe+i*ve+e*ye+i*be+e}const Te=0;class Ee{constructor(t){this._sortAcrossTiles="viewport-y"!==t.layout.get("symbol-z-order")&&void 0!==t.layout.get("symbol-sort-key").constantOr(1),this._currentTileIndex=0,this._currentPartIndex=0,this._seenCrossTileIDs={},this._bucketParts=[];}continuePlacement(t,e,i,o,r){const a=this._bucketParts;for(;this._currentTileIndex<t.length;)if(e.getBucketParts(a,o,t[this._currentTileIndex],this._sortAcrossTiles),this._currentTileIndex++,r())return !0;for(this._sortAcrossTiles&&(this._sortAcrossTiles=!1,a.sort(((t,e)=>t.sortKey-e.sortKey)));this._currentPartIndex<a.length;)if(e.placeLayerBucketPart(a[this._currentPartIndex],this._seenCrossTileIDs,i),this._currentPartIndex++,r())return !0;return !1}}class Ce{constructor(t,e,i,o,r,a,n){this.placement=new _e(t,r,a,n),this._currentPlacementIndex=e.length-1,this._forceFullPlacement=i,this._showCollisionBoxes=o,this._done=!1;}isDone(){return this._done}continuePlacement(e,i,o){const r=t.exported.now(),a=()=>{const e=t.exported.now()-r;return !this._forceFullPlacement&&e>2};for(;this._currentPlacementIndex>=0;){const t=i[e[this._currentPlacementIndex]],r=this.placement.collisionIndex.transform.zoom;if("symbol"===t.type&&(!t.minzoom||t.minzoom<=r)&&(!t.maxzoom||t.maxzoom>r)){if(this._inProgressLayer||(this._inProgressLayer=new Ee(t)),this._inProgressLayer.continuePlacement(o[t.source],this.placement,this._showCollisionBoxes,t,a))return;delete this._inProgressLayer;}this._currentPlacementIndex--;}this._done=!0;}commit(t){return this.placement.commit(t),this.placement}}const Se=512/t.EXTENT/2;class Ie{constructor(t,e,i){this.tileID=t,this.indexedSymbolInstances={},this.bucketInstanceId=i;for(let i=0;i<e.length;i++){const o=e.get(i),r=o.key;this.indexedSymbolInstances[r]||(this.indexedSymbolInstances[r]=[]),this.indexedSymbolInstances[r].push({crossTileID:o.crossTileID,coord:this.getScaledCoordinates(o,t)});}}getScaledCoordinates(e,i){const o=Se/Math.pow(2,i.canonical.z-this.tileID.canonical.z);return {x:Math.floor((i.canonical.x*t.EXTENT+e.anchorX)*o),y:Math.floor((i.canonical.y*t.EXTENT+e.anchorY)*o)}}findMatches(t,e,i){const o=this.tileID.canonical.z<e.canonical.z?1:Math.pow(2,this.tileID.canonical.z-e.canonical.z);for(let r=0;r<t.length;r++){const a=t.get(r);if(a.crossTileID)continue;const n=this.indexedSymbolInstances[a.key];if(!n)continue;const s=this.getScaledCoordinates(a,e);for(const t of n)if(Math.abs(t.coord.x-s.x)<=o&&Math.abs(t.coord.y-s.y)<=o&&!i[t.crossTileID]){i[t.crossTileID]=!0,a.crossTileID=t.crossTileID;break}}}}class Me{constructor(){this.maxCrossTileID=0;}generate(){return ++this.maxCrossTileID}}class ze{constructor(){this.indexes={},this.usedCrossTileIDs={},this.lng=0;}handleWrapJump(t){const e=Math.round((t-this.lng)/360);if(0!==e)for(const t in this.indexes){const i=this.indexes[t],o={};for(const t in i){const r=i[t];r.tileID=r.tileID.unwrapTo(r.tileID.wrap+e),o[r.tileID.key]=r;}this.indexes[t]=o;}this.lng=t;}addBucket(t,e,i){if(this.indexes[t.overscaledZ]&&this.indexes[t.overscaledZ][t.key]){if(this.indexes[t.overscaledZ][t.key].bucketInstanceId===e.bucketInstanceId)return !1;this.removeBucketCrossTileIDs(t.overscaledZ,this.indexes[t.overscaledZ][t.key]);}for(let t=0;t<e.symbolInstances.length;t++)e.symbolInstances.get(t).crossTileID=0;this.usedCrossTileIDs[t.overscaledZ]||(this.usedCrossTileIDs[t.overscaledZ]={});const o=this.usedCrossTileIDs[t.overscaledZ];for(const i in this.indexes){const r=this.indexes[i];if(Number(i)>t.overscaledZ)for(const i in r){const a=r[i];a.tileID.isChildOf(t)&&a.findMatches(e.symbolInstances,t,o);}else {const a=r[t.scaledTo(Number(i)).key];a&&a.findMatches(e.symbolInstances,t,o);}}for(let t=0;t<e.symbolInstances.length;t++){const r=e.symbolInstances.get(t);r.crossTileID||(r.crossTileID=i.generate(),o[r.crossTileID]=!0);}return void 0===this.indexes[t.overscaledZ]&&(this.indexes[t.overscaledZ]={}),this.indexes[t.overscaledZ][t.key]=new Ie(t,e.symbolInstances,e.bucketInstanceId),!0}removeBucketCrossTileIDs(t,e){for(const i in e.indexedSymbolInstances)for(const o of e.indexedSymbolInstances[i])delete this.usedCrossTileIDs[t][o.crossTileID];}removeStaleBuckets(t){let e=!1;for(const i in this.indexes){const o=this.indexes[i];for(const r in o)t[o[r].bucketInstanceId]||(this.removeBucketCrossTileIDs(i,o[r]),delete o[r],e=!0);}return e}}class Pe{constructor(){this.layerIndexes={},this.crossTileIDs=new Me,this.maxBucketInstanceId=0,this.bucketsInCurrentPlacement={};}addLayer(t,e,i){let o=this.layerIndexes[t.id];void 0===o&&(o=this.layerIndexes[t.id]=new ze);let r=!1;const a={};o.handleWrapJump(i);for(const i of e){const e=i.getBucket(t);e&&t.id===e.layerIds[0]&&(e.bucketInstanceId||(e.bucketInstanceId=++this.maxBucketInstanceId),o.addBucket(i.tileID,e,this.crossTileIDs)&&(r=!0),a[e.bucketInstanceId]=!0);}return o.removeStaleBuckets(a)&&(r=!0),r}pruneUnusedLayers(t){const e={};t.forEach((t=>{e[t]=!0;}));for(const t in this.layerIndexes)e[t]||delete this.layerIndexes[t];}}const Ae=(e,i)=>t.emitValidationErrors(e,i&&i.filter((t=>"source.canvas"!==t.identifier))),De=t.pick(Lt,["addLayer","removeLayer","setPaintProperty","setLayoutProperty","setFilter","addSource","removeSource","setLayerZoomRange","setLight","setTransition","setGeoJSONSourceData","setTerrain"]),Le=t.pick(Lt,["setCenter","setZoom","setBearing","setPitch"]),Re=function(){const e={},i=t.spec.$version;for(const o in t.spec.$root){const r=t.spec.$root[o];if(r.required){let t=null;t="version"===o?i:"array"===r.type?[]:{},null!=t&&(e[o]=t);}}return e}(),ke={fill:!0,line:!0,background:!0,hillshade:!0,raster:!0};class Be extends t.Evented{constructor(e,i={}){super(),this.map=e,this.dispatcher=new E(Pt(),this),this.imageManager=new f,this.imageManager.setEventedParent(this),this.glyphManager=new t.GlyphManager(e._requestManager,i.localFontFamily?t.LocalGlyphMode.all:i.localIdeographFontFamily?t.LocalGlyphMode.ideographs:t.LocalGlyphMode.none,i.localFontFamily||i.localIdeographFontFamily),this.lineAtlas=new T(256,512),this.crossTileSymbolIndex=new Pe,this._layers={},this._num3DLayers=0,this._numSymbolLayers=0,this._numCircleLayers=0,this._serializedLayers={},this._sourceCaches={},this._otherSourceCaches={},this._symbolSourceCaches={},this.zoomHistory=new t.ZoomHistory,this._loaded=!1,this._availableImages=[],this._order=[],this._drapedFirstOrder=[],this._resetUpdates(),this.dispatcher.broadcast("setReferrer",t.getReferrer());const o=this;this._rtlTextPluginCallback=Be.registerForPluginStateChange((e=>{o.dispatcher.broadcast("syncRTLPluginState",{pluginStatus:e.pluginStatus,pluginURL:e.pluginURL},((e,i)=>{if(t.triggerPluginCompletionEvent(e),i&&i.every((t=>t)))for(const t in o._sourceCaches){const e=o._sourceCaches[t],i=e.getSource().type;"vector"!==i&&"geojson"!==i||e.reload();}}));})),this.on("data",(t=>{if("source"!==t.dataType||"metadata"!==t.sourceDataType)return;const e=this.getSource(t.sourceId);if(e&&e.vectorLayerIds)for(const t in this._layers){const i=this._layers[t];i.source===e.id&&this._validateLayer(i);}}));}loadURL(e,i={}){this.fire(new t.Event("dataloading",{dataType:"style"}));const o="boolean"==typeof i.validate?i.validate:!t.isMapboxURL(e);e=this.map._requestManager.normalizeStyleURL(e,i.accessToken);const r=this.map._requestManager.transformRequest(e,t.ResourceType.Style);this._request=t.getJSON(r,((e,i)=>{this._request=null,e?this.fire(new t.ErrorEvent(e)):i&&this._load(i,o);}));}loadJSON(e,i={}){this.fire(new t.Event("dataloading",{dataType:"style"})),this._request=t.exported.frame((()=>{this._request=null,this._load(e,!1!==i.validate);}));}loadEmpty(){this.fire(new t.Event("dataloading",{dataType:"style"})),this._load(Re,!1);}_updateLayerCount(t,e){const i=e?1:-1;t.is3D()&&(this._num3DLayers+=i),"circle"===t.type&&(this._numCircleLayers+=i),"symbol"===t.type&&(this._numSymbolLayers+=i);}_load(e,i){if(i&&Ae(this,t.validateStyle(e)))return;this._loaded=!0,this.stylesheet=e;for(const t in e.sources)this.addSource(t,e.sources[t],{validate:!1});this._changed=!1,e.sprite?this._loadSprite(e.sprite):(this.imageManager.setLoaded(!0),this.dispatcher.broadcast("spriteLoaded",!0)),this.glyphManager.setURL(e.glyphs);const o=Dt(this.stylesheet.layers);this._order=o.map((t=>t.id)),this._layers={},this._serializedLayers={};for(let e of o)e=t.createStyleLayer(e),e.setEventedParent(this,{layer:{id:e.id}}),this._layers[e.id]=e,this._serializedLayers[e.id]=e.serialize(),this._updateLayerCount(e,!0);this.dispatcher.broadcast("setLayers",this._serializeLayers(this._order)),this.light=new v(this.stylesheet.light),this.stylesheet.terrain&&this._createTerrain(this.stylesheet.terrain),this._updateDrapeFirstLayers(),this.fire(new t.Event("data",{dataType:"style"})),this.fire(new t.Event("style.load"));}_loadSprite(e){this._spriteRequest=function(e,i,o){let r,a,n;const s=t.exported.devicePixelRatio>1?"@2x":"";let l=t.getJSON(i.transformRequest(i.normalizeSpriteURL(e,s,".json"),t.ResourceType.SpriteJSON),((t,e)=>{l=null,n||(n=t,r=e,h());})),c=t.getImage(i.transformRequest(i.normalizeSpriteURL(e,s,".png"),t.ResourceType.SpriteImage),((t,e)=>{c=null,n||(n=t,a=e,h());}));function h(){if(n)o(n);else if(r&&a){const e=t.exported.getImageData(a),i={};for(const o in r){const{width:a,height:n,x:s,y:l,sdf:c,pixelRatio:h,stretchX:u,stretchY:d,content:_}=r[o],m=new t.RGBAImage({width:a,height:n});t.RGBAImage.copy(e,m,{x:s,y:l},{x:0,y:0},{width:a,height:n}),i[o]={data:m,pixelRatio:h,sdf:c,stretchX:u,stretchY:d,content:_};}o(null,i);}}return {cancel(){l&&(l.cancel(),l=null),c&&(c.cancel(),c=null);}}}(e,this.map._requestManager,((e,i)=>{if(this._spriteRequest=null,e)this.fire(new t.ErrorEvent(e));else if(i)for(const t in i)this.imageManager.addImage(t,i[t]);this.imageManager.setLoaded(!0),this._availableImages=this.imageManager.listImages(),this.dispatcher.broadcast("setImages",this._availableImages),this.dispatcher.broadcast("spriteLoaded",!0),this.fire(new t.Event("data",{dataType:"style"}));}));}_validateLayer(e){const i=this.getSource(e.source);if(!i)return;const o=e.sourceLayer;o&&("geojson"===i.type||i.vectorLayerIds&&-1===i.vectorLayerIds.indexOf(o))&&this.fire(new t.ErrorEvent(new Error(`Source layer "${o}" does not exist on source "${i.id}" as specified by style layer "${e.id}"`)));}loaded(){if(!this._loaded)return !1;if(Object.keys(this._updatedSources).length)return !1;for(const t in this._sourceCaches)if(!this._sourceCaches[t].loaded())return !1;return !!this.imageManager.isLoaded()}_serializeLayers(t){const e=[];for(const i of t){const t=this._layers[i];"custom"!==t.type&&e.push(t.serialize());}return e}hasTransitions(){if(this.light&&this.light.hasTransition())return !0;for(const t in this._sourceCaches)if(this._sourceCaches[t].hasTransition())return !0;for(const t in this._layers)if(this._layers[t].hasTransition())return !0;return !1}get order(){return this.map._optimizeForTerrain&&this.terrain?this._drapedFirstOrder:this._order}isLayerDraped(t){return !!this.terrain&&ke[t.type]}_checkLoaded(){if(!this._loaded)throw new Error("Style is not done loading")}update(e){if(!this._loaded)return;const i=this._changed;if(this._changed){const t=Object.keys(this._updatedLayers),i=Object.keys(this._removedLayers);(t.length||i.length)&&this._updateWorkerLayers(t,i);for(const t in this._updatedSources){const e=this._updatedSources[t];"reload"===e?this._reloadSource(t):"clear"===e&&this._clearSource(t);}this._updateTilesForChangedImages();for(const t in this._updatedPaintProps)this._layers[t].updateTransitions(e);this.light.updateTransitions(e),this._resetUpdates();}const o={};for(const t in this._sourceCaches){const e=this._sourceCaches[t];o[t]=e.used,e.used=!1;}for(const t of this._order){const i=this._layers[t];if(i.recalculate(e,this._availableImages),!i.isHidden(e.zoom)){const t=this._getLayerSourceCache(i);t&&(t.used=!0);}const o=this.map.painter;if(o){const t=i.getProgramIds();if(!t)continue;const r=i.getProgramConfiguration(e.zoom);for(const e of t)o.useProgram(e,r);}}for(const e in o){const i=this._sourceCaches[e];o[e]!==i.used&&i.getSource().fire(new t.Event("data",{sourceDataType:"visibility",dataType:"source",sourceId:i.getSource().id}));}this.light.recalculate(e),this.terrain&&this.terrain.recalculate(e),this.z=e.zoom,i&&this.fire(new t.Event("data",{dataType:"style"}));}_updateTilesForChangedImages(){const t=Object.keys(this._changedImages);if(t.length){for(const e in this._sourceCaches)this._sourceCaches[e].reloadTilesForDependencies(["icons","patterns"],t);this._changedImages={};}}_updateWorkerLayers(t,e){this.dispatcher.broadcast("updateLayers",{layers:this._serializeLayers(t),removedIds:e});}_resetUpdates(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSources={},this._updatedPaintProps={},this._changedImages={};}setState(e){if(this._checkLoaded(),Ae(this,t.validateStyle(e)))return !1;(e=t.clone$2(e)).layers=Dt(e.layers);const i=function(t,e){if(!t)return [{command:Lt.setStyle,args:[e]}];let i=[];try{if(!r(t.version,e.version))return [{command:Lt.setStyle,args:[e]}];r(t.center,e.center)||i.push({command:Lt.setCenter,args:[e.center]}),r(t.zoom,e.zoom)||i.push({command:Lt.setZoom,args:[e.zoom]}),r(t.bearing,e.bearing)||i.push({command:Lt.setBearing,args:[e.bearing]}),r(t.pitch,e.pitch)||i.push({command:Lt.setPitch,args:[e.pitch]}),r(t.sprite,e.sprite)||i.push({command:Lt.setSprite,args:[e.sprite]}),r(t.glyphs,e.glyphs)||i.push({command:Lt.setGlyphs,args:[e.glyphs]}),r(t.transition,e.transition)||i.push({command:Lt.setTransition,args:[e.transition]}),r(t.light,e.light)||i.push({command:Lt.setLight,args:[e.light]});const o={},a=[];!function(t,e,i,o){let a;for(a in e=e||{},t=t||{})t.hasOwnProperty(a)&&(e.hasOwnProperty(a)||kt(a,i,o));for(a in e)e.hasOwnProperty(a)&&(t.hasOwnProperty(a)?r(t[a],e[a])||("geojson"===t[a].type&&"geojson"===e[a].type&&Ft(t,e,a)?i.push({command:Lt.setGeoJSONSourceData,args:[a,e[a].data]}):Bt(a,e,i,o)):Rt(a,e,i));}(t.sources,e.sources,a,o);const n=[];t.layers&&t.layers.forEach((t=>{o[t.source]?i.push({command:Lt.removeLayer,args:[t.id]}):n.push(t);}));let s=t.terrain;s&&o[s.source]&&(i.push({command:Lt.setTerrain,args:[void 0]}),s=void 0),i=i.concat(a),r(s,e.terrain)||i.push({command:Lt.setTerrain,args:[e.terrain]}),function(t,e,i){e=e||[];const o=(t=t||[]).map(Ut),a=e.map(Ut),n=t.reduce(Nt,{}),s=e.reduce(Nt,{}),l=o.slice(),c=Object.create(null);let h,u,d,_,m,p,f;for(h=0,u=0;h<o.length;h++)d=o[h],s.hasOwnProperty(d)?u++:(i.push({command:Lt.removeLayer,args:[d]}),l.splice(l.indexOf(d,u),1));for(h=0,u=0;h<a.length;h++)d=a[a.length-1-h],l[l.length-1-h]!==d&&(n.hasOwnProperty(d)?(i.push({command:Lt.removeLayer,args:[d]}),l.splice(l.lastIndexOf(d,l.length-u),1)):u++,p=l[l.length-h],i.push({command:Lt.addLayer,args:[s[d],p]}),l.splice(l.length-h,0,d),c[d]=!0);for(h=0;h<a.length;h++)if(d=a[h],_=n[d],m=s[d],!c[d]&&!r(_,m))if(r(_.source,m.source)&&r(_["source-layer"],m["source-layer"])&&r(_.type,m.type)){for(f in Ot(_.layout,m.layout,i,d,null,Lt.setLayoutProperty),Ot(_.paint,m.paint,i,d,null,Lt.setPaintProperty),r(_.filter,m.filter)||i.push({command:Lt.setFilter,args:[d,m.filter]}),r(_.minzoom,m.minzoom)&&r(_.maxzoom,m.maxzoom)||i.push({command:Lt.setLayerZoomRange,args:[d,m.minzoom,m.maxzoom]}),_)_.hasOwnProperty(f)&&"layout"!==f&&"paint"!==f&&"filter"!==f&&"metadata"!==f&&"minzoom"!==f&&"maxzoom"!==f&&(0===f.indexOf("paint.")?Ot(_[f],m[f],i,d,f.slice(6),Lt.setPaintProperty):r(_[f],m[f])||i.push({command:Lt.setLayerProperty,args:[d,f,m[f]]}));for(f in m)m.hasOwnProperty(f)&&!_.hasOwnProperty(f)&&"layout"!==f&&"paint"!==f&&"filter"!==f&&"metadata"!==f&&"minzoom"!==f&&"maxzoom"!==f&&(0===f.indexOf("paint.")?Ot(_[f],m[f],i,d,f.slice(6),Lt.setPaintProperty):r(_[f],m[f])||i.push({command:Lt.setLayerProperty,args:[d,f,m[f]]}));}else i.push({command:Lt.removeLayer,args:[d]}),p=l[l.lastIndexOf(d)+1],i.push({command:Lt.addLayer,args:[m,p]});}(n,e.layers,i);}catch(t){console.warn("Unable to compute style diff:",t),i=[{command:Lt.setStyle,args:[e]}];}return i}(this.serialize(),e).filter((t=>!(t.command in Le)));if(0===i.length)return !1;const o=i.filter((t=>!(t.command in De)));if(o.length>0)throw new Error(`Unimplemented: ${o.map((t=>t.command)).join(", ")}.`);return i.forEach((t=>{"setTransition"!==t.command&&this[t.command].apply(this,t.args);})),this.stylesheet=e,!0}addImage(e,i){if(this.getImage(e))return this.fire(new t.ErrorEvent(new Error("An image with this name already exists.")));this.imageManager.addImage(e,i),this._afterImageUpdated(e);}updateImage(t,e){this.imageManager.updateImage(t,e);}getImage(t){return this.imageManager.getImage(t)}removeImage(e){if(!this.getImage(e))return this.fire(new t.ErrorEvent(new Error("No image with this name exists.")));this.imageManager.removeImage(e),this._afterImageUpdated(e);}_afterImageUpdated(e){this._availableImages=this.imageManager.listImages(),this._changedImages[e]=!0,this._changed=!0,this.dispatcher.broadcast("setImages",this._availableImages),this.fire(new t.Event("data",{dataType:"style"}));}listImages(){return this._checkLoaded(),this.imageManager.listImages()}addSource(e,i,o={}){if(this._checkLoaded(),void 0!==this.getSource(e))throw new Error("There is already a source with this ID");if(!i.type)throw new Error(`The type property must be defined, but only the following properties were given: ${Object.keys(i).join(", ")}.`);if(["vector","raster","geojson","video","image"].indexOf(i.type)>=0&&this._validate(t.validateStyle.source,`sources.${e}`,i,null,o))return;this.map&&this.map._collectResourceTiming&&(i.collectResourceTiming=!0);const r=bt(e,i,this.dispatcher,this);r.setEventedParent(this,(()=>({isSourceLoaded:this.loaded(),source:r.serialize(),sourceId:e})));const a=i=>{const o=(i?"symbol:":"other:")+e,a=this._sourceCaches[o]=new t.SourceCache(o,r,i);(i?this._symbolSourceCaches:this._otherSourceCaches)[e]=a,a.style=this,a.onAdd(this.map);};a(!1),"vector"!==i.type&&"geojson"!==i.type||a(!0),r.onAdd&&r.onAdd(this.map),this._changed=!0;}removeSource(e){this._checkLoaded();const i=this.getSource(e);if(void 0===i)throw new Error("There is no source with this ID");for(const i in this._layers)if(this._layers[i].source===e)return this.fire(new t.ErrorEvent(new Error(`Source "${e}" cannot be removed while layer "${i}" is using it.`)));if(this.terrain&&this.terrain.get().source===e)return this.fire(new t.ErrorEvent(new Error(`Source "${e}" cannot be removed while terrain is using it.`)));const o=this._getSourceCaches(e);for(const e of o)delete this._sourceCaches[e.id],delete this._updatedSources[e.id],e.fire(new t.Event("data",{sourceDataType:"metadata",dataType:"source",sourceId:e.getSource().id})),e.setEventedParent(null),e.clearTiles();delete this._otherSourceCaches[e],delete this._symbolSourceCaches[e],i.setEventedParent(null),i.onRemove&&i.onRemove(this.map),this._changed=!0;}setGeoJSONSourceData(t,e){this._checkLoaded(),this.getSource(t).setData(e),this._changed=!0;}getSource(t){const e=this._getSourceCache(t);return e&&e.getSource()}addLayer(e,i,o={}){this._checkLoaded();const r=e.id;if(this.getLayer(r))return void this.fire(new t.ErrorEvent(new Error(`Layer with id "${r}" already exists on this map`)));let a;if("custom"===e.type){if(Ae(this,t.validateCustomStyleLayer(e)))return;a=t.createStyleLayer(e);}else {if("object"==typeof e.source&&(this.addSource(r,e.source),e=t.clone$2(e),e=t.extend(e,{source:r})),this._validate(t.validateStyle.layer,`layers.${r}`,e,{arrayIndex:-1},o))return;a=t.createStyleLayer(e),this._validateLayer(a),a.setEventedParent(this,{layer:{id:r}}),this._serializedLayers[a.id]=a.serialize(),this._updateLayerCount(a,!0);}const n=i?this._order.indexOf(i):this._order.length;if(i&&-1===n)return void this.fire(new t.ErrorEvent(new Error(`Layer with id "${i}" does not exist on this map.`)));this._order.splice(n,0,r),this._layerOrderChanged=!0,this._layers[r]=a;const s=this._getLayerSourceCache(a);if(this._removedLayers[r]&&a.source&&s&&"custom"!==a.type){const t=this._removedLayers[r];delete this._removedLayers[r],t.type!==a.type?this._updatedSources[a.source]="clear":(this._updatedSources[a.source]="reload",s.pause());}this._updateLayer(a),a.onAdd&&a.onAdd(this.map),this._updateDrapeFirstLayers();}moveLayer(e,i){if(this._checkLoaded(),this._changed=!0,!this._layers[e])return void this.fire(new t.ErrorEvent(new Error(`The layer '${e}' does not exist in the map's style and cannot be moved.`)));if(e===i)return;const o=this._order.indexOf(e);this._order.splice(o,1);const r=i?this._order.indexOf(i):this._order.length;i&&-1===r?this.fire(new t.ErrorEvent(new Error(`Layer with id "${i}" does not exist on this map.`))):(this._order.splice(r,0,e),this._layerOrderChanged=!0,this._updateDrapeFirstLayers());}removeLayer(e){this._checkLoaded();const i=this._layers[e];if(!i)return void this.fire(new t.ErrorEvent(new Error(`The layer '${e}' does not exist in the map's style and cannot be removed.`)));i.setEventedParent(null),this._updateLayerCount(i,!1);const o=this._order.indexOf(e);this._order.splice(o,1),this._layerOrderChanged=!0,this._changed=!0,this._removedLayers[e]=i,delete this._layers[e],delete this._serializedLayers[e],delete this._updatedLayers[e],delete this._updatedPaintProps[e],i.onRemove&&i.onRemove(this.map),this._updateDrapeFirstLayers();}getLayer(t){return this._layers[t]}hasLayer(t){return t in this._layers}hasLayerType(t){for(const e in this._layers)if(this._layers[e].type===t)return !0;return !1}setLayerZoomRange(e,i,o){this._checkLoaded();const r=this.getLayer(e);r?r.minzoom===i&&r.maxzoom===o||(null!=i&&(r.minzoom=i),null!=o&&(r.maxzoom=o),this._updateLayer(r)):this.fire(new t.ErrorEvent(new Error(`The layer '${e}' does not exist in the map's style and cannot have zoom extent.`)));}setFilter(e,i,o={}){this._checkLoaded();const a=this.getLayer(e);if(a){if(!r(a.filter,i))return null==i?(a.filter=void 0,void this._updateLayer(a)):void(this._validate(t.validateStyle.filter,`layers.${a.id}.filter`,i,null,o)||(a.filter=t.clone$2(i),this._updateLayer(a)))}else this.fire(new t.ErrorEvent(new Error(`The layer '${e}' does not exist in the map's style and cannot be filtered.`)));}getFilter(e){return t.clone$2(this.getLayer(e).filter)}setLayoutProperty(e,i,o,a={}){this._checkLoaded();const n=this.getLayer(e);n?r(n.getLayoutProperty(i),o)||(n.setLayoutProperty(i,o,a),this._updateLayer(n)):this.fire(new t.ErrorEvent(new Error(`The layer '${e}' does not exist in the map's style and cannot be styled.`)));}getLayoutProperty(e,i){const o=this.getLayer(e);if(o)return o.getLayoutProperty(i);this.fire(new t.ErrorEvent(new Error(`The layer '${e}' does not exist in the map's style.`)));}setPaintProperty(e,i,o,a={}){this._checkLoaded();const n=this.getLayer(e);n?r(n.getPaintProperty(i),o)||(n.setPaintProperty(i,o,a)&&this._updateLayer(n),this._changed=!0,this._updatedPaintProps[e]=!0):this.fire(new t.ErrorEvent(new Error(`The layer '${e}' does not exist in the map's style and cannot be styled.`)));}getPaintProperty(t,e){return this.getLayer(t).getPaintProperty(e)}setFeatureState(e,i){this._checkLoaded();const o=e.source,r=e.sourceLayer,a=this.getSource(o);if(void 0===a)return void this.fire(new t.ErrorEvent(new Error(`The source '${o}' does not exist in the map's style.`)));const n=a.type;if("geojson"===n&&r)return void this.fire(new t.ErrorEvent(new Error("GeoJSON sources cannot have a sourceLayer parameter.")));if("vector"===n&&!r)return void this.fire(new t.ErrorEvent(new Error("The sourceLayer parameter must be provided for vector source types.")));void 0===e.id&&this.fire(new t.ErrorEvent(new Error("The feature id parameter must be provided.")));const s=this._getSourceCaches(o);for(const t of s)t.setFeatureState(r,e.id,i);}removeFeatureState(e,i){this._checkLoaded();const o=e.source,r=this.getSource(o);if(void 0===r)return void this.fire(new t.ErrorEvent(new Error(`The source '${o}' does not exist in the map's style.`)));const a=r.type,n="vector"===a?e.sourceLayer:void 0;if("vector"===a&&!n)return void this.fire(new t.ErrorEvent(new Error("The sourceLayer parameter must be provided for vector source types.")));if(i&&"string"!=typeof e.id&&"number"!=typeof e.id)return void this.fire(new t.ErrorEvent(new Error("A feature id is required to remove its specific state property.")));const s=this._getSourceCaches(o);for(const t of s)t.removeFeatureState(n,e.id,i);}getFeatureState(e){this._checkLoaded();const i=e.source,o=e.sourceLayer,r=this.getSource(i);if(void 0!==r){if("vector"!==r.type||o)return void 0===e.id&&this.fire(new t.ErrorEvent(new Error("The feature id parameter must be provided."))),this._getSourceCaches(i)[0].getFeatureState(o,e.id);this.fire(new t.ErrorEvent(new Error("The sourceLayer parameter must be provided for vector source types.")));}else this.fire(new t.ErrorEvent(new Error(`The source '${i}' does not exist in the map's style.`)));}getTransition(){return t.extend({duration:300,delay:0},this.stylesheet&&this.stylesheet.transition)}serialize(){const e={};for(const t in this._sourceCaches){const i=this._sourceCaches[t].getSource();e[i.id]||(e[i.id]=i.serialize());}return t.filterObject({version:this.stylesheet.version,name:this.stylesheet.name,metadata:this.stylesheet.metadata,light:this.stylesheet.light,terrain:this.stylesheet.terrain,center:this.stylesheet.center,zoom:this.stylesheet.zoom,bearing:this.stylesheet.bearing,pitch:this.stylesheet.pitch,sprite:this.stylesheet.sprite,glyphs:this.stylesheet.glyphs,transition:this.stylesheet.transition,sources:e,layers:this._serializeLayers(this._order)},(t=>void 0!==t))}_updateLayer(t){this._updatedLayers[t.id]=!0;const e=this._getLayerSourceCache(t);t.source&&!this._updatedSources[t.source]&&e&&"raster"!==e.getSource().type&&(this._updatedSources[t.source]="reload",e.pause()),this._changed=!0;}_flattenAndSortRenderedFeatures(t){const e=t=>"fill-extrusion"===this._layers[t].type,i={},o=[];for(let r=this._order.length-1;r>=0;r--){const a=this._order[r];if(e(a)){i[a]=r;for(const e of t){const t=e[a];if(t)for(const e of t)o.push(e);}}}o.sort(((t,e)=>e.intersectionZ-t.intersectionZ));const r=[];for(let a=this._order.length-1;a>=0;a--){const n=this._order[a];if(e(n))for(let t=o.length-1;t>=0;t--){const e=o[t].feature;if(i[e.layer.id]<a)break;r.push(e),o.pop();}else for(const e of t){const t=e[n];if(t)for(const e of t)r.push(e.feature);}}return r}queryRenderedFeatures(e,i,o){i&&i.filter&&this._validate(t.validateStyle.filter,"queryRenderedFeatures.filter",i.filter,null,i);const r={};if(i&&i.layers){if(!Array.isArray(i.layers))return this.fire(new t.ErrorEvent(new Error("parameters.layers must be an Array."))),[];for(const e of i.layers){const i=this._layers[e];if(!i)return this.fire(new t.ErrorEvent(new Error(`The layer '${e}' does not exist in the map's style and cannot be queried for features.`))),[];r[i.source]=!0;}}const a=[];i.availableImages=this._availableImages;const n=i&&i.layers?i.layers.some((t=>{const e=this.getLayer(t);return e&&e.is3D()})):this.has3DLayers(),s=S.createFromScreenPoints(e,o);for(const t in this._sourceCaches){const e=this._sourceCaches[t].getSource().id;i.layers&&!r[e]||a.push(Tt(this._sourceCaches[t],this._layers,this._serializedLayers,s,i,o,n,!!this.map._showQueryGeometry));}return this.placement&&a.push(function(t,e,i,o,r,a,n){const s={},l=a.queryRenderedSymbols(o),c=[];for(const t of Object.keys(l).map(Number))c.push(n[t]);c.sort(Ct);for(const i of c){const o=i.featureIndex.lookupSymbolFeatures(l[i.bucketInstanceId],e,i.bucketIndex,i.sourceLayerIndex,r.filter,r.layers,r.availableImages,t);for(const t in o){const e=s[t]=s[t]||[],r=o[t];r.sort(((t,e)=>{const o=i.featureSortOrder;if(o){const i=o.indexOf(t.featureIndex);return o.indexOf(e.featureIndex)-i}return e.featureIndex-t.featureIndex}));for(const t of r)e.push(t);}}for(const e in s)s[e].forEach((o=>{const r=o.feature,a=i(t[e]).getFeatureState(r.layer["source-layer"],r.id);r.source=r.layer.source,r.layer["source-layer"]&&(r.sourceLayer=r.layer["source-layer"]),r.state=a;}));return s}(this._layers,this._serializedLayers,this._getLayerSourceCache.bind(this),s.screenGeometry,i,this.placement.collisionIndex,this.placement.retainedQueryData)),this._flattenAndSortRenderedFeatures(a)}querySourceFeatures(e,i){i&&i.filter&&this._validate(t.validateStyle.filter,"querySourceFeatures.filter",i.filter,null,i);const o=this._getSourceCaches(e);let r=[];for(const t of o)r=r.concat(Et(t,i));return r}addSourceType(t,e,i){return Be.getSourceType(t)?i(new Error(`A source type called "${t}" already exists.`)):(Be.setSourceType(t,e),e.workerSourceURL?void this.dispatcher.broadcast("loadWorkerSource",{name:t,url:e.workerSourceURL},i):i(null,null))}getLight(){return this.light.getLight()}setLight(e,i={}){this._checkLoaded();const o=this.light.getLight();let a=!1;for(const t in e)if(!r(e[t],o[t])){a=!0;break}if(!a)return;const n={now:t.exported.now(),transition:t.extend({duration:300,delay:0},this.stylesheet.transition)};this.light.setLight(e,i),this.light.updateTransitions(n);}getTerrain(){return this.terrain?this.terrain.get():null}setTerrain(e){if(this._checkLoaded(),!e)return delete this.terrain,delete this.stylesheet.terrain,this.dispatcher.broadcast("enableTerrain",!1),void this._force3DLayerUpdate();if("object"==typeof e.source){const i="terrain-dem-src";this.addSource(i,e.source),e=t.clone$2(e),e=t.extend(e,{source:i});}if(!this._validate(t.validateStyle.terrain,"terrain",e)){if(this.terrain){const i=this.terrain,o=i.get();for(const a in e)if(!r(e[a],o[a])){i.set(e),this.stylesheet.terrain=e;const o={now:t.exported.now(),transition:t.extend({duration:0},this.stylesheet.transition)};i.updateTransitions(o);break}}else this._createTerrain(e);this._updateDrapeFirstLayers();}}_updateDrapeFirstLayers(){if(!this.map._optimizeForTerrain||!this.terrain)return;const t=this._order.filter((t=>this.isLayerDraped(this._layers[t]))),e=this._order.filter((t=>!this.isLayerDraped(this._layers[t])));this._drapedFirstOrder=[],this._drapedFirstOrder.push(...t),this._drapedFirstOrder.push(...e);}_createTerrain(e){const i=this.terrain=new w(e);this.stylesheet.terrain=e,this.dispatcher.broadcast("enableTerrain",!0),this._force3DLayerUpdate();const o={now:t.exported.now(),transition:t.extend({duration:0},this.stylesheet.transition)};i.updateTransitions(o);}_force3DLayerUpdate(){for(const t in this._layers){const e=this._layers[t];"fill-extrusion"===e.type&&this._updateLayer(e);}}_validate(e,i,o,r,a={}){return (!a||!1!==a.validate)&&Ae(this,e.call(t.validateStyle,t.extend({key:i,style:this.serialize(),value:o,styleSpec:t.spec},r)))}_remove(){this._request&&(this._request.cancel(),this._request=null),this._spriteRequest&&(this._spriteRequest.cancel(),this._spriteRequest=null),t.evented.off("pluginStateChange",this._rtlTextPluginCallback);for(const t in this._layers)this._layers[t].setEventedParent(null);for(const t in this._sourceCaches)this._sourceCaches[t].clearTiles(),this._sourceCaches[t].setEventedParent(null);this.imageManager.setEventedParent(null),this.setEventedParent(null),this.dispatcher.remove();}_clearSource(t){const e=this._getSourceCaches(t);for(const t of e)t.clearTiles();}_reloadSource(t){const e=this._getSourceCaches(t);for(const t of e)t.resume(),t.reload();}_updateSources(t){for(const e in this._sourceCaches)this._sourceCaches[e].update(t);}_generateCollisionBoxes(){for(const t in this._sourceCaches){const e=this._sourceCaches[t];e.resume(),e.reload();}}_updatePlacement(e,i,o,r,a=!1){let n=!1,s=!1;const l={};for(const t of this._order){const i=this._layers[t];if("symbol"!==i.type)continue;if(!l[i.source]){const t=this._getLayerSourceCache(i);if(!t)continue;l[i.source]=t.getRenderableIds(!0).map((e=>t.getTileByID(e))).sort(((t,e)=>e.tileID.overscaledZ-t.tileID.overscaledZ||(t.tileID.isLessThan(e.tileID)?-1:1)));}const o=this.crossTileSymbolIndex.addLayer(i,l[i.source],e.center.lng);n=n||o;}if(this.crossTileSymbolIndex.pruneUnusedLayers(this._order),a=a||this._layerOrderChanged||0===o,this._layerOrderChanged&&this.fire(new t.Event("neworder")),(a||!this.pauseablePlacement||this.pauseablePlacement.isDone()&&!this.placement.stillRecent(t.exported.now(),e.zoom))&&(this.pauseablePlacement=new Ce(e,this._order,a,i,o,r,this.placement),this._layerOrderChanged=!1),this.pauseablePlacement.isDone()?this.placement.setStale():(this.pauseablePlacement.continuePlacement(this._order,this._layers,l),this.pauseablePlacement.isDone()&&(this.placement=this.pauseablePlacement.commit(t.exported.now()),s=!0),n&&this.pauseablePlacement.placement.setStale()),s||n)for(const t of this._order){const e=this._layers[t];"symbol"===e.type&&this.placement.updateLayerOpacities(e,l[e.source]);}return !this.pauseablePlacement.isDone()||this.placement.hasTransitions(t.exported.now())}_releaseSymbolFadeTiles(){for(const t in this._sourceCaches)this._sourceCaches[t].releaseSymbolFadeTiles();}getImages(t,e,i){this.imageManager.getImages(e.icons,i),this._updateTilesForChangedImages();const o=t=>{t&&t.setDependencies(e.tileID.key,e.type,e.icons);};o(this._otherSourceCaches[e.source]),o(this._symbolSourceCaches[e.source]);}getGlyphs(t,e,i){this.glyphManager.getGlyphs(e.stacks,i);}getResource(e,i,o){return t.makeRequest(i,o)}_getSourceCache(t){return this._otherSourceCaches[t]}_getLayerSourceCache(t){return "symbol"===t.type?this._symbolSourceCaches[t.source]:this._otherSourceCaches[t.source]}_getSourceCaches(t){const e=[];return this._otherSourceCaches[t]&&e.push(this._otherSourceCaches[t]),this._symbolSourceCaches[t]&&e.push(this._symbolSourceCaches[t]),e}has3DLayers(){return this._num3DLayers>0}hasSymbolLayers(){return this._numSymbolLayers>0}hasCircleLayers(){return this._numCircleLayers>0}}Be.getSourceType=function(t){return yt[t]},Be.setSourceType=function(t,e){yt[t]=e;},Be.registerForPluginStateChange=t.registerForPluginStateChange;var Fe="attribute highp vec3 a_pos_3f;uniform lowp mat4 u_matrix;varying highp vec3 v_uv;void main() {const mat3 half_neg_pi_around_x=mat3(1.0,0.0, 0.0,0.0,0.0,-1.0,0.0,1.0, 0.0);v_uv=half_neg_pi_around_x*a_pos_3f;vec4 pos=u_matrix*vec4(a_pos_3f,1.0);gl_Position=pos.xyww;}";let Oe={};Oe=Ge("","\n#define ELEVATION_SCALE 7.3\n#ifdef TERRAIN\nuniform sampler2D u_dem;uniform sampler2D u_dem_prev;uniform vec4 u_dem_unpack;uniform vec2 u_dem_tl;uniform vec2 u_dem_tl_prev;uniform float u_dem_scale;uniform float u_dem_scale_prev;uniform float u_dem_size;uniform float u_dem_lerp;uniform float u_exaggeration;uniform float u_meter_to_dem;uniform mat4 u_label_plane_matrix_inv;uniform sampler2D u_depth;uniform vec2 u_depth_size_inv;vec4 tileUvToDemSample(vec2 uv,float dem_size,float dem_scale,vec2 dem_tl) {vec2 pos=dem_size*(uv*dem_scale+dem_tl)+1.0;vec2 f=fract(pos);return vec4((pos-f+0.5)/(dem_size+2.0),f);}float decodeElevation(vec4 v) {return dot(vec4(v.xyz*255.0,-1.0),u_dem_unpack);}float currentElevation(vec2 apos) {float dd=1.0/(u_dem_size+2.0);vec4 r=tileUvToDemSample(apos/8192.0,u_dem_size,u_dem_scale,u_dem_tl);vec2 pos=r.xy;vec2 f=r.zw;float tl=decodeElevation(texture2D(u_dem,pos));float tr=decodeElevation(texture2D(u_dem,pos+vec2(dd,0.0)));float bl=decodeElevation(texture2D(u_dem,pos+vec2(0.0,dd)));float br=decodeElevation(texture2D(u_dem,pos+vec2(dd,dd)));return u_exaggeration*mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);}float prevElevation(vec2 apos) {float dd=1.0/(u_dem_size+2.0);vec4 r=tileUvToDemSample(apos/8192.0,u_dem_size,u_dem_scale_prev,u_dem_tl_prev);vec2 pos=r.xy;vec2 f=r.zw;float tl=decodeElevation(texture2D(u_dem_prev,pos));float tr=decodeElevation(texture2D(u_dem_prev,pos+vec2(dd,0.0)));float bl=decodeElevation(texture2D(u_dem_prev,pos+vec2(0.0,dd)));float br=decodeElevation(texture2D(u_dem_prev,pos+vec2(dd,dd)));return u_exaggeration*mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);}\n#ifdef TERRAIN_VERTEX_MORPHING\nfloat elevation(vec2 apos) {float nextElevation=currentElevation(apos);float prevElevation=prevElevation(apos);return mix(prevElevation,nextElevation,u_dem_lerp);}\n#else\nfloat elevation(vec2 apos) {return currentElevation(apos);}\n#endif\nfloat unpack_depth(vec4 rgba_depth)\n{const vec4 bit_shift=vec4(1.0/(256.0*256.0*256.0),1.0/(256.0*256.0),1.0/256.0,1.0);return dot(rgba_depth,bit_shift)*2.0-1.0;}bool isOccluded(vec4 frag) {vec3 coord=frag.xyz/frag.w;float depth=unpack_depth(texture2D(u_depth,(coord.xy+1.0)*0.5));return coord.z > depth+0.0005;}float occlusionFade(vec4 frag) {vec3 coord=frag.xyz/frag.w;vec3 df=vec3(5.0*u_depth_size_inv,0.0);vec2 uv=0.5*coord.xy+0.5;vec4 depth=vec4(\nunpack_depth(texture2D(u_depth,uv-df.xz)),unpack_depth(texture2D(u_depth,uv+df.xz)),unpack_depth(texture2D(u_depth,uv-df.zy)),unpack_depth(texture2D(u_depth,uv+df.zy))\n);return dot(vec4(0.25),vec4(1.0)-clamp(300.0*(vec4(coord.z-0.001)-depth),0.0,1.0));}vec4 fourSample(vec2 pos,vec2 off) {vec4 demtl=vec4(texture2D(u_dem,pos).xyz*255.0,-1.0);float tl=dot(demtl,u_dem_unpack);vec4 demtr=vec4(texture2D(u_dem,pos+vec2(off.x,0.0)).xyz*255.0,-1.0);float tr=dot(demtr,u_dem_unpack);vec4 dembl=vec4(texture2D(u_dem,pos+vec2(0.0,off.y)).xyz*255.0,-1.0);float bl=dot(dembl,u_dem_unpack);vec4 dembr=vec4(texture2D(u_dem,pos+off).xyz*255.0,-1.0);float br=dot(dembr,u_dem_unpack);return vec4(tl,tr,bl,br);}float flatElevation(vec2 pack) {vec2 apos=floor(pack/8.0);vec2 span=10.0*(pack-apos*8.0);vec2 uvTex=(apos-vec2(1.0,1.0))/8190.0;float size=u_dem_size+2.0;float dd=1.0/size;vec2 pos=u_dem_size*(uvTex*u_dem_scale+u_dem_tl)+1.0;vec2 f=fract(pos);pos=(pos-f+0.5)*dd;vec4 h=fourSample(pos,vec2(dd));float z=mix(mix(h.x,h.y,f.x),mix(h.z,h.w,f.x),f.y);vec2 w=floor(0.5*(span*u_meter_to_dem-1.0));vec2 d=dd*w;vec4 bounds=vec4(d,vec2(1.0)-d);h=fourSample(pos-d,2.0*d+vec2(dd));vec4 diff=abs(h.xzxy-h.ywzw);vec2 slope=min(vec2(0.25),u_meter_to_dem*0.5*(diff.xz+diff.yw)/(2.0*w+vec2(1.0)));vec2 fix=slope*span;float base=z+max(fix.x,fix.y);return u_exaggeration*base;}float elevationFromUint16(float word) {return u_exaggeration*word/ELEVATION_SCALE;}\n#else\nfloat elevation(vec2 pos) { return 0.0; }bool isOccluded(vec4 frag) { return false; }float occlusionFade(vec4 frag) { return 1.0; }\n#endif",!0);const Ue=Ge("#ifdef GL_ES\nprecision mediump float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nconst float PI=3.141592653589793;","#ifdef GL_ES\nprecision highp float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nvec2 unpack_float(const float packedValue) {int packedIntValue=int(packedValue);int v0=packedIntValue/256;return vec2(v0,packedIntValue-v0*256);}vec2 unpack_opacity(const float packedOpacity) {int intOpacity=int(packedOpacity)/2;return vec2(float(intOpacity)/127.0,mod(packedOpacity,2.0));}vec4 decode_color(const vec2 encodedColor) {return vec4(\nunpack_float(encodedColor[0])/255.0,unpack_float(encodedColor[1])/255.0\n);}float unpack_mix_vec2(const vec2 packedValue,const float t) {return mix(packedValue[0],packedValue[1],t);}vec4 unpack_mix_color(const vec4 packedColors,const float t) {vec4 minColor=decode_color(vec2(packedColors[0],packedColors[1]));vec4 maxColor=decode_color(vec2(packedColors[2],packedColors[3]));return mix(minColor,maxColor,t);}vec2 get_pattern_pos(const vec2 pixel_coord_upper,const vec2 pixel_coord_lower,const vec2 pattern_size,const float tile_units_to_pixels,const vec2 pos) {vec2 offset=mod(mod(mod(pixel_coord_upper,pattern_size)*256.0,pattern_size)*256.0+pixel_coord_lower,pattern_size);return (tile_units_to_pixels*pos+offset)/pattern_size;}const float PI=3.141592653589793;const vec4 AWAY=vec4(-1000.0,-1000.0,-1000.0,1);//Normalized device coordinate that is not rendered.");var Ne={background:Ge("uniform vec4 u_color;uniform float u_opacity;void main() {gl_FragColor=u_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);}"),backgroundPattern:Ge("uniform vec2 u_pattern_tl_a;uniform vec2 u_pattern_br_a;uniform vec2 u_pattern_tl_b;uniform vec2 u_pattern_br_b;uniform vec2 u_texsize;uniform float u_mix;uniform float u_opacity;uniform sampler2D u_image;varying vec2 v_pos_a;varying vec2 v_pos_b;void main() {vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(u_pattern_tl_a/u_texsize,u_pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(u_pattern_tl_b/u_texsize,u_pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);gl_FragColor=mix(color1,color2,u_mix)*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pattern_size_a;uniform vec2 u_pattern_size_b;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_scale_a;uniform float u_scale_b;uniform float u_tile_units_to_pixels;attribute vec2 a_pos;varying vec2 v_pos_a;varying vec2 v_pos_b;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_a*u_pattern_size_a,u_tile_units_to_pixels,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_b*u_pattern_size_b,u_tile_units_to_pixels,a_pos);}"),circle:Ge("varying vec3 v_data;varying float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=v_data.xy;float extrude_length=length(extrude);lowp float antialiasblur=v_data.z;float antialiased_blur=-max(blur,antialiasblur);float opacity_t=smoothstep(0.0,antialiased_blur,extrude_length-1.0);float color_t=stroke_width < 0.01 ? 0.0 : smoothstep(\nantialiased_blur,0.0,extrude_length-radius/(radius+stroke_width)\n);gl_FragColor=v_visibility*opacity_t*mix(color*opacity,stroke_color*stroke_opacity,color_t);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","#define NUM_VISIBILITY_RINGS 2\n#define INV_SQRT2 0.70710678\n#define ELEVATION_BIAS 0.0001\n#define NUM_SAMPLES_PER_RING 16\nuniform mat4 u_matrix;uniform vec2 u_extrude_scale;uniform lowp float u_device_pixel_ratio;uniform highp float u_camera_to_center_distance;attribute vec2 a_pos;varying vec3 v_data;varying float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvec2 calc_offset(vec2 extrusion,float radius,float stroke_width, float view_scale) {return extrusion*(radius+stroke_width)*u_extrude_scale*view_scale;}float cantilevered_elevation(vec2 pos,float radius,float stroke_width,float view_scale) {vec2 c1=pos+calc_offset(vec2(-1,-1),radius,stroke_width,view_scale);vec2 c2=pos+calc_offset(vec2(1,-1),radius,stroke_width,view_scale);vec2 c3=pos+calc_offset(vec2(1,1),radius,stroke_width,view_scale);vec2 c4=pos+calc_offset(vec2(-1,1),radius,stroke_width,view_scale);float h1=elevation(c1)+ELEVATION_BIAS;float h2=elevation(c2)+ELEVATION_BIAS;float h3=elevation(c3)+ELEVATION_BIAS;float h4=elevation(c4)+ELEVATION_BIAS;return max(h4,max(h3,max(h1,h2)));}float circle_elevation(vec2 pos) {\n#if defined(TERRAIN)\nreturn elevation(pos)+ELEVATION_BIAS;\n#else\nreturn 0.0;\n#endif\n}vec4 project_vertex(vec2 extrusion,vec4 world_center,vec4 projected_center,float radius,float stroke_width, float view_scale) {vec2 sample_offset=calc_offset(extrusion,radius,stroke_width,view_scale);\n#ifdef PITCH_WITH_MAP\nreturn u_matrix*( world_center+vec4(sample_offset,0,0) );\n#else\nreturn projected_center+vec4(sample_offset,0,0);\n#endif\n}float get_sample_step() {\n#ifdef PITCH_WITH_MAP\nreturn 2.0*PI/float(NUM_SAMPLES_PER_RING);\n#else\nreturn PI/float(NUM_SAMPLES_PER_RING);\n#endif\n}void main(void) {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=vec2(mod(a_pos,2.0)*2.0-1.0);vec2 circle_center=floor(a_pos*0.5);float height=circle_elevation(circle_center);vec4 world_center=vec4(circle_center,height,1);vec4 projected_center=u_matrix*world_center;float view_scale=0.0;\n#ifdef PITCH_WITH_MAP\n#ifdef SCALE_WITH_MAP\nview_scale=1.0;\n#else\nview_scale=projected_center.w/u_camera_to_center_distance;\n#endif\n#else\n#ifdef SCALE_WITH_MAP\nview_scale=u_camera_to_center_distance;\n#else\nview_scale=projected_center.w;\n#endif\n#endif\ngl_Position=project_vertex(extrude,world_center,projected_center,radius,stroke_width,view_scale);float visibility=0.0;\n#ifdef TERRAIN\nfloat step=get_sample_step();\n#ifdef PITCH_WITH_MAP\nfloat cantilevered_height=cantilevered_elevation(circle_center,radius,stroke_width,view_scale);vec4 occlusion_world_center=vec4(circle_center,cantilevered_height,1);vec4 occlusion_projected_center=u_matrix*occlusion_world_center;\n#else\nvec4 occlusion_world_center=world_center;vec4 occlusion_projected_center=projected_center;\n#endif\nfor(int ring=0; ring < NUM_VISIBILITY_RINGS; ring++) {float scale=(float(ring)+1.0)/float(NUM_VISIBILITY_RINGS);for(int i=0; i < NUM_SAMPLES_PER_RING; i++) {vec2 extrusion=vec2(cos(step*float(i)),-sin(step*float(i)))*scale;vec4 frag_pos=project_vertex(extrusion,occlusion_world_center,occlusion_projected_center,radius,stroke_width,view_scale);visibility+=float(!isOccluded(frag_pos));}}visibility/=float(NUM_VISIBILITY_RINGS)*float(NUM_SAMPLES_PER_RING);\n#else\nvisibility=1.0;\n#endif\nv_visibility=visibility;lowp float antialiasblur=1.0/u_device_pixel_ratio/(radius+stroke_width);v_data=vec3(extrude.x,extrude.y,antialiasblur);}"),clippingMask:Ge("void main() {gl_FragColor=vec4(1.0);}","attribute vec2 a_pos;uniform mat4 u_matrix;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);}"),heatmap:Ge("uniform highp float u_intensity;varying vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#define GAUSS_COEF 0.3989422804014327\nvoid main() {\n#pragma mapbox: initialize highp float weight\nfloat d=-0.5*3.0*3.0*dot(v_extrude,v_extrude);float val=weight*u_intensity*GAUSS_COEF*exp(d);gl_FragColor=vec4(val,1.0,1.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform float u_extrude_scale;uniform float u_opacity;uniform float u_intensity;attribute vec2 a_pos;varying vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#pragma mapbox: define mediump float radius\nconst highp float ZERO=1.0/255.0/16.0;\n#define GAUSS_COEF 0.3989422804014327\nvoid main(void) {\n#pragma mapbox: initialize highp float weight\n#pragma mapbox: initialize mediump float radius\nvec2 unscaled_extrude=vec2(mod(a_pos,2.0)*2.0-1.0);float S=sqrt(-2.0*log(ZERO/weight/u_intensity/GAUSS_COEF))/3.0;v_extrude=S*unscaled_extrude;vec2 extrude=v_extrude*radius*u_extrude_scale;vec4 pos=vec4(floor(a_pos*0.5)+extrude,elevation(floor(a_pos*0.5)),1);gl_Position=u_matrix*pos;}"),heatmapTexture:Ge("uniform sampler2D u_image;uniform sampler2D u_color_ramp;uniform float u_opacity;varying vec2 v_pos;void main() {float t=texture2D(u_image,v_pos).r;vec4 color=texture2D(u_color_ramp,vec2(t,0.5));gl_FragColor=color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(0.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_world;attribute vec2 a_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos*u_world,0,1);v_pos.x=a_pos.x;v_pos.y=1.0-a_pos.y;}"),collisionBox:Ge("varying float v_placed;varying float v_notUsed;void main() {vec4 red =vec4(1.0,0.0,0.0,1.0);vec4 blue=vec4(0.0,0.0,1.0,0.5);gl_FragColor =mix(red,blue,step(0.5,v_placed))*0.5;gl_FragColor*=mix(1.0,0.1,step(0.5,v_notUsed));}","attribute vec2 a_pos;attribute vec2 a_anchor_pos;attribute vec2 a_extrude;attribute vec2 a_placed;attribute vec2 a_shift;attribute float a_size_scale;attribute vec2 a_padding;uniform mat4 u_matrix;uniform vec2 u_extrude_scale;uniform float u_camera_to_center_distance;varying float v_placed;varying float v_notUsed;void main() {vec4 projectedPoint=u_matrix*vec4(a_anchor_pos,elevation(a_anchor_pos),1);highp float camera_to_anchor_distance=projectedPoint.w;highp float collision_perspective_ratio=clamp(\n0.5+0.5*(u_camera_to_center_distance/camera_to_anchor_distance),0.0,1.5);gl_Position=u_matrix*vec4(a_pos,elevation(a_pos),1.0);gl_Position.xy+=(a_extrude*a_size_scale+a_shift+a_padding)*u_extrude_scale*gl_Position.w*collision_perspective_ratio;v_placed=a_placed.x;v_notUsed=a_placed.y;}"),collisionCircle:Ge("varying float v_radius;varying vec2 v_extrude;varying float v_perspective_ratio;varying float v_collision;void main() {float alpha=0.5*min(v_perspective_ratio,1.0);float stroke_radius=0.9*max(v_perspective_ratio,1.0);float distance_to_center=length(v_extrude);float distance_to_edge=abs(distance_to_center-v_radius);float opacity_t=smoothstep(-stroke_radius,0.0,-distance_to_edge);vec4 color=mix(vec4(0.0,0.0,1.0,0.5),vec4(1.0,0.0,0.0,1.0),v_collision);gl_FragColor=color*alpha*opacity_t;}","attribute vec2 a_pos_2f;attribute float a_radius;attribute vec2 a_flags;uniform mat4 u_matrix;uniform mat4 u_inv_matrix;uniform vec2 u_viewport_size;uniform float u_camera_to_center_distance;varying float v_radius;varying vec2 v_extrude;varying float v_perspective_ratio;varying float v_collision;vec3 toTilePosition(vec2 screenPos) {vec4 rayStart=u_inv_matrix*vec4(screenPos,-1.0,1.0);vec4 rayEnd  =u_inv_matrix*vec4(screenPos, 1.0,1.0);rayStart.xyz/=rayStart.w;rayEnd.xyz  /=rayEnd.w;highp float t=(0.0-rayStart.z)/(rayEnd.z-rayStart.z);return mix(rayStart.xyz,rayEnd.xyz,t);}void main() {vec2 quadCenterPos=a_pos_2f;float radius=a_radius;float collision=a_flags.x;float vertexIdx=a_flags.y;vec2 quadVertexOffset=vec2(\nmix(-1.0,1.0,float(vertexIdx >=2.0)),mix(-1.0,1.0,float(vertexIdx >=1.0 && vertexIdx <=2.0)));vec2 quadVertexExtent=quadVertexOffset*radius;vec3 tilePos=toTilePosition(quadCenterPos);vec4 clipPos=u_matrix*vec4(tilePos,1.0);highp float camera_to_anchor_distance=clipPos.w;highp float collision_perspective_ratio=clamp(\n0.5+0.5*(u_camera_to_center_distance/camera_to_anchor_distance),0.0,4.0);float padding_factor=1.2;v_radius=radius;v_extrude=quadVertexExtent*padding_factor;v_perspective_ratio=collision_perspective_ratio;v_collision=collision;gl_Position=vec4(clipPos.xyz/clipPos.w,1.0)+vec4(quadVertexExtent*padding_factor/u_viewport_size*2.0,0.0,0.0);}"),debug:Ge("uniform highp vec4 u_color;uniform sampler2D u_overlay;varying vec2 v_uv;void main() {vec4 overlay_color=texture2D(u_overlay,v_uv);gl_FragColor=mix(u_color,overlay_color,overlay_color.a);}","attribute vec2 a_pos;varying vec2 v_uv;uniform mat4 u_matrix;uniform float u_overlay_scale;void main() {float h=elevation(a_pos);v_uv=a_pos/8192.0;gl_Position=u_matrix*vec4(a_pos*u_overlay_scale,h,1);}"),fill:Ge("#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_FragColor=color*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=u_matrix*vec4(a_pos,0,1);}"),fillOutline:Ge("varying vec2 v_pos;\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);gl_FragColor=outline_color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;uniform vec2 u_world;varying vec2 v_pos;\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=u_matrix*vec4(a_pos,0,1);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;}"),fillOutlinePattern:Ge("uniform vec2 u_texsize;uniform sampler2D u_image;uniform float u_fade;varying vec2 v_pos_a;varying vec2 v_pos_b;varying vec2 v_pos;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);float dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);gl_FragColor=mix(color1,color2,u_fade)*alpha*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_world;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;attribute vec2 a_pos;varying vec2 v_pos_a;varying vec2 v_pos_b;varying vec2 v_pos;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;gl_Position=u_matrix*vec4(a_pos,0,1);vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,a_pos);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;}"),fillPattern:Ge("uniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;varying vec2 v_pos_a;varying vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);gl_FragColor=mix(color1,color2,u_fade)*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;attribute vec2 a_pos;varying vec2 v_pos_a;varying vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;gl_Position=u_matrix*vec4(a_pos,0,1);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileZoomRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileZoomRatio,a_pos);}"),fillExtrusion:Ge("varying vec4 v_color;void main() {gl_FragColor=v_color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp float u_lightintensity;uniform float u_vertical_gradient;uniform lowp float u_opacity;attribute vec4 a_pos_normal_ed;attribute vec2 a_centroid_pos;varying vec4 v_color;\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define highp vec4 color\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize highp vec4 color\nvec3 pos_nx=floor(a_pos_normal_ed.xyz*0.5);mediump vec3 top_up_ny=a_pos_normal_ed.xyz-2.0*pos_nx;float x_normal=pos_nx.z/8192.0;vec3 normal=top_up_ny.y==1.0 ? vec3(0.0,0.0,1.0) : normalize(vec3(x_normal,(2.0*top_up_ny.z-1.0)*(1.0-abs(x_normal)),0.0));base=max(0.0,base);height=max(0.0,height);float t=top_up_ny.x;\n#ifdef TERRAIN\nvec2 centroid_pos=a_centroid_pos;bool flat_roof=centroid_pos.x !=0.0;float ele=elevation(pos_nx.xy);float hidden=float(centroid_pos.x==0.0 && centroid_pos.y==1.0);float c_ele=flat_roof ? centroid_pos.y==0.0 ? elevationFromUint16(centroid_pos.x) : flatElevation(centroid_pos) : ele;float h=flat_roof ? max(c_ele+height,ele+base+2.0) : ele+(t > 0.0 ? height : base==0.0 ?-5.0 : base);gl_Position=mix(u_matrix*vec4(pos_nx.xy,h,1),AWAY,hidden);\n#else\ngl_Position=u_matrix*vec4(pos_nx.xy,t > 0.0 ? height : base,1);\n#endif\nfloat colorvalue=color.r*0.2126+color.g*0.7152+color.b*0.0722;v_color=vec4(0.0,0.0,0.0,1.0);vec4 ambientlight=vec4(0.03,0.03,0.03,1.0);color+=ambientlight;float directional=clamp(dot(normal,u_lightpos),0.0,1.0);directional=mix((1.0-u_lightintensity),max((1.0-colorvalue+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=(\n(1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_color.r+=clamp(color.r*directional*u_lightcolor.r,mix(0.0,0.3,1.0-u_lightcolor.r),1.0);v_color.g+=clamp(color.g*directional*u_lightcolor.g,mix(0.0,0.3,1.0-u_lightcolor.g),1.0);v_color.b+=clamp(color.b*directional*u_lightcolor.b,mix(0.0,0.3,1.0-u_lightcolor.b),1.0);v_color*=u_opacity;}"),fillExtrusionPattern:Ge("uniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;varying vec2 v_pos_a;varying vec2 v_pos_b;varying vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);vec4 mixedColor=mix(color1,color2,u_fade);gl_FragColor=mixedColor*v_lighting;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_height_factor;uniform vec3 u_scale;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp float u_lightintensity;attribute vec4 a_pos_normal_ed;attribute vec2 a_centroid_pos;varying vec2 v_pos_a;varying vec2 v_pos_b;varying vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec3 pos_nx=floor(a_pos_normal_ed.xyz*0.5);mediump vec3 top_up_ny=a_pos_normal_ed.xyz-2.0*pos_nx;float x_normal=pos_nx.z/8192.0;vec3 normal=top_up_ny.y==1.0 ? vec3(0.0,0.0,1.0) : normalize(vec3(x_normal,(2.0*top_up_ny.z-1.0)*(1.0-abs(x_normal)),0.0));float edgedistance=a_pos_normal_ed.w;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;base=max(0.0,base);height=max(0.0,height);float t=top_up_ny.x;float z=t > 0.0 ? height : base;\n#ifdef TERRAIN\nvec2 centroid_pos=a_centroid_pos;bool flat_roof=centroid_pos.x !=0.0;float ele=elevation(pos_nx.xy);float hidden=float(centroid_pos.x==0.0 && centroid_pos.y==1.0);float c_ele=flat_roof ? centroid_pos.y==0.0 ? elevationFromUint16(centroid_pos.x) : flatElevation(centroid_pos) : ele;float h=flat_roof ? max(c_ele+height,ele+base+2.0) : ele+(t > 0.0 ? height : base==0.0 ?-5.0 : base);gl_Position=mix(u_matrix*vec4(pos_nx.xy,h,1),AWAY,hidden);\n#else\ngl_Position=u_matrix*vec4(pos_nx.xy,z,1);\n#endif\nvec2 pos=normal.z==1.0\n? pos_nx.xy\n: vec2(edgedistance,z*u_height_factor);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,pos);v_lighting=vec4(0.0,0.0,0.0,1.0);float directional=clamp(dot(normal,u_lightpos),0.0,1.0);directional=mix((1.0-u_lightintensity),max((0.5+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=(\n(1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_lighting.rgb+=clamp(directional*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_lighting*=u_opacity;}"),hillshadePrepare:Ge("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_image;varying vec2 v_pos;uniform vec2 u_dimension;uniform float u_zoom;uniform vec4 u_unpack;float getElevation(vec2 coord,float bias) {vec4 data=texture2D(u_image,coord)*255.0;data.a=-1.0;return dot(data,u_unpack)/4.0;}void main() {vec2 epsilon=1.0/u_dimension;float a=getElevation(v_pos+vec2(-epsilon.x,-epsilon.y),0.0);float b=getElevation(v_pos+vec2(0,-epsilon.y),0.0);float c=getElevation(v_pos+vec2(epsilon.x,-epsilon.y),0.0);float d=getElevation(v_pos+vec2(-epsilon.x,0),0.0);float e=getElevation(v_pos,0.0);float f=getElevation(v_pos+vec2(epsilon.x,0),0.0);float g=getElevation(v_pos+vec2(-epsilon.x,epsilon.y),0.0);float h=getElevation(v_pos+vec2(0,epsilon.y),0.0);float i=getElevation(v_pos+vec2(epsilon.x,epsilon.y),0.0);float exaggerationFactor=u_zoom < 2.0 ? 0.4 : u_zoom < 4.5 ? 0.35 : 0.3;float exaggeration=u_zoom < 15.0 ? (u_zoom-15.0)*exaggerationFactor : 0.0;vec2 deriv=vec2(\n(c+f+f+i)-(a+d+d+g),(g+h+h+i)-(a+b+b+c)\n)/pow(2.0,exaggeration+(19.2562-u_zoom));gl_FragColor=clamp(vec4(\nderiv.x/2.0+0.5,deriv.y/2.0+0.5,1.0,1.0),0.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_dimension;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_texture_pos/8192.0)*scale+epsilon;}"),hillshade:Ge("uniform sampler2D u_image;varying vec2 v_pos;uniform vec2 u_latrange;uniform vec2 u_light;uniform vec4 u_shadow;uniform vec4 u_highlight;uniform vec4 u_accent;void main() {vec4 pixel=texture2D(u_image,v_pos);vec2 deriv=((pixel.rg*2.0)-1.0);float scaleFactor=cos(radians((u_latrange[0]-u_latrange[1])*(1.0-v_pos.y)+u_latrange[1]));float slope=atan(1.25*length(deriv)/scaleFactor);float aspect=deriv.x !=0.0 ? atan(deriv.y,-deriv.x) : PI/2.0*(deriv.y > 0.0 ? 1.0 :-1.0);float intensity=u_light.x;float azimuth=u_light.y+PI;float base=1.875-intensity*1.75;float maxValue=0.5*PI;float scaledSlope=intensity !=0.5 ? ((pow(base,slope)-1.0)/(pow(base,maxValue)-1.0))*maxValue : slope;float accent=cos(scaledSlope);vec4 accent_color=(1.0-accent)*u_accent*clamp(intensity*2.0,0.0,1.0);float shade=abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);vec4 shade_color=mix(u_shadow,u_highlight,shade)*sin(scaledSlope)*clamp(intensity*2.0,0.0,1.0);gl_FragColor=accent_color*(1.0-shade_color.a)+shade_color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos=a_texture_pos/8192.0;}"),line:Ge("uniform lowp float u_device_pixel_ratio;varying vec2 v_width2;varying vec2 v_normal;varying float v_gamma_scale;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);gl_FragColor=color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nattribute vec2 a_pos_normal;attribute vec4 a_data;uniform mat4 u_matrix;uniform mediump float u_ratio;uniform vec2 u_units_to_pixels;uniform lowp float u_device_pixel_ratio;varying vec2 v_normal;varying vec2 v_width2;varying float v_gamma_scale;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist/u_ratio,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2/u_ratio,0.0,1.0)+projected_extrude;\n#ifndef RENDER_TO_TEXTURE\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#else\nv_gamma_scale=1.0;\n#endif\nv_width2=vec2(outset,inset);}"),lineGradient:Ge("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;varying vec2 v_width2;varying vec2 v_normal;varying float v_gamma_scale;varying highp vec2 v_uv;\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);vec4 color=texture2D(u_image,v_uv);gl_FragColor=color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nattribute vec2 a_pos_normal;attribute vec4 a_data;attribute float a_uv_x;attribute float a_split_index;uniform mat4 u_matrix;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_units_to_pixels;uniform float u_image_height;varying vec2 v_normal;varying vec2 v_width2;varying float v_gamma_scale;varying highp vec2 v_uv;\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;highp float texel_height=1.0/u_image_height;highp float half_texel_height=0.5*texel_height;v_uv=vec2(a_uv_x,a_split_index*texel_height-half_texel_height);vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist/u_ratio,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2/u_ratio,0.0,1.0)+projected_extrude;\n#ifndef RENDER_TO_TEXTURE\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#else\nv_gamma_scale=1.0;\n#endif\nv_width2=vec2(outset,inset);}"),linePattern:Ge("uniform lowp float u_device_pixel_ratio;uniform vec2 u_texsize;uniform float u_fade;uniform mediump vec3 u_scale;uniform sampler2D u_image;varying vec2 v_normal;varying vec2 v_width2;varying float v_linesofar;varying float v_gamma_scale;varying float v_width;\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;vec2 pattern_size_a=vec2(display_size_a.x*fromScale/tileZoomRatio,display_size_a.y);vec2 pattern_size_b=vec2(display_size_b.x*toScale/tileZoomRatio,display_size_b.y);float aspect_a=display_size_a.y/v_width;float aspect_b=display_size_b.y/v_width;float dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float x_a=mod(v_linesofar/pattern_size_a.x*aspect_a,1.0);float x_b=mod(v_linesofar/pattern_size_b.x*aspect_b,1.0);float y=0.5*v_normal.y+0.5;vec2 texel_size=1.0/u_texsize;vec2 pos_a=mix(pattern_tl_a*texel_size-texel_size,pattern_br_a*texel_size+texel_size,vec2(x_a,y));vec2 pos_b=mix(pattern_tl_b*texel_size-texel_size,pattern_br_b*texel_size+texel_size,vec2(x_b,y));vec4 color=mix(texture2D(u_image,pos_a),texture2D(u_image,pos_b),u_fade);gl_FragColor=color*alpha*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nattribute vec2 a_pos_normal;attribute vec4 a_data;attribute float a_linesofar;uniform mat4 u_matrix;uniform vec2 u_units_to_pixels;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;varying vec2 v_normal;varying vec2 v_width2;varying float v_linesofar;varying float v_gamma_scale;varying float v_width;\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist/u_ratio,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2/u_ratio,0.0,1.0)+projected_extrude;\n#ifndef RENDER_TO_TEXTURE\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#else\nv_gamma_scale=1.0;\n#endif\nv_linesofar=a_linesofar;v_width2=vec2(outset,inset);v_width=floorwidth;}"),lineSDF:Ge("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;uniform float u_sdfgamma;uniform float u_mix;varying vec2 v_normal;varying vec2 v_width2;varying vec2 v_tex_a;varying vec2 v_tex_b;varying float v_gamma_scale;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float sdfdist_a=texture2D(u_image,v_tex_a).a;float sdfdist_b=texture2D(u_image,v_tex_b).a;float sdfdist=mix(sdfdist_a,sdfdist_b,u_mix);alpha*=smoothstep(0.5-u_sdfgamma/floorwidth,0.5+u_sdfgamma/floorwidth,sdfdist);gl_FragColor=color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nattribute vec2 a_pos_normal;attribute vec4 a_data;attribute float a_linesofar;uniform mat4 u_matrix;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_patternscale_a;uniform float u_tex_y_a;uniform vec2 u_patternscale_b;uniform float u_tex_y_b;uniform vec2 u_units_to_pixels;varying vec2 v_normal;varying vec2 v_width2;varying vec2 v_tex_a;varying vec2 v_tex_b;varying float v_gamma_scale;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist/u_ratio,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2/u_ratio,0.0,1.0)+projected_extrude;\n#ifndef RENDER_TO_TEXTURE\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#else\nv_gamma_scale=1.0;\n#endif\nv_tex_a=vec2(a_linesofar*u_patternscale_a.x/floorwidth,normal.y*u_patternscale_a.y+u_tex_y_a);v_tex_b=vec2(a_linesofar*u_patternscale_b.x/floorwidth,normal.y*u_patternscale_b.y+u_tex_y_b);v_width2=vec2(outset,inset);}"),raster:Ge("uniform float u_fade_t;uniform float u_opacity;uniform sampler2D u_image0;uniform sampler2D u_image1;varying vec2 v_pos0;varying vec2 v_pos1;uniform float u_brightness_low;uniform float u_brightness_high;uniform float u_saturation_factor;uniform float u_contrast_factor;uniform vec3 u_spin_weights;void main() {vec4 color0=texture2D(u_image0,v_pos0);vec4 color1=texture2D(u_image1,v_pos1);if (color0.a > 0.0) {color0.rgb=color0.rgb/color0.a;}if (color1.a > 0.0) {color1.rgb=color1.rgb/color1.a;}vec4 color=mix(color0,color1,u_fade_t);color.a*=u_opacity;vec3 rgb=color.rgb;rgb=vec3(\ndot(rgb,u_spin_weights.xyz),dot(rgb,u_spin_weights.zxy),dot(rgb,u_spin_weights.yzx));float average=(color.r+color.g+color.b)/3.0;rgb+=(average-rgb)*u_saturation_factor;rgb=(rgb-0.5)*u_contrast_factor+0.5;vec3 u_high_vec=vec3(u_brightness_low,u_brightness_low,u_brightness_low);vec3 u_low_vec=vec3(u_brightness_high,u_brightness_high,u_brightness_high);gl_FragColor=vec4(mix(u_high_vec,u_low_vec,rgb)*color.a,color.a);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_tl_parent;uniform float u_scale_parent;uniform float u_buffer_scale;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos0;varying vec2 v_pos1;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos0=(((a_texture_pos/8192.0)-0.5)/u_buffer_scale )+0.5;v_pos1=(v_pos0*u_scale_parent)+u_tl_parent;}"),symbolIcon:Ge("uniform sampler2D u_texture;varying vec2 v_tex;varying float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nlowp float alpha=opacity*v_fade_opacity;gl_FragColor=texture2D(u_texture,v_tex)*alpha;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec4 a_pos_offset;attribute vec4 a_data;attribute vec4 a_pixeloffset;attribute vec3 a_projected_pos;attribute float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform highp float u_camera_to_center_distance;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform float u_fade_change;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform vec2 u_texsize;varying vec2 v_tex;varying float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;vec2 a_minFontScale=a_pixeloffset.zw/256.0;highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}float h=elevation(a_pos);vec4 projectedPoint=u_matrix*vec4(a_pos,h,1);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(\n0.5+0.5*distance_ratio,0.0,1.5);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=u_matrix*vec4(a_pos+vec2(1,0),h,1);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy,h,1.0);float z=0.0;vec2 offset=rotation_matrix*(a_offset/32.0*max(a_minFontScale,fontScale)+a_pxoffset/16.0);\n#ifdef PITCH_WITH_MAP_TERRAIN\nvec4 tile_pos=u_label_plane_matrix_inv*vec4(a_projected_pos.xy+offset,0.0,1.0);z=elevation(tile_pos.xy);\n#endif\nfloat occlusion_fade=occlusionFade(projectedPoint);gl_Position=mix(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+offset,z,1.0),AWAY,float(projectedPoint.w <=0.0 || occlusion_fade==0.0));v_tex=a_tex/u_texsize;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;v_fade_opacity=max(0.0,min(occlusion_fade,fade_opacity[0]+fade_change));}"),symbolSDF:Ge("#define SDF_PX 8.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;uniform bool u_is_text;varying vec2 v_data0;varying vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat EDGE_GAMMA=0.105/u_device_pixel_ratio;vec2 tex=v_data0.xy;float gamma_scale=v_data1.x;float size=v_data1.y;float fade_opacity=v_data1[2];float fontScale=u_is_text ? size/24.0 : size;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture2D(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);gl_FragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec4 a_pos_offset;attribute vec4 a_data;attribute vec4 a_pixeloffset;attribute vec3 a_projected_pos;attribute float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;varying vec2 v_data0;varying vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}float h=elevation(a_pos);vec4 projectedPoint=u_matrix*vec4(a_pos,h,1);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(\n0.5+0.5*distance_ratio,0.0,1.5);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=u_matrix*vec4(a_pos+vec2(1,0),h,1);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy,h,1.0);float z=0.0;vec2 offset=rotation_matrix*(a_offset/32.0*fontScale+a_pxoffset);\n#ifdef PITCH_WITH_MAP_TERRAIN\nvec4 tile_pos=u_label_plane_matrix_inv*vec4(a_projected_pos.xy+offset,0.0,1.0);z=elevation(tile_pos.xy);\n#endif\nfloat occlusion_fade=occlusionFade(projectedPoint);gl_Position=mix(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+offset,z,1.0),AWAY,float(projectedPoint.w <=0.0 || occlusion_fade==0.0));float gamma_scale=gl_Position.w;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(occlusion_fade,fade_opacity[0]+fade_change));v_data0=a_tex/u_texsize;v_data1=vec3(gamma_scale,size,interpolated_fade_opacity);}"),symbolTextAndIcon:Ge("#define SDF_PX 8.0\n#define SDF 1.0\n#define ICON 0.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform sampler2D u_texture_icon;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;varying vec4 v_data0;varying vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat fade_opacity=v_data1[2];if (v_data1.w==ICON) {vec2 tex_icon=v_data0.zw;lowp float alpha=opacity*fade_opacity;gl_FragColor=texture2D(u_texture_icon,tex_icon)*alpha;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nreturn;}vec2 tex=v_data0.xy;float EDGE_GAMMA=0.105/u_device_pixel_ratio;float gamma_scale=v_data1.x;float size=v_data1.y;float fontScale=size/24.0;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture2D(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);gl_FragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec4 a_pos_offset;attribute vec4 a_data;attribute vec3 a_projected_pos;attribute float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_texsize_icon;varying vec4 v_data0;varying vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);float is_sdf=a_size[0]-2.0*a_size_min;highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}float h=elevation(a_pos);vec4 projectedPoint=u_matrix*vec4(a_pos,h,1);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(\n0.5+0.5*distance_ratio,0.0,1.5);size*=perspective_ratio;float fontScale=size/24.0;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=u_matrix*vec4(a_pos+vec2(1,0),h,1);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy,h,1.0);float z=0.0;vec2 offset=rotation_matrix*(a_offset/32.0*fontScale);\n#ifdef PITCH_WITH_MAP_TERRAIN\nvec4 tile_pos=u_label_plane_matrix_inv*vec4(a_projected_pos.xy+offset,0.0,1.0);z=elevation(tile_pos.xy);\n#endif\nfloat occlusion_fade=occlusionFade(projectedPoint);gl_Position=mix(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+offset,z,1.0),AWAY,float(projectedPoint.w <=0.0 || occlusion_fade==0.0));float gamma_scale=gl_Position.w;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(occlusion_fade,fade_opacity[0]+fade_change));v_data0.xy=a_tex/u_texsize;v_data0.zw=a_tex/u_texsize_icon;v_data1=vec4(gamma_scale,size,interpolated_fade_opacity,is_sdf);}"),terrainRaster:Ge("uniform sampler2D u_image0;varying vec2 v_pos0;void main() {gl_FragColor=texture2D(u_image0,v_pos0);\n#ifdef TERRAIN_WIREFRAME\ngl_FragColor=vec4(1.0,0.0,0.0,0.8);\n#endif\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform float u_skirt_height;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos0;const float skirtOffset=24575.0;const float wireframeOffset=0.00015;void main() {v_pos0=a_texture_pos/8192.0;float skirt=float(a_pos.x >=skirtOffset);float elevation=elevation(a_texture_pos)-skirt*u_skirt_height;\n#ifdef TERRAIN_WIREFRAME\nelevation+=u_skirt_height*u_skirt_height*wireframeOffset;\n#endif\nvec2 decodedPos=a_pos-vec2(skirt*skirtOffset,0.0);gl_Position=u_matrix*vec4(decodedPos,elevation,1.0);}"),terrainDepth:Ge("#ifdef GL_ES\nprecision highp float;\n#endif\nvec4 pack_depth(float ndc_z) {float depth=ndc_z*0.5+0.5;const vec4 bit_shift=vec4(256.0*256.0*256.0,256.0*256.0,256.0,1.0);const vec4 bit_mask =vec4(0.0,1.0/256.0,1.0/256.0,1.0/256.0);vec4 res=fract(depth*bit_shift);res-=res.xxyz*bit_mask;return res;}varying float v_depth;void main() {gl_FragColor=pack_depth(v_depth);}","uniform mat4 u_matrix;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying float v_depth;void main() {float elevation=elevation(a_texture_pos);gl_Position=u_matrix*vec4(a_pos,elevation,1.0);v_depth=gl_Position.z/gl_Position.w;}"),skybox:Ge("\nvarying lowp vec3 v_uv;uniform lowp samplerCube u_cubemap;uniform lowp float u_opacity;uniform highp float u_temporal_offset;uniform highp vec3 u_sun_direction;highp vec3 hash(highp vec2 p) {highp vec3 p3=fract(vec3(p.xyx)*vec3(443.8975,397.2973,491.1871));p3+=dot(p3,p3.yxz+19.19);return fract(vec3((p3.x+p3.y)*p3.z,(p3.x+p3.z)*p3.y,(p3.y+p3.z)*p3.x));}vec3 dither(vec3 color,highp vec2 seed) {vec3 rnd=hash(seed)+hash(seed+0.59374)-0.5;color.rgb+=rnd/255.0;return color;}float sun_disk(highp vec3 ray_direction,highp vec3 sun_direction) {highp float cos_angle=dot(normalize(ray_direction),sun_direction);const highp float cos_sun_angular_diameter=0.99996192306;const highp float smoothstep_delta=1e-5;return smoothstep(\ncos_sun_angular_diameter-smoothstep_delta,cos_sun_angular_diameter+smoothstep_delta,cos_angle);}float map(float value,float start,float end,float new_start,float new_end) {return ((value-start)*(new_end-new_start))/(end-start)+new_start;}void main() {vec3 uv=v_uv;const float y_bias=0.015;uv.y+=y_bias;uv.y=pow(abs(uv.y),1.0/5.0);uv.y=map(uv.y,0.0,1.0,-1.0,1.0);vec3 sky_color=textureCube(u_cubemap,uv).rgb;sky_color.rgb=dither(sky_color.rgb,gl_FragCoord.xy+u_temporal_offset);sky_color+=0.1*sun_disk(v_uv,u_sun_direction);gl_FragColor=vec4(sky_color*u_opacity,u_opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}",Fe),skyboxGradient:Ge("varying highp vec3 v_uv;uniform lowp sampler2D u_color_ramp;uniform lowp vec3 u_center_direction;uniform lowp float u_radius;uniform lowp float u_opacity;uniform highp float u_temporal_offset;highp vec3 hash(highp vec2 p) {highp vec3 p3=fract(vec3(p.xyx)*vec3(443.8975,397.2973,491.1871));p3+=dot(p3,p3.yxz+19.19);return fract(vec3((p3.x+p3.y)*p3.z,(p3.x+p3.z)*p3.y,(p3.y+p3.z)*p3.x));}vec3 dither(vec3 color,highp vec2 seed) {vec3 rnd=hash(seed)+hash(seed+0.59374)-0.5;color.rgb+=rnd/255.0;return color;}void main() {float progress=acos(dot(normalize(v_uv),u_center_direction))/u_radius;vec4 color=texture2D(u_color_ramp,vec2(progress,0.5))*u_opacity;color.rgb=dither(color.rgb,gl_FragCoord.xy+u_temporal_offset);gl_FragColor=color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}",Fe),skyboxCapture:Ge("\nvarying highp vec3 v_position;uniform highp float u_sun_intensity;uniform highp float u_luminance;uniform lowp vec3 u_sun_direction;uniform highp vec4 u_color_tint_r;uniform highp vec4 u_color_tint_m;\n#ifdef GL_ES\nprecision highp float;\n#endif\n#define BETA_R                  vec3(5.5e-6,13.0e-6,22.4e-6)\n#define BETA_M                  vec3(21e-6,21e-6,21e-6)\n#define MIE_G                   0.76\n#define DENSITY_HEIGHT_SCALE_R  8000.0\n#define DENSITY_HEIGHT_SCALE_M  1200.0\n#define PLANET_RADIUS           6360e3\n#define ATMOSPHERE_RADIUS       6420e3\n#define SAMPLE_STEPS            10\n#define DENSITY_STEPS           4\nfloat ray_sphere_exit(vec3 orig,vec3 dir,float radius) {float a=dot(dir,dir);float b=2.0*dot(dir,orig);float c=dot(orig,orig)-radius*radius;float d=sqrt(b*b-4.0*a*c);return (-b+d)/(2.0*a);}vec3 extinction(vec2 density) {return exp(-vec3(BETA_R*u_color_tint_r.a*density.x+BETA_M*u_color_tint_m.a*density.y));}vec2 local_density(vec3 point) {float height=max(length(point)-PLANET_RADIUS,0.0);float exp_r=exp(-height/DENSITY_HEIGHT_SCALE_R);float exp_m=exp(-height/DENSITY_HEIGHT_SCALE_M);return vec2(exp_r,exp_m);}float phase_ray(float cos_angle) {return (3.0/(16.0*PI))*(1.0+cos_angle*cos_angle);}float phase_mie(float cos_angle) {return (3.0/(8.0*PI))*((1.0-MIE_G*MIE_G)*(1.0+cos_angle*cos_angle))/((2.0+MIE_G*MIE_G)*pow(1.0+MIE_G*MIE_G-2.0*MIE_G*cos_angle,1.5));}vec2 density_to_atmosphere(vec3 point,vec3 light_dir) {float ray_len=ray_sphere_exit(point,light_dir,ATMOSPHERE_RADIUS);float step_len=ray_len/float(DENSITY_STEPS);vec2 density_point_to_atmosphere=vec2(0.0);for (int i=0; i < DENSITY_STEPS;++i) {vec3 point_on_ray=point+light_dir*((float(i)+0.5)*step_len);density_point_to_atmosphere+=local_density(point_on_ray)*step_len;;}return density_point_to_atmosphere;}vec3 atmosphere(vec3 ray_dir,vec3 sun_direction,float sun_intensity) {vec2 density_orig_to_point=vec2(0.0);vec3 scatter_r=vec3(0.0);vec3 scatter_m=vec3(0.0);vec3 origin=vec3(0.0,PLANET_RADIUS,0.0);float ray_len=ray_sphere_exit(origin,ray_dir,ATMOSPHERE_RADIUS);float step_len=ray_len/float(SAMPLE_STEPS);for (int i=0; i < SAMPLE_STEPS;++i) {vec3 point_on_ray=origin+ray_dir*((float(i)+0.5)*step_len);vec2 density=local_density(point_on_ray)*step_len;density_orig_to_point+=density;vec2 density_point_to_atmosphere=density_to_atmosphere(point_on_ray,sun_direction);vec2 density_orig_to_atmosphere=density_orig_to_point+density_point_to_atmosphere;vec3 extinction=extinction(density_orig_to_atmosphere);scatter_r+=density.x*extinction;scatter_m+=density.y*extinction;}float cos_angle=dot(ray_dir,sun_direction);float phase_r=phase_ray(cos_angle);float phase_m=phase_mie(cos_angle);vec3 beta_r=BETA_R*u_color_tint_r.rgb*u_color_tint_r.a;vec3 beta_m=BETA_M*u_color_tint_m.rgb*u_color_tint_m.a;return (scatter_r*phase_r*beta_r+scatter_m*phase_m*beta_m)*sun_intensity;}const float A=0.15;const float B=0.50;const float C=0.10;const float D=0.20;const float E=0.02;const float F=0.30;vec3 uncharted2_tonemap(vec3 x) {return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;}void main() {vec3 ray_direction=v_position;ray_direction.y=pow(ray_direction.y,5.0);const float y_bias=0.015;ray_direction.y+=y_bias;vec3 color=atmosphere(normalize(ray_direction),u_sun_direction,u_sun_intensity);float white_scale=1.0748724675633854;color=uncharted2_tonemap((log2(2.0/pow(u_luminance,4.0)))*color)*white_scale;gl_FragColor=vec4(color,1.0);}","attribute highp vec3 a_pos_3f;uniform mat3 u_matrix_3f;varying highp vec3 v_position;float map(float value,float start,float end,float new_start,float new_end) {return ((value-start)*(new_end-new_start))/(end-start)+new_start;}void main() {vec4 pos=vec4(u_matrix_3f*a_pos_3f,1.0);v_position=pos.xyz;v_position.y*=-1.0;v_position.y=map(v_position.y,-1.0,1.0,0.0,1.0);gl_Position=vec4(a_pos_3f.xy,0.0,1.0);}")};function Ge(t,e,i){const o=/#pragma mapbox: ([\w]+) ([\w]+) ([\w]+) ([\w]+)/g,r=e.match(/attribute (highp |mediump |lowp )?([\w]+) ([\w]+)/g),a=t.match(/uniform (highp |mediump |lowp )?([\w]+) ([\w]+)([\s]*)([\w]*)/g),n=e.match(/uniform (highp |mediump |lowp )?([\w]+) ([\w]+)([\s]*)([\w]*)/g);let s=n?n.concat(a):a;i||(s=Oe.staticUniforms.concat(s));const l={};return {fragmentSource:t=t.replace(o,((t,e,i,o,r)=>(l[r]=!0,"define"===e?`\n#ifndef HAS_UNIFORM_u_${r}\nvarying ${i} ${o} ${r};\n#else\nuniform ${i} ${o} u_${r};\n#endif\n`:`\n#ifdef HAS_UNIFORM_u_${r}\n    ${i} ${o} ${r} = u_${r};\n#endif\n`))),vertexSource:e=e.replace(o,((t,e,i,o,r)=>{const a="float"===o?"vec2":"vec4",n=r.match(/color/)?"color":a;return l[r]?"define"===e?`\n#ifndef HAS_UNIFORM_u_${r}\nuniform lowp float u_${r}_t;\nattribute ${i} ${a} a_${r};\nvarying ${i} ${o} ${r};\n#else\nuniform ${i} ${o} u_${r};\n#endif\n`:"vec4"===n?`\n#ifndef HAS_UNIFORM_u_${r}\n    ${r} = a_${r};\n#else\n    ${i} ${o} ${r} = u_${r};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${r}\n    ${r} = unpack_mix_${n}(a_${r}, u_${r}_t);\n#else\n    ${i} ${o} ${r} = u_${r};\n#endif\n`:"define"===e?`\n#ifndef HAS_UNIFORM_u_${r}\nuniform lowp float u_${r}_t;\nattribute ${i} ${a} a_${r};\n#else\nuniform ${i} ${o} u_${r};\n#endif\n`:"vec4"===n?`\n#ifndef HAS_UNIFORM_u_${r}\n    ${i} ${o} ${r} = a_${r};\n#else\n    ${i} ${o} ${r} = u_${r};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${r}\n    ${i} ${o} ${r} = unpack_mix_${n}(a_${r}, u_${r}_t);\n#else\n    ${i} ${o} ${r} = u_${r};\n#endif\n`})),staticAttributes:r,staticUniforms:s}}class Ze{constructor(){this.boundProgram=null,this.boundLayoutVertexBuffer=null,this.boundPaintVertexBuffers=[],this.boundIndexBuffer=null,this.boundVertexOffset=null,this.boundDynamicVertexBuffer=null,this.vao=null;}bind(t,e,i,o,r,a,n,s){this.context=t;let l=this.boundPaintVertexBuffers.length!==o.length;for(let t=0;!l&&t<o.length;t++)this.boundPaintVertexBuffers[t]!==o[t]&&(l=!0);t.extVertexArrayObject&&this.vao&&this.boundProgram===e&&this.boundLayoutVertexBuffer===i&&!l&&this.boundIndexBuffer===r&&this.boundVertexOffset===a&&this.boundDynamicVertexBuffer===n&&this.boundDynamicVertexBuffer2===s?(t.bindVertexArrayOES.set(this.vao),n&&n.bind(),r&&r.dynamicDraw&&r.bind(),s&&s.bind()):this.freshBind(e,i,o,r,a,n,s);}freshBind(t,e,i,o,r,a,n){let s;const l=t.numAttributes,c=this.context,h=c.gl;if(c.extVertexArrayObject)this.vao&&this.destroy(),this.vao=c.extVertexArrayObject.createVertexArrayOES(),c.bindVertexArrayOES.set(this.vao),s=0,this.boundProgram=t,this.boundLayoutVertexBuffer=e,this.boundPaintVertexBuffers=i,this.boundIndexBuffer=o,this.boundVertexOffset=r,this.boundDynamicVertexBuffer=a,this.boundDynamicVertexBuffer2=n;else {s=c.currentNumAttributes||0;for(let t=l;t<s;t++)h.disableVertexAttribArray(t);}e.enableAttributes(h,t);for(const e of i)e.enableAttributes(h,t);a&&a.enableAttributes(h,t),n&&n.enableAttributes(h,t),e.bind(),e.setVertexAttribPointers(h,t,r);for(const e of i)e.bind(),e.setVertexAttribPointers(h,t,r);a&&(a.bind(),a.setVertexAttribPointers(h,t,r)),o&&o.bind(),n&&(n.bind(),n.setVertexAttribPointers(h,t,r)),c.currentNumAttributes=l;}destroy(){this.vao&&(this.context.extVertexArrayObject.deleteVertexArrayOES(this.vao),this.vao=null);}}function Ve(e,i){const o=Math.pow(2,i.canonical.z),r=i.canonical.y;return [new t.MercatorCoordinate(0,r/o).toLngLat().lat,new t.MercatorCoordinate(0,(r+1)/o).toLngLat().lat]}function qe(e,i,o,r,a,n,s){const l=e.context,c=l.gl,h=o.fbo;if(!h)return;e.prepareDrawTile(i);const u=e.useProgram("hillshade");l.activeTexture.set(c.TEXTURE0),c.bindTexture(c.TEXTURE_2D,h.colorAttachment.get());const d=((t,e,i,o)=>{const r=i.paint.get("hillshade-shadow-color"),a=i.paint.get("hillshade-highlight-color"),n=i.paint.get("hillshade-accent-color");let s=i.paint.get("hillshade-illumination-direction")*(Math.PI/180);"viewport"===i.paint.get("hillshade-illumination-anchor")&&(s-=t.transform.angle);const l=!t.options.moving;return {u_matrix:o||t.transform.calculatePosMatrix(e.tileID.toUnwrapped(),l),u_image:0,u_latrange:Ve(0,e.tileID),u_light:[i.paint.get("hillshade-exaggeration"),s],u_shadow:r,u_highlight:a,u_accent:n}})(e,o,r,e.terrain?i.posMatrix:null);u.draw(l,c.TRIANGLES,a,n,s,t.CullFaceMode.disabled,d,r.id,e.rasterBoundsBuffer,e.quadTriangleIndexBuffer,e.rasterBoundsSegments);}function We(e,i,o){if(!i.needsDEMTextureUpload)return;const r=e.context,a=r.gl;r.pixelStoreUnpackPremultiplyAlpha.set(!1),i.demTexture=i.demTexture||e.getTileTexture(o.stride);const n=o.getPixels();i.demTexture?i.demTexture.update(n,{premultiply:!1}):i.demTexture=new t.Texture(r,n,a.RGBA,{premultiply:!1}),i.needsDEMTextureUpload=!1;}function je(e,i,o,r,a,n){const s=e.context,l=s.gl;if(!i.dem)return;const c=i.dem;if(s.activeTexture.set(l.TEXTURE1),We(e,i,c),!i.demTexture)return;i.demTexture.bind(l.NEAREST,l.CLAMP_TO_EDGE);const h=c.dim;s.activeTexture.set(l.TEXTURE0);let u=i.fbo;if(!u){const e=new t.Texture(s,{width:h,height:h,data:null},l.RGBA);e.bind(l.LINEAR,l.CLAMP_TO_EDGE),u=i.fbo=s.createFramebuffer(h,h,!0),u.colorAttachment.set(e.texture);}s.bindFramebuffer.set(u.framebuffer),s.viewport.set([0,0,h,h]),e.useProgram("hillshadePrepare").draw(s,l.TRIANGLES,r,a,n,t.CullFaceMode.disabled,((e,i)=>{const o=i.stride,r=t.create$1();return t.ortho(r,0,t.EXTENT,-t.EXTENT,0,0,1),t.translate(r,r,[0,-t.EXTENT,0]),{u_matrix:r,u_image:1,u_dimension:[o,o],u_zoom:e.overscaledZ,u_unpack:i.unpackVector}})(i.tileID,c),o.id,e.rasterBoundsBuffer,e.quadTriangleIndexBuffer,e.rasterBoundsSegments),i.needsHillshadePrepare=!1;}const Xe=(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_image0:new t.Uniform1i(e,i.u_image0),u_skirt_height:new t.Uniform1f(e,i.u_skirt_height)}),$e=(t,e)=>({u_matrix:t,u_image0:0,u_skirt_height:e}),He=new class{constructor(){this.operations={};}newMorphing(t,e,i,o,r){if(t in this.operations){const e=this.operations[t];e.to.tileID.key!==i.tileID.key&&(e.queued=i);}else this.operations[t]={startTime:o,phase:0,duration:r,from:e,to:i,queued:null};}getMorphValuesForProxy(t){if(!(t in this.operations))return null;const e=this.operations[t];return {from:e.from,to:e.to,phase:e.phase}}update(t){for(const e in this.operations){const i=this.operations[e];for(i.phase=(t-i.startTime)/i.duration;i.phase>=1||!this._validOp(i);)if(!this._nextOp(i,t)){delete this.operations[e];break}}}_nextOp(t,e){return !!t.queued&&(t.from=t.to,t.to=t.queued,t.queued=null,t.phase=0,t.startTime=e,!0)}_validOp(t){return t.from.hasData()&&t.to.hasData()}},Ke={0:null,1:"TERRAIN_VERTEX_MORPHING",2:"TERRAIN_WIREFRAME"};function Ye(e,i,o,r,a){const n=e.context,s=n.gl;let l,c;const h=e.options.showTerrainWireframe?2:0,u=(t,i)=>{if(c===t)return;const o=[Ke[t]];i&&o.push(Ke[h]),l=e.useProgram("terrainRaster",null,o),c=t;},d=e.colorModeForRenderPass(),_=new t.DepthMode(s.LEQUAL,t.DepthMode.ReadWrite,e.depthRangeFor3D);He.update(a);const m=e.transform,p=6*Math.pow(1.5,22-m.zoom)*i.exaggeration();(h?[!1,!0]:[!1]).forEach((e=>{c=-1;const h=e?s.LINES:s.TRIANGLES,[f,g]=e?i.getWirefameBuffer():[i.gridIndexBuffer,i.gridSegments];for(const c of r){const r=o.getTile(c),y=t.StencilMode.disabled,b=i.prevTerrainTileForTile[c.key],w=i.terrainTileForTile[c.key];v=w,null!=(x=b)&&null!=v&&x.hasData()&&v.hasData()&&null!=x.demTexture&&null!=v.demTexture&&x.tileID.key!==v.tileID.key&&He.newMorphing(c.key,b,w,a,250),n.activeTexture.set(s.TEXTURE0),r.texture.bind(s.LINEAR,s.CLAMP_TO_EDGE,s.LINEAR_MIPMAP_NEAREST);const T=He.getMorphValuesForProxy(c.key),E=T?1:0;let C;T&&(C={morphing:{srcDemTile:T.from,dstDemTile:T.to,phase:t.easeCubicInOut(T.phase)}});const S=$e(c.posMatrix,Je(c.canonical,m.renderWorldCopies)?p/10:p);u(E,e),i.setupElevationDraw(r,l,C),l.draw(n,h,_,y,d,t.CullFaceMode.backCCW,S,"terrain_raster",i.gridBuffer,f,g);}var x,v;}));}function Je(t,e){const i=1<<t.z;return !e&&(0===t.x||t.x===i-1)||0===t.y||t.y===i-1}const Qe=t=>({u_matrix:t});function ti(e,i,o,r,a){if(a>0){const n=t.exported.now(),s=(n-e.timeAdded)/a,l=i?(n-i.timeAdded)/a:-1,c=o.getSource(),h=r.coveringZoomLevel({tileSize:c.tileSize,roundZoom:c.roundZoom}),u=!i||Math.abs(i.tileID.overscaledZ-h)>Math.abs(e.tileID.overscaledZ-h),d=u&&e.refreshedUponExpiration?1:t.clamp(u?s:1-l,0,1);return e.refreshedUponExpiration&&s>=1&&(e.refreshedUponExpiration=!1),i?{opacity:1,mix:1-d}:{opacity:d,mix:0}}return {opacity:1,mix:0}}class ei extends t.SourceCache{constructor(t){const e=bt("proxy",{type:"geojson",maxzoom:t.transform.maxZoom},new E(Pt(),null),t.style);super("proxy",e,!1),e.setEventedParent(this),this.map=this.getSource().map=t,this.used=this._sourceLoaded=!0,this.renderCache=[],this.renderCachePool=[],this.proxyCachedFBO={};}update(e,i,o){if(e.freezeTileCoverage)return;this.transform=e;const r=e.coveringTiles({tileSize:this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom,reparseOverscaled:this._source.reparseOverscaled,useElevationData:!0}).reduce(((i,o)=>{if(i[o.key]="",!this._tiles[o.key]){const i=new t.Tile(o,this._source.tileSize*o.overscaleFactor(),e.tileZoom);i.state="loaded",this._tiles[o.key]=i;}return i}),{});for(const t in this._tiles)t in r||(this.freeFBO(t),this._tiles[t].state="unloaded",delete this._tiles[t]);}freeFBO(t){const e=this.proxyCachedFBO[t];if(void 0!==e){const i=Object.values(e);this.renderCachePool.push(...i),delete this.proxyCachedFBO[t];}}deallocRenderCache(){this.renderCache.forEach((t=>t.fb.destroy())),this.renderCache=[],this.renderCachePool=[],this.proxyCachedFBO={};}}class ii extends t.OverscaledTileID{constructor(t,e,i){super(t.overscaledZ,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y),this.proxyTileKey=e,this.posMatrix=i;}}class oi extends t.Elevation{constructor(e,i){super(),this.painter=e,this.terrainTileForTile={},this.prevTerrainTileForTile={};const[o,r,a]=function(e){const i=new t.StructArrayLayout4i8,o=new t.StructArrayLayout3ui6,r=131;i.reserve(17161),o.reserve(33800);const a=t.EXTENT/128,n=t.EXTENT+a/2,s=n+a;for(let e=-a;e<s;e+=a)for(let o=-a;o<s;o+=a){const r=o<0||o>n||e<0||e>n?24575:0,a=t.clamp(Math.round(o),0,t.EXTENT),s=t.clamp(Math.round(e),0,t.EXTENT);i.emplaceBack(a+r,s,a,s);}const l=(t,e)=>{const i=e*r+t;o.emplaceBack(i+1,i,i+r),o.emplaceBack(i+r,i+r+1,i+1);};for(let t=1;t<129;t++)for(let e=1;e<129;e++)l(e,t);return [0,129].forEach((t=>{for(let e=0;e<130;e++)l(e,t),l(t,e);})),[i,o,32768]}(),n=e.context;this.gridBuffer=n.createVertexBuffer(o,xt.members),this.gridIndexBuffer=n.createIndexBuffer(r),this.gridSegments=t.SegmentVector.simpleSegment(0,0,o.length,r.length),this.gridNoSkirtSegments=t.SegmentVector.simpleSegment(0,0,o.length,a),this.proxyCoords=[],this.proxiedCoords={},this._visibleDemTiles=[],this._drapedRenderBatches=[],this._sourceTilesOverlap={},this.proxySourceCache=new ei(i.map),this.orthoMatrix=t.create$1(),t.ortho(this.orthoMatrix,0,t.EXTENT,0,t.EXTENT,0,1);const s=n.gl;this._overlapStencilMode=new t.StencilMode({func:s.GEQUAL,mask:255},0,255,s.KEEP,s.KEEP,s.REPLACE),this._previousZoom=e.transform.zoom,this.pool=[],this._findCoveringTileCache={},this._tilesDirty={},this.style=i,this._useVertexMorphing=!0,this._exaggeration=1;}set style(t){t.on("data",this._onStyleDataEvent.bind(this)),t.on("neworder",this._checkRenderCacheEfficiency.bind(this)),this._style=t,this._checkRenderCacheEfficiency();}update(e,i,o){if(e&&e.terrain){this._style!==e&&(this.style=e),this.enabled=!0;const r=e.terrain.properties;this.sourceCache=e._getSourceCache(r.get("source")),this._exaggeration=r.get("exaggeration");const a=()=>{this.sourceCache.used&&t.warnOnce(`Raster DEM source '${this.sourceCache.id}' is used both for terrain and as layer source.\nThis leads to lower resolution of hillshade. For full hillshade resolution but higher memory consumption, define another raster DEM source.`);const e=this.sourceCache.getSource().tileSize/128,o=this.proxySourceCache.getSource().tileSize;this.sourceCache.update(i,e*o,!0),this._findCoveringTileCache[this.sourceCache.id]={};};this.sourceCache.usedForTerrain||(this._findCoveringTileCache[this.sourceCache.id]={},this.sourceCache.usedForTerrain=!0,a(),this._initializing=!0),a(),i.updateElevation(!o),this._findCoveringTileCache[this.proxySourceCache.id]={},this.proxySourceCache.update(i),this._emptyDEMTextureDirty=!0;}else this._disable();}_checkRenderCacheEfficiency(){const e=this.renderCacheEfficiency(this._style);this._style.map._optimizeForTerrain||100!==e.efficiency&&t.warnOnce(`Terrain render cache efficiency is not optimal (${e.efficiency}%) and performance\n                may be affected negatively, consider placing all background, fill and line layers before layer\n                with id '${e.firstUndrapedLayer}' or create a map using optimizeForTerrain: true option.`);}_onStyleDataEvent(t){t.coord&&"source"===t.dataType?this._clearRenderCacheForTile(t.sourceCacheId,t.coord):"style"===t.dataType&&(this._invalidateRenderCache=!0);}_disable(){if(this.enabled&&(this.enabled=!1,this.proxySourceCache.deallocRenderCache(),this._style))for(const t in this._style._sourceCaches)this._style._sourceCaches[t].usedForTerrain=!1;}destroy(){this._disable(),this._emptyDEMTexture&&this._emptyDEMTexture.destroy(),this.pool.forEach((t=>t.fb.destroy())),this.pool=[],this._depthFBO&&(this._depthFBO.destroy(),delete this._depthFBO,delete this._depthTexture);}_source(){return this.enabled?this.sourceCache:null}exaggeration(){return this._exaggeration}get visibleDemTiles(){return this._visibleDemTiles}get drapeBufferSize(){const t=2*this.proxySourceCache.getSource().tileSize;return [t,t]}set useVertexMorphing(t){this._useVertexMorphing=t;}updateTileBinding(e){if(!this.enabled)return;this.prevTerrainTileForTile=this.terrainTileForTile;const i=this.proxySourceCache,o=this.painter.transform;this._initializing&&(this._initializing=0===o._centerAltitude&&-1===this.getAtPoint(t.MercatorCoordinate.fromLngLat(o.center),-1),this._emptyDEMTextureDirty=!this._initializing);const r=this.painter.options;this.renderCached=(r.zooming||r.moving||r.rotating||!!this.forceRenderCached)&&!this._invalidateRenderCache,this._invalidateRenderCache=!1;const a=this.proxyCoords=i.getIds().map((t=>{const e=i.getTileByID(t).tileID;return e.posMatrix=o.calculatePosMatrix(e.toUnwrapped()),e}));!function(e,i){const o=i.transform.pointCoordinate(i.transform.getCameraPoint()),r=new t.pointGeometry(o.x,o.y);e.sort(((e,i)=>{if(i.overscaledZ-e.overscaledZ)return i.overscaledZ-e.overscaledZ;const o=new t.pointGeometry(e.canonical.x+(1<<e.canonical.z)*e.wrap,e.canonical.y),a=new t.pointGeometry(i.canonical.x+(1<<i.canonical.z)*i.wrap,i.canonical.y),n=r.mult(1<<e.canonical.z);return n.x-=.5,n.y-=.5,n.distSqr(o)-n.distSqr(a)}));}(a,this.painter),this._previousZoom=o.zoom;const n=this.proxyToSource||{};this.proxyToSource={},a.forEach((t=>{this.proxyToSource[t.key]={};})),this.terrainTileForTile={};const s=this._style._sourceCaches;for(const t in s){const i=s[t];if(!i.used)continue;if(i!==this.sourceCache&&(this._findCoveringTileCache[i.id]={}),this._setupProxiedCoordsForOrtho(i,e[t],n),i.usedForTerrain)continue;const o=e[t];i.getSource().reparseOverscaled&&this._assignTerrainTiles(o);}this.proxiedCoords[i.id]=a.map((t=>new ii(t,t.key,this.orthoMatrix))),this._assignTerrainTiles(a),this._prepareDEMTextures(),this._setupDrapedRenderBatches(),this._setupRenderCache(n),this.renderingToTexture=!1,this._initFBOPool(),this._updateTimestamp=t.exported.now();const l={};this._visibleDemTiles=[];for(const t of this.proxyCoords){const e=this.terrainTileForTile[t.key];if(!e)continue;const i=e.tileID.key;i in l||(this._visibleDemTiles.push(e),l[i]=i);}}_assignTerrainTiles(t){this._initializing||t.forEach((t=>{if(this.terrainTileForTile[t.key])return;const e=this._findTileCoveringTileID(t,this.sourceCache);e&&(this.terrainTileForTile[t.key]=e);}));}_prepareDEMTextures(){const t=this.painter.context,e=t.gl;for(const i in this.terrainTileForTile){const o=this.terrainTileForTile[i],r=o.dem;!r||o.demTexture&&!o.needsDEMTextureUpload||(t.activeTexture.set(e.TEXTURE1),We(this.painter,o,r));}}_prepareDemTileUniforms(t,e,i,o){if(!e||null==e.demTexture)return !1;const r=t.tileID.canonical,a=Math.pow(2,e.tileID.canonical.z-r.z),n=o||"";return i[`u_dem_tl${n}`]=[r.x*a%1,r.y*a%1],i[`u_dem_scale${n}`]=a,!0}get emptyDEMTexture(){return !this._emptyDEMTextureDirty&&this._emptyDEMTexture?this._emptyDEMTexture:this._updateEmptyDEMTexture()}_getLoadedAreaMinimum(){let t=0;const e=this._visibleDemTiles.reduce(((e,i)=>{if(!i.dem)return e;const o=i.dem.tree.minimums[0];return o>0&&t++,e+o}),0);return t?e/t:0}_updateEmptyDEMTexture(){const e=this.painter.context,i=e.gl;e.activeTexture.set(i.TEXTURE2);const o=this._getLoadedAreaMinimum(),r={width:1,height:1,data:new Uint8Array(t.DEMData.pack(o,this.sourceCache.getSource().encoding))};this._emptyDEMTextureDirty=!1;let a=this._emptyDEMTexture;return a?a.update(r,{premultiply:!1}):a=this._emptyDEMTexture=new t.Texture(e,r,i.RGBA,{premultiply:!1}),a}setupElevationDraw(e,i,o){const r=this.painter.context,a=r.gl,n=(s=this.sourceCache.getSource().encoding,{u_dem:2,u_dem_prev:4,u_dem_unpack:t.DEMData.getUnpackVector(s),u_dem_tl:[0,0],u_dem_tl_prev:[0,0],u_dem_scale:0,u_dem_scale_prev:0,u_dem_size:0,u_dem_lerp:1,u_depth:3,u_depth_size_inv:[0,0],u_exaggeration:0});var s;n.u_dem_size=this.sourceCache.getSource().tileSize,n.u_exaggeration=this.exaggeration();let l=null,c=null,h=1;if(o&&o.morphing&&this._useVertexMorphing){const t=o.morphing.srcDemTile,i=o.morphing.dstDemTile;h=o.morphing.phase,t&&i&&(this._prepareDemTileUniforms(e,t,n,"_prev")&&(c=t),this._prepareDemTileUniforms(e,i,n)&&(l=i));}if(c&&l?(r.activeTexture.set(a.TEXTURE2),l.demTexture.bind(a.NEAREST,a.CLAMP_TO_EDGE,a.NEAREST),r.activeTexture.set(a.TEXTURE4),c.demTexture.bind(a.NEAREST,a.CLAMP_TO_EDGE,a.NEAREST),n.u_dem_lerp=h):(l=this.terrainTileForTile[e.tileID.key],r.activeTexture.set(a.TEXTURE2),(this._prepareDemTileUniforms(e,l,n)?l.demTexture:this.emptyDEMTexture).bind(a.NEAREST,a.CLAMP_TO_EDGE,a.NEAREST)),o&&o.useDepthForOcclusion&&(r.activeTexture.set(a.TEXTURE3),this._depthTexture.bind(a.NEAREST,a.CLAMP_TO_EDGE,a.NEAREST),n.u_depth_size_inv=[1/this._depthFBO.width,1/this._depthFBO.height]),o&&o.useMeterToDem&&l){const e=(1<<l.tileID.canonical.z)*t.mercatorZfromAltitude(1,this.painter.transform.center.lat)*this.sourceCache.getSource().tileSize;n.u_meter_to_dem=e;}o&&o.labelPlaneMatrixInv&&(n.u_label_plane_matrix_inv=o.labelPlaneMatrixInv),i.setTerrainUniformValues(r,n);}renderBatch(e){if(0===this._drapedRenderBatches.length)return e+1;this.renderingToTexture=!0;const i=this.painter,o=this.painter.context,r=this.proxySourceCache,a=this.proxiedCoords[r.id],n=()=>{o.bindFramebuffer.set(null),o.viewport.set([0,0,i.width,i.height]),this.renderingToTexture=!1;},s=this._drapedRenderBatches.shift();let l=[];const c=i.style.order;let h=0;for(let u=0;u<a.length;u++){const d=a[u],_=r.getTileByID(d.proxyTileKey),m=r.proxyCachedFBO[d.key]?r.proxyCachedFBO[d.key][e]:void 0;let p,f;if(p=this.currentFBO=void 0!==m?r.renderCache[m]:this.pool[h++],_.texture=p.tex,void 0===m||p.dirty){o.bindFramebuffer.set(p.fb.framebuffer),this.renderedToTile=!1,p.dirty&&(o.clear({color:t.Color.transparent}),p.dirty=!1);for(let t=s.start;t<=s.end;++t){const e=i.style._layers[c[t]];if(e.isHidden(i.transform.zoom))continue;const r=i.style._getLayerSourceCache(e),a=r?this.proxyToSource[d.key][r.id]:[d];if(!a)continue;const n=a;o.viewport.set([0,0,p.fb.width,p.fb.height]),f!==(r?r.id:null)&&(this._setupStencil(a,e,r),f=r?r.id:null),i.renderLayer(i,r,e,n);}p.dirty=this.renderedToTile,this.renderedToTile&&l.push(_.tileID),5===h&&(h=0,l.length>0&&(n(),Ye(i,this,r,l,this._updateTimestamp),this.renderingToTexture=!0,l=[]));}else l.push(_.tileID);}return n(),l.length>0&&Ye(i,this,r,l,this._updateTimestamp),s.end+1}postRender(){}renderCacheEfficiency(t){const e=t.order.length;if(0===e)return {efficiency:100};let i,o=0,r=0,a=!1;for(let n=0;n<e;++n){const e=t._layers[t.order[n]];this._style.isLayerDraped(e)?(a&&++o,++r):a||(a=!0,i=e.id);}return 0===r?{efficiency:100}:{efficiency:100*(1-o/r),firstUndrapedLayer:i}}getMinElevationBelowMSL(){let t=0;return this._visibleDemTiles.filter((t=>t.dem)).forEach((e=>{t=Math.min(t,e.dem.tree.minimums[0]);})),0===t?t:(t-30)*this._exaggeration}raycast(t,e,i){if(!this._visibleDemTiles)return null;const o=this._visibleDemTiles.filter((t=>t.dem)).map((o=>{const r=o.tileID,a=Math.pow(2,r.overscaledZ),{x:n,y:s}=r.canonical,l=n/a,c=(n+1)/a,h=s/a,u=(s+1)/a;return {minx:l,miny:h,maxx:c,maxy:u,t:o.dem.tree.raycastRoot(l,h,c,u,t,e,i),tile:o}}));o.sort(((t,e)=>(null!==t.t?t.t:Number.MAX_VALUE)-(null!==e.t?e.t:Number.MAX_VALUE)));for(const r of o){if(null==r.t)return null;const o=r.tile.dem.tree.raycast(r.minx,r.miny,r.maxx,r.maxy,t,e,i);if(null!=o)return o}return null}_createFBO(){const e=this.painter.context,i=e.gl,o=this.drapeBufferSize;e.activeTexture.set(i.TEXTURE0);const r=new t.Texture(e,{width:o[0],height:o[1],data:null},i.RGBA);r.bind(i.LINEAR,i.CLAMP_TO_EDGE);const a=e.createFramebuffer(o[0],o[1],!1);return a.colorAttachment.set(r.texture),e.extTextureFilterAnisotropic&&!e.extTextureFilterAnisotropicForceOff&&i.texParameterf(i.TEXTURE_2D,e.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,e.extTextureFilterAnisotropicMax),{fb:a,tex:r,dirty:!1,ref:1}}_initFBOPool(){for(;this.pool.length<Math.min(5,this.proxyCoords.length);)this.pool.push(this._createFBO());}_shouldDisableRenderCache(){return !this.renderCached||this._style.order.some((t=>{const e=this._style._layers[t],i=!e.isHidden(this.painter.transform.zoom),o=e.getCrossfadeParameters();return "custom"!==e.type&&!i&&!!o&&1!==o.t}))}_clearRasterFadeFromRenderCache(){let t=!1;for(const e in this._style._sourceCaches)if(this._style._sourceCaches[e]._source instanceof gt){t=!0;break}if(t)for(let t=0;t<this._style.order.length;++t){const e=this._style._layers[this._style.order[t]],i=e.isHidden(this.painter.transform.zoom),o=this._style._getLayerSourceCache(e);if("raster"!==e.type||i||!o)continue;const r=e.paint.get("raster-fade-duration");for(const t of this.proxyCoords){const e=this.proxyToSource[t.key][o.id];if(e)for(const t of e){const e=ti(o.getTile(t),o.findLoadedParent(t,0),o,this.painter.transform,r);(1!==e.opacity||0!==e.mix)&&this._clearRenderCacheForTile(o.id,t);}}}}_setupDrapedRenderBatches(){const t=this._style.order,e=t.length;if(0===e)return;const i=[];let o,r=0,a=this._style._layers[t[r]];for(;!this._style.isLayerDraped(a)&&a.isHidden(this.painter.transform.zoom)&&++r<e;)a=this._style._layers[t[r]];for(;r<e;++r){const e=this._style._layers[t[r]];e.isHidden(this.painter.transform.zoom)||(this._style.isLayerDraped(e)?void 0===o&&(o=r):void 0!==o&&(i.push({start:o,end:r-1}),o=void 0));}void 0!==o&&i.push({start:o,end:r-1}),this._drapedRenderBatches=i;}_setupRenderCache(t){const e=this.proxySourceCache;if(this._shouldDisableRenderCache()){if(e.renderCache.length>e.renderCachePool.length){const t=Object.values(e.proxyCachedFBO);e.proxyCachedFBO={};for(let i=0;i<t.length;++i){const o=Object.values(t[i]);e.renderCachePool.push(...o);}}return}this._clearRasterFadeFromRenderCache();const i=this.proxyCoords,o=this._tilesDirty;for(let r=i.length-1;r>=0;r--){const a=i[r];if(e.getTileByID(a.key),void 0!==e.proxyCachedFBO[a.key]){const i=t[a.key],r=this.proxyToSource[a.key];let n=0;for(const t in r){const e=r[t],a=i[t];if(!a||a.length!==e.length||e.some(((e,i)=>e!==a[i]||o[t]&&o[t].hasOwnProperty(e.key)))){n=-1;break}++n;}for(const t in e.proxyCachedFBO[a.key])e.renderCache[e.proxyCachedFBO[a.key][t]].dirty=n<0||n!==Object.values(i).length;}else for(let t=0;t<this._drapedRenderBatches.length;++t){const i=this._drapedRenderBatches[t];let o=e.renderCachePool.pop();void 0===o&&e.renderCache.length<50&&(o=e.renderCache.length,e.renderCache.push(this._createFBO())),void 0!==o&&(void 0===e.proxyCachedFBO[a.key]&&(e.proxyCachedFBO[a.key]={}),e.proxyCachedFBO[a.key][i.start]=o,e.renderCache[o].dirty=!0);}}this._tilesDirty={};}_setupStencil(t,e,i){if(!i||!this._sourceTilesOverlap[i.id])return void(this._overlapStencilType&&(this._overlapStencilType=!1));const o=this.painter.context,r=o.gl;if(t.length<=1)return void(this._overlapStencilType=!1);const a=this.currentFBO,n=a.fb;let s;if(e.isTileClipped())s=t.length,this._overlapStencilMode.test={func:r.EQUAL,mask:255},this._overlapStencilType="Clip";else {if(!(t[0].overscaledZ>t[t.length-1].overscaledZ))return void(this._overlapStencilType=!1);s=1,this._overlapStencilMode.test={func:r.GREATER,mask:255},this._overlapStencilType="Mask";}if(!n.depthAttachment){const t=o.createRenderbuffer(o.gl.DEPTH_STENCIL,n.width,n.height);n.depthAttachment=new mt(o,n.framebuffer),n.depthAttachment.set(t),o.clear({stencil:0});}a.ref+s>255&&(o.clear({stencil:0}),a.ref=0),a.ref+=s,this._overlapStencilMode.ref=a.ref,e.isTileClipped()&&this._renderTileClippingMasks(t,this._overlapStencilMode.ref);}stencilModeForRTTOverlap(e){return this.renderingToTexture&&this._overlapStencilType?("Clip"===this._overlapStencilType&&(this._overlapStencilMode.ref=this.painter._tileClippingMaskIDs[e.key]),this._overlapStencilMode):t.StencilMode.disabled}_renderTileClippingMasks(e,i){const o=this.painter,r=this.painter.context,a=r.gl;o._tileClippingMaskIDs={},r.setColorMode(t.ColorMode.disabled),r.setDepthMode(t.DepthMode.disabled);const n=o.useProgram("clippingMask");for(const s of e){const e=o._tileClippingMaskIDs[s.key]=--i;n.draw(r,a.TRIANGLES,t.DepthMode.disabled,new t.StencilMode({func:a.ALWAYS,mask:0},e,255,a.KEEP,a.KEEP,a.REPLACE),t.ColorMode.disabled,t.CullFaceMode.disabled,Qe(s.posMatrix),"$clipping",o.tileExtentBuffer,o.quadTriangleIndexBuffer,o.tileExtentSegments);}}pointCoordinate(e){const i=this.painter.transform;if(e.x<0||e.x>i.width||e.y<0||e.y>i.height)return null;const o=[e.x,e.y,1,1];t.transformMat4(o,o,i.pixelMatrixInverse),t.scale$2(o,o,1/o[3]),o[0]/=i.worldSize,o[1]/=i.worldSize;const r=i._camera.position,a=t.mercatorZfromAltitude(1,i.center.lat),n=[r[0],r[1],r[2]/a,0],s=t.subtract([],o.slice(0,3),n);t.normalize(s,s);const l=this.raycast(n,s,this._exaggeration);return null!==l&&l?(t.scaleAndAdd(n,n,s,l),n[3]=n[2],n[2]*=a,n):null}drawDepth(){const e=this.painter,i=e.context,o=this.proxySourceCache,r=Math.ceil(e.width),a=Math.ceil(e.height);if(!this._depthFBO||this._depthFBO.width===r&&this._depthFBO.height===a||(this._depthFBO.destroy(),delete this._depthFBO,delete this._depthTexture),!this._depthFBO){const e=i.gl,o=i.createFramebuffer(r,a,!0);i.activeTexture.set(e.TEXTURE0);const n=new t.Texture(i,{width:r,height:a,data:null},e.RGBA);n.bind(e.NEAREST,e.CLAMP_TO_EDGE),o.colorAttachment.set(n.texture);const s=i.createRenderbuffer(i.gl.DEPTH_COMPONENT16,r,a);o.depthAttachment.set(s),this._depthFBO=o,this._depthTexture=n;}i.bindFramebuffer.set(this._depthFBO.framebuffer),i.viewport.set([0,0,r,a]),function(e,i,o,r){const a=e.context,n=a.gl;a.clear({depth:1});const s=e.useProgram("terrainDepth"),l=new t.DepthMode(n.LESS,t.DepthMode.ReadWrite,e.depthRangeFor3D);for(const e of r){const r=o.getTile(e),c=$e(e.posMatrix,0);i.setupElevationDraw(r,s),s.draw(a,n.TRIANGLES,l,t.StencilMode.disabled,t.ColorMode.unblended,t.CullFaceMode.backCCW,c,"terrain_depth",i.gridBuffer,i.gridIndexBuffer,i.gridNoSkirtSegments);}}(e,this,o,this.proxyCoords);}_setupProxiedCoordsForOrtho(t,e,i){if(t.getSource()instanceof vt)return this._setupProxiedCoordsForImageSource(t,e,i);this._findCoveringTileCache[t.id]=this._findCoveringTileCache[t.id]||{};const o=this.proxiedCoords[t.id]=[],r=this.proxyCoords;for(let e=0;e<r.length;e++){const a=r[e],n=this._findTileCoveringTileID(a,t);if(n){const e=this._createProxiedId(a,n,i[a.key]&&i[a.key][t.id]);o.push(e),this.proxyToSource[a.key][t.id]=[e];}}let a=!1;for(let r=0;r<e.length;r++){const n=t.getTile(e[r]);if(!n||!n.hasData())continue;const s=this._findTileCoveringTileID(n.tileID,this.proxySourceCache);if(s&&s.tileID.canonical.z!==n.tileID.canonical.z){const e=this.proxyToSource[s.tileID.key][t.id],r=this._createProxiedId(s.tileID,n,i[s.tileID.key]&&i[s.tileID.key][t.id]);e?e.splice(e.length-1,0,r):this.proxyToSource[s.tileID.key][t.id]=[r],o.push(r),a=!0;}}this._sourceTilesOverlap[t.id]=a;}_setupProxiedCoordsForImageSource(e,i,o){if(!e.getSource().loaded())return;const r=this.proxiedCoords[e.id]=[],a=this.proxyCoords,n=e.getSource(),s=new t.pointGeometry(n.tileID.x,n.tileID.y)._div(1<<n.tileID.z),l=n.coordinates.map(t.MercatorCoordinate.fromLngLat).reduce(((t,e)=>(t.min.x=Math.min(t.min.x,e.x-s.x),t.min.y=Math.min(t.min.y,e.y-s.y),t.max.x=Math.max(t.max.x,e.x-s.x),t.max.y=Math.max(t.max.y,e.y-s.y),t)),{min:new t.pointGeometry(Number.MAX_VALUE,Number.MAX_VALUE),max:new t.pointGeometry(-Number.MAX_VALUE,-Number.MAX_VALUE)}),c=(e,i)=>{const o=e.wrap+e.canonical.x/(1<<e.canonical.z),r=e.canonical.y/(1<<e.canonical.z),a=t.EXTENT/(1<<e.canonical.z),n=i.wrap+i.canonical.x/(1<<i.canonical.z),s=i.canonical.y/(1<<i.canonical.z);return o+a<n+l.min.x||o>n+l.max.x||r+a<s+l.min.y||r>s+l.max.y};for(let t=0;t<a.length;t++){const n=a[t];for(let t=0;t<i.length;t++){const a=e.getTile(i[t]);if(!a||!a.hasData())continue;if(c(n,a.tileID))continue;const s=this._createProxiedId(n,a,o[n.key]&&o[n.key][e.id]),l=this.proxyToSource[n.key][e.id];l?l.push(s):this.proxyToSource[n.key][e.id]=[s],r.push(s);}}}_createProxiedId(e,i,o){let r=this.orthoMatrix;if(o){const t=o.find((t=>t.key===i.tileID.key));if(t)return t}if(i.tileID.key!==e.key){const o=e.canonical.z-i.tileID.canonical.z;let a,n,s;r=t.create$1();const l=i.tileID.wrap-e.wrap<<e.overscaledZ;o>0?(a=t.EXTENT>>o,n=a*((i.tileID.canonical.x<<o)-e.canonical.x+l),s=a*((i.tileID.canonical.y<<o)-e.canonical.y)):(a=t.EXTENT<<-o,n=t.EXTENT*(i.tileID.canonical.x-(e.canonical.x+l<<-o)),s=t.EXTENT*(i.tileID.canonical.y-(e.canonical.y<<-o))),t.ortho(r,0,a,0,a,0,1),t.translate(r,r,[n,s,0]);}return new ii(i.tileID,e.key,r)}_findTileCoveringTileID(e,i){let o=i.getTile(e);if(o&&o.hasData())return o;const r=this._findCoveringTileCache[i.id],a=r[e.key];if(o=a?i.getTileByID(a):null,o&&o.hasData()||null===a)return o;let n=o?o.tileID:e,s=n.overscaledZ;const l=i.getSource().minzoom,c=[];if(!a){const r=i.getSource().maxzoom;if(e.canonical.z>=r){const o=e.canonical.z-r;i.getSource().reparseOverscaled?(s=Math.max(e.canonical.z+2,i.transform.tileZoom),n=new t.OverscaledTileID(s,e.wrap,r,e.canonical.x>>o,e.canonical.y>>o)):0!==o&&(s=r,n=new t.OverscaledTileID(s,e.wrap,r,e.canonical.x>>o,e.canonical.y>>o));}n.key!==e.key&&(c.push(n.key),o=i.getTile(n));}const h=t=>{c.forEach((e=>{r[e]=t;})),c.length=0;};for(s-=1;s>=l&&(!o||!o.hasData());s--){o&&h(o.tileID.key);const t=n.calculateScaledKey(s);if(o=i.getTileByID(t),o&&o.hasData())break;const e=r[t];if(null===e)break;void 0===e?c.push(t):o=i.getTileByID(e);}return h(o?o.tileID.key:null),o&&o.hasData()?o:null}findDEMTileFor(t){return this.enabled?this._findTileCoveringTileID(t,this.sourceCache):null}prepareDrawTile(t){this.renderedToTile||(this.renderedToTile=!0);}_clearRenderCacheForTile(t,e){let i=this._tilesDirty[t];i||(i=this._tilesDirty[t]={}),i[e.key]=!0;}getWirefameBuffer(){if(!this.wireframeSegments){const e=function(e){let i,o,r;const a=new t.StructArrayLayout2ui4,n=131;for(o=1;o<129;o++){for(i=1;i<129;i++)r=o*n+i,a.emplaceBack(r,r+1),a.emplaceBack(r,r+n),a.emplaceBack(r+1,r+n),128===o&&a.emplaceBack(r+n,r+n+1);a.emplaceBack(r+1,r+1+n);}return a}();this.wireframeIndexBuffer=this.painter.context.createIndexBuffer(e),this.wireframeSegments=t.SegmentVector.simpleSegment(0,0,this.gridBuffer.length,e.length);}return [this.wireframeIndexBuffer,this.wireframeSegments]}}function ri(t){const e=[];for(let i=0;i<t.length;i++){if(null===t[i])continue;const o=t[i].split(" ");e.push(o.pop());}return e}class ai{static cacheKey(t,e,i){let o=`${t}${i?i.cacheKey:""}`;for(const t of e)o+=`/${t}`;return o}constructor(e,i,o,r,a,n){const s=e.gl;this.program=s.createProgram();const l=ri(o.staticAttributes),c=r?r.getBinderAttributes():[],h=l.concat(c),u=o.staticUniforms?ri(o.staticUniforms):[],d=r?r.getBinderUniforms():[],_=u.concat(d),m=[];for(const t of _)m.indexOf(t)<0&&m.push(t);let p=r?r.defines():[];p=p.concat(n.map((t=>`#define ${t}`)));const f=p.concat(Ue.fragmentSource,o.fragmentSource).join("\n"),g=p.concat(Ue.vertexSource,Oe.vertexSource,o.vertexSource).join("\n"),x=s.createShader(s.FRAGMENT_SHADER);if(s.isContextLost())return void(this.failedToCreate=!0);s.shaderSource(x,f),s.compileShader(x),s.attachShader(this.program,x);const v=s.createShader(s.VERTEX_SHADER);if(s.isContextLost())return void(this.failedToCreate=!0);s.shaderSource(v,g),s.compileShader(v),s.attachShader(this.program,v),this.attributes={};const y={};this.numAttributes=h.length;for(let t=0;t<this.numAttributes;t++)h[t]&&(s.bindAttribLocation(this.program,t,h[t]),this.attributes[h[t]]=t);s.linkProgram(this.program),s.deleteShader(v),s.deleteShader(x);for(let t=0;t<m.length;t++){const e=m[t];if(e&&!y[e]){const t=s.getUniformLocation(this.program,e);t&&(y[e]=t);}}this.fixedUniforms=a(e,y),this.binderUniforms=r?r.getUniforms(e,y):[],-1!==n.indexOf("TERRAIN")&&(this.terrainUniforms=((e,i)=>({u_dem:new t.Uniform1i(e,i.u_dem),u_dem_prev:new t.Uniform1i(e,i.u_dem_prev),u_dem_unpack:new t.Uniform4f(e,i.u_dem_unpack),u_dem_tl:new t.Uniform2f(e,i.u_dem_tl),u_dem_scale:new t.Uniform1f(e,i.u_dem_scale),u_dem_tl_prev:new t.Uniform2f(e,i.u_dem_tl_prev),u_dem_scale_prev:new t.Uniform1f(e,i.u_dem_scale_prev),u_dem_size:new t.Uniform1f(e,i.u_dem_size),u_dem_lerp:new t.Uniform1f(e,i.u_dem_lerp),u_exaggeration:new t.Uniform1f(e,i.u_exaggeration),u_depth:new t.Uniform1i(e,i.u_depth),u_depth_size_inv:new t.Uniform2f(e,i.u_depth_size_inv),u_meter_to_dem:new t.Uniform1f(e,i.u_meter_to_dem),u_label_plane_matrix_inv:new t.UniformMatrix4f(e,i.u_label_plane_matrix_inv)}))(e,y));}setTerrainUniformValues(t,e){if(!this.terrainUniforms)return;const i=this.terrainUniforms;if(!this.failedToCreate){t.program.set(this.program);for(const t in e)i[t].set(e[t]);}}draw(t,e,i,o,r,a,n,s,l,c,h,u,d,_,m,p){const f=t.gl;if(this.failedToCreate)return;t.program.set(this.program),t.setDepthMode(i),t.setStencilMode(o),t.setColorMode(r),t.setCullFace(a);for(const t in this.fixedUniforms)this.fixedUniforms[t].set(n[t]);_&&_.setUniforms(t,this.binderUniforms,u,{zoom:d});const g={[f.LINES]:2,[f.TRIANGLES]:3,[f.LINE_STRIP]:1}[e];for(const i of h.get()){const o=i.vaos||(i.vaos={});(o[s]||(o[s]=new Ze)).bind(t,this,l,_?_.getPaintVertexBuffers():[],c,i.vertexOffset,m,p),f.drawElements(e,i.primitiveLength*g,f.UNSIGNED_SHORT,i.primitiveOffset*g*2);}}}function ni(t,e,i){const o=1/C(i,1,e.transform.tileZoom),r=Math.pow(2,i.tileID.overscaledZ),a=i.tileSize*Math.pow(2,e.transform.tileZoom)/r,n=a*(i.tileID.canonical.x+i.tileID.wrap*r),s=a*i.tileID.canonical.y;return {u_image:0,u_texsize:i.imageAtlasTexture.size,u_scale:[o,t.fromScale,t.toScale],u_fade:t.t,u_pixel_coord_upper:[n>>16,s>>16],u_pixel_coord_lower:[65535&n,65535&s]}}const si=(e,i,o,r)=>{const a=i.style.light,n=a.properties.get("position"),s=[n.x,n.y,n.z],l=t.create$2();"viewport"===a.properties.get("anchor")&&(t.fromRotation(l,-i.transform.angle),t.transformMat3(s,s,l));const c=a.properties.get("color");return {u_matrix:e,u_lightpos:s,u_lightintensity:a.properties.get("intensity"),u_lightcolor:[c.r,c.g,c.b],u_vertical_gradient:+o,u_opacity:r}},li=(e,i,o,r,a,n,s)=>t.extend(si(e,i,o,r),ni(n,i,s),{u_height_factor:-Math.pow(2,a.overscaledZ)/s.tileSize/8}),ci=t=>({u_matrix:t}),hi=(e,i,o,r)=>t.extend(ci(e),ni(o,i,r)),ui=(t,e)=>({u_matrix:t,u_world:e}),di=(e,i,o,r,a)=>t.extend(hi(e,i,o,r),{u_world:a}),_i=(e,i,o,r)=>{const a=e.transform;let n;if("map"===r.paint.get("circle-pitch-alignment")){const t=C(o,1,a.zoom);n=[t,t];}else n=a.pixelsToGLUnits;return {u_camera_to_center_distance:a.cameraToCenterDistance,u_matrix:e.translatePosMatrix(i.posMatrix,o,r.paint.get("circle-translate"),r.paint.get("circle-translate-anchor")),u_device_pixel_ratio:t.exported.devicePixelRatio,u_extrude_scale:n}},mi=t=>{const e=[];return "map"===t.paint.get("circle-pitch-alignment")&&e.push("PITCH_WITH_MAP"),"map"===t.paint.get("circle-pitch-scale")&&e.push("SCALE_WITH_MAP"),e},pi=(e,i,o)=>{const r=t.EXTENT/o.tileSize;return {u_matrix:e,u_camera_to_center_distance:i.cameraToCenterDistance,u_extrude_scale:[i.pixelsToGLUnits[0]/r,i.pixelsToGLUnits[1]/r]}},fi=(t,e,i=1)=>({u_matrix:t,u_color:e,u_overlay:0,u_overlay_scale:i}),gi=(t,e,i,o)=>({u_matrix:t,u_extrude_scale:C(e,1,i),u_intensity:o}),xi=(e,i,o,r)=>{const a=e.transform;return {u_matrix:Ti(e,i,o,r),u_ratio:1/C(i,1,a.zoom),u_device_pixel_ratio:t.exported.devicePixelRatio,u_units_to_pixels:[1/a.pixelsToGLUnits[0],1/a.pixelsToGLUnits[1]]}},vi=(e,i,o,r,a)=>t.extend(xi(e,i,o,r),{u_image:0,u_image_height:a}),yi=(e,i,o,r,a)=>{const n=e.transform,s=wi(i,n);return {u_matrix:Ti(e,i,o,a),u_texsize:i.imageAtlasTexture.size,u_ratio:1/C(i,1,n.zoom),u_device_pixel_ratio:t.exported.devicePixelRatio,u_image:0,u_scale:[s,r.fromScale,r.toScale],u_fade:r.t,u_units_to_pixels:[1/n.pixelsToGLUnits[0],1/n.pixelsToGLUnits[1]]}},bi=(e,i,o,r,a,n)=>{const s=e.lineAtlas,l=wi(i,e.transform),c="round"===o.layout.get("line-cap"),h=s.getDash(r.from,c),u=s.getDash(r.to,c),d=h.width*a.fromScale,_=u.width*a.toScale;return t.extend(xi(e,i,o,n),{u_patternscale_a:[l/d,-h.height/2],u_patternscale_b:[l/_,-u.height/2],u_sdfgamma:s.width/(256*Math.min(d,_)*t.exported.devicePixelRatio)/2,u_image:0,u_tex_y_a:h.y,u_tex_y_b:u.y,u_mix:a.t})};function wi(t,e){return 1/C(t,1,e.tileZoom)}function Ti(t,e,i,o){return t.translatePosMatrix(o||e.tileID.posMatrix,e,i.paint.get("line-translate"),i.paint.get("line-translate-anchor"))}const Ei=(t,e,i,o,r)=>{return {u_matrix:t,u_tl_parent:e,u_scale_parent:i,u_buffer_scale:1,u_fade_t:o.mix,u_opacity:o.opacity*r.paint.get("raster-opacity"),u_image0:0,u_image1:1,u_brightness_low:r.paint.get("raster-brightness-min"),u_brightness_high:r.paint.get("raster-brightness-max"),u_saturation_factor:(n=r.paint.get("raster-saturation"),n>0?1-1/(1.001-n):-n),u_contrast_factor:(a=r.paint.get("raster-contrast"),a>0?1/(1-a):1+a),u_spin_weights:Ci(r.paint.get("raster-hue-rotate"))};var a,n;};function Ci(t){t*=Math.PI/180;const e=Math.sin(t),i=Math.cos(t);return [(2*i+1)/3,(-Math.sqrt(3)*e-i+1)/3,(Math.sqrt(3)*e-i+1)/3]}const Si=(t,e,i,o,r,a,n,s,l,c)=>{const h=r.transform;return {u_is_size_zoom_constant:+("constant"===t||"source"===t),u_is_size_feature_constant:+("constant"===t||"camera"===t),u_size_t:e?e.uSizeT:0,u_size:e?e.uSize:0,u_camera_to_center_distance:h.cameraToCenterDistance,u_pitch:h.pitch/360*2*Math.PI,u_rotate_symbol:+i,u_aspect_ratio:h.width/h.height,u_fade_change:r.options.fadeDuration?r.symbolFadeChange:1,u_matrix:a,u_label_plane_matrix:n,u_coord_matrix:s,u_is_text:+l,u_pitch_with_map:+o,u_texsize:c,u_texture:0}},Ii=(e,i,o,r,a,n,s,l,c,h,u)=>{const{cameraToCenterDistance:d,_pitch:_}=a.transform;return t.extend(Si(e,i,o,r,a,n,s,l,c,h),{u_gamma_scale:r?d*Math.cos(a.terrain?0:_):1,u_device_pixel_ratio:t.exported.devicePixelRatio,u_is_halo:+u})},Mi=(e,i,o,r,a,n,s,l,c,h)=>t.extend(Ii(e,i,o,r,a,n,s,l,!0,c,!0),{u_texsize_icon:h,u_texture_icon:1}),zi=(t,e,i)=>({u_matrix:t,u_opacity:e,u_color:i}),Pi=(e,i,o,r,a,n)=>t.extend(function(t,e,i,o){const r=i.imageManager.getPattern(t.from.toString()),a=i.imageManager.getPattern(t.to.toString()),{width:n,height:s}=i.imageManager.getPixelSize(),l=Math.pow(2,o.tileID.overscaledZ),c=o.tileSize*Math.pow(2,i.transform.tileZoom)/l,h=c*(o.tileID.canonical.x+o.tileID.wrap*l),u=c*o.tileID.canonical.y;return {u_image:0,u_pattern_tl_a:r.tl,u_pattern_br_a:r.br,u_pattern_tl_b:a.tl,u_pattern_br_b:a.br,u_texsize:[n,s],u_mix:e.t,u_pattern_size_a:r.displaySize,u_pattern_size_b:a.displaySize,u_scale_a:e.fromScale,u_scale_b:e.toScale,u_tile_units_to_pixels:1/C(o,1,i.transform.tileZoom),u_pixel_coord_upper:[h>>16,u>>16],u_pixel_coord_lower:[65535&h,65535&u]}}(r,n,o,a),{u_matrix:e,u_opacity:i}),Ai={fillExtrusion:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_lightpos:new t.Uniform3f(e,i.u_lightpos),u_lightintensity:new t.Uniform1f(e,i.u_lightintensity),u_lightcolor:new t.Uniform3f(e,i.u_lightcolor),u_vertical_gradient:new t.Uniform1f(e,i.u_vertical_gradient),u_opacity:new t.Uniform1f(e,i.u_opacity)}),fillExtrusionPattern:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_lightpos:new t.Uniform3f(e,i.u_lightpos),u_lightintensity:new t.Uniform1f(e,i.u_lightintensity),u_lightcolor:new t.Uniform3f(e,i.u_lightcolor),u_vertical_gradient:new t.Uniform1f(e,i.u_vertical_gradient),u_height_factor:new t.Uniform1f(e,i.u_height_factor),u_image:new t.Uniform1i(e,i.u_image),u_texsize:new t.Uniform2f(e,i.u_texsize),u_pixel_coord_upper:new t.Uniform2f(e,i.u_pixel_coord_upper),u_pixel_coord_lower:new t.Uniform2f(e,i.u_pixel_coord_lower),u_scale:new t.Uniform3f(e,i.u_scale),u_fade:new t.Uniform1f(e,i.u_fade),u_opacity:new t.Uniform1f(e,i.u_opacity)}),fill:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix)}),fillPattern:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_image:new t.Uniform1i(e,i.u_image),u_texsize:new t.Uniform2f(e,i.u_texsize),u_pixel_coord_upper:new t.Uniform2f(e,i.u_pixel_coord_upper),u_pixel_coord_lower:new t.Uniform2f(e,i.u_pixel_coord_lower),u_scale:new t.Uniform3f(e,i.u_scale),u_fade:new t.Uniform1f(e,i.u_fade)}),fillOutline:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_world:new t.Uniform2f(e,i.u_world)}),fillOutlinePattern:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_world:new t.Uniform2f(e,i.u_world),u_image:new t.Uniform1i(e,i.u_image),u_texsize:new t.Uniform2f(e,i.u_texsize),u_pixel_coord_upper:new t.Uniform2f(e,i.u_pixel_coord_upper),u_pixel_coord_lower:new t.Uniform2f(e,i.u_pixel_coord_lower),u_scale:new t.Uniform3f(e,i.u_scale),u_fade:new t.Uniform1f(e,i.u_fade)}),circle:(e,i)=>({u_camera_to_center_distance:new t.Uniform1f(e,i.u_camera_to_center_distance),u_extrude_scale:new t.Uniform2f(e,i.u_extrude_scale),u_device_pixel_ratio:new t.Uniform1f(e,i.u_device_pixel_ratio),u_matrix:new t.UniformMatrix4f(e,i.u_matrix)}),collisionBox:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_camera_to_center_distance:new t.Uniform1f(e,i.u_camera_to_center_distance),u_extrude_scale:new t.Uniform2f(e,i.u_extrude_scale)}),collisionCircle:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_inv_matrix:new t.UniformMatrix4f(e,i.u_inv_matrix),u_camera_to_center_distance:new t.Uniform1f(e,i.u_camera_to_center_distance),u_viewport_size:new t.Uniform2f(e,i.u_viewport_size)}),debug:(e,i)=>({u_color:new t.UniformColor(e,i.u_color),u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_overlay:new t.Uniform1i(e,i.u_overlay),u_overlay_scale:new t.Uniform1f(e,i.u_overlay_scale)}),clippingMask:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix)}),heatmap:(e,i)=>({u_extrude_scale:new t.Uniform1f(e,i.u_extrude_scale),u_intensity:new t.Uniform1f(e,i.u_intensity),u_matrix:new t.UniformMatrix4f(e,i.u_matrix)}),heatmapTexture:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_world:new t.Uniform2f(e,i.u_world),u_image:new t.Uniform1i(e,i.u_image),u_color_ramp:new t.Uniform1i(e,i.u_color_ramp),u_opacity:new t.Uniform1f(e,i.u_opacity)}),hillshade:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_image:new t.Uniform1i(e,i.u_image),u_latrange:new t.Uniform2f(e,i.u_latrange),u_light:new t.Uniform2f(e,i.u_light),u_shadow:new t.UniformColor(e,i.u_shadow),u_highlight:new t.UniformColor(e,i.u_highlight),u_accent:new t.UniformColor(e,i.u_accent)}),hillshadePrepare:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_image:new t.Uniform1i(e,i.u_image),u_dimension:new t.Uniform2f(e,i.u_dimension),u_zoom:new t.Uniform1f(e,i.u_zoom),u_unpack:new t.Uniform4f(e,i.u_unpack)}),line:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_ratio:new t.Uniform1f(e,i.u_ratio),u_device_pixel_ratio:new t.Uniform1f(e,i.u_device_pixel_ratio),u_units_to_pixels:new t.Uniform2f(e,i.u_units_to_pixels)}),lineGradient:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_ratio:new t.Uniform1f(e,i.u_ratio),u_device_pixel_ratio:new t.Uniform1f(e,i.u_device_pixel_ratio),u_units_to_pixels:new t.Uniform2f(e,i.u_units_to_pixels),u_image:new t.Uniform1i(e,i.u_image),u_image_height:new t.Uniform1f(e,i.u_image_height)}),linePattern:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_texsize:new t.Uniform2f(e,i.u_texsize),u_ratio:new t.Uniform1f(e,i.u_ratio),u_device_pixel_ratio:new t.Uniform1f(e,i.u_device_pixel_ratio),u_image:new t.Uniform1i(e,i.u_image),u_units_to_pixels:new t.Uniform2f(e,i.u_units_to_pixels),u_scale:new t.Uniform3f(e,i.u_scale),u_fade:new t.Uniform1f(e,i.u_fade)}),lineSDF:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_ratio:new t.Uniform1f(e,i.u_ratio),u_device_pixel_ratio:new t.Uniform1f(e,i.u_device_pixel_ratio),u_units_to_pixels:new t.Uniform2f(e,i.u_units_to_pixels),u_patternscale_a:new t.Uniform2f(e,i.u_patternscale_a),u_patternscale_b:new t.Uniform2f(e,i.u_patternscale_b),u_sdfgamma:new t.Uniform1f(e,i.u_sdfgamma),u_image:new t.Uniform1i(e,i.u_image),u_tex_y_a:new t.Uniform1f(e,i.u_tex_y_a),u_tex_y_b:new t.Uniform1f(e,i.u_tex_y_b),u_mix:new t.Uniform1f(e,i.u_mix)}),raster:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_tl_parent:new t.Uniform2f(e,i.u_tl_parent),u_scale_parent:new t.Uniform1f(e,i.u_scale_parent),u_buffer_scale:new t.Uniform1f(e,i.u_buffer_scale),u_fade_t:new t.Uniform1f(e,i.u_fade_t),u_opacity:new t.Uniform1f(e,i.u_opacity),u_image0:new t.Uniform1i(e,i.u_image0),u_image1:new t.Uniform1i(e,i.u_image1),u_brightness_low:new t.Uniform1f(e,i.u_brightness_low),u_brightness_high:new t.Uniform1f(e,i.u_brightness_high),u_saturation_factor:new t.Uniform1f(e,i.u_saturation_factor),u_contrast_factor:new t.Uniform1f(e,i.u_contrast_factor),u_spin_weights:new t.Uniform3f(e,i.u_spin_weights)}),symbolIcon:(e,i)=>({u_is_size_zoom_constant:new t.Uniform1i(e,i.u_is_size_zoom_constant),u_is_size_feature_constant:new t.Uniform1i(e,i.u_is_size_feature_constant),u_size_t:new t.Uniform1f(e,i.u_size_t),u_size:new t.Uniform1f(e,i.u_size),u_camera_to_center_distance:new t.Uniform1f(e,i.u_camera_to_center_distance),u_pitch:new t.Uniform1f(e,i.u_pitch),u_rotate_symbol:new t.Uniform1i(e,i.u_rotate_symbol),u_aspect_ratio:new t.Uniform1f(e,i.u_aspect_ratio),u_fade_change:new t.Uniform1f(e,i.u_fade_change),u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_label_plane_matrix:new t.UniformMatrix4f(e,i.u_label_plane_matrix),u_coord_matrix:new t.UniformMatrix4f(e,i.u_coord_matrix),u_is_text:new t.Uniform1i(e,i.u_is_text),u_pitch_with_map:new t.Uniform1i(e,i.u_pitch_with_map),u_texsize:new t.Uniform2f(e,i.u_texsize),u_texture:new t.Uniform1i(e,i.u_texture)}),symbolSDF:(e,i)=>({u_is_size_zoom_constant:new t.Uniform1i(e,i.u_is_size_zoom_constant),u_is_size_feature_constant:new t.Uniform1i(e,i.u_is_size_feature_constant),u_size_t:new t.Uniform1f(e,i.u_size_t),u_size:new t.Uniform1f(e,i.u_size),u_camera_to_center_distance:new t.Uniform1f(e,i.u_camera_to_center_distance),u_pitch:new t.Uniform1f(e,i.u_pitch),u_rotate_symbol:new t.Uniform1i(e,i.u_rotate_symbol),u_aspect_ratio:new t.Uniform1f(e,i.u_aspect_ratio),u_fade_change:new t.Uniform1f(e,i.u_fade_change),u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_label_plane_matrix:new t.UniformMatrix4f(e,i.u_label_plane_matrix),u_coord_matrix:new t.UniformMatrix4f(e,i.u_coord_matrix),u_is_text:new t.Uniform1i(e,i.u_is_text),u_pitch_with_map:new t.Uniform1i(e,i.u_pitch_with_map),u_texsize:new t.Uniform2f(e,i.u_texsize),u_texture:new t.Uniform1i(e,i.u_texture),u_gamma_scale:new t.Uniform1f(e,i.u_gamma_scale),u_device_pixel_ratio:new t.Uniform1f(e,i.u_device_pixel_ratio),u_is_halo:new t.Uniform1i(e,i.u_is_halo)}),symbolTextAndIcon:(e,i)=>({u_is_size_zoom_constant:new t.Uniform1i(e,i.u_is_size_zoom_constant),u_is_size_feature_constant:new t.Uniform1i(e,i.u_is_size_feature_constant),u_size_t:new t.Uniform1f(e,i.u_size_t),u_size:new t.Uniform1f(e,i.u_size),u_camera_to_center_distance:new t.Uniform1f(e,i.u_camera_to_center_distance),u_pitch:new t.Uniform1f(e,i.u_pitch),u_rotate_symbol:new t.Uniform1i(e,i.u_rotate_symbol),u_aspect_ratio:new t.Uniform1f(e,i.u_aspect_ratio),u_fade_change:new t.Uniform1f(e,i.u_fade_change),u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_label_plane_matrix:new t.UniformMatrix4f(e,i.u_label_plane_matrix),u_coord_matrix:new t.UniformMatrix4f(e,i.u_coord_matrix),u_is_text:new t.Uniform1i(e,i.u_is_text),u_pitch_with_map:new t.Uniform1i(e,i.u_pitch_with_map),u_texsize:new t.Uniform2f(e,i.u_texsize),u_texsize_icon:new t.Uniform2f(e,i.u_texsize_icon),u_texture:new t.Uniform1i(e,i.u_texture),u_texture_icon:new t.Uniform1i(e,i.u_texture_icon),u_gamma_scale:new t.Uniform1f(e,i.u_gamma_scale),u_device_pixel_ratio:new t.Uniform1f(e,i.u_device_pixel_ratio),u_is_halo:new t.Uniform1i(e,i.u_is_halo)}),background:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_opacity:new t.Uniform1f(e,i.u_opacity),u_color:new t.UniformColor(e,i.u_color)}),backgroundPattern:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_opacity:new t.Uniform1f(e,i.u_opacity),u_image:new t.Uniform1i(e,i.u_image),u_pattern_tl_a:new t.Uniform2f(e,i.u_pattern_tl_a),u_pattern_br_a:new t.Uniform2f(e,i.u_pattern_br_a),u_pattern_tl_b:new t.Uniform2f(e,i.u_pattern_tl_b),u_pattern_br_b:new t.Uniform2f(e,i.u_pattern_br_b),u_texsize:new t.Uniform2f(e,i.u_texsize),u_mix:new t.Uniform1f(e,i.u_mix),u_pattern_size_a:new t.Uniform2f(e,i.u_pattern_size_a),u_pattern_size_b:new t.Uniform2f(e,i.u_pattern_size_b),u_scale_a:new t.Uniform1f(e,i.u_scale_a),u_scale_b:new t.Uniform1f(e,i.u_scale_b),u_pixel_coord_upper:new t.Uniform2f(e,i.u_pixel_coord_upper),u_pixel_coord_lower:new t.Uniform2f(e,i.u_pixel_coord_lower),u_tile_units_to_pixels:new t.Uniform1f(e,i.u_tile_units_to_pixels)}),terrainRaster:Xe,terrainDepth:Xe,skybox:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_sun_direction:new t.Uniform3f(e,i.u_sun_direction),u_cubemap:new t.Uniform1i(e,i.u_cubemap),u_opacity:new t.Uniform1f(e,i.u_opacity),u_temporal_offset:new t.Uniform1f(e,i.u_temporal_offset)}),skyboxGradient:(e,i)=>({u_matrix:new t.UniformMatrix4f(e,i.u_matrix),u_color_ramp:new t.Uniform1i(e,i.u_color_ramp),u_center_direction:new t.Uniform3f(e,i.u_center_direction),u_radius:new t.Uniform1f(e,i.u_radius),u_opacity:new t.Uniform1f(e,i.u_opacity),u_temporal_offset:new t.Uniform1f(e,i.u_temporal_offset)}),skyboxCapture:(e,i)=>({u_matrix_3f:new t.UniformMatrix3f(e,i.u_matrix_3f),u_sun_direction:new t.Uniform3f(e,i.u_sun_direction),u_sun_intensity:new t.Uniform1f(e,i.u_sun_intensity),u_color_tint_r:new t.Uniform4f(e,i.u_color_tint_r),u_color_tint_m:new t.Uniform4f(e,i.u_color_tint_m),u_luminance:new t.Uniform1f(e,i.u_luminance)})};let Di;function Li(e,i,o,r,a,n,s){const l=e.context,c=l.gl,h=e.useProgram("collisionBox"),u=[];let d=0,_=0;for(let m=0;m<r.length;m++){const p=r[m],f=i.getTile(p),g=f.getBucket(o);if(!g)continue;let x=p.posMatrix;0===a[0]&&0===a[1]||(x=e.translatePosMatrix(p.posMatrix,f,a,n));const v=s?g.textCollisionBox:g.iconCollisionBox,y=g.collisionCircleArray;if(y.length>0){const i=t.create$1(),o=x;t.mul$1(i,g.placementInvProjMatrix,e.transform.glCoordMatrix),t.mul$1(i,i,g.placementViewportMatrix),u.push({circleArray:y,circleOffset:_,transform:o,invTransform:i}),d+=y.length/4,_=d;}v&&(e.terrain&&e.terrain.setupElevationDraw(f,h),h.draw(l,c.LINES,t.DepthMode.disabled,t.StencilMode.disabled,e.colorModeForRenderPass(),t.CullFaceMode.disabled,pi(x,e.transform,f),o.id,v.layoutVertexBuffer,v.indexBuffer,v.segments,null,e.transform.zoom,null,v.collisionVertexBuffer,v.collisionVertexBufferExt));}if(!s||!u.length)return;const m=e.useProgram("collisionCircle"),p=new t.StructArrayLayout2f1f2i16;p.resize(4*d),p._trim();let f=0;for(const t of u)for(let e=0;e<t.circleArray.length/4;e++){const i=4*e,o=t.circleArray[i+0],r=t.circleArray[i+1],a=t.circleArray[i+2],n=t.circleArray[i+3];p.emplace(f++,o,r,a,n,0),p.emplace(f++,o,r,a,n,1),p.emplace(f++,o,r,a,n,2),p.emplace(f++,o,r,a,n,3);}(!Di||Di.length<2*d)&&(Di=function(e){const i=2*e,o=new t.StructArrayLayout3ui6;o.resize(i),o._trim();for(let t=0;t<i;t++){const e=6*t;o.uint16[e+0]=4*t+0,o.uint16[e+1]=4*t+1,o.uint16[e+2]=4*t+2,o.uint16[e+3]=4*t+2,o.uint16[e+4]=4*t+3,o.uint16[e+5]=4*t+0;}return o}(d));const g=l.createIndexBuffer(Di,!0),x=l.createVertexBuffer(p,t.collisionCircleLayout.members,!0);for(const i of u){const r={u_matrix:i.transform,u_inv_matrix:i.invTransform,u_camera_to_center_distance:(v=e.transform).cameraToCenterDistance,u_viewport_size:[v.width,v.height]};m.draw(l,c.TRIANGLES,t.DepthMode.disabled,t.StencilMode.disabled,e.colorModeForRenderPass(),t.CullFaceMode.disabled,r,o.id,x,g,t.SegmentVector.simpleSegment(0,2*i.circleOffset,i.circleArray.length,i.circleArray.length/2),null,e.transform.zoom,null,null,null);}var v;x.destroy(),g.destroy();}const Ri=t.identity(new Float32Array(16));function ki(e,i,o,r,a,n){const{horizontalAlign:s,verticalAlign:l}=t.getAnchorAlignment(e),c=-(s-.5)*i,h=-(l-.5)*o,u=t.evaluateVariableOffset(e,r);return new t.pointGeometry((c/a+u[0])*n,(h/a+u[1])*n)}function Bi(e,i,o,r,a,n,s,l,c,h,u,d){const _=e.text.placedSymbolArray,m=e.text.dynamicLayoutVertexArray,p=e.icon.dynamicLayoutVertexArray,f={};m.clear();for(let p=0;p<_.length;p++){const g=_.get(p),x=e.allowVerticalPlacement&&!g.placedOrientation,v=g.hidden||!g.crossTileID||x?null:r[g.crossTileID];if(v){const r=new t.pointGeometry(g.anchorX,g.anchorY),_=d(r),p=Wt(r,o?l:s,_),x=jt(n.cameraToCenterDistance,p.signedDistanceFromCamera);let y=a.evaluateSizeForFeature(e.textSizeData,h,g)*x/t.ONE_EM;o&&(y*=e.tilePixelRatio/c);const{width:b,height:w,anchor:T,textOffset:E,textBoxScale:C}=v,S=ki(T,b,w,E,C,y),I=o?Wt(r.add(S),s,_).point:p.point.add(i?S.rotate(-n.angle):S),M=e.allowVerticalPlacement&&g.placedOrientation===t.WritingMode.vertical?Math.PI/2:0;for(let e=0;e<g.numGlyphs;e++)t.addDynamicAttributes(m,I,M);u&&g.associatedIconIndex>=0&&(f[g.associatedIconIndex]={shiftedAnchor:I,angle:M});}else ee(g.numGlyphs,m);}if(u){p.clear();const i=e.icon.placedSymbolArray;for(let e=0;e<i.length;e++){const o=i.get(e);if(o.hidden)ee(o.numGlyphs,p);else {const i=f[e];if(i)for(let e=0;e<o.numGlyphs;e++)t.addDynamicAttributes(p,i.shiftedAnchor,i.angle);else ee(o.numGlyphs,p);}}e.icon.dynamicLayoutVertexBuffer.updateData(p);}e.text.dynamicLayoutVertexBuffer.updateData(m);}function Fi(t,e,i){return i.iconsInText&&e?"symbolTextAndIcon":t?"symbolSDF":"symbolIcon"}function Oi(e,i,o,r,a,n,s,l,c,h,u,d){const _=e.context,m=_.gl,p=e.transform,f="map"===l,g="map"===c,x=f&&"point"!==o.layout.get("symbol-placement"),v=f&&!g&&!x,y=void 0!==o.layout.get("symbol-sort-key").constantOr(1);let b=!1;const w=e.depthModeForSublayer(0,t.DepthMode.ReadOnly),T=o.layout.get("text-variable-anchor"),E=[],S=e.terrain&&g?["PITCH_WITH_MAP_TERRAIN"]:null;for(const l of r){const r=i.getTile(l),c=r.getBucket(o);if(!c)continue;const u=a?c.text:c.icon;if(!u||!u.segments.get().length)continue;const d=u.programConfigurations.get(o.id),_=a||c.sdfIcons,w=a?c.textSizeData:c.iconSizeData,I=g||0!==p.pitch,M=e.useProgram(Fi(_,a,c),d,S),z=t.evaluateSizeForZoom(w,p.zoom);let P,A,D,L,R=[0,0],k=null;if(a){if(A=r.glyphAtlasTexture,D=m.LINEAR,P=r.glyphAtlasTexture.size,c.iconsInText){R=r.imageAtlasTexture.size,k=r.imageAtlasTexture;const t="composite"===w.kind||"camera"===w.kind;L=I||e.options.rotating||e.options.zooming||t?m.LINEAR:m.NEAREST;}}else {const t=1!==o.layout.get("icon-size").constantOr(0)||c.iconsNeedLinear;A=r.imageAtlasTexture,D=_||e.options.rotating||e.options.zooming||t||I?m.LINEAR:m.NEAREST,P=r.imageAtlasTexture.size;}const B=C(r,1,e.transform.zoom),F=Vt(l.posMatrix,g,f,e.transform,B),O=e.terrain&&g&&x?t.invert(new Float32Array(16),F):Ri,U=qt(l.posMatrix,g,f,e.transform,B),N=T&&c.hasTextData(),G="none"!==o.layout.get("icon-text-fit")&&N&&c.hasIconData();if(x){const t=p.elevation;$t(c,l.posMatrix,e,a,F,U,g,h,t?e=>t.getAtTileOffset(l,e.x,e.y):null);}const Z=e.translatePosMatrix(l.posMatrix,r,n,s),V=x||a&&T||G?Ri:F,q=e.translatePosMatrix(U,r,n,s,!0),W=_&&0!==o.paint.get(a?"text-halo-width":"icon-halo-width").constantOr(1);let j;j=_?c.iconsInText?Mi(w.kind,z,v,g,e,Z,V,q,P,R):Ii(w.kind,z,v,g,e,Z,V,q,a,P,!0):Si(w.kind,z,v,g,e,Z,V,q,a,P);const X={program:M,buffers:u,uniformValues:j,atlasTexture:A,atlasTextureIcon:k,atlasInterpolation:D,atlasInterpolationIcon:L,isSDF:_,hasHalo:W,tile:r,labelPlaneMatrixInv:O};if(y&&c.canOverlap){b=!0;const e=u.segments.get();for(const i of e)E.push({segments:new t.SegmentVector([i]),sortKey:i.sortKey,state:X});}else E.push({segments:u.segments,sortKey:0,state:X});}b&&E.sort(((t,e)=>t.sortKey-e.sortKey));for(const t of E){const i=t.state;if(e.terrain&&e.terrain.setupElevationDraw(i.tile,i.program,{useDepthForOcclusion:!0,labelPlaneMatrixInv:i.labelPlaneMatrixInv}),_.activeTexture.set(m.TEXTURE0),i.atlasTexture.bind(i.atlasInterpolation,m.CLAMP_TO_EDGE),i.atlasTextureIcon&&(_.activeTexture.set(m.TEXTURE1),i.atlasTextureIcon&&i.atlasTextureIcon.bind(i.atlasInterpolationIcon,m.CLAMP_TO_EDGE)),i.isSDF){const r=i.uniformValues;i.hasHalo&&(r.u_is_halo=1,Ui(i.buffers,t.segments,o,e,i.program,w,u,d,r)),r.u_is_halo=0;}Ui(i.buffers,t.segments,o,e,i.program,w,u,d,i.uniformValues);}}function Ui(e,i,o,r,a,n,s,l,c){const h=r.context;a.draw(h,h.gl.TRIANGLES,n,s,l,t.CullFaceMode.disabled,c,o.id,e.layoutVertexBuffer,e.indexBuffer,i,o.paint,r.transform.zoom,e.programConfigurations.get(o.id),e.dynamicLayoutVertexBuffer,e.opacityVertexBuffer);}function Ni(e,i,o,r,a,n,s){const l=e.context.gl,c=o.paint.get("fill-pattern"),h=c&&c.constantOr(1),u=o.getCrossfadeParameters();let d,_,m,p,f;s?(_=h&&!o.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline",d=l.LINES):(_=h?"fillPattern":"fill",d=l.TRIANGLES);for(const g of r){const r=i.getTile(g);if(h&&!r.patternsLoaded())continue;const x=r.getBucket(o);if(!x)continue;e.prepareDrawTile(g);const v=x.programConfigurations.get(o.id),y=e.useProgram(_,v);h&&(e.context.activeTexture.set(l.TEXTURE0),r.imageAtlasTexture.bind(l.LINEAR,l.CLAMP_TO_EDGE),v.updatePaintBuffers(u));const b=c.constantOr(null);if(b&&r.imageAtlas){const t=r.imageAtlas,e=t.patternPositions[b.to.toString()],i=t.patternPositions[b.from.toString()];e&&i&&v.setConstantPatternPositions(e,i);}const w=e.translatePosMatrix(g.posMatrix,r,o.paint.get("fill-translate"),o.paint.get("fill-translate-anchor"));if(s){p=x.indexBuffer2,f=x.segments2;const t=e.terrain&&e.terrain.renderingToTexture?e.terrain.drapeBufferSize:[l.drawingBufferWidth,l.drawingBufferHeight];m="fillOutlinePattern"===_&&h?di(w,e,u,r,t):ui(w,t);}else p=x.indexBuffer,f=x.segments,m=h?hi(w,e,u,r):ci(w);y.draw(e.context,d,a,e.stencilModeForClipping(g),n,t.CullFaceMode.disabled,m,o.id,x.layoutVertexBuffer,p,f,o.paint,e.transform.zoom,v);}}function Gi(e,i,o,r,a,n,s){const l=e.context,c=l.gl,h=o.paint.get("fill-extrusion-pattern"),u=h.constantOr(1),d=o.getCrossfadeParameters(),_=o.paint.get("fill-extrusion-opacity");for(const m of r){const r=i.getTile(m),p=r.getBucket(o);if(!p)continue;const f=p.programConfigurations.get(o.id),g=e.useProgram(u?"fillExtrusionPattern":"fillExtrusion",f);if(e.terrain){const t=e.terrain;if(!p.enableTerrain)continue;if(t.setupElevationDraw(r,g,{useMeterToDem:!0}),Zi(l,i,m,p,o,t),!p.centroidVertexBuffer){const t=g.attributes.a_centroid_pos;void 0!==t&&c.vertexAttrib2f(t,0,0);}}u&&(e.context.activeTexture.set(c.TEXTURE0),r.imageAtlasTexture.bind(c.LINEAR,c.CLAMP_TO_EDGE),f.updatePaintBuffers(d));const x=h.constantOr(null);if(x&&r.imageAtlas){const t=r.imageAtlas,e=t.patternPositions[x.to.toString()],i=t.patternPositions[x.from.toString()];e&&i&&f.setConstantPatternPositions(e,i);}const v=e.translatePosMatrix(m.posMatrix,r,o.paint.get("fill-extrusion-translate"),o.paint.get("fill-extrusion-translate-anchor")),y=o.paint.get("fill-extrusion-vertical-gradient"),b=u?li(v,e,y,_,m,d,r):si(v,e,y,_);g.draw(l,l.gl.TRIANGLES,a,n,s,t.CullFaceMode.backCCW,b,o.id,p.layoutVertexBuffer,p.indexBuffer,p.segments,o.paint,e.transform.zoom,f,e.terrain?p.centroidVertexBuffer:null);}}function Zi(e,i,o,r,a,n){const s=[e=>{let i=e.canonical.x-1,o=e.wrap;return i<0&&(i=(1<<e.canonical.z)-1,o--),new t.OverscaledTileID(e.overscaledZ,o,e.canonical.z,i,e.canonical.y)},e=>{let i=e.canonical.x+1,o=e.wrap;return i===1<<e.canonical.z&&(i=0,o++),new t.OverscaledTileID(e.overscaledZ,o,e.canonical.z,i,e.canonical.y)},e=>new t.OverscaledTileID(e.overscaledZ,e.wrap,e.canonical.z,e.canonical.x,(0===e.canonical.y?1<<e.canonical.z:e.canonical.y)-1),e=>new t.OverscaledTileID(e.overscaledZ,e.wrap,e.canonical.z,e.canonical.x,e.canonical.y===(1<<e.canonical.z)-1?0:e.canonical.y+1)],l=t=>{const e=i.getSource().maxzoom,o=t=>{const e=i.getTileByID(t);if(e&&e.hasData())return e.getBucket(a)};let r,n,s;return (t.overscaledZ===t.canonical.z||t.overscaledZ>=e)&&(r=o(t.key)),t.overscaledZ>=e&&(n=o(t.calculateScaledKey(t.overscaledZ+1))),t.overscaledZ>e&&(s=o(t.calculateScaledKey(t.overscaledZ-1))),r||n||s},c=[0,0,0],h=(e,i)=>(c[0]=Math.min(e.min.y,i.min.y),c[1]=Math.max(e.max.y,i.max.y),c[2]=t.EXTENT-i.min.x>e.max.x?i.min.x-t.EXTENT:e.max.x,c),u=(e,i)=>(c[0]=Math.min(e.min.x,i.min.x),c[1]=Math.max(e.max.x,i.max.x),c[2]=t.EXTENT-i.min.y>e.max.y?i.min.y-t.EXTENT:e.max.y,c),d=[(t,e)=>h(t,e),(t,e)=>h(e,t),(t,e)=>u(t,e),(t,e)=>u(e,t)],_=new t.pointGeometry(0,0);let m,p,f;const g=(e,i,r,a,s)=>{const l=[[a?r:e,a?e:r,0],[a?r:i,a?i:r,0]],c=s<0?t.EXTENT+s:s,h=[a?c:(e+i)/2,a?(e+i)/2:c,0];return 0===r&&s<0||0!==r&&s>0?n.getForTilePoints(f,[h],!0,p):l.push(h),n.getForTilePoints(o,l,!0,m),Math.max(l[0][2],l[1][2],h[2])/n.exaggeration()};for(let e=0;e<4;e++){const i=r.borders[e];if(0===i.length&&(r.borderDone[e]=!0),r.borderDone[e])continue;const a=f=s[e](o),c=l(a);if(!c||!c.enableTerrain)continue;if(p=n.findDEMTileFor(a),!p||!p.dem)continue;if(!m){const t=n.findDEMTileFor(o);if(!t||!t.dem)return;m=t;}const h=(e<2?1:5)-e,u=c.borders[h];let x=0;for(let o=0;o<i.length;o++){const a=r.featuresOnBorder[i[o]],n=a.borders[e];let s;for(;x<u.length&&(s=c.featuresOnBorder[u[x]],!(s.borders[h][1]>n[0]+3));)c.borderDone[h]||c.encodeCentroid(void 0,s,!1),x++;if(s&&x<u.length){const i=x;let o=0;for(;!(s.borders[h][0]>n[1]-3)&&(o++,++x!==u.length);)s=c.featuresOnBorder[u[x]];if(s=c.featuresOnBorder[u[i]],a.intersectsCount()>1||s.intersectsCount()>1||1!==o){1!==o&&(x=i),r.encodeCentroid(void 0,a,!1),c.borderDone[h]||c.encodeCentroid(void 0,s,!1);continue}const l=d[e](a,s),m=e%2?t.EXTENT-1:0;_.x=g(l[0],Math.min(t.EXTENT-1,l[1]),m,e<2,l[2]),_.y=0,r.encodeCentroid(_,a,!1),c.borderDone[h]||c.encodeCentroid(_,s,!1);}else r.encodeCentroid(void 0,a,!1);}r.borderDone[e]=r.needsCentroidUpdate=!0,c.borderDone[h]||(c.borderDone[h]=c.needsCentroidUpdate=!0);}(r.needsCentroidUpdate||!r.centroidVertexBuffer&&0!==r.centroidVertexArray.length)&&r.uploadCentroid(e);}const Vi=new t.Color(1,0,0,1),qi=new t.Color(0,1,0,1),Wi=new t.Color(0,0,1,1),ji=new t.Color(1,0,1,1),Xi=new t.Color(0,1,1,1);function $i(t,e,i,o){Ki(t,0,e+i/2,t.transform.width,i,o);}function Hi(t,e,i,o){Ki(t,e-i/2,0,i,t.transform.height,o);}function Ki(e,i,o,r,a,n){const s=e.context,l=s.gl;l.enable(l.SCISSOR_TEST),l.scissor(i*t.exported.devicePixelRatio,o*t.exported.devicePixelRatio,r*t.exported.devicePixelRatio,a*t.exported.devicePixelRatio),s.clear({color:n}),l.disable(l.SCISSOR_TEST);}function Yi(e,i,o){const r=e.context,a=r.gl,n=o.posMatrix,s=e.useProgram("debug"),l=i.getTileByID(o.key);e.terrain&&e.terrain.setupElevationDraw(l,s);const c=t.DepthMode.disabled,h=t.StencilMode.disabled,u=e.colorModeForRenderPass(),d="$debug";r.activeTexture.set(a.TEXTURE0),e.emptyTexture.bind(a.LINEAR,a.CLAMP_TO_EDGE),s.draw(r,a.LINE_STRIP,c,h,u,t.CullFaceMode.disabled,fi(n,t.Color.red),d,e.debugBuffer,e.tileBorderIndexBuffer,e.debugSegments);const _=l.latestRawTileData,m=Math.floor((_&&_.byteLength||0)/1024),p=i.getTile(o).tileSize,f=512/Math.min(p,512)*(o.overscaledZ/e.transform.zoom)*.5;let g=o.canonical.toString();o.overscaledZ!==o.canonical.z&&(g+=` => ${o.overscaledZ}`),function(t,e){t.initDebugOverlayCanvas();const i=t.debugOverlayCanvas,o=t.context.gl,r=t.debugOverlayCanvas.getContext("2d");r.clearRect(0,0,i.width,i.height),r.shadowColor="white",r.shadowBlur=2,r.lineWidth=1.5,r.strokeStyle="white",r.textBaseline="top",r.font="bold 36px Open Sans, sans-serif",r.fillText(e,5,5),r.strokeText(e,5,5),t.debugOverlayTexture.update(i),t.debugOverlayTexture.bind(o.LINEAR,o.CLAMP_TO_EDGE);}(e,`${g} ${m}kb`),s.draw(r,a.TRIANGLES,c,h,t.ColorMode.alphaBlended,t.CullFaceMode.disabled,fi(n,t.Color.transparent,f),d,e.debugBuffer,e.quadTriangleIndexBuffer,e.debugSegments);}const Ji=t.createLayout([{name:"a_pos_3f",components:3,type:"Float32"}]),{members:Qi}=Ji;function to(t,e,i,o){t.emplaceBack(e,i,o);}class eo{constructor(e){this.vertexArray=new t.StructArrayLayout3f12,this.indices=new t.StructArrayLayout3ui6,to(this.vertexArray,-1,-1,1),to(this.vertexArray,1,-1,1),to(this.vertexArray,-1,1,1),to(this.vertexArray,1,1,1),to(this.vertexArray,-1,-1,-1),to(this.vertexArray,1,-1,-1),to(this.vertexArray,-1,1,-1),to(this.vertexArray,1,1,-1),this.indices.emplaceBack(5,1,3),this.indices.emplaceBack(3,7,5),this.indices.emplaceBack(6,2,0),this.indices.emplaceBack(0,4,6),this.indices.emplaceBack(2,6,7),this.indices.emplaceBack(7,3,2),this.indices.emplaceBack(5,4,0),this.indices.emplaceBack(0,1,5),this.indices.emplaceBack(0,2,3),this.indices.emplaceBack(3,1,0),this.indices.emplaceBack(7,6,4),this.indices.emplaceBack(4,5,7),this.vertexBuffer=e.createVertexBuffer(this.vertexArray,Qi),this.indexBuffer=e.createIndexBuffer(this.indices),this.segment=t.SegmentVector.simpleSegment(0,0,36,12);}}function io(e,i,o,r,a,n){const s=e.gl,l=i.paint.get("sky-atmosphere-color"),c=i.paint.get("sky-atmosphere-halo-color"),h=i.paint.get("sky-atmosphere-sun-intensity"),u=((t,e,i,o,r)=>({u_matrix_3f:t,u_sun_direction:e,u_sun_intensity:i,u_color_tint_r:[o.r,o.g,o.b,o.a],u_color_tint_m:[r.r,r.g,r.b,r.a],u_luminance:5e-5}))(t.fromMat4([],r),a,h,l,c);s.framebufferTexture2D(s.FRAMEBUFFER,s.COLOR_ATTACHMENT0,s.TEXTURE_CUBE_MAP_POSITIVE_X+n,i.skyboxTexture,0),o.draw(e,s.TRIANGLES,t.DepthMode.disabled,t.StencilMode.disabled,t.ColorMode.unblended,t.CullFaceMode.frontCW,u,"skyboxCapture",i.skyboxGeometry.vertexBuffer,i.skyboxGeometry.indexBuffer,i.skyboxGeometry.segment);}const oo={symbol:function(e,i,o,r,a){if("translucent"!==e.renderPass)return;const n=t.StencilMode.disabled,s=e.colorModeForRenderPass();o.layout.get("text-variable-anchor")&&function(e,i,o,r,a,n,s){const l=i.transform,c="map"===a,h="map"===n;for(const a of e){const e=r.getTile(a),n=e.getBucket(o);if(!n||!n.text||!n.text.segments.get().length)continue;const u=t.evaluateSizeForZoom(n.textSizeData,l.zoom),d=C(e,1,i.transform.zoom),_=Vt(a.posMatrix,h,c,i.transform,d),m="none"!==o.layout.get("icon-text-fit")&&n.hasIconData();if(u){const i=Math.pow(2,l.zoom-e.tileID.overscaledZ),o=l.elevation;Bi(n,c,h,s,t.symbolSize,l,_,a.posMatrix,i,u,m,o?t=>o.getAtTileOffset(a,t.x,t.y):t=>0);}}}(r,e,o,i,o.layout.get("text-rotation-alignment"),o.layout.get("text-pitch-alignment"),a),0!==o.paint.get("icon-opacity").constantOr(1)&&Oi(e,i,o,r,!1,o.paint.get("icon-translate"),o.paint.get("icon-translate-anchor"),o.layout.get("icon-rotation-alignment"),o.layout.get("icon-pitch-alignment"),o.layout.get("icon-keep-upright"),n,s),0!==o.paint.get("text-opacity").constantOr(1)&&Oi(e,i,o,r,!0,o.paint.get("text-translate"),o.paint.get("text-translate-anchor"),o.layout.get("text-rotation-alignment"),o.layout.get("text-pitch-alignment"),o.layout.get("text-keep-upright"),n,s),i.map.showCollisionBoxes&&(Li(e,i,o,r,o.paint.get("text-translate"),o.paint.get("text-translate-anchor"),!0),Li(e,i,o,r,o.paint.get("icon-translate"),o.paint.get("icon-translate-anchor"),!1));},circle:function(e,i,o,r){if("translucent"!==e.renderPass)return;const a=o.paint.get("circle-opacity"),n=o.paint.get("circle-stroke-width"),s=o.paint.get("circle-stroke-opacity"),l=void 0!==o.layout.get("circle-sort-key").constantOr(1);if(0===a.constantOr(1)&&(0===n.constantOr(1)||0===s.constantOr(1)))return;const c=e.context,h=c.gl,u=e.depthModeForSublayer(0,t.DepthMode.ReadOnly),d=t.StencilMode.disabled,_=e.colorModeForRenderPass(),m=[];for(let a=0;a<r.length;a++){const n=r[a],s=i.getTile(n),c=s.getBucket(o);if(!c)continue;const h=c.programConfigurations.get(o.id),u=mi(o),d={programConfiguration:h,program:e.useProgram("circle",h,u),layoutVertexBuffer:c.layoutVertexBuffer,indexBuffer:c.indexBuffer,uniformValues:_i(e,n,s,o),tile:s};if(l){const e=c.segments.get();for(const i of e)m.push({segments:new t.SegmentVector([i]),sortKey:i.sortKey,state:d});}else m.push({segments:c.segments,sortKey:0,state:d});}l&&m.sort(((t,e)=>t.sortKey-e.sortKey));for(const i of m){const{programConfiguration:r,program:a,layoutVertexBuffer:n,indexBuffer:s,uniformValues:l,tile:m}=i.state,p=i.segments;e.terrain&&e.terrain.setupElevationDraw(m,a,{useDepthForOcclusion:!0}),a.draw(c,h.TRIANGLES,u,d,_,t.CullFaceMode.disabled,l,o.id,n,s,p,o.paint,e.transform.zoom,r);}},heatmap:function(e,i,o,r){if(0!==o.paint.get("heatmap-opacity"))if("offscreen"===e.renderPass){const a=e.context,n=a.gl,s=t.StencilMode.disabled,l=new t.ColorMode([n.ONE,n.ONE],t.Color.transparent,[!0,!0,!0,!0]);!function(t,e,i){const o=t.gl;t.activeTexture.set(o.TEXTURE1),t.viewport.set([0,0,e.width/4,e.height/4]);let r=i.heatmapFbo;if(r)o.bindTexture(o.TEXTURE_2D,r.colorAttachment.get()),t.bindFramebuffer.set(r.framebuffer);else {const a=o.createTexture();o.bindTexture(o.TEXTURE_2D,a),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_WRAP_S,o.CLAMP_TO_EDGE),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_WRAP_T,o.CLAMP_TO_EDGE),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_MIN_FILTER,o.LINEAR),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_MAG_FILTER,o.LINEAR),r=i.heatmapFbo=t.createFramebuffer(e.width/4,e.height/4,!1),function(t,e,i,o){const r=t.gl;r.texImage2D(r.TEXTURE_2D,0,r.RGBA,e.width/4,e.height/4,0,r.RGBA,t.extRenderToTextureHalfFloat?t.extTextureHalfFloat.HALF_FLOAT_OES:r.UNSIGNED_BYTE,null),o.colorAttachment.set(i);}(t,e,a,r);}}(a,e,o),a.clear({color:t.Color.transparent});for(let c=0;c<r.length;c++){const h=r[c];if(i.hasRenderableParent(h))continue;const u=i.getTile(h),d=u.getBucket(o);if(!d)continue;const _=d.programConfigurations.get(o.id),m=e.useProgram("heatmap",_),{zoom:p}=e.transform;e.terrain&&e.terrain.setupElevationDraw(u,m),m.draw(a,n.TRIANGLES,t.DepthMode.disabled,s,l,t.CullFaceMode.disabled,gi(h.posMatrix,u,p,o.paint.get("heatmap-intensity")),o.id,d.layoutVertexBuffer,d.indexBuffer,d.segments,o.paint,e.transform.zoom,_);}a.viewport.set([0,0,e.width,e.height]);}else "translucent"===e.renderPass&&(e.context.setColorMode(e.colorModeForRenderPass()),function(e,i){const o=e.context,r=o.gl,a=i.heatmapFbo;if(!a)return;o.activeTexture.set(r.TEXTURE0),r.bindTexture(r.TEXTURE_2D,a.colorAttachment.get()),o.activeTexture.set(r.TEXTURE1);let n=i.colorRampTexture;n||(n=i.colorRampTexture=new t.Texture(o,i.colorRamp,r.RGBA)),n.bind(r.LINEAR,r.CLAMP_TO_EDGE),e.useProgram("heatmapTexture").draw(o,r.TRIANGLES,t.DepthMode.disabled,t.StencilMode.disabled,e.colorModeForRenderPass(),t.CullFaceMode.disabled,((e,i,o,r)=>{const a=t.create$1();t.ortho(a,0,e.width,e.height,0,0,1);const n=e.context.gl;return {u_matrix:a,u_world:[n.drawingBufferWidth,n.drawingBufferHeight],u_image:0,u_color_ramp:1,u_opacity:i.paint.get("heatmap-opacity")}})(e,i),i.id,e.viewportBuffer,e.quadTriangleIndexBuffer,e.viewportSegments,i.paint,e.transform.zoom);}(e,o));},line:function(e,i,o,r){if("translucent"!==e.renderPass)return;const a=o.paint.get("line-opacity"),n=o.paint.get("line-width");if(0===a.constantOr(1)||0===n.constantOr(1))return;const s=e.depthModeForSublayer(0,t.DepthMode.ReadOnly),l=e.colorModeForRenderPass(),c=o.paint.get("line-dasharray"),h=o.paint.get("line-pattern"),u=h.constantOr(1),d=o.paint.get("line-gradient"),_=o.getCrossfadeParameters(),m=u?"linePattern":c?"lineSDF":d?"lineGradient":"line",p=e.context,f=p.gl;let g=!0;for(const a of r){const r=i.getTile(a);if(u&&!r.patternsLoaded())continue;const n=r.getBucket(o);if(!n)continue;e.prepareDrawTile(a);const x=n.programConfigurations.get(o.id),v=e.context.program.get(),y=e.useProgram(m,x),b=g||y.program!==v,w=h.constantOr(null);if(w&&r.imageAtlas){const t=r.imageAtlas,e=t.patternPositions[w.to.toString()],i=t.patternPositions[w.from.toString()];e&&i&&x.setConstantPatternPositions(e,i);}const T=e.terrain?a.posMatrix:null,E=u?yi(e,r,o,_,T):c?bi(e,r,o,c,_,T):d?vi(e,r,o,T,n.lineClipsArray.length):xi(e,r,o,T);if(u)p.activeTexture.set(f.TEXTURE0),r.imageAtlasTexture.bind(f.LINEAR,f.CLAMP_TO_EDGE),x.updatePaintBuffers(_);else if(c&&(b||e.lineAtlas.dirty))p.activeTexture.set(f.TEXTURE0),e.lineAtlas.bind(p);else if(d){const r=n.gradients[o.id];let s=r.texture;if(o.gradientVersion!==r.version){let l=256;if(o.stepInterpolant){const o=i.getSource().maxzoom,r=a.canonical.z===o?Math.ceil(1<<e.transform.maxZoom-a.canonical.z):1;l=t.clamp(t.nextPowerOfTwo(n.maxLineLength/t.EXTENT*1024*r),256,p.maxTextureSize);}r.gradient=t.renderColorRamp({expression:o.gradientExpression(),evaluationKey:"lineProgress",resolution:l,image:r.gradient||void 0,clips:n.lineClipsArray}),r.texture?r.texture.update(r.gradient):r.texture=new t.Texture(p,r.gradient,f.RGBA),r.version=o.gradientVersion,s=r.texture;}p.activeTexture.set(f.TEXTURE0),s.bind(o.stepInterpolant?f.NEAREST:f.LINEAR,f.CLAMP_TO_EDGE);}y.draw(p,f.TRIANGLES,s,e.stencilModeForClipping(a),l,t.CullFaceMode.disabled,E,o.id,n.layoutVertexBuffer,n.indexBuffer,n.segments,o.paint,e.transform.zoom,x,n.layoutVertexBuffer2),g=!1;}},fill:function(e,i,o,r){const a=o.paint.get("fill-color"),n=o.paint.get("fill-opacity");if(0===n.constantOr(1))return;const s=e.colorModeForRenderPass(),l=o.paint.get("fill-pattern"),c=e.opaquePassEnabledForLayer()&&!l.constantOr(1)&&1===a.constantOr(t.Color.transparent).a&&1===n.constantOr(0)?"opaque":"translucent";if(e.renderPass===c){const a=e.depthModeForSublayer(1,"opaque"===e.renderPass?t.DepthMode.ReadWrite:t.DepthMode.ReadOnly);Ni(e,i,o,r,a,s,!1);}if("translucent"===e.renderPass&&o.paint.get("fill-antialias")){const a=e.depthModeForSublayer(o.getPaintProperty("fill-outline-color")?2:0,t.DepthMode.ReadOnly);Ni(e,i,o,r,a,s,!0);}},"fill-extrusion":function(e,i,o,r){const a=o.paint.get("fill-extrusion-opacity");if(0!==a&&"translucent"===e.renderPass){const n=new t.DepthMode(e.context.gl.LEQUAL,t.DepthMode.ReadWrite,e.depthRangeFor3D);if(1!==a||o.paint.get("fill-extrusion-pattern").constantOr(1))Gi(e,i,o,r,n,t.StencilMode.disabled,t.ColorMode.disabled),Gi(e,i,o,r,n,e.stencilModeFor3D(),e.colorModeForRenderPass());else {const a=e.colorModeForRenderPass();Gi(e,i,o,r,n,t.StencilMode.disabled,a);}}},hillshade:function(e,i,o,r){if("offscreen"!==e.renderPass&&"translucent"!==e.renderPass)return;const a=e.context,n=e.depthModeForSublayer(0,t.DepthMode.ReadOnly),s=e.colorModeForRenderPass(),l=e.terrain&&e.terrain.renderingToTexture,[c,h]="translucent"!==e.renderPass||l?[{},r]:e.stencilConfigForOverlap(r);for(const r of h){const a=i.getTile(r);if(a.needsHillshadePrepare&&"offscreen"===e.renderPass)je(e,a,o,n,t.StencilMode.disabled,s);else if("translucent"===e.renderPass){const t=l&&e.terrain?e.terrain.stencilModeForRTTOverlap(r):c[r.overscaledZ];qe(e,r,a,o,n,t,s);}}a.viewport.set([0,0,e.width,e.height]);},raster:function(e,i,o,r,a,n){if("translucent"!==e.renderPass)return;if(0===o.paint.get("raster-opacity"))return;if(!r.length)return;const s=e.context,l=s.gl,c=i.getSource(),h=e.useProgram("raster"),u=e.colorModeForRenderPass(),d=e.terrain&&e.terrain.renderingToTexture,[_,m]=c instanceof vt||d?[{},r]:e.stencilConfigForOverlap(r),p=m[m.length-1].overscaledZ,f=!e.options.moving;for(const r of m){const a=d?t.DepthMode.disabled:e.depthModeForSublayer(r.overscaledZ-p,1===o.paint.get("raster-opacity")?t.DepthMode.ReadWrite:t.DepthMode.ReadOnly,l.LESS),m=i.getTile(r);if(d&&(!m||!m.hasData()))continue;const g=d?r.posMatrix:e.transform.calculatePosMatrix(r.toUnwrapped(),f),x=e.terrain&&d?e.terrain.stencilModeForRTTOverlap(r):_[r.overscaledZ],v=n?0:o.paint.get("raster-fade-duration");m.registerFadeDuration(v);const y=i.findLoadedParent(r,0),b=ti(m,y,i,e.transform,v);let w,T;e.terrain&&e.terrain.prepareDrawTile(r);const E="nearest"===o.paint.get("raster-resampling")?l.NEAREST:l.LINEAR;s.activeTexture.set(l.TEXTURE0),m.texture.bind(E,l.CLAMP_TO_EDGE,l.LINEAR_MIPMAP_NEAREST),s.activeTexture.set(l.TEXTURE1),y?(y.texture.bind(E,l.CLAMP_TO_EDGE,l.LINEAR_MIPMAP_NEAREST),w=Math.pow(2,y.tileID.overscaledZ-m.tileID.overscaledZ),T=[m.tileID.canonical.x*w%1,m.tileID.canonical.y*w%1]):m.texture.bind(E,l.CLAMP_TO_EDGE,l.LINEAR_MIPMAP_NEAREST);const C=Ei(g,T||[0,0],w||1,b,o);c instanceof vt?h.draw(s,l.TRIANGLES,a,t.StencilMode.disabled,u,t.CullFaceMode.disabled,C,o.id,c.boundsBuffer,e.quadTriangleIndexBuffer,c.boundsSegments):h.draw(s,l.TRIANGLES,a,x,u,t.CullFaceMode.disabled,C,o.id,e.rasterBoundsBuffer,e.quadTriangleIndexBuffer,e.rasterBoundsSegments);}},background:function(e,i,o,r){const a=o.paint.get("background-color"),n=o.paint.get("background-opacity");if(0===n)return;const s=e.context,l=s.gl,c=e.transform,h=c.tileSize,u=o.paint.get("background-pattern");if(e.isPatternMissing(u))return;const d=!u&&1===a.a&&1===n&&e.opaquePassEnabledForLayer()?"opaque":"translucent";if(e.renderPass!==d)return;const _=t.StencilMode.disabled,m=e.depthModeForSublayer(0,"opaque"===d?t.DepthMode.ReadWrite:t.DepthMode.ReadOnly),p=e.colorModeForRenderPass(),f=e.useProgram(u?"backgroundPattern":"background"),g=r||c.coveringTiles({tileSize:h});u&&(s.activeTexture.set(l.TEXTURE0),e.imageManager.bind(e.context));const x=o.getCrossfadeParameters();for(const i of g){const c=r?i.posMatrix:e.transform.calculatePosMatrix(i.toUnwrapped());e.prepareDrawTile(i);const d=u?Pi(c,n,e,u,{tileID:i,tileSize:h},x):zi(c,n,a);f.draw(s,l.TRIANGLES,m,_,p,t.CullFaceMode.disabled,d,o.id,e.tileExtentBuffer,e.quadTriangleIndexBuffer,e.tileExtentSegments);}},sky:function(e,i,o){const r=o.paint.get("sky-opacity");if(0===r)return;const a=e.context,n=o.paint.get("sky-type"),s=new t.DepthMode(a.gl.LEQUAL,t.DepthMode.ReadOnly,[0,1]),l=e.frameCounter/1e3%1;"atmosphere"===n?"offscreen"===e.renderPass?o.needsSkyboxCapture(e)&&(function(e,i,o,r){const a=e.context,n=a.gl;let s=i.skyboxFbo;if(!s){s=i.skyboxFbo=a.createFramebuffer(32,32,!1),i.skyboxGeometry=new eo(a),i.skyboxTexture=a.gl.createTexture(),n.bindTexture(n.TEXTURE_CUBE_MAP,i.skyboxTexture),n.texParameteri(n.TEXTURE_CUBE_MAP,n.TEXTURE_WRAP_S,n.CLAMP_TO_EDGE),n.texParameteri(n.TEXTURE_CUBE_MAP,n.TEXTURE_WRAP_T,n.CLAMP_TO_EDGE),n.texParameteri(n.TEXTURE_CUBE_MAP,n.TEXTURE_MIN_FILTER,n.LINEAR),n.texParameteri(n.TEXTURE_CUBE_MAP,n.TEXTURE_MAG_FILTER,n.LINEAR);for(let t=0;t<6;++t)n.texImage2D(n.TEXTURE_CUBE_MAP_POSITIVE_X+t,0,n.RGBA,32,32,0,n.RGBA,n.UNSIGNED_BYTE,null);}a.bindFramebuffer.set(s.framebuffer),a.viewport.set([0,0,32,32]);const l=i.getCenter(e,!0),c=e.useProgram("skyboxCapture"),h=new Float64Array(16);t.identity(h),t.rotateY(h,h,.5*-Math.PI),io(a,i,c,h,l,0),t.identity(h),t.rotateY(h,h,.5*Math.PI),io(a,i,c,h,l,1),t.identity(h),t.rotateX(h,h,.5*-Math.PI),io(a,i,c,h,l,2),t.identity(h),t.rotateX(h,h,.5*Math.PI),io(a,i,c,h,l,3),t.identity(h),io(a,i,c,h,l,4),t.identity(h),t.rotateY(h,h,Math.PI),io(a,i,c,h,l,5),a.viewport.set([0,0,e.width,e.height]);}(e,o),o.markSkyboxValid(e)):"sky"===e.renderPass&&function(e,i,o,r,a){const n=e.context,s=n.gl,l=e.transform,c=e.useProgram("skybox");n.activeTexture.set(s.TEXTURE0),s.bindTexture(s.TEXTURE_CUBE_MAP,i.skyboxTexture);const h=((t,e,i,o,r)=>({u_matrix:t,u_sun_direction:e,u_cubemap:0,u_opacity:o,u_temporal_offset:r}))(l.skyboxMatrix,i.getCenter(e,!1),0,r,a);c.draw(n,s.TRIANGLES,o,t.StencilMode.disabled,e.colorModeForRenderPass(),t.CullFaceMode.backCW,h,"skybox",i.skyboxGeometry.vertexBuffer,i.skyboxGeometry.indexBuffer,i.skyboxGeometry.segment);}(e,o,s,r,l):"gradient"===n&&"sky"===e.renderPass&&function(e,i,o,r,a){const n=e.context,s=n.gl,l=e.transform,c=e.useProgram("skyboxGradient");i.skyboxGeometry||(i.skyboxGeometry=new eo(n)),n.activeTexture.set(s.TEXTURE0);let h=i.colorRampTexture;h||(h=i.colorRampTexture=new t.Texture(n,i.colorRamp,s.RGBA)),h.bind(s.LINEAR,s.CLAMP_TO_EDGE);const u=((e,i,o,r,a)=>({u_matrix:e,u_color_ramp:0,u_center_direction:i,u_radius:t.degToRad(o),u_opacity:r,u_temporal_offset:a}))(l.skyboxMatrix,i.getCenter(e,!1),i.paint.get("sky-gradient-radius"),r,a);c.draw(n,s.TRIANGLES,o,t.StencilMode.disabled,e.colorModeForRenderPass(),t.CullFaceMode.backCW,u,"skyboxGradient",i.skyboxGeometry.vertexBuffer,i.skyboxGeometry.indexBuffer,i.skyboxGeometry.segment);}(e,o,s,r,l);},debug:function(t,e,i){for(let o=0;o<i.length;o++)Yi(t,e,i[o]);},custom:function(e,i,o){const r=e.context,a=o.implementation;if("offscreen"===e.renderPass){const t=a.prerender;t&&(e.setCustomLayerDefaults(),r.setColorMode(e.colorModeForRenderPass()),t.call(a,r.gl,e.transform.customLayerMatrix()),r.setDirty(),e.setBaseState());}else if("translucent"===e.renderPass){e.setCustomLayerDefaults(),r.setColorMode(e.colorModeForRenderPass()),r.setStencilMode(t.StencilMode.disabled);const i="3d"===a.renderingMode?new t.DepthMode(e.context.gl.LEQUAL,t.DepthMode.ReadWrite,e.depthRangeFor3D):e.depthModeForSublayer(0,t.DepthMode.ReadOnly);r.setDepthMode(i),a.render(r.gl,e.transform.customLayerMatrix()),r.setDirty(),e.setBaseState(),r.bindFramebuffer.set(null);}}};class ro{constructor(e,i){this.context=new ft(e),this.transform=i,this._tileTextures={},this.frameCopies=[],this.loadTimeStamps=[],this.setup(),this.numSublayers=t.SourceCache.maxUnderzooming+t.SourceCache.maxOverzooming+1,this.depthEpsilon=1/Math.pow(2,16),this.crossTileSymbolIndex=new Pe,this.gpuTimers={},this.frameCounter=0;}updateTerrain(t,e){const i=!!t&&!!t.terrain;if(!(i||this._terrain&&this._terrain.enabled))return;this._terrain||(this._terrain=new oi(this,t));const o=this._terrain;this.transform.elevation=i?o:null,o.update(t,this.transform,e);}get terrain(){return this._terrain&&this._terrain.enabled?this._terrain:null}resize(e,i){if(this.width=e*t.exported.devicePixelRatio,this.height=i*t.exported.devicePixelRatio,this.context.viewport.set([0,0,this.width,this.height]),this.style)for(const t of this.style.order)this.style._layers[t].resize();}setup(){const e=this.context,i=new t.StructArrayLayout2i4;i.emplaceBack(0,0),i.emplaceBack(t.EXTENT,0),i.emplaceBack(0,t.EXTENT),i.emplaceBack(t.EXTENT,t.EXTENT),this.tileExtentBuffer=e.createVertexBuffer(i,t.posAttributes.members),this.tileExtentSegments=t.SegmentVector.simpleSegment(0,0,4,2);const o=new t.StructArrayLayout2i4;o.emplaceBack(0,0),o.emplaceBack(t.EXTENT,0),o.emplaceBack(0,t.EXTENT),o.emplaceBack(t.EXTENT,t.EXTENT),this.debugBuffer=e.createVertexBuffer(o,t.posAttributes.members),this.debugSegments=t.SegmentVector.simpleSegment(0,0,4,5);const r=new t.StructArrayLayout4i8;r.emplaceBack(0,0,0,0),r.emplaceBack(t.EXTENT,0,t.EXTENT,0),r.emplaceBack(0,t.EXTENT,0,t.EXTENT),r.emplaceBack(t.EXTENT,t.EXTENT,t.EXTENT,t.EXTENT),this.rasterBoundsBuffer=e.createVertexBuffer(r,xt.members),this.rasterBoundsSegments=t.SegmentVector.simpleSegment(0,0,4,2);const a=new t.StructArrayLayout2i4;a.emplaceBack(0,0),a.emplaceBack(1,0),a.emplaceBack(0,1),a.emplaceBack(1,1),this.viewportBuffer=e.createVertexBuffer(a,t.posAttributes.members),this.viewportSegments=t.SegmentVector.simpleSegment(0,0,4,2);const n=new t.StructArrayLayout1ui2;n.emplaceBack(0),n.emplaceBack(1),n.emplaceBack(3),n.emplaceBack(2),n.emplaceBack(0),this.tileBorderIndexBuffer=e.createIndexBuffer(n);const s=new t.StructArrayLayout3ui6;s.emplaceBack(0,1,2),s.emplaceBack(2,1,3),this.quadTriangleIndexBuffer=e.createIndexBuffer(s),this.emptyTexture=new t.Texture(e,{width:1,height:1,data:new Uint8Array([0,0,0,0])},e.gl.RGBA);const l=this.context.gl;this.stencilClearMode=new t.StencilMode({func:l.ALWAYS,mask:0},0,255,l.ZERO,l.ZERO,l.ZERO),this.loadTimeStamps.push(t.window.performance.now());}clearStencil(){const e=this.context,i=e.gl;this.nextStencilID=1,this.currentStencilSource=void 0;const o=t.create$1();t.ortho(o,0,this.width,this.height,0,0,1),t.scale$1(o,o,[i.drawingBufferWidth,i.drawingBufferHeight,0]),this.useProgram("clippingMask").draw(e,i.TRIANGLES,t.DepthMode.disabled,this.stencilClearMode,t.ColorMode.disabled,t.CullFaceMode.disabled,Qe(o),"$clipping",this.viewportBuffer,this.quadTriangleIndexBuffer,this.viewportSegments);}_renderTileClippingMasks(e,i,o){if(!(i&&this.currentStencilSource!==i.id&&e.isTileClipped()&&o&&o.length))return;this.currentStencilSource=i.id;const r=this.context,a=r.gl;this.nextStencilID+o.length>256&&this.clearStencil(),r.setColorMode(t.ColorMode.disabled),r.setDepthMode(t.DepthMode.disabled);const n=this.useProgram("clippingMask");this._tileClippingMaskIDs={};for(const e of o){const i=this._tileClippingMaskIDs[e.key]=this.nextStencilID++;n.draw(r,a.TRIANGLES,t.DepthMode.disabled,new t.StencilMode({func:a.ALWAYS,mask:0},i,255,a.KEEP,a.KEEP,a.REPLACE),t.ColorMode.disabled,t.CullFaceMode.disabled,Qe(e.posMatrix),"$clipping",this.tileExtentBuffer,this.quadTriangleIndexBuffer,this.tileExtentSegments);}}stencilModeFor3D(){this.currentStencilSource=void 0,this.nextStencilID+1>256&&this.clearStencil();const e=this.nextStencilID++,i=this.context.gl;return new t.StencilMode({func:i.NOTEQUAL,mask:255},e,255,i.KEEP,i.KEEP,i.REPLACE)}stencilModeForClipping(e){if(this.terrain)return this.terrain.stencilModeForRTTOverlap(e);const i=this.context.gl;return new t.StencilMode({func:i.EQUAL,mask:255},this._tileClippingMaskIDs[e.key],0,i.KEEP,i.KEEP,i.REPLACE)}stencilConfigForOverlap(e){const i=this.context.gl,o=e.sort(((t,e)=>e.overscaledZ-t.overscaledZ)),r=o[o.length-1].overscaledZ,a=o[0].overscaledZ-r+1;if(a>1){this.currentStencilSource=void 0,this.nextStencilID+a>256&&this.clearStencil();const e={};for(let o=0;o<a;o++)e[o+r]=new t.StencilMode({func:i.GEQUAL,mask:255},o+this.nextStencilID,255,i.KEEP,i.KEEP,i.REPLACE);return this.nextStencilID+=a,[e,o]}return [{[r]:t.StencilMode.disabled},o]}colorModeForRenderPass(){const e=this.context.gl;if(this._showOverdrawInspector){const i=1/8;return new t.ColorMode([e.CONSTANT_COLOR,e.ONE],new t.Color(i,i,i,0),[!0,!0,!0,!0])}return "opaque"===this.renderPass?t.ColorMode.unblended:t.ColorMode.alphaBlended}depthModeForSublayer(e,i,o){if(!this.opaquePassEnabledForLayer())return t.DepthMode.disabled;const r=1-((1+this.currentLayer)*this.numSublayers+e)*this.depthEpsilon;return new t.DepthMode(o||this.context.gl.LEQUAL,i,[r,r])}opaquePassEnabledForLayer(){return this.currentLayer<this.opaquePassCutoff}render(e,i){this.style=e,this.options=i,this.lineAtlas=e.lineAtlas,this.imageManager=e.imageManager,this.glyphManager=e.glyphManager,this.symbolFadeChange=e.placement.symbolFadeChange(t.exported.now()),this.imageManager.beginFrame();const o=this.style.order,r=this.style._sourceCaches;for(const t in r){const e=r[t];e.used&&e.prepare(this.context);}const a={},n={},s={};for(const t in r){const e=r[t];a[t]=e.getVisibleCoordinates(),n[t]=a[t].slice().reverse(),s[t]=e.getVisibleCoordinates(!0).reverse();}this.opaquePassCutoff=1/0;for(let t=0;t<o.length;t++)if(this.style._layers[o[t]].is3D()){this.opaquePassCutoff=t;break}if(this.terrain&&(this.terrain.updateTileBinding(s),this.opaquePassCutoff=0),t.isMapAuthenticated(this.context.gl)){this.renderPass="offscreen";for(const t of o){const i=this.style._layers[t],o=e._getLayerSourceCache(i);if(!i.hasOffscreenPass()||i.isHidden(this.transform.zoom))continue;const r=o?n[o.id]:void 0;("custom"===i.type||i.isSky()||r&&r.length)&&this.renderLayer(this,o,i,r);}if(this.depthRangeFor3D=[0,1-(e.order.length+2)*this.numSublayers*this.depthEpsilon],this.terrain&&(this.style.hasSymbolLayers()||this.style.hasCircleLayers())&&this.terrain.drawDepth(),this.context.bindFramebuffer.set(null),this.context.viewport.set([0,0,this.width,this.height]),this.context.clear({color:i.showOverdrawInspector?t.Color.black:t.Color.transparent,depth:1}),this.clearStencil(),this._showOverdrawInspector=i.showOverdrawInspector,this.renderPass="opaque",!this.terrain)for(this.currentLayer=o.length-1;this.currentLayer>=0;this.currentLayer--){const t=this.style._layers[o[this.currentLayer]],i=e._getLayerSourceCache(t);if(t.isSky())continue;const r=i?n[i.id]:void 0;this._renderTileClippingMasks(t,i,r),this.renderLayer(this,i,t,r);}if(this.renderPass="sky",this.transform.isHorizonVisible())for(this.currentLayer=0;this.currentLayer<o.length;this.currentLayer++){const t=this.style._layers[o[this.currentLayer]],i=e._getLayerSourceCache(t);t.isSky()&&this.renderLayer(this,i,t,i?n[i.id]:void 0);}for(this.renderPass="translucent",this.currentLayer=0;this.currentLayer<o.length;){const t=this.style._layers[o[this.currentLayer]],i=e._getLayerSourceCache(t);if(t.isSky()){++this.currentLayer;continue}if(this.terrain&&this.style.isLayerDraped(t)){if(t.isHidden(this.transform.zoom)){++this.currentLayer;continue}this.currentLayer=this.terrain.renderBatch(this.currentLayer);continue}const r=i?("symbol"===t.type?s:n)[i.id]:void 0;this._renderTileClippingMasks(t,i,i?a[i.id]:void 0),this.renderLayer(this,i,t,r),++this.currentLayer;}if(this.terrain&&this.terrain.postRender(),this.options.showTileBoundaries||this.options.showQueryGeometry){let i=null;t.values(this.style._layers).forEach((t=>{const o=e._getLayerSourceCache(t);o&&!t.isHidden(this.transform.zoom)&&(!i||i.getSource().maxzoom<o.getSource().maxzoom)&&(i=o);})),i&&this.options.showTileBoundaries&&oo.debug(this,i,i.getVisibleCoordinates());}this.options.showPadding&&function(t){const e=t.transform.padding;$i(t,t.transform.height-(e.top||0),3,Vi),$i(t,e.bottom||0,3,qi),Hi(t,e.left||0,3,Wi),Hi(t,t.transform.width-(e.right||0),3,ji);const i=t.transform.centerPoint;!function(t,e,i,o){Ki(t,e-1,i-10,2,20,o),Ki(t,e-10,i-1,20,2,o);}(t,i.x,t.transform.height-i.y,Xi);}(this),this.context.setDefault(),this.frameCounter=(this.frameCounter+1)%t.MAX_SAFE_INTEGER,this.tileLoaded&&this.options.speedIndexTiming&&(this.loadTimeStamps.push(t.window.performance.now()),this.saveCanvasCopy());}}renderLayer(t,e,i,o){i.isHidden(this.transform.zoom)||("background"===i.type||"sky"===i.type||"custom"===i.type||o&&o.length)&&(this.id=i.id,this.gpuTimingStart(i),oo[i.type](t,e,i,o,this.style.placement.variableOffsets,this.options.isInitialLoad),this.gpuTimingEnd());}gpuTimingStart(t){if(!this.options.gpuTiming)return;const e=this.context.extTimerQuery;let i=this.gpuTimers[t.id];i||(i=this.gpuTimers[t.id]={calls:0,cpuTime:0,query:e.createQueryEXT()}),i.calls++,e.beginQueryEXT(e.TIME_ELAPSED_EXT,i.query);}gpuTimingEnd(){if(!this.options.gpuTiming)return;const t=this.context.extTimerQuery;t.endQueryEXT(t.TIME_ELAPSED_EXT);}collectGpuTimers(){const t=this.gpuTimers;return this.gpuTimers={},t}queryGpuTimers(t){const e={};for(const i in t){const o=t[i],r=this.context.extTimerQuery,a=r.getQueryObjectEXT(o.query,r.QUERY_RESULT_EXT)/1e6;r.deleteQueryEXT(o.query),e[i]=a;}return e}translatePosMatrix(e,i,o,r,a){if(!o[0]&&!o[1])return e;const n=a?"map"===r?this.transform.angle:0:"viewport"===r?-this.transform.angle:0;if(n){const t=Math.sin(n),e=Math.cos(n);o=[o[0]*e-o[1]*t,o[0]*t+o[1]*e];}const s=[a?o[0]:C(i,o[0],this.transform.zoom),a?o[1]:C(i,o[1],this.transform.zoom),0],l=new Float32Array(16);return t.translate(l,e,s),l}saveTileTexture(t){const e=this._tileTextures[t.size[0]];e?e.push(t):this._tileTextures[t.size[0]]=[t];}getTileTexture(t){const e=this._tileTextures[t];return e&&e.length>0?e.pop():null}isPatternMissing(t){if(!t)return !1;if(!t.from||!t.to)return !0;const e=this.imageManager.getPattern(t.from.toString()),i=this.imageManager.getPattern(t.to.toString());return !e||!i}currentGlobalDefines(){const t=this.terrain&&this.terrain.renderingToTexture,e=[];return this.terrain&&!this.terrain.renderingToTexture&&e.push("TERRAIN"),t&&e.push("RENDER_TO_TEXTURE"),this._showOverdrawInspector&&e.push("OVERDRAW_INSPECTOR"),e}useProgram(t,e,i){this.cache=this.cache||{};const o=i||[],r=this.currentGlobalDefines().concat(o),a=ai.cacheKey(t,r,e);return this.cache[a]||(this.cache[a]=new ai(this.context,t,Ne[t],e,Ai[t],r)),this.cache[a]}setCustomLayerDefaults(){this.context.unbindVAO(),this.context.cullFace.setDefault(),this.context.frontFace.setDefault(),this.context.cullFaceSide.setDefault(),this.context.activeTexture.setDefault(),this.context.pixelStoreUnpack.setDefault(),this.context.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.context.pixelStoreUnpackFlipY.setDefault();}setBaseState(){const t=this.context.gl;this.context.cullFace.set(!1),this.context.viewport.set([0,0,this.width,this.height]),this.context.blendEquation.set(t.FUNC_ADD);}initDebugOverlayCanvas(){null==this.debugOverlayCanvas&&(this.debugOverlayCanvas=t.window.document.createElement("canvas"),this.debugOverlayCanvas.width=512,this.debugOverlayCanvas.height=512,this.debugOverlayTexture=new t.Texture(this.context,this.debugOverlayCanvas,this.context.gl.RGBA));}destroy(){this._terrain&&this._terrain.destroy(),this.emptyTexture.destroy(),this.debugOverlayTexture&&this.debugOverlayTexture.destroy();}prepareDrawTile(t){this.terrain&&this.terrain.prepareDrawTile(t);}setTileLoadedFlag(t){this.tileLoaded=t;}saveCanvasCopy(){this.frameCopies.push(this.canvasCopy()),this.tileLoaded=!1;}canvasCopy(){const t=this.context.gl,e=t.createTexture();return t.bindTexture(t.TEXTURE_2D,e),t.copyTexImage2D(t.TEXTURE_2D,0,t.RGBA,0,0,t.drawingBufferWidth,t.drawingBufferHeight,0),e}getCanvasCopiesAndTimestamps(){return {canvasCopies:this.frameCopies,timeStamps:this.loadTimeStamps}}}class ao{constructor(t=0,e=0,i=0,o=0){if(isNaN(t)||t<0||isNaN(e)||e<0||isNaN(i)||i<0||isNaN(o)||o<0)throw new Error("Invalid value for edge-insets, top, bottom, left and right must all be numbers");this.top=t,this.bottom=e,this.left=i,this.right=o;}interpolate(e,i,o){return null!=i.top&&null!=e.top&&(this.top=t.number(e.top,i.top,o)),null!=i.bottom&&null!=e.bottom&&(this.bottom=t.number(e.bottom,i.bottom,o)),null!=i.left&&null!=e.left&&(this.left=t.number(e.left,i.left,o)),null!=i.right&&null!=e.right&&(this.right=t.number(e.right,i.right,o)),this}getCenter(e,i){const o=t.clamp((this.left+e-this.right)/2,0,e),r=t.clamp((this.top+i-this.bottom)/2,0,i);return new t.pointGeometry(o,r)}equals(t){return this.top===t.top&&this.bottom===t.bottom&&this.left===t.left&&this.right===t.right}clone(){return new ao(this.top,this.bottom,this.left,this.right)}toJSON(){return {top:this.top,bottom:this.bottom,left:this.left,right:this.right}}}function no(t,e){return [t[4*e],t[4*e+1],t[4*e+2],t[4*e+3]]}function so(t,e,i){t[4*e+0]=i[0],t[4*e+1]=i[1],t[4*e+2]=i[2],t[4*e+3]=i[3];}function lo(e,i){const o=no(e,3);t.fromQuat(e,i),so(e,3,o);}function co(t,e){so(t,3,[e[0],e[1],e[2],1]);}function ho(e,i){const o=t.identity$1([]);return t.rotateZ$1(o,o,-i),t.rotateX$1(o,o,-e),o}function uo(e,i){const o=[e[0],e[1],0],r=[i[0],i[1],0];if(t.length(o)>=1e-15){const e=t.normalize([],o);t.scale(r,e,t.dot(r,e)),i[0]=r[0],i[1]=r[1];}const a=t.cross([],i,e);if(t.len(a)<1e-15)return null;const n=Math.atan2(-a[1],a[0]);return ho(Math.atan2(Math.sqrt(e[0]*e[0]+e[1]*e[1]),-e[2]),n)}class _o{constructor(t,e){this.position=t,this.orientation=e;}get position(){return this._position}set position(e){this._position=this._renderWorldCopies?function(e){if(!e)return;const i=Array.isArray(e)?new t.MercatorCoordinate(e[0],e[1],e[2]):e;return i.x=t.wrap(i.x,0,1),i}(e):e;}lookAtPoint(e,i){if(this.orientation=null,!this.position)return;const o=this._elevation?this._elevation.getAtPoint(t.MercatorCoordinate.fromLngLat(e)):0,r=this.position,a=t.MercatorCoordinate.fromLngLat(e,o),n=[a.x-r.x,a.y-r.y,a.z-r.z];i||(i=[0,0,1]),i[2]=Math.abs(i[2]),this.orientation=uo(n,i);}setPitchBearing(e,i){this.orientation=ho(t.degToRad(e),t.degToRad(-i));}}class mo{constructor(e,i){this._transform=t.identity([]),this._orientation=t.identity$1([]),i&&(this._orientation=i,lo(this._transform,this._orientation)),e&&co(this._transform,e);}get mercatorPosition(){const e=this.position;return new t.MercatorCoordinate(e[0],e[1],e[2])}get position(){const t=no(this._transform,3);return [t[0],t[1],t[2]]}set position(t){co(this._transform,t);}get orientation(){return this._orientation}set orientation(t){this._orientation=t,lo(this._transform,this._orientation);}getPitchBearing(){const t=this.forward(),e=this.right();return {bearing:Math.atan2(-e[1],e[0]),pitch:Math.atan2(Math.sqrt(t[0]*t[0]+t[1]*t[1]),-t[2])}}setPitchBearing(t,e){this._orientation=ho(t,e),lo(this._transform,this._orientation);}forward(){const t=no(this._transform,2);return [-t[0],-t[1],-t[2]]}up(){const t=no(this._transform,1);return [-t[0],-t[1],-t[2]]}right(){const t=no(this._transform,0);return [t[0],t[1],t[2]]}getCameraToWorld(e,i){const o=new Float64Array(16);return t.invert(o,this.getWorldToCamera(e,i)),o}getWorldToCamera(e,i){const o=new Float64Array(16),r=new Float64Array(4),a=this.position;return t.conjugate(r,this._orientation),t.scale(a,a,-e),t.fromQuat(o,r),t.translate(o,o,a),o[1]*=-1,o[5]*=-1,o[9]*=-1,o[13]*=-1,o[8]*=i,o[9]*=i,o[10]*=i,o[11]*=i,o}getCameraToClipPerspective(e,i,o,r){const a=new Float64Array(16);return t.perspective(a,e,i,o,r),a}clone(){return new mo([...this.position],[...this.orientation])}}class po{constructor(e,i,o,r,a){this.tileSize=512,this.maxValidLatitude=85.051129,this._renderWorldCopies=void 0===a||a,this._minZoom=e||0,this._maxZoom=i||22,this._minPitch=null==o?0:o,this._maxPitch=null==r?60:r,this.setMaxBounds(),this.width=0,this.height=0,this._center=new t.LngLat(0,0),this.zoom=0,this.angle=0,this._fov=.6435011087932844,this._pitch=0,this._unmodified=!0,this._edgeInsets=new ao,this._posMatrixCache={},this._alignedPosMatrixCache={},this._camera=new mo,this._centerAltitude=0,this.cameraElevationReference="ground",this._horizonShift=.1;}clone(){const t=new po(this._minZoom,this._maxZoom,this._minPitch,this.maxPitch,this._renderWorldCopies);return t._elevation=this._elevation,t._centerAltitude=this._centerAltitude,t.tileSize=this.tileSize,t.latRange=this.latRange,t.width=this.width,t.height=this.height,t.cameraElevationReference=this.cameraElevationReference,t._center=this._center,t._setZoom(this.zoom),t._cameraZoom=this._cameraZoom,t.angle=this.angle,t._fov=this._fov,t._pitch=this._pitch,t._unmodified=this._unmodified,t._edgeInsets=this._edgeInsets.clone(),t._camera=this._camera.clone(),t._calcMatrices(),t.freezeTileCoverage=this.freezeTileCoverage,t}get elevation(){return this._elevation}set elevation(t){this._elevation!==t&&(this._elevation=t,t?this._updateCenterElevation()&&this._updateCameraOnTerrain():(this._cameraZoom=null,this._centerAltitude=0),this._calcMatrices());}updateElevation(t){this._terrainEnabled()&&null==this._cameraZoom&&this._updateCenterElevation()&&this._updateCameraOnTerrain(),t&&this._constrainCameraAltitude(),this._calcMatrices();}get minZoom(){return this._minZoom}set minZoom(t){this._minZoom!==t&&(this._minZoom=t,this.zoom=Math.max(this.zoom,t));}get maxZoom(){return this._maxZoom}set maxZoom(t){this._maxZoom!==t&&(this._maxZoom=t,this.zoom=Math.min(this.zoom,t));}get minPitch(){return this._minPitch}set minPitch(t){this._minPitch!==t&&(this._minPitch=t,this.pitch=Math.max(this.pitch,t));}get maxPitch(){return this._maxPitch}set maxPitch(t){this._maxPitch!==t&&(this._maxPitch=t,this.pitch=Math.min(this.pitch,t));}get renderWorldCopies(){return this._renderWorldCopies}set renderWorldCopies(t){void 0===t?t=!0:null===t&&(t=!1),this._renderWorldCopies=t;}get worldSize(){return this.tileSize*this.scale}get centerOffset(){return this.centerPoint._sub(this.size._div(2))}get size(){return new t.pointGeometry(this.width,this.height)}get bearing(){return -this.angle/Math.PI*180}set bearing(e){const i=-t.wrap(e,-180,180)*Math.PI/180;var o;this.angle!==i&&(this._unmodified=!1,this.angle=i,this._calcMatrices(),this.rotationMatrix=(o=new t.ARRAY_TYPE(4),t.ARRAY_TYPE!=Float32Array&&(o[1]=0,o[2]=0),o[0]=1,o[3]=1,o),function(t,e,i){var o=e[0],r=e[1],a=e[2],n=e[3],s=Math.sin(i),l=Math.cos(i);t[0]=o*l+a*s,t[1]=r*l+n*s,t[2]=o*-s+a*l,t[3]=r*-s+n*l;}(this.rotationMatrix,this.rotationMatrix,this.angle));}get pitch(){return this._pitch/Math.PI*180}set pitch(e){const i=t.clamp(e,this.minPitch,this.maxPitch)/180*Math.PI;this._pitch!==i&&(this._unmodified=!1,this._pitch=i,this._calcMatrices());}get fov(){return this._fov/Math.PI*180}set fov(t){t=Math.max(.01,Math.min(60,t)),this._fov!==t&&(this._unmodified=!1,this._fov=t/180*Math.PI,this._calcMatrices());}get zoom(){return this._zoom}set zoom(t){const e=Math.min(Math.max(t,this.minZoom),this.maxZoom);this._zoom!==e&&(this._unmodified=!1,this._setZoom(e),this._terrainEnabled()&&this._updateCameraOnTerrain(),this._constrain(),this._calcMatrices());}_setZoom(t){this._zoom=t,this.scale=this.zoomScale(t),this.tileZoom=Math.floor(t),this.zoomFraction=t-this.tileZoom;}_updateCenterElevation(){if(!this._elevation)return !1;const e=this._elevation.getAtPoint(t.MercatorCoordinate.fromLngLat(this.center),-1);return -1===e?(this._cameraZoom=null,!1):(this._centerAltitude=e,!0)}_updateCameraOnTerrain(){const e=this.cameraToCenterDistance/this.worldSize,i=t.mercatorZfromAltitude(this._centerAltitude,this.center.lat);this._cameraZoom=this._zoomFromMercatorZ(i+e);}get center(){return this._center}set center(t){t.lat===this._center.lat&&t.lng===this._center.lng||(this._unmodified=!1,this._center=t,this._terrainEnabled()&&("ground"===this.cameraElevationReference?this._updateCenterElevation()?this._updateCameraOnTerrain():this._cameraZoom=null:this._updateZoomFromElevation()),this._constrain(),this._calcMatrices());}_updateZoomFromElevation(){if(null==this._cameraZoom||!this._elevation)return;const e=this._cameraZoom,i=this._elevation.getAtPoint(t.MercatorCoordinate.fromLngLat(this.center)),o=t.mercatorZfromAltitude(i,this.center.lat),r=this._mercatorZfromZoom(e),a=this._mercatorZfromZoom(this._maxZoom),n=Math.max(r-o,a);this._setZoom(this._zoomFromMercatorZ(n));}get padding(){return this._edgeInsets.toJSON()}set padding(t){this._edgeInsets.equals(t)||(this._unmodified=!1,this._edgeInsets.interpolate(this._edgeInsets,t,1),this._calcMatrices());}computeZoomRelativeTo(e){const i=this.rayIntersectionCoordinate(this.pointRayIntersection(this.centerPoint,e.toAltitude()));let o;o=e.z<this._camera.position[2]?[i.x,i.y,i.z]:[e.x,e.y,e.z];const r=t.length(t.sub([],this._camera.position,o));return t.clamp(this._zoomFromMercatorZ(r),this._minZoom,this._maxZoom)}setFreeCameraOptions(e){if(!this.height)return;if(!e.position&&!e.orientation)return;this._updateCameraState();let i=!1;if(e.orientation&&!t.exactEquals(e.orientation,this._camera.orientation)&&(i=this._setCameraOrientation(e.orientation)),e.position){const o=[e.position.x,e.position.y,e.position.z];t.exactEquals$1(o,this._camera.position)||(this._setCameraPosition(o),i=!0);}i&&(this._updateStateFromCamera(),this.recenterOnTerrain());}getFreeCameraOptions(){this._updateCameraState();const e=this._camera.position,i=new _o;return i.position=new t.MercatorCoordinate(e[0],e[1],e[2]),i.orientation=this._camera.orientation,i._elevation=this.elevation,i._renderWorldCopies=this._renderWorldCopies,i}_setCameraOrientation(e){if(!t.length$1(e))return !1;t.normalize$1(e,e);const i=t.transformQuat([],[0,0,-1],e),o=t.transformQuat([],[0,-1,0],e);if(o[2]<0)return !1;const r=uo(i,o);return !!r&&(this._camera.orientation=r,!0)}_setCameraPosition(e){const i=this.zoomScale(this.minZoom)*this.tileSize,o=this.zoomScale(this.maxZoom)*this.tileSize,r=this.cameraToCenterDistance;e[2]=t.clamp(e[2],r/o,r/i),this._camera.position=e;}get centerPoint(){return this._edgeInsets.getCenter(this.width,this.height)}get fovAboveCenter(){return this._fov*(.5+this.centerOffset.y/this.height)}isPaddingEqual(t){return this._edgeInsets.equals(t)}interpolatePadding(t,e,i){this._unmodified=!1,this._edgeInsets.interpolate(t,e,i),this._constrain(),this._calcMatrices();}coveringZoomLevel(t){const e=(t.roundZoom?Math.round:Math.floor)(this.zoom+this.scaleZoom(this.tileSize/t.tileSize));return Math.max(0,e)}getVisibleUnwrappedCoordinates(e){const i=[new t.UnwrappedTileID(0,e)];if(this._renderWorldCopies){const o=this.pointCoordinate(new t.pointGeometry(0,0)),r=this.pointCoordinate(new t.pointGeometry(this.width,0)),a=this.pointCoordinate(new t.pointGeometry(this.width,this.height)),n=this.pointCoordinate(new t.pointGeometry(0,this.height)),s=Math.floor(Math.min(o.x,r.x,a.x,n.x)),l=Math.floor(Math.max(o.x,r.x,a.x,n.x)),c=1;for(let o=s-c;o<=l+c;o++)0!==o&&i.push(new t.UnwrappedTileID(o,e));}return i}coveringTiles(e){let i=this.coveringZoomLevel(e);const o=i,r=!!e.useElevationData;if(void 0!==e.minzoom&&i<e.minzoom)return [];void 0!==e.maxzoom&&i>e.maxzoom&&(i=e.maxzoom);const a=t.MercatorCoordinate.fromLngLat(this.center),n=1<<i,s=[n*a.x,n*a.y,0],l=_.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,i),c=this.pointCoordinate(this.getCameraPoint()),h=n*t.mercatorZfromAltitude(1,this.center.lat),u=this._camera.position[2]/t.mercatorZfromAltitude(1,this.center.lat),d=[n*c.x,n*c.y,u],p=this.cameraToCenterDistance/e.tileSize*(e.roundZoom?1:.502),f=this.pitch<=60&&this._edgeInsets.top<=this._edgeInsets.bottom&&!this._elevation?i:0,g=this.elevation?1e4*this.elevation.exaggeration():0,x=t=>({aabb:new m([t*n,0,-g],[(t+1)*n,n,g]),zoom:0,x:0,y:0,wrap:t,fullyVisible:!1}),v=[],y=[],b=i,w=e.reparseOverscaled?o:i,T=(t,e)=>{if(!this._elevation)return;const i=this._elevation.getMinMaxForTile(e);i&&(t.min[2]=i.min,t.max[2]=i.max,t.center[2]=(t.min[2]+t.max[2])/2);},E=t=>t*t,C=E((u-this._centerAltitude)*h),S=(t,e)=>{if(e*E(.707)<t)return 1;const i=Math.sqrt(e/t);return i/(1.4144271570014144+(Math.pow(1.1,i-1.4144271570014144+1)-1)/(1.1-1)-1)};if(this._renderWorldCopies)for(let t=1;t<=3;t++)v.push(x(-t)),v.push(x(t));for(v.push(x(0));v.length>0;){const o=v.pop(),a=o.x,n=o.y;let c=o.fullyVisible;if(!c){const t=o.aabb.intersects(l);if(0===t)continue;c=2===t;}let u=!0;if(f<=o.zoom&&o.zoom<b){const t=o.aabb.distanceX(d),e=o.aabb.distanceY(d);let i=C;r&&(i=E(o.aabb.distanceZ(d)*h));const a=t*t+e*e+i;u=a<E((1<<b-o.zoom)*p*S(Math.max(i,C),a));}if(o.zoom!==b&&u)for(let e=0;e<4;e++){const i=(a<<1)+e%2,s=(n<<1)+(e>>1),l=o.aabb.quadrant(e);let h=null;r&&o.zoom>b-6&&(h=new t.OverscaledTileID(o.zoom+1===b?w:o.zoom+1,o.wrap,o.zoom+1,i,s),T(l,h)),v.push({aabb:l,zoom:o.zoom+1,x:i,y:s,wrap:o.wrap,fullyVisible:c,tileID:h});}else {const r=o.zoom===b?w:o.zoom;if(e.minzoom&&e.minzoom>r)continue;const l=s[0]-(.5+a+(o.wrap<<o.zoom))*(1<<i-o.zoom),c=s[1]-.5-n,h=o.tileID?o.tileID:new t.OverscaledTileID(r,o.wrap,o.zoom,a,n);y.push({tileID:h,distanceSq:l*l+c*c});}}return y.sort(((t,e)=>t.distanceSq-e.distanceSq)).map((t=>t.tileID))}resize(t,e){this.width=t,this.height=e,this.pixelsToGLUnits=[2/t,-2/e],this._constrain(),this._calcMatrices();}get unmodified(){return this._unmodified}zoomScale(t){return Math.pow(2,t)}scaleZoom(t){return Math.log(t)/Math.LN2}project(e){const i=t.clamp(e.lat,-this.maxValidLatitude,this.maxValidLatitude);return new t.pointGeometry(t.mercatorXfromLng(e.lng)*this.worldSize,t.mercatorYfromLat(i)*this.worldSize)}unproject(e){return new t.MercatorCoordinate(e.x/this.worldSize,e.y/this.worldSize).toLngLat()}get point(){return this.project(this.center)}setLocationAtPoint(e,i){const o=this.pointCoordinate(i),r=this.pointCoordinate(this.centerPoint),a=this.locationCoordinate(e),n=new t.MercatorCoordinate(a.x-(o.x-r.x),a.y-(o.y-r.y));this.center=this.coordinateLocation(n),this._renderWorldCopies&&(this.center=this.center.wrap());}setLocation(t){this.center=this.coordinateLocation(t),this._renderWorldCopies&&(this.center=this.center.wrap());}locationPoint(t){return this._coordinatePoint(this.locationCoordinate(t),!1)}locationPoint3D(t){return this._coordinatePoint(this.locationCoordinate(t),!0)}pointLocation(t){return this.coordinateLocation(this.pointCoordinate(t))}pointLocation3D(t){return this.coordinateLocation(this.pointCoordinate3D(t))}locationCoordinate(e){return t.MercatorCoordinate.fromLngLat(e)}coordinateLocation(t){return t.toLngLat()}pointRayIntersection(e,i){const o=null!=i?i:this._centerAltitude,r=[e.x,e.y,0,1],a=[e.x,e.y,1,1];t.transformMat4(r,r,this.pixelMatrixInverse),t.transformMat4(a,a,this.pixelMatrixInverse);const n=a[3];t.scale$2(r,r,1/r[3]),t.scale$2(a,a,1/n);const s=r[2],l=a[2];return {p0:r,p1:a,t:s===l?0:(o-s)/(l-s)}}screenPointToMercatorRay(e){const i=[e.x,e.y,0,1],o=[e.x,e.y,1,1];return t.transformMat4(i,i,this.pixelMatrixInverse),t.transformMat4(o,o,this.pixelMatrixInverse),t.scale$2(i,i,1/i[3]),t.scale$2(o,o,1/o[3]),i[2]=t.mercatorZfromAltitude(i[2],this._center.lat)*this.worldSize,o[2]=t.mercatorZfromAltitude(o[2],this._center.lat)*this.worldSize,t.scale$2(i,i,1/this.worldSize),t.scale$2(o,o,1/this.worldSize),new d([i[0],i[1],i[2]],t.normalize([],t.sub([],o,i)))}rayIntersectionCoordinate(e){const{p0:i,p1:o,t:r}=e,a=t.mercatorZfromAltitude(i[2],this._center.lat),n=t.mercatorZfromAltitude(o[2],this._center.lat);return new t.MercatorCoordinate(t.number(i[0],o[0],r)/this.worldSize,t.number(i[1],o[1],r)/this.worldSize,t.number(a,n,r))}pointCoordinate(e){const i=this.horizonLineFromTop(!1),o=new t.pointGeometry(e.x,Math.max(i,e.y));return this.rayIntersectionCoordinate(this.pointRayIntersection(o))}pointCoordinate3D(e){if(!this.elevation)return this.pointCoordinate(e);const i=this.elevation;let o=this.elevation.pointCoordinate(e);if(o)return new t.MercatorCoordinate(o[0],o[1],o[2]);let r=0,a=this.horizonLineFromTop();if(e.y>a)return this.pointCoordinate(e);const n=.02*a,s=e.clone();for(let e=0;e<10&&a-r>n;e++){s.y=t.number(r,a,.66);const e=i.pointCoordinate(s);e?(a=s.y,o=e):r=s.y;}return o?new t.MercatorCoordinate(o[0],o[1],o[2]):this.pointCoordinate(e)}isPointAboveHorizon(t){if(this.elevation)return !this.elevation.pointCoordinate(t);{const e=this.horizonLineFromTop();return t.y<e}}_coordinatePoint(e,i){const o=i&&this.elevation?this.elevation.getAtPoint(e,this._centerAltitude):this._centerAltitude,r=[e.x*this.worldSize,e.y*this.worldSize,o+e.toAltitude(),1];return t.transformMat4(r,r,this.pixelMatrix),r[3]>0?new t.pointGeometry(r[0]/r[3],r[1]/r[3]):new t.pointGeometry(Number.MAX_VALUE,Number.MAX_VALUE)}getBounds(){return this._terrainEnabled()?this._getBounds3D():(new t.LngLatBounds).extend(this.pointLocation(new t.pointGeometry(this._edgeInsets.left,this._edgeInsets.top))).extend(this.pointLocation(new t.pointGeometry(this.width-this._edgeInsets.right,this._edgeInsets.top))).extend(this.pointLocation(new t.pointGeometry(this.width-this._edgeInsets.right,this.height-this._edgeInsets.bottom))).extend(this.pointLocation(new t.pointGeometry(this._edgeInsets.left,this.height-this._edgeInsets.bottom)))}_getBounds3D(){const e=this.elevation,i=e.visibleDemTiles.reduce(((t,e)=>{if(e.dem){const i=e.dem.tree;t.min=Math.min(t.min,i.minimums[0]),t.max=Math.max(t.max,i.maximums[0]);}return t}),{min:Number.MAX_VALUE,max:0});i.min*=e.exaggeration(),i.max*=e.exaggeration();const o=this.horizonLineFromTop();return [new t.pointGeometry(0,o),new t.pointGeometry(this.width,o),new t.pointGeometry(this.width,this.height),new t.pointGeometry(0,this.height)].reduce(((t,e)=>t.extend(this.coordinateLocation(this.rayIntersectionCoordinate(this.pointRayIntersection(e,i.min)))).extend(this.coordinateLocation(this.rayIntersectionCoordinate(this.pointRayIntersection(e,i.max))))),new t.LngLatBounds)}horizonLineFromTop(t=!0){const e=this.height/2/Math.tan(this._fov/2)/Math.tan(Math.max(this._pitch,.1))+this.centerOffset.y,i=this.height/2-.97*e;return t?Math.max(0,i):i}getMaxBounds(){return this.latRange&&2===this.latRange.length&&this.lngRange&&2===this.lngRange.length?new t.LngLatBounds([this.lngRange[0],this.latRange[0]],[this.lngRange[1],this.latRange[1]]):null}setMaxBounds(t){t?(this.lngRange=[t.getWest(),t.getEast()],this.latRange=[t.getSouth(),t.getNorth()],this._constrain()):(this.lngRange=null,this.latRange=[-this.maxValidLatitude,this.maxValidLatitude]);}calculatePosMatrix(e,i=!1){const o=e.key,r=i?this._alignedPosMatrixCache:this._posMatrixCache;if(r[o])return r[o];const a=e.canonical,n=this.worldSize/this.zoomScale(a.z),s=a.x+Math.pow(2,a.z)*e.wrap,l=t.identity(new Float64Array(16));return t.translate(l,l,[s*n,a.y*n,0]),t.scale$1(l,l,[n/t.EXTENT,n/t.EXTENT,1]),t.multiply(l,i?this.alignedProjMatrix:this.projMatrix,l),r[o]=new Float32Array(l),r[o]}customLayerMatrix(){return this.mercatorMatrix.slice()}recenterOnTerrain(){if(!this._elevation)return;const e=this._elevation;this._updateCameraState();const i=this._camera.position,o=this._camera.forward();if(i.z<=0||o[2]>=0)return;const r=t.mercatorZfromAltitude(1,this._center.lat);i[2]/=r,o[2]/=r,t.normalize(o,o);const a=e.raycast(i,o,e.exaggeration());if(a){const e=t.scaleAndAdd([],i,o,a),r=new t.MercatorCoordinate(e[0],e[1],t.mercatorZfromAltitude(e[2],t.latFromMercatorY(e[1]))),n=this._camera.position,s=r.z+t.length([r.x-n[0],r.y-n[1],r.z-n[2]]);this._cameraZoom=this._zoomFromMercatorZ(s),this._centerAltitude=r.toAltitude(),this._center=r.toLngLat(),this._updateZoomFromElevation(),this._constrain(),this._calcMatrices();}}_constrainCameraAltitude(){if(!this._elevation)return;const e=this._elevation;this._updateCameraState();const i=e.getAtPoint(this._camera.mercatorPosition),o=this._minimumHeightOverTerrain()*Math.cos(t.degToRad(this._maxPitch)),r=t.mercatorZfromAltitude(i,this._center.lat),a=this._camera.position[2]-r;if(a<o){const e=t.MercatorCoordinate.fromLngLat(this._center,this._centerAltitude),i=this._camera.mercatorPosition,r=[e.x-i.x,e.y-i.y,e.z-i.z],n=t.length(r);r[2]-=o-a;const s=t.length(r);if(0===s)return;t.scale(r,r,n/s),this._camera.position=[e.x-r[0],e.y-r[1],e.z-r[2]],this._camera.orientation=uo(r,this._camera.up()),this._updateStateFromCamera();}}_constrain(){if(!this.center||!this.width||!this.height||this._constraining)return;this._constraining=!0;let e,i,o,r,a=-90,n=90,s=-180,l=180;const c=this.size,h=this._unmodified;if(this.latRange){const i=this.latRange;a=t.mercatorYfromLat(i[1])*this.worldSize,n=t.mercatorYfromLat(i[0])*this.worldSize,e=n-a<c.y?c.y/(n-a):0;}if(this.lngRange){const e=this.lngRange;s=t.mercatorXfromLng(e[0])*this.worldSize,l=t.mercatorXfromLng(e[1])*this.worldSize,i=l-s<c.x?c.x/(l-s):0;}const u=this.point,d=Math.max(i||0,e||0);if(d)return this.center=this.unproject(new t.pointGeometry(i?(l+s)/2:u.x,e?(n+a)/2:u.y)),this.zoom+=this.scaleZoom(d),this._unmodified=h,void(this._constraining=!1);if(this.latRange){const t=u.y,e=c.y/2;t-e<a&&(r=a+e),t+e>n&&(r=n-e);}if(this.lngRange){const t=u.x,e=c.x/2;t-e<s&&(o=s+e),t+e>l&&(o=l-e);}void 0===o&&void 0===r||(this.center=this.unproject(new t.pointGeometry(void 0!==o?o:u.x,void 0!==r?r:u.y))),this._constrainCameraAltitude(),this._unmodified=h,this._constraining=!1;}_minZoomForBounds(){const e=(t,e)=>Math.log2(t/(this.tileSize*Math.abs(e[1]-e[0])));let i=0;if(this.latRange){const o=this.latRange;i=e(this.height,[t.mercatorYfromLat(o[0]),t.mercatorYfromLat(o[1])]);}let o=0;if(this.lngRange){const i=this.lngRange;o=e(this.width,[t.mercatorXfromLng(i[0]),t.mercatorXfromLng(i[1])]);}return Math.max(i,o)}_maxCameraBoundsDistance(){return this._mercatorZfromZoom(this._minZoomForBounds())}_calcMatrices(){if(!this.height)return;const e=this.centerOffset;this.cameraToCenterDistance=.5/Math.tan(this._fov/2)*this.height;const i=t.mercatorZfromAltitude(1,this.center.lat)*this.worldSize;this._updateCameraState();const o=Math.PI/2+this._pitch,r=this.fovAboveCenter,a=this.elevation?this.elevation.getMinElevationBelowMSL()*i:0,n=(this._camera.position[2]*this.worldSize-a)/Math.cos(this._pitch),s=Math.sin(r)*n/Math.sin(t.clamp(Math.PI-o-r,.01,Math.PI-.01)),l=this.point,c=l.x,h=l.y,u=Math.cos(Math.PI/2-this._pitch)*s+n,d=Math.min(1.01*u,n*(1/this._horizonShift)),_=this.height/50,m=this._camera.getWorldToCamera(this.worldSize,i),p=this._camera.getCameraToClipPerspective(this._fov,this.width/this.height,_,d);p[8]=2*-e.x/this.width,p[9]=2*e.y/this.height;let f=t.mul$1([],p,m);this.mercatorMatrix=t.scale$1([],f,[this.worldSize,this.worldSize,this.worldSize/i]),this.projMatrix=f,this.invProjMatrix=t.invert(new Float64Array(16),this.projMatrix);const g=new Float32Array(16);t.identity(g),t.scale$1(g,g,[1,-1,1]),t.rotateX(g,g,this._pitch),t.rotateZ(g,g,this.angle);const x=t.perspective(new Float32Array(16),this._fov,this.width/this.height,_,d),v=(Math.PI/2-this._pitch)*(this.height/this._fov)*this._horizonShift;x[8]=2*-e.x/this.width,x[9]=2*(e.y+v)/this.height,this.skyboxMatrix=t.multiply(g,x,g);const y=this.width%2/2,b=this.height%2/2,w=Math.cos(this.angle),T=Math.sin(this.angle),E=c-Math.round(c)+w*y+T*b,C=h-Math.round(h)+w*b+T*y,S=new Float64Array(f);if(t.translate(S,S,[E>.5?E-1:E,C>.5?C-1:C,0]),this.alignedProjMatrix=S,f=t.create$1(),t.scale$1(f,f,[this.width/2,-this.height/2,1]),t.translate(f,f,[1,-1,0]),this.labelPlaneMatrix=f,f=t.create$1(),t.scale$1(f,f,[1,-1,1]),t.translate(f,f,[-1,-1,0]),t.scale$1(f,f,[2/this.width,2/this.height,1]),this.glCoordMatrix=f,this.pixelMatrix=t.multiply(new Float64Array(16),this.labelPlaneMatrix,this.projMatrix),f=t.invert(new Float64Array(16),this.pixelMatrix),!f)throw new Error("failed to invert matrix");this.pixelMatrixInverse=f,this._posMatrixCache={},this._alignedPosMatrixCache={};}_updateCameraState(){if(!this.height)return;this._camera.setPitchBearing(this._pitch,this.angle);const e=this._camera.forward(),i=this.cameraToCenterDistance,o=this.point,r=this._mercatorZfromZoom(this._cameraZoom?this._cameraZoom:this._zoom)-t.mercatorZfromAltitude(this._centerAltitude,this.center.lat),a=this.cameraToCenterDistance/r;this._camera.position=[o.x/this.worldSize-e[0]*i/a,o.y/this.worldSize-e[1]*i/a,t.mercatorZfromAltitude(this._centerAltitude,this._center.lat)+-e[2]*i/a];}_translateCameraConstrained(e){const i=this._maxCameraBoundsDistance()*Math.cos(this._pitch),o=e[2];let r=1;o>0&&(r=Math.min((i-this._camera.position[2])/o,1)),this._camera.position=t.scaleAndAdd([],this._camera.position,e,r),this._updateStateFromCamera();}_updateStateFromCamera(){const e=this._camera.position,i=this._camera.forward(),{pitch:o,bearing:r}=this._camera.getPitchBearing(),a=t.mercatorZfromAltitude(this._centerAltitude,this.center.lat),n=this._mercatorZfromZoom(this._maxZoom)*Math.cos(t.degToRad(this._maxPitch)),s=Math.max((e[2]-a)/Math.cos(o),n),l=this._zoomFromMercatorZ(s);t.scaleAndAdd(e,e,i,s),this._pitch=t.clamp(o,t.degToRad(this.minPitch),t.degToRad(this.maxPitch)),this.angle=t.wrap(r,-Math.PI,Math.PI),this._setZoom(t.clamp(l,this._minZoom,this._maxZoom)),this._terrainEnabled()&&this._updateCameraOnTerrain(),this._center=new t.MercatorCoordinate(e[0],e[1],e[2]).toLngLat(),this._unmodified=!1,this._constrain(),this._calcMatrices();}_worldSizeFromZoom(t){return Math.pow(2,t)*this.tileSize}_mercatorZfromZoom(t){return this.cameraToCenterDistance/this._worldSizeFromZoom(t)}_minimumHeightOverTerrain(){const t=Math.min((null!=this._cameraZoom?this._cameraZoom:this._zoom)+2,this._maxZoom);return this._mercatorZfromZoom(t)}_zoomFromMercatorZ(t){return this.scaleZoom(this.cameraToCenterDistance/(t*this.tileSize))}_terrainEnabled(){return !!this._elevation}isHorizonVisibleForPoints(e,i){const o=Math.min(e.x,i.x),r=Math.max(e.x,i.x),a=Math.min(e.y,i.y),n=Math.max(e.y,i.y),s=[new t.pointGeometry(o,a),new t.pointGeometry(r,n),new t.pointGeometry(o,n),new t.pointGeometry(r,a)],l=this._renderWorldCopies?-3:0,c=this._renderWorldCopies?4:1;for(const t of s){const e=this.pointRayIntersection(t);if(e.t<0)return !0;const i=this.rayIntersectionCoordinate(e);if(i.x<l||i.y<0||i.x>c||i.y>1)return !0}return !1}isHorizonVisible(){return this.pitch+t.radToDeg(this.fovAboveCenter)>88||this.isHorizonVisibleForPoints(new t.pointGeometry(0,0),new t.pointGeometry(this.width,this.height))}zoomDeltaToMovement(e,i){const o=t.length(t.sub([],this._camera.position,e)),r=this._zoomFromMercatorZ(o)+i;return o-this._mercatorZfromZoom(r)}getCameraPoint(){const e=Math.tan(this._pitch)*(this.cameraToCenterDistance||1);return this.centerPoint.add(new t.pointGeometry(0,e))}}class fo{constructor(e){this._hashName=e&&encodeURIComponent(e),t.bindAll(["_getCurrentHash","_onHashChange","_updateHash"],this),this._updateHash=function(t,e){let i=!1,o=null;const r=()=>{o=null,i&&(t(),o=setTimeout(r,300),i=!1);};return ()=>(i=!0,o||r(),o)}(this._updateHashUnthrottled.bind(this));}addTo(e){return this._map=e,t.window.addEventListener("hashchange",this._onHashChange,!1),this._map.on("moveend",this._updateHash),this}remove(){return t.window.removeEventListener("hashchange",this._onHashChange,!1),this._map.off("moveend",this._updateHash),clearTimeout(this._updateHash()),delete this._map,this}getHashString(e){const i=this._map.getCenter(),o=Math.round(100*this._map.getZoom())/100,r=Math.ceil((o*Math.LN2+Math.log(512/360/.5))/Math.LN10),a=Math.pow(10,r),n=Math.round(i.lng*a)/a,s=Math.round(i.lat*a)/a,l=this._map.getBearing(),c=this._map.getPitch();let h="";if(h+=e?`/${n}/${s}/${o}`:`${o}/${s}/${n}`,(l||c)&&(h+="/"+Math.round(10*l)/10),c&&(h+=`/${Math.round(c)}`),this._hashName){const e=this._hashName;let i=!1;const o=t.window.location.hash.slice(1).split("&").map((t=>{const o=t.split("=")[0];return o===e?(i=!0,`${o}=${h}`):t})).filter((t=>t));return i||o.push(`${e}=${h}`),`#${o.join("&")}`}return `#${h}`}_getCurrentHash(){const e=t.window.location.hash.replace("#","");if(this._hashName){let t;return e.split("&").map((t=>t.split("="))).forEach((e=>{e[0]===this._hashName&&(t=e);})),(t&&t[1]||"").split("/")}return e.split("/")}_onHashChange(){const t=this._getCurrentHash();if(t.length>=3&&!t.some((t=>isNaN(t)))){const e=this._map.dragRotate.isEnabled()&&this._map.touchZoomRotate.isEnabled()?+(t[3]||0):this._map.getBearing();return this._map.jumpTo({center:[+t[2],+t[1]],zoom:+t[0],bearing:e,pitch:+(t[4]||0)}),!0}return !1}_updateHashUnthrottled(){const e=t.window.location.href.replace(/(#.+)?$/,this.getHashString());t.window.history.replaceState(t.window.history.state,null,e);}}const go={linearity:.3,easing:t.bezier(0,0,.3,1)},xo=t.extend({deceleration:2500,maxSpeed:1400},go),vo=t.extend({deceleration:20,maxSpeed:1400},go),yo=t.extend({deceleration:1e3,maxSpeed:360},go),bo=t.extend({deceleration:1e3,maxSpeed:90},go);class wo{constructor(t){this._map=t,this.clear();}clear(){this._inertiaBuffer=[];}record(e){this._drainInertiaBuffer(),this._inertiaBuffer.push({time:t.exported.now(),settings:e});}_drainInertiaBuffer(){const e=this._inertiaBuffer,i=t.exported.now();for(;e.length>0&&i-e[0].time>160;)e.shift();}_onMoveEnd(e){if(this._drainInertiaBuffer(),this._inertiaBuffer.length<2)return;const i={zoom:0,bearing:0,pitch:0,pan:new t.pointGeometry(0,0),pinchAround:void 0,around:void 0};for(const{settings:t}of this._inertiaBuffer)i.zoom+=t.zoomDelta||0,i.bearing+=t.bearingDelta||0,i.pitch+=t.pitchDelta||0,t.panDelta&&i.pan._add(t.panDelta),t.around&&(i.around=t.around),t.pinchAround&&(i.pinchAround=t.pinchAround);const o=this._inertiaBuffer[this._inertiaBuffer.length-1].time-this._inertiaBuffer[0].time,r={};if(i.pan.mag()){const a=Eo(i.pan.mag(),o,t.extend({},xo,e||{}));r.offset=i.pan.mult(a.amount/i.pan.mag()),r.center=this._map.transform.center,To(r,a);}if(i.zoom){const t=Eo(i.zoom,o,vo);r.zoom=this._map.transform.zoom+t.amount,To(r,t);}if(i.bearing){const e=Eo(i.bearing,o,yo);r.bearing=this._map.transform.bearing+t.clamp(e.amount,-179,179),To(r,e);}if(i.pitch){const t=Eo(i.pitch,o,bo);r.pitch=this._map.transform.pitch+t.amount,To(r,t);}if(r.zoom||r.bearing){const t=void 0===i.pinchAround?i.around:i.pinchAround;r.around=t?this._map.unproject(t):this._map.getCenter();}return this.clear(),t.extend(r,{noMoveStart:!0})}}function To(t,e){(!t.duration||t.duration<e.duration)&&(t.duration=e.duration,t.easing=e.easing);}function Eo(e,i,o){const{maxSpeed:r,linearity:a,deceleration:n}=o,s=t.clamp(e*a/(i/1e3),-r,r),l=Math.abs(s)/(n*a);return {easing:o.easing,duration:1e3*l,amount:s*(l/2)}}class Co extends t.Event{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(e,i,o,r={}){const n=a.mousePos(i.getCanvasContainer(),o),s=i.unproject(n);super(e,t.extend({point:n,lngLat:s,originalEvent:o},r)),this._defaultPrevented=!1,this.target=i;}}class So extends t.Event{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(e,i,o){const r="touchend"===e?o.changedTouches:o.touches,n=a.touchPos(i.getCanvasContainer(),r),s=n.map((t=>i.unproject(t))),l=n.reduce(((t,e,i,o)=>t.add(e.div(o.length))),new t.pointGeometry(0,0));super(e,{points:n,point:l,lngLats:s,lngLat:i.unproject(l),originalEvent:o}),this._defaultPrevented=!1;}}class Io extends t.Event{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(t,e,i){super(t,{originalEvent:i}),this._defaultPrevented=!1;}}class Mo{constructor(t,e){this._map=t,this._clickTolerance=e.clickTolerance;}reset(){delete this._mousedownPos;}wheel(t){return this._firePreventable(new Io(t.type,this._map,t))}mousedown(t,e){return this._mousedownPos=e,this._firePreventable(new Co(t.type,this._map,t))}mouseup(t){this._map.fire(new Co(t.type,this._map,t));}click(t,e){this._mousedownPos&&this._mousedownPos.dist(e)>=this._clickTolerance||this._map.fire(new Co(t.type,this._map,t));}dblclick(t){return this._firePreventable(new Co(t.type,this._map,t))}mouseover(t){this._map.fire(new Co(t.type,this._map,t));}mouseout(t){this._map.fire(new Co(t.type,this._map,t));}touchstart(t){return this._firePreventable(new So(t.type,this._map,t))}touchmove(t){this._map.fire(new So(t.type,this._map,t));}touchend(t){this._map.fire(new So(t.type,this._map,t));}touchcancel(t){this._map.fire(new So(t.type,this._map,t));}_firePreventable(t){if(this._map.fire(t),t.defaultPrevented)return {}}isEnabled(){return !0}isActive(){return !1}enable(){}disable(){}}class zo{constructor(t){this._map=t;}reset(){this._delayContextMenu=!1,delete this._contextMenuEvent;}mousemove(t){this._map.fire(new Co(t.type,this._map,t));}mousedown(){this._delayContextMenu=!0;}mouseup(){this._delayContextMenu=!1,this._contextMenuEvent&&(this._map.fire(new Co("contextmenu",this._map,this._contextMenuEvent)),delete this._contextMenuEvent);}contextmenu(t){this._delayContextMenu?this._contextMenuEvent=t:this._map.fire(new Co(t.type,this._map,t)),this._map.listens("contextmenu")&&t.preventDefault();}isEnabled(){return !0}isActive(){return !1}enable(){}disable(){}}class Po{constructor(t,e){this._map=t,this._el=t.getCanvasContainer(),this._container=t.getContainer(),this._clickTolerance=e.clickTolerance||1;}isEnabled(){return !!this._enabled}isActive(){return !!this._active}enable(){this.isEnabled()||(this._enabled=!0);}disable(){this.isEnabled()&&(this._enabled=!1);}mousedown(t,e){this.isEnabled()&&t.shiftKey&&0===t.button&&(a.disableDrag(),this._startPos=this._lastPos=e,this._active=!0);}mousemoveWindow(t,e){if(!this._active)return;const i=e;if(this._lastPos.equals(i)||!this._box&&i.dist(this._startPos)<this._clickTolerance)return;const o=this._startPos;this._lastPos=i,this._box||(this._box=a.create("div","mapboxgl-boxzoom",this._container),this._container.classList.add("mapboxgl-crosshair"),this._fireEvent("boxzoomstart",t));const r=Math.min(o.x,i.x),n=Math.max(o.x,i.x),s=Math.min(o.y,i.y),l=Math.max(o.y,i.y);a.setTransform(this._box,`translate(${r}px,${s}px)`),this._box.style.width=n-r+"px",this._box.style.height=l-s+"px";}mouseupWindow(e,i){if(!this._active)return;if(0!==e.button)return;const o=this._startPos,r=i;if(this.reset(),a.suppressClick(),o.x!==r.x||o.y!==r.y)return this._map.fire(new t.Event("boxzoomend",{originalEvent:e})),{cameraAnimation:t=>t.fitScreenCoordinates(o,r,this._map.getBearing(),{linear:!1})};this._fireEvent("boxzoomcancel",e);}keydown(t){this._active&&27===t.keyCode&&(this.reset(),this._fireEvent("boxzoomcancel",t));}reset(){this._active=!1,this._container.classList.remove("mapboxgl-crosshair"),this._box&&(a.remove(this._box),this._box=null),a.enableDrag(),delete this._startPos,delete this._lastPos;}_fireEvent(e,i){return this._map.fire(new t.Event(e,{originalEvent:i}))}}function Ao(t,e){const i={};for(let o=0;o<t.length;o++)i[t[o].identifier]=e[o];return i}class Do{constructor(t){this.reset(),this.numTouches=t.numTouches;}reset(){delete this.centroid,delete this.startTime,delete this.touches,this.aborted=!1;}touchstart(e,i,o){(this.centroid||o.length>this.numTouches)&&(this.aborted=!0),this.aborted||(void 0===this.startTime&&(this.startTime=e.timeStamp),o.length===this.numTouches&&(this.centroid=function(e){const i=new t.pointGeometry(0,0);for(const t of e)i._add(t);return i.div(e.length)}(i),this.touches=Ao(o,i)));}touchmove(t,e,i){if(this.aborted||!this.centroid)return;const o=Ao(i,e);for(const t in this.touches){const e=this.touches[t],i=o[t];(!i||i.dist(e)>30)&&(this.aborted=!0);}}touchend(t,e,i){if((!this.centroid||t.timeStamp-this.startTime>500)&&(this.aborted=!0),0===i.length){const t=!this.aborted&&this.centroid;if(this.reset(),t)return t}}}class Lo{constructor(t){this.singleTap=new Do(t),this.numTaps=t.numTaps,this.reset();}reset(){this.lastTime=1/0,delete this.lastTap,this.count=0,this.singleTap.reset();}touchstart(t,e,i){this.singleTap.touchstart(t,e,i);}touchmove(t,e,i){this.singleTap.touchmove(t,e,i);}touchend(t,e,i){const o=this.singleTap.touchend(t,e,i);if(o){const e=t.timeStamp-this.lastTime<500,i=!this.lastTap||this.lastTap.dist(o)<30;if(e&&i||this.reset(),this.count++,this.lastTime=t.timeStamp,this.lastTap=o,this.count===this.numTaps)return this.reset(),o}}}class Ro{constructor(){this._zoomIn=new Lo({numTouches:1,numTaps:2}),this._zoomOut=new Lo({numTouches:2,numTaps:1}),this.reset();}reset(){this._active=!1,this._zoomIn.reset(),this._zoomOut.reset();}touchstart(t,e,i){this._zoomIn.touchstart(t,e,i),this._zoomOut.touchstart(t,e,i);}touchmove(t,e,i){this._zoomIn.touchmove(t,e,i),this._zoomOut.touchmove(t,e,i);}touchend(t,e,i){const o=this._zoomIn.touchend(t,e,i),r=this._zoomOut.touchend(t,e,i);return o?(this._active=!0,t.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:e=>e.easeTo({duration:300,zoom:e.getZoom()+1,around:e.unproject(o)},{originalEvent:t})}):r?(this._active=!0,t.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:e=>e.easeTo({duration:300,zoom:e.getZoom()-1,around:e.unproject(r)},{originalEvent:t})}):void 0}touchcancel(){this.reset();}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}const ko={0:1,2:2};class Bo{constructor(t){this.reset(),this._clickTolerance=t.clickTolerance||1;}reset(){this._active=!1,this._moved=!1,delete this._lastPoint,delete this._eventButton;}_correctButton(t,e){return !1}_move(t,e){return {}}mousedown(t,e){if(this._lastPoint)return;const i=a.mouseButton(t);this._correctButton(t,i)&&(this._lastPoint=e,this._eventButton=i);}mousemoveWindow(t,e){const i=this._lastPoint;if(i)if(t.preventDefault(),function(t,e){const i=ko[e];return void 0===t.buttons||(t.buttons&i)!==i}(t,this._eventButton))this.reset();else if(this._moved||!(e.dist(i)<this._clickTolerance))return this._moved=!0,this._lastPoint=e,this._move(i,e)}mouseupWindow(t){this._lastPoint&&a.mouseButton(t)===this._eventButton&&(this._moved&&a.suppressClick(),this.reset());}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class Fo extends Bo{mousedown(t,e){super.mousedown(t,e),this._lastPoint&&(this._active=!0);}_correctButton(t,e){return 0===e&&!t.ctrlKey}_move(t,e){return {around:e,panDelta:e.sub(t)}}}class Oo extends Bo{_correctButton(t,e){return 0===e&&t.ctrlKey||2===e}_move(t,e){const i=.8*(e.x-t.x);if(i)return this._active=!0,{bearingDelta:i}}contextmenu(t){t.preventDefault();}}class Uo extends Bo{_correctButton(t,e){return 0===e&&t.ctrlKey||2===e}_move(t,e){const i=-.5*(e.y-t.y);if(i)return this._active=!0,{pitchDelta:i}}contextmenu(t){t.preventDefault();}}class No{constructor(t){this._minTouches=1,this._clickTolerance=t.clickTolerance||1,this.reset();}reset(){this._active=!1,this._touches={},this._sum=new t.pointGeometry(0,0);}touchstart(t,e,i){return this._calculateTransform(t,e,i)}touchmove(t,e,i){if(this._active&&!(i.length<this._minTouches))return t.preventDefault(),this._calculateTransform(t,e,i)}touchend(t,e,i){this._calculateTransform(t,e,i),this._active&&i.length<this._minTouches&&this.reset();}touchcancel(){this.reset();}_calculateTransform(e,i,o){o.length>0&&(this._active=!0);const r=Ao(o,i),a=new t.pointGeometry(0,0),n=new t.pointGeometry(0,0);let s=0;for(const t in r){const e=r[t],i=this._touches[t];i&&(a._add(e),n._add(e.sub(i)),s++,r[t]=e);}if(this._touches=r,s<this._minTouches||!n.mag())return;const l=n.div(s);return this._sum._add(l),this._sum.mag()<this._clickTolerance?void 0:{around:a.div(s),panDelta:l}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class Go{constructor(){this.reset();}reset(){this._active=!1,delete this._firstTwoTouches;}_start(t){}_move(t,e,i){return {}}touchstart(t,e,i){this._firstTwoTouches||i.length<2||(this._firstTwoTouches=[i[0].identifier,i[1].identifier],this._start([e[0],e[1]]));}touchmove(t,e,i){if(!this._firstTwoTouches)return;t.preventDefault();const[o,r]=this._firstTwoTouches,a=Zo(i,e,o),n=Zo(i,e,r);if(!a||!n)return;const s=this._aroundCenter?null:a.add(n).div(2);return this._move([a,n],s,t)}touchend(t,e,i){if(!this._firstTwoTouches)return;const[o,r]=this._firstTwoTouches,n=Zo(i,e,o),s=Zo(i,e,r);n&&s||(this._active&&a.suppressClick(),this.reset());}touchcancel(){this.reset();}enable(t){this._enabled=!0,this._aroundCenter=!!t&&"center"===t.around;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}function Zo(t,e,i){for(let o=0;o<t.length;o++)if(t[o].identifier===i)return e[o]}function Vo(t,e){return Math.log(t/e)/Math.LN2}class qo extends Go{reset(){super.reset(),delete this._distance,delete this._startDistance;}_start(t){this._startDistance=this._distance=t[0].dist(t[1]);}_move(t,e){const i=this._distance;if(this._distance=t[0].dist(t[1]),this._active||!(Math.abs(Vo(this._distance,this._startDistance))<.1))return this._active=!0,{zoomDelta:Vo(this._distance,i),pinchAround:e}}}function Wo(t,e){return 180*t.angleWith(e)/Math.PI}class jo extends Go{reset(){super.reset(),delete this._minDiameter,delete this._startVector,delete this._vector;}_start(t){this._startVector=this._vector=t[0].sub(t[1]),this._minDiameter=t[0].dist(t[1]);}_move(t,e){const i=this._vector;if(this._vector=t[0].sub(t[1]),this._active||!this._isBelowThreshold(this._vector))return this._active=!0,{bearingDelta:Wo(this._vector,i),pinchAround:e}}_isBelowThreshold(t){this._minDiameter=Math.min(this._minDiameter,t.mag());const e=25/(Math.PI*this._minDiameter)*360,i=Wo(t,this._startVector);return Math.abs(i)<e}}function Xo(t){return Math.abs(t.y)>Math.abs(t.x)}class $o extends Go{reset(){super.reset(),this._valid=void 0,delete this._firstMove,delete this._lastPoints;}_start(t){this._lastPoints=t,Xo(t[0].sub(t[1]))&&(this._valid=!1);}_move(t,e,i){const o=t[0].sub(this._lastPoints[0]),r=t[1].sub(this._lastPoints[1]);if(this._valid=this.gestureBeginsVertically(o,r,i.timeStamp),this._valid)return this._lastPoints=t,this._active=!0,{pitchDelta:(o.y+r.y)/2*-.5}}gestureBeginsVertically(t,e,i){if(void 0!==this._valid)return this._valid;const o=t.mag()>=2,r=e.mag()>=2;if(!o&&!r)return;if(!o||!r)return void 0===this._firstMove&&(this._firstMove=i),i-this._firstMove<100&&void 0;const a=t.y>0==e.y>0;return Xo(t)&&Xo(e)&&a}}const Ho={panStep:100,bearingStep:15,pitchStep:10};class Ko{constructor(){const t=Ho;this._panStep=t.panStep,this._bearingStep=t.bearingStep,this._pitchStep=t.pitchStep,this._rotationDisabled=!1;}reset(){this._active=!1;}keydown(t){if(t.altKey||t.ctrlKey||t.metaKey)return;let e=0,i=0,o=0,r=0,a=0;switch(t.keyCode){case 61:case 107:case 171:case 187:e=1;break;case 189:case 109:case 173:e=-1;break;case 37:t.shiftKey?i=-1:(t.preventDefault(),r=-1);break;case 39:t.shiftKey?i=1:(t.preventDefault(),r=1);break;case 38:t.shiftKey?o=1:(t.preventDefault(),a=-1);break;case 40:t.shiftKey?o=-1:(t.preventDefault(),a=1);break;default:return}return this._rotationDisabled&&(i=0,o=0),{cameraAnimation:n=>{const s=n.getZoom();n.easeTo({duration:300,easeId:"keyboardHandler",easing:Yo,zoom:e?Math.round(s)+e*(t.shiftKey?2:1):s,bearing:n.getBearing()+i*this._bearingStep,pitch:n.getPitch()+o*this._pitchStep,offset:[-r*this._panStep,-a*this._panStep],center:n.getCenter()},{originalEvent:t});}}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}disableRotation(){this._rotationDisabled=!0;}enableRotation(){this._rotationDisabled=!1;}}function Yo(t){return t*(2-t)}const Jo=4.000244140625;class Qo{constructor(e,i){this._map=e,this._el=e.getCanvasContainer(),this._handler=i,this._delta=0,this._defaultZoomRate=.01,this._wheelZoomRate=.0022222222222222222,t.bindAll(["_onTimeout"],this);}setZoomRate(t){this._defaultZoomRate=t;}setWheelZoomRate(t){this._wheelZoomRate=t;}isEnabled(){return !!this._enabled}isActive(){return !!this._active||void 0!==this._finishTimeout}isZooming(){return !!this._zooming}enable(t){this.isEnabled()||(this._enabled=!0,this._aroundCenter=t&&"center"===t.around);}disable(){this.isEnabled()&&(this._enabled=!1);}wheel(e){if(!this.isEnabled())return;let i=e.deltaMode===t.window.WheelEvent.DOM_DELTA_LINE?40*e.deltaY:e.deltaY;const o=t.exported.now(),r=o-(this._lastWheelEventTime||0);this._lastWheelEventTime=o,0!==i&&i%Jo==0?this._type="wheel":0!==i&&Math.abs(i)<4?this._type="trackpad":r>400?(this._type=null,this._lastValue=i,this._timeout=setTimeout(this._onTimeout,40,e)):this._type||(this._type=Math.abs(r*i)<200?"trackpad":"wheel",this._timeout&&(clearTimeout(this._timeout),this._timeout=null,i+=this._lastValue)),e.shiftKey&&i&&(i/=4),this._type&&(this._lastWheelEvent=e,this._delta-=i,this._active||this._start(e)),e.preventDefault();}_onTimeout(t){this._type="wheel",this._delta-=this._lastValue,this._active||this._start(t);}_start(t){if(!this._delta)return;this._frameId&&(this._frameId=null),this._active=!0,this.isZooming()||(this._zooming=!0),this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout);const e=a.mousePos(this._el,t);this._aroundPoint=this._aroundCenter?this._map.transform.centerPoint:e,this._aroundCoord=this._map.transform.pointCoordinate3D(this._aroundPoint),this._targetZoom=void 0,this._frameId||(this._frameId=!0,this._handler._triggerRenderFrame());}renderFrame(){if(!this._frameId)return;if(this._frameId=null,!this.isActive())return;const e=this._map.transform,i=()=>e._terrainEnabled()?e.computeZoomRelativeTo(this._aroundCoord):e.zoom;if(0!==this._delta){const t="wheel"===this._type&&Math.abs(this._delta)>Jo?this._wheelZoomRate:this._defaultZoomRate;let o=2/(1+Math.exp(-Math.abs(this._delta*t)));this._delta<0&&0!==o&&(o=1/o);const r=i(),a=Math.pow(2,r),n="number"==typeof this._targetZoom?e.zoomScale(this._targetZoom):a;this._targetZoom=Math.min(e.maxZoom,Math.max(e.minZoom,e.scaleZoom(n*o))),"wheel"===this._type&&(this._startZoom=i(),this._easing=this._smoothOutEasing(200)),this._delta=0;}const o="number"==typeof this._targetZoom?this._targetZoom:i(),r=this._startZoom,a=this._easing;let n,s=!1;if("wheel"===this._type&&r&&a){const e=Math.min((t.exported.now()-this._lastWheelEventTime)/200,1),i=a(e);n=t.number(r,o,i),e<1?this._frameId||(this._frameId=!0):s=!0;}else n=o,s=!0;return this._active=!0,s&&(this._active=!1,this._finishTimeout=setTimeout((()=>{this._zooming=!1,this._handler._triggerRenderFrame(),delete this._targetZoom,delete this._finishTimeout;}),200)),{noInertia:!0,needsRenderFrame:!s,zoomDelta:n-i(),around:this._aroundPoint,aroundCoord:this._aroundCoord,originalEvent:this._lastWheelEvent}}_smoothOutEasing(e){let i=t.ease;if(this._prevEase){const e=this._prevEase,o=(t.exported.now()-e.start)/e.duration,r=e.easing(o+.01)-e.easing(o),a=.27/Math.sqrt(r*r+1e-4)*.01,n=Math.sqrt(.0729-a*a);i=t.bezier(a,n,.25,1);}return this._prevEase={start:t.exported.now(),duration:e,easing:i},i}reset(){this._active=!1;}}class tr{constructor(t,e){this._clickZoom=t,this._tapZoom=e;}enable(){this._clickZoom.enable(),this._tapZoom.enable();}disable(){this._clickZoom.disable(),this._tapZoom.disable();}isEnabled(){return this._clickZoom.isEnabled()&&this._tapZoom.isEnabled()}isActive(){return this._clickZoom.isActive()||this._tapZoom.isActive()}}class er{constructor(){this.reset();}reset(){this._active=!1;}dblclick(t,e){return t.preventDefault(),{cameraAnimation:i=>{i.easeTo({duration:300,zoom:i.getZoom()+(t.shiftKey?-1:1),around:i.unproject(e)},{originalEvent:t});}}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class ir{constructor(){this._tap=new Lo({numTouches:1,numTaps:1}),this.reset();}reset(){this._active=!1,delete this._swipePoint,delete this._swipeTouch,delete this._tapTime,this._tap.reset();}touchstart(t,e,i){this._swipePoint||(this._tapTime&&t.timeStamp-this._tapTime>500&&this.reset(),this._tapTime?i.length>0&&(this._swipePoint=e[0],this._swipeTouch=i[0].identifier):this._tap.touchstart(t,e,i));}touchmove(t,e,i){if(this._tapTime){if(this._swipePoint){if(i[0].identifier!==this._swipeTouch)return;const o=e[0],r=o.y-this._swipePoint.y;return this._swipePoint=o,t.preventDefault(),this._active=!0,{zoomDelta:r/128}}}else this._tap.touchmove(t,e,i);}touchend(t,e,i){this._tapTime?this._swipePoint&&0===i.length&&this.reset():this._tap.touchend(t,e,i)&&(this._tapTime=t.timeStamp);}touchcancel(){this.reset();}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class or{constructor(t,e,i){this._el=t,this._mousePan=e,this._touchPan=i;}enable(t){this._inertiaOptions=t||{},this._mousePan.enable(),this._touchPan.enable(),this._el.classList.add("mapboxgl-touch-drag-pan");}disable(){this._mousePan.disable(),this._touchPan.disable(),this._el.classList.remove("mapboxgl-touch-drag-pan");}isEnabled(){return this._mousePan.isEnabled()&&this._touchPan.isEnabled()}isActive(){return this._mousePan.isActive()||this._touchPan.isActive()}}class rr{constructor(t,e,i){this._pitchWithRotate=t.pitchWithRotate,this._mouseRotate=e,this._mousePitch=i;}enable(){this._mouseRotate.enable(),this._pitchWithRotate&&this._mousePitch.enable();}disable(){this._mouseRotate.disable(),this._mousePitch.disable();}isEnabled(){return this._mouseRotate.isEnabled()&&(!this._pitchWithRotate||this._mousePitch.isEnabled())}isActive(){return this._mouseRotate.isActive()||this._mousePitch.isActive()}}class ar{constructor(t,e,i,o){this._el=t,this._touchZoom=e,this._touchRotate=i,this._tapDragZoom=o,this._rotationDisabled=!1,this._enabled=!0;}enable(t){this._touchZoom.enable(t),this._rotationDisabled||this._touchRotate.enable(t),this._tapDragZoom.enable(),this._el.classList.add("mapboxgl-touch-zoom-rotate");}disable(){this._touchZoom.disable(),this._touchRotate.disable(),this._tapDragZoom.disable(),this._el.classList.remove("mapboxgl-touch-zoom-rotate");}isEnabled(){return this._touchZoom.isEnabled()&&(this._rotationDisabled||this._touchRotate.isEnabled())&&this._tapDragZoom.isEnabled()}isActive(){return this._touchZoom.isActive()||this._touchRotate.isActive()||this._tapDragZoom.isActive()}disableRotation(){this._rotationDisabled=!0,this._touchRotate.disable();}enableRotation(){this._rotationDisabled=!1,this._touchZoom.isEnabled()&&this._touchRotate.enable();}}const nr=t=>t.zoom||t.drag||t.pitch||t.rotate;class sr extends t.Event{}class lr{constructor(){this.constants=[1,1,.01],this.radius=0;}setup(e,i){const o=t.sub([],i,e);this.radius=t.length(o[2]<0?t.div([],o,this.constants):[o[0],o[1],0]);}projectRay(e){t.div(e,e,this.constants),t.normalize(e,e),t.mul$2(e,e,this.constants);const i=t.scale([],e,this.radius);if(i[2]>0){const e=t.scale([],[0,0,1],t.dot(i,[0,0,1])),o=t.scale([],t.normalize([],[i[0],i[1],0]),this.radius),r=t.add([],i,t.scale([],t.sub([],t.add([],o,e),i),2));i[0]=r[0],i[1]=r[1];}return i}}function cr(t){return t.panDelta&&t.panDelta.mag()||t.zoomDelta||t.bearingDelta||t.pitchDelta}class hr{constructor(e,i){this._map=e,this._el=this._map.getCanvasContainer(),this._handlers=[],this._handlersById={},this._changes=[],this._inertia=new wo(e),this._bearingSnap=i.bearingSnap,this._previousActiveHandlers={},this._trackingEllipsoid=new lr,this._dragOrigin=null,this._eventsInProgress={},this._addDefaultHandlers(i),t.bindAll(["handleEvent","handleWindowEvent"],this);const o=this._el;this._listeners=[[o,"touchstart",{passive:!0}],[o,"touchmove",{passive:!1}],[o,"touchend",void 0],[o,"touchcancel",void 0],[o,"mousedown",void 0],[o,"mousemove",void 0],[o,"mouseup",void 0],[t.window.document,"mousemove",{capture:!0}],[t.window.document,"mouseup",void 0],[o,"mouseover",void 0],[o,"mouseout",void 0],[o,"dblclick",void 0],[o,"click",void 0],[o,"keydown",{capture:!1}],[o,"keyup",void 0],[o,"wheel",{passive:!1}],[o,"contextmenu",void 0],[t.window,"blur",void 0]];for(const[e,i,o]of this._listeners)a.addEventListener(e,i,e===t.window.document?this.handleWindowEvent:this.handleEvent,o);}destroy(){for(const[e,i,o]of this._listeners)a.removeEventListener(e,i,e===t.window.document?this.handleWindowEvent:this.handleEvent,o);}_addDefaultHandlers(t){const e=this._map,i=e.getCanvasContainer();this._add("mapEvent",new Mo(e,t));const o=e.boxZoom=new Po(e,t);this._add("boxZoom",o);const r=new Ro,a=new er;e.doubleClickZoom=new tr(a,r),this._add("tapZoom",r),this._add("clickZoom",a);const n=new ir;this._add("tapDragZoom",n);const s=e.touchPitch=new $o;this._add("touchPitch",s);const l=new Oo(t),c=new Uo(t);e.dragRotate=new rr(t,l,c),this._add("mouseRotate",l,["mousePitch"]),this._add("mousePitch",c,["mouseRotate"]);const h=new Fo(t),u=new No(t);e.dragPan=new or(i,h,u),this._add("mousePan",h),this._add("touchPan",u,["touchZoom","touchRotate"]);const d=new jo,_=new qo;e.touchZoomRotate=new ar(i,_,d,n),this._add("touchRotate",d,["touchPan","touchZoom"]),this._add("touchZoom",_,["touchPan","touchRotate"]),this._add("blockableMapEvent",new zo(e));const m=e.scrollZoom=new Qo(e,this);this._add("scrollZoom",m,["mousePan"]);const p=e.keyboard=new Ko;this._add("keyboard",p);for(const i of ["boxZoom","doubleClickZoom","tapDragZoom","touchPitch","dragRotate","dragPan","touchZoomRotate","scrollZoom","keyboard"])t.interactive&&t[i]&&e[i].enable(t[i]);}_add(t,e,i){this._handlers.push({handlerName:t,handler:e,allowed:i}),this._handlersById[t]=e;}stop(t){if(!this._updatingCamera){for(const{handler:t}of this._handlers)t.reset();this._inertia.clear(),this._fireEvents({},{},t),this._changes=[];}}isActive(){for(const{handler:t}of this._handlers)if(t.isActive())return !0;return !1}isZooming(){return !!this._eventsInProgress.zoom||this._map.scrollZoom.isZooming()}isRotating(){return !!this._eventsInProgress.rotate}isMoving(){return Boolean(nr(this._eventsInProgress))||this.isZooming()}_blockedByActive(t,e,i){for(const o in t)if(o!==i&&(!e||e.indexOf(o)<0))return !0;return !1}handleWindowEvent(t){this.handleEvent(t,`${t.type}Window`);}_getMapTouches(t){const e=[];for(const i of t)this._el.contains(i.target)&&e.push(i);return e}handleEvent(t,e){if("blur"===t.type)return void this.stop(!0);this._updatingCamera=!0;const i="renderFrame"===t.type,o=i?void 0:t,r={needsRenderFrame:!1},n={},s={},l=t.touches?this._getMapTouches(t.touches):void 0,c=l?a.touchPos(this._el,l):i?void 0:a.mousePos(this._el,t);for(const{handlerName:i,handler:a,allowed:h}of this._handlers){if(!a.isEnabled())continue;let u;this._blockedByActive(s,h,i)?a.reset():a[e||t.type]&&(u=a[e||t.type](t,c,l),this.mergeHandlerResult(r,n,u,i,o),u&&u.needsRenderFrame&&this._triggerRenderFrame()),(u||a.isActive())&&(s[i]=a);}const h={};for(const t in this._previousActiveHandlers)s[t]||(h[t]=o);this._previousActiveHandlers=s,(Object.keys(h).length||cr(r))&&(this._changes.push([r,n,h]),this._triggerRenderFrame()),(Object.keys(s).length||cr(r))&&this._map._stop(!0),this._updatingCamera=!1;const{cameraAnimation:u}=r;u&&(this._inertia.clear(),this._fireEvents({},{},!0),this._changes=[],u(this._map));}mergeHandlerResult(e,i,o,r,a){if(!o)return;t.extend(e,o);const n={handlerName:r,originalEvent:o.originalEvent||a};void 0!==o.zoomDelta&&(i.zoom=n),void 0!==o.panDelta&&(i.drag=n),void 0!==o.pitchDelta&&(i.pitch=n),void 0!==o.bearingDelta&&(i.rotate=n);}_applyChanges(){const e={},i={},o={};for(const[r,a,n]of this._changes)r.panDelta&&(e.panDelta=(e.panDelta||new t.pointGeometry(0,0))._add(r.panDelta)),r.zoomDelta&&(e.zoomDelta=(e.zoomDelta||0)+r.zoomDelta),r.bearingDelta&&(e.bearingDelta=(e.bearingDelta||0)+r.bearingDelta),r.pitchDelta&&(e.pitchDelta=(e.pitchDelta||0)+r.pitchDelta),void 0!==r.around&&(e.around=r.around),void 0!==r.aroundCoord&&(e.aroundCoord=r.aroundCoord),void 0!==r.pinchAround&&(e.pinchAround=r.pinchAround),r.noInertia&&(e.noInertia=r.noInertia),t.extend(i,a),t.extend(o,n);this._updateMapTransform(e,i,o),this._changes=[];}_updateMapTransform(e,i,o){const r=this._map,a=r.transform,n=t=>[t.x,t.y,t.z];if((t=>{const e=this._eventsInProgress.drag;return e&&!this._handlersById[e.handlerName].isActive()})()&&!cr(e)){const t=a.zoom;a.cameraElevationReference="sea",a.recenterOnTerrain(),a.cameraElevationReference="ground",t!==a.zoom&&this._map._update(!0);}if(!cr(e))return this._fireEvents(i,o,!0);let{panDelta:s,zoomDelta:l,bearingDelta:c,pitchDelta:h,around:u,aroundCoord:d,pinchAround:_}=e;void 0!==_&&(u=_),(t=>i.drag&&!this._eventsInProgress.drag)()&&u&&(this._dragOrigin=n(a.pointCoordinate3D(u)),this._trackingEllipsoid.setup(a._camera.position,this._dragOrigin)),a.cameraElevationReference="sea",r._stop(!0),u=u||r.transform.centerPoint,c&&(a.bearing+=c),h&&(a.pitch+=h),a._updateCameraState();const m=[0,0,0];if(s){const t=a.screenPointToMercatorRay(u),e=a.screenPointToMercatorRay(u.sub(s)),i=this._trackingEllipsoid.projectRay(t.dir),o=this._trackingEllipsoid.projectRay(e.dir);m[0]=o[0]-i[0],m[1]=o[1]-i[1];}const p=a.zoom,f=[0,0,0];if(l){const e=n(d||a.pointCoordinate3D(u)),i={dir:t.normalize([],t.sub([],e,a._camera.position))},o=a.screenPointToMercatorRay(a.centerPoint);if(i.dir[2]<0){const r=t.altitudeFromMercatorZ(e[2],e[1]),s=a.rayIntersectionCoordinate(a.pointRayIntersection(a.centerPoint,r)),c=a.zoomDeltaToMovement(n(s),l)*(o.dir[2]/i.dir[2]);t.scale(f,i.dir,c);}else if(a._terrainEnabled()){const o=a.zoomDeltaToMovement(e,l);t.scale(f,i.dir,o);}}const g=t.add(m,m,f);a._translateCameraConstrained(g),l&&Math.abs(a.zoom-p)>1e-4&&a.recenterOnTerrain(),a.cameraElevationReference="ground",this._map._update(),e.noInertia||this._inertia.record(e),this._fireEvents(i,o,!0);}_fireEvents(e,i,o){const r=nr(this._eventsInProgress),a=nr(e),n={};for(const t in e){const{originalEvent:i}=e[t];this._eventsInProgress[t]||(n[`${t}start`]=i),this._eventsInProgress[t]=e[t];}!r&&a&&this._fireEvent("movestart",a.originalEvent);for(const t in n)this._fireEvent(t,n[t]);a&&this._fireEvent("move",a.originalEvent);for(const t in e){const{originalEvent:i}=e[t];this._fireEvent(t,i);}const s={};let l;for(const t in this._eventsInProgress){const{handlerName:e,originalEvent:o}=this._eventsInProgress[t];this._handlersById[e].isActive()||(delete this._eventsInProgress[t],l=i[e]||o,s[`${t}end`]=l);}for(const t in s)this._fireEvent(t,s[t]);const c=nr(this._eventsInProgress);if(o&&(r||a)&&!c){this._updatingCamera=!0;const e=this._inertia._onMoveEnd(this._map.dragPan._inertiaOptions),i=t=>0!==t&&-this._bearingSnap<t&&t<this._bearingSnap;e?(i(e.bearing||this._map.getBearing())&&(e.bearing=0),this._map.easeTo(e,{originalEvent:l})):(this._map.fire(new t.Event("moveend",{originalEvent:l})),i(this._map.getBearing())&&this._map.resetNorth()),this._updatingCamera=!1;}}_fireEvent(e,i){this._map.fire(new t.Event(e,i?{originalEvent:i}:{}));}_requestFrame(){return this._map.triggerRepaint(),this._map._renderTaskQueue.add((t=>{delete this._frameId,this.handleEvent(new sr("renderFrame",{timeStamp:t})),this._applyChanges();}))}_triggerRenderFrame(){void 0===this._frameId&&(this._frameId=this._requestFrame());}}class ur extends t.Evented{constructor(e,i){super(),this._moving=!1,this._zooming=!1,this.transform=e,this._bearingSnap=i.bearingSnap,t.bindAll(["_renderFrameCallback"],this);}getCenter(){return new t.LngLat(this.transform.center.lng,this.transform.center.lat)}setCenter(t,e){return this.jumpTo({center:t},e)}panBy(e,i,o){return e=t.pointGeometry.convert(e).mult(-1),this.panTo(this.transform.center,t.extend({offset:e},i),o)}panTo(e,i,o){return this.easeTo(t.extend({center:e},i),o)}getZoom(){return this.transform.zoom}setZoom(t,e){return this.jumpTo({zoom:t},e),this}zoomTo(e,i,o){return this.easeTo(t.extend({zoom:e},i),o)}zoomIn(t,e){return this.zoomTo(this.getZoom()+1,t,e),this}zoomOut(t,e){return this.zoomTo(this.getZoom()-1,t,e),this}getBearing(){return this.transform.bearing}setBearing(t,e){return this.jumpTo({bearing:t},e),this}getPadding(){return this.transform.padding}setPadding(t,e){return this.jumpTo({padding:t},e),this}rotateTo(e,i,o){return this.easeTo(t.extend({bearing:e},i),o)}resetNorth(e,i){return this.rotateTo(0,t.extend({duration:1e3},e),i),this}resetNorthPitch(e,i){return this.easeTo(t.extend({bearing:0,pitch:0,duration:1e3},e),i),this}snapToNorth(t,e){return Math.abs(this.getBearing())<this._bearingSnap?this.resetNorth(t,e):this}getPitch(){return this.transform.pitch}setPitch(t,e){return this.jumpTo({pitch:t},e),this}cameraForBounds(e,i){e=t.LngLatBounds.convert(e);const o=i&&i.bearing||0;return this._cameraForBoxAndBearing(e.getNorthWest(),e.getSouthEast(),o,i)}_extendCameraOptions(e){const i={top:0,bottom:0,right:0,left:0};if("number"==typeof(e=t.extend({padding:i,offset:[0,0],maxZoom:this.transform.maxZoom},e)).padding){const t=e.padding;e.padding={top:t,bottom:t,right:t,left:t};}return e.padding=t.extend(i,e.padding),e}_cameraForBoxAndBearing(e,i,o,r){const a=this._extendCameraOptions(r),n=this.transform,s=n.padding,l=n.project(t.LngLat.convert(e)),c=n.project(t.LngLat.convert(i)),h=l.rotate(-t.degToRad(o)),u=c.rotate(-t.degToRad(o)),d=new t.pointGeometry(Math.max(h.x,u.x),Math.max(h.y,u.y)),_=new t.pointGeometry(Math.min(h.x,u.x),Math.min(h.y,u.y)),m=d.sub(_),p=(n.width-(s.left+s.right+a.padding.left+a.padding.right))/m.x,f=(n.height-(s.top+s.bottom+a.padding.top+a.padding.bottom))/m.y;if(f<0||p<0)return void t.warnOnce("Map cannot fit within canvas with the given bounds, padding, and/or offset.");const g=Math.min(n.scaleZoom(n.scale*Math.min(p,f)),a.maxZoom),x="number"==typeof a.offset.x?new t.pointGeometry(a.offset.x,a.offset.y):t.pointGeometry.convert(a.offset),v=new t.pointGeometry((a.padding.left-a.padding.right)/2,(a.padding.top-a.padding.bottom)/2).rotate(o*Math.PI/180),y=x.add(v).mult(n.scale/n.zoomScale(g));return {center:n.unproject(l.add(c).div(2).sub(y)),zoom:g,bearing:o}}_cameraForBox(e,i,o,r,a){const n=this._extendCameraOptions(a);o=o||0,r=r||0,e=t.LngLat.convert(e),i=t.LngLat.convert(i);const s=this.transform.clone();s.padding=n.padding;const l=this.getFreeCameraOptions(),c=new t.LngLat(.5*(e.lng+i.lng),.5*(e.lat+i.lat)),h=.5*(o+r);if(s._camera.position[2]<t.mercatorZfromAltitude(h,c.lat))return void t.warnOnce("Map cannot fit within canvas with the given bounds, padding, and/or offset.");l.lookAtPoint(c),s.setFreeCameraOptions(l);const u=t.MercatorCoordinate.fromLngLat(e),d=t.MercatorCoordinate.fromLngLat(i),p=s.pointRayIntersection(s.centerPoint,h),f=[(g=s.rayIntersectionCoordinate(p)).x,g.y,g.z];var g;const x=s.screenPointToMercatorRay(s.centerPoint);let v,y=0;do{const e=Math.floor(s.zoom),i=1<<e,a=Math.min(i*u.x,i*d.x),n=Math.min(i*u.y,i*d.y),l=Math.max(i*u.x,i*d.x),c=Math.max(i*u.y,i*d.y),h=new m([a,n,o],[l,c,r]),p=_.fromInvProjectionMatrix(s.invProjMatrix,s.worldSize,e);if(2!==h.intersects(p)){v&&(s._camera.position=t.scaleAndAdd([],s._camera.position,x.dir,-v),s._updateStateFromCamera());break}const g=t.sub([],s._camera.position,f);v=.5*t.length(g),s._camera.position=t.scaleAndAdd([],s._camera.position,x.dir,v);try{s._updateStateFromCamera();}catch(e){return void t.warnOnce("Map cannot fit within canvas with the given bounds, padding, and/or offset.")}}while(++y<10);return {center:s.center,zoom:s.zoom,bearing:s.bearing,pitch:s.pitch}}fitBounds(t,e,i){return this._fitInternal(this.cameraForBounds(t,e),e,i)}_raycastElevationBox(e,i){const o=this.transform.elevation;if(!o)return;const r=new t.pointGeometry(e.x,i.y),a=new t.pointGeometry(i.x,e.y),n=o.pointCoordinate(e);if(!n)return;const s=o.pointCoordinate(i);if(!s)return;const l=o.pointCoordinate(r);if(!l)return;const c=o.pointCoordinate(a);if(!c)return;const h=new t.MercatorCoordinate(n[0],n[1]).toLngLat(),u=new t.MercatorCoordinate(s[0],s[1]).toLngLat(),d=new t.MercatorCoordinate(l[0],l[1]).toLngLat(),_=new t.MercatorCoordinate(c[0],c[1]).toLngLat(),m=Math.min(h.lng,Math.min(u.lng,Math.min(d.lng,_.lng))),p=Math.min(h.lat,Math.min(u.lat,Math.min(d.lat,_.lat))),f=Math.max(h.lng,Math.max(u.lng,Math.max(d.lng,_.lng))),g=Math.max(h.lat,Math.max(u.lat,Math.max(d.lat,_.lat))),x=Math.min(n[3],Math.min(s[3],Math.min(l[3],c[3]))),v=Math.max(n[3],Math.max(s[3],Math.max(l[3],c[3])));return {minLngLat:new t.LngLat(m,p),maxLngLat:new t.LngLat(f,g),minAltitude:x,maxAltitude:v}}fitScreenCoordinates(e,i,o,r,a){let n,s,l,c;const h=t.pointGeometry.convert(e),u=t.pointGeometry.convert(i),d=this._raycastElevationBox(h,u);if(d)n=d.minLngLat,s=d.maxLngLat,l=d.minAltitude,c=d.maxAltitude;else {if(this.transform.isHorizonVisibleForPoints(h,u))return this;n=this.transform.pointLocation(h),s=this.transform.pointLocation(u);}return this._fitInternal(0===this.transform.pitch?this._cameraForBoxAndBearing(this.transform.pointLocation(t.pointGeometry.convert(e)),this.transform.pointLocation(t.pointGeometry.convert(i)),o,r):this._cameraForBox(n,s,l,c,r),r,a)}_fitInternal(e,i,o){return e?(delete(i=t.extend(e,i)).padding,i.linear?this.easeTo(i,o):this.flyTo(i,o)):this}jumpTo(e,i){this.stop();const o=this.transform;let r=!1,a=!1,n=!1;return "zoom"in e&&o.zoom!==+e.zoom&&(r=!0,o.zoom=+e.zoom),void 0!==e.center&&(o.center=t.LngLat.convert(e.center)),"bearing"in e&&o.bearing!==+e.bearing&&(a=!0,o.bearing=+e.bearing),"pitch"in e&&o.pitch!==+e.pitch&&(n=!0,o.pitch=+e.pitch),null==e.padding||o.isPaddingEqual(e.padding)||(o.padding=e.padding),this.fire(new t.Event("movestart",i)).fire(new t.Event("move",i)),r&&this.fire(new t.Event("zoomstart",i)).fire(new t.Event("zoom",i)).fire(new t.Event("zoomend",i)),a&&this.fire(new t.Event("rotatestart",i)).fire(new t.Event("rotate",i)).fire(new t.Event("rotateend",i)),n&&this.fire(new t.Event("pitchstart",i)).fire(new t.Event("pitch",i)).fire(new t.Event("pitchend",i)),this.fire(new t.Event("moveend",i))}getFreeCameraOptions(){return this.transform.getFreeCameraOptions()}setFreeCameraOptions(e,i){this.stop();const o=this.transform,r=o.zoom,a=o.pitch,n=o.bearing;o.setFreeCameraOptions(e);const s=r!==o.zoom,l=a!==o.pitch,c=n!==o.bearing;return this.fire(new t.Event("movestart",i)).fire(new t.Event("move",i)),s&&this.fire(new t.Event("zoomstart",i)).fire(new t.Event("zoom",i)).fire(new t.Event("zoomend",i)),c&&this.fire(new t.Event("rotatestart",i)).fire(new t.Event("rotate",i)).fire(new t.Event("rotateend",i)),l&&this.fire(new t.Event("pitchstart",i)).fire(new t.Event("pitch",i)).fire(new t.Event("pitchend",i)),this.fire(new t.Event("moveend",i)),this}easeTo(e,i){this._stop(!1,e.easeId),(!1===(e=t.extend({offset:[0,0],duration:500,easing:t.ease},e)).animate||!e.essential&&t.exported.prefersReducedMotion)&&(e.duration=0);const o=this.transform,r=this.getZoom(),a=this.getBearing(),n=this.getPitch(),s=this.getPadding(),l="zoom"in e?+e.zoom:r,c="bearing"in e?this._normalizeBearing(e.bearing,a):a,h="pitch"in e?+e.pitch:n,u="padding"in e?e.padding:o.padding,d=t.pointGeometry.convert(e.offset);let _=o.centerPoint.add(d);const m=o.pointLocation(_),p=t.LngLat.convert(e.center||m);this._normalizeCenter(p);const f=o.project(m),g=o.project(p).sub(f),x=o.zoomScale(l-r);let v,y;e.around&&(v=t.LngLat.convert(e.around),y=o.locationPoint(v));const b={moving:this._moving,zooming:this._zooming,rotating:this._rotating,pitching:this._pitching};return this._zooming=this._zooming||l!==r,this._rotating=this._rotating||a!==c,this._pitching=this._pitching||h!==n,this._padding=!o.isPaddingEqual(u),this._easeId=e.easeId,this._prepareEase(i,e.noMoveStart,b),this._ease((e=>{if(this._zooming&&(o.zoom=t.number(r,l,e)),this._rotating&&(o.bearing=t.number(a,c,e)),this._pitching&&(o.pitch=t.number(n,h,e)),this._padding&&(o.interpolatePadding(s,u,e),_=o.centerPoint.add(d)),v)o.setLocationAtPoint(v,y);else {const t=o.zoomScale(o.zoom-r),i=l>r?Math.min(2,x):Math.max(.5,x),a=Math.pow(i,1-e),n=o.unproject(f.add(g.mult(e*a)).mult(t));o.setLocationAtPoint(o.renderWorldCopies?n.wrap():n,_);}this._fireMoveEvents(i);}),(t=>{o.recenterOnTerrain(),this._afterEase(i,t);}),e),this}_prepareEase(e,i,o={}){this._moving=!0,this.transform.cameraElevationReference="sea",i||o.moving||this.fire(new t.Event("movestart",e)),this._zooming&&!o.zooming&&this.fire(new t.Event("zoomstart",e)),this._rotating&&!o.rotating&&this.fire(new t.Event("rotatestart",e)),this._pitching&&!o.pitching&&this.fire(new t.Event("pitchstart",e));}_fireMoveEvents(e){this.fire(new t.Event("move",e)),this._zooming&&this.fire(new t.Event("zoom",e)),this._rotating&&this.fire(new t.Event("rotate",e)),this._pitching&&this.fire(new t.Event("pitch",e));}_afterEase(e,i){if(this._easeId&&i&&this._easeId===i)return;delete this._easeId,this.transform.cameraElevationReference="ground";const o=this._zooming,r=this._rotating,a=this._pitching;this._moving=!1,this._zooming=!1,this._rotating=!1,this._pitching=!1,this._padding=!1,o&&this.fire(new t.Event("zoomend",e)),r&&this.fire(new t.Event("rotateend",e)),a&&this.fire(new t.Event("pitchend",e)),this.fire(new t.Event("moveend",e));}flyTo(e,i){if(!e.essential&&t.exported.prefersReducedMotion){const o=t.pick(e,["center","zoom","bearing","pitch","around"]);return this.jumpTo(o,i)}this.stop(),e=t.extend({offset:[0,0],speed:1.2,curve:1.42,easing:t.ease},e);const o=this.transform,r=this.getZoom(),a=this.getBearing(),n=this.getPitch(),s=this.getPadding(),l="zoom"in e?t.clamp(+e.zoom,o.minZoom,o.maxZoom):r,c="bearing"in e?this._normalizeBearing(e.bearing,a):a,h="pitch"in e?+e.pitch:n,u="padding"in e?e.padding:o.padding,d=o.zoomScale(l-r),_=t.pointGeometry.convert(e.offset);let m=o.centerPoint.add(_);const p=o.pointLocation(m),f=t.LngLat.convert(e.center||p);this._normalizeCenter(f);const g=o.project(p),x=o.project(f).sub(g);let v=e.curve;const y=Math.max(o.width,o.height),b=y/d,w=x.mag();if("minZoom"in e){const i=t.clamp(Math.min(e.minZoom,r,l),o.minZoom,o.maxZoom),a=y/o.zoomScale(i-r);v=Math.sqrt(a/w*2);}const T=v*v;function E(t){const e=(b*b-y*y+(t?-1:1)*T*T*w*w)/(2*(t?b:y)*T*w);return Math.log(Math.sqrt(e*e+1)-e)}function C(t){return (Math.exp(t)-Math.exp(-t))/2}function S(t){return (Math.exp(t)+Math.exp(-t))/2}const I=E(0);let M=function(t){return S(I)/S(I+v*t)},z=function(t){return y*((S(I)*(C(e=I+v*t)/S(e))-C(I))/T)/w;var e;},P=(E(1)-I)/v;if(Math.abs(w)<1e-6||!isFinite(P)){if(Math.abs(y-b)<1e-6)return this.easeTo(e,i);const t=b<y?-1:1;P=Math.abs(Math.log(b/y))/v,z=function(){return 0},M=function(e){return Math.exp(t*v*e)};}return e.duration="duration"in e?+e.duration:1e3*P/("screenSpeed"in e?+e.screenSpeed/v:+e.speed),e.maxDuration&&e.duration>e.maxDuration&&(e.duration=0),this._zooming=!0,this._rotating=a!==c,this._pitching=h!==n,this._padding=!o.isPaddingEqual(u),this._prepareEase(i,!1),this._ease((e=>{const d=e*P,p=1/M(d);o.zoom=1===e?l:r+o.scaleZoom(p),this._rotating&&(o.bearing=t.number(a,c,e)),this._pitching&&(o.pitch=t.number(n,h,e)),this._padding&&(o.interpolatePadding(s,u,e),m=o.centerPoint.add(_));const v=1===e?f:o.unproject(g.add(x.mult(z(d))).mult(p));o.setLocationAtPoint(o.renderWorldCopies?v.wrap():v,m),o._updateCenterElevation(),this._fireMoveEvents(i);}),(()=>this._afterEase(i)),e),this}isEasing(){return !!this._easeFrameId}stop(){return this._stop()}_stop(t,e){if(this._easeFrameId&&(this._cancelRenderFrame(this._easeFrameId),delete this._easeFrameId,delete this._onEaseFrame),this._onEaseEnd){const t=this._onEaseEnd;delete this._onEaseEnd,t.call(this,e);}if(!t){const t=this.handlers;t&&t.stop(!1);}return this}_ease(e,i,o){!1===o.animate||0===o.duration?(e(1),i()):(this._easeStart=t.exported.now(),this._easeOptions=o,this._onEaseFrame=e,this._onEaseEnd=i,this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback));}_renderFrameCallback(){const e=Math.min((t.exported.now()-this._easeStart)/this._easeOptions.duration,1);this._onEaseFrame(this._easeOptions.easing(e)),e<1?this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback):this.stop();}_normalizeBearing(e,i){e=t.wrap(e,-180,180);const o=Math.abs(e-i);return Math.abs(e-360-i)<o&&(e-=360),Math.abs(e+360-i)<o&&(e+=360),e}_normalizeCenter(t){const e=this.transform;if(!e.renderWorldCopies||e.lngRange)return;const i=t.lng-e.center.lng;t.lng+=i>180?-360:i<-180?360:0;}}class dr{constructor(e={}){this.options=e,t.bindAll(["_toggleAttribution","_updateEditLink","_updateData","_updateCompact"],this);}getDefaultPosition(){return "bottom-right"}onAdd(t){const e=this.options&&this.options.compact;return this._map=t,this._container=a.create("div","mapboxgl-ctrl mapboxgl-ctrl-attrib"),this._compactButton=a.create("button","mapboxgl-ctrl-attrib-button",this._container),this._compactButton.addEventListener("click",this._toggleAttribution),this._setElementTitle(this._compactButton,"ToggleAttribution"),this._innerContainer=a.create("div","mapboxgl-ctrl-attrib-inner",this._container),this._innerContainer.setAttribute("role","list"),e&&this._container.classList.add("mapboxgl-compact"),this._updateAttributions(),this._updateEditLink(),this._map.on("styledata",this._updateData),this._map.on("sourcedata",this._updateData),this._map.on("moveend",this._updateEditLink),void 0===e&&(this._map.on("resize",this._updateCompact),this._updateCompact()),this._container}onRemove(){a.remove(this._container),this._map.off("styledata",this._updateData),this._map.off("sourcedata",this._updateData),this._map.off("moveend",this._updateEditLink),this._map.off("resize",this._updateCompact),this._map=void 0,this._attribHTML=void 0;}_setElementTitle(t,e){const i=this._map._getUIString(`AttributionControl.${e}`);t.title=i,t.setAttribute("aria-label",i);}_toggleAttribution(){this._container.classList.contains("mapboxgl-compact-show")?(this._container.classList.remove("mapboxgl-compact-show"),this._compactButton.setAttribute("aria-pressed","false")):(this._container.classList.add("mapboxgl-compact-show"),this._compactButton.setAttribute("aria-pressed","true"));}_updateEditLink(){let e=this._editLink;e||(e=this._editLink=this._container.querySelector(".mapbox-improve-map"));const i=[{key:"owner",value:this.styleOwner},{key:"id",value:this.styleId},{key:"access_token",value:this._map._requestManager._customAccessToken||t.config.ACCESS_TOKEN}];if(e){const o=i.reduce(((t,e,o)=>(e.value&&(t+=`${e.key}=${e.value}${o<i.length-1?"&":""}`),t)),"?");e.href=`${t.config.FEEDBACK_URL}/${o}${this._map._hash?this._map._hash.getHashString(!0):""}`,e.rel="noopener nofollow",this._setElementTitle(e,"MapFeedback");}}_updateData(t){!t||"metadata"!==t.sourceDataType&&"visibility"!==t.sourceDataType&&"style"!==t.dataType||(this._updateAttributions(),this._updateEditLink());}_updateAttributions(){if(!this._map.style)return;let t=[];if(this.options.customAttribution&&(Array.isArray(this.options.customAttribution)?t=t.concat(this.options.customAttribution.map((t=>"string"!=typeof t?"":t))):"string"==typeof this.options.customAttribution&&t.push(this.options.customAttribution)),this._map.style.stylesheet){const t=this._map.style.stylesheet;this.styleOwner=t.owner,this.styleId=t.id;}const e=this._map.style._sourceCaches;for(const i in e){const o=e[i];if(o.used){const e=o.getSource();e.attribution&&t.indexOf(e.attribution)<0&&t.push(e.attribution);}}t.sort(((t,e)=>t.length-e.length)),t=t.filter(((e,i)=>{for(let o=i+1;o<t.length;o++)if(t[o].indexOf(e)>=0)return !1;return !0}));const i=t.join(" | ");i!==this._attribHTML&&(this._attribHTML=i,t.length?(this._innerContainer.innerHTML=i,this._container.classList.remove("mapboxgl-attrib-empty")):this._container.classList.add("mapboxgl-attrib-empty"),this._editLink=null);}_updateCompact(){this._map.getCanvasContainer().offsetWidth<=640?this._container.classList.add("mapboxgl-compact"):this._container.classList.remove("mapboxgl-compact","mapboxgl-compact-show");}}class _r{constructor(){t.bindAll(["_updateLogo"],this),t.bindAll(["_updateCompact"],this);}onAdd(t){this._map=t,this._container=a.create("div","mapboxgl-ctrl");const e=a.create("a","mapboxgl-ctrl-logo");return e.target="_blank",e.rel="noopener nofollow",e.href="https://www.mapbox.com/",e.setAttribute("aria-label",this._map._getUIString("LogoControl.Title")),e.setAttribute("rel","noopener nofollow"),this._container.appendChild(e),this._container.style.display="none",this._map.on("sourcedata",this._updateLogo),this._updateLogo(),this._map.on("resize",this._updateCompact),this._updateCompact(),this._container}onRemove(){a.remove(this._container),this._map.off("sourcedata",this._updateLogo),this._map.off("resize",this._updateCompact);}getDefaultPosition(){return "bottom-left"}_updateLogo(t){t&&"metadata"!==t.sourceDataType||(this._container.style.display=this._logoRequired()?"block":"none");}_logoRequired(){if(!this._map.style)return !0;const t=this._map.style._sourceCaches;if(0===Object.entries(t).length)return !0;for(const e in t){const i=t[e].getSource();if(i.hasOwnProperty("mapbox_logo")&&!i.mapbox_logo)return !1}return !0}_updateCompact(){const t=this._container.children;if(t.length){const e=t[0];this._map.getCanvasContainer().offsetWidth<250?e.classList.add("mapboxgl-compact"):e.classList.remove("mapboxgl-compact");}}}class mr{constructor(){this._queue=[],this._id=0,this._cleared=!1,this._currentlyRunning=!1;}add(t){const e=++this._id;return this._queue.push({callback:t,id:e,cancelled:!1}),e}remove(t){const e=this._currentlyRunning,i=e?this._queue.concat(e):this._queue;for(const e of i)if(e.id===t)return void(e.cancelled=!0)}run(t=0){const e=this._currentlyRunning=this._queue;this._queue=[];for(const i of e)if(!i.cancelled&&(i.callback(t),this._cleared))break;this._cleared=!1,this._currentlyRunning=!1;}clear(){this._currentlyRunning&&(this._cleared=!0),this._queue=[];}}const pr={"AttributionControl.ToggleAttribution":"Toggle attribution","AttributionControl.MapFeedback":"Map feedback","FullscreenControl.Enter":"Enter fullscreen","FullscreenControl.Exit":"Exit fullscreen","GeolocateControl.FindMyLocation":"Find my location","GeolocateControl.LocationNotAvailable":"Location not available","LogoControl.Title":"Mapbox logo","NavigationControl.ResetBearing":"Reset bearing to north","NavigationControl.ZoomIn":"Zoom in","NavigationControl.ZoomOut":"Zoom out","ScaleControl.Feet":"ft","ScaleControl.Meters":"m","ScaleControl.Kilometers":"km","ScaleControl.Miles":"mi","ScaleControl.NauticalMiles":"nm"},{HTMLImageElement:fr,HTMLElement:gr,ImageBitmap:xr}=t.window,vr={center:[0,0],zoom:0,bearing:0,pitch:0,minZoom:-2,maxZoom:22,minPitch:0,maxPitch:85,interactive:!0,scrollZoom:!0,boxZoom:!0,dragRotate:!0,dragPan:!0,keyboard:!0,doubleClickZoom:!0,touchZoomRotate:!0,touchPitch:!0,bearingSnap:7,clickTolerance:3,pitchWithRotate:!0,hash:!1,attributionControl:!0,failIfMajorPerformanceCaveat:!1,preserveDrawingBuffer:!1,trackResize:!0,optimizeForTerrain:!0,renderWorldCopies:!0,refreshExpiredTiles:!0,maxTileCacheSize:null,localIdeographFontFamily:"sans-serif",localFontFamily:null,transformRequest:null,accessToken:null,fadeDuration:300,crossSourceCollisions:!0};function yr(t){t.parentNode&&t.parentNode.removeChild(t);}const br={showCompass:!0,showZoom:!0,visualizePitch:!1};class wr{constructor(e,i,o=!1){this._clickTolerance=10,this.element=i,this.mouseRotate=new Oo({clickTolerance:e.dragRotate._mouseRotate._clickTolerance}),this.map=e,o&&(this.mousePitch=new Uo({clickTolerance:e.dragRotate._mousePitch._clickTolerance})),t.bindAll(["mousedown","mousemove","mouseup","touchstart","touchmove","touchend","reset"],this),a.addEventListener(i,"mousedown",this.mousedown),a.addEventListener(i,"touchstart",this.touchstart,{passive:!1}),a.addEventListener(i,"touchmove",this.touchmove),a.addEventListener(i,"touchend",this.touchend),a.addEventListener(i,"touchcancel",this.reset);}down(t,e){this.mouseRotate.mousedown(t,e),this.mousePitch&&this.mousePitch.mousedown(t,e),a.disableDrag();}move(t,e){const i=this.map,o=this.mouseRotate.mousemoveWindow(t,e);if(o&&o.bearingDelta&&i.setBearing(i.getBearing()+o.bearingDelta),this.mousePitch){const o=this.mousePitch.mousemoveWindow(t,e);o&&o.pitchDelta&&i.setPitch(i.getPitch()+o.pitchDelta);}}off(){const t=this.element;a.removeEventListener(t,"mousedown",this.mousedown),a.removeEventListener(t,"touchstart",this.touchstart,{passive:!1}),a.removeEventListener(t,"touchmove",this.touchmove),a.removeEventListener(t,"touchend",this.touchend),a.removeEventListener(t,"touchcancel",this.reset),this.offTemp();}offTemp(){a.enableDrag(),a.removeEventListener(t.window,"mousemove",this.mousemove),a.removeEventListener(t.window,"mouseup",this.mouseup);}mousedown(e){this.down(t.extend({},e,{ctrlKey:!0,preventDefault:()=>e.preventDefault()}),a.mousePos(this.element,e)),a.addEventListener(t.window,"mousemove",this.mousemove),a.addEventListener(t.window,"mouseup",this.mouseup);}mousemove(t){this.move(t,a.mousePos(this.element,t));}mouseup(t){this.mouseRotate.mouseupWindow(t),this.mousePitch&&this.mousePitch.mouseupWindow(t),this.offTemp();}touchstart(t){1!==t.targetTouches.length?this.reset():(this._startPos=this._lastPos=a.touchPos(this.element,t.targetTouches)[0],this.down({type:"mousedown",button:0,ctrlKey:!0,preventDefault:()=>t.preventDefault()},this._startPos));}touchmove(t){1!==t.targetTouches.length?this.reset():(this._lastPos=a.touchPos(this.element,t.targetTouches)[0],this.move({preventDefault:()=>t.preventDefault()},this._lastPos));}touchend(t){0===t.targetTouches.length&&this._startPos&&this._lastPos&&this._startPos.dist(this._lastPos)<this._clickTolerance&&this.element.click(),this.reset();}reset(){this.mouseRotate.reset(),this.mousePitch&&this.mousePitch.reset(),delete this._startPos,delete this._lastPos,this.offTemp();}}function Tr(e,i,o){if(e=new t.LngLat(e.lng,e.lat),i){const r=new t.LngLat(e.lng-360,e.lat),a=new t.LngLat(e.lng+360,e.lat),n=360*Math.ceil(Math.abs(e.lng-o.center.lng)/360),s=o.locationPoint(e).distSqr(i),l=i.x<0||i.y<0||i.x>o.width||i.y>o.height;o.locationPoint(r).distSqr(i)<s&&(l||Math.abs(r.lng-o.center.lng)<n)?e=r:o.locationPoint(a).distSqr(i)<s&&(l||Math.abs(a.lng-o.center.lng)<n)&&(e=a);}for(;Math.abs(e.lng-o.center.lng)>180;){const t=o.locationPoint(e);if(t.x>=0&&t.y>=0&&t.x<=o.width&&t.y<=o.height)break;e.lng>o.center.lng?e.lng-=360:e.lng+=360;}return e}const Er={center:"translate(-50%,-50%)",top:"translate(-50%,0)","top-left":"translate(0,0)","top-right":"translate(-100%,0)",bottom:"translate(-50%,-100%)","bottom-left":"translate(0,-100%)","bottom-right":"translate(-100%,-100%)",left:"translate(0,-50%)",right:"translate(-100%,-50%)"};function Cr(t,e,i){const o=t.classList;for(const t in Er)o.remove(`mapboxgl-${i}-anchor-${t}`);o.add(`mapboxgl-${i}-anchor-${e}`);}class Sr extends t.Evented{constructor(e,i){if(super(),(e instanceof t.window.HTMLElement||i)&&(e=t.extend({element:e},i)),t.bindAll(["_update","_onMove","_onUp","_addDragHandler","_onMapClick","_onKeyPress"],this),this._anchor=e&&e.anchor||"center",this._color=e&&e.color||"#3FB1CE",this._scale=e&&e.scale||1,this._draggable=e&&e.draggable||!1,this._clickTolerance=e&&e.clickTolerance||0,this._isDragging=!1,this._state="inactive",this._rotation=e&&e.rotation||0,this._rotationAlignment=e&&e.rotationAlignment||"auto",this._pitchAlignment=e&&e.pitchAlignment&&"auto"!==e.pitchAlignment?e.pitchAlignment:this._rotationAlignment,e&&e.element)this._element=e.element,this._offset=t.pointGeometry.convert(e&&e.offset||[0,0]);else {this._defaultMarker=!0,this._element=a.create("div"),this._element.setAttribute("aria-label","Map marker");const i=a.createNS("http://www.w3.org/2000/svg","svg"),o=41,r=27;i.setAttributeNS(null,"display","block"),i.setAttributeNS(null,"height",`${o}px`),i.setAttributeNS(null,"width",`${r}px`),i.setAttributeNS(null,"viewBox",`0 0 ${r} ${o}`);const n=a.createNS("http://www.w3.org/2000/svg","g");n.setAttributeNS(null,"stroke","none"),n.setAttributeNS(null,"stroke-width","1"),n.setAttributeNS(null,"fill","none"),n.setAttributeNS(null,"fill-rule","evenodd");const s=a.createNS("http://www.w3.org/2000/svg","g");s.setAttributeNS(null,"fill-rule","nonzero");const l=a.createNS("http://www.w3.org/2000/svg","g");l.setAttributeNS(null,"transform","translate(3.0, 29.0)"),l.setAttributeNS(null,"fill","#000000");const c=[{rx:"10.5",ry:"5.25002273"},{rx:"10.5",ry:"5.25002273"},{rx:"9.5",ry:"4.77275007"},{rx:"8.5",ry:"4.29549936"},{rx:"7.5",ry:"3.81822308"},{rx:"6.5",ry:"3.34094679"},{rx:"5.5",ry:"2.86367051"},{rx:"4.5",ry:"2.38636864"}];for(const t of c){const e=a.createNS("http://www.w3.org/2000/svg","ellipse");e.setAttributeNS(null,"opacity","0.04"),e.setAttributeNS(null,"cx","10.5"),e.setAttributeNS(null,"cy","5.80029008"),e.setAttributeNS(null,"rx",t.rx),e.setAttributeNS(null,"ry",t.ry),l.appendChild(e);}const h=a.createNS("http://www.w3.org/2000/svg","g");h.setAttributeNS(null,"fill",this._color);const u=a.createNS("http://www.w3.org/2000/svg","path");u.setAttributeNS(null,"d","M27,13.5 C27,19.074644 20.250001,27.000002 14.75,34.500002 C14.016665,35.500004 12.983335,35.500004 12.25,34.500002 C6.7499993,27.000002 0,19.222562 0,13.5 C0,6.0441559 6.0441559,0 13.5,0 C20.955844,0 27,6.0441559 27,13.5 Z"),h.appendChild(u);const d=a.createNS("http://www.w3.org/2000/svg","g");d.setAttributeNS(null,"opacity","0.25"),d.setAttributeNS(null,"fill","#000000");const _=a.createNS("http://www.w3.org/2000/svg","path");_.setAttributeNS(null,"d","M13.5,0 C6.0441559,0 0,6.0441559 0,13.5 C0,19.222562 6.7499993,27 12.25,34.5 C13,35.522727 14.016664,35.500004 14.75,34.5 C20.250001,27 27,19.074644 27,13.5 C27,6.0441559 20.955844,0 13.5,0 Z M13.5,1 C20.415404,1 26,6.584596 26,13.5 C26,15.898657 24.495584,19.181431 22.220703,22.738281 C19.945823,26.295132 16.705119,30.142167 13.943359,33.908203 C13.743445,34.180814 13.612715,34.322738 13.5,34.441406 C13.387285,34.322738 13.256555,34.180814 13.056641,33.908203 C10.284481,30.127985 7.4148684,26.314159 5.015625,22.773438 C2.6163816,19.232715 1,15.953538 1,13.5 C1,6.584596 6.584596,1 13.5,1 Z"),d.appendChild(_);const m=a.createNS("http://www.w3.org/2000/svg","g");m.setAttributeNS(null,"transform","translate(6.0, 7.0)"),m.setAttributeNS(null,"fill","#FFFFFF");const p=a.createNS("http://www.w3.org/2000/svg","g");p.setAttributeNS(null,"transform","translate(8.0, 8.0)");const f=a.createNS("http://www.w3.org/2000/svg","circle");f.setAttributeNS(null,"fill","#000000"),f.setAttributeNS(null,"opacity","0.25"),f.setAttributeNS(null,"cx","5.5"),f.setAttributeNS(null,"cy","5.5"),f.setAttributeNS(null,"r","5.4999962");const g=a.createNS("http://www.w3.org/2000/svg","circle");g.setAttributeNS(null,"fill","#FFFFFF"),g.setAttributeNS(null,"cx","5.5"),g.setAttributeNS(null,"cy","5.5"),g.setAttributeNS(null,"r","5.4999962"),p.appendChild(f),p.appendChild(g),s.appendChild(l),s.appendChild(h),s.appendChild(d),s.appendChild(m),s.appendChild(p),i.appendChild(s),i.setAttributeNS(null,"height",o*this._scale+"px"),i.setAttributeNS(null,"width",r*this._scale+"px"),this._element.appendChild(i),this._offset=t.pointGeometry.convert(e&&e.offset||[0,-14]);}this._element.classList.add("mapboxgl-marker"),this._element.addEventListener("dragstart",(t=>{t.preventDefault();})),this._element.addEventListener("mousedown",(t=>{t.preventDefault();})),Cr(this._element,this._anchor,"marker"),this._popup=null;}addTo(t){return this.remove(),this._map=t,t.getCanvasContainer().appendChild(this._element),t.on("move",this._update),t.on("moveend",this._update),this.setDraggable(this._draggable),this._update(),this._map.on("click",this._onMapClick),this}remove(){return this._map&&(this._map.off("click",this._onMapClick),this._map.off("move",this._update),this._map.off("moveend",this._update),this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler),this._map.off("mouseup",this._onUp),this._map.off("touchend",this._onUp),this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),delete this._map),a.remove(this._element),this._popup&&this._popup.remove(),this}getLngLat(){return this._lngLat}setLngLat(e){return this._lngLat=t.LngLat.convert(e),this._pos=null,this._popup&&this._popup.setLngLat(this._lngLat),this._update(),this}getElement(){return this._element}setPopup(t){if(this._popup&&(this._popup.remove(),this._popup=null,this._element.removeEventListener("keypress",this._onKeyPress),this._originalTabIndex||this._element.removeAttribute("tabindex")),t){if(!("offset"in t.options)){const e=38.1,i=13.5,o=Math.sqrt(Math.pow(i,2)/2);t.options.offset=this._defaultMarker?{top:[0,0],"top-left":[0,0],"top-right":[0,0],bottom:[0,-e],"bottom-left":[o,-1*(e-i+o)],"bottom-right":[-o,-1*(e-i+o)],left:[i,-1*(e-i)],right:[-i,-1*(e-i)]}:this._offset;}this._popup=t,this._lngLat&&this._popup.setLngLat(this._lngLat),this._originalTabIndex=this._element.getAttribute("tabindex"),this._originalTabIndex||this._element.setAttribute("tabindex","0"),this._element.addEventListener("keypress",this._onKeyPress);}return this}_onKeyPress(t){const e=t.code,i=t.charCode||t.keyCode;"Space"!==e&&"Enter"!==e&&32!==i&&13!==i||this.togglePopup();}_onMapClick(t){const e=t.originalEvent.target,i=this._element;this._popup&&(e===i||i.contains(e))&&this.togglePopup();}getPopup(){return this._popup}togglePopup(){const t=this._popup;return t?(t.isOpen()?t.remove():t.addTo(this._map),this):this}_updateOcclusion(){this._occlusionTimer||(this._occlusionTimer=setTimeout(this._onOcclusionTimer.bind(this),60));}_onOcclusionTimer(){const t=this._map.transform,e=this._pos?this._pos.sub(this._transformedOffset()):null;if(e&&e.x>=0&&e.x<t.width&&e.y>=0&&e.y<t.height){const t=this._map.unproject(e),i=this._map.getFreeCameraOptions();if(i.position){const e=i.position.toLngLat(),o=e.distanceTo(t),r=e.distanceTo(this._lngLat);this._element.classList.toggle("mapboxgl-marker-occluded",o<.9*r);}}this._occlusionTimer=null;}_update(t){if(!this._map)return;this._map.transform.renderWorldCopies&&(this._lngLat=Tr(this._lngLat,this._pos,this._map.transform)),this._pos=this._map.project(this._lngLat)._add(this._transformedOffset()),this._map.transform.elevation&&this._updateOcclusion();let e="";"viewport"===this._rotationAlignment||"auto"===this._rotationAlignment?e=`rotateZ(${this._rotation}deg)`:"map"===this._rotationAlignment&&(e=`rotateZ(${this._rotation-this._map.getBearing()}deg)`);let i="";"viewport"===this._pitchAlignment||"auto"===this._pitchAlignment?i="rotateX(0deg)":"map"===this._pitchAlignment&&(i=`rotateX(${this._map.getPitch()}deg)`),t&&"moveend"!==t.type||(this._pos=this._pos.round()),a.setTransform(this._element,`${Er[this._anchor]} translate(${this._pos.x}px, ${this._pos.y}px) ${i} ${e}`);}_transformedOffset(){if(!this._defaultMarker)return this._offset;const t=this._map.transform,e=this._offset.mult(this._scale);return "map"===this._rotationAlignment&&e._rotate(t.angle),"map"===this._pitchAlignment&&(e.y*=Math.cos(t._pitch)),e}getOffset(){return this._offset}setOffset(e){return this._offset=t.pointGeometry.convert(e),this._update(),this}_onMove(e){if(!this._isDragging){const t=this._clickTolerance||this._map._clickTolerance;this._isDragging=e.point.dist(this._pointerdownPos)>=t;}this._isDragging&&(this._pos=e.point.sub(this._positionDelta),this._lngLat=this._map.unproject(this._pos),this.setLngLat(this._lngLat),this._element.style.pointerEvents="none","pending"===this._state&&(this._state="active",this.fire(new t.Event("dragstart"))),this.fire(new t.Event("drag")));}_onUp(){this._element.style.pointerEvents="auto",this._positionDelta=null,this._pointerdownPos=null,this._isDragging=!1,this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),"active"===this._state&&this.fire(new t.Event("dragend")),this._state="inactive";}_addDragHandler(t){this._element.contains(t.originalEvent.target)&&(t.preventDefault(),this._positionDelta=t.point.sub(this._pos).add(this._transformedOffset()),this._pointerdownPos=t.point,this._state="pending",this._map.on("mousemove",this._onMove),this._map.on("touchmove",this._onMove),this._map.once("mouseup",this._onUp),this._map.once("touchend",this._onUp));}setDraggable(t){return this._draggable=!!t,this._map&&(t?(this._map.on("mousedown",this._addDragHandler),this._map.on("touchstart",this._addDragHandler)):(this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler))),this}isDraggable(){return this._draggable}setRotation(t){return this._rotation=t||0,this._update(),this}getRotation(){return this._rotation}setRotationAlignment(t){return this._rotationAlignment=t||"auto",this._update(),this}getRotationAlignment(){return this._rotationAlignment}setPitchAlignment(t){return this._pitchAlignment=t&&"auto"!==t?t:this._rotationAlignment,this._update(),this}getPitchAlignment(){return this._pitchAlignment}}const Ir={positionOptions:{enableHighAccuracy:!1,maximumAge:0,timeout:6e3},fitBoundsOptions:{maxZoom:15},trackUserLocation:!1,showAccuracyCircle:!0,showUserLocation:!0};let Mr,zr=0,Pr=!1;const Ar={maxWidth:100,unit:"metric"};function Dr(t,e,i){const o=i&&i.maxWidth||100,r=t._container.clientHeight/2,a=t.unproject([0,r]),n=t.unproject([o,r]),s=a.distanceTo(n);if(i&&"imperial"===i.unit){const i=3.2808*s;i>5280?Lr(e,o,i/5280,t._getUIString("ScaleControl.Miles")):Lr(e,o,i,t._getUIString("ScaleControl.Feet"));}else i&&"nautical"===i.unit?Lr(e,o,s/1852,t._getUIString("ScaleControl.NauticalMiles")):s>=1e3?Lr(e,o,s/1e3,t._getUIString("ScaleControl.Kilometers")):Lr(e,o,s,t._getUIString("ScaleControl.Meters"));}function Lr(t,e,i,o){const r=function(t){const e=Math.pow(10,`${Math.floor(t)}`.length-1);let i=t/e;return i=i>=10?10:i>=5?5:i>=3?3:i>=2?2:i>=1?1:function(t){const e=Math.pow(10,Math.ceil(-Math.log(t)/Math.LN10));return Math.round(t*e)/e}(i),e*i}(i);t.style.width=e*(r/i)+"px",t.innerHTML=`${r}&nbsp;${o}`;}const Rr={closeButton:!0,closeOnClick:!0,focusAfterOpen:!0,className:"",maxWidth:"240px"},kr=["a[href]","[tabindex]:not([tabindex='-1'])","[contenteditable]:not([contenteditable='false'])","button:not([disabled])","input:not([disabled])","select:not([disabled])","textarea:not([disabled])"].join(", ");function Br(e){if(e){if("number"==typeof e){const i=Math.round(Math.sqrt(.5*Math.pow(e,2)));return {center:new t.pointGeometry(0,0),top:new t.pointGeometry(0,e),"top-left":new t.pointGeometry(i,i),"top-right":new t.pointGeometry(-i,i),bottom:new t.pointGeometry(0,-e),"bottom-left":new t.pointGeometry(i,-i),"bottom-right":new t.pointGeometry(-i,-i),left:new t.pointGeometry(e,0),right:new t.pointGeometry(-e,0)}}if(e instanceof t.pointGeometry||Array.isArray(e)){const i=t.pointGeometry.convert(e);return {center:i,top:i,"top-left":i,"top-right":i,bottom:i,"bottom-left":i,"bottom-right":i,left:i,right:i}}return {center:t.pointGeometry.convert(e.center||[0,0]),top:t.pointGeometry.convert(e.top||[0,0]),"top-left":t.pointGeometry.convert(e["top-left"]||[0,0]),"top-right":t.pointGeometry.convert(e["top-right"]||[0,0]),bottom:t.pointGeometry.convert(e.bottom||[0,0]),"bottom-left":t.pointGeometry.convert(e["bottom-left"]||[0,0]),"bottom-right":t.pointGeometry.convert(e["bottom-right"]||[0,0]),left:t.pointGeometry.convert(e.left||[0,0]),right:t.pointGeometry.convert(e.right||[0,0])}}return Br(new t.pointGeometry(0,0))}const Fr={version:t.version,supported:e,setRTLTextPlugin:t.setRTLTextPlugin,getRTLTextPluginStatus:t.getRTLTextPluginStatus,Map:class extends ur{constructor(e){if(null!=(e=t.extend({},vr,e)).minZoom&&null!=e.maxZoom&&e.minZoom>e.maxZoom)throw new Error("maxZoom must be greater than or equal to minZoom");if(null!=e.minPitch&&null!=e.maxPitch&&e.minPitch>e.maxPitch)throw new Error("maxPitch must be greater than or equal to minPitch");if(null!=e.minPitch&&e.minPitch<0)throw new Error("minPitch must be greater than or equal to 0");if(null!=e.maxPitch&&e.maxPitch>85)throw new Error("maxPitch must be less than or equal to 85");if(super(new po(e.minZoom,e.maxZoom,e.minPitch,e.maxPitch,e.renderWorldCopies),e),this._interactive=e.interactive,this._maxTileCacheSize=e.maxTileCacheSize,this._failIfMajorPerformanceCaveat=e.failIfMajorPerformanceCaveat,this._preserveDrawingBuffer=e.preserveDrawingBuffer,this._antialias=e.antialias,this._trackResize=e.trackResize,this._bearingSnap=e.bearingSnap,this._refreshExpiredTiles=e.refreshExpiredTiles,this._fadeDuration=e.fadeDuration,this._isInitialLoad=!0,this._crossSourceCollisions=e.crossSourceCollisions,this._crossFadingFactor=1,this._collectResourceTiming=e.collectResourceTiming,this._optimizeForTerrain=e.optimizeForTerrain,this._renderTaskQueue=new mr,this._controls=[],this._mapId=t.uniqueId(),this._locale=t.extend({},pr,e.locale),this._clickTolerance=e.clickTolerance,this._requestManager=new t.RequestManager(e.transformRequest,e.accessToken,e.testMode),this._silenceAuthErrors=!!e.testMode,"string"==typeof e.container){if(this._container=t.window.document.getElementById(e.container),!this._container)throw new Error(`Container '${e.container}' not found.`)}else {if(!(e.container instanceof gr))throw new Error("Invalid type: 'container' must be a String or HTMLElement.");this._container=e.container;}if(e.maxBounds&&this.setMaxBounds(e.maxBounds),t.bindAll(["_onWindowOnline","_onWindowResize","_onMapScroll","_contextLost","_contextRestored"],this),this._setupContainer(),this._setupPainter(),void 0===this.painter)throw new Error("Failed to initialize WebGL.");this.on("move",(()=>this._update(!1))),this.on("moveend",(()=>this._update(!1))),this.on("zoom",(()=>this._update(!0))),void 0!==t.window&&(t.window.addEventListener("online",this._onWindowOnline,!1),t.window.addEventListener("resize",this._onWindowResize,!1),t.window.addEventListener("orientationchange",this._onWindowResize,!1)),this.handlers=new hr(this,e),this._hash=e.hash&&new fo("string"==typeof e.hash&&e.hash||void 0).addTo(this),this._hash&&this._hash._onHashChange()||(this.jumpTo({center:e.center,zoom:e.zoom,bearing:e.bearing,pitch:e.pitch}),e.bounds&&(this.resize(),this.fitBounds(e.bounds,t.extend({},e.fitBoundsOptions,{duration:0})))),this.resize(),this._localFontFamily=e.localFontFamily,this._localIdeographFontFamily=e.localIdeographFontFamily,e.style&&this.setStyle(e.style,{localFontFamily:this._localFontFamily,localIdeographFontFamily:this._localIdeographFontFamily}),e.attributionControl&&this.addControl(new dr({customAttribution:e.customAttribution})),this._logoControl=new _r,this.addControl(this._logoControl,e.logoPosition),this.on("style.load",(()=>{this.transform.unmodified&&this.jumpTo(this.style.stylesheet);})),this.on("data",(e=>{this._update("style"===e.dataType),this.fire(new t.Event(`${e.dataType}data`,e));})),this.on("dataloading",(e=>{this.fire(new t.Event(`${e.dataType}dataloading`,e));}));}_getMapId(){return this._mapId}addControl(e,i){if(void 0===i&&(i=e.getDefaultPosition?e.getDefaultPosition():"top-right"),!e||!e.onAdd)return this.fire(new t.ErrorEvent(new Error("Invalid argument to map.addControl(). Argument must be a control with onAdd and onRemove methods.")));const o=e.onAdd(this);this._controls.push(e);const r=this._controlPositions[i];return -1!==i.indexOf("bottom")?r.insertBefore(o,r.firstChild):r.appendChild(o),this}removeControl(e){if(!e||!e.onRemove)return this.fire(new t.ErrorEvent(new Error("Invalid argument to map.removeControl(). Argument must be a control with onAdd and onRemove methods.")));const i=this._controls.indexOf(e);return i>-1&&this._controls.splice(i,1),e.onRemove(this),this}hasControl(t){return this._controls.indexOf(t)>-1}resize(e){const i=this._containerDimensions(),o=i[0],r=i[1];this._resizeCanvas(o,r),this.transform.resize(o,r),this.painter.resize(o,r);const a=!this._moving;return a&&(this.stop(),this.fire(new t.Event("movestart",e)).fire(new t.Event("move",e))),this.fire(new t.Event("resize",e)),a&&this.fire(new t.Event("moveend",e)),this}getBounds(){return this.transform.getBounds()}getMaxBounds(){return this.transform.getMaxBounds()}setMaxBounds(e){return this.transform.setMaxBounds(t.LngLatBounds.convert(e)),this._update()}setMinZoom(t){if((t=null==t?-2:t)>=-2&&t<=this.transform.maxZoom)return this.transform.minZoom=t,this._update(),this.getZoom()<t&&this.setZoom(t),this;throw new Error("minZoom must be between -2 and the current maxZoom, inclusive")}getMinZoom(){return this.transform.minZoom}setMaxZoom(t){if((t=null==t?22:t)>=this.transform.minZoom)return this.transform.maxZoom=t,this._update(),this.getZoom()>t&&this.setZoom(t),this;throw new Error("maxZoom must be greater than the current minZoom")}getMaxZoom(){return this.transform.maxZoom}setMinPitch(t){if((t=null==t?0:t)<0)throw new Error("minPitch must be greater than or equal to 0");if(t>=0&&t<=this.transform.maxPitch)return this.transform.minPitch=t,this._update(),this.getPitch()<t&&this.setPitch(t),this;throw new Error("minPitch must be between 0 and the current maxPitch, inclusive")}getMinPitch(){return this.transform.minPitch}setMaxPitch(t){if((t=null==t?85:t)>85)throw new Error("maxPitch must be less than or equal to 85");if(t>=this.transform.minPitch)return this.transform.maxPitch=t,this._update(),this.getPitch()>t&&this.setPitch(t),this;throw new Error("maxPitch must be greater than the current minPitch")}getMaxPitch(){return this.transform.maxPitch}getRenderWorldCopies(){return this.transform.renderWorldCopies}setRenderWorldCopies(t){return this.transform.renderWorldCopies=t,this._update()}project(e){return this.transform.locationPoint3D(t.LngLat.convert(e))}unproject(e){return this.transform.pointLocation3D(t.pointGeometry.convert(e))}isMoving(){return this._moving||this.handlers&&this.handlers.isMoving()}isZooming(){return this._zooming||this.handlers&&this.handlers.isZooming()}isRotating(){return this._rotating||this.handlers&&this.handlers.isRotating()}_createDelegatedListener(t,e,i){if("mouseenter"===t||"mouseover"===t){let o=!1;const r=r=>{const a=this.getLayer(e)?this.queryRenderedFeatures(r.point,{layers:[e]}):[];a.length?o||(o=!0,i.call(this,new Co(t,this,r.originalEvent,{features:a}))):o=!1;};return {layer:e,listener:i,delegates:{mousemove:r,mouseout:()=>{o=!1;}}}}if("mouseleave"===t||"mouseout"===t){let o=!1;const r=r=>{(this.getLayer(e)?this.queryRenderedFeatures(r.point,{layers:[e]}):[]).length?o=!0:o&&(o=!1,i.call(this,new Co(t,this,r.originalEvent)));},a=e=>{o&&(o=!1,i.call(this,new Co(t,this,e.originalEvent)));};return {layer:e,listener:i,delegates:{mousemove:r,mouseout:a}}}{const o=t=>{const o=this.getLayer(e)?this.queryRenderedFeatures(t.point,{layers:[e]}):[];o.length&&(t.features=o,i.call(this,t),delete t.features);};return {layer:e,listener:i,delegates:{[t]:o}}}}on(t,e,i){if(void 0===i)return super.on(t,e);const o=this._createDelegatedListener(t,e,i);this._delegatedListeners=this._delegatedListeners||{},this._delegatedListeners[t]=this._delegatedListeners[t]||[],this._delegatedListeners[t].push(o);for(const t in o.delegates)this.on(t,o.delegates[t]);return this}once(t,e,i){if(void 0===i)return super.once(t,e);const o=this._createDelegatedListener(t,e,i);for(const t in o.delegates)this.once(t,o.delegates[t]);return this}off(t,e,i){return void 0===i?super.off(t,e):(this._delegatedListeners&&this._delegatedListeners[t]&&(o=>{const r=this._delegatedListeners[t];for(let t=0;t<r.length;t++){const o=r[t];if(o.layer===e&&o.listener===i){for(const t in o.delegates)this.off(t,o.delegates[t]);return r.splice(t,1),this}}})(),this)}queryRenderedFeatures(e,i){return this.style?(void 0!==i||void 0===e||e instanceof t.pointGeometry||Array.isArray(e)||(i=e,e=void 0),this.style.queryRenderedFeatures(e=e||[[0,0],[this.transform.width,this.transform.height]],i=i||{},this.transform)):[]}querySourceFeatures(t,e){return this.style.querySourceFeatures(t,e)}setStyle(e,i){return !1!==(i=t.extend({},{localIdeographFontFamily:this._localIdeographFontFamily,localFontFamily:this._localFontFamily},i)).diff&&i.localIdeographFontFamily===this._localIdeographFontFamily&&i.localFontFamily===this._localFontFamily&&this.style&&e?(this._diffStyle(e,i),this):(this._localIdeographFontFamily=i.localIdeographFontFamily,this._localFontFamily=i.localFontFamily,this._updateStyle(e,i))}_getUIString(t){const e=this._locale[t];if(null==e)throw new Error(`Missing UI string '${t}'`);return e}_updateStyle(t,e){return this.style&&(this.style.setEventedParent(null),this.style._remove(),delete this.style),t&&(this.style=new Be(this,e||{}),this.style.setEventedParent(this,{style:this.style}),"string"==typeof t?this.style.loadURL(t):this.style.loadJSON(t)),this._updateTerrain(),this}_lazyInitEmptyStyle(){this.style||(this.style=new Be(this,{}),this.style.setEventedParent(this,{style:this.style}),this.style.loadEmpty());}_diffStyle(e,i){if("string"==typeof e){const o=this._requestManager.normalizeStyleURL(e),r=this._requestManager.transformRequest(o,t.ResourceType.Style);t.getJSON(r,((e,o)=>{e?this.fire(new t.ErrorEvent(e)):o&&this._updateDiff(o,i);}));}else "object"==typeof e&&this._updateDiff(e,i);}_updateDiff(e,i){try{this.style.setState(e)&&this._update(!0);}catch(o){t.warnOnce(`Unable to perform style diff: ${o.message||o.error||o}.  Rebuilding the style from scratch.`),this._updateStyle(e,i);}}getStyle(){if(this.style)return this.style.serialize()}isStyleLoaded(){return this.style?this.style.loaded():t.warnOnce("There is no style added to the map.")}addSource(t,e){return this._lazyInitEmptyStyle(),this.style.addSource(t,e),this._update(!0)}isSourceLoaded(e){const i=this.style&&this.style._getSourceCaches(e);if(0!==i.length)return i.every((t=>t.loaded()));this.fire(new t.ErrorEvent(new Error(`There is no source with ID '${e}'`)));}areTilesLoaded(){const t=this.style&&this.style._sourceCaches;for(const e in t){const i=t[e]._tiles;for(const t in i){const e=i[t];if("loaded"!==e.state&&"errored"!==e.state)return !1}}return !0}addSourceType(t,e,i){return this._lazyInitEmptyStyle(),this.style.addSourceType(t,e,i)}removeSource(t){return this.style.removeSource(t),this._updateTerrain(),this._update(!0)}getSource(t){return this.style.getSource(t)}addImage(e,i,{pixelRatio:o=1,sdf:r=!1,stretchX:a,stretchY:n,content:s}={}){if(this._lazyInitEmptyStyle(),i instanceof fr||xr&&i instanceof xr){const{width:l,height:c,data:h}=t.exported.getImageData(i);this.style.addImage(e,{data:new t.RGBAImage({width:l,height:c},h),pixelRatio:o,stretchX:a,stretchY:n,content:s,sdf:r,version:0});}else {if(void 0===i.width||void 0===i.height)return this.fire(new t.ErrorEvent(new Error("Invalid arguments to map.addImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));{const{width:l,height:c,data:h}=i,u=i;this.style.addImage(e,{data:new t.RGBAImage({width:l,height:c},new Uint8Array(h)),pixelRatio:o,stretchX:a,stretchY:n,content:s,sdf:r,version:0,userImage:u}),u.onAdd&&u.onAdd(this,e);}}}updateImage(e,i){const o=this.style.getImage(e);if(!o)return this.fire(new t.ErrorEvent(new Error("The map has no image with that id. If you are adding a new image use `map.addImage(...)` instead.")));const r=i instanceof fr||xr&&i instanceof xr?t.exported.getImageData(i):i,{width:a,height:n,data:s}=r;return void 0===a||void 0===n?this.fire(new t.ErrorEvent(new Error("Invalid arguments to map.updateImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`"))):a!==o.data.width||n!==o.data.height?this.fire(new t.ErrorEvent(new Error("The width and height of the updated image must be that same as the previous version of the image"))):(o.data.replace(s,!(i instanceof fr||xr&&i instanceof xr)),void this.style.updateImage(e,o))}hasImage(e){return e?!!this.style.getImage(e):(this.fire(new t.ErrorEvent(new Error("Missing required image id"))),!1)}removeImage(t){this.style.removeImage(t);}loadImage(e,i){t.getImage(this._requestManager.transformRequest(e,t.ResourceType.Image),i);}listImages(){return this.style.listImages()}addLayer(t,e){return this._lazyInitEmptyStyle(),this.style.addLayer(t,e),this._update(!0)}moveLayer(t,e){return this.style.moveLayer(t,e),this._update(!0)}removeLayer(t){return this.style.removeLayer(t),this._update(!0)}getLayer(t){return this.style.getLayer(t)}setLayerZoomRange(t,e,i){return this.style.setLayerZoomRange(t,e,i),this._update(!0)}setFilter(t,e,i={}){return this.style.setFilter(t,e,i),this._update(!0)}getFilter(t){return this.style.getFilter(t)}setPaintProperty(t,e,i,o={}){return this.style.setPaintProperty(t,e,i,o),this._update(!0)}getPaintProperty(t,e){return this.style.getPaintProperty(t,e)}setLayoutProperty(t,e,i,o={}){return this.style.setLayoutProperty(t,e,i,o),this._update(!0)}getLayoutProperty(t,e){return this.style.getLayoutProperty(t,e)}setLight(t,e={}){return this._lazyInitEmptyStyle(),this.style.setLight(t,e),this._update(!0)}getLight(){return this.style.getLight()}setTerrain(t){return this._lazyInitEmptyStyle(),this.style.setTerrain(t),this._update(!0)}getTerrain(){return this.style.getTerrain()}setFeatureState(t,e){return this.style.setFeatureState(t,e),this._update()}removeFeatureState(t,e){return this.style.removeFeatureState(t,e),this._update()}getFeatureState(t){return this.style.getFeatureState(t)}getContainer(){return this._container}getCanvasContainer(){return this._canvasContainer}getCanvas(){return this._canvas}_containerDimensions(){let t=0,e=0;return this._container&&(t=this._container.clientWidth||400,e=this._container.clientHeight||300),[t,e]}_detectMissingCSS(){"rgb(250, 128, 114)"!==t.window.getComputedStyle(this._missingCSSCanary).getPropertyValue("background-color")&&t.warnOnce("This page appears to be missing CSS declarations for Mapbox GL JS, which may cause the map to display incorrectly. Please ensure your page includes mapbox-gl.css, as described in https://www.mapbox.com/mapbox-gl-js/api/.");}_setupContainer(){const t=this._container;t.classList.add("mapboxgl-map"),(this._missingCSSCanary=a.create("div","mapboxgl-canary",t)).style.visibility="hidden",this._detectMissingCSS();const e=this._canvasContainer=a.create("div","mapboxgl-canvas-container",t);this._interactive&&e.classList.add("mapboxgl-interactive"),this._canvas=a.create("canvas","mapboxgl-canvas",e),this._canvas.addEventListener("webglcontextlost",this._contextLost,!1),this._canvas.addEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.setAttribute("tabindex","0"),this._canvas.setAttribute("aria-label","Map"),this._canvas.setAttribute("role","region");const i=this._containerDimensions();this._resizeCanvas(i[0],i[1]);const o=this._controlContainer=a.create("div","mapboxgl-control-container",t),r=this._controlPositions={};["top-left","top-right","bottom-left","bottom-right"].forEach((t=>{r[t]=a.create("div",`mapboxgl-ctrl-${t}`,o);})),this._container.addEventListener("scroll",this._onMapScroll,!1);}_resizeCanvas(e,i){const o=t.exported.devicePixelRatio||1;this._canvas.width=o*e,this._canvas.height=o*i,this._canvas.style.width=`${e}px`,this._canvas.style.height=`${i}px`;}_setupPainter(){const i=t.extend({},e.webGLContextAttributes,{failIfMajorPerformanceCaveat:this._failIfMajorPerformanceCaveat,preserveDrawingBuffer:this._preserveDrawingBuffer,antialias:this._antialias||!1}),o=this._canvas.getContext("webgl",i)||this._canvas.getContext("experimental-webgl",i);o?(t.storeAuthState(o,!0),this.painter=new ro(o,this.transform),this.on("data",(t=>{"source"===t.dataType&&this.painter.setTileLoadedFlag(!0);})),t.exported$1.testSupport(o)):this.fire(new t.ErrorEvent(new Error("Failed to initialize WebGL")));}_contextLost(e){e.preventDefault(),this._frame&&(this._frame.cancel(),this._frame=null),this.fire(new t.Event("webglcontextlost",{originalEvent:e}));}_contextRestored(e){this._setupPainter(),this.resize(),this._update(),this.fire(new t.Event("webglcontextrestored",{originalEvent:e}));}_onMapScroll(t){if(t.target===this._container)return this._container.scrollTop=0,this._container.scrollLeft=0,!1}loaded(){return !this._styleDirty&&!this._sourcesDirty&&!!this.style&&this.style.loaded()}_update(t){return this.style?(this._styleDirty=this._styleDirty||t,this._sourcesDirty=!0,this.triggerRepaint(),this):this}_requestRenderFrame(t){return this._update(),this._renderTaskQueue.add(t)}_cancelRenderFrame(t){this._renderTaskQueue.remove(t);}_render(e){let i,o=0;const r=this.painter.context.extTimerQuery;if(this.listens("gpu-timing-frame")&&(i=r.createQueryEXT(),r.beginQueryEXT(r.TIME_ELAPSED_EXT,i),o=t.exported.now()),this.painter.context.setDirty(),this.painter.setBaseState(),this._renderTaskQueue.run(e),this._removed)return;let a=!1;const n=this._isInitialLoad?0:this._fadeDuration;if(this.style&&this._styleDirty){this._styleDirty=!1;const e=this.transform.zoom,i=t.exported.now();this.style.zoomHistory.update(e,i);const o=new t.EvaluationParameters(e,{now:i,fadeDuration:n,zoomHistory:this.style.zoomHistory,transition:this.style.getTransition()}),r=o.crossFadingFactor();1===r&&r===this._crossFadingFactor||(a=!0,this._crossFadingFactor=r),this.style.update(o);}if(this.style&&this._sourcesDirty&&(this._sourcesDirty=!1,this._updateTerrain(),this.style._updateSources(this.transform)),this._placementDirty=this.style&&this.style._updatePlacement(this.painter.transform,this.showCollisionBoxes,n,this._crossSourceCollisions),this.painter.render(this.style,{showTileBoundaries:this.showTileBoundaries,showTerrainWireframe:this.showTerrainWireframe,showOverdrawInspector:this._showOverdrawInspector,showQueryGeometry:!!this._showQueryGeometry,rotating:this.isRotating(),zooming:this.isZooming(),moving:this.isMoving(),fadeDuration:n,isInitialLoad:this._isInitialLoad,showPadding:this.showPadding,gpuTiming:!!this.listens("gpu-timing-layer"),speedIndexTiming:this.speedIndexTiming}),this.fire(new t.Event("render")),this.loaded()&&!this._loaded&&(this._loaded=!0,this.fire(new t.Event("load"))),this.style&&(this.style.hasTransitions()||a)&&(this._styleDirty=!0),this.style&&!this._placementDirty&&this.style._releaseSymbolFadeTiles(),this.listens("gpu-timing-frame")){const e=t.exported.now()-o;r.endQueryEXT(r.TIME_ELAPSED_EXT,i),setTimeout((()=>{const o=r.getQueryObjectEXT(i,r.QUERY_RESULT_EXT)/1e6;r.deleteQueryEXT(i),this.fire(new t.Event("gpu-timing-frame",{cpuTime:e,gpuTime:o}));}),50);}if(this.listens("gpu-timing-layer")){const e=this.painter.collectGpuTimers();setTimeout((()=>{const i=this.painter.queryGpuTimers(e);this.fire(new t.Event("gpu-timing-layer",{layerTimes:i}));}),50);}const s=this._sourcesDirty||this._styleDirty||this._placementDirty;if(s||this._repaint)this.triggerRepaint();else if(this._triggerFrame(!1),!this.isMoving()&&this.loaded()&&(this.fire(new t.Event("idle")),this._isInitialLoad=!1,this.speedIndexTiming)){const e=this._calculateSpeedIndex();this.fire(new t.Event("speedindexcompleted",{speedIndex:e})),this.speedIndexTiming=!1;}return !this._loaded||this._fullyLoaded||s||(this._fullyLoaded=!0,this._authenticate()),this}_authenticate(){t.getMapSessionAPI(this._getMapId(),this._requestManager._skuToken,this._requestManager._customAccessToken,(e=>{if(e&&(e.message===t.AUTH_ERR_MSG||401===e.status)){const e=this.painter.context.gl;t.storeAuthState(e,!1),this._logoControl instanceof _r&&this._logoControl._updateLogo(),e&&e.clear(e.DEPTH_BUFFER_BIT|e.COLOR_BUFFER_BIT|e.STENCIL_BUFFER_BIT),this._silenceAuthErrors||this.fire(new t.ErrorEvent(new Error("A valid Mapbox access token is required to use Mapbox GL JS. To create an account or a new access token, visit https://account.mapbox.com/")));}})),t.postMapLoadEvent(this._getMapId(),this._requestManager._skuToken,this._requestManager._customAccessToken,(()=>{}));}_updateTerrain(){this.painter.updateTerrain(this.style,this.isMoving()||this.isRotating()||this.isZooming());}_calculateSpeedIndex(){const t=this.painter.canvasCopy(),e=this.painter.getCanvasCopiesAndTimestamps();e.timeStamps.push(performance.now());const i=this.painter.context.gl,o=i.createFramebuffer();function r(t){i.framebufferTexture2D(i.FRAMEBUFFER,i.COLOR_ATTACHMENT0,i.TEXTURE_2D,t,0);const e=new Uint8Array(i.drawingBufferWidth*i.drawingBufferHeight*4);return i.readPixels(0,0,i.drawingBufferWidth,i.drawingBufferHeight,i.RGBA,i.UNSIGNED_BYTE,e),e}return i.bindFramebuffer(i.FRAMEBUFFER,o),this._canvasPixelComparison(r(t),e.canvasCopies.map(r),e.timeStamps)}_canvasPixelComparison(t,e,i){let o=i[1]-i[0];const r=t.length/4;for(let a=0;a<e.length;a++){const n=e[a];let s=0;for(let e=0;e<n.length;e+=4)n[e]===t[e]&&n[e+1]===t[e+1]&&n[e+2]===t[e+2]&&n[e+3]===t[e+3]&&(s+=1);o+=(i[a+2]-i[a+1])*(1-s/r);}return o}remove(){this._hash&&this._hash.remove();for(const t of this._controls)t.onRemove(this);this._controls=[],this._frame&&(this._frame.cancel(),this._frame=null),this._renderTaskQueue.clear(),this.painter.destroy(),this.handlers.destroy(),delete this.handlers,this.setStyle(null),void 0!==t.window&&(t.window.removeEventListener("resize",this._onWindowResize,!1),t.window.removeEventListener("orientationchange",this._onWindowResize,!1),t.window.removeEventListener("online",this._onWindowOnline,!1));const e=this.painter.context.gl.getExtension("WEBGL_lose_context");e&&e.loseContext(),yr(this._canvasContainer),yr(this._controlContainer),yr(this._missingCSSCanary),this._container.classList.remove("mapboxgl-map"),t.removeAuthState(this.painter.context.gl),this._removed=!0,this.fire(new t.Event("remove"));}triggerRepaint(){this._triggerFrame(!0);}_triggerFrame(e){this._renderNextFrame=this._renderNextFrame||e,this.style&&!this._frame&&(this._frame=t.exported.frame((t=>{const e=!!this._renderNextFrame;this._frame=null,this._renderNextFrame=null,e&&this._render(t);})));}_onWindowOnline(){this._update();}_onWindowResize(t){this._trackResize&&this.resize({originalEvent:t})._update();}get showTileBoundaries(){return !!this._showTileBoundaries}set showTileBoundaries(t){this._showTileBoundaries!==t&&(this._showTileBoundaries=t,this._update());}get showTerrainWireframe(){return !!this._showTerrainWireframe}set showTerrainWireframe(t){this._showTerrainWireframe!==t&&(this._showTerrainWireframe=t,this._update());}get speedIndexTiming(){return !!this._speedIndexTiming}set speedIndexTiming(t){this._speedIndexTiming!==t&&(this._speedIndexTiming=t,this._update());}get showPadding(){return !!this._showPadding}set showPadding(t){this._showPadding!==t&&(this._showPadding=t,this._update());}get showCollisionBoxes(){return !!this._showCollisionBoxes}set showCollisionBoxes(t){this._showCollisionBoxes!==t&&(this._showCollisionBoxes=t,t?this.style._generateCollisionBoxes():this._update());}get showOverdrawInspector(){return !!this._showOverdrawInspector}set showOverdrawInspector(t){this._showOverdrawInspector!==t&&(this._showOverdrawInspector=t,this._update());}get repaint(){return !!this._repaint}set repaint(t){this._repaint!==t&&(this._repaint=t,this.triggerRepaint());}get vertices(){return !!this._vertices}set vertices(t){this._vertices=t,this._update();}_setCacheLimits(e,i){t.setCacheLimits(e,i);}get version(){return t.version}},NavigationControl:class{constructor(e){this.options=t.extend({},br,e),this._container=a.create("div","mapboxgl-ctrl mapboxgl-ctrl-group"),this._container.addEventListener("contextmenu",(t=>t.preventDefault())),this.options.showZoom&&(t.bindAll(["_setButtonTitle","_updateZoomButtons"],this),this._zoomInButton=this._createButton("mapboxgl-ctrl-zoom-in",(t=>this._map.zoomIn({},{originalEvent:t}))),a.create("span","mapboxgl-ctrl-icon",this._zoomInButton).setAttribute("aria-hidden",!0),this._zoomOutButton=this._createButton("mapboxgl-ctrl-zoom-out",(t=>this._map.zoomOut({},{originalEvent:t}))),a.create("span","mapboxgl-ctrl-icon",this._zoomOutButton).setAttribute("aria-hidden",!0)),this.options.showCompass&&(t.bindAll(["_rotateCompassArrow"],this),this._compass=this._createButton("mapboxgl-ctrl-compass",(t=>{this.options.visualizePitch?this._map.resetNorthPitch({},{originalEvent:t}):this._map.resetNorth({},{originalEvent:t});})),this._compassIcon=a.create("span","mapboxgl-ctrl-icon",this._compass),this._compassIcon.setAttribute("aria-hidden",!0));}_updateZoomButtons(){const t=this._map.getZoom(),e=t===this._map.getMaxZoom(),i=t===this._map.getMinZoom();this._zoomInButton.disabled=e,this._zoomOutButton.disabled=i,this._zoomInButton.setAttribute("aria-disabled",e.toString()),this._zoomOutButton.setAttribute("aria-disabled",i.toString());}_rotateCompassArrow(){const t=this.options.visualizePitch?`scale(${1/Math.pow(Math.cos(this._map.transform.pitch*(Math.PI/180)),.5)}) rotateX(${this._map.transform.pitch}deg) rotateZ(${this._map.transform.angle*(180/Math.PI)}deg)`:`rotate(${this._map.transform.angle*(180/Math.PI)}deg)`;this._compassIcon.style.transform=t;}onAdd(t){return this._map=t,this.options.showZoom&&(this._setButtonTitle(this._zoomInButton,"ZoomIn"),this._setButtonTitle(this._zoomOutButton,"ZoomOut"),this._map.on("zoom",this._updateZoomButtons),this._updateZoomButtons()),this.options.showCompass&&(this._setButtonTitle(this._compass,"ResetBearing"),this.options.visualizePitch&&this._map.on("pitch",this._rotateCompassArrow),this._map.on("rotate",this._rotateCompassArrow),this._rotateCompassArrow(),this._handler=new wr(this._map,this._compass,this.options.visualizePitch)),this._container}onRemove(){a.remove(this._container),this.options.showZoom&&this._map.off("zoom",this._updateZoomButtons),this.options.showCompass&&(this.options.visualizePitch&&this._map.off("pitch",this._rotateCompassArrow),this._map.off("rotate",this._rotateCompassArrow),this._handler.off(),delete this._handler),delete this._map;}_createButton(t,e){const i=a.create("button",t,this._container);return i.type="button",i.addEventListener("click",e),i}_setButtonTitle(t,e){const i=this._map._getUIString(`NavigationControl.${e}`);t.title=i,t.setAttribute("aria-label",i);}},GeolocateControl:class extends t.Evented{constructor(e){super(),this.options=t.extend({},Ir,e),t.bindAll(["_onSuccess","_onError","_onZoom","_finish","_setupUI","_updateCamera","_updateMarker"],this);}onAdd(e){var i;return this._map=e,this._container=a.create("div","mapboxgl-ctrl mapboxgl-ctrl-group"),i=this._setupUI,void 0!==Mr?i(Mr):void 0!==t.window.navigator.permissions?t.window.navigator.permissions.query({name:"geolocation"}).then((t=>{Mr="denied"!==t.state,i(Mr);})):(Mr=!!t.window.navigator.geolocation,i(Mr)),this._container}onRemove(){void 0!==this._geolocationWatchID&&(t.window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0),this.options.showUserLocation&&this._userLocationDotMarker&&this._userLocationDotMarker.remove(),this.options.showAccuracyCircle&&this._accuracyCircleMarker&&this._accuracyCircleMarker.remove(),a.remove(this._container),this._map.off("zoom",this._onZoom),this._map=void 0,zr=0,Pr=!1;}_isOutOfMapMaxBounds(t){const e=this._map.getMaxBounds(),i=t.coords;return e&&(i.longitude<e.getWest()||i.longitude>e.getEast()||i.latitude<e.getSouth()||i.latitude>e.getNorth())}_setErrorState(){switch(this._watchState){case"WAITING_ACTIVE":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active-error");break;case"ACTIVE_LOCK":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting");break;case"BACKGROUND":this._watchState="BACKGROUND_ERROR",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting");}}_onSuccess(e){if(this._map){if(this._isOutOfMapMaxBounds(e))return this._setErrorState(),this.fire(new t.Event("outofmaxbounds",e)),this._updateMarker(),void this._finish();if(this.options.trackUserLocation)switch(this._lastKnownPosition=e,this._watchState){case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active");break;case"BACKGROUND":case"BACKGROUND_ERROR":this._watchState="BACKGROUND",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background");}this.options.showUserLocation&&"OFF"!==this._watchState&&this._updateMarker(e),this.options.trackUserLocation&&"ACTIVE_LOCK"!==this._watchState||this._updateCamera(e),this.options.showUserLocation&&this._dotElement.classList.remove("mapboxgl-user-location-dot-stale"),this.fire(new t.Event("geolocate",e)),this._finish();}}_updateCamera(e){const i=new t.LngLat(e.coords.longitude,e.coords.latitude),o=e.coords.accuracy,r=this._map.getBearing(),a=t.extend({bearing:r},this.options.fitBoundsOptions);this._map.fitBounds(i.toBounds(o),a,{geolocateSource:!0});}_updateMarker(e){if(e){const i=new t.LngLat(e.coords.longitude,e.coords.latitude);this._accuracyCircleMarker.setLngLat(i).addTo(this._map),this._userLocationDotMarker.setLngLat(i).addTo(this._map),this._accuracy=e.coords.accuracy,this.options.showUserLocation&&this.options.showAccuracyCircle&&this._updateCircleRadius();}else this._userLocationDotMarker.remove(),this._accuracyCircleMarker.remove();}_updateCircleRadius(){const t=this._map._container.clientHeight/2,e=this._map.unproject([0,t]),i=this._map.unproject([100,t]),o=e.distanceTo(i)/100,r=Math.ceil(2*this._accuracy/o);this._circleElement.style.width=`${r}px`,this._circleElement.style.height=`${r}px`;}_onZoom(){this.options.showUserLocation&&this.options.showAccuracyCircle&&this._updateCircleRadius();}_onError(e){if(this._map){if(this.options.trackUserLocation)if(1===e.code){this._watchState="OFF",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background-error"),this._geolocateButton.disabled=!0;const t=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.title=t,this._geolocateButton.setAttribute("aria-label",t),void 0!==this._geolocationWatchID&&this._clearWatch();}else {if(3===e.code&&Pr)return;this._setErrorState();}"OFF"!==this._watchState&&this.options.showUserLocation&&this._dotElement.classList.add("mapboxgl-user-location-dot-stale"),this.fire(new t.Event("error",e)),this._finish();}}_finish(){this._timeoutId&&clearTimeout(this._timeoutId),this._timeoutId=void 0;}_setupUI(e){if(this._container.addEventListener("contextmenu",(t=>t.preventDefault())),this._geolocateButton=a.create("button","mapboxgl-ctrl-geolocate",this._container),a.create("span","mapboxgl-ctrl-icon",this._geolocateButton).setAttribute("aria-hidden",!0),this._geolocateButton.type="button",!1===e){t.warnOnce("Geolocation support is not available so the GeolocateControl will be disabled.");const e=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.disabled=!0,this._geolocateButton.title=e,this._geolocateButton.setAttribute("aria-label",e);}else {const t=this._map._getUIString("GeolocateControl.FindMyLocation");this._geolocateButton.title=t,this._geolocateButton.setAttribute("aria-label",t);}this.options.trackUserLocation&&(this._geolocateButton.setAttribute("aria-pressed","false"),this._watchState="OFF"),this.options.showUserLocation&&(this._dotElement=a.create("div","mapboxgl-user-location-dot"),this._userLocationDotMarker=new Sr(this._dotElement),this._circleElement=a.create("div","mapboxgl-user-location-accuracy-circle"),this._accuracyCircleMarker=new Sr({element:this._circleElement,pitchAlignment:"map"}),this.options.trackUserLocation&&(this._watchState="OFF"),this._map.on("zoom",this._onZoom)),this._geolocateButton.addEventListener("click",this.trigger.bind(this)),this._setup=!0,this.options.trackUserLocation&&this._map.on("movestart",(e=>{e.geolocateSource||"ACTIVE_LOCK"!==this._watchState||e.originalEvent&&"resize"===e.originalEvent.type||(this._watchState="BACKGROUND",this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this.fire(new t.Event("trackuserlocationend")));}));}trigger(){if(!this._setup)return t.warnOnce("Geolocate control triggered before added to a map"),!1;if(this.options.trackUserLocation){switch(this._watchState){case"OFF":this._watchState="WAITING_ACTIVE",this.fire(new t.Event("trackuserlocationstart"));break;case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":case"BACKGROUND_ERROR":zr--,Pr=!1,this._watchState="OFF",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background-error"),this.fire(new t.Event("trackuserlocationend"));break;case"BACKGROUND":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background"),this._lastKnownPosition&&this._updateCamera(this._lastKnownPosition),this.fire(new t.Event("trackuserlocationstart"));}switch(this._watchState){case"WAITING_ACTIVE":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active");break;case"ACTIVE_LOCK":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active");break;case"ACTIVE_ERROR":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active-error");break;case"BACKGROUND":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background");break;case"BACKGROUND_ERROR":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background-error");}if("OFF"===this._watchState&&void 0!==this._geolocationWatchID)this._clearWatch();else if(void 0===this._geolocationWatchID){let e;this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","true"),zr++,zr>1?(e={maximumAge:6e5,timeout:0},Pr=!0):(e=this.options.positionOptions,Pr=!1),this._geolocationWatchID=t.window.navigator.geolocation.watchPosition(this._onSuccess,this._onError,e);}}else t.window.navigator.geolocation.getCurrentPosition(this._onSuccess,this._onError,this.options.positionOptions),this._timeoutId=setTimeout(this._finish,1e4);return !0}_clearWatch(){t.window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0,this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","false"),this.options.showUserLocation&&this._updateMarker(null);}},AttributionControl:dr,ScaleControl:class{constructor(e){this.options=t.extend({},Ar,e),t.bindAll(["_onMove","setUnit"],this);}getDefaultPosition(){return "bottom-left"}_onMove(){Dr(this._map,this._container,this.options);}onAdd(t){return this._map=t,this._container=a.create("div","mapboxgl-ctrl mapboxgl-ctrl-scale",t.getContainer()),this._map.on("move",this._onMove),this._onMove(),this._container}onRemove(){a.remove(this._container),this._map.off("move",this._onMove),this._map=void 0;}setUnit(t){this.options.unit=t,Dr(this._map,this._container,this.options);}},FullscreenControl:class{constructor(e){this._fullscreen=!1,e&&e.container&&(e.container instanceof t.window.HTMLElement?this._container=e.container:t.warnOnce("Full screen control 'container' must be a DOM element.")),t.bindAll(["_onClickFullscreen","_changeIcon"],this),"onfullscreenchange"in t.window.document?this._fullscreenchange="fullscreenchange":"onwebkitfullscreenchange"in t.window.document&&(this._fullscreenchange="webkitfullscreenchange");}onAdd(e){return this._map=e,this._container||(this._container=this._map.getContainer()),this._controlContainer=a.create("div","mapboxgl-ctrl mapboxgl-ctrl-group"),this._checkFullscreenSupport()?this._setupUI():(this._controlContainer.style.display="none",t.warnOnce("This device does not support fullscreen mode.")),this._controlContainer}onRemove(){a.remove(this._controlContainer),this._map=null,t.window.document.removeEventListener(this._fullscreenchange,this._changeIcon);}_checkFullscreenSupport(){return !(!t.window.document.fullscreenEnabled&&!t.window.document.webkitFullscreenEnabled)}_setupUI(){const e=this._fullscreenButton=a.create("button","mapboxgl-ctrl-fullscreen",this._controlContainer);a.create("span","mapboxgl-ctrl-icon",e).setAttribute("aria-hidden",!0),e.type="button",this._updateTitle(),this._fullscreenButton.addEventListener("click",this._onClickFullscreen),t.window.document.addEventListener(this._fullscreenchange,this._changeIcon);}_updateTitle(){const t=this._getTitle();this._fullscreenButton.setAttribute("aria-label",t),this._fullscreenButton.title=t;}_getTitle(){return this._map._getUIString(this._isFullscreen()?"FullscreenControl.Exit":"FullscreenControl.Enter")}_isFullscreen(){return this._fullscreen}_changeIcon(){(t.window.document.fullscreenElement||t.window.document.webkitFullscreenElement)===this._container!==this._fullscreen&&(this._fullscreen=!this._fullscreen,this._fullscreenButton.classList.toggle("mapboxgl-ctrl-shrink"),this._fullscreenButton.classList.toggle("mapboxgl-ctrl-fullscreen"),this._updateTitle());}_onClickFullscreen(){this._isFullscreen()?t.window.document.exitFullscreen?t.window.document.exitFullscreen():t.window.document.webkitCancelFullScreen&&t.window.document.webkitCancelFullScreen():this._container.requestFullscreen?this._container.requestFullscreen():this._container.webkitRequestFullscreen&&this._container.webkitRequestFullscreen();}},Popup:class extends t.Evented{constructor(e){super(),this.options=t.extend(Object.create(Rr),e),t.bindAll(["_update","_onClose","remove","_onMouseMove","_onMouseUp","_onDrag"],this);}addTo(e){return this._map&&this.remove(),this._map=e,this.options.closeOnClick&&this._map.on("click",this._onClose),this.options.closeOnMove&&this._map.on("move",this._onClose),this._map.on("remove",this.remove),this._update(),this._focusFirstElement(),this._trackPointer?(this._map.on("mousemove",this._onMouseMove),this._map.on("mouseup",this._onMouseUp),this._container&&this._container.classList.add("mapboxgl-popup-track-pointer"),this._map._canvasContainer.classList.add("mapboxgl-track-pointer")):this._map.on("move",this._update),this.fire(new t.Event("open")),this}isOpen(){return !!this._map}remove(){return this._content&&a.remove(this._content),this._container&&(a.remove(this._container),delete this._container),this._map&&(this._map.off("move",this._update),this._map.off("move",this._onClose),this._map.off("click",this._onClose),this._map.off("remove",this.remove),this._map.off("mousemove",this._onMouseMove),this._map.off("mouseup",this._onMouseUp),this._map.off("drag",this._onDrag),delete this._map),this.fire(new t.Event("close")),this}getLngLat(){return this._lngLat}setLngLat(e){return this._lngLat=t.LngLat.convert(e),this._pos=null,this._trackPointer=!1,this._update(),this._map&&(this._map.on("move",this._update),this._map.off("mousemove",this._onMouseMove),this._container&&this._container.classList.remove("mapboxgl-popup-track-pointer"),this._map._canvasContainer.classList.remove("mapboxgl-track-pointer")),this}trackPointer(){return this._trackPointer=!0,this._pos=null,this._update(),this._map&&(this._map.off("move",this._update),this._map.on("mousemove",this._onMouseMove),this._map.on("drag",this._onDrag),this._container&&this._container.classList.add("mapboxgl-popup-track-pointer"),this._map._canvasContainer.classList.add("mapboxgl-track-pointer")),this}getElement(){return this._container}setText(e){return this.setDOMContent(t.window.document.createTextNode(e))}setHTML(e){const i=t.window.document.createDocumentFragment(),o=t.window.document.createElement("body");let r;for(o.innerHTML=e;r=o.firstChild,r;)i.appendChild(r);return this.setDOMContent(i)}getMaxWidth(){return this._container&&this._container.style.maxWidth}setMaxWidth(t){return this.options.maxWidth=t,this._update(),this}setDOMContent(t){if(this._content)for(;this._content.hasChildNodes();)this._content.firstChild&&this._content.removeChild(this._content.firstChild);else this._content=a.create("div","mapboxgl-popup-content",this._container);return this._content.appendChild(t),this._createCloseButton(),this._update(),this._focusFirstElement(),this}addClassName(t){this._container&&this._container.classList.add(t);}removeClassName(t){this._container&&this._container.classList.remove(t);}setOffset(t){return this.options.offset=t,this._update(),this}toggleClassName(t){if(this._container)return this._container.classList.toggle(t)}_createCloseButton(){this.options.closeButton&&(this._closeButton=a.create("button","mapboxgl-popup-close-button",this._content),this._closeButton.type="button",this._closeButton.setAttribute("aria-label","Close popup"),this._closeButton.innerHTML="&#215;",this._closeButton.addEventListener("click",this._onClose));}_onMouseUp(t){this._update(t.point);}_onMouseMove(t){this._update(t.point);}_onDrag(t){this._update(t.point);}_update(t){if(!this._map||!this._lngLat&&!this._trackPointer||!this._content)return;if(this._container||(this._container=a.create("div","mapboxgl-popup",this._map.getContainer()),this._tip=a.create("div","mapboxgl-popup-tip",this._container),this._container.appendChild(this._content),this.options.className&&this.options.className.split(" ").forEach((t=>this._container.classList.add(t))),this._trackPointer&&this._container.classList.add("mapboxgl-popup-track-pointer")),this.options.maxWidth&&this._container.style.maxWidth!==this.options.maxWidth&&(this._container.style.maxWidth=this.options.maxWidth),this._map.transform.renderWorldCopies&&!this._trackPointer&&(this._lngLat=Tr(this._lngLat,this._pos,this._map.transform)),this._trackPointer&&!t)return;const e=this._pos=this._trackPointer&&t?t:this._map.project(this._lngLat);let i=this.options.anchor;const o=Br(this.options.offset);if(!i){const t=this._container.offsetWidth,r=this._container.offsetHeight;let a;a=e.y+o.bottom.y<r?["top"]:e.y>this._map.transform.height-r?["bottom"]:[],e.x<t/2?a.push("left"):e.x>this._map.transform.width-t/2&&a.push("right"),i=0===a.length?"bottom":a.join("-");}const r=e.add(o[i]).round();a.setTransform(this._container,`${Er[i]} translate(${r.x}px,${r.y}px)`),Cr(this._container,i,"popup");}_focusFirstElement(){if(!this.options.focusAfterOpen||!this._container)return;const t=this._container.querySelector(kr);t&&t.focus();}_onClose(){this.remove();}},Marker:Sr,Style:Be,LngLat:t.LngLat,LngLatBounds:t.LngLatBounds,Point:t.pointGeometry,MercatorCoordinate:t.MercatorCoordinate,FreeCameraOptions:_o,Evented:t.Evented,config:t.config,prewarm:function(){Pt().acquire(It);},clearPrewarmedResources:function(){const t=zt;t&&(t.isPreloaded()&&1===t.numActive()?(t.release(It),zt=null):console.warn("Could not clear WebWorkers since there are active Map instances that still reference it. The pre-warmed WebWorker pool can only be cleared when all map instances have been removed with map.remove()"));},get accessToken(){return t.config.ACCESS_TOKEN},set accessToken(e){t.config.ACCESS_TOKEN=e;},get baseApiUrl(){return t.config.API_URL},set baseApiUrl(e){t.config.API_URL=e;},get workerCount(){return Mt.workerCount},set workerCount(t){Mt.workerCount=t;},get maxParallelImageRequests(){return t.config.MAX_PARALLEL_IMAGE_REQUESTS},set maxParallelImageRequests(e){t.config.MAX_PARALLEL_IMAGE_REQUESTS=e;},clearStorage(e){t.clearTileCache(e);},workerUrl:"",workerClass:null,setNow:t.exported.setNow,restoreNow:t.exported.restoreNow};return Fr}));

//

var mapboxgl$1 = mapboxgl;

return mapboxgl$1;

})));
