jQuery( window ).on( 'elementor:init', function() {
	var ControlCTHIconItemView = elementor.modules.controls.Select2.extend( {
		initialize: function() {
			elementor.modules.controls.Select2.prototype.initialize.apply( this, arguments );

			this.filterIcons();
		},

		filterIcons: function() {
			var icons = this.model.get( 'options' ),
				include = this.model.get( 'include' ),
				exclude = this.model.get( 'exclude' );

			if ( include ) {
				var filteredIcons = {};

				_.each( include, function( iconKey ) {
					filteredIcons[ iconKey ] = icons[ iconKey ];
				} );

				this.model.set( 'options', filteredIcons );
				return;
			}

			if ( exclude ) {
				_.each( exclude, function( iconKey ) {
					delete icons[ iconKey ];
				} );
			}
		},
		iconsList: function( icon ) {
			if ( ! icon.id ) {
				return icon.text;
			}

			return jQuery(
				'<span><i class="' + icon.id + '"></i> ' + icon.text + '</span>'
			);
		},

		getSelect2Options: function() {
			return {
				allowClear: true,
				templateResult: this.iconsList.bind( this ),
				templateSelection: this.iconsList.bind( this ),
			};
		},
	
	} );
	elementor.addControlView( 'cthicon', ControlCTHIconItemView );
} );