<?php
/* add_ons_php */
/**
 * Settings for PayFast Gateway.
 *
 * @package WooCommerce/Classes/Payment
 */

defined('ABSPATH') || exit;

return array(
    'enabled'      => array(
        'title'   => __('Enable/Disable', 'homeradar-woo-payments'),
        'type'    => 'checkbox',
        'label'   => __('Enable PayFast Recurring', 'homeradar-woo-payments'),
        'default' => 'no',
    ),
    'title'        => array(
        'title'       => __('Title', 'homeradar-woo-payments'),
        'type'        => 'text',
        'description' => __('This controls the title which the user sees during checkout.', 'homeradar-woo-payments'),
        'default'     => 'HomeRadar PayFast',
        'desc_tip'    => true,
    ),
    'description'  => array(
        'title'       => __('Description', 'homeradar-woo-payments'),
        'type'        => 'text',
        'desc_tip'    => true,
        'description' => __('This controls the description which the user sees during checkout.', 'homeradar-woo-payments'),
        'default'     => "Pay via PayFast; you can pay with your credit card if you don't have a PayFast account.",
    ),

    'merchant'     => array(
        'title'       => __('Merchant options', 'homeradar-woo-payments'),
        'type'        => 'title',
        'description' => '',
    ),

    'merchant_id'  => array(
        'title'       => __('Merchant ID', 'homeradar-woo-payments'),
        'type'        => 'text',
        'description' => __('You PayFast merchant id', 'homeradar-woo-payments'),
        'default'     => '',
        'desc_tip'    => false,
    ),

    'merchant_key' => array(
        'title'       => __('Merchant Key', 'homeradar-woo-payments'),
        'type'        => 'text',
        'description' => __('You PayFast merchant key', 'homeradar-woo-payments'),
        'default'     => '',
        'desc_tip'    => false,
    ),

    'passphrase' => array(
        'title'       => __('Merchant passphrase', 'homeradar-woo-payments'),
        'type'        => 'text',
        'description' => sprintf( __( 'Enter your PayFast passphrase. Learn how to create your <a href="%s">PayFast passphrase</a>.<br /><a href="%s">WooCommerce PayFast Payment Gateway</a>', 'homeradar-woo-payments' ), 'https://support.payfast.co.za/article/120-how-do-i-enable-a-passphrase-on-my-payfast-account', 'https://docs.woocommerce.com/document/payfast-payment-gateway/' ),
        'default'     => '',
        'desc_tip'    => false,
    ),

    'email_confirmation'      => array(
        'title'       => __( 'Email Confirmation?', 'homeradar-woo-payments' ),
        'type'        => 'checkbox',
        'label'       => __( 'Enable email confirmation', 'homeradar-woo-payments' ),
        'default'     => 'yes',
        'description' => __( 'Whether to send email confirmation to the merchant of the transaction.', 'homeradar-woo-payments' ),
    ),
    'confirmation_address'        => array(
        'title'       => __( 'Confirmation Email Address', 'homeradar-woo-payments' ),
        'type'        => 'email',
        'description' => __( 'The address to send the confirmation email to.', 'homeradar-woo-payments' ),
        'default'     => '',
        'desc_tip'    => true,
        'placeholder' => 'you@youremail.com',
    ),


    'advanced'     => array(
        'title'       => __('Advanced options', 'homeradar-woo-payments'),
        'type'        => 'title',
        'description' => '',
    ),
    'testmode'     => array(
        'title'       => __('PayFast sandbox', 'homeradar-woo-payments'),
        'type'        => 'checkbox',
        'label'       => __('Enable PayFast sandbox', 'homeradar-woo-payments'),
        'default'     => 'no',
        /* translators: %s: URL */
        'description' => sprintf(__('PayFast sandbox can be used to test payments. Sign up for a <a href="%s">developer account</a>.', 'homeradar-woo-payments'), 'https://developer.payfast.com/'),
    ),
    'debug'        => array(
        'title'       => __('Debug log', 'homeradar-woo-payments'),
        'type'        => 'checkbox',
        'label'       => __('Enable logging', 'homeradar-woo-payments'),
        'default'     => 'no',
        /* translators: %s: URL */
        'description' => sprintf(__('Log PayFast events, such as IPN requests, inside %s Note: this may log personal information. We recommend using this for debugging purposes only and deleting the logs when finished.', 'homeradar-woo-payments'), '<code>' . WC_Log_Handler_File::get_log_file_path('cth-payfast') . '</code>'),
    ),

);
