<?php
/* banner-php */
/**
 * Template part for displaying audio posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 */

?>
<!-- article> --> 
<article id="post-<?php the_ID(); ?>" <?php post_class('pos-single ptype-content-audio'); ?>>
    <?php 
    if(citybook_get_option('single_featured' )): ?>
        <?php 
		if(get_post_meta(get_the_ID(), '_cth_embed_video', true)!=""){ ?>	
		    <div class="list-single-main-media fl-wrap">
		    	<?php
		    		$audio_url = get_post_meta(get_the_ID(), '_cth_embed_video', true);
					if(preg_match('/(.mp3|.ogg|.wma|.m4a|.wav)$/i', $audio_url )){
						$attr = array(
							'src'      => $audio_url,
							'loop'     => '',
							'autoplay' => '',
							'preload'  => 'none'
						);
						echo wp_audio_shortcode( $attr );
					}else{
				?>
					<div class="resp-audio">
						<?php echo wp_oembed_get(esc_url( $audio_url ) , array('height'=>'166') ); ?>
					</div>
				<?php } ?>
		    	
	        </div>
        <?php
        }elseif(has_post_thumbnail( )){ ?>
        <div class="list-single-main-media fl-wrap">
            <?php the_post_thumbnail('citybook-single-image',array('class'=>'respimg') ); ?>
        </div>
        <?php } 
        ?>
    <?php 
    endif; ?>
    <div class="list-single-main-item fl-wrap">
        <div class="list-single-main-item-title fl-wrap">
            <?php 
            the_title( '<h3 class="entry-title">', '</h3>' );
            citybook_edit_link( get_the_ID() );
            ?>
        </div>
        <?php the_content();?>
        <?php
            wp_link_pages( array(
            'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'citybook' ) . '</span>',
            'after'       => '</div>',
            'link_before' => '<span>',
            'link_after'  => '</span>',
            ) );
        ?>
        <div class="clearfix"></div>
        <?php if( citybook_get_option( 'single_author' ) ):?>
        <div class="post-author">
            <?php 
                echo get_avatar(get_the_author_meta('user_email'), '80', 'https://0.gravatar.com/avatar/ad516503a11cd5ca435acc9bb6523536?s=80', get_the_author_meta( 'display_name' ) );
            ?>
            <?php esc_html_e( 'By, ',  'citybook' ) ; the_author_posts_link( );?>
        </div>
        <?php endif;?>


        <?php if( citybook_get_option( 'single_date' )  || citybook_get_option( 'single_cats' ) || citybook_get_option( 'single_comments' )  ):?>
        <div class="post-opt">
            <ul class="blog-title-opt">
                <?php if( citybook_get_option( 'single_date' ) ) :?>
                <li><i class="fal fa-calendar-check"></i><span><?php the_time(get_option('date_format'));?></span></li>
                <?php endif;?>
                
                <?php if( function_exists('citybook_addons_get_post_views') ) :?>
                <li><i class="fal fa-eye"></i> <span><?php echo citybook_addons_get_post_views(get_the_ID());?></span></li>
                <?php endif;?>

                <?php if( citybook_get_option( 'single_cats' ) ) :?>
                    <?php if(get_the_category( )) { ?>
                    <li><i class="fal fa-tags"></i><?php the_category( ' , ' ); ?></li>  
                    <?php } ?>  
                <?php endif;?>

                <?php if( citybook_get_option( 'single_comments' ) ):?>
                <li><i class="fal fa-comments"></i> <?php comments_popup_link( esc_html_x('0 comment','comment counter None format' ,'citybook'), esc_html_x('1 comment','comment counter One format', 'citybook'), esc_html_x('% comments','comment counter Plural format', 'citybook') ); ?></li>
                <?php endif;?>

            </ul>
        </div>
        <?php endif;?>
        <?php if( citybook_get_option( 'single_tags' ) && get_the_tags( ) ) :?>
        <span class="fw-separator"></span>
        <div class="list-single-main-item-title fl-wrap">
            <h3><?php esc_html_e( 'Tags', 'citybook' ); ?></h3>
        </div>
        <div class="list-single-tags tags-stylwrap blog-tags">
            <?php the_tags('','','');?>                                                                          
        </div>
        <?php endif;?>
        <?php if(function_exists('citybook_addons_echo_socials_share')) citybook_addons_echo_socials_share(); ?>
        <span class="fw-separator"></span>
        <?php citybook_post_nav();?> 
    </div>
</article>
<!-- article end -->       
<span class="section-separator"></span>

