<?php
/* banner-php */
/**
 * Template part for displaying posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 */

?>
<!-- article> --> 
<article id="post-<?php the_ID(); ?>" <?php post_class('fl-wrap ptype-content fw-post'); ?>>
    <?php 
	// Get the list of files
    $slider_images = get_post_meta( get_the_ID(), '_cth_post_slider_images', true);
    if( !empty($slider_images)&& citybook_get_option('blog_show_format', true ) && get_post_format( ) !== 'gallery' ){ ?>
	<div class="list-single-main-media fl-wrap">
		<div class="single-slider-wrapper fl-wrap">

			<div class="single-slider fl-wrap">
				<?php 
                foreach ( (array) $slider_images as $img_id => $img_url ) {
			        echo '<div class="slick-slide-item">';
			        	echo '<a href="' . esc_url( get_permalink() ) . '" class="blog-thumb-link">';
			        		echo wp_get_attachment_image($img_id, 'citybook-featured-image','',array('class'=>'respimgsss') );
			        	echo '</a>';
			        echo '</div>';
			    }
				?>
            </div>
            <div class="swiper-button-prev sw-btn"><i class="fal fa-long-arrow-left"></i></div>
            <div class="swiper-button-next sw-btn"><i class="fal fa-long-arrow-right"></i></div>
        </div>
    </div>
	<?php
	}elseif(has_post_thumbnail( )){ ?>
	<div class="list-single-main-media fl-wrap">
        <a href="<?php the_permalink( ); ?>" class="blog-thumb-link">
        	<?php the_post_thumbnail('citybook-featured-image',array('class'=>'respimg') ); ?>
        </a>
    </div>
	<?php } ?>
    <div class="list-single-main-item fl-wrap">
        <div class="list-single-main-item-title fl-wrap">
        	<?php 
			the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
			citybook_edit_link( get_the_ID() );
			?>
        </div>
        <?php
        if( 'listing' == get_post_type(get_the_ID()) ){
            $cats = get_the_terms(get_the_ID(), 'listing_cat');
            if ( $cats && ! is_wp_error( $cats ) ){
                echo '<div class="listing-tag-view"><div class="listing-cats-wrap">';
                foreach( $cats as $key => $cat){

                    echo sprintf( '<a href="%1$s" class="listing-geodir-category">%2$s</a> ',
                        esc_url( get_term_link( $cat->term_id, 'listing_cat' ) ),
                        esc_html( $cat->name )
                    );
                }
                echo '</div></div>';
            }
            // end check cat
        }
        ?>
        <?php the_excerpt();?>
        <?php
			wp_link_pages( array(
			'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'citybook' ) . '</span>',
			'after'       => '</div>',
			'link_before' => '<span>',
			'link_after'  => '</span>',
			) );
		?>
		<?php if( citybook_get_option( 'blog_author') ):?>
		<div class="post-author">
			<?php 
                echo get_avatar(get_the_author_meta('user_email'), '80', 'https://0.gravatar.com/avatar/ad516503a11cd5ca435acc9bb6523536?s=80', get_the_author_meta( 'display_name' ) );
            ?>
            <?php esc_html_e( 'By, ',  'citybook' ) ; the_author_posts_link( );?>
        </div>
		<?php endif;?>


		<?php if( citybook_get_option( 'blog_date' )  || citybook_get_option( 'blog_cats' ) || citybook_get_option( 'blog_comments' )  ):?>
	    <div class="post-opt">
	    	<ul class="blog-title-opt">
		        <?php if( citybook_get_option( 'blog_date') ) :?>
				<li><i class="fal fa-calendar-check"></i><span><?php the_time(get_option('date_format'));?></span></li>
				<?php endif;?>
				
				<?php if( function_exists('citybook_addons_get_post_views') ) :?>
				<li><i class="fal fa-eye"></i> <span><?php echo citybook_addons_get_post_views(get_the_ID());?></span></li>
				<?php endif;?>

		        <?php if( citybook_get_option( 'blog_cats' ) ) :?>
					<?php if(get_the_category( )) { ?>
					<li><i class="fal fa-tags"></i><?php the_category( ' , ' ); ?></li>	
					<?php } ?>	
				<?php endif;?>

				<?php if( citybook_get_option( 'blog_comments' ) ):?>
				<li><i class="fal fa-comments"></i> <?php comments_popup_link( esc_html_x('0 comment','comment counter None format' ,'citybook'), esc_html_x('1 comment','comment counter One format', 'citybook'), esc_html_x('% comments','comment counter Plural format', 'citybook') ); ?></li>
				<?php endif;?>

		    </ul>
		</div>
		<?php endif;?>
        
        <?php if( citybook_get_option( 'blog_tags' ) && get_the_tags( ) ) :?>
        <span class="fw-separator"></span>
		<div class="list-single-main-item-title fl-wrap">
            <h3><?php esc_html_e( 'Tags', 'citybook' ); ?></h3>
        </div>
		<div class="list-single-tags tags-stylwrap blog-tags">
            <?php the_tags('','','');?>                                                                          
        </div>
	    <?php endif;?>
        <span class="fw-separator"></span>
        <div class="readmore-post"><a href="<?php the_permalink();?>" class="btn transparent-btn float-btn"><?php esc_html_e('Read more ','citybook' );?><i class="fal fa-eye"></i></a></div>
    </div>
</article>
<!-- article end -->       
<span class="section-separator"></span>
