<?php
/* banner-php */

Redux::setSection( $opt_name, array(
    'title' => esc_html__('Shop', 'citybook'),
    'id'         => 'shop-settings',
    'subsection' => false,
    'icon'       => 'el-icon-shopping-cart',
    'fields' => array(
        array(
            'id'       => 'shop_fullwidth_nav_menu',
            'type'     => 'switch',
            'on'=> esc_html__('Yes', 'citybook'),
            'off'=> esc_html__('No', 'citybook'),
            'title'    => esc_html__( 'Fullwidth Navigation Menu', 'citybook' ),
            'default'  => false,
        ),


        array(
            'id'       => 'show_shop_header',
            'type'     => 'switch',
            'on'=> esc_html__('Yes', 'citybook'),
            'off'=> esc_html__('No', 'citybook'),
            'title'    => esc_html__( 'Show Shop Header', 'citybook' ),
            'default'  => true,
        ),
        array(
            'id' => 'shop_header_image',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Shop Header Image', 'citybook'),
            'default' => array('url' => get_template_directory_uri().'/assets/images/bg/10.jpg'),
        ),

        array(
            'id'       => 'shop_breadcrumbs',
            'type'     => 'switch',
            'on'=> esc_html__('Yes', 'citybook'),
            'off'=> esc_html__('No', 'citybook'),
            'title'    => esc_html__( 'Show Breadcrumbs', 'citybook' ),
            'default'  => true,
        ),

        array(
            'id'       => 'shop_sidebar',
            'type'     => 'image_select',
            'title'    => esc_html__( 'Shop Sidebar', 'citybook' ),

            'options'  => array(
                'fullwidth' => array(
                    'alt' => 'No Sidebar',
                    'img' => get_template_directory_uri() . '/assets/redux/1col.png'
                ),
                'left_sidebar' => array(
                    'alt' => 'Left Sidebar',
                    'img' => get_template_directory_uri() . '/assets/redux/2cl.png'
                ),
                'right_sidebar' => array(
                    'alt' => 'Right Sidebar',
                    'img' => get_template_directory_uri() . '/assets/redux/2cr.png'
                ),
                
            ),
            'default'  => 'right_sidebar'
        ),

        

        array(
            'id' => 'shop-sidebar-width',
            'type' => 'select',
            'title' => esc_html__('Sidebar Width', 'citybook'),
            'subtitle' => esc_html__( 'Based on Bootstrap 12 columns.', 'citybook' ),
            'options' => array(
                            '2' => esc_html__('2 Columns', 'citybook'),
                            '3' => esc_html__('3 Columns', 'citybook'),
                            '4' => esc_html__('4 Columns', 'citybook'),
                            '5' => esc_html__('5 Columns', 'citybook'),
                            '6' => esc_html__('6 Columns', 'citybook'),
             ), //Must provide key => value pairs for select options
            'default' => '4'
        ),


        array(
            'id'       => 'shop_posts_per_page',
            'type'     => 'text',
            'title'    => esc_html__( 'Posts per page', 'citybook' ),
            'subtitle' => esc_html__( 'Number of post to show per page, -1 to show all posts.', 'citybook' ),
            'default'  => 12,
        ),
        // array(
        //     'id'       => 'show_image_large_popup',
        //     'type'     => 'switch',
        //     'on'=> esc_html__('Yes', 'citybook'),
        //     'off'=> esc_html__('No', 'citybook'),
        //     'title'    => esc_html__( 'Show image popup button', 'citybook' ),
        //     'subtitle' => esc_html__( 'Set this to On to show image popup button on product list view.', 'citybook' ),
        //     'default'  => true,
        // ),
        

        array(
            'id' => 'shop_columns',
            'type' => 'select',
            'title' => esc_html__('Desktop Columns', 'citybook'),
            'desc' => esc_html__('Number of products per row on desktop view.','citybook'),
            'options' => array(
                            'one' => esc_html__('One column', 'citybook'),
                            'two' => esc_html__('Two columns', 'citybook'),
                            'three' => esc_html__('Three columns', 'citybook'),
                            'four' => esc_html__('Four columns', 'citybook'),
                            'five' => esc_html__('Five columns', 'citybook'),
                            'six' => esc_html__('Six columns', 'citybook'),
                            
                        ),
            'default' => 'three'
        ),


        array(
            'id' => 'shop_columns_tablet',
            'type' => 'select',
            'title' => esc_html__('Horizontal Tablet Columns', 'citybook'),
            'desc' => esc_html__('Number of products per row on tablet horizontal view.','citybook'),
            'options' => array(
                            'one' => esc_html__('One column', 'citybook'),
                            'two' => esc_html__('Two columns', 'citybook'),
                            'three' => esc_html__('Three columns', 'citybook'),
                            'four' => esc_html__('Four columns', 'citybook'),
                            'five' => esc_html__('Five columns', 'citybook'),
                            'six' => esc_html__('Six columns', 'citybook'),
                            
                        ),
            'default' => 'three'
        ),
        

        // array(
        //     'id'       => 'shop_show_header_mini_cart',
        //     'type'     => 'switch',
        //     'on'=> esc_html__('Yes', 'citybook'),
        //     'off'=> esc_html__('No', 'citybook'),
        //     'title'    => esc_html__( 'Show shopping cart on header?', 'citybook' ),
        //     'default'  => true,
        // ),

        
        // array(
        //     'id' => 'shop_layout',
        //     'type' => 'select',
        //     'title' => esc_html__('Shop Layout', 'citybook'),
        //     'options' => array(
        //                     'grid_layout' => esc_html__('Grid Layout', 'citybook'),
        //                     'list_layout' => esc_html__('List Layout', 'citybook'),
        //                 ),
        //     'default' => 'grid_layout'
        // ),

        // array(
        //     'id'       => 'shop_show_layout_switcher',
        //     'type'     => 'switch',
        //     'on'=> esc_html__('Yes', 'citybook'),
        //     'off'=> esc_html__('No', 'citybook'),
        //     'title'    => esc_html__( 'Show layout switch?', 'citybook' ),
        //     'default'  => true,
        // ),

        // array(
        //     'id'       => 'shop_show_product_list_excerpt',
        //     'type'     => 'switch',
        //     'on'=> esc_html__('Yes', 'citybook'),
        //     'off'=> esc_html__('No', 'citybook'),
        //     'title'    => esc_html__( 'Show product excerpt?', 'citybook' ),
        //     'default'  => true,
        // ),
        
    ),
) );
