<?php
/* banner-php */

Redux::setSection( $opt_name, array(
    'title' => esc_html__('Portfolio', 'citybook'),
    'id'         => 'portfolio-settings',
    'subsection' => false,
    
    'icon'       => 'el-icon-briefcase',
    'fields' => array(

        array(
            'id'       => 'folio_fullwidth_nav_menu',
            'type'     => 'switch',
            'title'    => esc_html__( 'Fullwidth Navigation Menu', 'citybook' ),
            // 'subtitle' => esc_html__( '', 'citybook' ),
            'default'  => false,
        ),

        array(
            'id'       => 'show_folio_header',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Portfolio Header', 'citybook' ),
            // 'subtitle' => esc_html__( '', 'citybook' ),
            'default'  => true,
        ),
        array(
                'id' => 'folio_home_text',
                'type' => 'text',
                'title' => esc_html__('Portfolio Heading Text', 'citybook'),
                // 'subtitle' => esc_html__('', 'citybook'),
                // 'desc' => esc_html__('', 'citybook'),
                'default' => 'Our <strong> portfolio </strong>'
            ),
        array(
                'id' => 'folio_home_text_intro',
                'type' => 'textarea',
                'title' => esc_html__('Portfolio Intro Text', 'citybook'),
                // 'subtitle' => esc_html__('', 'citybook'),
                // 'desc' => esc_html__('', 'citybook'),
                'default' => ''
            ),
        array(
                'id' => 'folio_header_video',
                'type' => 'text',
                'title' => esc_html__('Portfolio Header Video', 'citybook'),
                // 'subtitle' => esc_html__('', 'citybook'),
                'desc' => esc_html__('Please enter your Youtube video ID (ex: oDpSPNIozt8 ) here to use header background video feature or leave empty to use header background image selected bellow.', 'citybook'),
                'default' => ''
            ),
        array(
            'id' => 'folio_header_image',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Portfolio Header Image', 'citybook'),
            //'compiler' => 'true',
            //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
            // 'desc' => esc_html__('Upload your blog header image', 'citybook'),
            // 'subtitle' => esc_html__('', 'citybook'),
            'default' => array('url' => get_template_directory_uri().'/assets/images/bg/17.jpg'),
        ),
        array(
            'id'       => 'show_folio_breadcrumbs',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Breadcrumbs', 'citybook' ),
            // 'subtitle' => esc_html__( '', 'citybook' ),
            'default'  => true,
        ),

        array(
            'id'       => 'show_folio_footer_content',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Content Footer', 'citybook' ),
            // 'subtitle' => esc_html__( '', 'citybook' ),
            'default'  => true,
        ),

        array(
            'id' => 'folio_style',
            'type' => 'select',
            'title' => esc_html__('Portfolio Layout', 'citybook'),
            // 'subtitle' => esc_html__('', 'citybook'),
            'desc' => '',
            'options' => array(
                            'horizontal' => 'Horizontal',
                            'horizontal_boxed' => 'Horizontal Boxed',
                            'vertical' => 'Vertical', 
                            'vertical_fullscreen' => 'Vertical Fullscreen', 
                            'parallax' => 'Parallax', 
                            //'gallery_masonry' => 'Gallery Masonry', 
                            //'gallery_grid' => 'Gallery Grid',
             ), //Must provide key => value pairs for select options
            'default' => 'parallax'
        ),
        array(
            'id' => 'folio_column',
            'type' => 'select',
            'title' => esc_html__('Portfolio Columns', 'citybook'),
            // 'subtitle' => esc_html__('', 'citybook'),
            'desc' => esc_html__('Vertical columns for Horizontal layout', 'citybook'),
            'options' => array('five' => 'Five Columns','four' => 'Four Columns', 'three' => 'Three Columns','two' => 'Two Columns', 'one' => 'One Column'), //Must provide key => value pairs for select options
            'default' => 'two'
        ),
        array(
            'id'       => 'folio_show_filter',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Filter', 'citybook' ),
            // 'subtitle' => esc_html__( '', 'citybook' ),
            'default'  => true,
        ),
        array(
            'id'       => 'folio_show_counter',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Counter', 'citybook' ),
            // 'subtitle' => esc_html__( '', 'citybook' ),
            'default'  => true,
        ),
        array(
            'id'       => 'folio_posts_per_page',
            'type'     => 'text',
            'title'    => esc_html__( 'Posts per page', 'citybook' ),
            'subtitle' => esc_html__( 'Number of post to show per page, -1 to show all posts.', 'citybook' ),
            'default'  => 10,
        ),
        array(
            'id' => 'folio_filter_orderby',
            'type' => 'select',
            'title' => esc_html__('Order Filter By', 'citybook'),
            // 'subtitle' => esc_html__('', 'citybook'),
            'desc' => '',
            'options' => array(
                            'id' => esc_html__( 'ID', 'citybook' ), 
                            'count' => esc_html__( 'Count', 'citybook' ),
                            'name' => esc_html__( 'Name', 'citybook' ), 
                            'slug' => esc_html__( 'Slug', 'citybook' ),
                            'none' => esc_html__( 'None', 'citybook' )
                        ), //Must provide key => value pairs for select options
            'default' => 'name'
        ),
        array(
            'id' => 'folio_filter_order',
            'type' => 'select',
            'title' => esc_html__('Order Filter', 'citybook'),
            // 'subtitle' => esc_html__('', 'citybook'),
            'desc' => '',
            'options' => array(
                            'ASC' => esc_html__( 'Ascending', 'citybook' ), 
                            'DESC' => esc_html__( 'Descending', 'citybook' ),
                        ), //Must provide key => value pairs for select options
            'default' => 'ASC'
        ),
        array(
            'id' => 'folio_archive_orderby',
            'type' => 'select',
            'title' => esc_html__('Order Portfolio By', 'citybook'),
            // 'subtitle' => esc_html__('', 'citybook'),
            'desc' => '',
            'options' => array(
                            'none' => esc_html__( 'None', 'citybook' ), 
                            'ID' => esc_html__( 'Post ID', 'citybook' ), 
                            'author' => esc_html__( 'Post Author', 'citybook' ),
                            'title' => esc_html__( 'Post title', 'citybook' ), 
                            'name' => esc_html__( 'Post name (post slug)', 'citybook' ),
                            'date' => esc_html__( 'Created Date', 'citybook' ),
                            'modified' => esc_html__( 'Last modified date', 'citybook' ),
                            'parent' => esc_html__( 'Post Parent id', 'citybook' ),
                            'rand' => esc_html__( 'Random', 'citybook' ),
                        ), //Must provide key => value pairs for select options
            'default' => 'date'
        ),
        array(
            'id' => 'folio_archive_order',
            'type' => 'select',
            'title' => esc_html__('Order Portfolio', 'citybook'),
            // 'subtitle' => esc_html__('', 'citybook'),
            'desc' => '',
            'options' => array(
                            'DESC' => esc_html__( 'Descending', 'citybook' ),
                            'ASC' => esc_html__( 'Ascending', 'citybook' ), 
                            
                        ), //Must provide key => value pairs for select options
            'default' => 'DESC'
        ),
        array(
            'id' => 'folio_show_info_first',
            'type' => 'select',
            'title' => esc_html__('Show Info', 'citybook'),
            // 'subtitle' => esc_html__('', 'citybook'),
            'desc' => '',
            'options' => array(
                            'show_on_hover' => esc_html__( 'Show On Hover', 'citybook' ),
                            'show' => esc_html__( 'Show', 'citybook' ), 
                            'hide' => esc_html__( 'Hide', 'citybook' ), 
                            
                        ), //Must provide key => value pairs for select options
            'default' => 'show_on_hover'
        ),
        
        array(
            'id' => 'folio_pad',
            'type' => 'select',
            'title' => esc_html__('Spacing', 'citybook'),
            'subtitle' => esc_html__('The space between portfolio grid items.', 'citybook'),
            'desc' => '',
            'options' => array(
                            'small' => esc_html__('Small','citybook'), 
                            'big' =>  esc_html__('Big','citybook'),
                            'none' =>  esc_html__('None','citybook'),
                        ), //Must provide key => value pairs for select options
            'default' => 'small'
        ),
        array(
            'id'       => 'folio_enable_gallery',
            'type'     => 'switch',
            'title'    => esc_html__( 'Enable Image Gallery on Portfolio Grid', 'citybook' ),
            // 'subtitle' => esc_html__( '', 'citybook' ),
            'default'  => false,
        ),
        array(
            'id'       => 'folio_disable_overlay',
            'type'     => 'switch',
            'title'    => esc_html__( 'Disbale Image Overlay Effect', 'citybook' ),
            // 'subtitle' => esc_html__( '', 'citybook' ),
            'default'  => false,
        ),
    ),
) );
