<?php
/* banner-php */

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Colors', 'citybook'),
    'id'         => 'styling-settings',
    'subsection' => false,

    'icon'       => 'el-icon-magic',
    'fields'     => array(
        array(
            'id'      => 'use_custom_color',
            'type'    => 'switch',
            'on'      => esc_html__('Yes', 'citybook'),
            'off'     => esc_html__('No', 'citybook'),
            'title'   => esc_html__('Use Custom Colors', 'citybook'),
            'desc'    => wp_kses(__('Set this option to <b>Yes</b> if you want to use color variants bellow.', 'citybook'), array('b' => array(), 'strong' => array(), 'p' => array())),
            'default' => true,

        ),

        array(
            'id'      => 'theme-color',
            'type'    => 'color',
            'title'   => esc_html__('Theme Color', 'citybook'),
            'desc'    => esc_html__('Default: #4DB7FE', 'citybook'),
            'default' => '#4DB7FE',
        ),
        array(
            'id'      => 'theme-color-second',
            'type'    => 'color',
            'title'   => esc_html__('Theme Secondary Color', 'citybook'),
            'desc'    => esc_html__('Default: #5ECFB1', 'citybook'),
            'default' => '#5ECFB1',
        ),
        array(
            'id'      => 'theme-color-third',
            'type'    => 'color',
            'title'   => esc_html__('Button Hover Color - Theme third color', 'citybook'),
            'desc'    => esc_html__('Default: #2F3B59', 'citybook'),
            'default' => '#2F3B59',
        ),
        array(
            'id'      => 'main-bg-color',
            'type'    => 'color',
            'title'   => esc_html__('Body Background Color', 'citybook'),
            'desc'    => esc_html__('Default: #2F3B59', 'citybook'),
            'default' => '',
        ),
        array(
            'id'      => 'loader-bg-color',
            'type'    => 'color',
            'title'   => esc_html__('Loader Background Color', 'citybook'),
            'desc'    => esc_html__('Default: #2F3B59', 'citybook'),
            'default' => '',
        ),
        array(
            'id'      => 'body-text-color',
            'type'    => 'color',
            'title'   => esc_html__('Body Text Color', 'citybook'),
            'desc'    => esc_html__('Default: #000', 'citybook'),
            'default' => '',
        ),
        array(
            'id'      => 'paragraph-color',
            'type'    => 'color',
            'title'   => esc_html__('Paragraph Color', 'citybook'),
            'desc'    => esc_html__('Default: #878C9F', 'citybook'),
            'default' => '',
        ),

        array(
            'id'      => 'link_colors',
            'type'    => 'link_color',
            'title'   => esc_html__('Link Color', 'citybook'),
            'default' => array(
                'regular' => '#000',
                'hover'   => '#4DB7FE',
                'active'  => '#000000',
            ),
            'active'  => true,
            'visited' => false,
        ),

        array(
            'id'      => 'header-bg-color',
            'type'    => 'color_rgba',
            'title'   => esc_html__('Header Bg Color', 'citybook'),
            'desc'    => esc_html__('Default: #2F3B59', 'citybook'),
            'default' => array(
                'color' => '#2F3B59',
                'alpha' => 1,
            ),
        ),
        array(
            'id'      => 'header-text-color',
            'type'    => 'color',
            'title'   => esc_html__('Header Color', 'citybook'),
            'desc'    => esc_html__('Default: #ffffff', 'citybook'),
            'default' => '',
        ),
        array(
            'id'      => 'submenu-bg-color',
            'type'    => 'color_rgba',
            'title'   => esc_html__('Submenu Background Color', 'citybook'),
            'desc'    => esc_html__('Default: #fff', 'citybook'),
            'default' => array(
                'color' => '#fff',
                'alpha' => 1,
            ),
        ),
        array(
            'id'      => 'menu_colors',
            'type'    => 'link_color',
            'title'   => esc_html__('Menu Color', 'citybook'),
            'default' => array(
                'regular' => '#fff',
                'hover'   => '#4DB7FE',
                'active'  => '#4DB7FE',
            ),
            'active'  => true,
            'visited' => false,
        ),
        array(
            'id'      => 'submenu_colors',
            'type'    => 'link_color',
            'title'   => esc_html__('Submenu Color', 'citybook'),
            'default' => array(
                'regular' => '#000000',
                'hover'   => '#4DB7FE',
                'active'  => '#4DB7FE',
            ),
            'active'  => true,
            'visited' => false,
        ),
        array(
            'id'      => 'footer-bg-color',
            'type'    => 'color_rgba',
            'title'   => esc_html__('Footer Background Color', 'citybook'),
            'desc'    => esc_html__('Default: #2C3B5A', 'citybook'),
            'default' => array(
                'color' => '#2C3B5A',
                'alpha' => 1,
            ),
        ),
        array(
            'id'      => 'footer-text-color',
            'type'    => 'color',
            'title'   => esc_html__('Footer Color', 'citybook'),
            'desc'    => esc_html__('Default: #878C9F', 'citybook'),
            'default' => '',
        ),
        array(
            'id'      => 'subfooter-bg-color',
            'type'    => 'color_rgba',
            'title'   => esc_html__('Footer Copyright Background Color', 'citybook'),
            'desc'    => esc_html__('Default: #2C3B5A', 'citybook'),
            'default' => array(
                'color' => '#2C3B5A',
                'alpha' => 1,
            ),
        ),

    ),
));
