<?php
/* banner-php */

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Blog Options', 'citybook'),
    'id'         => 'blog-settings',
    'subsection' => false,

    'icon'       => 'el-icon-website',
    'fields'     => array(
        array(
            'id'      => 'show_blog_header',
            'type'    => 'switch',
            'on'      => esc_html__('Yes', 'citybook'),
            'off'     => esc_html__('No', 'citybook'),
            'title'   => esc_html__('Show Header', 'citybook'),
            'default' => false,

        ),
        array(
            'id'      => 'blog_head_title',
            'type'    => 'text',
            'title'   => esc_html__('Header Title', 'citybook'),
            'default' => 'Our Last News',
        ),
        array(
            'id'      => 'blog_head_intro',
            'type'    => 'textarea',
            'title'   => esc_html__('Header Intro', 'citybook'),
            'default' => '<p class="head-intro">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut nec tincidunt arcu, sit amet fermentum sem.</p>',
        ),

        array(
            'id'      => 'blog_header_image',
            'type'    => 'image_id',
            'title'   => esc_html__('Header Background', 'citybook'),
            'default' => '',
        ),

        array(
            'id'      => 'blog_layout',
            'type'    => 'image_select',
            'title'   => esc_html__('Blog Sidebar Layout', 'citybook'),

            'options' => array(
                'fullwidth'     => array(
                    'alt' => 'Fullwidth',
                    'img' => get_template_directory_uri() . '/assets/redux/1col.png',
                ),
                'left_sidebar'  => array(
                    'alt' => 'Left Sidebar',
                    'img' => get_template_directory_uri() . '/assets/redux/2cl.png',
                ),
                'right_sidebar' => array(
                    'alt' => 'Right Sidebar',
                    'img' => get_template_directory_uri() . '/assets/redux/2cr.png',
                ),

            ),
            'default' => 'right_sidebar',
        ),

        array(
            'id'      => 'blog-sidebar-width',
            'type'    => 'select',
            'title'   => esc_html__('Sidebar Width', 'citybook'),
            'desc'       => esc_html__( 'Based on Bootstrap 12 columns.', 'citybook' ),
            'options' => array(
                '2' => esc_html__('2 Columns', 'citybook'),
        '3' => esc_html__('3 Columns', 'citybook'),
        '4' => esc_html__('4 Columns', 'citybook'),
        '5' => esc_html__('5 Columns', 'citybook'),
        '6' => esc_html__('6 Columns', 'citybook'),
            ),
            'default' => '4',
        ),

        array(
            'id'      => 'blog_show_format',
            'type'    => 'switch',
            'on'      => esc_html__('Yes', 'citybook'),
            'off'     => esc_html__('No', 'citybook'),
            'title'   => esc_html__('Show Post Format on posts page', 'citybook'),
            'default' => true,

        ),
        array(
            'id'      => 'blog_date',
            'type'    => 'switch',
            'on'      => esc_html__('Yes', 'citybook'),
            'off'     => esc_html__('No', 'citybook'),
            'title'   => esc_html__('Show Date', 'citybook'),
            'default' => true,

        ),
        array(
            'id'      => 'blog_author',
            'type'    => 'switch',
            'on'      => esc_html__('Yes', 'citybook'),
            'off'     => esc_html__('No', 'citybook'),
            'title'   => esc_html__('Show Author', 'citybook'),
            'default' => false,

        ),

        array(
            'id'      => 'blog_cats',
            'type'    => 'switch',
            'on'      => esc_html__('Yes', 'citybook'),
            'off'     => esc_html__('No', 'citybook'),
            'title'   => esc_html__('Show Categories', 'citybook'),
            'default' => true,

        ),

        array(
            'id'      => 'blog_tags',
            'type'    => 'switch',
            'on'      => esc_html__('Yes', 'citybook'),
            'off'     => esc_html__('No', 'citybook'),
            'title'   => esc_html__('Show Tags', 'citybook'),
            'default' => true,

        ),

        array(
            'id'      => 'blog_comments',
            'type'    => 'switch',
            'on'      => esc_html__('Yes', 'citybook'),
            'off'     => esc_html__('No', 'citybook'),
            'title'   => esc_html__('Show Comments', 'citybook'),
            'default' => false,

        ),



    ),
));
