<?php
/* banner-php */
/**
 * CityBook: Kirki Customizer
 *
 */
add_action( 'customize_register', function( $wp_customize ) {
	/**
	 * The custom control class
	 */
	class Kirki_Controls_Thumbnail_Size_Control extends WP_Customize_Control {
		public $type = 'thumbnail_size';

		public function __construct( $manager, $id, $args = array() ) {

			parent::__construct( $manager, $id, $args );
			add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_scripts' ), 999 );

		}

		/**
		 * Enqueue control related scripts/styles.
		 *
		 * @access public
		 */
		public function enqueue_scripts() {
			wp_enqueue_style( 'cth-thumbnail_size-css', get_theme_file_uri( '/assets/admin/css/thumbnail_size.css' ), null );
			wp_enqueue_script( 'cth-thumbnail_size', get_theme_file_uri( '/assets/admin/js/thumbnail_size.js' ), array( 'jquery', 'customize-base'), false, true );
			
		}

		/**
		 * Refresh the parameters passed to the JavaScript via JSON.
		 *
		 * @see WP_Customize_Control::to_json()
		 */
		public function to_json() {
			parent::to_json();

			$this->json['default'] = $this->setting->default;
			if ( isset( $this->default ) ) {
				$this->json['default'] = $this->default;
			}
			$this->json['value']   = $this->sanitize( $this->value() ) ;
			$this->json['choices'] = $this->choices;
			$this->json['link']    = $this->get_link();
			$this->json['id']      = $this->id;

			$this->json['inputAttrs'] = '';
			foreach ( $this->input_attrs as $attr => $value ) {
				$this->json['inputAttrs'] .= $attr . '="' . esc_attr( $value ) . '" ';
			}

			foreach ( array_keys( $this->json['value'] ) as $key ) {
				if ( ! in_array( $key, array( 'width', 'height', 'hard_crop' ) ) && ! isset( $this->json['default'][ $key ] ) ) {
					unset( $this->json['value'][ $key ] );
				}
			}

			// Fix for https://github.com/aristath/kirki/issues/1405.
			foreach ( array_keys( $this->json['value'] ) as $key ) {
				if ( isset( $this->json['default'][ $key ] ) && false === $this->json['default'][ $key ] ) {
					unset( $this->json['value'][ $key ] );
				}
			}
		}

		protected  function sanitize( $value ) {

			if ( ! is_array( $value ) ) {
				return array();
			}

			foreach ( $value as $key => $val ) {
				switch ( $key ) {
					case 'width':
						$value['width'] = esc_attr( $val );
						break;
					case 'height':
						$value['height'] = esc_attr( $val );
						break;
					case 'hard_crop':
						if ( ! isset($val) ) {
							$value['hard_crop'] = '1';
						}
						break;
					
				} // End switch().
			} // End foreach().

			return $value;

		}

		/**
		 * An Underscore (JS) template for this control's content (but not its container).
		 *
		 * Class variables for this control class are available in the `data` JS object;
		 * export custom variables by overriding {@see WP_Customize_Control::to_json()}.
		 *
		 * @see WP_Customize_Control::print_template()
		 *
		 * @access protected
		 */
		protected function content_template() {
			?>
			<label class="customizer-text">
				<# if ( data.label ) { #><span class="customize-control-title">{{{ data.label }}}</span><# } #>
				<# if ( data.description ) { #><span class="description customize-control-description">{{{ data.description }}}</span><# } #>
			</label>

			<div class="wrapper">
				
				<div class="field-thumbnail-size-input input-prepend thumbnail_size-width">
                   	<span class="add-on"><?php esc_html_e( 'W', 'citybook' );?></span>
                    <label for="{{ data.id }}-width"><?php esc_html_e( 'Image Width', 'citybook' );?></label>
                    <input {{{ data.inputAttrs }}} placeholder="<?php esc_html_e( 'Width', 'citybook' );?>" type="text" id="{{ data.id }}-width" name="_customize-thumbnail_size-width-{{ data.id }}" value="{{ data.value['width'] }}">
                </div>

                <div class="field-thumbnail-size-input input-prepend"><span  class="ts-add-on"><?php esc_html_e( ' x ', 'citybook' );?></span></div>

                <div class="field-thumbnail-size-input input-prepend thumbnail_size-height">
                   	<span class="add-on"><?php esc_html_e( 'H', 'citybook' );?></span>
                    <label for="{{ data.id }}-height"><?php esc_html_e( 'Image Height', 'citybook' );?></label>
                    <input {{{ data.inputAttrs }}} placeholder="<?php esc_html_e( 'Height', 'citybook' );?>" type="text" id="{{ data.id }}-height" name="_customize-thumbnail_size-height-{{ data.id }}" value="{{ data.value['height'] }}">
                </div>

                <div class="field-thumbnail-size-input input-prepend"><span  class="ts-add-on"><?php esc_html_e( ' px ', 'citybook' );?></span></div>

                <div class="field-thumbnail-size-input thumbnail_size-hard_crop">
	                <label for="{{ data.id }}-hard_crop">
		                <input type="checkbox" id="{{ data.id }}-hard_crop" name="_customize-thumbnail_size-hard_crop-{{ data.id }}" value="1" <# if ( data.value['hard_crop'] === '1' ) { #> checked="checked"<# } #>>
		            	<?php esc_html_e( 'Hard Crop ', 'citybook' );?>
		            </label>
                    
                </div>
				
			</div>
			<#
			
			valueJSON = JSON.stringify( data.value ).replace( /'/g, '&#39' );
			#>
			<input class="thumbnail_size-hidden-value" type="text" name="{{ data.id }}" value='{{{ valueJSON }}}' {{{ data.link }}}>
			<?php
		}	

		/**
		 * Render the control's content.
		 *
		 * @see WP_Customize_Control::render_content()
		 */
		protected function render_content() {}
	}
	// Register the class so that it's JS template is available in the Customizer.
    $wp_customize->register_control_type( 'Kirki_Controls_Thumbnail_Size_Control' );

	// Register our custom control with Kirki
	add_filter( 'kirki/control_types', function( $controls ) {
		$controls['thumbnail_size'] = 'Kirki_Controls_Thumbnail_Size_Control';
		return $controls;
	} );

} );

// https://aristath.github.io/kirki/docs/getting-started/config.html
CityBook_Kirki::add_config( 'citybook_configs', array(
	'capability'    => 'edit_theme_options',
	'option_type'   => 'option', // theme_mod option
	'option_name'	=> 'citybook_options' // for option type
) );
// https://wordpress.stackexchange.com/questions/280278/site-identity-section-name
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'image',
	'settings'    => 'mobile_logo',
	'label'       => esc_html__( 'Mobile Logo', 'citybook' ),
	'section'     => 'title_tagline',
	'default'     => '',
	'priority'    => 8,
	'choices'     => array(
		'save_as' => 'id',
	),
	
) );


CityBook_Kirki::add_section( 'general_options', array(
    'title'          => esc_html__( 'General Options', 'citybook' ),
    'panel'          => '', // Not typically needed.
    'priority'       => 120,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '', // Rarely needed.
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'toggle',
	'settings'    => 'show_loader',
	'label'       => esc_html__( 'Show Loader', 'citybook' ),
	'section'     => 'general_options',
	'default'     => '1',
	'priority'    => 10,
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'image',
	'settings'    => 'loader_icon',
	'label'       => esc_html__( 'Loader Icon', 'citybook' ),
	'section'     => 'general_options',
	'default'     => '',
	'priority'    => 10,
	'choices'     => array(
		'save_as' => 'id',
	),
	
) );

CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'toggle',
	'settings'    => 'enable_auto_update',
	'label'       => esc_html__( 'Enable Auto Update', 'citybook' ),
	'description' => esc_html__( 'Note: auto update feature is not for Envato Elements download.', 'citybook' ),
	'section'     => 'general_options',
	'default'     => '0',
	'priority'    => 10,
) );


CityBook_Kirki::add_section( 'header_options', array(
    'title'          => esc_html__( 'Header Options', 'citybook' ),
    'panel'          => '', // Not typically needed.
    'priority'       => 130,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '', // Rarely needed.
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'textarea',
	'settings'    => 'header_info',
	'label'       => esc_html__( 'Header Contacts Info', 'citybook' ),
	'description'       => esc_html__( 'Enter header contacts info for your site. Notice: only visible on large screen.', 'citybook' ),
	'section'     => 'header_options',
	'default'     => '',
	'priority'    => 10,
) );

CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'toggle',
	'settings'    => 'show_fixed_search',
	'label'       => esc_html__( 'Show Search', 'citybook' ),
	'section'     => 'header_options',
	'default'     => '1',
	'priority'    => 10,
) );

CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'toggle',
	'settings'    => 'show_mini_cart',
	'label'       => esc_html__( 'Show Cart', 'citybook' ),
	'section'     => 'header_options',
	'default'     => '1',
	'priority'    => 10,
) );

CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'select',
	'settings'    => 'user_menu_style',
	'label'       => esc_html__( 'Logged In Avatar', 'citybook' ),
	'section'     => 'header_options',
	'default'     => 'two',
	'priority'    => 10,
	'multiple'    => 0,
	'choices'     => array(
		'one' => esc_html__('Style One', 'citybook'),
        'two' => esc_html__('Style Two', 'citybook'),
	),
) );


CityBook_Kirki::add_section( 'thumbnails_options', array(
    'title'          => esc_html__( 'Thumbnail Sizes', 'citybook' ),
    'description'	=> esc_html__( 'These settings affect the display and dimensions of images in your pages.
Enter 9999 as Width value and uncheck Hard Crop to make your thumbnail dynamic width.
Enter 9999 as Height value and uncheck Hard Crop to make your thumbnail dynamic height.
Enter 9999 as Width and Height values to use full size image.
After changing these settings you may need using Regenerate Thumbnails plugin to regenerate your thumbnails', 'citybook' ),
    'panel'          => '', // Not typically needed.
    'priority'       => 140,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '', // Rarely needed.
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'toggle',
	'settings'    => 'enable_custom_sizes',
	'label'       => esc_html__( 'Enable Custom Image Sizes', 'citybook' ),
	'section'     => 'thumbnails_options',
	'default'     => '1',
	'priority'    => 10,
	'transport'		=> 'postMessage',
) );

// CityBook_Kirki::add_field( 'citybook_configs', array(
// 	'type'        => 'thumbnail_size',
// 	'settings'    => 'thumb_size_opt_1',
// 	'label'       => esc_html__( 'Fullscreen Thumbnail', 'citybook' ),
// 	'description'       => esc_html__( 'Demo: Width - 1920, Height - 754, Hard crop - checked', 'citybook' ),
// 	'section'     => 'thumbnails_options',
// 	'transport'		=> 'postMessage',
// 	'default'     => array(
// 		'width'		=> '1920',
// 		'height'	=> '754',
// 		'hard_crop'	=> '1',
// 	),
// 	'priority'    => 10,
	
// ) );
// CityBook_Kirki::add_field( 'citybook_configs', array(
// 	'type'        => 'thumbnail_size',
// 	'settings'    => 'thumb_size_opt_2',
// 	'label'       => esc_html__( 'Carousel Thumbnail', 'citybook' ),
// 	'description'       => esc_html__( 'Demo: Width - 9999, Height - 754, Hard crop - un-checked', 'citybook' ),
// 	'section'     => 'thumbnails_options',
// 	'transport'		=> 'postMessage',
// 	'default'     => array(
// 		'width'		=> '9999',
// 		'height'	=> '754',
// 		'hard_crop'	=> '0',
// 	),
// 	'priority'    => 10,
	
// ) );

CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'thumbnail_size',
	'settings'    => 'thumb_size_opt_3',
	'label'       => esc_html__( 'Listing Gallery', 'citybook' ),
	'description'       => esc_html__( 'Demo: Width - 424, Height - 280, Hard crop - checked', 'citybook' ),
	'section'     => 'thumbnails_options',
	'transport'		=> 'postMessage',
	'default'     => array(
		'width'		=> '424',
		'height'	=> '280',
		'hard_crop'	=> '1',
	),
	'priority'    => 10,
	
) );

CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'thumbnail_size',
	'settings'    => 'thumb_size_opt_4',
	'label'       => esc_html__( 'Listing Grid', 'citybook' ),
	'description'       => esc_html__( 'Demo: Width - 424, Height - 280, Hard crop - checked', 'citybook' ),
	'section'     => 'thumbnails_options',
	'transport'		=> 'postMessage',
	'default'     => array(
		'width'		=> '424',
		'height'	=> '280',
		'hard_crop'	=> '1',
	),
	'priority'    => 10,
	
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'thumbnail_size',
	'settings'    => 'thumb_size_opt_5',
	'label'       => esc_html__( 'Listing Category Size One', 'citybook' ),
	'description'       => esc_html__( 'Demo: Width - 388, Height - 257, Hard crop - checked', 'citybook' ),
	'section'     => 'thumbnails_options',
	'transport'		=> 'postMessage',
	'default'     => array(
		'width'		=> '388',
		'height'	=> '257',
		'hard_crop'	=> '1',
	),
	'priority'    => 10,
	
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'thumbnail_size',
	'settings'    => 'thumb_size_opt_6',
	'label'       => esc_html__( 'Listing Category Size Two', 'citybook' ),
	'description'       => esc_html__( 'Demo: Width - 795, Height - 257, Hard crop - checked', 'citybook' ),
	'section'     => 'thumbnails_options',
	'transport'		=> 'postMessage',
	'default'     => array(
		'width'		=> '795',
		'height'	=> '257',
		'hard_crop'	=> '1',
	),
	'priority'    => 10,
	
) );

CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'thumbnail_size',
	'settings'    => 'thumb_size_opt_7',
	'label'       => esc_html__( 'Listing Category Size Three', 'citybook' ),
	'description'       => esc_html__( 'Demo: Width - 1200, Height - 532, Hard crop - checked', 'citybook' ),
	'section'     => 'thumbnails_options',
	'transport'		=> 'postMessage',
	'default'     => array(
		'width'		=> '1200',
		'height'	=> '532',
		'hard_crop'	=> '1',
	),
	'priority'    => 10,
	
) );

CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'thumbnail_size',
	'settings'    => 'thumb_size_opt_8',
	'label'       => esc_html__( 'Post Grid Thumbanil', 'citybook' ),
	'description'       => esc_html__( 'Demo: Width - 381, Height - 240, Hard crop - checked', 'citybook' ),
	'section'     => 'thumbnails_options',
	'transport'		=> 'postMessage',
	'default'     => array(
		'width'		=> '381',
		'height'	=> '240',
		'hard_crop'	=> '1',
	),
	'priority'    => 10,
	
) );

CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'thumbnail_size',
	'settings'    => 'thumb_size_opt_9',
	'label'       => esc_html__( 'Blog Thumbnail', 'citybook' ),
	'description'       => esc_html__( 'Demo: Width - 806, Height - 530, Hard crop - checked', 'citybook' ),
	'section'     => 'thumbnails_options',
	'transport'		=> 'postMessage',
	'default'     => array(
		'width'		=> '806',
		'height'	=> '530',
		'hard_crop'	=> '1',
	),
	'priority'    => 10,
	
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'thumbnail_size',
	'settings'    => 'thumb_size_opt_10',
	'label'       => esc_html__( 'Blog Single Thumbnail', 'citybook' ),
	'description'       => esc_html__( 'Demo: Width - 806, Height - 530, Hard crop - checked', 'citybook' ),
	'section'     => 'thumbnails_options',
	'transport'		=> 'postMessage',
	'default'     => array(
		'width'		=> '806',
		'height'	=> '530',
		'hard_crop'	=> '1',
	),
	'priority'    => 10,
	
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'thumbnail_size',
	'settings'    => 'thumb_size_opt_11',
	'label'       => esc_html__( 'Recent Post Widget', 'citybook' ),
	'description'       => esc_html__( 'Demo: Width - 82, Height - 54, Hard crop - checked', 'citybook' ),
	'section'     => 'thumbnails_options',
	'transport'		=> 'postMessage',
	'default'     => array(
		'width'		=> '82',
		'height'	=> '54',
		'hard_crop'	=> '1',
	),
	'priority'    => 10,
	
) );






CityBook_Kirki::add_section( 'color_options', array(
    'title'          => esc_html__( 'Colors & Fonts - Options', 'citybook' ),
    'panel'          => '', // Not typically needed.
    'priority'       => 150,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '', // Rarely needed.
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'toggle',
	'settings'    => 'use_custom_color',
	'label'       => esc_html__( 'Use Custom Colors', 'citybook' ),
	'description'       => wp_kses(__('Set this option to <b>Yes</b> if you want to use color variants bellow.', 'citybook'), array('b'=>array(),'strong'=>array(),'p'=>array()) ),
	'section'     => 'color_options',
	'default'     => '0',
	'priority'    => 10,
) );

CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'color',
	'settings'    => 'theme-color',
	'label'       => esc_html__( 'Theme Color', 'citybook' ), 
	'description'       => esc_html__( 'Default: #4DB7FE', 'citybook' ),
	'section'     => 'color_options',
	'default'     => '#4DB7FE',
	'priority'    => 10,
	
) );

CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'color',
	'settings'    => 'theme-color-second',
	'label'       => esc_html__( 'Theme Secondary Color', 'citybook' ),
	'description'       => esc_html__( 'Default: #5ECFB1', 'citybook' ),
	'section'     => 'color_options',
	'default'     => '#5ECFB1',
	'priority'    => 10,
	
) );

CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'color',
	'settings'    => 'theme-color-third',
	'label'       => esc_html__( 'Button Hover Color - Theme third color', 'citybook' ),
	'description'       => esc_html__( 'Default: #2F3B59', 'citybook' ),
	'section'     => 'color_options',
	'default'     => '#2F3B59',
	'priority'    => 10,
	
) );

CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'color',
	'settings'    => 'main-bg-color',
	'label'       => esc_html__( 'Body Background Color', 'citybook' ),
	'description'       => esc_html__( 'Default: #2F3B59', 'citybook' ),
	'section'     => 'color_options',
	'default'     => '',
	'priority'    => 10,
	'transport'		=> 'auto',
	'output' 		=> array(
		array(
			'element'  => 'body',
			'property' => 'background-color',
		),
	),
) );

CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'color',
	'settings'    => 'loader-bg-color',
	'label'       => esc_html__( 'Loader Background Color', 'citybook' ),
	'description'       => esc_html__( 'Default: #2F3B59', 'citybook' ),
	'section'     => 'color_options',
	'default'     => '',
	'priority'    => 10,
	'transport'		=> 'auto',
	'output' 		=> array(
		array(
			'element'  => '.loader-wrap',
			'property' => 'background-color',
		),
	),
) );

CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'color',
	'settings'    => 'body-text-color',
	'label'       => esc_html__( 'Body Text Color', 'citybook' ),
	'description'       => esc_html__( 'Default: #000000', 'citybook' ),
	'section'     => 'color_options',
	'default'     => '',
	'priority'    => 10,
	'transport'		=> 'auto',
	'output' 		=> array(
		array(
			'element'  => 'body',
			'property' => 'color',
		),
	),
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'color',
	'settings'    => 'paragraph-color',
	'label'       => esc_html__( 'Paragraph Color', 'citybook' ),
	'description'       => esc_html__( 'Default: #878C9F', 'citybook' ),
	'section'     => 'color_options',
	'default'     => '',
	'priority'    => 10,
	'transport'		=> 'auto',
	'output' 		=> array(
		array(
			'element'  => 'p',
			'property' => 'color',
		),
	),
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'color',
	'settings'    => 'link_color',
	'label'       => esc_html__( 'Link Color', 'citybook' ),
	'description'       => esc_html__( 'Default: #000000', 'citybook' ),
	'section'     => 'color_options',
	'default'     => '',
	'priority'    => 10,
	'transport'		=> 'auto',
	'output' 		=> array(
		array(
			'element'  => 'a',
			'property' => 'color',
		),
	),
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'color',
	'settings'    => 'link_hover_color',
	'label'       => esc_html__( 'Link Hover Color', 'citybook' ),
	'description'       => esc_html__( 'Default: #4DB7FE', 'citybook' ),
	'section'     => 'color_options',
	'default'     => '',
	'priority'    => 10,
	'transport'		=> 'auto',
	'output' 		=> array(
		array(
			'element'  => 'a:hover',
			'property' => 'color',
		),
	),
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'color',
	'settings'    => 'link_active_color',
	'label'       => esc_html__( 'Link Active Color', 'citybook' ),
	'description'       => esc_html__( 'Default: #000000', 'citybook' ),
	'section'     => 'color_options',
	'default'     => '',
	'priority'    => 10,
	'transport'		=> 'auto',
	'output' 		=> array(
		array(
			'element'  => 'a:active,a:focus',
			'property' => 'color',
		),
	),
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        	=> 'color',
	'settings'    	=> 'header-bg-color',
	'label'       	=> esc_html__( 'Header Bg Color', 'citybook' ),
	'description'       => esc_html__( 'Default: #2F3B59', 'citybook' ),
	'section'     	=> 'color_options',
	'default'     	=> '',
	'choices'     	=> array(
		'alpha' 	=> true,
	),
	'priority'    	=> 10,
	'transport'		=> 'auto',
	'output' 		=> array(
		array(
			'element'  => 'header.main-header',
			'property' => 'background-color',
		),
	),

	
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'color',
	'settings'    => 'header-text-color',
	'label'       => esc_html__( 'Header Color', 'citybook' ),
	'description'       => esc_html__( 'Default: #ffffff', 'citybook' ),
	'section'     => 'color_options',
	'default'     => '',
	'choices'     => array(
		'alpha' 	=> true,
	),
	'priority'    => 10,
	'transport'		=> 'auto',
	'output' 		=> array(
		array(
			'element'  => 'header.main-header',
			'property' => 'color',
		),
		
	),
) );  
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'color',
	'settings'    => 'submenu-bg-color',
	'label'       => esc_html__( 'Submenu Background Color', 'citybook' ),
	'description'       => esc_html__( 'Default: #ffffff', 'citybook' ),
	'section'     => 'color_options',
	'default'     => '',
	'choices'     => array(
		'alpha' 	=> true,
	),
	'priority'    => 10,
	'transport'		=> 'auto',
	'output' 		=> array(
		array(
			'element'  => '.nav-holder nav li ul',
			'property' => 'background-color',
		),
	),
) );          
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'color',
	'settings'    => 'mainmenu_color',
	'label'       => esc_html__( 'Menu Color', 'citybook' ),
	'description'       => esc_html__( 'Default: #ffffff', 'citybook' ),
	'section'     => 'color_options',
	'default'     => '',
	'priority'    => 10,
	'transport'		=> 'auto',
	'output' 		=> array(
		array(
			'element'  => '.nav-holder nav li a',
			'property' => 'color',
		),
	),
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'color',
	'settings'    => 'mainmenu_hover_color',
	'label'       => esc_html__( 'Menu Hover Color', 'citybook' ),
	'description'       => esc_html__( 'Default: #4DB7FE', 'citybook' ),
	'section'     => 'color_options',
	'default'     => '',
	'priority'    => 10,
	'transport'		=> 'auto',
	'output' 		=> array(
		array(
			'element'  => '.nav-holder nav li a:hover',
			'property' => 'color',
		),
	),
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'color',
	'settings'    => 'mainmenu_active_color',
	'label'       => esc_html__( 'Menu Active Color', 'citybook' ),
	'description'       => esc_html__( 'Default: #4DB7FE', 'citybook' ),
	'section'     => 'color_options',
	'default'     => '',
	'priority'    => 10,
	'transport'		=> 'auto',
	'output' 		=> array(
		array(
			'element'  => '.nav-holder nav li a:active,.nav-holder nav li a:focus, .nav-holder nav li.current-menu-ancestor > a, .nav-holder nav li.current-menu-parent > a,.nav-holder nav li.current-menu-item > a',
			'property' => 'color',
		),
	),
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'color',
	'settings'    => 'submenu_color',
	'label'       => esc_html__( 'Submenu Color', 'citybook' ),
	'description'       => esc_html__( 'Default: #000000', 'citybook' ),
	'section'     => 'color_options',
	'default'     => '',
	'priority'    => 10,
	'transport'		=> 'auto',
	'output' 		=> array(
		array(
			'element'  => '.nav-holder nav li ul a',
			'property' => 'color',
		),
	),
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'color',
	'settings'    => 'submenu_hover_color',
	'label'       => esc_html__( 'Submenu Hover Color', 'citybook' ),
	'description'       => esc_html__( 'Default: #4DB7FE', 'citybook' ),
	'section'     => 'color_options',
	'default'     => '',
	'priority'    => 10,
	'transport'		=> 'auto',
	'output' 		=> array(
		array(
			'element'  => '.nav-holder nav li ul a:hover',
			'property' => 'color',
		),
	),
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'color',
	'settings'    => 'submenu_active_color',
	'label'       => esc_html__( 'Submenu Active Color', 'citybook' ),
	'description'       => esc_html__( 'Default: #4DB7FE', 'citybook' ),
	'section'     => 'color_options',
	'default'     => '',
	'priority'    => 10,
	'transport'		=> 'auto',
	'output' 		=> array(
		array(
			'element'  => '.nav-holder nav li ul li a:active,.nav-holder nav li ul li a:focus,.nav-holder nav li ul li.current-menu-ancestor > a,.nav-holder nav li ul li.current-menu-parent > a,.nav-holder nav li ul li.current-menu-item > a',
			'property' => 'color',
		),
	),
) );           

CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'color',
	'settings'    => 'footer-bg-color',
	'label'       => esc_html__( 'Footer Background Color', 'citybook' ),
	'description'       => esc_html__( 'Default: #2C3B5A', 'citybook' ),
	'section'     => 'color_options',
	'default'     => '',
	'choices'     => array(
		'alpha' 	=> true,
	),
	'priority'    => 10,
	'transport'		=> 'auto',
	'output' 		=> array(
		array(
			'element'  => 'footer.citybook-footer',
			'property' => 'background-color',
		),
	),
) );           
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'color',
	'settings'    => 'footer-text-color',
	'label'       => esc_html__( 'Footer Color', 'citybook' ),
	'description'       => esc_html__( 'Default: #878C9F', 'citybook' ),
	'section'     => 'color_options',
	'default'     => '',
	'choices'     => array(
		'alpha' 	=> true,
	),
	'priority'    => 10,
	'transport'		=> 'auto',
	'output' 		=> array(
		array(
			'element'  => 'footer.citybook-footer,.footer-counter,.footer-social li a',
			'property' => 'color',
		),
	),
) );   

CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'color',
	'settings'    => 'subfooter-bg-color',
	'label'       => esc_html__( 'Footer Copyright Background Color', 'citybook' ),
	'description'       => esc_html__( 'Default: #2C3B5A', 'citybook' ),
	'section'     => 'color_options',
	'default'     => '',
	'choices'     => array(
		'alpha' 	=> true,
	),
	'priority'    => 10,
	'transport'		=> 'auto',
	'output' 		=> array(
		array(
			'element'  => '.sub-footer',
			'property' => 'background-color',
		),
	),
) ); 

CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'typography',
	'settings'    => 'body-font',
	'label'       => esc_html__( 'Body Font', 'citybook' ),
	'description'       => wp_kses(__('<p>Specify the body font properties.</br> Default </br>font-family: Quicksand </br>font-size: 13px </br>font-weight: 400</p>', 'citybook'), array( 'br'=>array(),'p'=>array(), ) ),
	'section'     => 'color_options',
	'default'     => array(
		'font-family'    => 'Quicksand',
	),
	'priority'    => 10,
	'transport'		=> 'auto',
	'output' 		=> array(
		array(
			'element'  => 'body',
		),
		array(
			'element' => '.custom-form  input::-webkit-input-placeholder , .custom-form  textarea::-webkit-input-placeholder',
		)
	),
) );          
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'typography',
	'settings'    => 'heading-font',
	'label'       => esc_html__( 'Heading Font', 'citybook' ),
	'description'       => wp_kses(__('<p>Specify the body font properties.</br> Default </br>font-family: Quicksand', 'citybook'), array( 'br'=>array(),'p'=>array(), ) ),
	'section'     => 'color_options',
	'default'     => array(
		'font-family'    => 'Quicksand',
	),
	'priority'    => 10,
	'transport'		=> 'auto',
	'output' 		=> array(
		array(
			'element'  => 'h1,h2,h3,h4,h5,h6',
		),
	),
) ); 
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'typography',
	'settings'    => 'paragraph-font',
	'label'       => esc_html__( 'Paragraph Font', 'citybook' ),
	'description'       => wp_kses(__('<p>Specify the body font properties.</br> Default </br>font-family: Quicksand </br>font-size: 12px </br>font-weight: 400</p>', 'citybook'), array( 'br'=>array(),'p'=>array(), ) ),
	'section'     => 'color_options',
	'default'     => array(
		'font-family'    => 'Quicksand',
	),
	'priority'    => 10,
	'transport'		=> 'auto',
	'output' 		=> array(
		array(
			'element'  => 'p',
		),
	),
) ); 
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'typography',
	'settings'    => 'theme-bolder-font',
	'label'       => esc_html__( 'CityBook Bolder Font', 'citybook' ),
	'description'       => wp_kses(__('<p>Specify the body font properties.</br> Default </br>font-family: Montserrat', 'citybook'), array( 'br'=>array(),'p'=>array(), ) ),
	'section'     => 'color_options',
	'default'     => array(
		'font-family'    => 'Montserrat',
	),
	'priority'    => 10,
	'transport'		=> 'auto',
	'output' 		=> array(
		array(
			'element'  => '.main-register h3 span,.images-collage-title,.footer-menu  li a,.error-wrap h2,.cs-countdown-item span',
		),
	),
) ); 
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'typography',
	'settings'    => 'theme-italic-font',
	'label'       => esc_html__( 'CityBook Italic Font', 'citybook' ),
	'description'       => wp_kses(__('<p>Specify the body font properties.</br> Default </br>font-family: Georgia </br>font-style: italic</p>', 'citybook'), array( 'br'=>array(),'p'=>array(), ) ),
	'section'     => 'color_options',
	'default'     => array(
		'font-family'    => 'Georgia',
		'variant'        => 'italic',
	),
	'priority'    => 10,
	'transport'		=> 'auto',
	'output' 		=> array(
		array(
			'element'  => 'blockquote p,.price-num-desc,.testimonilas-text p,.testimonilas-text li a,.footer-widget .about-widget h4,.video-item p',
		),
	),
) ); 




// for blog settings
CityBook_Kirki::add_panel( 'blog_panel', array(
    'priority'    => 160,
    'title'       => esc_html__( 'Blog Options', 'citybook' ),
    'description' => esc_html__( 'My Description', 'citybook' ),
) );


CityBook_Kirki::add_section( 'blog_header', array(
    'title'          => esc_html__( 'Blog Header', 'citybook' ),
    'description'    => esc_html__( 'These options are for your blog list page: ' , 'citybook') .esc_url(home_url('?post_type=post' )),
    'panel'          => 'blog_panel', // Not typically needed.
    'priority'       => 160,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '', // Rarely needed.
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'toggle',
	'settings'    => 'show_blog_header',
	'label'       => esc_html__( 'Show Header', 'citybook' ),
	'section'     => 'blog_header',
	'default'     => '0',
	'priority'    => 10,
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'text',
	'settings'    => 'blog_head_title',
	'label'       => esc_html__( 'Header Title', 'citybook' ),
	'section'     => 'blog_header',
	'default'     => 'Our Last News',
	'priority'    => 10,
	
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'textarea',
	'settings'    => 'blog_head_intro',
	'label'       => esc_html__( 'Header Intro', 'citybook' ),
	'section'     => 'blog_header',
	'default'     => '<p class="head-intro">Praesent nec leo venenatis elit semper aliquet id ac enim.</p>',
	'priority'    => 10,
	
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'image',
	'settings'    => 'blog_header_image',
	'label'       => esc_html__( 'Header Background', 'citybook' ),
	'section'     => 'blog_header',
	'default'     => get_template_directory_uri().'/assets/images/bg/3.jpg',
	'priority'    => 10,
	
) );



CityBook_Kirki::add_section( 'blog_list', array(
    'title'          => esc_html__( 'List View', 'citybook' ),
    'description'    => esc_html__( 'These options are for your blog list page: ' , 'citybook') .esc_url(home_url('?post_type=post' )),
    'panel'          => 'blog_panel', // Not typically needed.
    'priority'       => 160,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '', // Rarely needed.
) );
// CityBook_Kirki::add_field( 'citybook_configs', array(
// 	'type'        => 'select',
// 	'settings'    => 'blog_content_width',
// 	'label'       => esc_html__( 'Content Width', 'citybook' ),
// 	'section'     => 'blog_list',
// 	'default'     => 'big-container',
// 	'priority'    => 10,
// 	'multiple'    => 0,
// 	'choices'     => array(
// 		'boxed-container' => esc_html__( 'Small Boxed', 'citybook' ),
// 		'big-container' => esc_html__( 'Wide Boxed', 'citybook' ),
// 		'full-container' => esc_html__( 'Fullwidth', 'citybook' ),
// 	),
// ) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'radio-image',
	'settings'    => 'blog_layout',
	'label'       => esc_html__( 'Blog Sidebar Layout', 'citybook' ),
	'section'     => 'blog_list',
	'default'     => 'right_sidebar',
	'priority'    => 10,
	'choices'     => array(
		'fullwidth' => get_template_directory_uri() . '/assets/admin/images/1c.png',
		'left_sidebar' => get_template_directory_uri() . '/assets/admin/images/2cl.png',
		'right_sidebar' => get_template_directory_uri() . '/assets/admin/images/2cr.png',
		
	),
) );

CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'select',
	'settings'    => 'blog-sidebar-width',
	'label'       => esc_html__( 'Sidebar Width', 'citybook' ),
	'description'       => esc_html__( 'Based on Bootstrap 12 columns.', 'citybook' ),
	'section'     => 'blog_list',
	'default'     => '4',
	'priority'    => 10,
	'multiple'    => 0,
	'choices'     => array(
		'2' => esc_html__('2 Columns', 'citybook'),
        '3' => esc_html__('3 Columns', 'citybook'),
        '4' => esc_html__('4 Columns', 'citybook'),
        '5' => esc_html__('5 Columns', 'citybook'),
        '6' => esc_html__('6 Columns', 'citybook'),
	),
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'toggle',
	'settings'    => 'blog_show_format',
	'label'       => esc_html__( 'Show Post Format on posts page', 'citybook' ),
	'section'     => 'blog_list',
	'default'     => '1',
	'priority'    => 10,
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'toggle',
	'settings'    => 'blog_date',
	'label'       => esc_html__( 'Show Date', 'citybook' ),
	'section'     => 'blog_list',
	'default'     => '1',
	'priority'    => 10,
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'toggle',
	'settings'    => 'blog_author',
	'label'       => esc_html__( 'Show Author', 'citybook' ),
	'section'     => 'blog_list',
	'default'     => '0',
	'priority'    => 10,
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'toggle',
	'settings'    => 'blog_cats',
	'label'       => esc_html__( 'Show Categories', 'citybook' ),
	'section'     => 'blog_list',
	'default'     => '1',
	'priority'    => 10,
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'toggle',
	'settings'    => 'blog_tags',
	'label'       => esc_html__( 'Show Tags', 'citybook' ),
	'section'     => 'blog_list',
	'default'     => '1',
	'priority'    => 10,
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'toggle',
	'settings'    => 'blog_comments',
	'label'       => esc_html__( 'Show Comments', 'citybook' ),
	'section'     => 'blog_list',
	'default'     => '0',
	'priority'    => 10,
) );

CityBook_Kirki::add_section( 'blog_single', array(
    'title'          => esc_html__( 'Single Post View', 'citybook' ),
    'description'    => esc_html__( 'Add custom CSS here' , 'citybook'),
    'panel'          => 'blog_panel', // Not typically needed.
    'priority'       => 160,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '', // Rarely needed.
) );
// CityBook_Kirki::add_field( 'citybook_configs', array(
// 	'type'        => 'select',
// 	'settings'    => 'blog_single_width',
// 	'label'       => esc_html__( 'Content Width', 'citybook' ),
// 	'section'     => 'blog_single',
// 	'default'     => 'big-container',
// 	'priority'    => 10,
// 	'multiple'    => 0,
// 	'choices'     => array(
// 		'boxed-container' => esc_html__( 'Small Boxed', 'citybook' ),
// 		'big-container' => esc_html__( 'Wide Boxed', 'citybook' ),
// 		'full-container' => esc_html__( 'Fullwidth', 'citybook' ),
// 	),
// ) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'select',
	'settings'    => 'blog-single-sidebar-width',
	'label'       => esc_html__( 'Sidebar Width', 'citybook' ),
	'description'       => esc_html__( 'Based on Bootstrap 12 columns.', 'citybook' ),
	'section'     => 'blog_single',
	'default'     => '4',
	'priority'    => 10,
	'multiple'    => 0,
	'choices'     => array(
		'2' => esc_html__('2 Columns', 'citybook'),
        '3' => esc_html__('3 Columns', 'citybook'),
        '4' => esc_html__('4 Columns', 'citybook'),
        '5' => esc_html__('5 Columns', 'citybook'),
        '6' => esc_html__('6 Columns', 'citybook'),
	),
) );

CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'toggle',
	'settings'    => 'single_featured',
	'label'       => esc_html__( 'Show Featured Image', 'citybook' ),
	'section'     => 'blog_single',
	'default'     => '1',
	'priority'    => 10,
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'toggle',
	'settings'    => 'single_date',
	'label'       => esc_html__( 'Show Date', 'citybook' ),
	'section'     => 'blog_single',
	'default'     => '1',
	'priority'    => 10,
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'toggle',
	'settings'    => 'single_author',
	'label'       => esc_html__( 'Show Author', 'citybook' ),
	'section'     => 'blog_single',
	'default'     => '0',
	'priority'    => 10,
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'toggle',
	'settings'    => 'single_cats',
	'label'       => esc_html__( 'Show Categories', 'citybook' ),
	'section'     => 'blog_single',
	'default'     => '1',
	'priority'    => 10,
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'toggle',
	'settings'    => 'single_tags',
	'label'       => esc_html__( 'Show Tags', 'citybook' ),
	'section'     => 'blog_single',
	'default'     => '1',
	'priority'    => 10,
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'toggle',
	'settings'    => 'single_comments',
	'label'       => esc_html__( 'Show Comments', 'citybook' ),
	'section'     => 'blog_single',
	'default'     => '0',
	'priority'    => 10,
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'toggle',
	'settings'    => 'single_author_block',
	'label'       => esc_html__( 'Show Author Block', 'citybook' ),
	'section'     => 'blog_single',
	'default'     => '1',
	'priority'    => 10,
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'toggle',
	'settings'    => 'single_post_nav',
	'label'       => esc_html__( 'Show post navigation', 'citybook' ),
	'section'     => 'blog_single',
	'default'     => '1',
	'priority'    => 10,
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'toggle',
	'settings'    => 'single_same_term',
	'label'       => esc_html__( 'Next/Prev posts should be in same category', 'citybook' ),
	'section'     => 'blog_single',
	'default'     => '0',
	'priority'    => 10,
) );


CityBook_Kirki::add_section( 'footer_options', array(
    'title'          => esc_html__( 'Footer Options', 'citybook' ),
    'panel'          => '', // Not typically needed.
    'priority'       => 160,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '', // Rarely needed.
) );

CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'repeater',
	'label'       => esc_attr__( 'Footer Widgets', 'citybook' ),
	'section'     => 'footer_options',
	'priority'    => 10,
	'row_label' => array(
		'type'  => 'field',
		'value' => esc_attr__('Widget Area', 'citybook' ),
		'field' => 'title',
	),
	'settings'    => 'footer_widgets',
	'default'     => citybook_get_footer_widgets_default(),
	'fields' => array(
		'title' => array(
			'type'        => 'text',
			'label'       => esc_attr__( 'Widget Title', 'citybook' ),
			'description' => esc_attr__( 'This will be the label for your widget area', 'citybook' ),
			'default'     => '',
		),
		'classes' => array(
			'type'        => 'text',
			'label'       => esc_attr__( 'Widget Classes', 'citybook' ),
			'description' => esc_attr__( 'This will be used to layout your widget', 'citybook' ),
			'default'     => 'col-md-3',
		),
		'widid' => array(
			'type'        => 'text',
			'label'       => esc_attr__( 'Widget ID', 'citybook' ),
			'description' => esc_attr__( 'This value must be unique. And don\'t change it after.', 'citybook' ),
			'default'     => 'widget-id-1',
		),
	)
) );


CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'image',
	'settings'    => 'footer_logo',
	'label'       => esc_html__( 'Footer Logo', 'citybook' ),
	'section'     => 'footer_options',
	'default'     => '',
	'priority'    => 10,
	'choices'     => array(
		'save_as' => 'id',
	),
	
) );


CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'textarea',
	'settings'    => 'footer_copyright',
	'label'       => esc_html__( 'Copyright Text', 'citybook' ),
	'description'       => esc_html__( 'Enter footer copyright text for your site.', 'citybook' ),
	'section'     => 'footer_options',
	'default'     => '<span class="ft-copy">&#169; CityBook 2019  /  All rights reserved. </span>',
	'priority'    => 10,
) );

CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'toggle',
	'settings'    => 'footer_currencies',
	'label'       => esc_html__( 'Show currencies switcher?', 'citybook' ),
	'section'     => 'footer_options',
	'default'     => '1',
	'priority'    => 10,
) );

// 404 error page
CityBook_Kirki::add_section( 'error404_options', array(
    'title'          => esc_html__( 'Error 404 Options', 'citybook' ),
    'panel'          => '', // Not typically needed.
    'priority'       => 160,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '', // Rarely needed.
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'image',
	'settings'    => 'error404_bg',
	'label'       => esc_html__( 'Background Image', 'citybook' ),
	'section'     => 'error404_options',
	'default'     => get_template_directory_uri().'/assets/images/bg/29.jpg',
	'priority'    => 10,
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'textarea',
	'settings'    => 'error404_msg',
	'label'       => esc_html__( 'Additional Message', 'citybook' ),
	'section'     => 'error404_options',
	'default'     => '',
	'priority'    => 10,
) );
CityBook_Kirki::add_field( 'citybook_configs', array(
	'type'        => 'toggle',
	'settings'    => 'error404_btn',
	'label'       => esc_html__( 'Show back Home', 'citybook' ),
	'section'     => 'error404_options',
	'default'     => '1',
	'priority'    => 10,
) );