<?php
/* banner-php */
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg" itemscope>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php 
if(citybook_get_option('show_loader', true ) ) : 
    $loader_icon = citybook_get_option('loader_icon');
?>
    <!--loader-->
    <div class="loader-wrap">
        <div class="loader-inner">
        <?php if(!empty($loader_icon)): ?>
            <div class="loader-icon-img">
            <?php echo wp_get_attachment_image( $loader_icon, 'full', false, array('class'=>'no-lazy') ); ?>
            </div>
            <div class="ldicon-pulse"></div>
        <?php else: ?>
            <div class="pin"></div>
            <div class="pulse"></div>
        <?php endif; ?>
        </div>
    </div>
    <!--loader end-->
    <div id="main-theme">
<?php else :?>
    <div id="main-theme" class="is-hide-loader">
<?php endif;?>

        <!-- header-->
        <header id="masthead" class="citybook-header main-header dark-header fs-header sticky">
            <?php
            if(citybook_get_option( 'header_info'  ) != ''): ?>
            <div class="header-contacts">
                <?php echo wp_kses_post( citybook_get_option( 'header_info') ); ?>
            </div>
            <?php endif;?>

            <div class="header-inner">
                <div class="logo-holder">
                    <?php 
                    if(citybook_get_option('mobile_logo') != ''){
                        echo '<a class="custom-mobile-logo-link" href="'.esc_url( home_url('/' ) ).'">'.wp_get_attachment_image( citybook_get_option('mobile_logo'), 'full', false, array('class'=>'resp-img mobile-logo') ).'</a>';
                    }
                    if(has_custom_logo()) the_custom_logo(); 
                    else echo '<a class="custom-logo-link logo-text" href="'.esc_url( home_url('/' ) ).'"><h2>'.get_bloginfo( 'name' ).'</h2></a>'; 
                    ?>
                </div>
                <?php 
                if(citybook_get_option('show_fixed_search', true )) : ?>     
                
                <?php echo do_shortcode( citybook_check_shortcode('[citybook_search_header]', 'citybook_search_header') );?>
                <?php endif;?>

                
                <?php echo do_shortcode( citybook_check_shortcode('[citybook_submit_button]', 'citybook_submit_button') );?>
                <?php echo do_shortcode( citybook_check_shortcode('[citybook_login style="'.citybook_get_option('user_menu_style').'"]', 'citybook_login') );?>
                <!-- nav-button-wrap-->
                <div class="nav-button-wrap color-bg">
                    <div class="nav-button">
                        <span></span><span></span><span></span>
                    </div>
                </div>
                <!-- nav-button-wrap end-->
                <?php
                if(is_active_sidebar('sidebar-3')) :
                ?>
                <!-- sidebar-button --> 
                <div class="sidebar-button-wrap vis-m"></div>
                <!-- sidebar-button end-->         
                <?php endif;?>
                <?php 
                $head_carts = citybook_get_header_cart_link();
                if (  !empty($head_carts) ) {
                ?>
                <div class="attr-nav">
                    <ul>
                        <li>
                            <a href="#" class="cart-link">
                                <i class="fal fa-shopping-bag"></i>
                                <span class="cart-count"><?php echo esc_html($head_carts['count'] );?></span>
                            </a>
                        <?php if(citybook_get_option('show_mini_cart')): ?>
                            <ul class="cart-list">
                                <li><div class="widget_shopping_cart_content"></div></li>
                            </ul>
                        <?php endif;?>
                        </li>
                    </ul>
                </div>
                <?php 
                }
                ?>

                <?php if ( has_nav_menu( 'top' ) ) : ?>
                <!--  .nav-holder -->
                <div class="nav-holder main-menu">
                    <?php get_template_part( 'template-parts/navigation/navigation', 'top' ); ?>
                </div><!-- .nav-holder -->
                <?php endif; ?>
            </div>
        </header>
        <!--  header end -->
        <!--  wrapper  -->
        <div id="wrapper">
            <!-- Content-->
            <div class="content">
