<?php
/* banner-php */
/**
 * The template for displaying archive pages
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 */
get_header(); 

$sb_w = citybook_get_option('blog-sidebar-width','4');


if( citybook_get_option('show_blog_header', false) ) :?>
<!--section -->
<section class="parallax-section" data-scrollax-parent="true">
    <div class="bg par-elem"  data-bg="<?php echo esc_url( citybook_get_option('blog_header_image' ) );?>" data-scrollax="properties: { translateY: '30%' }"></div>
    <div class="overlay"></div>
    <div class="container">
        <div class="section-title center-align">
            <?php 
            the_archive_title('<h1 class="head-sec-title"><span>','</span></h1>') ;
            the_archive_description( '<div class="taxonomy-description">', '</div>' );
             ?>
            <?php citybook_breadcrumbs(); ?>
            <span class="section-separator"></span>
        </div>
    </div>
    <div class="header-sec-link">
        <div class="container"><a href="#sec1" class="custom-scroll-link"><?php esc_html_e( 'Let\'s Start', 'citybook' ); ?></a></div>
    </div>
</section>
<!-- section end -->
<?php 
endif;?>
<!--section -->   
<section class="gray-section" id="sec1">
    <div class="container">
        <div class="row">
            <?php if( citybook_get_option('blog_layout') ==='left_sidebar' && is_active_sidebar('sidebar-1')):?>
            <div class="col-md-<?php echo esc_attr($sb_w );?> blog-sidebar-column">
                <div class="blog-sidebar box-widget-wrap fl-wrap left-sidebar">
                    <?php 
                        get_sidebar(); 
                    ?>                 
                </div>
            </div>
            <?php endif;?>
            <?php if( citybook_get_option('blog_layout') ==='fullwidth' || !is_active_sidebar('sidebar-1')):?>
            <div class="col-md-12 display-posts nosidebar">
            <?php else:?>
            <div class="col-md-<?php echo (12 - $sb_w);?> col-wrap display-posts hassidebar">
            <?php endif;?>
                <div class="list-single-main-wrapper fl-wrap" id="sec2">
                
                    <?php
                    if ( have_posts() ) :

                        /* Start the Loop */
                        while ( have_posts() ) : the_post();

                            /*
                             * Include the Post-Format-specific template for the content.
                             * If you want to override this in a child theme, then include a file
                             * called content-___.php (where ___ is the Post Format name) and that will be used instead.
                             */
                            if(citybook_get_option('blog_show_format', true ))
                                get_template_part( 'template-parts/post/content', ( post_type_supports( get_post_type(), 'post-formats' ) ? get_post_format() : get_post_type() ) );
                            else
                               get_template_part( 'template-parts/post/content' );

                        endwhile;

                        citybook_pagination();
                        

                    else :

                        get_template_part( 'template-parts/post/content', 'none' );

                    endif;
                    ?>

                </div>
                <!-- end list-single-main-wrapper -->
            </div>
            <!-- end display-posts col-md-8 -->

            <?php if( citybook_get_option('blog_layout') === 'right_sidebar' && is_active_sidebar('sidebar-1')):?>
            <div class="col-md-<?php echo esc_attr($sb_w );?> blog-sidebar-column">
                <div class="blog-sidebar box-widget-wrap fl-wrap right-sidebar">
                    <?php 
                        get_sidebar(); 
                    ?>                 
                </div>
            </div>
            <?php endif;?>

        </div>
        <!-- end row -->
    </div>
    <!-- end container -->

</section>
<!-- section end -->

<?php get_footer();

