<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



/**
 * Core class used to implement a Recent Posts widget.
 *
 * @since 2.8.0
 *
 * @see WP_Widget
 */
class CityBook_About_Author extends WP_Widget {

	/**
	 * Sets up a new Recent Posts widget instance.
	 *
	 * @since 2.8.0
	 * @access public
	 */
	public function __construct() {
		$widget_ops = array('classname' => 'citybook_about_author', 'description' => __( "CityBook about author widget",'citybook-add-ons') );
		// Add Widget scripts
   		add_action('admin_enqueue_scripts', array($this, 'scripts'));
 
		parent::__construct('citybook-about-author', __('CityBook Author','citybook-add-ons'), $widget_ops);
		$this->alt_option_name = 'citybook_about_author';
	}

	public function scripts()
	{
	   	wp_enqueue_script( 'media-upload' );
	   	wp_enqueue_media();
	   	wp_enqueue_script('citybook_au_wid_js', CITYBOOK_ADD_ONS_DIR_URL . 'assets/admin/citybook_au_wid_js.js', array('jquery'));
	}

	/**
	 * Outputs the content for the current Recent Posts widget instance.
	 *
	 * @since 2.8.0
	 * @access public
	 *
	 * @param array $args     Display arguments including 'before_title', 'after_title',
	 *                        'before_widget', and 'after_widget'.
	 * @param array $instance Settings for the current Recent Posts widget instance.
	 */
	public function widget( $args, $instance ) {
		if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : __( 'About Author' ,'citybook-add-ons');

		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

		$au_text = ! empty( $instance['text'] ) ? $instance['text'] : '';
		$au_name = ! empty( $instance['au_name'] ) ? $instance['au_name'] : '';

		$au_photo = ! empty( $instance['au_photo'] ) ? $instance['au_photo'] : '';
		$au_link = ! empty( $instance['au_link'] ) ? $instance['au_link'] : 'javascript:void(0)';
		$au_socials = ! empty( $instance['au_socials'] ) ? $instance['au_socials'] : '';



		$text = apply_filters( 'citybook_author_widget_text', $au_text, $instance, $this );

		?>

		<?php echo $args['before_widget']; ?>
		<?php if ( $title ) {
			echo $args['before_title'] . $title . $args['after_title'];
		} ?>
			<div class="box-widget list-author-widget">
                <div class="list-author-widget-header shapes-bg-small  color-bg fl-wrap">
                	<?php if($au_name): ?>
			            <span class="list-author-widget-link"><a href="<?php echo $au_link; ?>"><?php echo esc_html($au_name); ?></a></span>
			        <?php endif;?>
                    <?php if($au_photo): ?>
			      		<img src="<?php echo esc_url($au_photo); ?>" class="respimg" alt="<?php echo esc_html($au_name); ?>">
			   		<?php endif;?>
                </div>
                <div class="box-widget-content">
                    <div class="list-author-widget-text">
                        <div class="list-author-widget-contacts">
                            <?php echo !empty( $instance['filter'] ) ? wpautop( $text ) : $text; ?>
                        </div>
                        <?php if($au_socials !=''): ?>
                        <div class="list-widget-social">
							<?php echo $au_socials; ?>
                        </div>
                        <?php endif;?>
                    </div>
                </div>
            </div>

        <?php echo $args['after_widget']; ?>

	<?php

	}

	/**
	 * Handles updating the settings for the current Recent Posts widget instance.
	 *
	 * @since 2.8.0
	 * @access public
	 *
	 * @param array $new_instance New settings for this instance as input by the user via
	 *                            WP_Widget::form().
	 * @param array $old_instance Old settings for this instance.
	 * @return array Updated settings to save.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );

		$instance['au_photo'] = ( ! empty( $new_instance['au_photo'] ) ) ? $new_instance['au_photo'] : '';
		$instance['au_link'] = ( ! empty( $new_instance['au_link'] ) ) ? $new_instance['au_link'] : '';

		if ( current_user_can( 'unfiltered_html' ) ) {
			$instance['text'] = $new_instance['text'];
		} else {
			$instance['text'] = wp_kses_post( $new_instance['text'] );
		}

		$instance['au_name'] = ( ! empty( $new_instance['au_name'] ) ) ? $new_instance['au_name'] : '';
		$instance['au_socials'] = ( ! empty( $new_instance['au_socials'] ) ) ? $new_instance['au_socials'] : '';

		$instance['filter'] = ! empty( $new_instance['filter'] );

		return $instance;
	}

	/**
	 * Outputs the settings form for the Recent Posts widget.
	 *
	 * @since 2.8.0
	 * @access public
	 *
	 * @param array $instance Current settings.
	 */
	public function form( $instance ) {

		$instance = wp_parse_args( (array) $instance, array( 'title' => '', 'text' => '','au_photo' => '', 'au_sig' => '') );

		$title     = sanitize_text_field( $instance['title'] );
		$au_photo = ! empty( $instance['au_photo'] ) ? $instance['au_photo'] : '';
		$au_sig = ! empty( $instance['au_sig'] ) ? $instance['au_sig'] : '';

		

		$au_name = isset( $instance['au_name'] ) ? $instance['au_name'] : '';
		$au_link = isset( $instance['au_link'] ) ? $instance['au_link'] : '';
		$au_socials = isset( $instance['au_socials'] ) ? $instance['au_socials'] : '<ul>
    <li><a href="#" target="_blank"><i class="fa fa-facebook"></i></a></li>
    <li><a href="#" target="_blank"><i class="fa fa-twitter"></i></a></li>
    <li><a href="#" target="_blank"><i class="fa fa-vk"></i></a></li>
    <li><a href="#" target="_blank"><i class="fa fa-whatsapp"></i></a></li>
</ul>';
		$filter = isset( $instance['filter'] ) ? $instance['filter'] : 0;
?>
		<p><label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ,'citybook-add-ons'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" /></p>

		<p>
      	<label for="<?php echo $this->get_field_id( 'au_photo' ); ?>"><?php _e( 'Author Photo:','citybook-add-ons' ); ?></label>
      	<input class="widefat" id="<?php echo $this->get_field_id( 'au_photo' ); ?>" name="<?php echo $this->get_field_name( 'au_photo' ); ?>" type="text" value="<?php echo esc_url( $au_photo ); ?>" />
      	<br>
      	<button class="citybook_author_upload_image_button button button-primary"><?php _e('Upload Image','citybook-add-ons');?></button>
   		</p>

   		

   		<p><label for="<?php echo $this->get_field_id( 'au_name' ); ?>"><?php _e( 'Author Name:' ,'citybook-add-ons'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'au_name' ); ?>" name="<?php echo $this->get_field_name( 'au_name' ); ?>" type="text" value="<?php echo $au_name; ?>" /></p>
		


		<p><label for="<?php echo $this->get_field_id( 'text' ); ?>"><?php _e( 'Author Description:' ,'citybook-add-ons'); ?></label>
		<textarea class="widefat" rows="5" cols="20" id="<?php echo $this->get_field_id('text'); ?>" name="<?php echo $this->get_field_name('text'); ?>"><?php echo esc_textarea( $instance['text'] ); ?></textarea></p>

   		<p><input id="<?php echo $this->get_field_id('filter'); ?>" name="<?php echo $this->get_field_name('filter'); ?>" type="checkbox"<?php checked( $filter ); ?> />&nbsp;<label for="<?php echo $this->get_field_id('filter'); ?>"><?php _e('Automatically add paragraphs','citybook-add-ons'); ?></label></p>
		
		<p><label for="<?php echo $this->get_field_id( 'au_link' ); ?>"><?php _e( 'Author URL:' ,'citybook-add-ons'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'au_link' ); ?>" name="<?php echo $this->get_field_name( 'au_link' ); ?>" type="text" value="<?php echo $au_link; ?>" /></p>
		
		<p><label for="<?php echo $this->get_field_id( 'au_socials' ); ?>"><?php _e( 'Socials:' ,'citybook-add-ons'); ?></label>
		<textarea class="widefat" id="<?php echo $this->get_field_id( 'au_socials' ); ?>" name="<?php echo $this->get_field_name( 'au_socials' ); ?>" rows="7"><?php echo $au_socials; ?></textarea></p>


		
<?php
	}
}
