<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


?>
<script type="text/template" id="tmpl-listing-item">
    <# _.each(data.listings, function(listing){ #>
    <div class="listing-item{{data.tmpl_add_cls}}" data-postid="{{listing.ID}}">
        <article class="geodir-category-listing fl-wrap">
            <# if(listing.thumbnail){ #>
            <div class="geodir-category-img">
                <?php if(citybook_addons_get_option('enable_img_click') == 'yes'): ?>
                    <a href="{{listing.url}}" class="listing-thumb-link">
                <?php endif;?>
                    <img src="{{listing.thumbnail}}" alt="">
                    <div class="overlay"></div>
                    <div class="list-post-counter">{{{listing.like_stats}}}</div>

                    <# if(listing.featured == '1'){ #>
                    <div class="listing-featured"><?php _e( 'Featured', 'citybook-add-ons' ); ?></div>
                    <# } #>
                <?php if(citybook_addons_get_option('enable_img_click') == 'yes'): ?>
                    </a>
                <?php endif;?>

            </div>
            <# } #>
            <div class="geodir-category-content fl-wrap">
                <# if(listing.cats){ #>
                <div class="listing-cats-wrap">
                <#  _.each(listing.cats,function(catstr){
                        print(catstr)
                    }) #>
                </div>
                <# } #>
                <# if(false == listing.hide_author_info){ #>
                <div class="listing-avatar"><a href="{{listing.author_url}}">{{{listing.author_avatar}}}</a>
                    <span class="avatar-tooltip"><?php esc_html_e( 'Added By  ', 'citybook-add-ons' );?><strong>{{{listing.author_name}}}</strong></span>
                </div>
                <# } #>
                <h3><a href="{{listing.url}}">{{{listing.title}}}<# if(listing.verified){ #><?php echo ' <span class="listing-verified tooltipwrap tooltip-center"><i class="fa fa-check"></i><span class="tooltiptext">'.__('Verified','citybook-add-ons').'</span></span>'; ?><# } #></a></h3>
                
                <?php 
                if(citybook_addons_get_option('listing_event_date') == 'yes'): ?>
                <# if(listing.event_date_text){ #><div class="card-event-date">{{{listing.event_date_text}}}</div><# } #>
                <?php 
                endif; ?>


                <?php 
                if(citybook_addons_get_option('grid_price') == 'yes'): ?>
                    <# if(listing.price_from){ #>
                    <div class="pricerange fl-wrap">
                        <span class="lprice-from">{{{listing.price_from_formated}}}</span>
                        <# if(listing.price_to){ #> - <span class="lprice-to">{{{listing.price_to_formated}}}</span><# } #>
                    </div>
                    <# } #>
                <?php endif; ?>

                <div class="card-excerpt">{{{listing.excerpt}}}</div>
                <div class="geodir-category-options fl-wrap">
                    <?php if(citybook_addons_get_option('single_show_rating')): ?>
                        <# if(listing.rating){ #>
                        <div class="listing-rating card-popup-rainingvis" data-rating="{{listing.rating.rating}}" data-stars="<?php echo esc_attr( citybook_addons_get_option('rating_base') ); ?>">
                            <span>({{{listing.rating.count}}}<?php esc_html_e( ' reviews',  'citybook-add-ons' );?>)</span>
                        </div>
                        <# }else{ #>
                        <div class="listing-rating">
                            <span><?php esc_html_e( 'Not review yet', 'citybook-add-ons' );?></span>
                        </div>
                        <# } #>
                    <?php endif; ?>
                    
                    <div class="geodir-category-location listing-item-footer">
                            
                        <?php 
                        if(citybook_addons_get_option('grid_wkhour') == 'yes'):
                        ?>
                        <span class="wkhour-status wkhour-{{listing.status}}">{{{listing.statusText}}}</span>
                        <div class="listing-footer-right">
                        <?php else: ?>
                        <div class="listing-footer-right without-status">
                        <?php endif; ?>
                            <# if(listing.latitude&&listing.longitude&&listing.address){ #>
                            <a class="item-loc tooltipwrap tooltip-right tooltip-nowrap" href="https://www.google.com/maps/search/?api=1&query={{listing.latitude}},{{listing.longitude}}" target="_blank"><i class="fa fa-map-marker" aria-hidden="true"></i> <span class="tooltiptext">{{{listing.address}}}</span></a>
                            <# } #>


                            <?php 
                            if( citybook_addons_get_option('grid_price_range') == 'yes' ):
                            ?>
                            <# if(listing.price_range !=''){ #><span class="price-range tooltipwrap tooltip-right tooltip-nowrap"><?php echo citybook_add_ons_get_currency_symbol(citybook_addons_get_option('currency','USD')) ?><span class="tooltiptext">{{{listing.price_range}}}</span></span><# } #>
                            <?php endif; ?>

                            <?php 
                            if( citybook_addons_get_option('grid_viewed_count') == 'yes' ):
                            ?>
                            <span class="viewed-count"><i class="fa fa-eye"></i> {{listing.view}}</span>
                            <?php endif; ?>

                            <?php if(!is_user_logged_in()): ?>
                                <a href="#" class="save-btn logreg-modal-open tooltipwrap tooltip-right" data-message="<?php esc_attr_e( 'Logging in first to bookmark this listing.', 'citybook-add-ons' ); ?>"><i class="fa fa-bookmark-o"></i><span class="tooltiptext"><?php _e( 'Bookmark', 'citybook-add-ons' ); ?></span></a>
                            <?php else: ?>
                                <# if(listing.bookmarked){ #>
                                <a href="javascript:void(0);" class="save-btn tooltipwrap tooltip-right" data-id="{{listing.ID}}"><i class="fa fa-bookmark"></i><span class="tooltiptext"><?php _e( 'Bookmarked', 'citybook-add-ons' ); ?></span></a>
                                <# }else{ #>
                                <a href="#" class="save-btn bookmark-listing-btn tooltipwrap tooltip-right" data-id="{{listing.ID}}"><i class="fa fa-bookmark-o"></i><span class="tooltiptext"><?php _e( 'Bookmark', 'citybook-add-ons' ); ?></span></a>
                                <# } #>
                            <?php endif; ?>
                        </div>

                    </div>
                    
                </div>
            </div>
        </article>
    </div>
    <# }) #>
</script>
<script type="text/template" id="tmpl-no-results">
    <?php citybook_addons_get_template_part('template-parts/search-no'); ?>
</script>
<script type="text/template" id="tmpl-map-info">
    <div class="map-popup-wrap">
        <div class="map-popup">
            <div class="infoBox-close"><i class="fa fa-times" aria-hidden="true"></i></div>
            <# if(data.cats){ #><div class="map-popup-category">{{{Object.keys(data.cats).join(' - ')}}}</div><# } #>
            <a href="{{data.url}}" class="listing-img-content fl-wrap">
                <img src="{{data.img}}" alt="{{data.title}}">
                <# if(data.featured == '1'){ #>
                <div class="listing-featured"><?php _e( 'Featured', 'citybook-add-ons' ); ?></div>
                <# } #>
            </a>
        
            <div class="listing-content fl-wrap">
                <?php if(citybook_addons_get_option('single_show_rating')): ?>
                    <# if(data.rating){ #>
                    <div class="card-popup-raining map-card-rainting" data-rating="{{data.rating.rating}}" data-stars="<?php echo esc_attr( citybook_addons_get_option('rating_base') ); ?>"> 
                        <span class="map-popup-reviews-count">( {{{data.rating.count}}}<?php esc_html_e( ' reviews', 'citybook-add-ons' );?> )</span> 
                    </div> 
                    <# } #>
                <?php endif; ?>
                <div class="listing-title fl-wrap"> 
                    <h4><a href="{{data.url}}">{{{data.title}}}</a></h4> 
                    <?php 
                    if(citybook_addons_get_option('grid_price') == 'yes' & 1 == 2): ?>
                        <# if(data.price_from){ #>
                        <div class="pricerange fl-wrap">
                            <span class="lprice-from">{{data.price_from}}</span>
                            <# if(data.price_to){ #><span class="lprice-to">{{data.price_to}}</span><# } #>
                        </div>
                        <# } #>
                    <?php endif; ?>
                    <# if(data.address){ #>
                    <span class="map-popup-contact-infos infos-address"> 
                        <i class="fa fa-map-marker" aria-hidden="true"></i>{{{data.address}}}
                    </span>  
                    <# } #>
                    <# if(data.phone){ #> 
                    <span class="map-popup-contact-infos infos-phone"> 
                        <i class="fa fa-phone" aria-hidden="true"></i><a href="tel:{{data.phone}}">{{{data.phone}}}</a> 
                    </span> 
                    <# } #>   
                </div> 

                <div class="geodir-category-location listing-item-footer">
                    
                    <?php 
                    if(citybook_addons_get_option('grid_wkhour') == 'yes'):
                    ?>
                    <span class="wkhour-status wkhour-{{data.status}}">{{data.statusText}}</span>
                    <?php endif; ?>

                    
                </div>


            </div> 
        </div> 
    </div> 
</script>

<script type="text/template" id="tmpl-feature-search">
<# _.each(data.features, function(fea){ #>
<?php citybook_addons_get_template_part('templates-inner/feature-search'); ?>
<# }) #>
</script>
<script type="text/template" id="tmpl-filter-subcats">
<# _.each(data.subcats, function(subcat){ #>
<?php citybook_addons_get_template_part('templates-inner/subcats-filter'); ?>
<# }) #>
</script>
<div id="ol-popup" class="ol-popup">
    <a href="#" id="ol-popup-closer" class="ol-popup-closer"></a>
    <div id="ol-popup-content"></div>
</div>