<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


if(!isset($hide_text_field)) $hide_text_field = 'yes';
if(!isset($use_pre_locs)) $use_pre_locs = 'no';
if(!isset($for_jstmpl)) $for_jstmpl = 'no';
?>
<div class="main-search-form-wrap">
    <form role="search" method="get" action="<?php echo esc_url(home_url( '/' ) ); ?>" class="main-search-form">
        <div class="main-search-input fl-wrap">

            <?php if($for_jstmpl == 'yes'): ?>
                <# if(settings.hide_text_field != 'yes'){ #>
                <div class="main-search-input-item lsearch-string">
                    <input name="search_term" type="text" class="search" placeholder="<?php echo esc_attr_x( 'What are you looking for?', 'hero search placeholder','citybook-add-ons' ) ?>" value="<?php echo get_search_query() ?>"/>
                </div>
                <# } #>
            <?php else: ?>
                <?php if($hide_text_field != 'yes'): ?>
                <div class="main-search-input-item lsearch-string">
                    <input name="search_term" type="text" class="search" placeholder="<?php echo esc_attr_x( 'What are you looking for?', 'hero search placeholder','citybook-add-ons' ) ?>" value="<?php echo get_search_query() ?>"/>
                </div>
                <?php endif; ?>
            <?php endif; ?>
            <div class="main-search-input-item location lsearch-location">
            <?php if($for_jstmpl == 'yes'): ?>
                <# if(settings.use_pre_locs == 'yes'){ #>
                    <?php
                    $listing_locations = citybook_addons_get_listing_locations(true);
                    $search_loc = '';
                    ?>
                    <select data-placeholder="<?php esc_attr_e( 'All Locations',  'citybook-add-ons' );?>" class="chosen-select" name="llocs">
                        <option value=""><?php esc_html_e( 'All Locations',  'citybook-add-ons' );?></option>
                        <?php 
                        foreach ($listing_locations as $loc => $loc_name) {
                            echo '<option value="'.$loc.'" '.selected( $search_loc, $loc,false).'>'.$loc_name.'</option>';
                        }
                        ?>
                    </select>
                <# }else{ #>
                    <input type="text" id="main_search_loc" placeholder="<?php esc_attr_e( 'Location',  'citybook-add-ons' );?>" name="address">
                    <a href="#" class="get-current-city"><i class="fa fa-dot-circle-o"></i></a>
                <# } #>
            <?php else: ?>
                <?php if($use_pre_locs == 'yes'): ?>
                    <?php
                    $listing_locations = citybook_addons_get_listing_locations(true);
                    $search_loc = '';
                    ?>
                    <select data-placeholder="<?php esc_attr_e( 'All Locations',  'citybook-add-ons' );?>" class="chosen-select" name="llocs">
                        <option value=""><?php esc_html_e( 'All Locations',  'citybook-add-ons' );?></option>
                        <?php 
                        foreach ($listing_locations as $loc => $loc_name) {
                            echo '<option value="'.$loc.'" '.selected( $search_loc, $loc,false).'>'.$loc_name.'</option>';
                        }
                        ?>
                    </select>
                    <?php else: ?>
                    <input type="text" id="main_search_loc" placeholder="<?php esc_attr_e( 'Location',  'citybook-add-ons' );?>" name="address">
                
                    <label class="get-current-city" for="hero-nearme-filter-checkbox"><i class="fa fa-dot-circle-o"></i></label>
                    <input type="checkbox" id="hero-nearme-filter-checkbox" class="dis-none" name="nearme-filter" value="yes">
                    <input type="hidden" id="address_lat" name="address_lat">
                    <input type="hidden" id="address_lng" name="address_lng">


                <?php endif; ?>
            <?php endif; // end for_jstmpl ?>
            </div>
            <?php
            $listing_cats = citybook_addons_get_listing_categories(citybook_addons_get_option('search_cat_level'));
            ?>
            <div class="main-search-input-item lsearch-category">
                <select data-placeholder="<?php esc_attr_e( 'All Categories',  'citybook-add-ons' );?>" class="chosen-select" name="lcats[]">
                    <option value=""><?php esc_html_e( 'All Categories',  'citybook-add-ons' );?></option>
                    <?php 
                    foreach ($listing_cats as $cat) {
                        // var_dump($cat);
                        echo '<option value="'.$cat['id'].'">'.str_repeat('-', $cat['level']).$cat['name'].'</option>';
                    }
                    ?>
                </select>
            </div>
            <input type="hidden" name="post_type" value="listing">
            <button class="main-search-button" type="submit"><?php esc_html_e( 'Search', 'citybook-add-ons' ); ?></button>

            <?php 
            if(defined('ICL_LANGUAGE_CODE')){
                echo '<input type="hidden" name="lang" value="'.ICL_LANGUAGE_CODE.'">';
            }
            ?>
        
        </div>
    </form>
</div>