<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


?>
<!-- listsearch-input-wrap  -->
<div class="mobile-open-filters">
    <a href="#" class="mb-open-filter">
        <?php _e( '<i class="fa fa-sort-amount-desc"></i><span>Listing Filters</span>', 'citybook-add-ons' ); ?>
    </a>
</div>
<div class="listsearch-input-wrap fl-wrap">
    <?php do_action( 'citybook_addons_before_filters' ); ?>
    <form id="list-search-page-form" role="search" method="get" action="<?php echo esc_url(home_url( '/' ) ); ?>" class="list-search-page-form">
        <div class="filter-form-inputs-wrap">
            <?php 
                do_action( 'citybook_addons_filter_before' );
            ?>
            <div class="listsearch-main-inputs filter-group-1">
                <?php 
                if(citybook_addons_get_option('filter_hide_string') != 'yes'): ?>
                <div class="listsearch-input-item">
                    <i class="mbri-key single-i"></i>
                    <input name="search_term" type="text" class="search" placeholder="<?php echo esc_attr__( 'Keywords?','citybook-add-ons' ) ?>" value="<?php echo (isset($_GET['search_term'])? $_GET['search_term'] : ''); ?>"/>
                </div>
                <?php endif; // end filter string ?>

                <?php 
                if(citybook_addons_get_option('filter_hide_loc') != 'yes'): ?>
                <?php
                $listing_locations = citybook_addons_get_listing_locations(true);
                $search_loc = '';
                if(is_tax('listing_location')){
                    $loc_term = get_term( get_queried_object_id(), 'listing_location' );
                    if ( ! empty( $loc_term ) && ! is_wp_error( $loc_term ) ) $search_loc = $loc_term->slug;
                }else{
                    if(isset( $_GET['llocs'] ) && !empty( $_GET['llocs'] )){
                        $llocs = explode(',',$_GET['llocs']);
                        $search_loc = sanitize_title( $llocs[0] );
                    }

                }
                ?>
                <div class="listsearch-input-item">
                    <select id="search_llocs" data-placeholder="<?php esc_attr_e( 'All Locations',  'citybook-add-ons' );?>" class="chosen-select<?php if(is_tax('listing_location')) echo ' disabled';?>" name="llocs">
                        <option value=""><?php esc_html_e( 'All Locations',  'citybook-add-ons' );?></option>
                        <?php 
                        foreach ($listing_locations as $loc => $loc_name) {
                            echo '<option value="'.$loc.'" '.selected( $search_loc, $loc,false).'>'.$loc_name.'</option>';
                        }
                        ?>
                    </select>
                </div>
                <?php endif; // end filter location ?>
                
                <?php 
                if(citybook_addons_get_option('filter_hide_cat') != 'yes'): ?>
                <?php
                $listing_cats = citybook_addons_get_listing_categories(citybook_addons_get_option('search_cat_level'));
                $search_cats = array();
                if(is_tax('listing_cat')){
                    $search_cats = array(get_queried_object_id());
                }else{
                    if(isset($_GET['lcats'])&&is_array($_GET['lcats'])){
                        $search_cats = array_filter($_GET['lcats']);
                    } 
                }
                
                    
                ?>
                <div class="listsearch-input-item">
                    <select id="search_lcats" data-placeholder="<?php esc_attr_e( 'All Categories',  'citybook-add-ons' );?>" class="chosen-select<?php if(is_tax('listing_location')) echo ' disabled';?>" name="lcats[]">
                        <option value=""><?php esc_html_e( 'All Categories',  'citybook-add-ons' );?></option>
                        <?php 
                        foreach ($listing_cats as $cat) {
                            if(in_array($cat['id'], $search_cats)){
                                echo '<option value="'.$cat['id'].'" selected>'.str_repeat('-', $cat['level']).$cat['name'].'</option>';
                            }else{
                                echo '<option value="'.$cat['id'].'">'.str_repeat('-', $cat['level']).$cat['name'].'</option>';
                            }
                            
                        }
                        ?>
                    </select>
                </div>
                <?php endif; // end filter category ?>
            </div>
            <!-- end listsearch-main-inputs -->
            <?php 
            if(citybook_addons_get_option('filter_hide_address') != 'yes'): ?>
                <?php if( isset($_GET['nearme-filter']) && $_GET['nearme-filter'] == 'yes' && isset($_GET['address_lat']) && !empty($_GET['address_lat'] ) && isset($_GET['address_lng']) && !empty($_GET['address_lng'] ) ): ?>
            <div class="listsearch-address-inputs filter-group-2 show-distance-filter">
                <div class="listsearch-input-item">
                    <label><?php _e( '<i class="fa fa-map-pin"></i> Enter Address ', 'citybook-add-ons' ); ?></label>
                    <input id="address_add" name="address_add" type="text" placeholder="<?php esc_attr_e( 'Destination, Area, City', 'citybook-add-ons' ); ?>" class="has-icon qodef-archive-places-search" value=""/>
                    <label id="get-curr-loc" class="loc-act qodef-archive-current-location" for="nearme-filter-checkbox"><i class="fa fa-dot-circle-o"></i></label>
                    <input type="checkbox" id="nearme-filter-checkbox" class="dis-none" name="nearme-filter" value="yes" checked="checked">
                    <input type="hidden" id="address_lat" name="address_lat" value="<?php echo $_GET['address_lat']; ?>">
                    <input type="hidden" id="address_lng" name="address_lng" value="<?php echo $_GET['address_lng']; ?>">
                </div>
                <?php else: ?>
            <div class="listsearch-address-inputs filter-group-2">
                <div class="listsearch-input-item">
                    <label><?php _e( '<i class="fa fa-map-pin"></i> Enter Address ', 'citybook-add-ons' ); ?></label>
                    <input id="address_add" name="address_add" type="text" placeholder="<?php esc_attr_e( 'Destination , Area , CityBook', 'citybook-add-ons' ); ?>" class="has-icon qodef-archive-places-search" value="<?php echo (isset($_GET['address'])? $_GET['address'] : ''); ?>"/>
                    <label id="get-curr-loc" class="loc-act qodef-archive-current-location" for="nearme-filter-checkbox"><i class="fa fa-dot-circle-o"></i></label>
                    <input type="checkbox" id="nearme-filter-checkbox" class="dis-none" name="nearme-filter" value="yes">
                    <input type="hidden" id="address_lat" name="address_lat">
                    <input type="hidden" id="address_lng" name="address_lng">
                </div>
                <?php endif; ?>
                
                <div class="distance-input fl-wrap distance-filter filter-group-2-2">
                    <div class="distance-title"><?php _e( 'Radius around selected destination <span class="distance-value"></span> km.', 'citybook-add-ons' ); ?></div>
                    <div class="distance-radius-wrap fl-wrap">
                        <input id="listing-distance-search" name="ldistance" class="distance-radius rangeslider--horizontal" type="range" min="<?php echo citybook_addons_get_option('distance_min'); ?>" max="<?php echo citybook_addons_get_option('distance_max'); ?>" step="<?php _ex( '1', 'Distance search step value in kilometer', 'citybook-add-ons' ); ?>" value="<?php echo citybook_addons_get_option('distance_df'); ?>" data-title="<?php _e( 'Radius around selected destination', 'citybook-add-ons' ); ?>">
                    </div>
                    <!-- <input type="hidden" id="distance_lat_min" name="distance_lat_min">
                    <input type="hidden" id="distance_lat_max" name="distance_lat_max">

                    <input type="hidden" id="distance_lng_min" name="distance_lng_min">
                    <input type="hidden" id="distance_lng_max" name="distance_lng_max"> -->
                </div>

            </div>
            <?php endif; // end filter address ?>

            <!-- hidden-listing-filter -->
            <div class="hidden-listing-filter fl-wrap filter-group-3">
                
                <!-- advance-inputs   -->
                <div class="listsearch-advance-inputs filter-group-3-2">
                    <?php 
                    if(citybook_addons_get_option('filter_hide_event_date') != 'yes'): ?>
                    <div class="listsearch-input-item">    
                        <input name="event_date" type="text" class="datepicker" data-max-year="2050" data-min-year="2016"  data-large-mode="true" data-large-default="true" data-format="Y-m-d" data-init-set="false" placeholder="<?php echo esc_attr__( 'Event Date','citybook-add-ons' ) ?>" value=""/>
                        <span class="remove-date-time"><i class="fa fa-trash"></i></span>
                    </div>
                    <?php endif; // end filter event date ?>
                    <?php 
                    if(citybook_addons_get_option('filter_hide_event_time') != 'yes'): ?>
                    <div class="listsearch-input-item">    
                        <input name="event_time" type="text" class="timepicker" placeholder="<?php echo esc_attr__( 'Event Time','citybook-add-ons' ) ?>" value=""/>
                        <span class="remove-date-time"><i class="fa fa-trash"></i></span>
                    </div>
                    <?php endif; // end filter event time ?>
                    <?php 
                    if(citybook_addons_get_option('filter_hide_open_now') != 'yes'): ?>
                    <div class="listsearch-input-item">    
                        <div class="switchbtn text-center">
                            <input type="checkbox" id="lfilter-status" name="status" value="open" class="switchbtn-checkbox">
                            <label class="switchbtn-label" for="lfilter-status">
                                <?php _e( '<i class="fa fa-clock-o" aria-hidden="true"></i> <span>Open Now</span>', 'citybook-add-ons' ); ?>
                            </label>
                        </div>
                    </div>
                    <?php endif; // end filter open now ?>
                    <?php 
                    if(citybook_addons_get_option('filter_hide_price_range') != 'yes'): ?>
                    <div class="listsearch-input-item">    
                        <select class="chosen-selects" name="price_range">
                            <option value=""><?php esc_html_e( 'Price Range',  'citybook-add-ons' );?></option>
                            <?php 
                            foreach (citybook_addons_get_listing_price_range() as $range => $title) {
                                echo '<option value="'.$range.'">'.$title.'</option>';
                            }
                            ?>
                        </select>
                    </div>
                    <?php endif; // end filter price range ?>
                    <?php 
                    if(citybook_addons_get_option('filter_hide_sortby') != 'yes'): ?>
                    <div class="listsearch-input-item">    
                        <select class="chosen-selects" name="morderby">
                            <option value=""><?php esc_html_e( 'Sort By',  'citybook-add-ons' );?></option>
                            <option value="price_desc"><?php esc_html_e( 'Price DESC',  'citybook-add-ons' );?></option>
                            <option value="price_asc"><?php esc_html_e( 'Price ASC',  'citybook-add-ons' );?></option>
                            <option value="most_reviewed"><?php esc_html_e( 'Most Reviewed',  'citybook-add-ons' );?></option>
                            <option value="most_viewed"><?php esc_html_e( 'Most Viewed',  'citybook-add-ons' );?></option>
                            <option value="most_liked"><?php esc_html_e( 'Most Liked',  'citybook-add-ons' );?></option>
                            <option value="highest_rated"><?php esc_html_e( 'Highest Rated',  'citybook-add-ons' );?></option>
                        </select>
                    </div>
                <?php endif; // end filter sortby ?>
                </div>
                
                <?php
                $cats_features = array();
                $cats_subcats = array();
                if(!empty($search_cats)){
                    foreach ($search_cats as $search_cat) {
                        $term_meta = get_term_meta( $search_cat, '_cth_term_meta', true );
                        if(isset($term_meta['features']) && !empty($term_meta['features'])){
                            foreach ($term_meta['features'] as $fea_id) {
                                $feature = get_term( $fea_id, 'listing_feature' );
                                if ( $feature != null && ! is_wp_error( $feature ) ){
                                    $cats_features[] = array(
                                        'type' => 'feature', // is features field
                                        'label' => $feature->name,
                                        'value' => $fea_id,
                                        // 'lvalue' => ''
                                    );
                                }
                            }
                            // end foreach
                        }
                        // end if $term_meta['features']
                        if(citybook_addons_get_option('search_load_subcat') == 'yes'){
                            $sub_cats = get_terms( array(
                                'taxonomy'      => 'listing_cat',
                                // 'hide_empty'    => false,
                                'parent'        => $search_cat,
                            ) );

                            if ( ! empty( $sub_cats ) && ! is_wp_error( $sub_cats ) ){
                                foreach ( $sub_cats as $sub_cat ) {
                                    $cats_subcats[] = array(
                                        'id'            => $sub_cat->term_id,
                                        'slug'          => $sub_cat->slug,
                                        'name'          => $sub_cat->name,
                                    );
                                }
                            }
                        }
                            

                    }
                    // end loop search_cats
                        
                }
                // end if $search_cats
                ?>
                <?php 
                if(!empty($cats_features)): ?>
                <div class="listing-features-view">
                    <h4 class="field-head"><?php esc_html_e( 'Filter by Features', 'citybook-add-ons' );?></h4>
                    <div class="listing-features">
                    <?php 
                    foreach ($cats_features as $fea) {
                        citybook_addons_get_template_part('templates-inner/feature-search',false,array('fea'=>$fea));
                    }
                    ?>
                    </div>
                </div>
                <?php 
                else : 
                // not in category view 
                    $option_features = array();
                    $filter_features = citybook_addons_get_option('filter_features');
                    if( !empty($filter_features) && is_array($filter_features) ){
                        foreach ($filter_features as $fea_id) {
                            $feature = get_term( $fea_id, 'listing_feature' );
                            if ( $feature != null && ! is_wp_error( $feature ) ){
                                $option_features[] = array(
                                    'type' => 'feature', // is features field
                                    'label' => $feature->name,
                                    'value' => $fea_id,
                                    // 'lvalue' => ''
                                );
                            }
                        }
                    }

                    if(!empty($option_features)):
                    ?>
                    <div class="listing-features-view">
                        <h4 class="field-head"><?php esc_html_e( 'Filter by Features', 'citybook-add-ons' );?></h4>
                        <div class="listing-features">
                        <?php 
                        foreach ($option_features as $fea) {
                            citybook_addons_get_template_part('templates-inner/feature-search',false,array('fea'=>$fea));
                        }
                        ?>
                        </div>
                    </div>
                    <?php else: ?>
                    <div class="listing-features-view loading-feas">
                        <h4 class="field-head"><?php esc_html_e( 'Filter by Features', 'citybook-add-ons' );?></h4>
                        <div class="listing-features"></div>
                    </div>
                <?php 
                    endif; // end check option features
                endif;?>
                
                <?php 
                if(!empty($cats_subcats)): ?>
                <div class="listing-subcats-view">
                    <h4 class="field-head"><?php esc_html_e( 'Filter by Sub Categories', 'citybook-add-ons' );?></h4>
                    <div class="listing-subcats">
                    <?php 
                    foreach ($cats_subcats as $subcat) {
                        citybook_addons_get_template_part('templates-inner/subcats-filter',false,array('subcat'=>$subcat));
                    }
                    ?>
                    </div>
                </div>
                <?php 
                else : ?>
                <div class="listing-subcats-view loading-subcats">
                    <h4 class="field-head"><?php esc_html_e( 'Filter by Sub Categories', 'citybook-add-ons' );?></h4>
                    <div class="listing-subcats"></div>
                </div>
                <?php 
                endif;?>
                <?php
                $option_tags = array();
                $filter_ltags = citybook_addons_get_option('filter_ltags');
                if( !empty($filter_ltags) && is_array($filter_ltags) ){
                    foreach ($filter_ltags as $tag_id) {
                        $ltag = get_term( $tag_id, 'post_tag' );
                        if ( $ltag != null && ! is_wp_error( $ltag ) ){
                            $option_tags[] = array(
                                'type' => 'ltag', // is listing tag field
                                'label' => $ltag->name,
                                'value' => $tag_id,
                            );
                        }
                    }
                }

                if(!empty($option_tags)):
                ?>
                <div class="listing-filter-tags">
                    <h4 class="field-head"><?php esc_html_e( 'Filter by Tags', 'citybook-add-ons' );?></h4>
                    <div class="listing-ftags">
                    <?php 
                    foreach ($option_tags as $tag) {
                        citybook_addons_get_template_part('templates-inner/tag-search',false,array('tag'=>$tag));
                    }
                    ?>
                    </div>
                </div>
                <?php endif;?>
                    
                <?php 
                    do_action( 'citybook_addons_filter_after' );
                ?>

                

            </div>
            <!-- hidden-listing-filter end -->

        </div>

            
        <input type="hidden" name="post_type" value="listing">
        <?php 
        if(isset($posts_per_page)) echo '<input type="hidden" name="lposts_per_page" value="'.$posts_per_page.'">';
        if(isset($orderby)) echo '<input type="hidden" name="lorderby" value="'.$orderby.'">';
        if(isset($order)) echo '<input type="hidden" name="lorder" value="'.$order.'">';
        ?>
        <div class="listsearch-footer">
            <button class="buttons lfilter-submit" type="submit"><?php esc_html_e( 'Update', 'citybook-add-ons' );?></button>
            <div class="more-filter-option"><?php esc_html_e( 'More Filters ', 'citybook-add-ons' );?><span></span></div>
        </div>
        <?php 
        if(defined('ICL_LANGUAGE_CODE')){
            echo '<input type="hidden" name="lang" value="'.ICL_LANGUAGE_CODE.'">';
        }
        ?>
    </form>
</div>
<!-- listsearch-input-wrap end -->
