<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


if(!citybook_addons_get_option('single_show_rating')) return;
$rating = citybook_addons_get_average_ratings(get_the_ID());       
if($rating):
?>
<div class="listing-rating card-popup-rainingvis" data-rating="<?php echo esc_attr( $rating['rating'] );?>" data-stars="<?php echo esc_attr( citybook_addons_get_option('rating_base') ); ?>">
    <span>(<?php echo esc_html( $rating['count'] );?><?php esc_html_e( ' reviews',  'citybook-add-ons' );?>)</span>
</div>
<?php else : ?>
<div class="listing-rating">
    <span><?php esc_html_e( 'Not review yet', 'citybook-add-ons' );?></span>
</div>
<?php endif;
