<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


if( citybook_addons_check_package_single_field( 'hide_contacts_info' ) ) return;
// $contact_infos = get_post_meta( get_the_ID(), '_cth_contact_infos', true );
$contact_infos = array(
    'address' => get_post_meta( get_the_ID(), '_cth_contact_infos_address', true ),
    'latitude' => get_post_meta( get_the_ID(), '_cth_contact_infos_latitude', true ),
    'longitude' => get_post_meta( get_the_ID(), '_cth_contact_infos_longitude', true ),
    'phone' => get_post_meta( get_the_ID(), '_cth_contact_infos_phone', true ),
    'email' => get_post_meta( get_the_ID(), '_cth_contact_infos_email', true ),
    'website' => get_post_meta( get_the_ID(), '_cth_contact_infos_website', true ),
);



?>
<div class="list-single-header-contacts fl-wrap">
    <ul>
    	<?php if(isset($contact_infos['phone'])): ?>
        <li><i class="fa fa-phone"></i><a  href="tel:<?php echo esc_html( $contact_infos['phone'] );?>"><?php echo esc_html( $contact_infos['phone'] ) ;?></a></li>
        <?php endif;?>
        <?php if(isset($contact_infos['latitude'])&&isset($contact_infos['longitude'])&&isset($contact_infos['address'])): ?>
        <li><i class="fa fa-map-marker"></i><a href="https://www.google.com/maps/search/?api=1&query=<?php echo $contact_infos['latitude'].','.$contact_infos['longitude'];?>" target="_blank"><?php echo esc_attr( $contact_infos['address'] );?></a></li>
        <?php endif;?>
        <?php if(isset($contact_infos['email'])): ?>
        <li><i class="fa fa-envelope-o"></i><a  href="mailto:<?php echo esc_html( $contact_infos['email'] ) ;?>"><?php echo esc_html( $contact_infos['email'] ) ;?></a></li>
        <?php endif;?>
    </ul>
</div>
