<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


$support_types = array(
    'select' => __( 'Select', 'citybook-add-ons' ),
    'checkbox' => __( 'Checkbox', 'citybook-add-ons' ),
    'radio' => __( 'Radio', 'citybook-add-ons' ),
    'switch' => __( 'Switch', 'citybook-add-ons' ),
	'text' => __( 'Text Field', 'citybook-add-ons' ),
	'textarea' => __( 'Textarea', 'citybook-add-ons' ),
	'editor' => __( 'Editor', 'citybook-add-ons' ),
);
if(!isset($index)) $index = false;
if(!isset($name)) $name = false;
if(!isset($field)) $field = array('field_type'=>'text','field_name'=>'field_name','field_label'=>'Field Label');

$index_text = ($index === false)? '{{data.index}}':$index;
$name_text = ($name == false)? '{{data.child_field_name}}':$name;

?>
<div class="entry">
    <select class="custom-select" name="<?php echo $name_text; ?>[<?php echo $index_text;?>][field_type]" required>
        <?php
        foreach ($support_types as $val => $lbl) {
            echo '<option value="'.$val.'" '.selected( $field['field_type'], $val, false ).'>'.$lbl.'</option>';
        }
        ?>
    </select>
    <input type="text" name="<?php echo $name_text; ?>[<?php echo $index_text;?>][field_name]" placeholder="<?php esc_attr_e( 'Field Name',  'citybook-add-ons' );?>" value="<?php echo isset($field['field_name'])? $field['field_name'] : '';?>" required>
    <input type="text" name="<?php echo $name_text; ?>[<?php echo $index_text;?>][field_label]" placeholder="<?php esc_attr_e( 'Field Label',  'citybook-add-ons' );?>" value="<?php echo isset($field['field_label'])? $field['field_label'] : '';?>">
    <button class="btn rmfield" type="button" ><span class="dashicons dashicons-trash"></span></button>
</div>
<!-- end entry -->

