<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


$working_days = citybook_addons_get_working_days_array();
if(!isset($post_working_hours)) $post_working_hours = array(
	'Monday' => array(
					'static' => 'enterHours',
					'hours' => 	array(
									array(
										'open' => '8:00',
										'close' => '22:00'
									),
								)
				),
	'Tuesday' => array(
					'static' => 'enterHours',
					'hours' => 	array(
									array(
										'open' => '8:00',
										'close' => '22:00'
									)
								)
				),
	'Wednesday' => array(
					'static' => 'enterHours',
					'hours' => 	array(
									array(
										'open' => '8:00',
										'close' => '22:00'
									)
								)
				),
	'Thursday' => array(
					'static' => 'enterHours',
					'hours' => 	array(
									array(
										'open' => '8:00',
										'close' => '22:00'
									)
								)
				),
	'Friday' => array(
					'static' => 'enterHours',
					'hours' => 	array(
									array(
										'open' => '8:00',
										'close' => '22:00'
									)
								)
				),
	'Saturday' => array(
					'static' => 'enterHours',
					'hours' => 	array(
									array(
										'open' => '8:00',
										'close' => '12:00'
									)
								)
				),
	'Sunday' => array(
					'static' => 'closeAllDay',
					'hours' => 	array(
									
								)
				),
	'timezone' => get_option( 'timezone_string', 'Europe/London' ),
);

?>
<div class="row">
    <?php 
    if(citybook_addons_get_option('submit_timezone_hide') == 'yes'): ?>
    <div class="col-md-12">
    <?php else: ?>
    <div class="col-md-8">
    <?php endif; ?>
        <div class="tabs-wrapper tabs-working-hours">
            <ul class="tabs-menu">
            <?php
            $cur = 0;
            foreach ($working_days as $dval => $dlbl){
                echo "<li class=\"tab-menu".(($cur==0)?' current':'')."\"><a href=\"#tab-{$dval}\">{$dlbl}</a></li>";
                $cur++;
            } 
            ?>
            </ul>
            <div class="tabs-content">
                <?php
                $cur = 0;
                foreach ($working_days as $dval => $dlbl) : 
                    $hourstatic = isset($post_working_hours[$dval]['static'])? $post_working_hours[$dval]['static'] : 'enterHours';
                    ?>
                    <div id="tab-<?php echo $dval;?>" class="tab-content<?php if($cur == 0) echo ' current';?>">
                        <div class="working-hours-static">
                            <label for="" class="radio inline">
                                <input type="radio" name="working_hours[<?php echo $dval;?>][static]" value="enterHours" <?php checked( $hourstatic, 'enterHours', true );?>>
                                <span><?php esc_html_e( 'Enter Hours', 'citybook-add-ons' );?></span>
                            </label>
                            <label for="" class="radio inline">
                                <input type="radio" name="working_hours[<?php echo $dval;?>][static]" value="openAllDay" <?php checked( $hourstatic, 'openAllDay', true );?>>
                                <span><?php esc_html_e( 'Open all day', 'citybook-add-ons' );?></span>
                            </label>
                            <label for="" class="radio inline">
                                <input type="radio" name="working_hours[<?php echo $dval;?>][static]" value="closeAllDay" <?php checked( $hourstatic, 'closeAllDay', true );?>>
                                <span><?php esc_html_e( 'Close all day', 'citybook-add-ons' );?></span>
                            </label>
                            
                        </div>
                        <!-- working-hours-static end -->
                        
                        <div class="repeater-fields-wrap" data-tmpl="tmpl-wrhour" data-tmpl_data='<?php echo json_encode(array('day'=>$dval));?>'>
                            <div class="repeater-fields">
                            <?php 
                            if(isset($post_working_hours[$dval]['hours'])&&!empty($post_working_hours[$dval]['hours'])){
                                foreach ($post_working_hours[$dval]['hours'] as $key => $hour) {
                                    citybook_addons_get_template_part('templates-inner/hour', false, array('index'=>$key,'day'=>$dval, 'hour'=>$hour));
                                }
                            }
                            ?>
                            </div>
                            <button class="btn addfield" type="button"><?php  esc_html_e( 'Add Hour','citybook-add-ons' );?></button>
                        </div>

                    </div>
                    <!-- end tab-content -->
                <?php 
                    $cur++;
                endforeach;
                ?>
            </div><!-- end tabs-content -->
        </div>
        <!-- end tabs-wrapper -->
    </div>
    <!-- end col-md-8 -->
    <?php 
    if(citybook_addons_get_option('submit_timezone_hide') == 'yes'): ?>
    <input type="hidden" name="working_hours[timezone]" value="<?php echo get_option( 'timezone_string', 'Europe/London' ); ?>">
    <?php else: ?>
    <div class="col-md-4">
        <?php 
        $timezones = citybook_addons_generate_timezone_list();
        ?>
        <label for="timezone"><?php esc_html_e( 'Timezone', 'citybook-add-ons' );?></label>
        <select id="timezone" class="chosen-select" name="working_hours[timezone]" data-placeholder="<?php esc_attr_e( 'Select Timezone', 'citybook-add-ons' );?>" required>
            <?php
            $timezone_val = isset($post_working_hours['timezone'])? $post_working_hours['timezone'] : get_option( 'timezone_string', 'Europe/London' );
            foreach ($timezones as $tzval => $tzlbl) {
                echo '<option value="'.$tzval.'" '.selected( $timezone_val , $tzval, false ).'>'.$tzlbl.'</option>';
            }
            ?>
        </select>
    </div>
    <!-- end col-md-4 -->
    <?php endif; ?>
    
</div>
<!-- end row -->