<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


$working_hours = citybook_addons_get_working_hours(get_the_ID());
?>
<!--box-widget-item -->
<div class="box-widget-item fl-wrap" id="listing-wkhour-widget">
    <div class="box-widget-item-header">
        <h3><?php esc_html_e( 'Working Hours : ', 'citybook-add-ons' );?></h3>
    </div>
    <div class="box-widget opening-hours">
        <div class="box-widget-content">
            
            <span class="current-status"><i class="fa fa-clock-o"></i> <?php echo $working_hours['statusText'];?> <span class="listing-timezone"><?php echo $working_hours['timezone'];?></span></span>
            <?php 
            $working_days_hours = $working_hours['days_hours'];
            if(count($working_days_hours)) :
            ?>
            <ul>
            <?php
            foreach ($working_days_hours as $day => $hours) {
                ?>
                <li><span class="opening-hours-day"><?php echo $day;?></span><span class="opening-hours-time"><?php
                foreach ($hours as $hr) {
                    echo $hr;
                }
                ?></span></li>
            <?php
            } // end foreach
            ?>
            </ul>
            <?php 
            endif; // end if count($working_days_hours)
            ?>
        </div>
    </div>
</div>
<!--box-widget-item end --> 