<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


$price_from = get_post_meta( get_the_ID(), P_META_PREFIX.'price_from', true );
$price_to = get_post_meta( get_the_ID(), P_META_PREFIX.'price_to', true );


?>
<!--box-widget-item -->
<div class="box-widget-item fl-wrap" id="listing-price-range-widget">
    <div class="box-widget-item-header">
        <h3><?php _e( 'Price / Claim : ', 'citybook-add-ons' ); ?></h3>
    </div>
    <div class="box-widget">
         <div class="box-widget-content">
            <div class="claim-price-wdget fl-wrap">

                <div class="claim-price-wdget-content fl-wrap">
                    <?php 
                    if($price_from != '') :  ?>
                    <div class="pricerange fl-wrap">
                    <?php 
                        _e( '<span class="lprice-text">Price : </span>', 'citybook-add-ons' );
                        echo '<span class="lprice-from">'.citybook_addons_get_price_formated($price_from).'</span>';
                        if($price_to != '') echo __( ' - ', 'citybook-add-ons' ) . '<span class="lprice-to">'. citybook_addons_get_price_formated($price_to).'</span>';

                    ?>
                    </div>
                    <?php 
                    if('yes' == _x( 'no', 'Show Add to cart button on listing price range. yes or no', 'citybook-add-ons' )  && citybook_addons_is_woocommerce_activated()){ ?>
                    <div class="listing-add-cart">
                        <a class="btn color-bg" href="<?php echo citybook_addons_get_add_to_cart_url( get_the_ID() );?>"><?php _e( 'Add to cart', 'citybook-add-ons' ); ?></a>
                    </div>
                    <?php } ?>
                    <?php 
                    endif; ?>
                    <?php if(citybook_addons_get_option('single_hide_claim') != 'yes' ): ?>
                        <?php if( get_post_meta( get_the_ID() , P_META_PREFIX.'verified', true ) == '' || ( get_post_meta( get_the_ID() , P_META_PREFIX.'verified', true ) && citybook_addons_get_option('single_hide_claimed') != 'yes' ) ): ?>
                        <div class="claim-widget-link fl-wrap">
                            <?php _e( '<span>Own or work here?</span>', 'citybook-add-ons' ); ?>
                            <?php if(is_user_logged_in()) : ?>
                            <a class="open-listing-claim" href="#">
                            <?php else : ?>
                            <a class="logreg-modal-open" href="#" data-message="<?php esc_attr_e( 'You must be logged in to claim listing.', 'citybook-add-ons' ); ?>">
                            <?php endif; ?>
                                <?php _e( 'Claim Now!', 'citybook-add-ons' ); ?>
                            </a>
                            
                        </div>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>  

            </div>
         </div>
    </div>
</div>
<!--box-widget-item end -->
