<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


$author_ID = get_the_author_meta( 'ID' );
$args = array(
    'post_type'     =>  'listing', 
    'author'        =>  $author_ID, 
    'orderby'       =>  'date',
    'order'         =>  'DESC',
    'posts_per_page' => 3
);

// The Query
$posts_query = new WP_Query( $args );
if($posts_query->have_posts()) : ?>
<!--box-widget-item -->
<div class="box-widget-item fl-wrap" id="listing-morefauthor-widget">
    <div class="box-widget-item-header">
        <h3><?php esc_html_e( 'More from this author : ', 'citybook-add-ons' ); ?></h3>
    </div>
    <div class="box-widget">
        <div class="box-widget-content widget-posts">
            <ul>
            <?php while($posts_query->have_posts()) : $posts_query->the_post(); ?>
                <li class="clearfix">
                    <?php
                    if(has_post_thumbnail( )){ ?>
                    <a href="<?php echo esc_url( get_permalink() ); ?>"  class="widget-posts-img"><?php the_post_thumbnail('citybook-recent-post',array('class'=>'respimg') ); ?></a>
                    <?php } ?>
                    <div class="widget-posts-descr">
                        <a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php esc_attr( get_the_title() ); ?>"><?php the_title(); ?></a>
                        <span class="widget-posts-date"><i class="fa fa-calendar-check-o"></i> <?php the_time(get_option('date_format'));?></span> 
                    </div>
                </li>
                
            <?php endwhile; ?>
            </ul>
            <a class="widget-posts-link" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php esc_html_e( 'See All Listing', 'citybook-add-ons' ); ?><span><i class="fa fa-angle-right"></i></span></a>   
        </div>
    </div>
</div>
<!--box-widget-item end --> 
<?php 
wp_reset_postdata();
endif;

