<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


$working_hours = get_post_meta( get_the_ID(), P_META_PREFIX.'working_hours', true );
$timezone = isset($working_hours['timezone']) ? $working_hours['timezone'] : '';

$levent_date = get_post_meta( get_the_ID(), P_META_PREFIX.'levent_date', true );
$levent_time = get_post_meta( get_the_ID(), P_META_PREFIX.'levent_time', true );
if($levent_date != '') : 
?>
<!--box-widget-item -->
<div class="box-widget-item fl-wrap" id="listing-counter-widget">
    <div class="box-widget-item-header">
        <h3><?php esc_html_e( 'Event Will Begin : ', 'citybook-add-ons' ); ?><span class="widget-event-date"><?php echo sprintf( __( 'on <span>%s</span> at <span>%s</span>', 'citybook-add-ons' ), date_i18n( get_option( 'date_format' ), strtotime( $levent_date.' '.$levent_time ) ), date_i18n( get_option( 'time_format' ), strtotime( $levent_date.' '.$levent_time ) ) ); ?></span></h3>
    </div>
    <div class="box-widget countdown-widget gradient-bg" data-countdate="<?php echo citybook_addons_get_gmt_from_date( $levent_date.' '.$levent_time, $timezone, 'm/d/Y H:i:s' );?>">
        <div class="countdown fl-wrap">
            <div class="countdown-completed">
                <span><?php _e( 'Event started', 'citybook-add-ons' ); ?></span>
            </div>
            <div class="countdown-item">
                <span class="days rot">00</span>
                <p><?php esc_html_e( 'days', 'citybook-add-ons' ); ?></p>
            </div>
            <div class="countdown-item">
                <span class="hours rot">00</span>
                <p><?php esc_html_e( 'hours', 'citybook-add-ons' ); ?></p>
            </div>
            <div class="countdown-item no-dec">
                <span class="minutes rot2">00</span>
                <p><?php esc_html_e( 'minutes', 'citybook-add-ons' ); ?></p>
            </div>
            <div class="countdown-item-seconds">
                <span class="seconds rot2">00</span>
            </div>

        </div>
    </div>
</div>
<!--box-widget-item end -->
<?php 
endif;

$levent_end_date = get_post_meta( get_the_ID(), P_META_PREFIX.'levent_end_date', true );
$levent_end_time = get_post_meta( get_the_ID(), P_META_PREFIX.'levent_end_time', true );
if($levent_end_date != '') : 
    
?>
<!--box-widget-item -->
<div class="box-widget-item fl-wrap" id="listing-counter-end-widget">
    <div class="box-widget-item-header">
        <h3><?php esc_html_e( 'Event Will End: ', 'citybook-add-ons' ); ?><span class="widget-event-end-date"><?php echo sprintf( __( 'on <span>%s</span> at <span>%s</span>', 'citybook-add-ons' ), date_i18n( get_option( 'date_format' ), strtotime( $levent_end_date.' '.$levent_end_time ) ), date_i18n( get_option( 'time_format' ), strtotime( $levent_end_date.' '.$levent_end_time ) ) ); ?></span></h3>
    </div>
    <div class="box-widget countdown-widget gradient-bg" data-countdate="<?php echo citybook_addons_get_gmt_from_date( $levent_end_date.' '.$levent_end_time, $timezone, 'm/d/Y H:i:s' );?>">
        <div class="countdown fl-wrap">
            <div class="countdown-completed">
                <span><?php _e( 'The event ended', 'citybook-add-ons' ); ?></span>
            </div>
            <div class="countdown-item">
                <span class="days rot">00</span>
                <p><?php esc_html_e( 'days', 'citybook-add-ons' ); ?></p>
            </div>
            <div class="countdown-item">
                <span class="hours rot">00</span>
                <p><?php esc_html_e( 'hours', 'citybook-add-ons' ); ?></p>
            </div>
            <div class="countdown-item no-dec">
                <span class="minutes rot2">00</span>
                <p><?php esc_html_e( 'minutes', 'citybook-add-ons' ); ?></p>
            </div>
            <div class="countdown-item-seconds">
                <span class="seconds rot2">00</span>
            </div>

        </div>
    </div>
</div>
<!--box-widget-item end -->
<?php 
endif;