<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


// $contact_infos = get_post_meta( get_the_ID(), '_cth_contact_infos', true );
$contact_infos = array(
                    'address' => get_post_meta( get_the_ID(), '_cth_contact_infos_address', true ),
                    'latitude' => get_post_meta( get_the_ID(), '_cth_contact_infos_latitude', true ),
                    'longitude' => get_post_meta( get_the_ID(), '_cth_contact_infos_longitude', true ),
                    'phone' => get_post_meta( get_the_ID(), '_cth_contact_infos_phone', true ),
                    'email' => get_post_meta( get_the_ID(), '_cth_contact_infos_email', true ),
                    'website' => get_post_meta( get_the_ID(), '_cth_contact_infos_website', true ),
                );

$listing_author_id = get_the_author_meta('ID');
?>
<!--box-widget-item -->
<div class="box-widget-item fl-wrap" id="listing-contacts-widget">
    <div class="box-widget-item-header">
        <h3><?php esc_html_e( 'Location / Contacts : ', 'citybook-add-ons' );?></h3>
    </div>
    <div class="box-widget">
        <div class="contacts-boxes">
            <div class="contacts-info-box">
                <?php
                if($contact_infos['latitude'] != '' && $contact_infos['longitude'] != '') : 
                    $dataArr = array();
                ?>
                <div class="map-container">
                    <?php if(citybook_addons_get_option('use_osm_map') == 'yes'): ?>
                    <div id="<?php echo uniqid('singleMapOSM'); ?>" class="singleMapOSM" data-lat="<?php echo esc_attr( $contact_infos['latitude'] );?>" data-lng="<?php echo esc_attr( $contact_infos['longitude'] );?>" data-loc="<?php echo esc_attr( $contact_infos['address'] );?>" data-zoom="<?php echo citybook_addons_get_option('gmap_single_zoom');?>"></div>
                    <?php else: ?>
                    <div class="singleMap" data-lat="<?php echo esc_attr( $contact_infos['latitude'] );?>" data-lng="<?php echo esc_attr( $contact_infos['longitude'] );?>" data-loc="<?php echo esc_attr( $contact_infos['address'] );?>" data-zoom="<?php echo citybook_addons_get_option('gmap_single_zoom');?>"></div>
                    <?php endif; ?>

                    
                </div>
                <?php 
                endif; 
                ?>
                <div class="box-widget-content">
                    <div class="list-author-widget-contacts list-item-widget-contacts">
                        <ul>
                            <?php
                            if($contact_infos['address'] != '' && $contact_infos['longitude'] != '' && $contact_infos['longitude'] != ''): ?>
                            <li><span><?php _e( '<i class="fa fa-map-marker"></i> Address :', 'citybook-add-ons' );?></span> <a href="https://www.google.com/maps/search/?api=1&query=<?php echo $contact_infos['latitude'].','.$contact_infos['longitude'];?>" target="_blank"><?php echo esc_attr( $contact_infos['address'] );?></a></li>
                            <?php endif;?>
                        <?php 
                        if( false == citybook_addons_check_package_single_field( 'hide_contacts_info' ) ): ?>
                            <?php 
                            if($contact_infos['phone']): ?>
                            <li><span><?php _e( '<i class="fa fa-phone"></i> Phone :', 'citybook-add-ons' );?></span> <a href="tel:<?php echo esc_html( $contact_infos['phone'] );?>"><?php echo esc_html( $contact_infos['phone'] ) ;?></a></li>
                            <?php endif;?>
                            <?php 
                            if($contact_infos['email']): ?>
                            <li><span><?php _e( '<i class="fa fa-envelope-o"></i> Mail :', 'citybook-add-ons' );?></span> <a href="mailto:<?php echo esc_html( $contact_infos['email'] ) ;?>"><?php echo esc_html( $contact_infos['email'] ) ;?></a></li>
                            <?php endif;?>
                            <?php 
                            if($contact_infos['website']): ?>
                            <li><span><?php _e( '<i class="fa fa-globe"></i> Website :', 'citybook-add-ons' );?></span> <a href="<?php echo esc_url( $contact_infos['website'] ) ;?>" target="_blank"><?php echo esc_html( $contact_infos['website'] ) ;?></a></li>
                            <?php endif;?>
                        <?php endif;?>
                        </ul>
                    </div>
                    

                    <?php if( false == citybook_addons_check_package_field( 'hide_socials_opt', true ) ): ?> 
                    <?php 
                    $socials = get_post_meta( get_the_ID(), '_cth_socials', true );
                    if(is_array($socials) && count($socials)) : ?>
                    <div class="list-widget-social">
                        <ul>
                            <?php 
                            foreach ($socials as $social) {
                                echo '<li><a href="'.esc_url( $social['url'] ).'" target="_blank" ><i class="fa fa-'.esc_attr( $social['name'] ).'"></i></a></li>';
                            }
                            ?>
                        </ul>
                    </div>
                    <?php 
                    endif;?>
                <?php endif; ?>
                </div>
                <a href="#" class="switchchat-btn show-ctform-btn"><?php _e( 'Chat Author', 'citybook-add-ons' ); ?><i class="fa fa-angle-right"></i></a>
            </div>
            <!-- End contacts-info-box    -->
            <div class="contacts-form-box">
                <a href="#" class="switchchat-btn close-ctform-btn"><i class="fa fa-angle-left"></i><?php _e( 'Show Infos', 'citybook-add-ons' ); ?></a>
                <?php 
                
                $lat_chat_id = 'new'; 
                ?>
                <?php if ( !is_user_logged_in() ) { ?>
                    <a href="" class="btn color-bg logreg-modal-open" data-message="<?php esc_attr_e( 'Sign in to chat.', 'citybook-add-ons' ); ?>"><?php _e( 'Sign In', 'citybook-add-ons' );?></a>
                <?php }elseif($listing_author_id != get_current_user_id()){ ?>
                    <div class="mini-chat-box chat-box-wrap">
                        <div id="chat-box" class="chat-box fl-wrap grey-blue-bg loading-replies"></div>
                        <div class="chat-replies-loading">
                            <span></span>
                            <span></span>
                            <span></span>
                        </div>
                        <div id="chat-input-wrap" class="message-input fl-wrap">
                            <form action="#" id="author-chat-form">
                                <textarea name="chat-msg" placeholder="<?php esc_attr_e( 'Type Message', 'citybook-add-ons' ); ?>" required></textarea>                                                 
                                <button type="submit"><i class="fa fa-paper-plane-o"></i></button>

                                <input type="hidden" name="cid" value="<?php echo $lat_chat_id; ?>">
                                <input type="hidden" name="touid" value="<?php echo $listing_author_id; ?>">
                                <input type="hidden" name="fuid" value="<?php echo get_current_user_id(); ?>">
                            </form>
                        </div>
                    </div>
                    <!-- chat-box end--> 
                <?php }else{ 
                    _e( '<p>This is your listing</p>', 'citybook-add-ons' );
                } ?>
                

            </div>
            <!-- End contacts-form-box -->
        </div>
        <!-- End .contacts-boxes -->
    </div>
</div>
<!--box-widget-item end --> 