<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



?>
<!--box-widget-item -->
<div class="box-widget-item fl-wrap" id="listing-author-widget">
    <div class="box-widget-item-header">
        <h3><?php esc_html_e( 'Hosted by : ', 'citybook-add-ons' );?></h3>
    </div>
    <?php 
    $author_ID = get_the_author_meta( 'ID' );
    ?>
    <div class="box-widget list-author-widget">
        <div class="list-author-widget-header shapes-bg-small color-bg fl-wrap">
            <span class="list-author-widget-link">
                <a href="<?php echo get_author_posts_url( $author_ID ); ?>"><?php echo get_the_author_meta('display_name');?></a>
            </span>
            <?php 
                echo get_avatar(get_the_author_meta('user_email'),'150','https://0.gravatar.com/avatar/ad516503a11cd5ca435acc9bb6523536?s=150', get_the_author_meta('display_name') );
            ?> 
        </div>
        <div class="box-widget-content">
            <div class="list-author-widget-text">
                <?php
                $au_phone = get_user_meta( $author_ID, '_cth_phone', true );
                $au_address = get_user_meta( $author_ID, '_cth_address', true );
                $au_url = get_the_author_meta('user_url');
                ?>
                <div class="list-author-widget-contacts">
                    <ul>
                        <?php if($au_phone != ''){ ?><li><span><i class="fa fa-phone"></i><?php esc_html_e( ' Phone :', 'citybook-add-ons' );?></span> <a href="tell:<?php echo esc_attr($au_phone);?>"><?php echo esc_html($au_phone);?></a></li><?php } ?>
                        <?php if($au_address != ''){ ?><li><span><i class="fa fa-map-marker"></i><?php esc_html_e( ' Address :', 'citybook-add-ons' );?></span> <span><?php echo esc_html($au_address);?></span></li><?php } ?>
                        <?php if($au_url != ''){ ?><li><span><i class="fa fa-globe"></i><?php esc_html_e( ' Website :', 'citybook-add-ons' );?></span> <a href="<?php echo esc_url( $au_url );?>" target="_blank"><?php echo esc_url( $au_url );?></a></li><?php } ?>
                    </ul>
                </div>

                <?php 
                $au_socials = get_user_meta( $author_ID, '_cth_socials', true );
                // echo'<pre>';var_dump($au_socials);
                if(is_array($au_socials) && count($au_socials)) : ?>
                <div class="list-author-widget-socials">
                    <ul>
                        <?php 
                        foreach ($au_socials as $social) {
                            echo '<li><a href="'.esc_url( $social['url'] ).'" target="_blank" ><i class="fa fa-'.esc_attr( $social['name'] ).'"></i></a></li>';
                        }
                        ?>
                    </ul>
                </div>
                <?php 
                endif;?>
                  
                <div class="author-view-profile">
                    <a href="<?php echo get_author_posts_url( $author_ID ); ?>" class="btn transparent-btn"><?php esc_html_e( 'View Profile ', 'citybook-add-ons' );?><i class="fa fa-eye"></i></a>
                </div>
    
            </div>
        </div>
    </div>
</div>
<!--box-widget-item end -->