<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



// echo '<pre>';
$cats = get_the_terms(get_the_ID(), 'listing_cat');
$add_feas = array();
if ( $cats && ! is_wp_error( $cats ) ){
    foreach( $cats as $key => $cat){
        // $term_meta = get_option("_cth_tax_listing_cat_$cat->term_id");
        $term_meta = get_term_meta( $cat->term_id, P_META_PREFIX.'term_meta', true );
        
        if(isset($term_meta['add-features']) && !empty($term_meta['add-features'])){
            foreach ($term_meta['add-features'] as $field) {
                if(isset($field['name']) && isset($field['label'])) $add_feas = array_merge($add_feas, array( $field['name'] => $field['label'] ) );
            }
        }
    }
}
// end check cat
$post_add_feas = get_post_meta( get_the_ID(), P_META_PREFIX.'add-features', true );
// var_dump($post_add_feas);
if(is_array($post_add_feas) && !empty($post_add_feas) && !empty($add_feas)) : 
?>
<!--box-widget-item -->
<div class="box-widget-item fl-wrap" id="listing-addfeas-widget">
    <div class="box-widget-item-header">
        <h3><?php esc_html_e( 'Additional Features:', 'citybook-add-ons' ); ?></h3>
    </div>
    <div class="box-widget additional-features">
        <div class="box-widget-content">
            <ul>
            <?php 
            foreach ($post_add_feas as $name => $value) {
                if($value && array_key_exists($name, $add_feas)) echo '<li><span class="fea-label">'.$add_feas[$name].'</span><span class="fea-value">'.$value.'</span></li>';
            }
            // end foreach 
            ?>
            </ul>
        </div>
    </div>
</div>
<!--box-widget-item end -->  
<?php 
endif;
// end check fea
?>