<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


if(!isset($location)) $location = '';
if(!isset($contact_infos)) $contact_infos = array(
												'address' => '',												
												'latitude' => '',												
												'longitude' => '',												
												'phone' => '',												
												'email' => '',												
												'website' => '',												
											);
// new arg for hide location from back-end
if(!isset($hide_location)) $hide_location = false;
?>
<?php if($hide_location != true): ?>
<label><?php _e( 'Location<i class="fa fa-map-marker"></i>', 'citybook-add-ons' );?></label>
<input class="has-icon" id="location" type="text" name="locations" placeholder="<?php esc_attr_e( 'Region of your business', 'citybook-add-ons' );?>" value="<?php echo esc_attr( $location );?>"/>
<?php endif; ?>
<div class="contact-infos-wrap">
    <div class="row listing-submit-contacts-row">
        <div class="col-md-6 listing-submit-address-col">
            <label for="address"><?php esc_html_e( 'Address', 'citybook-add-ons' );?></label>
            <input type="text" id="contact_infos_address" name="contact_infos_address" placeholder="<?php esc_attr_e( 'Address of your business', 'citybook-add-ons' );?>" value="<?php echo esc_attr( $contact_infos['address'] );?>"/>

            <div class="row submit-latlng listing-submit-latlng-row">
                <div class="col-md-6">
                    <label for="latitude"><?php esc_html_e( 'Latitude', 'citybook-add-ons' );?></label>
                    <input type="text" id="contact_infos_latitude" name="contact_infos_latitude" value="<?php echo esc_attr( $contact_infos['latitude'] );?>"/>
                </div>
                <div class="col-md-6">
                    <label for="longitude"><?php esc_html_e( 'Longitude', 'citybook-add-ons' );?></label>
                    <input type="text" id="contact_infos_longitude" name="contact_infos_longitude" value="<?php echo esc_attr( $contact_infos['longitude'] );?>"/>
                </div>
            </div>
        </div>
        <!-- col-md-6 -->
        <div class="col-md-6 listing-submit-map-col">
            <div class="map-container">
                <?php if(citybook_addons_get_option('use_osm_map')): ?>
                <div id="<?php echo uniqid('submitMapOSM'); ?>" class="submitMapOSM" data-lat="<?php echo esc_attr( $contact_infos['latitude'] );?>" data-lng="<?php echo esc_attr( $contact_infos['longitude'] );?>"></div>
                <?php else: ?>
                <div class="submitMap" data-lat="<?php echo esc_attr( $contact_infos['latitude'] );?>" data-lng="<?php echo esc_attr( $contact_infos['longitude'] );?>"></div>
                <?php endif; ?>
                    
                
            </div>
        </div>
    </div>
        	

    <label><?php esc_html_e( 'Phone', 'citybook-add-ons' );?><i class="fa fa-phone"></i></label>
    <input class="has-icon" type="text" name="contact_infos_phone" placeholder="<?php esc_attr_e( 'Your Phone', 'citybook-add-ons' );?>" value="<?php echo esc_attr( $contact_infos['phone'] );?>"/>
    <label><?php esc_html_e( 'Email', 'citybook-add-ons' );?><i class="fa fa-envelope-o"></i></label>
    <input class="has-icon" type="text" name="contact_infos_email" placeholder="<?php esc_attr_e( 'Your Email', 'citybook-add-ons' );?>" value="<?php echo esc_attr( $contact_infos['email'] );?>"/>
    <label><?php esc_html_e( 'Website', 'citybook-add-ons' );?><i class="fa fa-globe"></i></label>
    <input class="has-icon" type="text" name="contact_infos_website" placeholder="<?php esc_attr_e( 'Your Website', 'citybook-add-ons' );?>" value="<?php echo esc_attr( $contact_infos['website'] );?>"/>
</div>