<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



// $is_ad_meta = get_post_meta( get_the_ID(), P_META_PREFIX.'is_ad', true);
// $ad_expire_meta = get_post_meta( get_the_ID(), P_META_PREFIX.'ad_expire', true);
// $is_ad = false;
// if($is_ad_meta == 'yes' && $ad_expire_meta >= current_time('mysql', 1) ) $is_ad = true;
if(!isset($is_ad)) $is_ad = false;
// for default list layout
if(!isset($for_slider)) $for_slider = false;

?>

<!-- listing-item -->
<div class="listing-item<?php if(citybook_addons_get_option('listings_grid_layout')=='list'&&$for_slider== false) echo ' list-layout';?>" data-postid="<?php echo get_the_ID(); ?>">
    <article class="geodir-category-listing">
        <?php
        if(has_post_thumbnail( )){ 
        ?>
        <div class="geodir-category-img">
        <?php if(citybook_addons_get_option('enable_img_click') == 'yes'): ?>
            <a href="<?php the_permalink(  );?>" class="listing-thumb-link">
        <?php endif;?>
            <?php the_post_thumbnail('citybook-listing-grid',array('class'=>'respimg') ); ?>
            <div class="overlay"></div>
            <div class="list-post-counter"><?php echo citybook_addons_get_likes_stats(get_the_ID());?></div>
            
            <?php if( get_post_meta( get_the_ID(), P_META_PREFIX.'featured', true ) == '1' ) : ?>
            <div class="listing-featured"><?php _e( 'Featured', 'citybook-add-ons' ); ?></div>
            <?php endif;?>
            
        <?php if(citybook_addons_get_option('enable_img_click') == 'yes'): ?>
            </a>
        <?php endif;?>
        </div>
        <?php } ?>
        <div class="geodir-category-content">
            <?php //if( $settings['show_cats'] == 'yes' ):?>
                <?php
                $cats = get_the_terms(get_the_ID(), 'listing_cat');
                if ( $cats && ! is_wp_error( $cats ) ){
                    echo '<div class="listing-cats-wrap">';
                    foreach( $cats as $key => $cat){

                        echo sprintf( '<a href="%1$s" class="listing-geodir-category">%2$s</a> ',
                            esc_url( get_term_link( $cat->term_id, 'listing_cat' ) ),
                            esc_html( $cat->name )
                        );
                    }
                    echo '</div>';
                }
                // end check cat
                ?>
            <?php //endif;?>
            <?php if( false == citybook_addons_check_package_single_field( 'hide_author_info' ) ):?>
            <div class="listing-avatar">
                <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>"><?php 
                    echo get_avatar(get_the_author_meta('user_email'),'80','https://0.gravatar.com/avatar/ad516503a11cd5ca435acc9bb6523536?s=80', get_the_author_meta( 'display_name' ) );
                ?></a>
                <span class="avatar-tooltip"><?php esc_html_e( 'Added By ',  'citybook-add-ons' );?><strong><?php the_author();?></strong></span>
            </div>
            <?php endif;?>

            <h3 class="entry-title">
                <?php if($is_ad) echo '<span class="item-ad">'.__( 'Ad', 'citybook-add-ons' ).'</span>'; ?>
                <a href="<?php echo esc_url( get_permalink() ) ?>" rel="bookmark">
                    <?php the_title(); ?>
                    <?php if( get_post_meta( get_the_ID(), P_META_PREFIX.'verified', true ) ) echo '<span class="listing-verified tooltipwrap tooltip-center"><i class="fa fa-check"></i><span class="tooltiptext">'.__('Verified','citybook-add-ons').'</span></span>'; ?>
                </a>
            </h3>

            <?php 
            if(citybook_addons_get_option('listing_event_date') == 'yes'): 
            $levent_date = get_post_meta( get_the_ID(), P_META_PREFIX.'levent_date', true );
            $levent_time = get_post_meta( get_the_ID(), P_META_PREFIX.'levent_time', true );
            if($levent_date != ''): ?>
            <div class="card-event-date"><?php echo sprintf( __( 'Will begin on <span>%s</span> at <span>%s</span>', 'citybook-add-ons' ), date_i18n( get_option( 'date_format' ), strtotime( $levent_date.' '.$levent_time ) ), date_i18n( get_option( 'time_format' ), strtotime( $levent_date.' '.$levent_time ) ) ); ?></div>
            <?php 
                endif;
            endif; ?>

            <?php 
            if(citybook_addons_get_option('grid_price') == 'yes'):
                $price_from = get_post_meta( get_the_ID(), P_META_PREFIX.'price_from', true );
                $price_to = get_post_meta( get_the_ID(), P_META_PREFIX.'price_to', true );
                if($price_from != '') :  ?>
                <div class="pricerange fl-wrap">
                <?php 
                    echo '<span class="lprice-from">'.citybook_addons_get_price_formated($price_from).'</span>';
                    if($price_to != '') echo __( ' - ', 'citybook-add-ons' ) . '<span class="lprice-to">'. citybook_addons_get_price_formated($price_to).'</span>';

                ?>
                </div>
                <?php endif; 
            endif; ?>
            <div class="card-excerpt"><?php 
                // the_excerpt();
                citybook_addons_the_excerpt_max_charlength(citybook_addons_get_option('excerpt_length','55'));
                ?></div>
            <div class="geodir-category-options">
                <?php citybook_addons_get_template_part( 'templates-inner/listing-rating');?>
                <?php
                $contact_infos = array(
                    'address' => get_post_meta( get_the_ID(), '_cth_contact_infos_address', true ),
                    'latitude' => get_post_meta( get_the_ID(), '_cth_contact_infos_latitude', true ),
                    'longitude' => get_post_meta( get_the_ID(), '_cth_contact_infos_longitude', true ),
                    // 'phone' => get_post_meta( get_the_ID(), '_cth_contact_infos_phone', true ),
                    // 'email' => get_post_meta( get_the_ID(), '_cth_contact_infos_email', true ),
                    // 'website' => get_post_meta( get_the_ID(), '_cth_contact_infos_website', true ),
                );

                ?>
                <div class="geodir-category-location listing-item-footer">
                    <?php 
                    if(citybook_addons_get_option('grid_wkhour') == 'yes'):
                    $wkhour = citybook_addons_get_working_hours(get_the_ID());
                    ?>
                    <span class="wkhour-status wkhour-<?php echo $wkhour['status']; ?>"><?php echo $wkhour['statusText']; ?></span>
                    <div class="listing-footer-right">
                    <?php else: ?>
                    <div class="listing-footer-right without-status">
                    <?php endif; ?>

                    

                        <?php
                        if($contact_infos['latitude'] && $contact_infos['longitude'] && $contact_infos['address']) : 
                            // https://developers.google.com/maps/documentation/urls/guide#citybook-view-action
                        ?>
                        <a class="item-loc tooltipwrap tooltip-right tooltip-nowrap" href="https://www.google.com/maps/search/?api=1&query=<?php echo $contact_infos['latitude'].','.$contact_infos['longitude'];?>" target="_blank"><i class="fa fa-map-marker" aria-hidden="true"></i> <span class="tooltiptext"><?php echo esc_html( $contact_infos['address'] );?></span></a>
                        <?php 
                        endif;?>
                        
                        <?php 
                        $price_range = get_post_meta( get_the_ID(), P_META_PREFIX.'price_range', true );
                        if( citybook_addons_get_option('grid_price_range') == 'yes' && $price_range != '' && $price_range != 'none'):
                        ?>
                        <span class="price-range tooltipwrap tooltip-right tooltip-nowrap"><?php echo citybook_add_ons_get_currency_symbol(citybook_addons_get_option('currency','USD')) ?><span class="tooltiptext"><?php echo citybook_addons_get_listing_price_range( $price_range ); ?></span></span>
                        <?php endif; ?>

                        <?php 
                        if( citybook_addons_get_option('grid_viewed_count') == 'yes' ):
                        ?>
                        <span class="viewed-count"><i class="fa fa-eye"></i> <?php echo citybook_addons_get_post_views(get_the_ID()); ?></span>
                        <?php endif; ?>

                        <?php if(!is_user_logged_in()): ?>
                        <a href="#" class="save-btn logreg-modal-open tooltipwrap tooltip-right" data-message="<?php esc_attr_e( 'Logging in first to bookmark this listing.', 'citybook-add-ons' ); ?>"><i class="fa fa-bookmark-o"></i><?php //esc_html_e( ' Save ', 'citybook-add-ons' ); ?><span class="tooltiptext"><?php _e( 'Bookmark', 'citybook-add-ons' ); ?></span></a>
                        <?php elseif( citybook_addons_already_bookmarked( get_the_ID() ) ): ?>
                        <a href="javascript:void(0);" class="save-btn tooltipwrap tooltip-right" data-id="<?php the_ID(); ?>"><i class="fa fa-bookmark"></i><?php //esc_html_e( ' Saved ', 'citybook-add-ons' ); ?><span class="tooltiptext"><?php _e( 'Bookmarked', 'citybook-add-ons' ); ?></span></a>
                        <?php else: ?>
                        <a href="#" class="save-btn bookmark-listing-btn tooltipwrap tooltip-right" data-id="<?php the_ID(); ?>"><i class="fa fa-bookmark-o"></i><?php //esc_html_e( ' Save ', 'citybook-add-ons' ); ?><span class="tooltiptext"><?php _e( 'Bookmark', 'citybook-add-ons' ); ?></span></a>
                        <?php endif; ?>
                    </div>
        
                </div>
                
            </div>
        </div>
    </article>
</div>
<!-- listing-item end-->  