<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


?>
<div class="ctb-modal-wrap ctb-modal" id="ctb-listing-claim-modal">
    <div class="ctb-modal-holder">
        <div class="ctb-modal-inner">
            <div class="ctb-modal-close"><i class="fa fa-times"></i></div>
            <h3><?php echo sprintf( __( 'Claim listing: <span class="lauthor-msg-title">%s</span>', 'citybook-add-ons' ), get_the_title() );?></h3>
            <div class="ctb-modal-content">
                <?php do_action( 'citybook-addons-claim-form-before' ); ?>
                <form class="listing-claim-form custom-form" action="#" method="POST">
                    <fieldset>
                        <?php do_action( 'citybook-addons-claim-form' ); ?>
                        <textarea name="claim_message" cols="40" rows="3" placeholder="<?php esc_attr_e( 'Additional information here.', 'citybook-add-ons' ); ?>" required="required"></textarea>
                    </fieldset>
                    <input type="hidden" name="listing_id" value="<?php echo get_the_ID(); ?>" required="required">
                    <button class="btn color-bg" type="submit" id="lclaim-submit"><?php _e( 'Submit', 'citybook-add-ons' ); ?></button>
                </form>
                <?php do_action( 'citybook-addons-claim-form-after' ); ?>
            </div>
            <!-- end modal-content -->
        </div>
    </div>
</div>
<!-- end modal --> 