<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


$dashboard = get_query_var('dashboard');
$dashboard_page_id = citybook_addons_get_option('dashboard_page');

$notifications = get_user_meta( get_current_user_id(), P_META_PREFIX.'notifications', true );
$indicators = array(
    'new_invoice' => 0,
    'order_completed' => 0,
    'listing_publish'   => 0,
    'bookmarked'   => 0,
    'ad_completed'   => 0,
);
if(!empty($notifications) && is_array($notifications)){
    foreach ($notifications as $key => $value) {
        $noti_type = citybook_addons_get_notification_type($key);
        switch ($noti_type) {
            
            case 'new_invoice':
                $indicators['new_invoice'] += 1;
                break;
            case 'order_completed':
                $indicators['order_completed'] += 1;
                break;
            case 'listing_publish':
                $indicators['listing_publish'] += 1;
                break;
            case 'bookmarked':
                $indicators['bookmarked'] += 1;
                break;
            case 'ad_completed':
                $indicators['ad_completed'] += 1;
                break;
            
        }
    }
}
$badges = array();
foreach ($indicators as $key => $value) {
    if($value)
        $badges[$key] = '<span>'.$value.'</span>';
    else 
        $badges[$key] = '';
}

?>
<div class="fixed-bar fl-wrap">
    <?php 
    $current_sub = citybook_addons_get_current_subscription(get_current_user_id());
    if($current_sub && $current_sub['valid']){
        $current_plan = get_the_title( $current_sub['plan_id'] );
    }else{
        if( in_array(citybook_addons_get_user_role(), array('l_customer', 'subscriber') ) ){
            $current_plan = __( 'Customer', 'citybook-add-ons' );
        }else{
            $current_plan = __( 'Free', 'citybook-add-ons' );
        }
    
        
    }
    ?>
    <div class="user-profile-menu-wrap fl-wrap user-current-plan">
        <div class="user-profile-menu">
            <h3><?php _e( 'Your Plan:', 'citybook-add-ons' ); ?></h3>
            <div class="plan-details">
                <?php echo sprintf(__( '<p>You are on <strong>%s</strong>. Use link bellow to view details or upgrade.</p>', 'citybook-add-ons' ), $current_plan ); ?>
                <a href="<?php echo get_permalink( citybook_addons_get_option('packages_page') ); ?>" class="btn color-bg"><?php _e( 'Details', 'citybook-add-ons' ); ?></a>
            </div>

        </div>
    </div>

    <div class="user-profile-menu-wrap fl-wrap">

        <!-- user-profile-menu-->
        <div class="user-profile-menu">
            <h3><?php _e( 'Main', 'citybook-add-ons' );?></h3>
            <ul>
                <li><a href="<?php echo get_the_permalink( $dashboard_page_id );?>"<?php if($dashboard == '') echo '  class="active"';?>><?php _e( '<i class="fa fa-dashboard"></i> Dashboard', 'citybook-add-ons' );?></a></li>
                <li><a href="<?php echo get_the_permalink( $dashboard_page_id ).'?dashboard=profile';?>"<?php if($dashboard == 'profile') echo '  class="active"';?>><?php _e( '<i class="fa fa-user-o"></i> Edit profile', 'citybook-add-ons' );?></a></li>
                <?php if(function_exists('bp_core_get_user_domain')): ?>
                <li><a href="<?php echo bp_core_get_user_domain(get_current_user_id());?>"><?php _e( '<i class="fa fa-user-o"></i> BuddyPress profile', 'citybook-add-ons' );?></a></li>
                <?php endif; ?>
                <?php if( citybook_addons_get_option('db_hide_messages') != 'yes' ): ?>
                    <li><a href="<?php echo get_the_permalink( $dashboard_page_id ).'?dashboard=messages';?>"<?php if($dashboard == 'messages') echo '  class="active"';?>><?php _e( '<i class="fa fa-envelope-o"></i> Messages', 'citybook-add-ons' );?></a></li>
                <?php endif; ?>
                <li><a href="<?php echo get_the_permalink( $dashboard_page_id ).'?dashboard=changepass';?>"<?php if($dashboard == 'changepass') echo '  class="active"';?>><?php _e( '<i class="fa fa-unlock-alt"></i>Change Password', 'citybook-add-ons' );?></a></li>
            </ul>
        </div>
        
        <!-- user-profile-menu end-->
        <!-- user-profile-menu-->
        <div class="user-profile-menu">
            <h3><?php _e( 'Listings', 'citybook-add-ons' );?></h3>
            <ul>
            <?php if(  citybook_addons_current_user_can('view_listings_dashboard') ): ?>
                <li><a href="<?php echo get_the_permalink( $dashboard_page_id ).'?dashboard=listings';?>"<?php if($dashboard == 'listings') echo '  class="active"';?>><?php _e( '<i class="fa fa-th-list"></i> My listings  ', 'citybook-add-ons' );?> <?php echo $badges['listing_publish'] ?></a></li>
                <?php if( citybook_addons_get_option('db_hide_packages') != 'yes' ): ?>
                    <li><a href="<?php echo get_the_permalink( $dashboard_page_id ).'?dashboard=packages';?>"<?php if($dashboard == 'packages') echo '  class="active"';?>><?php _e( '<i class="fa fa-briefcase"></i> Packages ', 'citybook-add-ons' );?> <?php echo $badges['order_completed'] ?></a></li>
                <?php endif; ?>
                <?php if( citybook_addons_get_option('db_hide_ads') != 'yes' ): ?>
                <li><a href="<?php echo get_the_permalink( $dashboard_page_id ).'?dashboard=ads';?>"<?php if($dashboard == 'ads') echo '  class="active"';?>><?php _e( '<i class="fa fa-bullhorn"></i> AD Campaigns ', 'citybook-add-ons' );?> <?php echo $badges['ad_completed'] ?></a></li>
                <?php endif; ?>
                <?php if( citybook_addons_get_option('db_hide_invoices') != 'yes' ): ?>
                    <li><a href="<?php echo get_the_permalink( $dashboard_page_id ).'?dashboard=invoices';?>"<?php if($dashboard == 'invoices') echo '  class="active"';?>><?php _e( '<i class="fa fa-file-text-o"></i> Invoices ', 'citybook-add-ons' );?> <?php echo $badges['new_invoice'] ?></a></li>
                <?php endif; ?>
                <?php if( citybook_addons_get_option('db_hide_bookings') != 'yes' ): ?>
                    <li><a href="<?php echo get_the_permalink( $dashboard_page_id ).'?dashboard=bookings';?>"<?php if($dashboard == 'bookings') echo '  class="active"';?>><?php _e( '<i class="fa fa-calendar-check-o"></i> Bookings ', 'citybook-add-ons' );?></a></li>
                <?php endif; ?>
                <?php if( citybook_addons_get_option('db_hide_bookmarks') != 'yes' ): ?>
                    <li><a href="<?php echo get_the_permalink( $dashboard_page_id ).'?dashboard=bookmarks';?>"<?php if($dashboard == 'bookmarks') echo '  class="active"';?>><?php _e( '<i class="fa fa-heart-o"></i> Bookmarks ', 'citybook-add-ons' );?> <?php echo $badges['bookmarked'] ?></a></li>
                <?php endif; ?>
                <?php if( citybook_addons_get_option('db_hide_reviews') != 'yes' ): ?>
                    <li><a href="<?php echo get_the_permalink( $dashboard_page_id ).'?dashboard=reviews';?>"<?php if($dashboard == 'reviews') echo '  class="active"';?>><?php _e( '<i class="fa fa-comments-o"></i> Reviews ', 'citybook-add-ons' );?></a></li>
                <?php endif; ?>
                <?php if( citybook_addons_get_option('db_hide_adnew') != 'yes' ): ?>
                    <li><a href="<?php echo citybook_addons_get_submit_link();?>"><?php _e( '<i class="fa fa-plus-square-o"></i> Add New', 'citybook-add-ons' );?></a></li>
                <?php endif; ?>
            <?php else : ?>
                <?php if( citybook_addons_get_option('db_hide_bookings') != 'yes' ): ?>
                    <li><a href="<?php echo get_the_permalink( $dashboard_page_id ).'?dashboard=bookings';?>"<?php if($dashboard == 'bookings') echo '  class="active"';?>><?php _e( '<i class="fa fa-calendar-check-o"></i> Bookings ', 'citybook-add-ons' );?></a></li>
                <?php endif; ?>
                <?php if( citybook_addons_get_option('db_hide_bookmarks') != 'yes' ): ?>
                    <li><a href="<?php echo get_the_permalink( $dashboard_page_id ).'?dashboard=bookmarks';?>"<?php if($dashboard == 'bookmarks') echo '  class="active"';?>><?php _e( '<i class="fa fa-heart-o"></i> Bookmarks ', 'citybook-add-ons' );?> <?php echo $badges['bookmarked'] ?></a></li>
                <?php endif; ?>
            <?php endif; ?>
                
            </ul>
        </div>
        <!-- user-profile-menu end-->                                        
        <a href="<?php echo wp_logout_url( citybook_addons_get_current_url() ); ?>" class="log-out-btn"><?php _e( 'Log Out', 'citybook-add-ons' );?></a>

    </div>
</div>