<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



?>
<!-- list-single-header -->
<div class="list-single-header list-single-header-inside fl-wrap">
    <div class="container">
        <div class="list-single-header-item">
            <div class="row">
                <div class="col-md-8">
                    <div class="list-single-header-item-opt fl-wrap">
                        <?php

                        $cats = get_the_terms(get_the_ID(), 'listing_cat');
                        if ( $cats && ! is_wp_error( $cats ) ){
                            echo '<div class="list-single-header-cat fl-wrap">';
                            foreach( $cats as $key => $cat){

                                echo sprintf( '<a href="%1$s" class="listing-cat">%2$s</a> ',
                                    esc_url( get_term_link( $cat->term_id, 'listing_cat' ) ),
                                    esc_html( $cat->name )
                                );
                            }
                            echo '</div>';
                        }
                        // end check cat

                        ?>
                    </div>
                    <h2>
                        <?php the_title( ) ;?>
                        <?php if( get_post_meta( get_the_ID(), P_META_PREFIX.'verified', true ) ) echo '<span class="listing-verified tooltipwrap tooltip-center"><i class="fa fa-check"></i><span class="tooltiptext">'.__('Verified','citybook-add-ons').'</span></span>'; ?>
                        <?php if( false == citybook_addons_check_package_single_field( 'hide_author_info' ) ): ?>
                        <span><?php esc_html_e( ' - Hosted By ', 'citybook-add-ons' );?></span><?php the_author_posts_link( );?> 
                        <?php endif; ?>
                        <?php citybook_addons_edit_listing_link(get_the_ID());?>
                    </h2>
                    <?php 
                    if(citybook_addons_get_option('listing_event_date') == 'yes'): 
                    $levent_date = get_post_meta( get_the_ID(), P_META_PREFIX.'levent_date', true );
                    $levent_time = get_post_meta( get_the_ID(), P_META_PREFIX.'levent_time', true );
                    if($levent_date != ''): ?>
                    <div class="single-event-date"><?php echo sprintf( __( 'Will begin on <span>%s</span> at <span>%s</span>', 'citybook-add-ons' ), date_i18n( get_option( 'date_format' ), strtotime( $levent_date.' '.$levent_time ) ), date_i18n( get_option( 'time_format' ), strtotime( $levent_date.' '.$levent_time ) ) ); ?></div>
                    <?php 
                        endif;
                    endif; ?>

                    <span class="section-separator"></span>
                    <?php citybook_addons_get_template_part( 'templates-inner/listing-rating');?>
                    <div class="list-post-counter single-list-post-counter"><?php echo citybook_addons_get_likes_button(get_the_ID());?></div>
                    <div class="clearfix"></div>

                    <?php //citybook_addons_get_template_part( 'templates-inner/listing-contacts');?>

                </div>
                <div class="col-md-4">
                    <?php citybook_addons_get_template_part( 'templates-inner/listing-share');?>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- list-single-header end -->