<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



?>
<div class="ctb-modal-wrap ctb-modal" id="ctb-view-invoice-modal">
    <div class="ctb-modal-holder">
        <div class="ctb-modal-inner">
            <div class="ctb-modal-close"><i class="fa fa-times"></i></div>
            <h3><?php _e( 'Invoice ', 'citybook-add-ons' );?><span class="lauthor-msg-title"><?php esc_html_e( 'Details', 'citybook-add-ons' ); ?></span></h3>
            <div class="ctb-modal-content">
                
                <div class="invoice-details-holder"></div>
            </div>
            <!-- end modal-content -->
        </div>
        <div class="invoice-loading-icon"><i class="fa fa-spinner fa-pulse fa-3x"></i></div>
    </div>
</div>
<!-- end modal -->
<script type="text/template" id="tmpl-invoice-data">
    <table class="cth-table table-invoice-details">
        <tbody>
            <tr>
                <td class="w40" colspan="2"><?php _e( 'Date', 'citybook-add-ons' ); ?></td>
                <td class="w60 text-bold" colspan="3">{{{data.date}}}</td>
            </tr>
            <tr>
                <td class="w40" colspan="2"><?php _e( 'Subscribed with', 'citybook-add-ons' ); ?></td>
                <td class="w40 text-bold" colspan="3">{{{data.author}}}</td>
            </tr>
            <tr>
                <td class="w40" colspan="2"><?php _e( 'Charged via', 'citybook-add-ons' ); ?></td>
                <td class="w40 text-bold" colspan="3">{{{data.method}}}</td>
            </tr>
            <tr>
                <td class="w40" colspan="2"><?php _e( 'Expiration date', 'citybook-add-ons' ); ?></td>
                <td class="w40 text-bold" colspan="3">{{{data.expire}}}</td>
            </tr>
            <tr>
                <td class="w80" colspan="4"><?php _e( 'Subscription to', 'citybook-add-ons' ); ?> {{{data.plan}}}</td>
                <td class="w20 text-right">{{{data.amount}}}</td>
            </tr>
            <tr>
                <td class="w40 text-right text-bold text-blur" colspan="2"><?php _e( 'Subtotal', 'citybook-add-ons' ); ?></td>
                <td class="w40 text-right" colspan="3">{{{data.amount}}}</td>
            </tr>
            <tr>
                <td class="w40 text-right text-bold text-blur" colspan="2"><?php _e( 'Total', 'citybook-add-ons' ); ?></td>
                <td class="w40 text-right" colspan="3">{{{data.amount}}}</td>
            </tr>
            <tr>
                <td class="w40 text-right text-bold" colspan="2"><?php _e( 'Paid', 'citybook-add-ons' ); ?></td>
                <td class="w60 text-right text-bold" colspan="3">{{{data.amount}}}</td>
            </tr>
        </tbody>
    </table>
    <div class="invoice-footer">
        <div class="invoice-thanks text-blur"><?php _e( 'Thank you!', 'citybook-add-ons' ); ?></div>
        <div class="invoice-sitename"><?php echo get_bloginfo('name') ?></div>
    </div>
</script>

    