<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



?>
<div class="ctb-modal-wrap ctb-modal" id="ctb-reply-msg-modal">
    <div class="ctb-modal-holder">
        <div class="ctb-modal-inner">
            <div class="ctb-modal-close"><i class="fa fa-times"></i></div>
            <h3><?php _e( 'Reply to ', 'citybook-add-ons' );?><span class="lauthor-msg-title"><?php esc_html_e( 'Message', 'citybook-add-ons' ); ?></span></h3>
            <div class="ctb-modal-content">
                
                <form class="author-message-form author-message-dashboard custom-form" action="#" method="post">
                    
                    <fieldset>
                        <textarea name="lmsg_message" cols="40" rows="3" placeholder="<?php esc_attr_e( 'Your message:', 'citybook-add-ons' ); ?>"></textarea>
                    </fieldset>

                    <input type="hidden" name="authid" value="" required="required">
                    <input class="btn color-bg" type="submit" value="<?php esc_attr_e( 'Submit', 'citybook-add-ons' ); ?>">

                </form>
            </div>
            <!-- end modal-content -->
        </div>
    </div>
</div>
<!-- end modal --> 

<script type="text/template" id="tmpl-chat">
    <?php citybook_addons_get_template_part('templates-inner/chat');?>
</script>
<script type="text/template" id="tmpl-chat-reply">
    <?php citybook_addons_get_template_part('templates-inner/chat-reply');?>
</script>
<script type="text/template" id="tmpl-replies-lmore">
    <div class="chat-replies-lmore">
        <span></span>
        <span></span>
        <span></span>
    </div>
</script>
<script type="text/template" id="tmpl-chat-typing">
    <div class="typing-indicator">
        <span></span>
        <span></span>
        <span></span>
    </div>
</script>
<script type="text/template" id="tmpl-chat-no-replies">
    <p class="no-replies"><?php _e( 'No replies yet', 'citybook-add-ons' ); ?></p>
</script>

