<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


$checkout_page_id = citybook_addons_get_option('checkout_page');
?>
<div class="ctb-modal-wrap ctb-modal ctb-modal-lg" id="ctb-new-campaign-modal">
    <div class="ctb-modal-holder">
        <div class="ctb-modal-inner">
            <div class="ctb-modal-close"><i class="fa fa-times"></i></div>
            <h3><?php _e( 'New ', 'citybook-add-ons' );?><span class="lauthor-msg-title"><?php esc_html_e( 'AD Campaign', 'citybook-add-ons' ); ?></span></h3>
            <div class="ctb-modal-content">
                
                <form class="new-ad-canpaign-form custom-form" action="<?php echo esc_url(get_permalink($checkout_page_id));?>" method="post">
                    
                    <fieldset>
                        <?php 
                        // listing meta search
                        $meta_queries = array();
                        // check for membership expired
                        // if(citybook_addons_get_option('membership_package_expired_hide') == 'yes'){
                        //     $meta_queries['relation'] = 'OR';
                        //     $meta_queries[] = array(
                        //         'key'     => P_META_PREFIX.'expire_date',
                        //         'value'   => current_time('mysql', 1),
                        //         'compare' => '>=',
                        //         'type'    => 'DATETIME',
                        //     );
                        //     $meta_queries[] = array(
                        //         'key'     => P_META_PREFIX.'expire_date',
                        //         'value'   => 'NEVER',
                        //         'compare' => '=',
                        //     );

                        // }
                        $current_user = wp_get_current_user();
                        $listing_args = array(
                            'post_type'         => 'listing',
                            'author'            =>  $current_user->ID,
                            'post_status'       => 'publish',
                            'posts_per_page'    => -1,
                        );

                        if(!empty($meta_queries)) $listing_args['meta_query'] = $meta_queries;

                        $listing_posts = get_posts($listing_args);
                        if(empty($listing_posts)) echo '<div class="ad-no-listing-msg">'.__( 'You have no Published listings yet!', 'citybook-add-ons' ).'</div>';
                        ?>
                        <label for="ad-listing-select"><?php _e( 'Select a listing', 'citybook-add-ons' ); ?></label>
                        <select name="ad-listing" id="ad-listing-select" class="chosen-select" required="required"<?php if(empty($listing_posts)) echo ' disabled="disabled"'; ?>>
                            <option value=""><?php esc_html_e( 'Select a listing',  'citybook-add-ons' );?></option>
                            <?php 
                            if(!empty($listing_posts)){
                                foreach ($listing_posts as $listing) {
                                    echo '<option value="'.$listing->ID.'">'.$listing->post_title.'</option>';
                                }
                            }
                            ?>
                        </select>
                        <?php 
                        $ad_packages = get_terms( array(
                            'taxonomy' => 'cthads_package',
                            'hide_empty' => false,
                            'meta_key'  => P_META_PREFIX.'ad_price',
                            'orderby'   => 'meta_value_num',
                            // 'order'     => 'ASC',
                            'meta_query' => array(
                                // 'relation' => 'OR',
                                array(
                                    'key' => P_META_PREFIX.'is_active',
                                    'value' => 'yes',
                                    // 'compare' => 'LIKE',
                                ),
                                // array(
                                //     'key' => 'bar_key',
                                // ),
                            ),



                        ) );
                         
                        if ( ! empty( $ad_packages ) && ! is_wp_error( $ad_packages ) ) { ?>
                        <div class="ad-packages">
                        <?php
                            foreach ($ad_packages as $package) {
                                $icon_img = get_term_meta( $package->term_id, P_META_PREFIX.'icon_img', true );
                            ?>
                            <div class="ad-package-item ad-package-<?php echo $package->slug;?>">
                                    <label for="ad-package-<?php echo $package->slug;?>">
                                        <div class="ad-package-title"><?php echo $package->name; ?></div>
                                        <?php if(isset($icon_img['id'])) echo wp_get_attachment_image( $icon_img['id'] ); ?>
                                        <input type="radio" name="ad-package" id="ad-package-<?php echo $package->slug;?>" value="<?php echo $package->term_id;?>" required="required">
                                        <span class="ad-package-desc"><?php //echo $data['desc'];?></span>
                                        <div class="ad-package-price">
                                            <?php 
                                            echo sprintf(__( '<span class="ad-price">%s</span> <span class="ad-period">%s</span>', 'citybook-add-ons' ), citybook_addons_get_price_formated(get_term_meta( $package->term_id, P_META_PREFIX.'ad_price', true )), citybook_add_ons_get_plan_period_text( get_term_meta( $package->term_id, P_META_PREFIX.'ad_interval', true ), get_term_meta( $package->term_id, P_META_PREFIX.'ad_period', true ) ) );
                                            ?>
                                        </div>
                                    </label>
                                    <?php 
                                    $ad_positions = get_term_meta( $package->term_id, P_META_PREFIX.'ad_type', true );
                                    if(!empty($ad_positions)){
                                        echo '<div class="ad-pos-desc">'. __( 'Positions:', 'citybook-add-ons' );
                                        foreach ((array)$ad_positions as $pos) {
                                            echo '<div class="ad-pos-item">'.citybook_addons_listing_ad_positions($pos). '</div>';
                                        }
                                        echo '</div>';
                                    }
                                    ?>
                                </div>
                                <!-- end <?php echo $package->slug;?> -->
                            <?php
                            } ?>
                        </div>
                        <?php
                        } ?>
                    </fieldset>
                    <input class="btn color-bg" id="new-ad-submit" name="new-ad-submit" type="submit" value="<?php esc_attr_e( 'Submit', 'citybook-add-ons' ); ?>">

                </form>
            </div>
            <!-- end modal-content -->
        </div>
    </div>
</div>
<!-- end modal --> 