<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



$listing_cats_arr = citybook_addons_get_listing_categories(); 

wp_localize_script( 'citybook-addons', '_citybook_submit', array(
    'id'        => 0,
    'mode'      => 'submit',
    'feas'      => array(),
    'addfeas'   => array(),
) );
?>
<!--section --> 
<section id="sec1">
    <!-- container -->
    <div class="container">
        <!-- profile-edit-wrap -->
        <div class="profile-edit-wrap">
            <div class="profile-edit-page-header">
                <h2><?php the_title();?></h2>
                <?php citybook_addons_breadcrumbs();?>
            </div>
            <div class="row">

                <div class="col-md-12">
                    <div id="submit-listing-view">
                    <!-- #submit-listing-view -->
                        <div id="submit-listing-message"></div>
                        <!-- #listing-submission-form-->
                        <form id="listing-submission-form" action="#">

                            <!-- profile-edit-container--> 
                            <div class="profile-edit-container add-list-container">
                                <!-- <div class="profile-edit-header fl-wrap">
                                    <h4><?php _e( 'User Login', 'citybook-add-ons' );?></h4>
                                </div> -->
                                <?php 
                                $current_user = wp_get_current_user();
                                if ( 0 == $current_user->ID ) {
                                    ?>
                                <div class="account-box">
                                    <span><?php _e( 'If you don\'t have an account, you can create one by entering your email address bellow. <br>Account details will be confirmed via email.', 'citybook-add-ons' );?></span>
                                    <a href="" class="btn color-bg logreg-modal-open" data-message="<?php esc_attr_e( 'Sign in to submit a listing.', 'citybook-add-ons' ); ?>"><?php _e( 'Sign In', 'citybook-add-ons' );?></a>
                                </div>
                                <div class="custom-form">
                                    <label><?php _e( 'Username', 'citybook-add-ons' );?><i class="fa fa-user"></i></label>
                                    <input type="text" class="has-icon" name="user_login" placeholder="<?php esc_attr_e( 'Enter your username', 'citybook-add-ons' );?>" value="" required data-msg="<?php esc_attr_e( 'Please enter your username.', 'citybook-add-ons' ); ?>"/>
                                    <label><?php _e( 'Your Email ', 'citybook-add-ons' );?><i class="fa fa-envelope"></i></label>
                                    <input type="email" class="has-icon" name="user_email" placeholder="<?php esc_attr_e( 'Enter your email address', 'citybook-add-ons' );?>" value="" required data-msg="<?php esc_attr_e( 'Please enter your email address.', 'citybook-add-ons' ); ?>"/>
                                </div>
                                <?php
                                }else{
                                    ?>
                                <div class="account-box">
                                    <span><?php echo sprintf(__('You are currently signed in as <strong>%s</strong>, <a href="%s">Sign out</a> or continue below.','citybook-add-ons'), $current_user->display_name, wp_logout_url( citybook_addons_get_current_url() ) ) ;?></span>
                                </div>
                                <?php
                                }
                                ?>
                                
                            </div>
                            <!-- profile-edit-container end--> 

                            <!-- profile-edit-container--> 
                            <div class="profile-edit-container add-list-container">
                                <div class="profile-edit-header fl-wrap">
                                    <h4><?php _e( 'Basic Information', 'citybook-add-ons' );?></h4>
                                </div>
                                <div class="custom-form">
                                    <label><?php _e( 'Listing Title <i class="fa fa-briefcase"></i>', 'citybook-add-ons' );?></label>
                                    <input type="text" class="has-icon" name="title" placeholder="<?php esc_attr_e( 'Name of your business', 'citybook-add-ons' ); ?>" value="" required data-msg="<?php esc_attr_e( 'Please enter listing title.', 'citybook-add-ons' ); ?>"/>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <label><?php _e( 'Category', 'citybook-add-ons' );?></label>
                                            <select id="listing_cats" name="listing_cats[]" data-placeholder="<?php esc_attr_e( 'Select Category', 'citybook-add-ons' );?>" required<?php if( citybook_addons_get_option('multiple_cat') == 'yes' ) echo ' multiple="multiple"'; ?> data-msg="<?php esc_attr_e( 'Please select at least one category.', 'citybook-add-ons' ); ?>">
                                                <option value=""><?php _e( 'Select Category', 'citybook-add-ons' );?></option>
                                                <?php 
                                                    if(count($listing_cats_arr)){
                                                        foreach ($listing_cats_arr as $cat) {
                                                            
                                                                echo '<option value="'.$cat['id'].'">'.str_repeat('-', $cat['level']).' '.$cat['name'].'</option>';
                                                          
                                                            
                                                        }
                                                    }
                                                ?>
                                            </select>
                                        </div>
                                        <?php if( false == citybook_addons_check_package_field('hide_tags') ): ?>   
                                        <div class="col-md-6">
                                            <label><?php _e( 'Keywords <i class="fa fa-key"></i>', 'citybook-add-ons' );?></label>
                                            <input class="has-icon" type="text" id="listing_tags" name="listing_tags" placeholder="<?php esc_attr_e( 'Maximum 15, should be separated by commas', 'citybook-add-ons' );?>" value=""/>
                                        </div>
                                        <?php endif; ?>   


                                        <div class="col-md-12 listing-features-view loading-feas">
                                            <h4 class="field-head"><?php esc_html_e( 'Features', 'citybook-add-ons' );?></h4>
                                            <div class="listing-features"></div>
                                            <h4 class="field-head"><?php esc_html_e( 'Additional Info', 'citybook-add-ons' );?></h4>
                                            <div class="listing-additional-features"></div>
                                        </div>

                                        <!-- <div class="col-md-12 listing-features-view" id="listing-features-view"></div> -->

                                        

                                    </div>
                                </div>
                            </div>
                            <!-- profile-edit-container end--> 
                            <!-- profile-edit-container--> 
                            <div class="profile-edit-container add-list-container">
                                <div class="profile-edit-header fl-wrap">
                                    <h4><?php _e( 'Location /  Contacts', 'citybook-add-ons' );?></h4>
                                </div>
                                <div class="custom-form">
                                    <?php 
                                    citybook_addons_get_template_part('template-parts/location-contacts');
                                    ?>

                                </div>
                            </div>
                            <!-- profile-edit-container end--> 
                            <?php if( false == citybook_addons_check_package_field('hide_price_opt') ): ?>   
                            <!-- profile-edit-container--> 
                            <div class="profile-edit-container add-list-container">
                                <div class="profile-edit-header fl-wrap">
                                    <h4><?php _e( 'Price Options', 'citybook-add-ons' );?></h4>
                                </div>
                                <div class="custom-form">
                                    
                                    <div class="row">
                                        <div class="col-md-4">
                                            
                                            <label for="price_range"><?php esc_html_e( 'Price Range', 'citybook-add-ons' );?></label>
                                            <select id="price_range" class="fwcl chosen-select" name="price_range">
                                                <?php 
                                                    foreach (citybook_addons_get_listing_price_range() as $range => $title) {
                                                            echo '<option value="'.$range.'">'.$title.'</option>';
                                                    }
                                                ?>
                                            </select>
                                        </div>
                                        <div class="col-md-4">
                                            <label for="price_from"><?php esc_html_e( 'Price From', 'citybook-add-ons' );?></label>
                                            <input type="text" id="price_from" name="price_from">
                                        </div>
                                        <div class="col-md-4">
                                            <label for="price_to"><?php esc_html_e( 'Price To', 'citybook-add-ons' );?></label>
                                            <input type="text" id="price_to" name="price_to">
                                        </div>
                                    </div>


                                </div>
                            </div>
                            <!-- profile-edit-container end--> 

                        <?php endif; ?>

                            <?php do_action( 'citybook-addons-submit-addfields', 0, false ); ?>

                            <!-- profile-edit-container--> 
                            <div class="profile-edit-container add-list-container">
                                <div class="profile-edit-header fl-wrap">
                                    <h4><?php _e( 'Media', 'citybook-add-ons' );?></h4>
                                </div>
                                <div class="custom-form">
                                    <label for=""><?php _e( 'Featured Image', 'citybook-add-ons' );?></label>
                                    <?php 
                                    citybook_addons_get_template_part( 'template-parts/images-upload', false, array( 'is_single'=>true, 'name'=>'featured' ) );
                                    ?>

                                    <?php 
                                    if( false == citybook_addons_check_package_field('hide_head_background') || false == citybook_addons_check_package_field('hide_head_carousel') || false == citybook_addons_check_package_field('hide_head_video') ):

                                        $lcol_cls = 'col-md-8';
                                        $rcol_cls = 'col-md-4';
                                        $incol_cls = 'col-md-6';
                                        if( citybook_addons_check_package_field('hide_head_video') ){
                                            $lcol_cls = 'col-md-12';
                                            if( citybook_addons_check_package_field('hide_head_background') || citybook_addons_check_package_field('hide_head_carousel') ){
                                                $incol_cls = 'col-md-12';
                                            }
                                        }else{
                                            if( citybook_addons_check_package_field('hide_head_background') && citybook_addons_check_package_field('hide_head_carousel') ){
                                                $rcol_cls = 'col-md-12';
                                            }elseif( citybook_addons_check_package_field('hide_head_background') || citybook_addons_check_package_field('hide_head_carousel') ){
                                                $lcol_cls = 'col-md-6';
                                                $rcol_cls = 'col-md-6';
                                                $incol_cls = 'col-md-12';
                                            }
                                        }

                                    ?>

                                    <label for=""><?php _e( 'Header Media', 'citybook-add-ons' );?></label>
                                    <div class="row">
                                        <?php 
                                        if( false == citybook_addons_check_package_field('hide_head_background') || false == citybook_addons_check_package_field('hide_head_carousel') ):
                                        ?>
                                        <!--col --> 
                                        <div class="<?php echo esc_attr( $lcol_cls ); ?>">
                                        <?php // endif; ?>
                                            <div class="row">
                                                <?php 
                                                if( false == citybook_addons_check_package_field('hide_head_background') ):
                                                ?>
                                                <!--col --> 
                                                <div class="<?php echo esc_attr( $incol_cls ); ?>">
                                                    <?php 
                                                    citybook_addons_get_template_part( 'template-parts/radio-head', false, array( 'name'=>'headertype', 'value'=> 'bgimage', 'checked' => 'bgimage', 'label' => __( 'Background Image', 'citybook-add-ons' ) ) );
                                                    ?>
                                                    
                                                </div>
                                                <!--col-md-6 end--> 
                                                <?php endif; ?>
                                                <?php 
                                                if( false == citybook_addons_check_package_field('hide_head_carousel') ):
                                                ?>
                                                <!--col --> 
                                                <div class="<?php echo esc_attr( $incol_cls ); ?>">
                                                    <?php 
                                                    citybook_addons_get_template_part( 'template-parts/radio-head', false, array( 'name'=>'headertype', 'value'=> 'carousel', 'checked' => 'bgimage', 'label' => __( 'Carousel', 'citybook-add-ons' ) ) );
                                                    ?>
                                                    
                                                </div>
                                                <!--col-md-6 end--> 
                                                <?php endif; ?>
                                            </div>

                                            <?php 
                                            citybook_addons_get_template_part( 'template-parts/images-upload', false, array( 'is_single'=>false, 'name'=>'headerimgs[]' ) );
                                            ?>

                                        </div>
                                        <!--col-md-8 end --> 
                                        <?php endif; ?>
                                        
                                        <?php 
                                        if( false == citybook_addons_check_package_field('hide_head_video') ):
                                        ?>
                                        <!--col --> 
                                        <div class="<?php echo esc_attr( $rcol_cls ); ?>">
                                            <?php 
                                            citybook_addons_get_template_part( 'template-parts/radio-head', false, array( 'name'=>'headertype', 'value'=> 'bgvideo', 'checked' => 'bgimage', 'label' => __( 'Video Background', 'citybook-add-ons' ) ) );
                                            ?>
                                            <div class="add-list-media-wrap">
                                                <label><?php _e( 'Youtube Video ID  <i class="fa fa-youtube"></i>', 'citybook-add-ons' );?></label>
                                                <input class="has-icon" name="headerbg_youtube" type="text" placeholder="<?php esc_html_e( 'Ex: Hg5iNVSp2z8', 'citybook-add-ons' ); ?>" value=""/> 

                                                <label><?php _e( 'Or Vimeo Video ID <i class="fa fa-vimeo"></i>', 'citybook-add-ons' );?></label>
                                                <input class="has-icon" name="headerbg_vimeo" type="text" placeholder="<?php esc_html_e( 'Ex: 97871257', 'citybook-add-ons' ); ?>" value=""/> 

                                                
                                            </div>
                                        </div>
                                        <!--col-md-4 end-->   
                                        <?php endif; // end hide background video ?>                                                
                                    </div>
                                    <?php endif; // end hide all header media ?>
                                </div>
                            </div>
                            <!-- profile-edit-container end-->                                         
                            <!-- profile-edit-container--> 
                            <div class="profile-edit-container add-list-container">
                                <div class="profile-edit-header fl-wrap">
                                    <h4><?php _e( 'Detailed Information', 'citybook-add-ons' );?></h4>
                                </div>
                                <div class="custom-form-editor">
                                    <label><?php _e( 'Description', 'citybook-add-ons' );?></label>
                                    <?php 
                                    // https://codex.wordpress.org/Function_Reference/wp_editor
                                    wp_editor( '', 'listing_content', array('media_buttons'=>false,'textarea_rows'=>10) ); 
                                    ?>
                                </div>
                                <div class="custom-form">
                                    <label><?php _e( 'Custom Excerpt', 'citybook-add-ons' );?></label>
                                    <textarea name="post_excerpt" cols="30" rows="3"></textarea>
                                </div>
                            </div>
                            <!-- profile-edit-container end-->
                            <?php 
                            if( false == citybook_addons_check_package_field('hide_content_video') || false == citybook_addons_check_package_field('hide_content_gallery') || false == citybook_addons_check_package_field('hide_content_slider') || false == citybook_addons_check_package_field('hide_faqs_opt') ):

                            ?>                                 
                            <!-- profile-edit-container--> 
                            <div class="profile-edit-container add-list-container">
                                <?php 
                                if( false == citybook_addons_check_package_field('hide_content_video') || false == citybook_addons_check_package_field('hide_content_gallery') || false == citybook_addons_check_package_field('hide_content_slider') ):

                                ?>

                                <div class="profile-edit-header fl-wrap">
                                    <h4><?php _e( 'Content Widgets', 'citybook-add-ons' );?></h4>
                                </div>
                                <div class="custom-form">
                                    
                                    <div class="submit-widgets-wrap">
                                        <?php if( false == citybook_addons_check_package_field('hide_content_video') ): ?>
                                        <!-- act-widget--> 
                                        <div class="act-widget fl-wrap">
                                            <div class="act-widget-header">
                                                <h4><?php _e( 'Promo video', 'citybook-add-ons' );?></h4>
                                            </div>
                                            <?php 
                                            citybook_addons_get_template_part( 'template-parts/images-upload', false, array( 'is_single'=>true, 'name'=>'promo_bg' ) );
                                            ?>
                                            <div class="add-list-media-wrap">
                                                
                                                <label><?php _e( 'Video URL :  <i class="fa fa-video-camera"></i>', 'citybook-add-ons' );?></label>
                                                <input class="has-icon" name="promovideo_url" type="text" placeholder="https://www.youtube.com/" value=""/>   
                                            </div>
                                        </div>
                                        <!-- act-widget end-->
                                        <?php endif; ?>
                                        <?php if( false == citybook_addons_check_package_field('hide_content_gallery') ): ?>
                                        <!-- act-widget--> 
                                        <div class="act-widget fl-wrap">
                                            <div class="act-widget-header">
                                                <h4><?php _e( 'Gallery Thumbnails', 'citybook-add-ons' );?></h4>
                                            </div>
                                            <?php 
                                            citybook_addons_get_template_part( 'template-parts/images-upload', false, array( 'name'=>'gallery_imgs[]' ) );
                                            ?>
                                            
                                        </div>
                                        <!-- act-widget end-->
                                        <?php endif; ?>
                                        <?php if( false == citybook_addons_check_package_field('hide_content_slider') ): ?>
                                        <!-- act-widget--> 
                                        <div class="act-widget fl-wrap">
                                            <div class="act-widget-header">
                                                <h4><?php _e( 'Slider', 'citybook-add-ons' );?></h4>
                                            </div>
                                            <?php 
                                            citybook_addons_get_template_part( 'template-parts/images-upload', false, array( 'name'=>'slider_imgs[]' ) );
                                            ?>
                            
                                        </div>
                                        <!-- act-widget end-->
                                        <?php endif; ?>
                                    </div>
                                    <!-- submit-widgets-wrap end -->
                                
                                </div>
                                <?php endif; // end all content widgets ?>

                                <?php if( false == citybook_addons_check_package_field('hide_faqs_opt') ): ?>  
                                <div class="custom-form">
                                    <div class="list-faqs-wrap">
                                        <label for=""><?php esc_html_e( 'Frequently Asked Questions', 'citybook-add-ons' ); ?></label>
                                        <div class="repeater-fields-wrap"  data-tmpl="tmpl-faq">
                                            <div class="repeater-fields"></div>
                                            <button class="btn addfield" type="button"><?php  esc_html_e( 'Add FAQ','citybook-add-ons' );?></button>
                                        </div>
                                    </div>
                                    <!-- list-faqs-wrap end -->
                                </div>
                                <?php endif; ?>


                            </div>
                            <!-- profile-edit-container end-->
                            <?php endif; // end all content widgets - faqs ?>

                            <?php if( false ==citybook_addons_check_package_field('hide_counter_opt') || false == citybook_addons_check_package_field('hide_workinghours_opt') ): ?>                            
                            <!-- profile-edit-container--> 
                            <div class="profile-edit-container add-list-container">
                                <div class="profile-edit-header fl-wrap">
                                    <h4><?php _e( 'Sidebar Widgets', 'citybook-add-ons' );?></h4>
                                </div>
                                <div class="custom-form">
                                    
                                    <?php if( false == citybook_addons_check_package_field('hide_counter_opt') ): ?>
                                    <!-- act-widget--> 
                                    <div class="act-widget fl-wrap">
                                        <div class="act-widget-header">
                                            <h4><?php _e( 'Event Counter', 'citybook-add-ons' );?></h4>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <label><?php _e( 'Event Date <i class="fa fa-calendar-o"></i>', 'citybook-add-ons' );?></label>
                                                <div class="dtpicker-wrap fl-wrap">
                                                    <input class="datepicker has-icon" data-max-year="2050" data-min-year="2016"  data-large-mode="true" data-large-default="true" data-format="Y-m-d" data-init-set="false" name="levent_date" type="text" placeholder="<?php esc_html_e( 'Date Format : 2019-09-20', 'citybook-add-ons' ); ?>" value=""/>
                                                    <span class="remove-date-time"><i class="fa fa-trash"></i></span>
                                                </div>
                                                    
                                            </div>
                                            <div class="col-md-6">
                                                <label><?php _e( 'Event Time<i class="fa fa-clock-o"></i>', 'citybook-add-ons' );?></label>
                                                <div class="dtpicker-wrap fl-wrap">
                                                    <input class="timepicker has-icon" name="levent_time" type="text" placeholder="<?php esc_html_e( 'Time Format : 12:00:00', 'citybook-add-ons' ); ?>" value=""/>
                                                    <span class="remove-date-time"><i class="fa fa-trash"></i></span>
                                                </div>
                                                    
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6">
                                                <label><?php _e( 'Event End Date <i class="fa fa-calendar-o"></i>', 'citybook-add-ons' );?></label>
                                                <div class="dtpicker-wrap fl-wrap">
                                                    <input class="datepicker has-icon" data-max-year="2050" data-min-year="2016" data-large-mode="true" data-large-default="true" data-format="Y-m-d" data-init-set="false" name="levent_end_date" type="text" placeholder="<?php esc_html_e( 'Date Format : 2019-09-20', 'citybook-add-ons' ); ?>" value=""/>
                                                    <span class="remove-date-time"><i class="fa fa-trash"></i></span>
                                                </div>
                                                    
                                            </div>
                                            <div class="col-md-6">
                                                <label><?php _e( 'Event End Time<i class="fa fa-clock-o"></i>', 'citybook-add-ons' );?></label>
                                                <div class="dtpicker-wrap fl-wrap">
                                                    <input class="timepicker has-icon" name="levent_end_time" type="text" placeholder="<?php esc_html_e( 'Time Format : 12:00:00', 'citybook-add-ons' ); ?>" value=""/>
                                                    <span class="remove-date-time"><i class="fa fa-trash"></i></span>
                                                </div>
                                                    
                                            </div>
                                        </div>
                                                        
                                    </div>
                                    <!-- act-widget end-->  
                                    <?php endif; ?>
                                    
                                    <?php if( false == citybook_addons_check_package_field('hide_workinghours_opt') ): ?>                                                
                                    <!-- act-widget--> 
                                    <div class="act-widget fl-wrap">
                                        <div class="act-widget-header">
                                            <h4><?php _e( 'Working Hours', 'citybook-add-ons' );?></h4>
                                        </div>

                                        <?php 
                                        citybook_addons_get_template_part('template-parts/working-hours');
                                        ?>

           
                                    </div>
                                    <!-- act-widget end--> 
                                    <?php endif; ?>
                                     


                                </div>
                            </div>
                            <!-- profile-edit-container end-->   
                            <?php endif; // end sidebar widget options ?>

                            <?php do_action( 'citybook-addons-submit-widget-addfields', 0, false ); ?>  

                            <!-- profile-edit-container--> 
                            <div class="profile-edit-container mt-30">
                                <?php if( false == citybook_addons_check_package_field('hide_socials_opt') ): ?> 
                                <div class="profile-edit-header fl-wrap">
                                    <h4><?php _e( 'Socials', 'citybook-add-ons' );?></h4>
                                </div>

                                <div class="custom-form">
                                    <div class="repeater-fields-wrap"  data-tmpl="tmpl-user-social">
                                        <div class="repeater-fields"></div>
                                        <button class="btn addfield" type="button"><?php  esc_html_e( 'Add Social','citybook-add-ons' );?></button>
                                    </div>
                                </div>
                                <?php endif; ?>

                                <?php citybook_addons_display_recaptcha('submitCaptcha'); ?>

                                <div class="custom-form">
                                    <button type="submit" id="submit-listing-btn" value="1" class="btn big-btn color-bg flat-btn"><?php _e( 'Save Changes ', 'citybook-add-ons' );?> <i class="fa fa-angle-right"></i></button>
                                </div>
                                
                            </div>
                            <!-- profile-edit-container end--> 

                            <!-- <input type="submit" value="Submit form">  -->

                        </form>
                        <!-- #listing-submission-form end--> 
                        
                    </div>
                    <!-- #submit-listing-view -->
                </div>
            </div>
        </div>
        <!--profile-edit-wrap end -->
    </div>
    <!--container end -->
</section>
<!-- section end -->    
<div class="limit-box fl-wrap"></div>

<?php //include CITYBOOK_ADD_ONS_DIR . 'shortcodes/tmpls.php';

citybook_addons_get_template_part('shortcodes/tmpls');
// template for social
citybook_addons_get_template_part('shortcodes/tmpls-dashboard');

?>
