<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if(isset($_POST['change_plan']) && isset($_POST['listing_id']) && isset($_POST['plan_id'])){
    $current_user = wp_get_current_user(); 

    $listing_post = get_post($_POST['listing_id']);
    // display none on incorrect listing or not authorize listing item
    if(null == $listing_post || $listing_post->post_author != $current_user->ID) return;

    // plan post
    $plan_post = get_post($_POST['plan_id']);
    // display none on incorrect plan
    if(null == $plan_post ) return;

    $prices = citybook_addons_get_plan_prices($plan_post->ID);
}else{
    return;
}

?>
<!--section --> 
<section>
    <!-- container -->
    <div class="container">
        <!-- profile-edit-wrap -->
        <div class="profile-edit-wrap">
            <div class="profile-edit-page-header">
                <h2><?php the_title();?></h2>
                <?php citybook_addons_breadcrumbs();?>
            </div>
            <div class="row">

                <div class="col-md-12">
                    <form autocomplete="off" class="listing-payment-form row" id="listing-payment-form" action="<?php echo esc_url( get_the_permalink() ); ?>" method="post" name="listing-payment-form">
                        <div class="col-md-8 payment-details">
                            <div class="payment-details-wrap">
                                <h4><?php esc_html_e( 'Listing Details', 'citybook-add-ons' ); ?></h4>
                                
                                <div class="row">
                                    
                                    <div class="listing-thumb col-sm-3">
                                        <?php 
                                        if(has_post_thumbnail($listing_post)) echo get_the_post_thumbnail( $listing_post, 'thumbnail' ); 
                                        ?>
                                    </div>
                                    <div class="listing-details col-sm-9">
                                        <h4><?php echo $listing_post->post_title;?></h4>
                                        <div class="listing-details-inner">
                                            <div class="listing-details-date">
                                                <h4>Date</h4>
                                                <?php echo get_the_date( get_option( 'date_format' ), $listing_post->ID ); ?>
                                            </div>
                                            <div class="listing-details-cats">
                                                <h4>Categories</h4>
                                                <?php
                                                $listing_cats = get_the_terms($listing_post->ID, 'listing_cat');
                                                if ( $listing_cats && ! is_wp_error( $listing_cats ) ){
                                                    // echo '<div class="list-single-header-cat fl-wrap">';
                                                    foreach( $listing_cats as $key => $cat){

                                                        echo sprintf( '<a href="%1$s" class="listing-cat">%2$s</a> ',
                                                            esc_url( get_term_link( $cat->term_id, 'listing_cat' ) ),
                                                            esc_html( $cat->name )
                                                        );
                                                    }
                                                    // echo '</div>';
                                                }
                                                // end check cat
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                    

                                </div>

                                <input type="hidden" name="listing-id" value="<?php echo esc_attr( $listing_post->ID );?>">
                                <input type="hidden" name="plan-id" value="<?php echo esc_attr( $plan_post->ID );?>">
                                
                            </div>
                            <div class="payment-total-wrap">
                                <table>
                                    <thead>
                                        <tr>
                                            <th><?php esc_html_e( 'Plan', 'citybook-add-ons' ); ?></th>
                                            <th><?php esc_html_e( 'Total', 'citybook-add-ons' ); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td><?php echo $plan_post->post_title;?></td>
                                            <td><?php echo citybook_addons_get_price_formated($prices['price']); ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php esc_html_e( 'Tax (VAT)', 'citybook-add-ons' ); ?></td>
                                            <td><?php echo citybook_addons_get_price_formated($prices['tax']); ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php esc_html_e( 'Total', 'citybook-add-ons' ); ?></td>
                                            <td><?php echo citybook_addons_get_price_formated($prices['total']); ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                                
                            </div>  
                            <div class="process-checkout-wrap">
                                <input class="btn color-bg" type="submit" id="lcheckout_btn" name="listing_checkout" value="<?php esc_attr_e( 'Place Order', 'citybook-add-ons' ); ?>">
                                <?php wp_nonce_field( 'listing-checkout', '_wpnonce', true, true ); ?>
                            </div>
                        </div>
                        <!-- .payment-details end -->
                        <div class="col-md-4 payment-methods">
                            <div class="payment-methods-wrap custom-form">
                                <h4><?php esc_html_e( 'Payment Method', 'citybook-add-ons' ); ?></h4>
                                <?php 
                                $idx = 0;
                                foreach (citybook_addons_get_payment_methods() as $method => $data) {
                                ?>
                                <div class="payment-method-item payment-method-<?php echo $method;?>">
                                    <label for="payment-<?php echo $method;?>">
                                        <input type="radio" name="payment-method" id="payment-<?php echo $method;?>" data-btn="<?php echo $data['checkout_text'];?>" value="<?php echo $method;?>" required="required" <?php //if($idx == 0) echo ' checked="checked"'; ?>>
                                        <img src="<?php echo $data['icon'];?>" alt="<?php echo $data['title'];?>">
                                        <span class="payment-desc"><?php echo $data['desc'];?></span>
                                    </label>
                                </div>
                                <!-- end <?php echo $method;?> -->
                                <?php
                                $idx++;
                                } ?>
                                
                            </div>
                        </div>
                        <!-- .payment-methods end -->
                    </form>
                    
                </div>
                <!-- end col -->

            </div>
        </div>
        <!--profile-edit-wrap end -->
    </div>
    <!--container end -->
</section>
<!-- section end -->
<div class="limit-box fl-wrap"></div>

